# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

ECM_TEST="forceoptional"
KDE_ORG_CATEGORY="kdevelop"
KDE_ORG_NAME="kdev-python"
PYTHON_COMPAT=( python3_{11..14} )
KFMIN=6.16.0
QTMIN=6.9.1
inherit ecm gear.kde.org python-single-r1

DESCRIPTION="Python plugin for KDevelop"
HOMEPAGE="https://kdevelop.org/"

LICENSE="GPL-2" # TODO: CHECK
SLOT="6"
KEYWORDS="amd64 arm64"
IUSE=""

REQUIRED_USE="${PYTHON_REQUIRED_USE}"
RESTRICT="test" # bug 965829

COMMON_DEPEND="${PYTHON_DEPS}
	>=dev-qt/qt5compat-${QTMIN}:6
	>=dev-qt/qtbase-${QTMIN}:6[gui,widgets]
	dev-util/kdevelop:6=
	>=kde-frameworks/kconfig-${KFMIN}:6
	>=kde-frameworks/kcoreaddons-${KFMIN}:6
	>=kde-frameworks/ki18n-${KFMIN}:6
	>=kde-frameworks/kparts-${KFMIN}:6
	>=kde-frameworks/kservice-${KFMIN}:6
	>=kde-frameworks/ktexteditor-${KFMIN}:6
	>=kde-frameworks/kwidgetsaddons-${KFMIN}:6
	>=kde-frameworks/kxmlgui-${KFMIN}:6
	>=kde-frameworks/threadweaver-${KFMIN}:6
"
DEPEND="${COMMON_DEPEND}
	dev-util/kdevelop:6=[test?]
"
RDEPEND="${COMMON_DEPEND}
	$(python_gen_cond_dep '
		dev-python/pycodestyle[${PYTHON_USEDEP}]
	')
"
