# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

inherit findlib

DESCRIPTION="Ocaml library to handle dates and time"
HOMEPAGE="https://forge.ocamlcore.org/projects/calendar/"
SRC_URI="https://download.ocamlcore.org/${PN}/${PN}/${PV}/${P}.tar.gz"

LICENSE="LGPL-2.1-with-linking-exception"
SLOT="0/${PV}"
KEYWORDS="~amd64"
IUSE="doc"

DEPEND="<dev-lang/ocaml-5:=[ocamlopt]"
RDEPEND="${DEPEND}"

src_compile() {
	emake
	use doc && emake doc
}

src_test() {
	emake tests
}

src_install() {
	findlib_src_install
	dodoc README CHANGES

	if use doc ; then
		docinto html
		dodoc -r doc
	fi
}
