# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

MY_PN="naxsi"
NGINX_MOD_S="${WORKDIR}/${MY_PN}-${PV}"
NGINX_MOD_CONFIG_DIR="naxsi_src"

inherit nginx-module

DESCRIPTION="NAXSI is an open-source, high performance, low rules maintenance WAF for NGINX"
HOMEPAGE="https://github.com/wargio/naxsi"
# We fetch the source code generated by GitHub to not waste bandwidth on
# downloading submodules which are provided by the system.
SRC_URI="
	https://github.com/wargio/naxsi/archive/refs/tags/${PV}.tar.gz -> ${P}.tar.gz
"

LICENSE="BSD-2"
SLOT="0"

KEYWORDS="~amd64"

DEPEND="dev-libs/libinjection:="
RDEPEND="${DEPEND}"

PATCHES=(
	"${FILESDIR}/${PN}-1.7-use-ngx_module_libs.patch"
)

src_install() {
	nginx-module_src_install
	insinto /etc/nginx/naxsi
	doins -r "${NGINX_MOD_S}"/naxsi_rules/*
	docompress -x "/usr/share/doc/${PF}"
	dodoc -r "${NGINX_MOD_S}"/docs/*
}
