/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.functions.StandardFunction;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public abstract class SystemFunction
extends FunctionCall {
    private StandardFunction.Entry details;
    protected int operation;

    public static FunctionCall makeSystemFunction(String name, Expression[] arguments) {
        StandardFunction.Entry entry = StandardFunction.getFunction(name, arguments.length);
        if (entry == null) {
            return null;
        }
        Class functionClass = entry.implementationClass;
        try {
            SystemFunction f = (SystemFunction)functionClass.newInstance();
            f.setDetails(entry);
            f.setFunctionName(new StructuredQName("", "http://www.w3.org/2005/xpath-functions", name));
            f.setArguments(arguments);
            return f;
        }
        catch (IllegalAccessException err) {
            return null;
        }
        catch (InstantiationException err) {
            return null;
        }
    }

    public void setDetails(StandardFunction.Entry entry) {
        this.details = entry;
        this.operation = this.details.opcode;
    }

    public StandardFunction.Entry getDetails() {
        return this.details;
    }

    public int getImplementationMethod() {
        boolean feedable = this.getNumberOfArguments() > 0 && !Cardinality.allowsMany(this.getRequiredType(0).getCardinality());
        int methods = super.getImplementationMethod();
        if (feedable) {
            methods |= 0x10;
        }
        return methods;
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        this.checkArgumentCount(this.details.minArguments, this.details.maxArguments, visitor);
        for (int i = 0; i < this.argument.length; ++i) {
            this.checkArgument(i, visitor);
        }
    }

    private void checkArgument(int arg, ExpressionVisitor visitor) throws XPathException {
        RoleLocator role = new RoleLocator(0, this.getFunctionName(), arg);
        role.setErrorCode(this.getErrorCodeForTypeErrors());
        this.argument[arg] = TypeChecker.staticTypeCheck(this.argument[arg], this.getRequiredType(arg), visitor.getStaticContext().isInBackwardsCompatibleMode(), role, visitor);
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression sf = super.optimize(visitor, contextItemType);
        if (sf == this && this.argument.length <= this.details.resultIfEmpty.length) {
            for (int i = 0; i < this.argument.length; ++i) {
                if (!Literal.isEmptySequence(this.argument[i]) || this.details.resultIfEmpty[i] == null) continue;
                return Literal.makeLiteral(this.details.resultIfEmpty[i]);
            }
        }
        return sf;
    }

    public Expression copy() {
        Expression[] a2 = new Expression[this.argument.length];
        for (int i = 0; i < this.argument.length; ++i) {
            a2[i] = this.argument[i].copy();
        }
        FunctionCall e2 = SystemFunction.makeSystemFunction(this.details.name, a2);
        if (e2 == null) {
            throw new UnsupportedOperationException("SystemFunction.copy()");
        }
        return e2;
    }

    public String getErrorCodeForTypeErrors() {
        return "XPTY0004";
    }

    protected SequenceType getRequiredType(int arg) {
        if (this.details == null) {
            return SequenceType.ANY_SEQUENCE;
        }
        return this.details.argumentTypes[arg];
    }

    public ItemType getItemType(TypeHierarchy th) {
        if (this.details == null) {
            return AnyItemType.getInstance();
        }
        ItemType type = this.details.itemType;
        if (type == StandardFunction.SAME_AS_FIRST_ARGUMENT) {
            if (this.argument.length > 0) {
                return this.argument[0].getItemType(th);
            }
            return AnyItemType.getInstance();
        }
        return type;
    }

    public int computeCardinality() {
        if (this.details == null) {
            return 57344;
        }
        return this.details.cardinality;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        if (this.details == null) {
            return p;
        }
        if (this.details.itemType.isAtomicType()) {
            return p | 0x400000;
        }
        for (int i = 0; i < this.argument.length; ++i) {
            if ((this.argument[i].getSpecialProperties() & 0x400000) != 0) continue;
            return p;
        }
        return p | 0x400000;
    }

    protected final void useContextItemAsDefault(ExpressionVisitor visitor) {
        if (this.argument.length == 0) {
            this.argument = new Expression[1];
            this.argument[0] = new ContextItemExpression();
            ExpressionTool.copyLocationInfo(this, this.argument[0]);
            visitor.resetStaticProperties();
        }
    }

    protected final void addContextDocumentArgument(int pos, String augmentedName) throws XPathException {
        if (this.argument.length > pos) {
            return;
        }
        if (this.argument.length != pos) {
            throw new XPathException("Too few arguments in call to " + augmentedName + "() function");
        }
        Expression[] newArgs = new Expression[pos + 1];
        System.arraycopy(this.argument, 0, newArgs, 0, this.argument.length);
        RootExpression rootExpression = new RootExpression();
        ExpressionTool.copyLocationInfo(this, rootExpression);
        newArgs[pos] = rootExpression;
        this.argument = newArgs;
        this.setDetails(StandardFunction.getFunction(augmentedName, newArgs.length));
    }

    public PathMap.PathMapNodeSet addDocToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodes) {
        this.argument[0].addToPathMap(pathMap, pathMapNodes);
        return new PathMap.PathMapNodeSet(pathMap.makeNewRoot(this));
    }
}

