/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DayTimeDurationValue;

public class Adjust
extends SystemFunction {
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        return super.simplify(visitor);
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        AtomicValue av1 = (AtomicValue)this.argument[0].evaluateItem(context);
        if (av1 == null) {
            return null;
        }
        CalendarValue in = (CalendarValue)av1;
        int nargs = this.argument.length;
        if (nargs == 1) {
            return in.adjustTimezone(context.getImplicitTimezone());
        }
        AtomicValue av2 = (AtomicValue)this.argument[1].evaluateItem(context);
        if (av2 == null) {
            return in.removeTimezone();
        }
        DayTimeDurationValue tz = (DayTimeDurationValue)av2;
        long microseconds = tz.getLengthInMicroseconds();
        if (microseconds % 60000000L != 0L) {
            XPathException err = new XPathException("Timezone is not an integral number of minutes");
            err.setErrorCode("FODT0003");
            err.setLocator(this);
            err.setXPathContext(context);
            throw err;
        }
        int tzminutes = (int)(microseconds / 60000000L);
        if (Math.abs(tzminutes) > 840) {
            XPathException err = new XPathException("Timezone out of range (-14:00 to +14:00)");
            err.setErrorCode("FODT0003");
            err.setLocator(this);
            err.setXPathContext(context);
            throw err;
        }
        return in.adjustTimezone(tzminutes);
    }
}

