/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.om.Axis;
import net.sf.saxon.pattern.AnchorPattern;
import net.sf.saxon.pattern.AnyChildNodeTest;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.LocationPathPattern;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeSetPattern;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.UnionPattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class PatternMaker {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Pattern fromExpression(Expression expression, Configuration config) throws XPathException {
        void var2_15;
        Object var2_2 = null;
        if (expression instanceof DocumentSorter) {
            expression = ((DocumentSorter)expression).getBaseExpression();
        }
        if (expression instanceof VennExpression && ((VennExpression)expression).getOperator() == 1) {
            UnionPattern unionPattern = new UnionPattern(PatternMaker.fromExpression(((VennExpression)expression).getOperands()[0], config), PatternMaker.fromExpression(((VennExpression)expression).getOperands()[1], config));
        } else if (expression instanceof AxisExpression) {
            byte axis = ((AxisExpression)expression).getAxis();
            NodeTest test = ((AxisExpression)expression).getNodeTest();
            if (test == null) {
                test = AnyNodeTest.getInstance();
            }
            if (test instanceof AnyNodeTest && (axis == 3 || axis == 4)) {
                test = AnyChildNodeTest.getInstance();
            }
            int kind = test.getPrimitiveType();
            if (axis == 12 && kind == 9) {
                NodeTestPattern nodeTestPattern = new NodeTestPattern(test);
            } else if (axis == 2) {
                if (kind == 0) {
                    NodeTestPattern nodeTestPattern = new NodeTestPattern(NodeKindTest.ATTRIBUTE);
                } else if (!Axis.containsNodeKind(axis, kind)) {
                    NodeTestPattern nodeTestPattern = new NodeTestPattern(EmptySequenceTest.getInstance());
                } else {
                    NodeTestPattern nodeTestPattern = new NodeTestPattern(test);
                }
            } else {
                if (axis != 3 && axis != 4 && axis != 5) throw new XPathException("Only downwards axes are allowed in a pattern", "XTSE0340");
                if (kind != 0 && !Axis.containsNodeKind(axis, kind)) {
                    test = EmptySequenceTest.getInstance();
                }
                NodeTestPattern nodeTestPattern = new NodeTestPattern(test);
            }
        } else if (expression instanceof FilterExpression) {
            Expression base = ((FilterExpression)expression).getControllingExpression();
            Expression filter = ((FilterExpression)expression).getFilter();
            Pattern basePattern = PatternMaker.fromExpression(base, config);
            if (basePattern instanceof NodeTestPattern) {
                LocationPathPattern path = new LocationPathPattern();
                path.setNodeTest(basePattern.getNodeTest());
                basePattern = path;
            }
            if (!(basePattern instanceof LocationPathPattern)) {
                throw new XPathException("The filtered expression in a pattern must be a simple step");
            }
            ((LocationPathPattern)basePattern).addFilter(filter);
            Pattern pattern = basePattern;
        } else if (expression instanceof SlashExpression) {
            Expression head = ((SlashExpression)expression).getLeadingSteps();
            Expression tail = ((SlashExpression)expression).getLastStep();
            Pattern tailPattern = PatternMaker.fromExpression(tail, config);
            if (tailPattern instanceof NodeTestPattern) {
                LocationPathPattern path = new LocationPathPattern();
                path.setNodeTest(tailPattern.getNodeTest());
                tailPattern = path;
            }
            if (!(tailPattern instanceof LocationPathPattern)) {
                throw new XPathException("The path in a pattern must contain simple steps: found " + tailPattern.toString());
            }
            if (((LocationPathPattern)tailPattern).getUpperPattern() != null) {
                throw new XPathException("The path in a pattern must contain simple steps");
            }
            byte axis = PatternMaker.getAxisForPathStep(tail);
            Pattern headPattern = PatternMaker.fromExpression(head, config);
            ((LocationPathPattern)tailPattern).setUpperPattern(axis, headPattern);
            Pattern pattern = tailPattern;
        } else if (expression instanceof ContextItemExpression) {
            AnchorPattern anchorPattern = new AnchorPattern();
        } else if (expression instanceof RootExpression) {
            NodeTestPattern nodeTestPattern = new NodeTestPattern(NodeKindTest.DOCUMENT);
        } else {
            TypeHierarchy th = config.getTypeHierarchy();
            ItemType type = expression.getItemType(th);
            if ((expression.getDependencies() & 0xE) == 0 && (type instanceof NodeTest || expression instanceof VariableReference)) {
                NodeSetPattern nodeSetPattern = new NodeSetPattern(expression, config);
            }
        }
        if (var2_15 == null) {
            throw new XPathException("Cannot convert the expression {" + expression.toString() + "} to a pattern");
        }
        var2_15.setOriginalText(expression.toString());
        return var2_15;
    }

    public static byte getAxisForPathStep(Expression step) throws XPathException {
        if (step instanceof AxisExpression) {
            return Axis.inverseAxis[((AxisExpression)step).getAxis()];
        }
        if (step instanceof FilterExpression) {
            return PatternMaker.getAxisForPathStep(((FilterExpression)step).getControllingExpression());
        }
        if (step instanceof PathExpression) {
            return PatternMaker.getAxisForPathStep(((PathExpression)step).getFirstStep());
        }
        if (step instanceof ContextItemExpression) {
            return 12;
        }
        throw new XPathException("The path in a pattern must contain simple steps");
    }
}

