/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.BufferedIndexOutput;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;

public class SimpleFSDirectory
extends FSDirectory {
    public SimpleFSDirectory(File path, LockFactory lockFactory) throws IOException {
        super(path, lockFactory);
    }

    public SimpleFSDirectory(File path) throws IOException {
        super(path, null);
    }

    public IndexOutput createOutput(String name) throws IOException {
        this.initOutput(name);
        return new SimpleFSIndexOutput(new File(this.directory, name));
    }

    public IndexInput openInput(String name, int bufferSize) throws IOException {
        this.ensureOpen();
        return new SimpleFSIndexInput(new File(this.directory, name), bufferSize, this.getReadChunkSize());
    }

    protected static class SimpleFSIndexOutput
    extends BufferedIndexOutput {
        RandomAccessFile file = null;
        private volatile boolean isOpen;

        public SimpleFSIndexOutput(File path) throws IOException {
            this.file = new RandomAccessFile(path, "rw");
            this.isOpen = true;
        }

        public void flushBuffer(byte[] b, int offset, int size) throws IOException {
            this.file.write(b, offset, size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void close() throws IOException {
            block6: {
                if (!this.isOpen) return;
                boolean success = false;
                try {
                    super.close();
                    success = true;
                    Object var3_2 = null;
                    this.isOpen = false;
                    if (success) break block6;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.isOpen = false;
                    if (success) {
                        this.file.close();
                        throw throwable;
                    }
                    try {
                        this.file.close();
                        throw throwable;
                    }
                    catch (Throwable t) {
                        throw throwable;
                    }
                }
                try {}
                catch (Throwable t) {
                    return;
                }
                this.file.close();
                return;
            }
            this.file.close();
        }

        public void seek(long pos) throws IOException {
            super.seek(pos);
            this.file.seek(pos);
        }

        public long length() throws IOException {
            return this.file.length();
        }

        public void setLength(long length) throws IOException {
            this.file.setLength(length);
        }
    }

    protected static class SimpleFSIndexInput
    extends BufferedIndexInput {
        protected final Descriptor file;
        boolean isClone;
        protected final int chunkSize;

        public SimpleFSIndexInput(File path, int bufferSize, int chunkSize) throws IOException {
            super(bufferSize);
            this.file = new Descriptor(path, "r");
            this.chunkSize = chunkSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void readInternal(byte[] b, int offset, int len) throws IOException {
            Descriptor descriptor = this.file;
            synchronized (descriptor) {
                long position = this.getFilePointer();
                if (position != this.file.position) {
                    this.file.seek(position);
                    this.file.position = position;
                }
                int total = 0;
                try {
                    int i;
                    do {
                        int readLength;
                        if ((i = this.file.read(b, offset + total, readLength = total + this.chunkSize > len ? len - total : this.chunkSize)) == -1) {
                            throw new IOException("read past EOF");
                        }
                        this.file.position += (long)i;
                    } while ((total += i) < len);
                }
                catch (OutOfMemoryError e) {
                    OutOfMemoryError outOfMemoryError = new OutOfMemoryError("OutOfMemoryError likely caused by the Sun VM Bug described in https://issues.apache.org/jira/browse/LUCENE-1566; try calling FSDirectory.setReadChunkSize with a a value smaller than the current chunks size (" + this.chunkSize + ")");
                    outOfMemoryError.initCause(e);
                    throw outOfMemoryError;
                }
            }
        }

        public void close() throws IOException {
            if (!this.isClone) {
                this.file.close();
            }
        }

        protected void seekInternal(long position) {
        }

        public long length() {
            return this.file.length;
        }

        public Object clone() {
            SimpleFSIndexInput clone = (SimpleFSIndexInput)super.clone();
            clone.isClone = true;
            return clone;
        }

        boolean isFDValid() throws IOException {
            return this.file.getFD().valid();
        }

        protected static class Descriptor
        extends RandomAccessFile {
            protected volatile boolean isOpen = true;
            long position;
            final long length = this.length();

            public Descriptor(File file, String mode) throws IOException {
                super(file, mode);
            }

            public void close() throws IOException {
                if (this.isOpen) {
                    this.isOpen = false;
                    super.close();
                }
            }
        }
    }
}

