/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.HttpUtils;
import com.xmlcalabash.util.JSONtoXML;
import com.xmlcalabash.util.MIMEReader;
import com.xmlcalabash.util.RelevantNodes;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.XMLtoJSON;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.List;
import java.util.Vector;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.json.JSONTokener;
import org.xml.sax.InputSource;

public class HttpRequest
extends DefaultStep {
    private static final QName c_request = new QName("c", "http://www.w3.org/ns/xproc-step", "request");
    private static final QName cx_timeout = new QName("cx", "http://xmlcalabash.com/ns/extensions", "timeout");
    private static final QName cx_cookies = new QName("cx", "http://xmlcalabash.com/ns/extensions", "cookies");
    private static final QName cx_save_cookies = new QName("cx", "http://xmlcalabash.com/ns/extensions", "save-cookies");
    private static final QName cx_use_cookies = new QName("cx", "http://xmlcalabash.com/ns/extensions", "use-cookies");
    private static final QName cx_send_binary = new QName("cx", "http://xmlcalabash.com/ns/extensions", "send-binary");
    public static final QName _href = new QName("", "href");
    public static final QName _detailed = new QName("", "detailed");
    public static final QName _status_only = new QName("", "status-only");
    public static final QName _username = new QName("", "username");
    public static final QName _password = new QName("", "password");
    public static final QName _auth_method = new QName("", "auth-method");
    public static final QName _send_authorization = new QName("", "send-authorization");
    public static final QName _override_content_type = new QName("", "override-content-type");
    public static final QName _content_type = new QName("", "content-type");
    public static final QName _name = new QName("", "name");
    public static final QName _value = new QName("", "value");
    public static final QName _id = new QName("", "id");
    public static final QName _description = new QName("", "description");
    public static final QName _disposition = new QName("", "disposition");
    public static final QName _status = new QName("", "status");
    public static final QName _boundary = new QName("", "boundary");
    public static final QName _charset = new QName("", "charset");
    private static final int bufSize = 7296;
    private HttpClient client = null;
    private boolean statusOnly = false;
    private boolean detailed = false;
    private String method = null;
    private URI requestURI = null;
    private Vector<Header> headers = new Vector();
    private String contentType = null;
    private String overrideContentType = null;
    private String headerContentType = null;
    private boolean encodeBinary = false;
    private ReadablePipe source = null;
    private WritablePipe result = null;

    public HttpRequest(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        this.source = readablePipe;
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() throws SaxonApiException {
        TreeWriter treeWriter;
        block50: {
            void var15_30;
            Object object;
            int n;
            Object object3;
            ProxySelector proxySelector;
            List<Proxy> list;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            super.run();
            XdmNode xdmNode = this.source.read();
            XdmNode xdmNode2 = S9apiUtils.getDocumentElement(xdmNode);
            if (!c_request.equals((Object)xdmNode2.getNodeName())) {
                throw XProcException.stepError(40);
            }
            XdmSequenceIterator xdmSequenceIterator = xdmNode2.axisIterator(Axis.ATTRIBUTE);
            boolean bl = true;
            while (xdmSequenceIterator.hasNext()) {
                object8 = (XdmNode)xdmSequenceIterator.next();
                object7 = object8.getNodeName();
                if (_method.equals(object7) || _href.equals(object7) || _detailed.equals(object7) || _status_only.equals(object7) || _username.equals(object7) || _password.equals(object7) || _auth_method.equals(object7) || _send_authorization.equals(object7) || _override_content_type.equals(object7) || !"".equals(object7.getNamespaceURI())) continue;
                throw new XProcException(this.step.getNode(), "Unsupported attribute on c:request for p:http-request: " + object7);
            }
            object8 = this.step.getExtensionAttribute(cx_send_binary);
            this.encodeBinary = !"true".equals(object8);
            this.method = xdmNode2.getAttributeValue(_method);
            this.statusOnly = "true".equals(xdmNode2.getAttributeValue(_status_only));
            this.detailed = "true".equals(xdmNode2.getAttributeValue(_detailed));
            this.overrideContentType = xdmNode2.getAttributeValue(_override_content_type);
            if (this.method == null) {
                throw XProcException.stepError(6);
            }
            if (this.statusOnly && !this.detailed) {
                throw XProcException.stepError(4);
            }
            if (xdmNode2.getAttributeValue(_href) == null) {
                throw new XProcException(this.step.getNode(), "The 'href' attribute must be specified on c:request for p:http-request");
            }
            this.requestURI = xdmNode2.getBaseURI().resolve(xdmNode2.getAttributeValue(_href));
            if ("file".equals(this.requestURI.getScheme())) {
                this.doFile();
                return;
            }
            object7 = this.step.getExtensionAttribute(cx_save_cookies);
            String string = this.step.getExtensionAttribute(cx_use_cookies);
            String string2 = this.step.getExtensionAttribute(cx_cookies);
            if (object7 == null) {
                object7 = string2;
            }
            if (string == null) {
                string = string2;
            }
            this.client = new HttpClient();
            this.client.getParams().setCookiePolicy("rfc2109");
            this.client.getParams().setParameter("http.protocol.single-cookie-header", (Object)true);
            HttpState httpState = this.client.getState();
            if (string != null) {
                object6 = string.split("\\s+");
                int n2 = ((String[])object6).length;
                for (int i = 0; i < n2; ++i) {
                    object5 = object6[i];
                    for (Cookie object42 : this.runtime.getCookies((String)object5)) {
                        httpState.addCookie(object42);
                    }
                }
            }
            if ((object6 = this.step.getExtensionAttribute(cx_timeout)) != null) {
                HttpClientParams httpClientParams = this.client.getParams();
                httpClientParams.setSoTimeout(Integer.parseInt((String)object6));
            }
            if ((list = (proxySelector = ProxySelector.getDefault()).select(this.requestURI)).size() > 0) {
                object5 = list.get(0);
                switch (((Proxy)object5).type()) {
                    case DIRECT: {
                        break;
                    }
                    case HTTP: {
                        object3 = (InetSocketAddress)((Proxy)object5).address();
                        String string3 = ((InetSocketAddress)object3).getHostName();
                        int n2 = ((InetSocketAddress)object3).getPort();
                        this.client.getHostConfiguration().setProxy(string3, n2);
                        break;
                    }
                }
            }
            if (xdmNode2.getAttributeValue(_username) != null) {
                object5 = xdmNode2.getAttributeValue(_username);
                object3 = xdmNode2.getAttributeValue(_password);
                String string4 = xdmNode2.getAttributeValue(_auth_method);
                if (string4 == null || !"basic".equals(string4.toLowerCase()) && !"digest".equals(string4.toLowerCase())) {
                    throw XProcException.stepError(3, "Unsupported auth-method: " + string4);
                }
                String string5 = this.requestURI.getHost();
                n = this.requestURI.getPort();
                object = new AuthScope(string5, n);
                UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials((String)object5, (String)object3);
                this.client.getState().setCredentials((AuthScope)object, (Credentials)usernamePasswordCredentials);
                if ("basic".equals(string4.toLowerCase())) {
                    this.client.getParams().setAuthenticationPreemptive(true);
                }
            }
            xdmSequenceIterator = xdmNode2.axisIterator(Axis.CHILD);
            object5 = null;
            while (xdmSequenceIterator.hasNext()) {
                object3 = (XdmNode)xdmSequenceIterator.next();
                if (object3.getNodeKind() != XdmNodeKind.ELEMENT) continue;
                if (object5 != null) {
                    throw new UnsupportedOperationException("Elements follow c:multipart or c:body");
                }
                if (XProcConstants.c_header.equals((Object)object3.getNodeName())) {
                    String string6 = object3.getAttributeValue(_name);
                    if (string6 == null) continue;
                    if (string6.toLowerCase().equals("content-type")) {
                        this.headerContentType = object3.getAttributeValue(_value).toLowerCase();
                        continue;
                    }
                    this.headers.add(new Header(object3.getAttributeValue(_name), object3.getAttributeValue(_value)));
                    continue;
                }
                if (XProcConstants.c_multipart.equals((Object)object3.getNodeName()) || XProcConstants.c_body.equals((Object)object3.getNodeName())) {
                    object5 = object3;
                    continue;
                }
                throw new UnsupportedOperationException("Unexpected request element: " + object3.getNodeName());
            }
            object3 = this.method.toLowerCase();
            if (object5 != null && !"put".equals(object3) && !"post".equals(object3)) {
                throw XProcException.stepError(5);
            }
            if ("get".equals(object3)) {
                GetMethod getMethod = this.doGet();
            } else if ("post".equals(object3)) {
                PostMethod postMethod = this.doPost((XdmNode)object5);
            } else if ("put".equals(object3)) {
                PutMethod putMethod = this.doPut((XdmNode)object5);
            } else if ("head".equals(object3)) {
                HeadMethod headMethod = this.doHead();
            } else if ("delete".equals(object3)) {
                DeleteMethod deleteMethod = this.doDelete();
            } else {
                throw new UnsupportedOperationException("Unrecognized http method: " + this.method);
            }
            treeWriter = new TreeWriter(this.runtime);
            treeWriter.startDocument(this.requestURI);
            try {
                n = this.client.executeMethod((HttpMethod)var15_30);
                if (object7 != null) {
                    this.runtime.clearCookies((String)object7);
                    httpState = this.client.getState();
                    for (Cookie cookie : object = httpState.getCookies()) {
                        this.runtime.addCookie((String)object7, cookie);
                    }
                }
                object = this.getContentType((HttpMethodBase)var15_30);
                if (this.overrideContentType != null) {
                    if (this.xmlContentType((String)object) && this.overrideContentType.startsWith("image/") || object.startsWith("text/") && this.overrideContentType.startsWith("image/") || object.startsWith("image/") && this.xmlContentType(this.overrideContentType) || object.startsWith("image/") && this.overrideContentType.startsWith("text/") || object.startsWith("multipart/") && !this.overrideContentType.startsWith("multipart/") || !object.startsWith("multipart/") && this.overrideContentType.startsWith("multipart/")) {
                        throw XProcException.stepError(30);
                    }
                    object = this.overrideContentType;
                }
                if (this.detailed) {
                    InputStream inputStream;
                    treeWriter.addStartElement(XProcConstants.c_response);
                    treeWriter.addAttribute(_status, "" + n);
                    treeWriter.startContent();
                    for (Cookie cookie : var15_30.getResponseHeaders()) {
                        String string7 = cookie.toString();
                        int n3 = string7.indexOf(":");
                        String string8 = cookie.getName();
                        String string9 = string7.substring(n3 + 1).trim();
                        treeWriter.addStartElement(XProcConstants.c_header);
                        treeWriter.addAttribute(_name, string8);
                        treeWriter.addAttribute(_value, string9);
                        treeWriter.startContent();
                        treeWriter.addEndElement();
                    }
                    if (!this.statusOnly && (inputStream = var15_30.getResponseBodyAsStream()) != null) {
                        this.readBodyContent(treeWriter, inputStream, (HttpMethodBase)var15_30);
                    }
                    treeWriter.addEndElement();
                    break block50;
                }
                if (this.statusOnly) {
                    break block50;
                }
                InputStream inputStream = var15_30.getResponseBodyAsStream();
                if (inputStream != null) {
                    this.readBodyContent(treeWriter, inputStream, (HttpMethodBase)var15_30);
                    break block50;
                }
                throw XProcException.dynamicError(6);
            }
            catch (Exception exception) {
                throw new XProcException(exception);
            }
            finally {
                var15_30.releaseConnection();
            }
        }
        treeWriter.endDocument();
        XdmNode xdmNode = treeWriter.getResult();
        this.result.write(xdmNode);
    }

    private GetMethod doGet() {
        GetMethod getMethod = new GetMethod(this.requestURI.toASCIIString());
        getMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
        for (Header header : this.headers) {
            getMethod.addRequestHeader(header);
        }
        return getMethod;
    }

    private HeadMethod doHead() {
        HeadMethod headMethod = new HeadMethod(this.requestURI.toASCIIString());
        headMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
        for (Header header : this.headers) {
            headMethod.addRequestHeader(header);
        }
        return headMethod;
    }

    private DeleteMethod doDelete() {
        DeleteMethod deleteMethod = new DeleteMethod(this.requestURI.toASCIIString());
        deleteMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
        for (Header header : this.headers) {
            deleteMethod.addRequestHeader(header);
        }
        return deleteMethod;
    }

    private PutMethod doPut(XdmNode xdmNode) {
        PutMethod putMethod = new PutMethod(this.requestURI.toASCIIString());
        this.doPutOrPost((EntityEnclosingMethod)putMethod, xdmNode);
        return putMethod;
    }

    private PostMethod doPost(XdmNode xdmNode) {
        PostMethod postMethod = new PostMethod(this.requestURI.toASCIIString());
        this.doPutOrPost((EntityEnclosingMethod)postMethod, xdmNode);
        return postMethod;
    }

    private void doPutOrPost(EntityEnclosingMethod entityEnclosingMethod, XdmNode xdmNode) {
        if (XProcConstants.c_multipart.equals((Object)xdmNode.getNodeName())) {
            this.doPutOrPostMultipart(entityEnclosingMethod, xdmNode);
        } else {
            this.doPutOrPostSinglepart(entityEnclosingMethod, xdmNode);
        }
    }

    private void doPutOrPostSinglepart(EntityEnclosingMethod entityEnclosingMethod, XdmNode xdmNode) {
        Object object2;
        entityEnclosingMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
        this.contentType = xdmNode.getAttributeValue(_content_type);
        if (this.contentType == null) {
            throw new XProcException(this.step.getNode(), "Content-type on c:body is required.");
        }
        if (this.headerContentType != null && !this.headerContentType.equals(this.contentType.toLowerCase())) {
            throw XProcException.stepError(20);
        }
        for (Object object2 : this.headers) {
            entityEnclosingMethod.addRequestHeader(object2);
        }
        Object object3 = null;
        object2 = xdmNode.getAttributeValue(_encoding);
        try {
            Object object4;
            if ("base64".equals(object2)) {
                object4 = xdmNode.getAttributeValue(_charset);
                if (object4 == null) {
                    object4 = "utf-8";
                }
                String string = this.decodeBase64(xdmNode, (String)object4);
                StringWriter stringWriter = new StringWriter();
                stringWriter.write(string);
                stringWriter.close();
                object3 = stringWriter.toString();
            } else if (this.jsonContentType(this.contentType)) {
                object3 = XMLtoJSON.convert(xdmNode);
            } else if (this.xmlContentType(this.contentType)) {
                Object object5;
                object4 = this.makeSerializer();
                if (!S9apiUtils.isDocumentContent(xdmNode.axisIterator(Axis.CHILD))) {
                    throw XProcException.stepError(22);
                }
                Vector<XdmNode> vector = new Vector<XdmNode>();
                XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
                while (xdmSequenceIterator.hasNext()) {
                    object5 = (XdmNode)xdmSequenceIterator.next();
                    vector.add((XdmNode)object5);
                }
                object5 = new StringWriter();
                object4.setOutputWriter((Writer)object5);
                S9apiUtils.serialize(this.runtime, vector, (Serializer)object4);
                ((StringWriter)object5).close();
                object3 = ((StringWriter)object5).toString();
            } else {
                object4 = new StringWriter();
                XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
                while (xdmSequenceIterator.hasNext()) {
                    XdmNode xdmNode2 = (XdmNode)xdmSequenceIterator.next();
                    if (xdmNode2.getNodeKind() != XdmNodeKind.TEXT) {
                        throw XProcException.stepError(28);
                    }
                    ((StringWriter)object4).write(xdmNode2.getStringValue());
                }
                ((StringWriter)object4).close();
                object3 = ((StringWriter)object4).toString();
            }
            object4 = new StringRequestEntity((String)object3, this.contentType, "UTF-8");
            entityEnclosingMethod.setRequestEntity((RequestEntity)object4);
        }
        catch (IOException iOException) {
            throw new XProcException(iOException);
        }
        catch (SaxonApiException saxonApiException) {
            throw new XProcException(saxonApiException);
        }
    }

    private void doPutOrPostMultipart(EntityEnclosingMethod entityEnclosingMethod, XdmNode xdmNode) {
        Object object2;
        entityEnclosingMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
        this.contentType = xdmNode.getAttributeValue(_content_type);
        if (this.contentType == null) {
            this.contentType = "multipart/mixed";
        }
        if (this.headerContentType != null && !this.headerContentType.equals(this.contentType.toLowerCase())) {
            throw XProcException.stepError(20);
        }
        if (!this.contentType.startsWith("multipart/")) {
            throw new UnsupportedOperationException("Multipart content-type must be multipart/...");
        }
        for (Object object2 : this.headers) {
            entityEnclosingMethod.addRequestHeader(object2);
        }
        String string = xdmNode.getAttributeValue(_boundary);
        if (string == null) {
            throw new XProcException(this.step.getNode(), "A boundary value must be specified on c:multipart");
        }
        if (string.startsWith("--")) {
            throw XProcException.stepError(2);
        }
        object2 = "\"";
        if (string.contains((CharSequence)object2)) {
            object2 = "'";
        }
        if (string.contains((CharSequence)object2)) {
            object2 = "";
        }
        String string2 = this.contentType + "; boundary=" + (String)object2 + (String)string + (String)object2;
        MessageBytes messageBytes = new MessageBytes();
        messageBytes.append("This is a multipart message.\r\n");
        for (XdmNode xdmNode2 : new RelevantNodes(this.runtime, xdmNode, Axis.CHILD)) {
            String string3;
            if (!XProcConstants.c_body.equals((Object)xdmNode2.getNodeName())) {
                throw new XProcException(this.step.getNode(), "A c:multipart may only contain c:body elements.");
            }
            String string4 = xdmNode2.getAttributeValue(_content_type);
            if (string4 == null) {
                throw new XProcException(this.step.getNode(), "Content-type on c:body is required.");
            }
            String string5 = xdmNode2.getAttributeValue(_id);
            String string6 = xdmNode2.getAttributeValue(_description);
            String string7 = xdmNode2.getAttributeValue(_disposition);
            String string8 = HttpUtils.getCharset(string4);
            if (string4.contains(";")) {
                int n = string4.indexOf(";");
                string4 = string4.substring(0, n);
            }
            if ((string3 = xdmNode2.getAttributeValue(_encoding)) != null && !"base64".equals(string3)) {
                throw new UnsupportedOperationException("The '" + string3 + "' encoding is not supported");
            }
            string4 = string8 != null ? string4 + "; charset=" + string8 : string4 + "; charset=utf-8";
            messageBytes.append("--" + (String)string + "\r\n");
            messageBytes.append("Content-Type: " + string4 + "\r\n");
            if (string6 != null) {
                messageBytes.append("Content-Description: " + string6 + "\r\n");
            }
            if (string5 != null) {
                messageBytes.append("Content-ID: " + string5 + "\r\n");
            }
            if (string7 != null) {
                messageBytes.append("Content-Disposition: " + string7 + "\r\n");
            }
            if (string3 != null && this.encodeBinary) {
                messageBytes.append("Content-Transfer-Encoding: " + string3 + "\r\n");
            }
            messageBytes.append("\r\n");
            try {
                XdmSequenceIterator xdmSequenceIterator;
                XdmSequenceIterator xdmSequenceIterator2;
                Object object3;
                if (this.xmlContentType(string4)) {
                    Object object4;
                    object3 = this.makeSerializer();
                    xdmSequenceIterator2 = new Vector();
                    xdmSequenceIterator = xdmNode2.axisIterator(Axis.CHILD);
                    while (xdmSequenceIterator.hasNext()) {
                        object4 = (XdmNode)xdmSequenceIterator.next();
                        xdmSequenceIterator2.add(object4);
                    }
                    object4 = new StringWriter();
                    object3.setOutputWriter((Writer)object4);
                    S9apiUtils.serialize(this.runtime, (Vector<XdmNode>)xdmSequenceIterator2, (Serializer)object3);
                    ((StringWriter)object4).close();
                    messageBytes.append(((StringWriter)object4).toString());
                } else if (this.jsonContentType(this.contentType)) {
                    messageBytes.append(XMLtoJSON.convert(xdmNode2));
                } else if (!this.encodeBinary && "base64".equals(string3)) {
                    object3 = Base64.decode(xdmNode2.getStringValue());
                    messageBytes.append((byte[])object3, ((Serializer)object3).length);
                } else {
                    object3 = new StringWriter();
                    xdmSequenceIterator2 = xdmNode2.axisIterator(Axis.CHILD);
                    while (xdmSequenceIterator2.hasNext()) {
                        xdmSequenceIterator = (XdmNode)xdmSequenceIterator2.next();
                        if (xdmSequenceIterator.getNodeKind() != XdmNodeKind.TEXT) {
                            throw XProcException.stepError(28);
                        }
                        ((StringWriter)object3).write(xdmSequenceIterator.getStringValue());
                    }
                    ((StringWriter)object3).close();
                    messageBytes.append(((StringWriter)object3).toString());
                }
                messageBytes.append("\r\n");
            }
            catch (IOException iOException) {
                throw new XProcException(iOException);
            }
            catch (SaxonApiException saxonApiException) {
                throw new XProcException(saxonApiException);
            }
        }
        messageBytes.append("--" + (String)string + "--\r\n");
        ByteArrayRequestEntity byteArrayRequestEntity = new ByteArrayRequestEntity(messageBytes.content(), string2);
        entityEnclosingMethod.setRequestEntity((RequestEntity)byteArrayRequestEntity);
    }

    private String getFullContentType(HttpMethodBase httpMethodBase) {
        Header header = httpMethodBase.getResponseHeader("Content-Type");
        return this.getFullContentType(header);
    }

    private String getFullContentType(Header header) {
        if (header == null) {
            return "application/octet-stream";
        }
        HeaderElement[] headerElementArray = header.getElements();
        if (headerElementArray == null || headerElementArray.length == 0) {
            return null;
        }
        String string = headerElementArray[0].getName();
        NameValuePair[] nameValuePairArray = headerElementArray[0].getParameters();
        if (nameValuePairArray != null) {
            for (NameValuePair nameValuePair : nameValuePairArray) {
                string = string + "; " + nameValuePair.getName() + "=\"" + nameValuePair.getValue() + "\"";
            }
        }
        return string;
    }

    private String getHeaderValue(Header header) {
        if (header == null) {
            return null;
        }
        HeaderElement[] headerElementArray = header.getElements();
        if (headerElementArray == null || headerElementArray.length == 0) {
            return null;
        }
        return headerElementArray[0].getName();
    }

    private String getContentType(HttpMethodBase httpMethodBase) {
        Header header = httpMethodBase.getResponseHeader("Content-Type");
        String string = this.getContentType(header);
        if (string == null) {
            return "application/octet-stream";
        }
        return string;
    }

    private String getContentType(Header header) {
        return this.getHeaderValue(header);
    }

    private String getContentBoundary(HttpMethodBase httpMethodBase) {
        Header header = httpMethodBase.getResponseHeader("Content-Type");
        return this.getContentBoundary(header);
    }

    private String getContentBoundary(Header header) {
        if (header == null) {
            return null;
        }
        HeaderElement[] headerElementArray = header.getElements();
        if (headerElementArray == null || headerElementArray.length == 0) {
            return null;
        }
        NameValuePair nameValuePair = headerElementArray[0].getParameterByName("boundary");
        return nameValuePair == null ? null : nameValuePair.getValue();
    }

    private String getContentCharset(Header header) {
        if (header == null) {
            return null;
        }
        HeaderElement[] headerElementArray = header.getElements();
        if (headerElementArray == null || headerElementArray.length == 0) {
            return null;
        }
        NameValuePair nameValuePair = headerElementArray[0].getParameterByName("charset");
        if (nameValuePair == null) {
            return "US-ASCII";
        }
        return nameValuePair.getValue();
    }

    private boolean xmlContentType(String string) {
        return HttpUtils.xmlContentType(string);
    }

    private boolean jsonContentType(String string) {
        return this.runtime.transparentJSON() && HttpUtils.jsonContentType(string);
    }

    private boolean textContentType(String string) {
        return HttpUtils.textContentType(string);
    }

    private void readBodyContent(TreeWriter treeWriter, InputStream inputStream, HttpMethodBase httpMethodBase) throws SaxonApiException, IOException {
        String string = this.getFullContentType(httpMethodBase);
        String string2 = httpMethodBase.getResponseCharSet();
        String string3 = this.getContentBoundary(httpMethodBase);
        if (this.overrideContentType != null) {
            string = this.overrideContentType;
        }
        if (string.startsWith("multipart/")) {
            treeWriter.addStartElement(XProcConstants.c_multipart);
            treeWriter.addAttribute(_content_type, string);
            treeWriter.addAttribute(_boundary, string3);
            treeWriter.startContent();
            this.readMultipartContent(treeWriter, inputStream, string3);
            treeWriter.addEndElement();
        } else if (!this.detailed && (this.xmlContentType(string) || this.jsonContentType(string))) {
            this.readBodyContentPart(treeWriter, inputStream, string, string2);
        } else {
            treeWriter.addStartElement(XProcConstants.c_body);
            treeWriter.addAttribute(_content_type, string);
            if (!(this.xmlContentType(string) || this.textContentType(string) || this.jsonContentType(string))) {
                treeWriter.addAttribute(_encoding, "base64");
            }
            treeWriter.startContent();
            this.readBodyContentPart(treeWriter, inputStream, string, string2);
            treeWriter.addEndElement();
        }
    }

    private void readMultipartContent(TreeWriter treeWriter, InputStream inputStream, String string) throws IOException, SaxonApiException {
        MIMEReader mIMEReader = new MIMEReader(inputStream, string);
        boolean bl = false;
        while (mIMEReader.readHeaders()) {
            int n;
            Object object;
            Header header = mIMEReader.getHeader("Content-Type");
            Header header2 = mIMEReader.getHeader("Content-Length");
            this.contentType = this.getHeaderValue(header);
            String string2 = this.getContentCharset(header);
            String string3 = this.getHeaderValue(header);
            InputStream inputStream2 = null;
            if (header2 != null) {
                int n2 = Integer.parseInt(this.getHeaderValue(header2));
                inputStream2 = mIMEReader.readBodyPart(n2);
            } else {
                inputStream2 = mIMEReader.readBodyPart();
            }
            treeWriter.addStartElement(XProcConstants.c_body);
            treeWriter.addAttribute(_content_type, this.contentType);
            if (!this.xmlContentType(this.contentType) && !this.textContentType(this.contentType)) {
                treeWriter.addAttribute(_encoding, "base64");
            }
            treeWriter.startContent();
            if (this.xmlContentType(string3)) {
                object = new BufferedReader(new InputStreamReader(inputStream2, string2));
                treeWriter.addSubtree(this.runtime.parse(new InputSource((Reader)object)));
            } else if (this.textContentType(string3)) {
                object = new BufferedReader(new InputStreamReader(inputStream2, string2));
                char[] cArray = new char[7296];
                n = ((BufferedReader)object).read(cArray, 0, 7296);
                while (n >= 0) {
                    char[] cArray2 = new char[7296];
                    int n3 = 0;
                    for (int i = 0; i < n; ++i) {
                        if (cArray[i] == '\r') {
                            if (i + 1 == n || cArray[i + 1] == '\n') continue;
                            int n4 = n3;
                            n3 = (char)(n3 + 1);
                            cArray2[n4] = 10;
                            continue;
                        }
                        int n5 = n3;
                        n3 = (char)(n3 + 1);
                        cArray2[n5] = cArray[i];
                    }
                    treeWriter.addText(new String(cArray2, 0, n3));
                    n = ((BufferedReader)object).read(cArray, 0, 7296);
                }
            } else {
                object = new byte[7296];
                int n6 = 0;
                n = 7296;
                int n7 = inputStream2.read((byte[])object, 0, 7296);
                while (n7 >= 0) {
                    n6 += n7;
                    if ((n -= n7) == 0) {
                        treeWriter.addText(Base64.encodeBytes((byte[])object));
                        n6 = 0;
                        n = 7296;
                    }
                    n7 = inputStream2.read((byte[])object, n6, n);
                }
                if (n6 > 0) {
                    byte[] byArray = new byte[n6];
                    System.arraycopy(object, 0, byArray, 0, n6);
                    treeWriter.addText(Base64.encodeBytes(byArray));
                }
                treeWriter.addText("\n");
            }
            treeWriter.addEndElement();
        }
    }

    public void readBodyContentPart(TreeWriter treeWriter, InputStream inputStream, String string, String string2) throws SaxonApiException, IOException {
        if (this.xmlContentType(string)) {
            treeWriter.addSubtree(this.runtime.parse(new InputSource(inputStream)));
        } else if (this.textContentType(string)) {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string2);
            char[] cArray = new char[7296];
            int n = inputStreamReader.read(cArray, 0, 7296);
            while (n >= 0) {
                String string3 = new String(cArray, 0, n);
                treeWriter.addText(string3);
                n = inputStreamReader.read(cArray, 0, 7296);
            }
        } else if (this.jsonContentType(string)) {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            JSONTokener jSONTokener = new JSONTokener(inputStreamReader);
            XdmNode xdmNode = JSONtoXML.convert(this.runtime.getProcessor(), jSONTokener, this.runtime.jsonFlavor());
            treeWriter.addSubtree(xdmNode);
        } else {
            Object object;
            byte[] byArray = new byte[7296];
            int n = 0;
            int n2 = 7296;
            int n3 = inputStream.read(byArray, 0, 7296);
            while (n3 >= 0) {
                n += n3;
                if ((n2 -= n3) == 0) {
                    object = Base64.encodeBytes(byArray);
                    treeWriter.addText((String)object);
                    n = 0;
                    n2 = 7296;
                }
                n3 = inputStream.read(byArray, n, n2);
            }
            if (n > 0) {
                object = new byte[n];
                System.arraycopy(byArray, 0, object, 0, n);
                treeWriter.addText(Base64.encodeBytes(object));
            }
            treeWriter.addText("\n");
        }
    }

    private String extractText(XdmNode xdmNode) {
        String string = "";
        XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
        while (xdmSequenceIterator.hasNext()) {
            XdmNode xdmNode2 = (XdmNode)xdmSequenceIterator.next();
            if (xdmNode2.getNodeKind() != XdmNodeKind.ELEMENT && xdmNode2.getNodeKind() != XdmNodeKind.TEXT) continue;
            string = string + xdmNode2.getStringValue();
        }
        return string;
    }

    private String decodeBase64(XdmNode xdmNode, String string) {
        String string2 = this.extractText(xdmNode);
        byte[] byArray = Base64.decode(string2);
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw XProcException.stepError(10, unsupportedEncodingException);
        }
    }

    private void doFile() {
        String string = this.overrideContentType;
        if (string == null) {
            string = "application/octet-stream";
        }
        String string2 = HttpUtils.getCharset(string, "ISO-8859-1");
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(this.requestURI);
        try {
            File file = new File(this.requestURI.getPath());
            FileInputStream fileInputStream = null;
            fileInputStream = new FileInputStream(file);
            if (this.xmlContentType(string)) {
                this.readBodyContentPart(treeWriter, fileInputStream, string, string2);
            } else {
                treeWriter.addStartElement(XProcConstants.c_body);
                treeWriter.addAttribute(_content_type, string);
                if (!this.xmlContentType(string) && !this.textContentType(string)) {
                    treeWriter.addAttribute(_encoding, "base64");
                }
                treeWriter.startContent();
                this.readBodyContentPart(treeWriter, fileInputStream, string, string2);
                treeWriter.addEndElement();
            }
            treeWriter.endDocument();
            XdmNode xdmNode = treeWriter.getResult();
            this.result.write(xdmNode);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new XProcException(fileNotFoundException);
        }
        catch (SaxonApiException saxonApiException) {
            throw new XProcException(saxonApiException);
        }
        catch (IOException iOException) {
            throw new XProcException(iOException);
        }
    }

    private class MessageBytes {
        int chunkSize = 8192;
        byte[] byteContent = new byte[this.chunkSize];
        int pos = 0;

        public void append(String string) {
            try {
                byte[] byArray = string.getBytes("US-ASCII");
                this.append(byArray, byArray.length);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new XProcException(unsupportedEncodingException);
            }
        }

        public void append(byte[] byArray, int n) {
            if (this.pos + byArray.length > this.byteContent.length) {
                byte[] byArray2 = new byte[this.byteContent.length + byArray.length + this.chunkSize];
                System.arraycopy(this.byteContent, 0, byArray2, 0, this.byteContent.length);
                this.byteContent = byArray2;
            }
            System.arraycopy(byArray, 0, this.byteContent, this.pos, byArray.length);
            this.pos += byArray.length;
        }

        public byte[] content() {
            byte[] byArray = new byte[this.pos];
            System.arraycopy(this.byteContent, 0, byArray, 0, this.pos);
            return byArray;
        }
    }
}

