/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.JsrInstruction;
import org.apache.bcel.generic.VariableLengthInstruction;
import org.apache.bcel.generic.Visitor;

public class JSR
extends JsrInstruction
implements VariableLengthInstruction {
    JSR() {
    }

    public JSR(InstructionHandle target) {
        super((short)168, target);
    }

    public void dump(DataOutputStream out) throws IOException {
        this.index = this.getTargetOffset();
        if (this.opcode == 168) {
            super.dump(out);
        } else {
            this.index = this.getTargetOffset();
            out.writeByte(this.opcode);
            out.writeInt(this.index);
        }
    }

    protected int updatePosition(int offset, int max_offset) {
        int i = this.getTargetOffset();
        this.position += offset;
        if (Math.abs(i) >= Short.MAX_VALUE - max_offset) {
            this.opcode = (short)201;
            this.length = (short)5;
            return 2;
        }
        return 0;
    }

    public void accept(Visitor v) {
        v.visitStackProducer(this);
        v.visitVariableLengthInstruction(this);
        v.visitBranchInstruction(this);
        v.visitJsrInstruction(this);
        v.visitJSR(this);
    }
}

