/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.property;

import java.util.Enumeration;
import java.util.Vector;

public class RegexUtil {
    private static Vector parseSelectString(String input) {
        Vector<SelectNode> nodes = new Vector<SelectNode>();
        StringBuffer buf = new StringBuffer();
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\\') {
                if (buf.length() > 0) {
                    nodes.addElement(new StringSelectNode(buf.toString()));
                    buf.setLength(0);
                }
                while (i + 1 < c.length && Character.isDigit(c[i + 1])) {
                    buf.append(c[i + 1]);
                    ++i;
                }
                int groupNum = Integer.parseInt(buf.toString());
                buf.setLength(0);
                nodes.addElement(new GroupSelectNode(groupNum));
                continue;
            }
            buf.append(c[i]);
        }
        if (buf.length() > 0) {
            nodes.addElement(new StringSelectNode(buf.toString()));
            buf.setLength(0);
        }
        return nodes;
    }

    public static String select(String select, Vector groups) {
        Vector nodes = RegexUtil.parseSelectString(select);
        StringBuffer buf = new StringBuffer();
        Enumeration e = nodes.elements();
        SelectNode node = null;
        while (e.hasMoreElements()) {
            node = (SelectNode)e.nextElement();
            buf.append(node.select(groups));
        }
        return buf.toString();
    }

    private static class StringSelectNode
    implements SelectNode {
        private String text;

        public StringSelectNode(String text) {
            this.text = text;
        }

        public String select(Vector groups) {
            return this.text;
        }

        public String toString() {
            return "string: " + this.text;
        }
    }

    private static class GroupSelectNode
    implements SelectNode {
        private int groupNumber;

        public GroupSelectNode(int groupNumber) {
            this.groupNumber = groupNumber;
        }

        public String select(Vector groups) {
            if (this.groupNumber < groups.size()) {
                return (String)groups.elementAt(this.groupNumber);
            }
            return "\\" + this.groupNumber;
        }

        public String toString() {
            return "group: " + this.groupNumber;
        }
    }

    private static interface SelectNode {
        public String select(Vector var1);
    }
}

