/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.model;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcData;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.Binding;
import com.xmlcalabash.model.Catch;
import com.xmlcalabash.model.Choose;
import com.xmlcalabash.model.CompoundStep;
import com.xmlcalabash.model.EmptyBinding;
import com.xmlcalabash.model.EndPoint;
import com.xmlcalabash.model.Environment;
import com.xmlcalabash.model.Input;
import com.xmlcalabash.model.Option;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.Parameter;
import com.xmlcalabash.model.PipeNameBinding;
import com.xmlcalabash.model.Pipeline;
import com.xmlcalabash.model.Port;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.model.When;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;

public class DeclareStep
extends CompoundStep {
    protected boolean psviRequired = false;
    protected String xpathVersion = "2.0";
    private QName declaredType = null;
    private boolean atomic = true;
    private Pipeline implementation = null;
    protected Hashtable<QName, DeclareStep> declaredSteps = new Hashtable();
    protected HashSet<String> importedLibs = new HashSet();
    private DeclareStep parentDecl = null;
    private Vector<XdmNode> rest = null;
    private HashSet<String> excludedInlineNamespaces = null;
    private boolean bodyParsed = false;

    public DeclareStep(XProcRuntime xproc, XdmNode node, String name) {
        super(xproc, node, XProcConstants.p_declare_step, name);
    }

    protected void setXmlContent(Vector<XdmNode> nodes) {
        this.rest = nodes;
    }

    protected Vector<XdmNode> getXmlContent() {
        return this.rest;
    }

    public boolean getBodyParsed() {
        return this.bodyParsed;
    }

    public void setBodyParsed(boolean parsed) {
        this.bodyParsed = parsed;
    }

    public void setPsviRequired(boolean psvi) {
        this.psviRequired = psvi;
    }

    public void setXPathVersion(String version) {
        this.xpathVersion = version;
    }

    public void setDeclaredType(QName type) {
        this.declaredType = type;
    }

    public void setExcludeInlineNamespaces(HashSet<String> uris) {
        this.excludedInlineNamespaces = uris;
    }

    public HashSet<String> getExcludeInlineNamespaces() {
        return this.excludedInlineNamespaces;
    }

    public void setAtomic(boolean isAtomic) {
        this.atomic = isAtomic;
    }

    public boolean isAtomic() {
        return this.atomic;
    }

    @Override
    public boolean isPipeline() {
        return !this.atomic;
    }

    @Override
    public QName getDeclaredType() {
        return this.declaredType;
    }

    public void setParentDecl(DeclareStep decl) {
        this.parentDecl = decl;
    }

    public void setPipeline(Pipeline pipeline) {
        this.implementation = pipeline;
    }

    @Override
    public Pipeline getPipeline() {
        return this.implementation;
    }

    public void declareStep(QName type, DeclareStep step) {
        if (this.declaredSteps.containsKey(type)) {
            throw new XProcException((Step)step, "Duplicate step type");
        }
        this.declaredSteps.put(type, step);
    }

    public boolean imported(String uri) {
        if (this.importedLibs.contains(uri)) {
            return true;
        }
        if (this.parentDecl == null) {
            return false;
        }
        return this.parentDecl.imported(uri);
    }

    public void addImport(String uri) {
        this.importedLibs.add(uri);
    }

    @Override
    public DeclareStep getDeclaration() {
        return this.getStepDeclaration(this.declaredType);
    }

    public DeclareStep getStepDeclaration(QName type) {
        if (this.declaredSteps.containsKey(type)) {
            return this.declaredSteps.get(type);
        }
        if (this.parentDecl != null) {
            return this.parentDecl.getStepDeclaration(type);
        }
        return this.runtime.getBuiltinDeclaration(type);
    }

    public Collection<DeclareStep> getStepDeclarations() {
        return this.declaredSteps.values();
    }

    public void setupEnvironment() {
        this.setEnvironment(new Environment(this));
    }

    @Override
    protected void patchEnvironment(Environment env) {
        if (!this.atomic) {
            int count = 0;
            Input defin = null;
            boolean foundPrimary = false;
            for (Input input : this.inputs) {
                if (input.getPort().startsWith("|") || input.getParameterInput()) continue;
                ++count;
                foundPrimary |= input.getPrimary();
                if (!input.getPrimary() && input.getPrimarySet() || defin != null && !input.getPrimary()) continue;
                defin = input;
            }
            if (count == 1 || foundPrimary) {
                env.setDefaultReadablePort(defin);
            }
        }
    }

    private int logLevel(Logger logger) {
        Logger log = logger;
        Level level = null;
        if (log != null) {
            level = log.getLevel();
        }
        while (log != null && level == null) {
            log = log.getParent();
            level = log.getLevel();
        }
        if (level == null) {
            return Level.SEVERE.intValue();
        }
        return level.intValue();
    }

    public void setup() {
        XProcRuntime runtime = this.runtime;
        DeclareStep decl = this;
        boolean debug = runtime.getDebug();
        if (decl.psviRequired && !runtime.getPSVISupported()) {
            throw XProcException.dynamicError(22);
        }
        if (debug && this.logLevel(this.logger) <= Level.FINEST.intValue()) {
            System.err.println("=====================================================================================");
            System.err.println("Before augment:");
            decl.dump();
        }
        boolean seenPrimaryDocument = false;
        boolean seenPrimaryParameter = false;
        for (Input input : decl.inputs()) {
            if (input.getPort().startsWith("|") || !input.getPrimary()) continue;
            if (seenPrimaryDocument && !input.getParameterInput()) {
                this.error("At most one primary document input port is allowed", XProcConstants.staticError(30));
            }
            if (seenPrimaryParameter && input.getParameterInput()) {
                this.error("At most one primary parameter input port is allowed", XProcConstants.staticError(30));
            }
            if (input.getParameterInput()) {
                seenPrimaryParameter = true;
                continue;
            }
            seenPrimaryDocument = true;
        }
        boolean seenPrimary = false;
        for (Output output : decl.outputs()) {
            if (output.getPort().endsWith("|") || !output.getPrimary()) continue;
            if (seenPrimary) {
                this.error("At most one primary output port is allowed", XProcConstants.staticError(30));
            }
            seenPrimary = true;
        }
        if (debug && this.logLevel(this.logger) <= Level.FINEST.intValue()) {
            System.err.println("After binding pipeline inputs and outputs:");
            decl.dump();
        }
        if (this.subpipeline.size() == 0) {
            this.error("Declared step has no subpipeline, but is not known.", XProcConstants.staticError(100));
            return;
        }
        decl.augment();
        if (debug && this.logLevel(this.logger) <= Level.FINEST.intValue()) {
            System.err.println("After augment:");
            decl.dump();
        }
        decl.setupEnvironment();
        if (!decl.valid()) {
            if (this.logLevel(this.logger) <= Level.INFO.intValue()) {
                decl.dump();
            }
            return;
        }
        if (debug && this.logLevel(this.logger) <= Level.FINEST.intValue()) {
            System.err.println("After valid:");
            decl.dump();
        }
        if (!decl.orderSteps()) {
            if (this.logLevel(this.logger) <= Level.INFO.intValue()) {
                decl.dump();
            }
            return;
        }
        if (debug && this.logLevel(this.logger) <= Level.FINEST.intValue()) {
            System.err.println("After ordering:");
            decl.dump();
        }
        HashSet<QName> vars = new HashSet<QName>();
        this.checkDuplicateVars(vars);
        if (!this.checkOutputBindings()) {
            if (this.logLevel(this.logger) <= Level.INFO.intValue()) {
                decl.dump();
            }
            return;
        }
    }

    protected boolean checkOutputBindings() {
        PipeNameBinding b;
        Output output;
        HashSet<Output> uboutputs = new HashSet<Output>();
        for (Step substep : this.subpipeline) {
            for (Output output2 : substep.outputs()) {
                if (output2.getBinding().size() != 0 || output2.getPort().endsWith("|") || output2.getPort().startsWith("#")) continue;
                uboutputs.add(output2);
            }
        }
        for (Input input : this.inputs()) {
            for (Binding binding : input.bindings) {
                if (binding.getBindingType() != 1 || !uboutputs.contains(output = this.env.readablePort((b = (PipeNameBinding)binding).getStep(), b.getPort()))) continue;
                uboutputs.remove(output);
            }
        }
        for (Option option : this.options()) {
            for (Binding binding : option.bindings) {
                if (binding.getBindingType() != 1 || !uboutputs.contains(output = this.env.readablePort((b = (PipeNameBinding)binding).getStep(), b.getPort()))) continue;
                uboutputs.remove(output);
            }
        }
        for (Parameter param : this.parameters()) {
            for (Binding binding : param.bindings) {
                if (binding.getBindingType() != 1 || !uboutputs.contains(output = this.env.readablePort((b = (PipeNameBinding)binding).getStep(), b.getPort()))) continue;
                uboutputs.remove(output);
            }
        }
        for (Step substep : this.subpipeline) {
            substep.checkForBindings(uboutputs);
        }
        boolean valid = true;
        for (Output output3 : uboutputs) {
            if (!output3.getPrimary()) continue;
            this.error("Unbound primary output: " + output3, new QName("", "ERR"));
            valid = false;
        }
        return valid;
    }

    @Override
    protected boolean checkBinding(Input input) {
        XProcData data;
        boolean valid = true;
        if (input.getBinding().size() == 0) {
            Step substep;
            Port port = null;
            if ("#xpath-context".equals(input.getPort())) {
                if (this instanceof When) {
                    port = new Port(this.runtime, this.getNode());
                    port.setStep(this.parent);
                    port.setPort("#xpath-context");
                } else {
                    port = this.env.getDefaultReadablePort();
                }
            }
            if ("#iteration-source".equals(input.getPort()) || "#viewport-source".equals(input.getPort())) {
                port = this.env.getParent().getDefaultReadablePort();
            }
            Vector<Binding> declBinding = null;
            if (XProcConstants.p_pipeline.equals((Object)this.getType())) {
                DeclareStep decl = this.declaration;
                for (Input dinput : decl.inputs()) {
                    if (!dinput.getPort().equals(input.getPort())) continue;
                    declBinding = dinput.getBinding();
                }
            }
            if (input.getPrimary() && input.getPort().startsWith("|") && this.subpipeline.size() > 0 && (port = (substep = (Step)this.subpipeline.get(this.subpipeline.size() - 1)).getDefaultOutput()) == null) {
                this.error("Output port '" + input.getPort().substring(1) + "' on " + this.getStep() + " unbound", XProcConstants.staticError(5));
                valid = false;
            }
            EndPoint output = null;
            if (input.getPort().startsWith("|") && this.parent != null) {
                String oport = input.getPort().substring(1);
                output = this.getOutput(oport);
            }
            if (output != null && output.getBinding().size() > 0) {
                for (Binding binding : output.getBinding()) {
                    input.addBinding(binding);
                }
                output.clearBindings();
            } else if (port == null) {
                if (declBinding != null) {
                    for (Binding binding : declBinding) {
                        input.addBinding(binding);
                    }
                } else if (input.getParameterInput()) {
                    EmptyBinding empty = new EmptyBinding();
                    input.addBinding(empty);
                }
            } else {
                String stepName = port.getStep().getName();
                String portName = port.getPort();
                PipeNameBinding binding = new PipeNameBinding(this.runtime, this.node);
                binding.setStep(stepName);
                binding.setPort(portName);
                input.addBinding(binding);
            }
        } else if (input.getParameterInput() && (data = this.runtime.getXProcData()).getDepth() == 0 && input.getBinding().size() > 0) {
            throw XProcException.staticError(35, input.getNode(), "You must not specify bindings in this context.");
        }
        for (Binding binding : input.getBinding()) {
            Output output;
            PipeNameBinding pipe;
            Step step;
            if (binding.getBindingType() != 1 || (step = this.env.visibleStep((pipe = (PipeNameBinding)binding).getStep())) instanceof Catch && "error".equals(pipe.getPort()) || step instanceof Choose && "#xpath-context".equals(pipe.getPort()) || (output = this.env.readablePort(pipe.getStep(), pipe.getPort())) != null) continue;
            this.error("Unreadable port: " + pipe.getPort() + " on " + pipe.getStep(), XProcException.err_E0001);
            valid = false;
        }
        return valid;
    }
}

