/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.Controller;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.tree.AttributeCollection;
import com.nwalsh.saxon.CopyEmitter;
import java.util.Stack;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;

public class NumberLinesEmitter
extends CopyEmitter {
    protected Stack elementStack = new Stack();
    protected int lineNumber = 0;
    protected boolean firstElement = true;
    protected static String foURI = "http://www.w3.org/1999/XSL/Format";
    protected static String xhURI = "http://www.w3.org/1999/xhtml";
    protected int startinglinenumber = 1;
    protected int modulus = 5;
    protected int width = 3;
    protected String separator = " ";
    protected boolean foStylesheet = false;

    public NumberLinesEmitter(Controller controller, NamePool namePool, int startingLineNumber, int modulus, int width, String separator, boolean foStylesheet) {
        super(controller, namePool);
        this.modulus = modulus;
        this.startinglinenumber = startingLineNumber;
        this.width = width;
        this.separator = separator;
        this.foStylesheet = foStylesheet;
    }

    public void characters(char[] chars, int start, int len) throws TransformerException {
        this.firstElement = false;
        if (this.lineNumber == 0) {
            this.lineNumber = this.startinglinenumber;
            this.formatLineNumber(this.lineNumber);
        }
        char[] newChars = new char[len];
        int pos = 0;
        for (int count = start; count < start + len; ++count) {
            if (chars[count] == '\n') {
                StartElementInfo elem;
                if (pos > 0) {
                    this.rtfEmitter.characters(newChars, 0, pos);
                    pos = 0;
                }
                Stack<StartElementInfo> tempStack = new Stack<StartElementInfo>();
                while (!this.elementStack.empty()) {
                    elem = (StartElementInfo)this.elementStack.pop();
                    this.rtfEmitter.endElement(elem.getNameCode());
                    tempStack.push(elem);
                }
                newChars[pos++] = chars[count];
                this.rtfEmitter.characters(newChars, 0, pos);
                pos = 0;
                this.formatLineNumber(++this.lineNumber);
                while (!tempStack.empty()) {
                    elem = (StartElementInfo)tempStack.pop();
                    AttributeCollection attr = (AttributeCollection)elem.getAttributes();
                    AttributeCollection newAttr = new AttributeCollection(this.namePool);
                    for (int acount = 0; acount < attr.getLength(); ++acount) {
                        String localName = attr.getLocalName(acount);
                        int nameCode = attr.getNameCode(acount);
                        String type = attr.getType(acount);
                        String value = attr.getValue(acount);
                        String uri = attr.getURI(acount);
                        String prefix = "";
                        if (localName.indexOf(58) > 0) {
                            prefix = localName.substring(0, localName.indexOf(58));
                            localName = localName.substring(localName.indexOf(58) + 1);
                        }
                        if (uri.equals("") && (this.foStylesheet && localName.equals("id") || !this.foStylesheet && (localName.equals("id") || localName.equals("name")))) continue;
                        newAttr.addAttribute(prefix, uri, localName, type, value);
                    }
                    this.rtfEmitter.startElement(elem.getNameCode(), (Attributes)newAttr, elem.getNamespaces(), elem.getNSCount());
                    this.elementStack.push(elem);
                }
                continue;
            }
            newChars[pos++] = chars[count];
        }
        if (pos > 0) {
            this.rtfEmitter.characters(newChars, 0, pos);
            pos = 0;
        }
    }

    protected void formatLineNumber(int lineNumber) throws TransformerException {
        char ch = '\u00a0';
        String lno = "";
        if (lineNumber == 1 || this.modulus >= 1 && lineNumber % this.modulus == 0) {
            lno = "" + lineNumber;
        }
        while (lno.length() < this.width) {
            lno = ch + lno;
        }
        lno = lno + this.separator;
        char[] chars = new char[lno.length()];
        for (int count = 0; count < lno.length(); ++count) {
            chars[count] = lno.charAt(count);
        }
        this.characters(chars, 0, lno.length());
    }

    public void endElement(int nameCode) throws TransformerException {
        if (!this.elementStack.empty()) {
            this.elementStack.pop();
        }
        this.rtfEmitter.endElement(nameCode);
    }

    public void startElement(int nameCode, Attributes attributes, int[] namespaces, int nscount) throws TransformerException {
        if (!this.skipThisElement(nameCode)) {
            StartElementInfo sei = new StartElementInfo(nameCode, attributes, namespaces, nscount);
            this.elementStack.push(sei);
        }
        this.firstElement = false;
        this.rtfEmitter.startElement(nameCode, attributes, namespaces, nscount);
    }

    protected boolean skipThisElement(int nameCode) {
        if (this.firstElement) {
            int thisFingerprint = this.namePool.getFingerprint(nameCode);
            int foBlockFingerprint = this.namePool.getFingerprint(foURI, "block");
            int htmlPreFingerprint = this.namePool.getFingerprint("", "pre");
            int htmlDivFingerprint = this.namePool.getFingerprint("", "div");
            int xhtmlPreFingerprint = this.namePool.getFingerprint(xhURI, "pre");
            int xhtmlDivFingerprint = this.namePool.getFingerprint(xhURI, "div");
            if (this.foStylesheet && thisFingerprint == foBlockFingerprint || !this.foStylesheet && (thisFingerprint == htmlPreFingerprint || thisFingerprint == htmlDivFingerprint || thisFingerprint == xhtmlPreFingerprint || thisFingerprint == xhtmlDivFingerprint)) {
                return true;
            }
        }
        return false;
    }

    private class StartElementInfo {
        private int _nameCode;
        Attributes _attributes;
        int[] _namespaces;
        int _nscount;

        public StartElementInfo(int nameCode, Attributes attributes, int[] namespaces, int nscount) {
            this._nameCode = nameCode;
            this._attributes = attributes;
            this._namespaces = namespaces;
            this._nscount = nscount;
        }

        public int getNameCode() {
            return this._nameCode;
        }

        public Attributes getAttributes() {
            return this._attributes;
        }

        public int[] getNamespaces() {
            return this._namespaces;
        }

        public int getNSCount() {
            return this._nscount;
        }
    }
}

