/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NamespaceException;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.AttributeImpl;
import com.icl.saxon.tree.DocumentImpl;
import com.icl.saxon.tree.ElementImpl;
import com.icl.saxon.tree.NamespaceImpl;
import com.icl.saxon.tree.NodeImpl;
import com.icl.saxon.tree.ParentNodeImpl;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementWithAttributes
extends ElementImpl
implements Element,
NamedNodeMap {
    protected AttributeCollection attributeList;
    protected int[] namespaceList = null;

    public void initialise(int n, AttributeCollection attributeCollection, NodeInfo nodeInfo, String string, int n2, int n3) {
        this.nameCode = n;
        this.attributeList = attributeCollection;
        this.parent = (ParentNodeImpl)nodeInfo;
        this.sequence = n3;
        this.root = (DocumentImpl)nodeInfo.getDocumentRoot();
        this.root.setLineNumber(n3, n2);
        this.root.setSystemId(n3, string);
    }

    public void setNamespaceDeclarations(int[] nArray, int n) {
        this.namespaceList = new int[n];
        System.arraycopy(nArray, 0, this.namespaceList, 0, n);
    }

    public short getURICodeForPrefix(String string) throws NamespaceException {
        if (string.equals("xml")) {
            return 1;
        }
        NamePool namePool = this.getNamePool();
        short s = namePool.getCodeForPrefix(string);
        if (s == -1) {
            throw new NamespaceException(string);
        }
        return this.getURICodeForPrefixCode(s);
    }

    private short getURICodeForPrefixCode(int n) throws NamespaceException {
        if (this.namespaceList != null) {
            int n2 = 0;
            while (n2 < this.namespaceList.length) {
                if (this.namespaceList[n2] >> 16 == n) {
                    return (short)(this.namespaceList[n2] & 0xFFFF);
                }
                ++n2;
            }
        }
        NodeImpl nodeImpl = this.parent;
        while (true) {
            if (nodeImpl.getNodeType() == 9) {
                if (n == 0) {
                    return 0;
                }
                throw new NamespaceException(this.getNamePool().getPrefixFromNamespaceCode(n << 16));
            }
            if (nodeImpl instanceof ElementWithAttributes) {
                return ((ElementWithAttributes)nodeImpl).getURICodeForPrefixCode(n);
            }
            nodeImpl = (NodeImpl)nodeImpl.getParentNode();
        }
    }

    public String getPrefixForURI(String string) {
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        NamePool namePool = this.getNamePool();
        short s = namePool.getCodeForURI(string);
        if (s < 0) {
            return null;
        }
        return this.getPrefixForURICode(s);
    }

    private String getPrefixForURICode(int n) {
        if (this.namespaceList != null) {
            int n2 = 0;
            while (n2 < this.namespaceList.length) {
                if ((this.namespaceList[n2] & 0xFFFF) == n) {
                    return this.getNamePool().getPrefixFromNamespaceCode(this.namespaceList[n2]);
                }
                ++n2;
            }
        }
        NodeImpl nodeImpl = this.parent;
        while (!(nodeImpl instanceof DocumentInfo)) {
            if (nodeImpl instanceof ElementWithAttributes) {
                return ((ElementWithAttributes)nodeImpl).getPrefixForURICode(n);
            }
            nodeImpl = (NodeImpl)nodeImpl.getParentNode();
        }
        return null;
    }

    public void addNamespaceNodes(ElementImpl elementImpl, Vector vector, boolean bl) {
        int n;
        if (this.namespaceList != null) {
            n = vector.size();
            int n2 = 0;
            while (n2 < this.namespaceList.length) {
                int n3 = this.namespaceList[n2];
                int n4 = n3 >> 16;
                boolean bl2 = false;
                int n5 = 0;
                while (n5 < n) {
                    NamespaceImpl namespaceImpl;
                    if ((namespaceImpl = (NamespaceImpl)vector.elementAt(n5++)).getNamespaceCode() != n4) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    vector.addElement(new NamespaceImpl(elementImpl, n3, vector.size() + 1));
                }
                ++n2;
            }
        }
        if (this.parent.getNodeType() != 9) {
            ((ElementImpl)this.parent).addNamespaceNodes(elementImpl, vector, false);
        }
        if (bl) {
            n = 65537;
            vector.addElement(new NamespaceImpl(this, n, vector.size() + 1));
        }
    }

    public void outputNamespaceNodes(Outputter outputter, boolean bl) throws TransformerException {
        if (this.namespaceList != null) {
            int n = 0;
            while (n < this.namespaceList.length) {
                outputter.writeNamespaceDeclaration(this.namespaceList[n]);
                ++n;
            }
        }
        if (bl && this.parent.getNodeType() != 9) {
            ((ElementImpl)this.parent).outputNamespaceNodes(outputter, true);
        }
    }

    protected int[] getNamespaceCodes() {
        Vector vector = new Vector();
        this.addNamespaceNodes(this, vector, true);
        int[] nArray = new int[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            NamespaceImpl namespaceImpl = (NamespaceImpl)vector.elementAt(n);
            nArray[n] = namespaceImpl.getNamespaceCode();
            ++n;
        }
        return nArray;
    }

    public AttributeCollection getAttributeList() {
        return this.attributeList;
    }

    public boolean hasAttributes() {
        return this.attributeList.getLength() > 0;
    }

    public String getAttributeValue(String string, String string2) {
        return this.attributeList.getValue(string, string2);
    }

    public String getAttributeValue(String string) {
        return this.attributeList.getValue(string);
    }

    public String getAttributeValue(int n) {
        return this.attributeList.getValueByFingerprint(n);
    }

    public void setAttribute(String string, String string2) throws DOMException {
        this.disallowUpdate();
    }

    public void copy(Outputter outputter, boolean bl) throws TransformerException {
        int n = this.getNameCode();
        outputter.writeStartTag(n);
        this.outputNamespaceNodes(outputter, bl);
        int n2 = 0;
        while (n2 < this.attributeList.getLength()) {
            outputter.writeAttribute(this.attributeList.getNameCode(n2), this.attributeList.getValue(n2));
            ++n2;
        }
        NodeImpl nodeImpl = (NodeImpl)this.getFirstChild();
        while (nodeImpl != null) {
            if (nodeImpl instanceof ElementImpl) {
                ((ElementImpl)nodeImpl).copy(outputter, false);
            } else {
                nodeImpl.copy(outputter);
            }
            nodeImpl = (NodeImpl)nodeImpl.getNextSibling();
        }
        outputter.writeEndTag(n);
    }

    public String getAttribute(String string) {
        int n = this.attributeList.getIndex(string);
        if (n < 0) {
            return "";
        }
        return this.attributeList.getValue(n);
    }

    public NamedNodeMap getAttributes() {
        return this;
    }

    public void removeAttribute(String string) {
        this.setAttribute(string, null);
    }

    public Attr getAttributeNode(String string) {
        int n = this.getAttributeList().getIndex(string);
        if (n < 0) {
            return null;
        }
        return new AttributeImpl(this, n);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public String getAttributeNS(String string, String string2) {
        String string3 = this.getAttributeValue(string, string2);
        return string3 == null ? "" : string3;
    }

    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        this.disallowUpdate();
    }

    public void removeAttributeNS(String string, String string2) throws DOMException {
        this.disallowUpdate();
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        int n = this.attributeList.getIndex(string, string2);
        if (n < 0) {
            return null;
        }
        return new AttributeImpl(this, n);
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public boolean hasAttribute(String string) {
        return this.attributeList.getIndex(string) >= 0;
    }

    public boolean hasAttributeNS(String string, String string2) {
        return this.getAttributeValue(string, string2) != null;
    }

    public Node getNamedItem(String string) {
        return this.getAttributeNode(string);
    }

    public Node setNamedItem(Node node) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Node removeNamedItem(String string) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Node item(int n) {
        if (n < 0 || n >= this.attributeList.getLength()) {
            return null;
        }
        return new AttributeImpl(this, n);
    }

    public int getLength() {
        return this.attributeList.getLength();
    }

    public Node getNamedItemNS(String string, String string2) {
        return this.getAttributeNodeNS(string, string2);
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        this.disallowUpdate();
        return null;
    }
}

