/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.text.Collator;
import java.util.Locale;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.PriorityQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FieldDocSortedHitQueue
extends PriorityQueue<FieldDoc> {
    volatile SortField[] fields = null;
    volatile Collator[] collators = null;

    FieldDocSortedHitQueue(int size) {
        this.initialize(size);
    }

    void setFields(SortField[] fields) {
        this.fields = fields;
        this.collators = this.hasCollators(fields);
    }

    SortField[] getFields() {
        return this.fields;
    }

    private Collator[] hasCollators(SortField[] fields) {
        if (fields == null) {
            return null;
        }
        Collator[] ret = new Collator[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            Locale locale = fields[i].getLocale();
            if (locale == null) continue;
            ret[i] = Collator.getInstance(locale);
        }
        return ret;
    }

    @Override
    protected final boolean lessThan(FieldDoc docA, FieldDoc docB) {
        int n = this.fields.length;
        int c = 0;
        for (int i = 0; i < n && c == 0; ++i) {
            int type = this.fields[i].getType();
            if (type == 3) {
                String s1 = (String)((Object)docA.fields[i]);
                String s2 = (String)((Object)docB.fields[i]);
                c = s1 == null ? (s2 == null ? 0 : -1) : (s2 == null ? 1 : (this.fields[i].getLocale() == null ? s1.compareTo(s2) : this.collators[i].compare(s1, s2)));
            } else {
                c = docA.fields[i].compareTo(docB.fields[i]);
                if (type == 0) {
                    c = -c;
                }
            }
            if (!this.fields[i].getReverse()) continue;
            c = -c;
        }
        if (c == 0) {
            return docA.doc > docB.doc;
        }
        return c > 0;
    }
}

