// re2rust $INPUT -o $OUTPUT

#[derive(Debug, PartialEq)]
struct SemVer(u32, u32, u32); // version: (major, minor, patch)

fn s2n(str: &[u8]) -> u32 { // convert a pre-parsed string to a number
    let mut n = 0;
    for i in str { n = n * 10 + *i as u32 - 48; }
    return n;
}

fn parse(str: &[u8]) -> Option<SemVer> {
    let (mut cur, mut mar) = (0, 0);

    // User-defined tag variables that are available in semantic action.
    let (t1, mut t2, t3, t4, t5);

    // Autogenerated tag variables used by the lexer to track tag values.
    const NONE: usize = std::usize::MAX;
    /*!stags:re2c format = 'let mut @@{tag} = NONE;'; */

    /*!re2c
        re2c:define:YYCTYPE     = u8;
        re2c:define:YYPEEK      = "*str.get_unchecked(cur)";
        re2c:define:YYSKIP      = "cur += 1;";
        re2c:define:YYBACKUP    = "mar = cur;";
        re2c:define:YYRESTORE   = "cur = mar;";
        re2c:define:YYSTAGP     = "@@{tag} = cur;";
        re2c:define:YYSTAGN     = "@@{tag} = NONE;";
        re2c:define:YYSHIFTSTAG = "@@{tag} -= -@@{shift}isize as usize;";
        re2c:yyfill:enable = 0;
        re2c:tags = 1;

        num = [0-9]+;

        @t1 num @t2 "." @t3 num @t4 ("." @t5 num)? [\x00] {
            let major = s2n(&str[t1..t2]);
            let minor = s2n(&str[t3..t4]);
            let patch = if t5 != NONE {s2n(&str[t5..cur - 1])} else {0};
            return Some(SemVer(major, minor, patch));
        }
        * { return None; }
    */
}

fn main() {
    assert_eq!(parse(b"23.34\0"), Some(SemVer(23, 34, 0)));
    assert_eq!(parse(b"1.2.99999\0"), Some(SemVer(1, 2, 99999)));
    assert_eq!(parse(b"1.a\0"), None);
}
