/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class UseAttributeSets
extends Instruction {
    private AttributeSet[] attributeSets;

    public UseAttributeSets(AttributeSet[] sets) {
        this.attributeSets = sets;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        return this;
    }

    public Expression copy() {
        throw new UnsupportedOperationException("UseAttributeSets.copy()");
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        return this;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return NodeKindTest.ATTRIBUTE;
    }

    public int getIntrinsicDependencies() {
        int d = 0;
        for (int i = 0; i < this.attributeSets.length; ++i) {
            AttributeSet as = this.attributeSets[i];
            d |= as.getFocusDependencies();
        }
        return d;
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        AttributeSet.expand(this.attributeSets, context);
        return null;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("useAttributeSets");
        for (int i = 0; i < this.attributeSets.length; ++i) {
            AttributeSet as = this.attributeSets[i];
            out.startElement("useAttributeSet");
            out.emitAttribute("name", as.getObjectName().getDisplayName());
            out.endElement();
        }
        out.endElement();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UseAttributeSets)) {
            return false;
        }
        if (this.attributeSets.length != ((UseAttributeSets)obj).attributeSets.length) {
            return false;
        }
        for (int i = 0; i < this.attributeSets.length; ++i) {
            AttributeSet as0 = this.attributeSets[i];
            AttributeSet as1 = ((UseAttributeSets)obj).attributeSets[i];
            if (as0.getObjectName().equals(as1.getObjectName())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = -2042480871;
        for (int i = 0; i < this.attributeSets.length; ++i) {
            h ^= this.attributeSets[i].getObjectName().hashCode();
        }
        return h;
    }
}

