/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

public class HttpUtils {
    protected HttpUtils() {
    }

    public static String baseContentType(String string) {
        if (string != null && string.matches("(^.*)[ \t]*;.*$")) {
            return string.replaceAll("(^.*)[ \t]*;.*$", "$1");
        }
        return string;
    }

    public static boolean xmlContentType(String string) {
        String string2 = HttpUtils.baseContentType(string);
        return string2 != null && ("application/xml".equals(string2) || "text/xml".equals(string2) || string2.endsWith("+xml"));
    }

    public static boolean jsonContentType(String string) {
        String string2 = HttpUtils.baseContentType(string);
        return string2 != null && ("application/json".equals(string2) || "text/json".equals(string2));
    }

    public static boolean textContentType(String string) {
        return string != null && string.startsWith("text/");
    }

    public static String getCharset(String string, String string2) {
        String string3 = HttpUtils.getCharset(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public static String getCharset(String string) {
        String string2 = null;
        if (string != null && string.matches("^.*;[ \t]*charset=([^ \t]+).*$") && ((string2 = string.replaceAll("^.*;[ \t]*charset=([^ \t]+).*$", "$1")).startsWith("\"") || string2.startsWith("'"))) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        return string2;
    }
}

