/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.config.FoProcessor;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.URIUtils;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

public class XSLFormatter
extends DefaultStep {
    private static final QName _href = new QName("", "href");
    private static final QName _content_type = new QName("", "content-type");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private Properties options = new Properties();

    public XSLFormatter(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void setParameter(QName name, RuntimeValue value) {
        if (!"".equals(name.getNamespaceURI())) {
            throw new XProcException(this.step.getNode(), "The p:xsl-formatter parameters are in no namespace: " + name + " (" + name.getNamespaceURI() + ")");
        }
        this.options.setProperty(name.getLocalName(), value.getString());
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        Vector<String> foClasses = new Vector<String>();
        if (this.runtime.getConfiguration().foProcessor != null) {
            foClasses.add(this.runtime.getConfiguration().foProcessor);
        }
        foClasses.add("com.xmlcalabash.util.FoFOP");
        FoProcessor provider = null;
        Throwable pexcept = null;
        for (String className : foClasses) {
            if (provider != null) continue;
            try {
                provider = (FoProcessor)Class.forName(className).newInstance();
                provider.initialize(this.runtime, this.step, this.options);
            }
            catch (NoClassDefFoundError ncdfe) {
                pexcept = ncdfe;
                provider = null;
            }
            catch (Exception e) {
                pexcept = e;
                provider = null;
            }
        }
        if (provider == null) {
            throw new XProcException(this.step.getNode(), "Failed to instantiate FO provider", pexcept);
        }
        String contentType = null;
        if (this.getOption(_content_type) != null) {
            contentType = this.getOption(_content_type).getString();
        }
        String href = this.getOption(_href).getBaseURI().resolve(this.getOption(_href).getString()).toASCIIString();
        String output = null;
        if (!href.startsWith("file:/")) {
            throw new XProcException(this.step.getNode(), "Don't know how to write p:xsl-formatter output to " + href);
        }
        output = URIUtils.getFile(href).getPath();
        OutputStream out = null;
        try {
            try {
                out = new BufferedOutputStream(new FileOutputStream(output));
                provider.format(this.source.read(), out, contentType);
            }
            catch (XProcException e) {
                throw e;
            }
            catch (Exception e) {
                throw new XProcException(this.step.getNode(), "Failed to process FO document", (Throwable)e);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(this.step.getNode().getBaseURI());
        tree.addStartElement(XProcConstants.c_result);
        tree.startContent();
        tree.addText(href);
        tree.addEndElement();
        tree.endDocument();
        this.result.write(tree.getResult());
    }
}

