/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.Serializable;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.RuleTarget;
import net.sf.saxon.trans.StripSpaceRules;
import net.sf.saxon.trans.XPathException;

public class RuleBasedStripper
extends Stripper {
    public static final StripRuleTarget STRIP = new StripRuleTarget(){};
    public static final StripRuleTarget PRESERVE = new StripRuleTarget(){};
    private boolean preserveAll;
    private StripSpaceRules stripperMode;

    public RuleBasedStripper() {
    }

    public RuleBasedStripper(StripSpaceRules stripperRules) {
        this.stripperMode = stripperRules;
        this.preserveAll = stripperRules == null;
    }

    public RuleBasedStripper getAnother() {
        RuleBasedStripper clone = new RuleBasedStripper(this.stripperMode);
        clone.setPipelineConfiguration(this.getPipelineConfiguration());
        clone.preserveAll = this.preserveAll;
        return clone;
    }

    public byte isSpacePreserving(int fingerprint) throws XPathException {
        if (this.preserveAll) {
            return 1;
        }
        Rule rule = this.stripperMode.getRule(fingerprint);
        if (rule == null) {
            return 1;
        }
        return rule.getAction() == PRESERVE ? (byte)1 : 0;
    }

    public static class StripRuleTarget
    implements RuleTarget,
    Serializable {
        public void explain(ExpressionPresenter presenter) {
        }
    }
}

