/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import net.sf.saxon.serialize.XMLEmitter;
import net.sf.saxon.serialize.charcode.UTF8CharacterSet;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.HexBinaryValue;

public class TEXTEmitter
extends XMLEmitter {
    boolean recognizeBinary;

    public void setOutputProperties(Properties details) throws XPathException {
        super.setOutputProperties(details);
        String recognize = this.outputProperties.getProperty("{http://saxon.sf.net/}recognize-binary");
        if ("yes".equals(recognize)) {
            this.recognizeBinary = true;
        }
    }

    public void open() throws XPathException {
    }

    protected void openDocument() throws XPathException {
        String byteOrderMark;
        String encoding;
        if (this.writer == null) {
            this.makeWriter();
        }
        if (this.characterSet == null) {
            this.characterSet = UTF8CharacterSet.getInstance();
        }
        if ((encoding = this.outputProperties.getProperty("encoding")) == null || encoding.equalsIgnoreCase("utf8")) {
            encoding = "UTF-8";
        }
        if ("yes".equals(byteOrderMark = this.outputProperties.getProperty("byte-order-mark")) && ("UTF-8".equalsIgnoreCase(encoding) || "UTF-16LE".equalsIgnoreCase(encoding) || "UTF-16BE".equalsIgnoreCase(encoding))) {
            try {
                this.writer.write(65279);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.started = true;
    }

    public void writeDeclaration() throws XPathException {
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        int badchar;
        if (!this.started) {
            this.openDocument();
        }
        if ((properties & 4) == 0 && (badchar = this.testCharacters(chars)) != 0) {
            throw new XPathException("Output character not available in this encoding (decimal " + badchar + ")");
        }
        try {
            this.writer.write(((Object)chars).toString());
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) {
    }

    public void namespace(int namespaceCode, int properties) {
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) {
    }

    public void endElement() {
    }

    public void processingInstruction(String name, CharSequence value, int locationId, int properties) throws XPathException {
        if (this.recognizeBinary) {
            String encoding;
            if (!this.started) {
                this.openDocument();
            }
            byte[] bytes = null;
            int dot = name.indexOf(46);
            if (dot >= 0 && dot != name.length() - 1) {
                encoding = name.substring(dot + 1);
                name = name.substring(0, dot);
            } else {
                encoding = this.outputProperties.getProperty("encoding", "utf8");
            }
            if (name.equals("hex")) {
                bytes = new HexBinaryValue(value).getBinaryValue();
            } else if (name.equals("b64")) {
                bytes = new Base64BinaryValue(value).getBinaryValue();
            }
            if (bytes != null) {
                try {
                    ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                    InputStreamReader reader = new InputStreamReader((InputStream)stream, encoding);
                    char[] array = new char[bytes.length];
                    int used = reader.read(array, 0, array.length);
                    this.writer.write(array, 0, used);
                }
                catch (IOException e) {
                    throw new XPathException("Text output method: failed to decode binary data " + Err.wrap(((Object)value).toString(), 4));
                }
            }
        }
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
    }
}

