/*
 * Decompiled with CFR 0.152.
 */
package org.python.posix;

import com.kenai.jaffl.LastError;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.mapper.FromNativeContext;
import com.kenai.jaffl.mapper.FromNativeConverter;
import com.kenai.jaffl.mapper.ToNativeContext;
import com.kenai.jaffl.mapper.ToNativeConverter;
import com.kenai.jaffl.struct.Struct;
import com.kenai.jaffl.struct.StructUtil;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.python.constantine.platform.Errno;
import org.python.posix.BaseHeapFileStat;
import org.python.posix.DefaultNativeGroup;
import org.python.posix.DefaultNativeTimeval;
import org.python.posix.FileStat;
import org.python.posix.Group;
import org.python.posix.JavaLibCHelper;
import org.python.posix.LibC;
import org.python.posix.LibCProvider;
import org.python.posix.POSIX;
import org.python.posix.POSIXHandler;
import org.python.posix.Passwd;
import org.python.posix.Timeval;

abstract class BaseNativePOSIX
implements POSIX {
    private final LibC libc;
    protected final String libraryName;
    protected final POSIXHandler handler;
    protected final JavaLibCHelper helper;
    public static final PointerConverter GROUP = new PointerConverter(){

        public Object fromNative(Object arg, FromNativeContext ctx) {
            return arg != null ? new DefaultNativeGroup((Pointer)arg) : null;
        }
    };
    public static final ToNativeConverter<FileStat, Struct> FileStatConverter = new ToNativeConverter<FileStat, Struct>(){

        @Override
        public Struct toNative(FileStat value, ToNativeContext context) {
            if (!(value instanceof Struct)) {
                throw new IllegalArgumentException("FileStat instance is not a struct");
            }
            return (Struct)((Object)value);
        }

        @Override
        public Class<Struct> nativeType() {
            return Struct.class;
        }
    };

    BaseNativePOSIX(String libraryName, LibCProvider libcProvider, POSIXHandler handler) {
        this.handler = handler;
        this.libraryName = libraryName;
        this.libc = libcProvider.getLibC();
        this.helper = new JavaLibCHelper(handler);
    }

    public final LibC libc() {
        return this.libc;
    }

    public int chmod(String filename, int mode) {
        return this.libc().chmod(filename, mode);
    }

    public int chown(String filename, int user, int group) {
        return this.libc().chown(filename, user, group);
    }

    public FileStat fstat(FileDescriptor fileDescriptor) {
        BaseHeapFileStat stat = this.allocateStat();
        int fd = this.helper.getfd(fileDescriptor);
        if (this.libc().fstat(fd, stat) < 0) {
            this.handler.error(Errno.ENOENT, "" + fd);
        }
        return stat;
    }

    public int getegid() {
        return this.libc().getegid();
    }

    public int geteuid() {
        return this.libc().geteuid();
    }

    public int getgid() {
        return this.libc().getgid();
    }

    public String getlogin() {
        return this.libc().getlogin();
    }

    public int getpgid() {
        return this.libc().getpgid();
    }

    public int getpgrp() {
        return this.libc().getpgrp();
    }

    public int getpid() {
        return this.libc().getpid();
    }

    public int getppid() {
        return this.libc().getppid();
    }

    public Passwd getpwent() {
        return this.libc().getpwent();
    }

    public Passwd getpwuid(int which) {
        return this.libc().getpwuid(which);
    }

    public Passwd getpwnam(String which) {
        return this.libc().getpwnam(which);
    }

    public Group getgrent() {
        return this.libc().getgrent();
    }

    public Group getgrgid(int which) {
        return this.libc().getgrgid(which);
    }

    public Group getgrnam(String which) {
        return this.libc().getgrnam(which);
    }

    public int setpwent() {
        return this.libc().setpwent();
    }

    public int endpwent() {
        return this.libc().endpwent();
    }

    public int setgrent() {
        return this.libc().setgrent();
    }

    public int endgrent() {
        return this.libc().endgrent();
    }

    public int getuid() {
        return this.libc().getuid();
    }

    public int setegid(int egid) {
        return this.libc().setegid(egid);
    }

    public int seteuid(int euid) {
        return this.libc().seteuid(euid);
    }

    public int setgid(int gid) {
        return this.libc().setgid(gid);
    }

    public int getfd(FileDescriptor descriptor) {
        return this.helper.getfd(descriptor);
    }

    public int getpgid(int pid) {
        return this.libc().getpgid(pid);
    }

    public int setpgid(int pid, int pgid) {
        return this.libc().setpgid(pid, pgid);
    }

    public int setpgrp(int pid, int pgrp) {
        return this.libc().setpgrp(pid, pgrp);
    }

    public int setsid() {
        return this.libc().setsid();
    }

    public int setuid(int uid) {
        return this.libc().setuid(uid);
    }

    public int kill(int pid, int signal) {
        return this.libc().kill(pid, signal);
    }

    public int lchmod(String filename, int mode) {
        return this.libc().lchmod(filename, mode);
    }

    public int lchown(String filename, int user, int group) {
        return this.libc().lchown(filename, user, group);
    }

    public int link(String oldpath, String newpath) {
        return this.libc().link(oldpath, newpath);
    }

    public FileStat lstat(String path) {
        BaseHeapFileStat stat = this.allocateStat();
        if (this.libc().lstat(path, stat) < 0) {
            this.handler.error(Errno.ENOENT, path);
        }
        return stat;
    }

    public int mkdir(String path, int mode) {
        int res = this.libc().mkdir(path, mode);
        if (res < 0) {
            int errno2 = this.errno();
            this.handler.error(Errno.valueOf(errno2), path);
        }
        return res;
    }

    public FileStat stat(String path) {
        BaseHeapFileStat stat = this.allocateStat();
        if (this.libc().stat(path, stat) < 0) {
            this.handler.error(Errno.ENOENT, path);
        }
        return stat;
    }

    public int symlink(String oldpath, String newpath) {
        return this.libc().symlink(oldpath, newpath);
    }

    public String readlink(String oldpath) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        int result = this.libc().readlink(oldpath, buffer, buffer.capacity());
        if (result == -1) {
            return null;
        }
        buffer.position(0);
        buffer.limit(result);
        return Charset.forName("ASCII").decode(buffer).toString();
    }

    public int umask(int mask) {
        return this.libc().umask(mask);
    }

    public int utimes(String path, long[] atimeval, long[] mtimeval) {
        Timeval[] times = null;
        if (atimeval != null && mtimeval != null) {
            times = (Timeval[])StructUtil.newArray(DefaultNativeTimeval.class, (int)2);
            times[0].setTime(atimeval);
            times[1].setTime(mtimeval);
        }
        return this.libc().utimes(path, times);
    }

    public int fork() {
        return this.libc().fork();
    }

    public int waitpid(int pid, int[] status, int flags) {
        return this.libc().waitpid(pid, status, flags);
    }

    public int wait(int[] status) {
        return this.libc().wait(status);
    }

    public int getpriority(int which, int who) {
        return this.libc().getpriority(which, who);
    }

    public int setpriority(int which, int who, int prio) {
        return this.libc().setpriority(which, who, prio);
    }

    public boolean isatty(FileDescriptor fd) {
        return this.libc().isatty(this.helper.getfd(fd)) != 0;
    }

    public int errno() {
        return LastError.getLastError();
    }

    public void errno(int value) {
        LastError.setLastError(value);
    }

    public boolean isNative() {
        return true;
    }

    public abstract BaseHeapFileStat allocateStat();

    public static abstract class PointerConverter
    implements FromNativeConverter {
        public Class nativeType() {
            return Pointer.class;
        }
    }
}

