/*
 * Copyright 2022 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */
#ifndef _gc_9_4_3_OFFSET_HEADER
#define _gc_9_4_3_OFFSET_HEADER



// addressBlock: xcd0_gc_grbmdec
// base address: 0x8000
#define regGRBM_CNTL                                                                                    0x0000
#define regGRBM_CNTL_BASE_IDX                                                                           0
#define regGRBM_SKEW_CNTL                                                                               0x0001
#define regGRBM_SKEW_CNTL_BASE_IDX                                                                      0
#define regGRBM_STATUS2                                                                                 0x0002
#define regGRBM_STATUS2_BASE_IDX                                                                        0
#define regGRBM_PWR_CNTL                                                                                0x0003
#define regGRBM_PWR_CNTL_BASE_IDX                                                                       0
#define regGRBM_STATUS                                                                                  0x0004
#define regGRBM_STATUS_BASE_IDX                                                                         0
#define regGRBM_STATUS_SE0                                                                              0x0005
#define regGRBM_STATUS_SE0_BASE_IDX                                                                     0
#define regGRBM_STATUS_SE1                                                                              0x0006
#define regGRBM_STATUS_SE1_BASE_IDX                                                                     0
#define regGRBM_SOFT_RESET                                                                              0x0008
#define regGRBM_SOFT_RESET_BASE_IDX                                                                     0
#define regGRBM_GFX_CLKEN_CNTL                                                                          0x000c
#define regGRBM_GFX_CLKEN_CNTL_BASE_IDX                                                                 0
#define regGRBM_WAIT_IDLE_CLOCKS                                                                        0x000d
#define regGRBM_WAIT_IDLE_CLOCKS_BASE_IDX                                                               0
#define regGRBM_STATUS_SE2                                                                              0x000e
#define regGRBM_STATUS_SE2_BASE_IDX                                                                     0
#define regGRBM_STATUS_SE3                                                                              0x000f
#define regGRBM_STATUS_SE3_BASE_IDX                                                                     0
#define regGRBM_READ_ERROR                                                                              0x0016
#define regGRBM_READ_ERROR_BASE_IDX                                                                     0
#define regGRBM_READ_ERROR2                                                                             0x0017
#define regGRBM_READ_ERROR2_BASE_IDX                                                                    0
#define regGRBM_INT_CNTL                                                                                0x0018
#define regGRBM_INT_CNTL_BASE_IDX                                                                       0
#define regGRBM_TRAP_OP                                                                                 0x0019
#define regGRBM_TRAP_OP_BASE_IDX                                                                        0
#define regGRBM_TRAP_ADDR                                                                               0x001a
#define regGRBM_TRAP_ADDR_BASE_IDX                                                                      0
#define regGRBM_TRAP_ADDR_MSK                                                                           0x001b
#define regGRBM_TRAP_ADDR_MSK_BASE_IDX                                                                  0
#define regGRBM_TRAP_WD                                                                                 0x001c
#define regGRBM_TRAP_WD_BASE_IDX                                                                        0
#define regGRBM_TRAP_WD_MSK                                                                             0x001d
#define regGRBM_TRAP_WD_MSK_BASE_IDX                                                                    0
#define regGRBM_WRITE_ERROR                                                                             0x001f
#define regGRBM_WRITE_ERROR_BASE_IDX                                                                    0
#define regGRBM_IOV_ERROR                                                                               0x0020
#define regGRBM_IOV_ERROR_BASE_IDX                                                                      0
#define regGRBM_CHIP_REVISION                                                                           0x0021
#define regGRBM_CHIP_REVISION_BASE_IDX                                                                  0
#define regGRBM_GFX_CNTL                                                                                0x0022
#define regGRBM_GFX_CNTL_BASE_IDX                                                                       0
#define regGRBM_RSMU_CFG                                                                                0x0023
#define regGRBM_RSMU_CFG_BASE_IDX                                                                       0
#define regGRBM_IH_CREDIT                                                                               0x0024
#define regGRBM_IH_CREDIT_BASE_IDX                                                                      0
#define regGRBM_PWR_CNTL2                                                                               0x0025
#define regGRBM_PWR_CNTL2_BASE_IDX                                                                      0
#define regGRBM_UTCL2_INVAL_RANGE_START                                                                 0x0026
#define regGRBM_UTCL2_INVAL_RANGE_START_BASE_IDX                                                        0
#define regGRBM_UTCL2_INVAL_RANGE_END                                                                   0x0027
#define regGRBM_UTCL2_INVAL_RANGE_END_BASE_IDX                                                          0
#define regGRBM_RSMU_READ_ERROR                                                                         0x0028
#define regGRBM_RSMU_READ_ERROR_BASE_IDX                                                                0
#define regGRBM_CHICKEN_BITS                                                                            0x0029
#define regGRBM_CHICKEN_BITS_BASE_IDX                                                                   0
#define regGRBM_FENCE_RANGE0                                                                            0x002a
#define regGRBM_FENCE_RANGE0_BASE_IDX                                                                   0
#define regGRBM_FENCE_RANGE1                                                                            0x002b
#define regGRBM_FENCE_RANGE1_BASE_IDX                                                                   0
#define regGRBM_IOV_READ_ERROR                                                                          0x002c
#define regGRBM_IOV_READ_ERROR_BASE_IDX                                                                 0
#define regGRBM_NOWHERE                                                                                 0x003f
#define regGRBM_NOWHERE_BASE_IDX                                                                        0
#define regGRBM_SCRATCH_REG0                                                                            0x0040
#define regGRBM_SCRATCH_REG0_BASE_IDX                                                                   0
#define regGRBM_SCRATCH_REG1                                                                            0x0041
#define regGRBM_SCRATCH_REG1_BASE_IDX                                                                   0
#define regGRBM_SCRATCH_REG2                                                                            0x0042
#define regGRBM_SCRATCH_REG2_BASE_IDX                                                                   0
#define regGRBM_SCRATCH_REG3                                                                            0x0043
#define regGRBM_SCRATCH_REG3_BASE_IDX                                                                   0
#define regGRBM_SCRATCH_REG4                                                                            0x0044
#define regGRBM_SCRATCH_REG4_BASE_IDX                                                                   0
#define regGRBM_SCRATCH_REG5                                                                            0x0045
#define regGRBM_SCRATCH_REG5_BASE_IDX                                                                   0
#define regGRBM_SCRATCH_REG6                                                                            0x0046
#define regGRBM_SCRATCH_REG6_BASE_IDX                                                                   0
#define regGRBM_SCRATCH_REG7                                                                            0x0047
#define regGRBM_SCRATCH_REG7_BASE_IDX                                                                   0
#define regVIOLATION_DATA_ASYNC_VF_PROG                                                                 0x0048
#define regVIOLATION_DATA_ASYNC_VF_PROG_BASE_IDX                                                        0


// addressBlock: xcd0_gc_cpdec
// base address: 0x8200
#define regCP_CPC_DEBUG_CNTL                                                                            0x0080
#define regCP_CPC_DEBUG_CNTL_BASE_IDX                                                                   0
#define regCP_CPF_DEBUG_CNTL                                                                            0x0082
#define regCP_CPF_DEBUG_CNTL_BASE_IDX                                                                   0
#define regCP_CPC_STATUS                                                                                0x0084
#define regCP_CPC_STATUS_BASE_IDX                                                                       0
#define regCP_CPC_BUSY_STAT                                                                             0x0085
#define regCP_CPC_BUSY_STAT_BASE_IDX                                                                    0
#define regCP_CPC_STALLED_STAT1                                                                         0x0086
#define regCP_CPC_STALLED_STAT1_BASE_IDX                                                                0
#define regCP_CPF_STATUS                                                                                0x0087
#define regCP_CPF_STATUS_BASE_IDX                                                                       0
#define regCP_CPF_BUSY_STAT                                                                             0x0088
#define regCP_CPF_BUSY_STAT_BASE_IDX                                                                    0
#define regCP_CPF_STALLED_STAT1                                                                         0x0089
#define regCP_CPF_STALLED_STAT1_BASE_IDX                                                                0
#define regCP_CPC_GRBM_FREE_COUNT                                                                       0x008b
#define regCP_CPC_GRBM_FREE_COUNT_BASE_IDX                                                              0
#define regCP_CPC_PRIV_VIOLATION_ADDR                                                                   0x008c
#define regCP_CPC_PRIV_VIOLATION_ADDR_BASE_IDX                                                          0
#define regCP_MEC_CNTL                                                                                  0x008d
#define regCP_MEC_CNTL_BASE_IDX                                                                         0
#define regCP_MEC_ME1_HEADER_DUMP                                                                       0x008e
#define regCP_MEC_ME1_HEADER_DUMP_BASE_IDX                                                              0
#define regCP_MEC_ME2_HEADER_DUMP                                                                       0x008f
#define regCP_MEC_ME2_HEADER_DUMP_BASE_IDX                                                              0
#define regCP_CPC_SCRATCH_INDEX                                                                         0x0090
#define regCP_CPC_SCRATCH_INDEX_BASE_IDX                                                                0
#define regCP_CPC_SCRATCH_DATA                                                                          0x0091
#define regCP_CPC_SCRATCH_DATA_BASE_IDX                                                                 0
#define regCP_CPF_GRBM_FREE_COUNT                                                                       0x0092
#define regCP_CPF_GRBM_FREE_COUNT_BASE_IDX                                                              0
#define regCP_CPC_HALT_HYST_COUNT                                                                       0x00a7
#define regCP_CPC_HALT_HYST_COUNT_BASE_IDX                                                              0
#define regCP_CE_COMPARE_COUNT                                                                          0x00c0
#define regCP_CE_COMPARE_COUNT_BASE_IDX                                                                 0
#define regCP_CE_DE_COUNT                                                                               0x00c1
#define regCP_CE_DE_COUNT_BASE_IDX                                                                      0
#define regCP_DE_CE_COUNT                                                                               0x00c2
#define regCP_DE_CE_COUNT_BASE_IDX                                                                      0
#define regCP_DE_LAST_INVAL_COUNT                                                                       0x00c3
#define regCP_DE_LAST_INVAL_COUNT_BASE_IDX                                                              0
#define regCP_DE_DE_COUNT                                                                               0x00c4
#define regCP_DE_DE_COUNT_BASE_IDX                                                                      0
#define regCP_STALLED_STAT3                                                                             0x019c
#define regCP_STALLED_STAT3_BASE_IDX                                                                    0
#define regCP_STALLED_STAT1                                                                             0x019d
#define regCP_STALLED_STAT1_BASE_IDX                                                                    0
#define regCP_STALLED_STAT2                                                                             0x019e
#define regCP_STALLED_STAT2_BASE_IDX                                                                    0
#define regCP_BUSY_STAT                                                                                 0x019f
#define regCP_BUSY_STAT_BASE_IDX                                                                        0
#define regCP_STAT                                                                                      0x01a0
#define regCP_STAT_BASE_IDX                                                                             0
#define regCP_ME_HEADER_DUMP                                                                            0x01a1
#define regCP_ME_HEADER_DUMP_BASE_IDX                                                                   0
#define regCP_PFP_HEADER_DUMP                                                                           0x01a2
#define regCP_PFP_HEADER_DUMP_BASE_IDX                                                                  0
#define regCP_GRBM_FREE_COUNT                                                                           0x01a3
#define regCP_GRBM_FREE_COUNT_BASE_IDX                                                                  0
#define regCP_CE_HEADER_DUMP                                                                            0x01a4
#define regCP_CE_HEADER_DUMP_BASE_IDX                                                                   0
#define regCP_PFP_INSTR_PNTR                                                                            0x01a5
#define regCP_PFP_INSTR_PNTR_BASE_IDX                                                                   0
#define regCP_ME_INSTR_PNTR                                                                             0x01a6
#define regCP_ME_INSTR_PNTR_BASE_IDX                                                                    0
#define regCP_CE_INSTR_PNTR                                                                             0x01a7
#define regCP_CE_INSTR_PNTR_BASE_IDX                                                                    0
#define regCP_MEC1_INSTR_PNTR                                                                           0x01a8
#define regCP_MEC1_INSTR_PNTR_BASE_IDX                                                                  0
#define regCP_MEC2_INSTR_PNTR                                                                           0x01a9
#define regCP_MEC2_INSTR_PNTR_BASE_IDX                                                                  0
#define regCP_CSF_STAT                                                                                  0x01b4
#define regCP_CSF_STAT_BASE_IDX                                                                         0
#define regCP_ME_CNTL                                                                                   0x01b6
#define regCP_ME_CNTL_BASE_IDX                                                                          0
#define regCP_CNTX_STAT                                                                                 0x01b8
#define regCP_CNTX_STAT_BASE_IDX                                                                        0
#define regCP_ME_PREEMPTION                                                                             0x01b9
#define regCP_ME_PREEMPTION_BASE_IDX                                                                    0
#define regCP_ROQ_THRESHOLDS                                                                            0x01bc
#define regCP_ROQ_THRESHOLDS_BASE_IDX                                                                   0
#define regCP_MEQ_STQ_THRESHOLD                                                                         0x01bd
#define regCP_MEQ_STQ_THRESHOLD_BASE_IDX                                                                0
#define regCP_RB2_RPTR                                                                                  0x01be
#define regCP_RB2_RPTR_BASE_IDX                                                                         0
#define regCP_RB1_RPTR                                                                                  0x01bf
#define regCP_RB1_RPTR_BASE_IDX                                                                         0
#define regCP_RB0_RPTR                                                                                  0x01c0
#define regCP_RB0_RPTR_BASE_IDX                                                                         0
#define regCP_RB_RPTR                                                                                   0x01c0
#define regCP_RB_RPTR_BASE_IDX                                                                          0
#define regCP_RB_WPTR_DELAY                                                                             0x01c1
#define regCP_RB_WPTR_DELAY_BASE_IDX                                                                    0
#define regCP_RB_WPTR_POLL_CNTL                                                                         0x01c2
#define regCP_RB_WPTR_POLL_CNTL_BASE_IDX                                                                0
#define regCP_ROQ1_THRESHOLDS                                                                           0x01d5
#define regCP_ROQ1_THRESHOLDS_BASE_IDX                                                                  0
#define regCP_ROQ2_THRESHOLDS                                                                           0x01d6
#define regCP_ROQ2_THRESHOLDS_BASE_IDX                                                                  0
#define regCP_STQ_THRESHOLDS                                                                            0x01d7
#define regCP_STQ_THRESHOLDS_BASE_IDX                                                                   0
#define regCP_QUEUE_THRESHOLDS                                                                          0x01d8
#define regCP_QUEUE_THRESHOLDS_BASE_IDX                                                                 0
#define regCP_MEQ_THRESHOLDS                                                                            0x01d9
#define regCP_MEQ_THRESHOLDS_BASE_IDX                                                                   0
#define regCP_ROQ_AVAIL                                                                                 0x01da
#define regCP_ROQ_AVAIL_BASE_IDX                                                                        0
#define regCP_STQ_AVAIL                                                                                 0x01db
#define regCP_STQ_AVAIL_BASE_IDX                                                                        0
#define regCP_ROQ2_AVAIL                                                                                0x01dc
#define regCP_ROQ2_AVAIL_BASE_IDX                                                                       0
#define regCP_MEQ_AVAIL                                                                                 0x01dd
#define regCP_MEQ_AVAIL_BASE_IDX                                                                        0
#define regCP_CMD_INDEX                                                                                 0x01de
#define regCP_CMD_INDEX_BASE_IDX                                                                        0
#define regCP_CMD_DATA                                                                                  0x01df
#define regCP_CMD_DATA_BASE_IDX                                                                         0
#define regCP_ROQ_RB_STAT                                                                               0x01e0
#define regCP_ROQ_RB_STAT_BASE_IDX                                                                      0
#define regCP_ROQ_IB1_STAT                                                                              0x01e1
#define regCP_ROQ_IB1_STAT_BASE_IDX                                                                     0
#define regCP_ROQ_IB2_STAT                                                                              0x01e2
#define regCP_ROQ_IB2_STAT_BASE_IDX                                                                     0
#define regCP_STQ_STAT                                                                                  0x01e3
#define regCP_STQ_STAT_BASE_IDX                                                                         0
#define regCP_STQ_WR_STAT                                                                               0x01e4
#define regCP_STQ_WR_STAT_BASE_IDX                                                                      0
#define regCP_MEQ_STAT                                                                                  0x01e5
#define regCP_MEQ_STAT_BASE_IDX                                                                         0
#define regCP_CEQ1_AVAIL                                                                                0x01e6
#define regCP_CEQ1_AVAIL_BASE_IDX                                                                       0
#define regCP_CEQ2_AVAIL                                                                                0x01e7
#define regCP_CEQ2_AVAIL_BASE_IDX                                                                       0
#define regCP_CE_ROQ_RB_STAT                                                                            0x01e8
#define regCP_CE_ROQ_RB_STAT_BASE_IDX                                                                   0
#define regCP_CE_ROQ_IB1_STAT                                                                           0x01e9
#define regCP_CE_ROQ_IB1_STAT_BASE_IDX                                                                  0
#define regCP_CE_ROQ_IB2_STAT                                                                           0x01ea
#define regCP_CE_ROQ_IB2_STAT_BASE_IDX                                                                  0
#define regCP_INT_STAT_DEBUG                                                                            0x01f7
#define regCP_INT_STAT_DEBUG_BASE_IDX                                                                   0
#define regCP_DEBUG_CNTL                                                                                0x01f8
#define regCP_DEBUG_CNTL_BASE_IDX                                                                       0
#define regCP_PRIV_VIOLATION_ADDR                                                                       0x01fa
#define regCP_PRIV_VIOLATION_ADDR_BASE_IDX                                                              0


// addressBlock: xcd0_gc_padec
// base address: 0x8800
#define regVGT_VTX_VECT_EJECT_REG                                                                       0x022c
#define regVGT_VTX_VECT_EJECT_REG_BASE_IDX                                                              0
#define regVGT_DMA_DATA_FIFO_DEPTH                                                                      0x022d
#define regVGT_DMA_DATA_FIFO_DEPTH_BASE_IDX                                                             0
#define regVGT_DMA_REQ_FIFO_DEPTH                                                                       0x022e
#define regVGT_DMA_REQ_FIFO_DEPTH_BASE_IDX                                                              0
#define regVGT_DRAW_INIT_FIFO_DEPTH                                                                     0x022f
#define regVGT_DRAW_INIT_FIFO_DEPTH_BASE_IDX                                                            0
#define regVGT_LAST_COPY_STATE                                                                          0x0230
#define regVGT_LAST_COPY_STATE_BASE_IDX                                                                 0
#define regVGT_CACHE_INVALIDATION                                                                       0x0231
#define regVGT_CACHE_INVALIDATION_BASE_IDX                                                              0
#define regVGT_RESET_DEBUG                                                                              0x0232
#define regVGT_RESET_DEBUG_BASE_IDX                                                                     0
#define regVGT_STRMOUT_DELAY                                                                            0x0233
#define regVGT_STRMOUT_DELAY_BASE_IDX                                                                   0
#define regVGT_FIFO_DEPTHS                                                                              0x0234
#define regVGT_FIFO_DEPTHS_BASE_IDX                                                                     0
#define regVGT_GS_VERTEX_REUSE                                                                          0x0235
#define regVGT_GS_VERTEX_REUSE_BASE_IDX                                                                 0
#define regVGT_MC_LAT_CNTL                                                                              0x0236
#define regVGT_MC_LAT_CNTL_BASE_IDX                                                                     0
#define regIA_CNTL_STATUS                                                                               0x0237
#define regIA_CNTL_STATUS_BASE_IDX                                                                      0
#define regVGT_CNTL_STATUS                                                                              0x023c
#define regVGT_CNTL_STATUS_BASE_IDX                                                                     0
#define regWD_CNTL_STATUS                                                                               0x023f
#define regWD_CNTL_STATUS_BASE_IDX                                                                      0
#define regCC_GC_PRIM_CONFIG                                                                            0x0240
#define regCC_GC_PRIM_CONFIG_BASE_IDX                                                                   0
#define regGC_USER_PRIM_CONFIG                                                                          0x0241
#define regGC_USER_PRIM_CONFIG_BASE_IDX                                                                 0
#define regWD_QOS                                                                                       0x0242
#define regWD_QOS_BASE_IDX                                                                              0
#define regWD_UTCL1_CNTL                                                                                0x0243
#define regWD_UTCL1_CNTL_BASE_IDX                                                                       0
#define regWD_UTCL1_STATUS                                                                              0x0244
#define regWD_UTCL1_STATUS_BASE_IDX                                                                     0
#define regIA_UTCL1_CNTL                                                                                0x0246
#define regIA_UTCL1_CNTL_BASE_IDX                                                                       0
#define regIA_UTCL1_STATUS                                                                              0x0247
#define regIA_UTCL1_STATUS_BASE_IDX                                                                     0
#define regVGT_SYS_CONFIG                                                                               0x0263
#define regVGT_SYS_CONFIG_BASE_IDX                                                                      0
#define regVGT_VS_MAX_WAVE_ID                                                                           0x0268
#define regVGT_VS_MAX_WAVE_ID_BASE_IDX                                                                  0
#define regVGT_GS_MAX_WAVE_ID                                                                           0x0269
#define regVGT_GS_MAX_WAVE_ID_BASE_IDX                                                                  0
#define regGFX_PIPE_CONTROL                                                                             0x026d
#define regGFX_PIPE_CONTROL_BASE_IDX                                                                    0
#define regCC_GC_SHADER_ARRAY_CONFIG                                                                    0x026f
#define regCC_GC_SHADER_ARRAY_CONFIG_BASE_IDX                                                           0
#define regGC_USER_SHADER_ARRAY_CONFIG                                                                  0x0270
#define regGC_USER_SHADER_ARRAY_CONFIG_BASE_IDX                                                         0
#define regVGT_DMA_PRIMITIVE_TYPE                                                                       0x0271
#define regVGT_DMA_PRIMITIVE_TYPE_BASE_IDX                                                              0
#define regVGT_DMA_CONTROL                                                                              0x0272
#define regVGT_DMA_CONTROL_BASE_IDX                                                                     0
#define regVGT_DMA_LS_HS_CONFIG                                                                         0x0273
#define regVGT_DMA_LS_HS_CONFIG_BASE_IDX                                                                0
#define regWD_BUF_RESOURCE_1                                                                            0x0276
#define regWD_BUF_RESOURCE_1_BASE_IDX                                                                   0
#define regWD_BUF_RESOURCE_2                                                                            0x0277
#define regWD_BUF_RESOURCE_2_BASE_IDX                                                                   0
#define regPA_CL_CNTL_STATUS                                                                            0x0284
#define regPA_CL_CNTL_STATUS_BASE_IDX                                                                   0
#define regPA_CL_ENHANCE                                                                                0x0285
#define regPA_CL_ENHANCE_BASE_IDX                                                                       0
#define regPA_CL_RESET_DEBUG                                                                            0x0286
#define regPA_CL_RESET_DEBUG_BASE_IDX                                                                   0
#define regPA_SU_CNTL_STATUS                                                                            0x0294
#define regPA_SU_CNTL_STATUS_BASE_IDX                                                                   0
#define regPA_SC_FIFO_DEPTH_CNTL                                                                        0x0295
#define regPA_SC_FIFO_DEPTH_CNTL_BASE_IDX                                                               0
#define regPA_SC_P3D_TRAP_SCREEN_HV_LOCK                                                                0x02c0
#define regPA_SC_P3D_TRAP_SCREEN_HV_LOCK_BASE_IDX                                                       0
#define regPA_SC_HP3D_TRAP_SCREEN_HV_LOCK                                                               0x02c1
#define regPA_SC_HP3D_TRAP_SCREEN_HV_LOCK_BASE_IDX                                                      0
#define regPA_SC_TRAP_SCREEN_HV_LOCK                                                                    0x02c2
#define regPA_SC_TRAP_SCREEN_HV_LOCK_BASE_IDX                                                           0
#define regPA_SC_FORCE_EOV_MAX_CNTS                                                                     0x02c9
#define regPA_SC_FORCE_EOV_MAX_CNTS_BASE_IDX                                                            0
#define regPA_SC_BINNER_EVENT_CNTL_0                                                                    0x02cc
#define regPA_SC_BINNER_EVENT_CNTL_0_BASE_IDX                                                           0
#define regPA_SC_BINNER_EVENT_CNTL_1                                                                    0x02cd
#define regPA_SC_BINNER_EVENT_CNTL_1_BASE_IDX                                                           0
#define regPA_SC_BINNER_EVENT_CNTL_2                                                                    0x02ce
#define regPA_SC_BINNER_EVENT_CNTL_2_BASE_IDX                                                           0
#define regPA_SC_BINNER_EVENT_CNTL_3                                                                    0x02cf
#define regPA_SC_BINNER_EVENT_CNTL_3_BASE_IDX                                                           0
#define regPA_SC_BINNER_TIMEOUT_COUNTER                                                                 0x02d0
#define regPA_SC_BINNER_TIMEOUT_COUNTER_BASE_IDX                                                        0
#define regPA_SC_BINNER_PERF_CNTL_0                                                                     0x02d1
#define regPA_SC_BINNER_PERF_CNTL_0_BASE_IDX                                                            0
#define regPA_SC_BINNER_PERF_CNTL_1                                                                     0x02d2
#define regPA_SC_BINNER_PERF_CNTL_1_BASE_IDX                                                            0
#define regPA_SC_BINNER_PERF_CNTL_2                                                                     0x02d3
#define regPA_SC_BINNER_PERF_CNTL_2_BASE_IDX                                                            0
#define regPA_SC_BINNER_PERF_CNTL_3                                                                     0x02d4
#define regPA_SC_BINNER_PERF_CNTL_3_BASE_IDX                                                            0
#define regPA_SC_ENHANCE_2                                                                              0x02dc
#define regPA_SC_ENHANCE_2_BASE_IDX                                                                     0
#define regPA_SC_FIFO_SIZE                                                                              0x02f3
#define regPA_SC_FIFO_SIZE_BASE_IDX                                                                     0
#define regPA_SC_IF_FIFO_SIZE                                                                           0x02f5
#define regPA_SC_IF_FIFO_SIZE_BASE_IDX                                                                  0
#define regPA_SC_PKR_WAVE_TABLE_CNTL                                                                    0x02f8
#define regPA_SC_PKR_WAVE_TABLE_CNTL_BASE_IDX                                                           0
#define regPA_UTCL1_CNTL1                                                                               0x02f9
#define regPA_UTCL1_CNTL1_BASE_IDX                                                                      0
#define regPA_UTCL1_CNTL2                                                                               0x02fa
#define regPA_UTCL1_CNTL2_BASE_IDX                                                                      0
#define regPA_SIDEBAND_REQUEST_DELAYS                                                                   0x02fb
#define regPA_SIDEBAND_REQUEST_DELAYS_BASE_IDX                                                          0
#define regPA_SC_ENHANCE                                                                                0x02fc
#define regPA_SC_ENHANCE_BASE_IDX                                                                       0
#define regPA_SC_ENHANCE_1                                                                              0x02fd
#define regPA_SC_ENHANCE_1_BASE_IDX                                                                     0
#define regPA_SC_DSM_CNTL                                                                               0x02fe
#define regPA_SC_DSM_CNTL_BASE_IDX                                                                      0
#define regPA_SC_TILE_STEERING_CREST_OVERRIDE                                                           0x02ff
#define regPA_SC_TILE_STEERING_CREST_OVERRIDE_BASE_IDX                                                  0


// addressBlock: xcd0_gc_sqdec
// base address: 0x8c00
#define regSQ_CONFIG                                                                                    0x0300
#define regSQ_CONFIG_BASE_IDX                                                                           0
#define regSQC_CONFIG                                                                                   0x0301
#define regSQC_CONFIG_BASE_IDX                                                                          0
#define regLDS_CONFIG                                                                                   0x0302
#define regLDS_CONFIG_BASE_IDX                                                                          0
#define regSQ_RANDOM_WAVE_PRI                                                                           0x0303
#define regSQ_RANDOM_WAVE_PRI_BASE_IDX                                                                  0
#define regSQ_REG_CREDITS                                                                               0x0304
#define regSQ_REG_CREDITS_BASE_IDX                                                                      0
#define regSQ_FIFO_SIZES                                                                                0x0305
#define regSQ_FIFO_SIZES_BASE_IDX                                                                       0
#define regSQ_DSM_CNTL                                                                                  0x0306
#define regSQ_DSM_CNTL_BASE_IDX                                                                         0
#define regSQ_DSM_CNTL2                                                                                 0x0307
#define regSQ_DSM_CNTL2_BASE_IDX                                                                        0
#define regSQ_RUNTIME_CONFIG                                                                            0x0308
#define regSQ_RUNTIME_CONFIG_BASE_IDX                                                                   0
#define regSQ_DEBUG_STS_GLOBAL                                                                          0x0309
#define regSQ_DEBUG_STS_GLOBAL_BASE_IDX                                                                 0
#define regSH_MEM_BASES                                                                                 0x030a
#define regSH_MEM_BASES_BASE_IDX                                                                        0
#define regSQ_TIMEOUT_CONFIG                                                                            0x030b
#define regSQ_TIMEOUT_CONFIG_BASE_IDX                                                                   0
#define regSQ_TIMEOUT_STATUS                                                                            0x030c
#define regSQ_TIMEOUT_STATUS_BASE_IDX                                                                   0
#define regSH_MEM_CONFIG                                                                                0x030d
#define regSH_MEM_CONFIG_BASE_IDX                                                                       0
#define regSP_MFMA_PORTD_RD_CONFIG                                                                      0x030e
#define regSP_MFMA_PORTD_RD_CONFIG_BASE_IDX                                                             0
#define regSH_CAC_CONFIG                                                                                0x030f
#define regSH_CAC_CONFIG_BASE_IDX                                                                       0
#define regSQ_DEBUG_STS_GLOBAL2                                                                         0x0310
#define regSQ_DEBUG_STS_GLOBAL2_BASE_IDX                                                                0
#define regSQ_DEBUG_STS_GLOBAL3                                                                         0x0311
#define regSQ_DEBUG_STS_GLOBAL3_BASE_IDX                                                                0
#define regCC_GC_SHADER_RATE_CONFIG                                                                     0x0312
#define regCC_GC_SHADER_RATE_CONFIG_BASE_IDX                                                            0
#define regGC_USER_SHADER_RATE_CONFIG                                                                   0x0313
#define regGC_USER_SHADER_RATE_CONFIG_BASE_IDX                                                          0
#define regSQ_INTERRUPT_AUTO_MASK                                                                       0x0314
#define regSQ_INTERRUPT_AUTO_MASK_BASE_IDX                                                              0
#define regSQ_INTERRUPT_MSG_CTRL                                                                        0x0315
#define regSQ_INTERRUPT_MSG_CTRL_BASE_IDX                                                               0
#define regSQ_DEBUG_PERFCOUNT_TRAP                                                                      0x0316
#define regSQ_DEBUG_PERFCOUNT_TRAP_BASE_IDX                                                             0
#define regSQ_UTCL1_CNTL1                                                                               0x0317
#define regSQ_UTCL1_CNTL1_BASE_IDX                                                                      0
#define regSQ_UTCL1_CNTL2                                                                               0x0318
#define regSQ_UTCL1_CNTL2_BASE_IDX                                                                      0
#define regSQ_UTCL1_STATUS                                                                              0x0319
#define regSQ_UTCL1_STATUS_BASE_IDX                                                                     0
#define regSQ_FED_INTERRUPT_STATUS                                                                      0x031a
#define regSQ_FED_INTERRUPT_STATUS_BASE_IDX                                                             0
#define regSQ_CGTS_CONFIG                                                                               0x031b
#define regSQ_CGTS_CONFIG_BASE_IDX                                                                      0
#define regSQ_SHADER_TBA_LO                                                                             0x031c
#define regSQ_SHADER_TBA_LO_BASE_IDX                                                                    0
#define regSQ_SHADER_TBA_HI                                                                             0x031d
#define regSQ_SHADER_TBA_HI_BASE_IDX                                                                    0
#define regSQ_SHADER_TMA_LO                                                                             0x031e
#define regSQ_SHADER_TMA_LO_BASE_IDX                                                                    0
#define regSQ_SHADER_TMA_HI                                                                             0x031f
#define regSQ_SHADER_TMA_HI_BASE_IDX                                                                    0
#define regSQC_DSM_CNTL                                                                                 0x0320
#define regSQC_DSM_CNTL_BASE_IDX                                                                        0
#define regSQC_DSM_CNTLA                                                                                0x0321
#define regSQC_DSM_CNTLA_BASE_IDX                                                                       0
#define regSQC_DSM_CNTLB                                                                                0x0322
#define regSQC_DSM_CNTLB_BASE_IDX                                                                       0
#define regSQC_DSM_CNTL2                                                                                0x0325
#define regSQC_DSM_CNTL2_BASE_IDX                                                                       0
#define regSQC_DSM_CNTL2A                                                                               0x0326
#define regSQC_DSM_CNTL2A_BASE_IDX                                                                      0
#define regSQC_DSM_CNTL2B                                                                               0x0327
#define regSQC_DSM_CNTL2B_BASE_IDX                                                                      0
#define regSQC_DSM_CNTL2E                                                                               0x032a
#define regSQC_DSM_CNTL2E_BASE_IDX                                                                      0
#define regSQC_EDC_FUE_CNTL                                                                             0x032b
#define regSQC_EDC_FUE_CNTL_BASE_IDX                                                                    0
#define regSQC_EDC_CNT2                                                                                 0x032c
#define regSQC_EDC_CNT2_BASE_IDX                                                                        0
#define regSQC_EDC_CNT3                                                                                 0x032d
#define regSQC_EDC_CNT3_BASE_IDX                                                                        0
#define regSQC_EDC_PARITY_CNT3                                                                          0x032e
#define regSQC_EDC_PARITY_CNT3_BASE_IDX                                                                 0
#define regSQ_DEBUG                                                                                     0x0332
#define regSQ_DEBUG_BASE_IDX                                                                            0
#define regSQ_PERF_SNAPSHOT_CTRL                                                                        0x0334
#define regSQ_PERF_SNAPSHOT_CTRL_BASE_IDX                                                               0
#define regSQ_DEBUG_FOR_INTERNAL_CTRL                                                                   0x0335
#define regSQ_DEBUG_FOR_INTERNAL_CTRL_BASE_IDX                                                          0
#define regSQ_REG_TIMESTAMP                                                                             0x0374
#define regSQ_REG_TIMESTAMP_BASE_IDX                                                                    0
#define regSQ_CMD_TIMESTAMP                                                                             0x0375
#define regSQ_CMD_TIMESTAMP_BASE_IDX                                                                    0
#define regSQ_HOSTTRAP_STATUS                                                                           0x0376
#define regSQ_HOSTTRAP_STATUS_BASE_IDX                                                                  0
#define regSQ_IND_INDEX                                                                                 0x0378
#define regSQ_IND_INDEX_BASE_IDX                                                                        0
#define regSQ_IND_DATA                                                                                  0x0379
#define regSQ_IND_DATA_BASE_IDX                                                                         0
#define regSQ_CONFIG1                                                                                   0x037a
#define regSQ_CONFIG1_BASE_IDX                                                                          0
#define regSQ_CMD                                                                                       0x037b
#define regSQ_CMD_BASE_IDX                                                                              0
#define regSQ_TIME_HI                                                                                   0x037c
#define regSQ_TIME_HI_BASE_IDX                                                                          0
#define regSQ_TIME_LO                                                                                   0x037d
#define regSQ_TIME_LO_BASE_IDX                                                                          0
#define regSQ_DS_0                                                                                      0x037f
#define regSQ_DS_0_BASE_IDX                                                                             0
#define regSQ_DS_1                                                                                      0x037f
#define regSQ_DS_1_BASE_IDX                                                                             0
#define regSQ_EXP_0                                                                                     0x037f
#define regSQ_EXP_0_BASE_IDX                                                                            0
#define regSQ_EXP_1                                                                                     0x037f
#define regSQ_EXP_1_BASE_IDX                                                                            0
#define regSQ_FLAT_0                                                                                    0x037f
#define regSQ_FLAT_0_BASE_IDX                                                                           0
#define regSQ_FLAT_1                                                                                    0x037f
#define regSQ_FLAT_1_BASE_IDX                                                                           0
#define regSQ_GLBL_0                                                                                    0x037f
#define regSQ_GLBL_0_BASE_IDX                                                                           0
#define regSQ_GLBL_1                                                                                    0x037f
#define regSQ_GLBL_1_BASE_IDX                                                                           0
#define regSQ_INST                                                                                      0x037f
#define regSQ_INST_BASE_IDX                                                                             0
#define regSQ_MIMG_0                                                                                    0x037f
#define regSQ_MIMG_0_BASE_IDX                                                                           0
#define regSQ_MIMG_1                                                                                    0x037f
#define regSQ_MIMG_1_BASE_IDX                                                                           0
#define regSQ_MTBUF_0                                                                                   0x037f
#define regSQ_MTBUF_0_BASE_IDX                                                                          0
#define regSQ_MTBUF_1                                                                                   0x037f
#define regSQ_MTBUF_1_BASE_IDX                                                                          0
#define regSQ_MUBUF_0                                                                                   0x037f
#define regSQ_MUBUF_0_BASE_IDX                                                                          0
#define regSQ_MUBUF_1                                                                                   0x037f
#define regSQ_MUBUF_1_BASE_IDX                                                                          0
#define regSQ_SCRATCH_0                                                                                 0x037f
#define regSQ_SCRATCH_0_BASE_IDX                                                                        0
#define regSQ_SCRATCH_1                                                                                 0x037f
#define regSQ_SCRATCH_1_BASE_IDX                                                                        0
#define regSQ_SMEM_0                                                                                    0x037f
#define regSQ_SMEM_0_BASE_IDX                                                                           0
#define regSQ_SMEM_1                                                                                    0x037f
#define regSQ_SMEM_1_BASE_IDX                                                                           0
#define regSQ_SOP1                                                                                      0x037f
#define regSQ_SOP1_BASE_IDX                                                                             0
#define regSQ_SOP2                                                                                      0x037f
#define regSQ_SOP2_BASE_IDX                                                                             0
#define regSQ_SOPC                                                                                      0x037f
#define regSQ_SOPC_BASE_IDX                                                                             0
#define regSQ_SOPK                                                                                      0x037f
#define regSQ_SOPK_BASE_IDX                                                                             0
#define regSQ_SOPP                                                                                      0x037f
#define regSQ_SOPP_BASE_IDX                                                                             0
#define regSQ_VINTRP                                                                                    0x037f
#define regSQ_VINTRP_BASE_IDX                                                                           0
#define regSQ_VOP1                                                                                      0x037f
#define regSQ_VOP1_BASE_IDX                                                                             0
#define regSQ_VOP2                                                                                      0x037f
#define regSQ_VOP2_BASE_IDX                                                                             0
#define regSQ_VOP3P_0                                                                                   0x037f
#define regSQ_VOP3P_0_BASE_IDX                                                                          0
#define regSQ_VOP3P_1                                                                                   0x037f
#define regSQ_VOP3P_1_BASE_IDX                                                                          0
#define regSQ_VOP3P_MFMA_0                                                                              0x037f
#define regSQ_VOP3P_MFMA_0_BASE_IDX                                                                     0
#define regSQ_VOP3P_MFMA_1                                                                              0x037f
#define regSQ_VOP3P_MFMA_1_BASE_IDX                                                                     0
#define regSQ_VOP3_0                                                                                    0x037f
#define regSQ_VOP3_0_BASE_IDX                                                                           0
#define regSQ_VOP3_0_SDST_ENC                                                                           0x037f
#define regSQ_VOP3_0_SDST_ENC_BASE_IDX                                                                  0
#define regSQ_VOP3_1                                                                                    0x037f
#define regSQ_VOP3_1_BASE_IDX                                                                           0
#define regSQ_VOPC                                                                                      0x037f
#define regSQ_VOPC_BASE_IDX                                                                             0
#define regSQ_VOP_DPP                                                                                   0x037f
#define regSQ_VOP_DPP_BASE_IDX                                                                          0
#define regSQ_VOP_SDWA                                                                                  0x037f
#define regSQ_VOP_SDWA_BASE_IDX                                                                         0
#define regSQ_VOP_SDWA_SDST_ENC                                                                         0x037f
#define regSQ_VOP_SDWA_SDST_ENC_BASE_IDX                                                                0
#define regSQ_LB_CTR_CTRL                                                                               0x0398
#define regSQ_LB_CTR_CTRL_BASE_IDX                                                                      0
#define regSQ_LB_DATA0                                                                                  0x0399
#define regSQ_LB_DATA0_BASE_IDX                                                                         0
#define regSQ_LB_DATA1                                                                                  0x039a
#define regSQ_LB_DATA1_BASE_IDX                                                                         0
#define regSQ_LB_DATA2                                                                                  0x039b
#define regSQ_LB_DATA2_BASE_IDX                                                                         0
#define regSQ_LB_DATA3                                                                                  0x039c
#define regSQ_LB_DATA3_BASE_IDX                                                                         0
#define regSQ_LB_CTR_SEL                                                                                0x039d
#define regSQ_LB_CTR_SEL_BASE_IDX                                                                       0
#define regSQ_LB_CTR0_CU                                                                                0x039e
#define regSQ_LB_CTR0_CU_BASE_IDX                                                                       0
#define regSQ_LB_CTR1_CU                                                                                0x039f
#define regSQ_LB_CTR1_CU_BASE_IDX                                                                       0
#define regSQ_LB_CTR2_CU                                                                                0x03a0
#define regSQ_LB_CTR2_CU_BASE_IDX                                                                       0
#define regSQ_LB_CTR3_CU                                                                                0x03a1
#define regSQ_LB_CTR3_CU_BASE_IDX                                                                       0
#define regSQC_EDC_CNT                                                                                  0x03a2
#define regSQC_EDC_CNT_BASE_IDX                                                                         0
#define regSQ_EDC_SEC_CNT                                                                               0x03a3
#define regSQ_EDC_SEC_CNT_BASE_IDX                                                                      0
#define regSQ_EDC_DED_CNT                                                                               0x03a4
#define regSQ_EDC_DED_CNT_BASE_IDX                                                                      0
#define regSQ_EDC_INFO                                                                                  0x03a5
#define regSQ_EDC_INFO_BASE_IDX                                                                         0
#define regSQ_EDC_CNT                                                                                   0x03a6
#define regSQ_EDC_CNT_BASE_IDX                                                                          0
#define regSQ_EDC_FUE_CNTL                                                                              0x03a7
#define regSQ_EDC_FUE_CNTL_BASE_IDX                                                                     0
#define regSQ_THREAD_TRACE_WORD_CMN                                                                     0x03b0
#define regSQ_THREAD_TRACE_WORD_CMN_BASE_IDX                                                            0
#define regSQ_THREAD_TRACE_WORD_EVENT                                                                   0x03b0
#define regSQ_THREAD_TRACE_WORD_EVENT_BASE_IDX                                                          0
#define regSQ_THREAD_TRACE_WORD_INST                                                                    0x03b0
#define regSQ_THREAD_TRACE_WORD_INST_BASE_IDX                                                           0
#define regSQ_THREAD_TRACE_WORD_INST_PC_1_OF_2                                                          0x03b0
#define regSQ_THREAD_TRACE_WORD_INST_PC_1_OF_2_BASE_IDX                                                 0
#define regSQ_THREAD_TRACE_WORD_INST_USERDATA_1_OF_2                                                    0x03b0
#define regSQ_THREAD_TRACE_WORD_INST_USERDATA_1_OF_2_BASE_IDX                                           0
#define regSQ_THREAD_TRACE_WORD_ISSUE                                                                   0x03b0
#define regSQ_THREAD_TRACE_WORD_ISSUE_BASE_IDX                                                          0
#define regSQ_THREAD_TRACE_WORD_MISC                                                                    0x03b0
#define regSQ_THREAD_TRACE_WORD_MISC_BASE_IDX                                                           0
#define regSQ_THREAD_TRACE_WORD_PERF_1_OF_2                                                             0x03b0
#define regSQ_THREAD_TRACE_WORD_PERF_1_OF_2_BASE_IDX                                                    0
#define regSQ_THREAD_TRACE_WORD_REG_1_OF_2                                                              0x03b0
#define regSQ_THREAD_TRACE_WORD_REG_1_OF_2_BASE_IDX                                                     0
#define regSQ_THREAD_TRACE_WORD_REG_2_OF_2                                                              0x03b0
#define regSQ_THREAD_TRACE_WORD_REG_2_OF_2_BASE_IDX                                                     0
#define regSQ_THREAD_TRACE_WORD_REG_CS_1_OF_2                                                           0x03b0
#define regSQ_THREAD_TRACE_WORD_REG_CS_1_OF_2_BASE_IDX                                                  0
#define regSQ_THREAD_TRACE_WORD_REG_CS_2_OF_2                                                           0x03b0
#define regSQ_THREAD_TRACE_WORD_REG_CS_2_OF_2_BASE_IDX                                                  0
#define regSQ_THREAD_TRACE_WORD_TIMESTAMP_1_OF_2                                                        0x03b0
#define regSQ_THREAD_TRACE_WORD_TIMESTAMP_1_OF_2_BASE_IDX                                               0
#define regSQ_THREAD_TRACE_WORD_WAVE                                                                    0x03b0
#define regSQ_THREAD_TRACE_WORD_WAVE_BASE_IDX                                                           0
#define regSQ_THREAD_TRACE_WORD_WAVE_START                                                              0x03b0
#define regSQ_THREAD_TRACE_WORD_WAVE_START_BASE_IDX                                                     0
#define regSQ_THREAD_TRACE_WORD_INST_PC_2_OF_2                                                          0x03b1
#define regSQ_THREAD_TRACE_WORD_INST_PC_2_OF_2_BASE_IDX                                                 0
#define regSQ_THREAD_TRACE_WORD_INST_USERDATA_2_OF_2                                                    0x03b1
#define regSQ_THREAD_TRACE_WORD_INST_USERDATA_2_OF_2_BASE_IDX                                           0
#define regSQ_THREAD_TRACE_WORD_PERF_2_OF_2                                                             0x03b1
#define regSQ_THREAD_TRACE_WORD_PERF_2_OF_2_BASE_IDX                                                    0
#define regSQ_THREAD_TRACE_WORD_TIMESTAMP_2_OF_2                                                        0x03b1
#define regSQ_THREAD_TRACE_WORD_TIMESTAMP_2_OF_2_BASE_IDX                                               0
#define regSQ_WREXEC_EXEC_HI                                                                            0x03b1
#define regSQ_WREXEC_EXEC_HI_BASE_IDX                                                                   0
#define regSQ_WREXEC_EXEC_LO                                                                            0x03b1
#define regSQ_WREXEC_EXEC_LO_BASE_IDX                                                                   0
#define regSQ_BUF_RSRC_WORD0                                                                            0x03c0
#define regSQ_BUF_RSRC_WORD0_BASE_IDX                                                                   0
#define regSQ_BUF_RSRC_WORD1                                                                            0x03c1
#define regSQ_BUF_RSRC_WORD1_BASE_IDX                                                                   0
#define regSQ_BUF_RSRC_WORD2                                                                            0x03c2
#define regSQ_BUF_RSRC_WORD2_BASE_IDX                                                                   0
#define regSQ_BUF_RSRC_WORD3                                                                            0x03c3
#define regSQ_BUF_RSRC_WORD3_BASE_IDX                                                                   0
#define regSQ_IMG_RSRC_WORD0                                                                            0x03c4
#define regSQ_IMG_RSRC_WORD0_BASE_IDX                                                                   0
#define regSQ_IMG_RSRC_WORD1                                                                            0x03c5
#define regSQ_IMG_RSRC_WORD1_BASE_IDX                                                                   0
#define regSQ_IMG_RSRC_WORD2                                                                            0x03c6
#define regSQ_IMG_RSRC_WORD2_BASE_IDX                                                                   0
#define regSQ_IMG_RSRC_WORD3                                                                            0x03c7
#define regSQ_IMG_RSRC_WORD3_BASE_IDX                                                                   0
#define regSQ_IMG_RSRC_WORD4                                                                            0x03c8
#define regSQ_IMG_RSRC_WORD4_BASE_IDX                                                                   0
#define regSQ_IMG_RSRC_WORD5                                                                            0x03c9
#define regSQ_IMG_RSRC_WORD5_BASE_IDX                                                                   0
#define regSQ_IMG_RSRC_WORD6                                                                            0x03ca
#define regSQ_IMG_RSRC_WORD6_BASE_IDX                                                                   0
#define regSQ_IMG_RSRC_WORD7                                                                            0x03cb
#define regSQ_IMG_RSRC_WORD7_BASE_IDX                                                                   0
#define regSQ_IMG_SAMP_WORD0                                                                            0x03cc
#define regSQ_IMG_SAMP_WORD0_BASE_IDX                                                                   0
#define regSQ_IMG_SAMP_WORD1                                                                            0x03cd
#define regSQ_IMG_SAMP_WORD1_BASE_IDX                                                                   0
#define regSQ_IMG_SAMP_WORD2                                                                            0x03ce
#define regSQ_IMG_SAMP_WORD2_BASE_IDX                                                                   0
#define regSQ_IMG_SAMP_WORD3                                                                            0x03cf
#define regSQ_IMG_SAMP_WORD3_BASE_IDX                                                                   0
#define regSQ_FLAT_SCRATCH_WORD0                                                                        0x03d0
#define regSQ_FLAT_SCRATCH_WORD0_BASE_IDX                                                               0
#define regSQ_FLAT_SCRATCH_WORD1                                                                        0x03d1
#define regSQ_FLAT_SCRATCH_WORD1_BASE_IDX                                                               0
#define regSQ_M0_GPR_IDX_WORD                                                                           0x03d2
#define regSQ_M0_GPR_IDX_WORD_BASE_IDX                                                                  0
#define regSQC_ICACHE_UTCL1_CNTL1                                                                       0x03d3
#define regSQC_ICACHE_UTCL1_CNTL1_BASE_IDX                                                              0
#define regSQC_ICACHE_UTCL1_CNTL2                                                                       0x03d4
#define regSQC_ICACHE_UTCL1_CNTL2_BASE_IDX                                                              0
#define regSQC_DCACHE_UTCL1_CNTL1                                                                       0x03d5
#define regSQC_DCACHE_UTCL1_CNTL1_BASE_IDX                                                              0
#define regSQC_DCACHE_UTCL1_CNTL2                                                                       0x03d6
#define regSQC_DCACHE_UTCL1_CNTL2_BASE_IDX                                                              0
#define regSQC_ICACHE_UTCL1_STATUS                                                                      0x03d7
#define regSQC_ICACHE_UTCL1_STATUS_BASE_IDX                                                             0
#define regSQC_DCACHE_UTCL1_STATUS                                                                      0x03d8
#define regSQC_DCACHE_UTCL1_STATUS_BASE_IDX                                                             0
#define regSQC_UE_EDC_LO                                                                                0x03d9
#define regSQC_UE_EDC_LO_BASE_IDX                                                                       0
#define regSQC_UE_EDC_HI                                                                                0x03da
#define regSQC_UE_EDC_HI_BASE_IDX                                                                       0
#define regSQC_CE_EDC_LO                                                                                0x03db
#define regSQC_CE_EDC_LO_BASE_IDX                                                                       0
#define regSQC_CE_EDC_HI                                                                                0x03dc
#define regSQC_CE_EDC_HI_BASE_IDX                                                                       0
#define regSQ_UE_ERR_STATUS_LO                                                                          0x03dd
#define regSQ_UE_ERR_STATUS_LO_BASE_IDX                                                                 0
#define regSQ_UE_ERR_STATUS_HI                                                                          0x03de
#define regSQ_UE_ERR_STATUS_HI_BASE_IDX                                                                 0
#define regSQ_CE_ERR_STATUS_LO                                                                          0x03df
#define regSQ_CE_ERR_STATUS_LO_BASE_IDX                                                                 0
#define regSQ_CE_ERR_STATUS_HI                                                                          0x03e0
#define regSQ_CE_ERR_STATUS_HI_BASE_IDX                                                                 0
#define regLDS_UE_ERR_STATUS_LO                                                                         0x03e1
#define regLDS_UE_ERR_STATUS_LO_BASE_IDX                                                                0
#define regLDS_UE_ERR_STATUS_HI                                                                         0x03e2
#define regLDS_UE_ERR_STATUS_HI_BASE_IDX                                                                0
#define regLDS_CE_ERR_STATUS_LO                                                                         0x03e3
#define regLDS_CE_ERR_STATUS_LO_BASE_IDX                                                                0
#define regLDS_CE_ERR_STATUS_HI                                                                         0x03e4
#define regLDS_CE_ERR_STATUS_HI_BASE_IDX                                                                0
#define regSP0_UE_ERR_STATUS_LO                                                                         0x03e5
#define regSP0_UE_ERR_STATUS_LO_BASE_IDX                                                                0
#define regSP0_UE_ERR_STATUS_HI                                                                         0x03e6
#define regSP0_UE_ERR_STATUS_HI_BASE_IDX                                                                0
#define regSP0_CE_ERR_STATUS_LO                                                                         0x03e7
#define regSP0_CE_ERR_STATUS_LO_BASE_IDX                                                                0
#define regSP0_CE_ERR_STATUS_HI                                                                         0x03e8
#define regSP0_CE_ERR_STATUS_HI_BASE_IDX                                                                0
#define regSP1_UE_ERR_STATUS_LO                                                                         0x03e9
#define regSP1_UE_ERR_STATUS_LO_BASE_IDX                                                                0
#define regSP1_UE_ERR_STATUS_HI                                                                         0x03ea
#define regSP1_UE_ERR_STATUS_HI_BASE_IDX                                                                0
#define regSP1_CE_ERR_STATUS_LO                                                                         0x03eb
#define regSP1_CE_ERR_STATUS_LO_BASE_IDX                                                                0
#define regSP1_CE_ERR_STATUS_HI                                                                         0x03ec
#define regSP1_CE_ERR_STATUS_HI_BASE_IDX                                                                0


// addressBlock: xcd0_gc_shsdec
// base address: 0x9000
#define regSX_DEBUG_BUSY                                                                                0x0414
#define regSX_DEBUG_BUSY_BASE_IDX                                                                       0
#define regSX_DEBUG_1                                                                                   0x0419
#define regSX_DEBUG_1_BASE_IDX                                                                          0
#define regSPI_PS_MAX_WAVE_ID                                                                           0x043a
#define regSPI_PS_MAX_WAVE_ID_BASE_IDX                                                                  0
#define regSPI_START_PHASE                                                                              0x043b
#define regSPI_START_PHASE_BASE_IDX                                                                     0
#define regSPI_GFX_CNTL                                                                                 0x043c
#define regSPI_GFX_CNTL_BASE_IDX                                                                        0
#define regSPI_DEBUG_READ                                                                               0x0442
#define regSPI_DEBUG_READ_BASE_IDX                                                                      0
#define regSPI_DSM_CNTL                                                                                 0x0443
#define regSPI_DSM_CNTL_BASE_IDX                                                                        0
#define regSPI_DSM_CNTL2                                                                                0x0444
#define regSPI_DSM_CNTL2_BASE_IDX                                                                       0
#define regSPI_EDC_CNT                                                                                  0x0445
#define regSPI_EDC_CNT_BASE_IDX                                                                         0
#define regSPI_UE_ERR_STATUS_LO                                                                         0x0446
#define regSPI_UE_ERR_STATUS_LO_BASE_IDX                                                                0
#define regSPI_UE_ERR_STATUS_HI                                                                         0x0447
#define regSPI_UE_ERR_STATUS_HI_BASE_IDX                                                                0
#define regSPI_CE_ERR_STATUS_LO                                                                         0x0448
#define regSPI_CE_ERR_STATUS_LO_BASE_IDX                                                                0
#define regSPI_CE_ERR_STATUS_HI                                                                         0x0449
#define regSPI_CE_ERR_STATUS_HI_BASE_IDX                                                                0
#define regSPI_DEBUG_BUSY                                                                               0x0450
#define regSPI_DEBUG_BUSY_BASE_IDX                                                                      0
#define regSPI_CONFIG_PS_CU_EN                                                                          0x0452
#define regSPI_CONFIG_PS_CU_EN_BASE_IDX                                                                 0
#define regSPI_WF_LIFETIME_CNTL                                                                         0x04aa
#define regSPI_WF_LIFETIME_CNTL_BASE_IDX                                                                0
#define regSPI_WF_LIFETIME_LIMIT_0                                                                      0x04ab
#define regSPI_WF_LIFETIME_LIMIT_0_BASE_IDX                                                             0
#define regSPI_WF_LIFETIME_LIMIT_1                                                                      0x04ac
#define regSPI_WF_LIFETIME_LIMIT_1_BASE_IDX                                                             0
#define regSPI_WF_LIFETIME_LIMIT_2                                                                      0x04ad
#define regSPI_WF_LIFETIME_LIMIT_2_BASE_IDX                                                             0
#define regSPI_WF_LIFETIME_LIMIT_3                                                                      0x04ae
#define regSPI_WF_LIFETIME_LIMIT_3_BASE_IDX                                                             0
#define regSPI_WF_LIFETIME_LIMIT_4                                                                      0x04af
#define regSPI_WF_LIFETIME_LIMIT_4_BASE_IDX                                                             0
#define regSPI_WF_LIFETIME_LIMIT_5                                                                      0x04b0
#define regSPI_WF_LIFETIME_LIMIT_5_BASE_IDX                                                             0
#define regSPI_WF_LIFETIME_LIMIT_6                                                                      0x04b1
#define regSPI_WF_LIFETIME_LIMIT_6_BASE_IDX                                                             0
#define regSPI_WF_LIFETIME_LIMIT_7                                                                      0x04b2
#define regSPI_WF_LIFETIME_LIMIT_7_BASE_IDX                                                             0
#define regSPI_WF_LIFETIME_LIMIT_8                                                                      0x04b3
#define regSPI_WF_LIFETIME_LIMIT_8_BASE_IDX                                                             0
#define regSPI_WF_LIFETIME_LIMIT_9                                                                      0x04b4
#define regSPI_WF_LIFETIME_LIMIT_9_BASE_IDX                                                             0
#define regSPI_WF_LIFETIME_STATUS_0                                                                     0x04b5
#define regSPI_WF_LIFETIME_STATUS_0_BASE_IDX                                                            0
#define regSPI_WF_LIFETIME_STATUS_1                                                                     0x04b6
#define regSPI_WF_LIFETIME_STATUS_1_BASE_IDX                                                            0
#define regSPI_WF_LIFETIME_STATUS_2                                                                     0x04b7
#define regSPI_WF_LIFETIME_STATUS_2_BASE_IDX                                                            0
#define regSPI_WF_LIFETIME_STATUS_3                                                                     0x04b8
#define regSPI_WF_LIFETIME_STATUS_3_BASE_IDX                                                            0
#define regSPI_WF_LIFETIME_STATUS_4                                                                     0x04b9
#define regSPI_WF_LIFETIME_STATUS_4_BASE_IDX                                                            0
#define regSPI_WF_LIFETIME_STATUS_5                                                                     0x04ba
#define regSPI_WF_LIFETIME_STATUS_5_BASE_IDX                                                            0
#define regSPI_WF_LIFETIME_STATUS_6                                                                     0x04bb
#define regSPI_WF_LIFETIME_STATUS_6_BASE_IDX                                                            0
#define regSPI_WF_LIFETIME_STATUS_7                                                                     0x04bc
#define regSPI_WF_LIFETIME_STATUS_7_BASE_IDX                                                            0
#define regSPI_WF_LIFETIME_STATUS_8                                                                     0x04bd
#define regSPI_WF_LIFETIME_STATUS_8_BASE_IDX                                                            0
#define regSPI_WF_LIFETIME_STATUS_9                                                                     0x04be
#define regSPI_WF_LIFETIME_STATUS_9_BASE_IDX                                                            0
#define regSPI_WF_LIFETIME_STATUS_10                                                                    0x04bf
#define regSPI_WF_LIFETIME_STATUS_10_BASE_IDX                                                           0
#define regSPI_WF_LIFETIME_STATUS_11                                                                    0x04c0
#define regSPI_WF_LIFETIME_STATUS_11_BASE_IDX                                                           0
#define regSPI_WF_LIFETIME_STATUS_12                                                                    0x04c1
#define regSPI_WF_LIFETIME_STATUS_12_BASE_IDX                                                           0
#define regSPI_WF_LIFETIME_STATUS_13                                                                    0x04c2
#define regSPI_WF_LIFETIME_STATUS_13_BASE_IDX                                                           0
#define regSPI_WF_LIFETIME_STATUS_14                                                                    0x04c3
#define regSPI_WF_LIFETIME_STATUS_14_BASE_IDX                                                           0
#define regSPI_WF_LIFETIME_STATUS_15                                                                    0x04c4
#define regSPI_WF_LIFETIME_STATUS_15_BASE_IDX                                                           0
#define regSPI_WF_LIFETIME_STATUS_16                                                                    0x04c5
#define regSPI_WF_LIFETIME_STATUS_16_BASE_IDX                                                           0
#define regSPI_WF_LIFETIME_STATUS_17                                                                    0x04c6
#define regSPI_WF_LIFETIME_STATUS_17_BASE_IDX                                                           0
#define regSPI_WF_LIFETIME_STATUS_18                                                                    0x04c7
#define regSPI_WF_LIFETIME_STATUS_18_BASE_IDX                                                           0
#define regSPI_WF_LIFETIME_STATUS_19                                                                    0x04c8
#define regSPI_WF_LIFETIME_STATUS_19_BASE_IDX                                                           0
#define regSPI_WF_LIFETIME_STATUS_20                                                                    0x04c9
#define regSPI_WF_LIFETIME_STATUS_20_BASE_IDX                                                           0
#define regSPI_WF_LIFETIME_DEBUG                                                                        0x04ca
#define regSPI_WF_LIFETIME_DEBUG_BASE_IDX                                                               0
#define regSPI_LB_CTR_CTRL                                                                              0x04d4
#define regSPI_LB_CTR_CTRL_BASE_IDX                                                                     0
#define regSPI_LB_CU_MASK                                                                               0x04d5
#define regSPI_LB_CU_MASK_BASE_IDX                                                                      0
#define regSPI_LB_DATA_REG                                                                              0x04d6
#define regSPI_LB_DATA_REG_BASE_IDX                                                                     0
#define regSPI_PG_ENABLE_STATIC_CU_MASK                                                                 0x04d7
#define regSPI_PG_ENABLE_STATIC_CU_MASK_BASE_IDX                                                        0
#define regSPI_GDS_CREDITS                                                                              0x04d8
#define regSPI_GDS_CREDITS_BASE_IDX                                                                     0
#define regSPI_SX_EXPORT_BUFFER_SIZES                                                                   0x04d9
#define regSPI_SX_EXPORT_BUFFER_SIZES_BASE_IDX                                                          0
#define regSPI_SX_SCOREBOARD_BUFFER_SIZES                                                               0x04da
#define regSPI_SX_SCOREBOARD_BUFFER_SIZES_BASE_IDX                                                      0
#define regSPI_CSQ_WF_ACTIVE_STATUS                                                                     0x04db
#define regSPI_CSQ_WF_ACTIVE_STATUS_BASE_IDX                                                            0
#define regSPI_CSQ_WF_ACTIVE_COUNT_0                                                                    0x04dc
#define regSPI_CSQ_WF_ACTIVE_COUNT_0_BASE_IDX                                                           0
#define regSPI_CSQ_WF_ACTIVE_COUNT_1                                                                    0x04dd
#define regSPI_CSQ_WF_ACTIVE_COUNT_1_BASE_IDX                                                           0
#define regSPI_CSQ_WF_ACTIVE_COUNT_2                                                                    0x04de
#define regSPI_CSQ_WF_ACTIVE_COUNT_2_BASE_IDX                                                           0
#define regSPI_CSQ_WF_ACTIVE_COUNT_3                                                                    0x04df
#define regSPI_CSQ_WF_ACTIVE_COUNT_3_BASE_IDX                                                           0
#define regSPI_CSQ_WF_ACTIVE_COUNT_4                                                                    0x04e0
#define regSPI_CSQ_WF_ACTIVE_COUNT_4_BASE_IDX                                                           0
#define regSPI_CSQ_WF_ACTIVE_COUNT_5                                                                    0x04e1
#define regSPI_CSQ_WF_ACTIVE_COUNT_5_BASE_IDX                                                           0
#define regSPI_CSQ_WF_ACTIVE_COUNT_6                                                                    0x04e2
#define regSPI_CSQ_WF_ACTIVE_COUNT_6_BASE_IDX                                                           0
#define regSPI_CSQ_WF_ACTIVE_COUNT_7                                                                    0x04e3
#define regSPI_CSQ_WF_ACTIVE_COUNT_7_BASE_IDX                                                           0
#define regSPI_LB_DATA_WAVES                                                                            0x04e4
#define regSPI_LB_DATA_WAVES_BASE_IDX                                                                   0
#define regSPI_LB_DATA_PERCU_WAVE_HSGS                                                                  0x04e5
#define regSPI_LB_DATA_PERCU_WAVE_HSGS_BASE_IDX                                                         0
#define regSPI_LB_DATA_PERCU_WAVE_VSPS                                                                  0x04e6
#define regSPI_LB_DATA_PERCU_WAVE_VSPS_BASE_IDX                                                         0
#define regSPI_LB_DATA_PERCU_WAVE_CS                                                                    0x04e7
#define regSPI_LB_DATA_PERCU_WAVE_CS_BASE_IDX                                                           0
#define regSPIS_DEBUG_READ                                                                              0x04ea
#define regSPIS_DEBUG_READ_BASE_IDX                                                                     0
#define regBCI_DEBUG_READ                                                                               0x04eb
#define regBCI_DEBUG_READ_BASE_IDX                                                                      0
#define regSPI_P0_TRAP_SCREEN_PSBA_LO                                                                   0x04ec
#define regSPI_P0_TRAP_SCREEN_PSBA_LO_BASE_IDX                                                          0
#define regSPI_P0_TRAP_SCREEN_PSBA_HI                                                                   0x04ed
#define regSPI_P0_TRAP_SCREEN_PSBA_HI_BASE_IDX                                                          0
#define regSPI_P0_TRAP_SCREEN_PSMA_LO                                                                   0x04ee
#define regSPI_P0_TRAP_SCREEN_PSMA_LO_BASE_IDX                                                          0
#define regSPI_P0_TRAP_SCREEN_PSMA_HI                                                                   0x04ef
#define regSPI_P0_TRAP_SCREEN_PSMA_HI_BASE_IDX                                                          0
#define regSPI_P0_TRAP_SCREEN_GPR_MIN                                                                   0x04f0
#define regSPI_P0_TRAP_SCREEN_GPR_MIN_BASE_IDX                                                          0
#define regSPI_P1_TRAP_SCREEN_PSBA_LO                                                                   0x04f1
#define regSPI_P1_TRAP_SCREEN_PSBA_LO_BASE_IDX                                                          0
#define regSPI_P1_TRAP_SCREEN_PSBA_HI                                                                   0x04f2
#define regSPI_P1_TRAP_SCREEN_PSBA_HI_BASE_IDX                                                          0
#define regSPI_P1_TRAP_SCREEN_PSMA_LO                                                                   0x04f3
#define regSPI_P1_TRAP_SCREEN_PSMA_LO_BASE_IDX                                                          0
#define regSPI_P1_TRAP_SCREEN_PSMA_HI                                                                   0x04f4
#define regSPI_P1_TRAP_SCREEN_PSMA_HI_BASE_IDX                                                          0
#define regSPI_P1_TRAP_SCREEN_GPR_MIN                                                                   0x04f5
#define regSPI_P1_TRAP_SCREEN_GPR_MIN_BASE_IDX                                                          0


// addressBlock: xcd0_gc_tpdec
// base address: 0x9400
#define regTD_CNTL                                                                                      0x0525
#define regTD_CNTL_BASE_IDX                                                                             0
#define regTD_STATUS                                                                                    0x0526
#define regTD_STATUS_BASE_IDX                                                                           0
#define regTD_POWER_CNTL                                                                                0x052a
#define regTD_POWER_CNTL_BASE_IDX                                                                       0
#define regTD_UE_EDC_LO                                                                                 0x052b
#define regTD_UE_EDC_LO_BASE_IDX                                                                        0
#define regTD_UE_EDC_HI                                                                                 0x052c
#define regTD_UE_EDC_HI_BASE_IDX                                                                        0
#define regTD_CE_EDC_LO                                                                                 0x052d
#define regTD_CE_EDC_LO_BASE_IDX                                                                        0
#define regTD_CE_EDC_HI                                                                                 0x052e
#define regTD_CE_EDC_HI_BASE_IDX                                                                        0
#define regTD_DSM_CNTL                                                                                  0x052f
#define regTD_DSM_CNTL_BASE_IDX                                                                         0
#define regTD_DSM_CNTL2                                                                                 0x0530
#define regTD_DSM_CNTL2_BASE_IDX                                                                        0
#define regTD_SCRATCH                                                                                   0x0533
#define regTD_SCRATCH_BASE_IDX                                                                          0
#define regTA_POWER_CNTL                                                                                0x0540
#define regTA_POWER_CNTL_BASE_IDX                                                                       0
#define regTA_CNTL                                                                                      0x0541
#define regTA_CNTL_BASE_IDX                                                                             0
#define regTA_CNTL_AUX                                                                                  0x0542
#define regTA_CNTL_AUX_BASE_IDX                                                                         0
#define regTA_FEATURE_CNTL                                                                              0x0543
#define regTA_FEATURE_CNTL_BASE_IDX                                                                     0
#define regTA_STATUS                                                                                    0x0548
#define regTA_STATUS_BASE_IDX                                                                           0
#define regTA_SCRATCH                                                                                   0x0564
#define regTA_SCRATCH_BASE_IDX                                                                          0
#define regTA_DSM_CNTL                                                                                  0x0584
#define regTA_DSM_CNTL_BASE_IDX                                                                         0
#define regTA_DSM_CNTL2                                                                                 0x0585
#define regTA_DSM_CNTL2_BASE_IDX                                                                        0
#define regTA_UE_EDC_LO                                                                                 0x0587
#define regTA_UE_EDC_LO_BASE_IDX                                                                        0
#define regTA_UE_EDC_HI                                                                                 0x0588
#define regTA_UE_EDC_HI_BASE_IDX                                                                        0
#define regTA_CE_EDC_LO                                                                                 0x0589
#define regTA_CE_EDC_LO_BASE_IDX                                                                        0
#define regTA_CE_EDC_HI                                                                                 0x058a
#define regTA_CE_EDC_HI_BASE_IDX                                                                        0


// addressBlock: xcd0_gc_gdsdec
// base address: 0x9700
#define regGDS_CONFIG                                                                                   0x05c0
#define regGDS_CONFIG_BASE_IDX                                                                          0
#define regGDS_CNTL_STATUS                                                                              0x05c1
#define regGDS_CNTL_STATUS_BASE_IDX                                                                     0
#define regGDS_ENHANCE2                                                                                 0x05c2
#define regGDS_ENHANCE2_BASE_IDX                                                                        0
#define regGDS_PROTECTION_FAULT                                                                         0x05c3
#define regGDS_PROTECTION_FAULT_BASE_IDX                                                                0
#define regGDS_VM_PROTECTION_FAULT                                                                      0x05c4
#define regGDS_VM_PROTECTION_FAULT_BASE_IDX                                                             0
#define regGDS_EDC_CNT                                                                                  0x05c5
#define regGDS_EDC_CNT_BASE_IDX                                                                         0
#define regGDS_EDC_GRBM_CNT                                                                             0x05c6
#define regGDS_EDC_GRBM_CNT_BASE_IDX                                                                    0
#define regGDS_EDC_OA_DED                                                                               0x05c7
#define regGDS_EDC_OA_DED_BASE_IDX                                                                      0
#define regGDS_DSM_CNTL                                                                                 0x05ca
#define regGDS_DSM_CNTL_BASE_IDX                                                                        0
#define regGDS_EDC_OA_PHY_CNT                                                                           0x05cb
#define regGDS_EDC_OA_PHY_CNT_BASE_IDX                                                                  0
#define regGDS_EDC_OA_PIPE_CNT                                                                          0x05cc
#define regGDS_EDC_OA_PIPE_CNT_BASE_IDX                                                                 0
#define regGDS_DSM_CNTL2                                                                                0x05cd
#define regGDS_DSM_CNTL2_BASE_IDX                                                                       0
#define regGDS_WD_GDS_CSB                                                                               0x05ce
#define regGDS_WD_GDS_CSB_BASE_IDX                                                                      0
#define regGDS_UE_ERR_STATUS_LO                                                                         0x05cf
#define regGDS_UE_ERR_STATUS_LO_BASE_IDX                                                                0
#define regGDS_UE_ERR_STATUS_HI                                                                         0x05d0
#define regGDS_UE_ERR_STATUS_HI_BASE_IDX                                                                0
#define regGDS_CE_ERR_STATUS_LO                                                                         0x05d1
#define regGDS_CE_ERR_STATUS_LO_BASE_IDX                                                                0
#define regGDS_CE_ERR_STATUS_HI                                                                         0x05d2
#define regGDS_CE_ERR_STATUS_HI_BASE_IDX                                                                0


// addressBlock: xcd0_gc_rbdec
// base address: 0x9800
#define regDB_DEBUG                                                                                     0x060c
#define regDB_DEBUG_BASE_IDX                                                                            0
#define regDB_DEBUG2                                                                                    0x060d
#define regDB_DEBUG2_BASE_IDX                                                                           0
#define regDB_DEBUG3                                                                                    0x060e
#define regDB_DEBUG3_BASE_IDX                                                                           0
#define regDB_DEBUG4                                                                                    0x060f
#define regDB_DEBUG4_BASE_IDX                                                                           0
#define regDB_CREDIT_LIMIT                                                                              0x0614
#define regDB_CREDIT_LIMIT_BASE_IDX                                                                     0
#define regDB_WATERMARKS                                                                                0x0615
#define regDB_WATERMARKS_BASE_IDX                                                                       0
#define regDB_SUBTILE_CONTROL                                                                           0x0616
#define regDB_SUBTILE_CONTROL_BASE_IDX                                                                  0
#define regDB_FREE_CACHELINES                                                                           0x0617
#define regDB_FREE_CACHELINES_BASE_IDX                                                                  0
#define regDB_FIFO_DEPTH1                                                                               0x0618
#define regDB_FIFO_DEPTH1_BASE_IDX                                                                      0
#define regDB_FIFO_DEPTH2                                                                               0x0619
#define regDB_FIFO_DEPTH2_BASE_IDX                                                                      0
#define regDB_EXCEPTION_CONTROL                                                                         0x061a
#define regDB_EXCEPTION_CONTROL_BASE_IDX                                                                0
#define regDB_RING_CONTROL                                                                              0x061b
#define regDB_RING_CONTROL_BASE_IDX                                                                     0
#define regDB_MEM_ARB_WATERMARKS                                                                        0x061c
#define regDB_MEM_ARB_WATERMARKS_BASE_IDX                                                               0
#define regDB_RMI_CACHE_POLICY                                                                          0x061e
#define regDB_RMI_CACHE_POLICY_BASE_IDX                                                                 0
#define regDB_DFSM_CONFIG                                                                               0x0630
#define regDB_DFSM_CONFIG_BASE_IDX                                                                      0
#define regDB_DFSM_WATERMARK                                                                            0x0631
#define regDB_DFSM_WATERMARK_BASE_IDX                                                                   0
#define regDB_DFSM_TILES_IN_FLIGHT                                                                      0x0632
#define regDB_DFSM_TILES_IN_FLIGHT_BASE_IDX                                                             0
#define regDB_DFSM_PRIMS_IN_FLIGHT                                                                      0x0633
#define regDB_DFSM_PRIMS_IN_FLIGHT_BASE_IDX                                                             0
#define regDB_DFSM_WATCHDOG                                                                             0x0634
#define regDB_DFSM_WATCHDOG_BASE_IDX                                                                    0
#define regDB_DFSM_FLUSH_ENABLE                                                                         0x0635
#define regDB_DFSM_FLUSH_ENABLE_BASE_IDX                                                                0
#define regDB_DFSM_FLUSH_AUX_EVENT                                                                      0x0636
#define regDB_DFSM_FLUSH_AUX_EVENT_BASE_IDX                                                             0
#define regCC_RB_REDUNDANCY                                                                             0x063c
#define regCC_RB_REDUNDANCY_BASE_IDX                                                                    0
#define regCC_RB_BACKEND_DISABLE                                                                        0x063d
#define regCC_RB_BACKEND_DISABLE_BASE_IDX                                                               0
#define regGB_ADDR_CONFIG                                                                               0x063e
#define regGB_ADDR_CONFIG_BASE_IDX                                                                      0
#define regGB_BACKEND_MAP                                                                               0x063f
#define regGB_BACKEND_MAP_BASE_IDX                                                                      0
#define regGB_GPU_ID                                                                                    0x0640
#define regGB_GPU_ID_BASE_IDX                                                                           0
#define regCC_RB_DAISY_CHAIN                                                                            0x0641
#define regCC_RB_DAISY_CHAIN_BASE_IDX                                                                   0
#define regGB_ADDR_CONFIG_READ                                                                          0x0642
#define regGB_ADDR_CONFIG_READ_BASE_IDX                                                                 0
#define regGB_TILE_MODE0                                                                                0x0644
#define regGB_TILE_MODE0_BASE_IDX                                                                       0
#define regGB_TILE_MODE1                                                                                0x0645
#define regGB_TILE_MODE1_BASE_IDX                                                                       0
#define regGB_TILE_MODE2                                                                                0x0646
#define regGB_TILE_MODE2_BASE_IDX                                                                       0
#define regGB_TILE_MODE3                                                                                0x0647
#define regGB_TILE_MODE3_BASE_IDX                                                                       0
#define regGB_TILE_MODE4                                                                                0x0648
#define regGB_TILE_MODE4_BASE_IDX                                                                       0
#define regGB_TILE_MODE5                                                                                0x0649
#define regGB_TILE_MODE5_BASE_IDX                                                                       0
#define regGB_TILE_MODE6                                                                                0x064a
#define regGB_TILE_MODE6_BASE_IDX                                                                       0
#define regGB_TILE_MODE7                                                                                0x064b
#define regGB_TILE_MODE7_BASE_IDX                                                                       0
#define regGB_TILE_MODE8                                                                                0x064c
#define regGB_TILE_MODE8_BASE_IDX                                                                       0
#define regGB_TILE_MODE9                                                                                0x064d
#define regGB_TILE_MODE9_BASE_IDX                                                                       0
#define regGB_TILE_MODE10                                                                               0x064e
#define regGB_TILE_MODE10_BASE_IDX                                                                      0
#define regGB_TILE_MODE11                                                                               0x064f
#define regGB_TILE_MODE11_BASE_IDX                                                                      0
#define regGB_TILE_MODE12                                                                               0x0650
#define regGB_TILE_MODE12_BASE_IDX                                                                      0
#define regGB_TILE_MODE13                                                                               0x0651
#define regGB_TILE_MODE13_BASE_IDX                                                                      0
#define regGB_TILE_MODE14                                                                               0x0652
#define regGB_TILE_MODE14_BASE_IDX                                                                      0
#define regGB_TILE_MODE15                                                                               0x0653
#define regGB_TILE_MODE15_BASE_IDX                                                                      0
#define regGB_TILE_MODE16                                                                               0x0654
#define regGB_TILE_MODE16_BASE_IDX                                                                      0
#define regGB_TILE_MODE17                                                                               0x0655
#define regGB_TILE_MODE17_BASE_IDX                                                                      0
#define regGB_TILE_MODE18                                                                               0x0656
#define regGB_TILE_MODE18_BASE_IDX                                                                      0
#define regGB_TILE_MODE19                                                                               0x0657
#define regGB_TILE_MODE19_BASE_IDX                                                                      0
#define regGB_TILE_MODE20                                                                               0x0658
#define regGB_TILE_MODE20_BASE_IDX                                                                      0
#define regGB_TILE_MODE21                                                                               0x0659
#define regGB_TILE_MODE21_BASE_IDX                                                                      0
#define regGB_TILE_MODE22                                                                               0x065a
#define regGB_TILE_MODE22_BASE_IDX                                                                      0
#define regGB_TILE_MODE23                                                                               0x065b
#define regGB_TILE_MODE23_BASE_IDX                                                                      0
#define regGB_TILE_MODE24                                                                               0x065c
#define regGB_TILE_MODE24_BASE_IDX                                                                      0
#define regGB_TILE_MODE25                                                                               0x065d
#define regGB_TILE_MODE25_BASE_IDX                                                                      0
#define regGB_TILE_MODE26                                                                               0x065e
#define regGB_TILE_MODE26_BASE_IDX                                                                      0
#define regGB_TILE_MODE27                                                                               0x065f
#define regGB_TILE_MODE27_BASE_IDX                                                                      0
#define regGB_TILE_MODE28                                                                               0x0660
#define regGB_TILE_MODE28_BASE_IDX                                                                      0
#define regGB_TILE_MODE29                                                                               0x0661
#define regGB_TILE_MODE29_BASE_IDX                                                                      0
#define regGB_TILE_MODE30                                                                               0x0662
#define regGB_TILE_MODE30_BASE_IDX                                                                      0
#define regGB_TILE_MODE31                                                                               0x0663
#define regGB_TILE_MODE31_BASE_IDX                                                                      0
#define regGB_MACROTILE_MODE0                                                                           0x0664
#define regGB_MACROTILE_MODE0_BASE_IDX                                                                  0
#define regGB_MACROTILE_MODE1                                                                           0x0665
#define regGB_MACROTILE_MODE1_BASE_IDX                                                                  0
#define regGB_MACROTILE_MODE2                                                                           0x0666
#define regGB_MACROTILE_MODE2_BASE_IDX                                                                  0
#define regGB_MACROTILE_MODE3                                                                           0x0667
#define regGB_MACROTILE_MODE3_BASE_IDX                                                                  0
#define regGB_MACROTILE_MODE4                                                                           0x0668
#define regGB_MACROTILE_MODE4_BASE_IDX                                                                  0
#define regGB_MACROTILE_MODE5                                                                           0x0669
#define regGB_MACROTILE_MODE5_BASE_IDX                                                                  0
#define regGB_MACROTILE_MODE6                                                                           0x066a
#define regGB_MACROTILE_MODE6_BASE_IDX                                                                  0
#define regGB_MACROTILE_MODE7                                                                           0x066b
#define regGB_MACROTILE_MODE7_BASE_IDX                                                                  0
#define regGB_MACROTILE_MODE8                                                                           0x066c
#define regGB_MACROTILE_MODE8_BASE_IDX                                                                  0
#define regGB_MACROTILE_MODE9                                                                           0x066d
#define regGB_MACROTILE_MODE9_BASE_IDX                                                                  0
#define regGB_MACROTILE_MODE10                                                                          0x066e
#define regGB_MACROTILE_MODE10_BASE_IDX                                                                 0
#define regGB_MACROTILE_MODE11                                                                          0x066f
#define regGB_MACROTILE_MODE11_BASE_IDX                                                                 0
#define regGB_MACROTILE_MODE12                                                                          0x0670
#define regGB_MACROTILE_MODE12_BASE_IDX                                                                 0
#define regGB_MACROTILE_MODE13                                                                          0x0671
#define regGB_MACROTILE_MODE13_BASE_IDX                                                                 0
#define regGB_MACROTILE_MODE14                                                                          0x0672
#define regGB_MACROTILE_MODE14_BASE_IDX                                                                 0
#define regGB_MACROTILE_MODE15                                                                          0x0673
#define regGB_MACROTILE_MODE15_BASE_IDX                                                                 0
#define regCB_HW_CONTROL                                                                                0x0680
#define regCB_HW_CONTROL_BASE_IDX                                                                       0
#define regCB_HW_CONTROL_1                                                                              0x0681
#define regCB_HW_CONTROL_1_BASE_IDX                                                                     0
#define regCB_HW_CONTROL_2                                                                              0x0682
#define regCB_HW_CONTROL_2_BASE_IDX                                                                     0
#define regCB_HW_CONTROL_3                                                                              0x0683
#define regCB_HW_CONTROL_3_BASE_IDX                                                                     0
#define regCB_HW_MEM_ARBITER_RD                                                                         0x0686
#define regCB_HW_MEM_ARBITER_RD_BASE_IDX                                                                0
#define regCB_HW_MEM_ARBITER_WR                                                                         0x0687
#define regCB_HW_MEM_ARBITER_WR_BASE_IDX                                                                0
#define regCB_DCC_CONFIG                                                                                0x0688
#define regCB_DCC_CONFIG_BASE_IDX                                                                       0
#define regGC_USER_RB_REDUNDANCY                                                                        0x06de
#define regGC_USER_RB_REDUNDANCY_BASE_IDX                                                               0
#define regGC_USER_RB_BACKEND_DISABLE                                                                   0x06df
#define regGC_USER_RB_BACKEND_DISABLE_BASE_IDX                                                          0


// addressBlock: xcd0_gc_ea_gceadec
// base address: 0xa800
#define regGCEA_DRAM_RD_CLI2GRP_MAP0                                                                    0x0a00
#define regGCEA_DRAM_RD_CLI2GRP_MAP0_BASE_IDX                                                           0
#define regGCEA_DRAM_RD_CLI2GRP_MAP1                                                                    0x0a01
#define regGCEA_DRAM_RD_CLI2GRP_MAP1_BASE_IDX                                                           0
#define regGCEA_DRAM_WR_CLI2GRP_MAP0                                                                    0x0a02
#define regGCEA_DRAM_WR_CLI2GRP_MAP0_BASE_IDX                                                           0
#define regGCEA_DRAM_WR_CLI2GRP_MAP1                                                                    0x0a03
#define regGCEA_DRAM_WR_CLI2GRP_MAP1_BASE_IDX                                                           0
#define regGCEA_DRAM_RD_GRP2VC_MAP                                                                      0x0a04
#define regGCEA_DRAM_RD_GRP2VC_MAP_BASE_IDX                                                             0
#define regGCEA_DRAM_WR_GRP2VC_MAP                                                                      0x0a05
#define regGCEA_DRAM_WR_GRP2VC_MAP_BASE_IDX                                                             0
#define regGCEA_DRAM_RD_LAZY                                                                            0x0a06
#define regGCEA_DRAM_RD_LAZY_BASE_IDX                                                                   0
#define regGCEA_DRAM_WR_LAZY                                                                            0x0a07
#define regGCEA_DRAM_WR_LAZY_BASE_IDX                                                                   0
#define regGCEA_DRAM_RD_CAM_CNTL                                                                        0x0a08
#define regGCEA_DRAM_RD_CAM_CNTL_BASE_IDX                                                               0
#define regGCEA_DRAM_WR_CAM_CNTL                                                                        0x0a09
#define regGCEA_DRAM_WR_CAM_CNTL_BASE_IDX                                                               0
#define regGCEA_DRAM_PAGE_BURST                                                                         0x0a0a
#define regGCEA_DRAM_PAGE_BURST_BASE_IDX                                                                0
#define regGCEA_DRAM_RD_PRI_AGE                                                                         0x0a0b
#define regGCEA_DRAM_RD_PRI_AGE_BASE_IDX                                                                0
#define regGCEA_DRAM_WR_PRI_AGE                                                                         0x0a0c
#define regGCEA_DRAM_WR_PRI_AGE_BASE_IDX                                                                0
#define regGCEA_DRAM_RD_PRI_QUEUING                                                                     0x0a0d
#define regGCEA_DRAM_RD_PRI_QUEUING_BASE_IDX                                                            0
#define regGCEA_DRAM_WR_PRI_QUEUING                                                                     0x0a0e
#define regGCEA_DRAM_WR_PRI_QUEUING_BASE_IDX                                                            0
#define regGCEA_DRAM_RD_PRI_FIXED                                                                       0x0a0f
#define regGCEA_DRAM_RD_PRI_FIXED_BASE_IDX                                                              0
#define regGCEA_DRAM_WR_PRI_FIXED                                                                       0x0a10
#define regGCEA_DRAM_WR_PRI_FIXED_BASE_IDX                                                              0
#define regGCEA_DRAM_RD_PRI_URGENCY                                                                     0x0a11
#define regGCEA_DRAM_RD_PRI_URGENCY_BASE_IDX                                                            0
#define regGCEA_DRAM_WR_PRI_URGENCY                                                                     0x0a12
#define regGCEA_DRAM_WR_PRI_URGENCY_BASE_IDX                                                            0
#define regGCEA_DRAM_RD_PRI_QUANT_PRI1                                                                  0x0a13
#define regGCEA_DRAM_RD_PRI_QUANT_PRI1_BASE_IDX                                                         0
#define regGCEA_DRAM_RD_PRI_QUANT_PRI2                                                                  0x0a14
#define regGCEA_DRAM_RD_PRI_QUANT_PRI2_BASE_IDX                                                         0
#define regGCEA_DRAM_RD_PRI_QUANT_PRI3                                                                  0x0a15
#define regGCEA_DRAM_RD_PRI_QUANT_PRI3_BASE_IDX                                                         0
#define regGCEA_DRAM_WR_PRI_QUANT_PRI1                                                                  0x0a16
#define regGCEA_DRAM_WR_PRI_QUANT_PRI1_BASE_IDX                                                         0
#define regGCEA_DRAM_WR_PRI_QUANT_PRI2                                                                  0x0a17
#define regGCEA_DRAM_WR_PRI_QUANT_PRI2_BASE_IDX                                                         0
#define regGCEA_DRAM_WR_PRI_QUANT_PRI3                                                                  0x0a18
#define regGCEA_DRAM_WR_PRI_QUANT_PRI3_BASE_IDX                                                         0
#define regGCEA_IO_RD_CLI2GRP_MAP0                                                                      0x0ad5
#define regGCEA_IO_RD_CLI2GRP_MAP0_BASE_IDX                                                             0
#define regGCEA_IO_RD_CLI2GRP_MAP1                                                                      0x0ad6
#define regGCEA_IO_RD_CLI2GRP_MAP1_BASE_IDX                                                             0
#define regGCEA_IO_WR_CLI2GRP_MAP0                                                                      0x0ad7
#define regGCEA_IO_WR_CLI2GRP_MAP0_BASE_IDX                                                             0
#define regGCEA_IO_WR_CLI2GRP_MAP1                                                                      0x0ad8
#define regGCEA_IO_WR_CLI2GRP_MAP1_BASE_IDX                                                             0
#define regGCEA_IO_RD_COMBINE_FLUSH                                                                     0x0ad9
#define regGCEA_IO_RD_COMBINE_FLUSH_BASE_IDX                                                            0
#define regGCEA_IO_WR_COMBINE_FLUSH                                                                     0x0ada
#define regGCEA_IO_WR_COMBINE_FLUSH_BASE_IDX                                                            0
#define regGCEA_IO_GROUP_BURST                                                                          0x0adb
#define regGCEA_IO_GROUP_BURST_BASE_IDX                                                                 0
#define regGCEA_IO_RD_PRI_AGE                                                                           0x0adc
#define regGCEA_IO_RD_PRI_AGE_BASE_IDX                                                                  0
#define regGCEA_IO_WR_PRI_AGE                                                                           0x0add
#define regGCEA_IO_WR_PRI_AGE_BASE_IDX                                                                  0
#define regGCEA_IO_RD_PRI_QUEUING                                                                       0x0ade
#define regGCEA_IO_RD_PRI_QUEUING_BASE_IDX                                                              0
#define regGCEA_IO_WR_PRI_QUEUING                                                                       0x0adf
#define regGCEA_IO_WR_PRI_QUEUING_BASE_IDX                                                              0
#define regGCEA_IO_RD_PRI_FIXED                                                                         0x0ae0
#define regGCEA_IO_RD_PRI_FIXED_BASE_IDX                                                                0
#define regGCEA_IO_WR_PRI_FIXED                                                                         0x0ae1
#define regGCEA_IO_WR_PRI_FIXED_BASE_IDX                                                                0
#define regGCEA_IO_RD_PRI_URGENCY                                                                       0x0ae2
#define regGCEA_IO_RD_PRI_URGENCY_BASE_IDX                                                              0
#define regGCEA_IO_WR_PRI_URGENCY                                                                       0x0ae3
#define regGCEA_IO_WR_PRI_URGENCY_BASE_IDX                                                              0
#define regGCEA_IO_RD_PRI_URGENCY_MASKING                                                               0x0ae4
#define regGCEA_IO_RD_PRI_URGENCY_MASKING_BASE_IDX                                                      0
#define regGCEA_IO_WR_PRI_URGENCY_MASKING                                                               0x0ae5
#define regGCEA_IO_WR_PRI_URGENCY_MASKING_BASE_IDX                                                      0
#define regGCEA_IO_RD_PRI_QUANT_PRI1                                                                    0x0ae6
#define regGCEA_IO_RD_PRI_QUANT_PRI1_BASE_IDX                                                           0
#define regGCEA_IO_RD_PRI_QUANT_PRI2                                                                    0x0ae7
#define regGCEA_IO_RD_PRI_QUANT_PRI2_BASE_IDX                                                           0
#define regGCEA_IO_RD_PRI_QUANT_PRI3                                                                    0x0ae8
#define regGCEA_IO_RD_PRI_QUANT_PRI3_BASE_IDX                                                           0
#define regGCEA_IO_WR_PRI_QUANT_PRI1                                                                    0x0ae9
#define regGCEA_IO_WR_PRI_QUANT_PRI1_BASE_IDX                                                           0
#define regGCEA_IO_WR_PRI_QUANT_PRI2                                                                    0x0aea
#define regGCEA_IO_WR_PRI_QUANT_PRI2_BASE_IDX                                                           0
#define regGCEA_IO_WR_PRI_QUANT_PRI3                                                                    0x0aeb
#define regGCEA_IO_WR_PRI_QUANT_PRI3_BASE_IDX                                                           0
#define regGCEA_SDP_ARB_DRAM                                                                            0x0aec
#define regGCEA_SDP_ARB_DRAM_BASE_IDX                                                                   0
#define regGCEA_SDP_ARB_FINAL                                                                           0x0aee
#define regGCEA_SDP_ARB_FINAL_BASE_IDX                                                                  0
#define regGCEA_SDP_DRAM_PRIORITY                                                                       0x0aef
#define regGCEA_SDP_DRAM_PRIORITY_BASE_IDX                                                              0
#define regGCEA_SDP_IO_PRIORITY                                                                         0x0af1
#define regGCEA_SDP_IO_PRIORITY_BASE_IDX                                                                0
#define regGCEA_SDP_CREDITS                                                                             0x0af2
#define regGCEA_SDP_CREDITS_BASE_IDX                                                                    0
#define regGCEA_SDP_TAG_RESERVE0                                                                        0x0af3
#define regGCEA_SDP_TAG_RESERVE0_BASE_IDX                                                               0
#define regGCEA_SDP_TAG_RESERVE1                                                                        0x0af4
#define regGCEA_SDP_TAG_RESERVE1_BASE_IDX                                                               0
#define regGCEA_SDP_VCC_RESERVE0                                                                        0x0af5
#define regGCEA_SDP_VCC_RESERVE0_BASE_IDX                                                               0
#define regGCEA_SDP_VCC_RESERVE1                                                                        0x0af6
#define regGCEA_SDP_VCC_RESERVE1_BASE_IDX                                                               0
#define regGCEA_SDP_VCD_RESERVE0                                                                        0x0af7
#define regGCEA_SDP_VCD_RESERVE0_BASE_IDX                                                               0
#define regGCEA_SDP_VCD_RESERVE1                                                                        0x0af8
#define regGCEA_SDP_VCD_RESERVE1_BASE_IDX                                                               0
#define regGCEA_SDP_REQ_CNTL                                                                            0x0af9
#define regGCEA_SDP_REQ_CNTL_BASE_IDX                                                                   0
#define regGCEA_MISC                                                                                    0x0afa
#define regGCEA_MISC_BASE_IDX                                                                           0
#define regGCEA_LATENCY_SAMPLING                                                                        0x0afb
#define regGCEA_LATENCY_SAMPLING_BASE_IDX                                                               0
#define regGCEA_PERFCOUNTER_LO                                                                          0x0afc
#define regGCEA_PERFCOUNTER_LO_BASE_IDX                                                                 0
#define regGCEA_PERFCOUNTER_HI                                                                          0x0afd
#define regGCEA_PERFCOUNTER_HI_BASE_IDX                                                                 0
#define regGCEA_PERFCOUNTER0_CFG                                                                        0x0afe
#define regGCEA_PERFCOUNTER0_CFG_BASE_IDX                                                               0
#define regGCEA_PERFCOUNTER1_CFG                                                                        0x0aff
#define regGCEA_PERFCOUNTER1_CFG_BASE_IDX                                                               0


// addressBlock: xcd0_gc_ea_gceadec2
// base address: 0x9c00
#define regGCEA_PERFCOUNTER_RSLT_CNTL                                                                   0x0700
#define regGCEA_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                          0
#define regGCEA_MAM_CTRL                                                                                0x0701
#define regGCEA_MAM_CTRL_BASE_IDX                                                                       0
#define regGCEA_MAM_CTRL2                                                                               0x0702
#define regGCEA_MAM_CTRL2_BASE_IDX                                                                      0
#define regGCEA_UE_ERR_STATUS_LO                                                                        0x0706
#define regGCEA_UE_ERR_STATUS_LO_BASE_IDX                                                               0
#define regGCEA_UE_ERR_STATUS_HI                                                                        0x0707
#define regGCEA_UE_ERR_STATUS_HI_BASE_IDX                                                               0
#define regGCEA_DSM_CNTL                                                                                0x0708
#define regGCEA_DSM_CNTL_BASE_IDX                                                                       0
#define regGCEA_DSM_CNTLA                                                                               0x0709
#define regGCEA_DSM_CNTLA_BASE_IDX                                                                      0
#define regGCEA_DSM_CNTLB                                                                               0x070a
#define regGCEA_DSM_CNTLB_BASE_IDX                                                                      0
#define regGCEA_DSM_CNTL2                                                                               0x070b
#define regGCEA_DSM_CNTL2_BASE_IDX                                                                      0
#define regGCEA_DSM_CNTL2A                                                                              0x070c
#define regGCEA_DSM_CNTL2A_BASE_IDX                                                                     0
#define regGCEA_DSM_CNTL2B                                                                              0x070d
#define regGCEA_DSM_CNTL2B_BASE_IDX                                                                     0
#define regGCEA_TCC_XBR_CREDITS                                                                         0x070e
#define regGCEA_TCC_XBR_CREDITS_BASE_IDX                                                                0
#define regGCEA_TCC_XBR_MAXBURST                                                                        0x070f
#define regGCEA_TCC_XBR_MAXBURST_BASE_IDX                                                               0
#define regGCEA_PROBE_CNTL                                                                              0x0710
#define regGCEA_PROBE_CNTL_BASE_IDX                                                                     0
#define regGCEA_PROBE_MAP                                                                               0x0711
#define regGCEA_PROBE_MAP_BASE_IDX                                                                      0
#define regGCEA_ERR_STATUS                                                                              0x0712
#define regGCEA_ERR_STATUS_BASE_IDX                                                                     0
#define regGCEA_MISC2                                                                                   0x0713
#define regGCEA_MISC2_BASE_IDX                                                                          0
#define regGCEA_SDP_BACKDOOR_CMDCREDITS0                                                                0x0715
#define regGCEA_SDP_BACKDOOR_CMDCREDITS0_BASE_IDX                                                       0
#define regGCEA_SDP_BACKDOOR_CMDCREDITS1                                                                0x0716
#define regGCEA_SDP_BACKDOOR_CMDCREDITS1_BASE_IDX                                                       0
#define regGCEA_SDP_BACKDOOR_DATACREDITS0                                                               0x0717
#define regGCEA_SDP_BACKDOOR_DATACREDITS0_BASE_IDX                                                      0
#define regGCEA_SDP_BACKDOOR_DATACREDITS1                                                               0x0718
#define regGCEA_SDP_BACKDOOR_DATACREDITS1_BASE_IDX                                                      0
#define regGCEA_SDP_BACKDOOR_MISCCREDITS                                                                0x0719
#define regGCEA_SDP_BACKDOOR_MISCCREDITS_BASE_IDX                                                       0
#define regGCEA_CE_ERR_STATUS_LO                                                                        0x071b
#define regGCEA_CE_ERR_STATUS_LO_BASE_IDX                                                               0
#define regGCEA_CE_ERR_STATUS_HI                                                                        0x071d
#define regGCEA_CE_ERR_STATUS_HI_BASE_IDX                                                               0
#define regGCEA_SDP_ENABLE                                                                              0x071f
#define regGCEA_SDP_ENABLE_BASE_IDX                                                                     0


// addressBlock: xcd0_gc_ea_pwrdec
// base address: 0x3c000
#define regGCEA_ICG_CTRL                                                                                0x50c4
#define regGCEA_ICG_CTRL_BASE_IDX                                                                       1


// addressBlock: xcd0_gc_rmi_rmidec
// base address: 0x9e00
#define regRMI_GENERAL_CNTL                                                                             0x0780
#define regRMI_GENERAL_CNTL_BASE_IDX                                                                    0
#define regRMI_GENERAL_CNTL1                                                                            0x0781
#define regRMI_GENERAL_CNTL1_BASE_IDX                                                                   0
#define regRMI_GENERAL_STATUS                                                                           0x0782
#define regRMI_GENERAL_STATUS_BASE_IDX                                                                  0
#define regRMI_SUBBLOCK_STATUS0                                                                         0x0783
#define regRMI_SUBBLOCK_STATUS0_BASE_IDX                                                                0
#define regRMI_SUBBLOCK_STATUS1                                                                         0x0784
#define regRMI_SUBBLOCK_STATUS1_BASE_IDX                                                                0
#define regRMI_SUBBLOCK_STATUS2                                                                         0x0785
#define regRMI_SUBBLOCK_STATUS2_BASE_IDX                                                                0
#define regRMI_SUBBLOCK_STATUS3                                                                         0x0786
#define regRMI_SUBBLOCK_STATUS3_BASE_IDX                                                                0
#define regRMI_XBAR_CONFIG                                                                              0x0787
#define regRMI_XBAR_CONFIG_BASE_IDX                                                                     0
#define regRMI_PROBE_POP_LOGIC_CNTL                                                                     0x0788
#define regRMI_PROBE_POP_LOGIC_CNTL_BASE_IDX                                                            0
#define regRMI_UTC_XNACK_N_MISC_CNTL                                                                    0x0789
#define regRMI_UTC_XNACK_N_MISC_CNTL_BASE_IDX                                                           0
#define regRMI_DEMUX_CNTL                                                                               0x078a
#define regRMI_DEMUX_CNTL_BASE_IDX                                                                      0
#define regRMI_UTCL1_CNTL1                                                                              0x078b
#define regRMI_UTCL1_CNTL1_BASE_IDX                                                                     0
#define regRMI_UTCL1_CNTL2                                                                              0x078c
#define regRMI_UTCL1_CNTL2_BASE_IDX                                                                     0
#define regRMI_UTC_UNIT_CONFIG                                                                          0x078d
#define regRMI_UTC_UNIT_CONFIG_BASE_IDX                                                                 0
#define regRMI_TCIW_FORMATTER0_CNTL                                                                     0x078e
#define regRMI_TCIW_FORMATTER0_CNTL_BASE_IDX                                                            0
#define regRMI_TCIW_FORMATTER1_CNTL                                                                     0x078f
#define regRMI_TCIW_FORMATTER1_CNTL_BASE_IDX                                                            0
#define regRMI_SCOREBOARD_CNTL                                                                          0x0790
#define regRMI_SCOREBOARD_CNTL_BASE_IDX                                                                 0
#define regRMI_SCOREBOARD_STATUS0                                                                       0x0791
#define regRMI_SCOREBOARD_STATUS0_BASE_IDX                                                              0
#define regRMI_SCOREBOARD_STATUS1                                                                       0x0792
#define regRMI_SCOREBOARD_STATUS1_BASE_IDX                                                              0
#define regRMI_SCOREBOARD_STATUS2                                                                       0x0793
#define regRMI_SCOREBOARD_STATUS2_BASE_IDX                                                              0
#define regRMI_XBAR_ARBITER_CONFIG                                                                      0x0794
#define regRMI_XBAR_ARBITER_CONFIG_BASE_IDX                                                             0
#define regRMI_XBAR_ARBITER_CONFIG_1                                                                    0x0795
#define regRMI_XBAR_ARBITER_CONFIG_1_BASE_IDX                                                           0
#define regRMI_CLOCK_CNTRL                                                                              0x0796
#define regRMI_CLOCK_CNTRL_BASE_IDX                                                                     0
#define regRMI_UTCL1_STATUS                                                                             0x0797
#define regRMI_UTCL1_STATUS_BASE_IDX                                                                    0
#define regRMI_XNACK_DEBUG                                                                              0x079d
#define regRMI_XNACK_DEBUG_BASE_IDX                                                                     0
#define regRMI_SPARE                                                                                    0x079e
#define regRMI_SPARE_BASE_IDX                                                                           0
#define regRMI_SPARE_1                                                                                  0x079f
#define regRMI_SPARE_1_BASE_IDX                                                                         0
#define regRMI_SPARE_2                                                                                  0x07a0
#define regRMI_SPARE_2_BASE_IDX                                                                         0


// addressBlock: xcd0_gc_utcl2_atcl2dec
// base address: 0xa000
#define regATC_L2_CNTL                                                                                  0x0800
#define regATC_L2_CNTL_BASE_IDX                                                                         0
#define regATC_L2_CNTL2                                                                                 0x0801
#define regATC_L2_CNTL2_BASE_IDX                                                                        0
#define regATC_L2_CACHE_DATA0                                                                           0x0804
#define regATC_L2_CACHE_DATA0_BASE_IDX                                                                  0
#define regATC_L2_CACHE_DATA1                                                                           0x0805
#define regATC_L2_CACHE_DATA1_BASE_IDX                                                                  0
#define regATC_L2_CACHE_DATA2                                                                           0x0806
#define regATC_L2_CACHE_DATA2_BASE_IDX                                                                  0
#define regATC_L2_CACHE_DATA3                                                                           0x0807
#define regATC_L2_CACHE_DATA3_BASE_IDX                                                                  0
#define regATC_L2_CNTL3                                                                                 0x0808
#define regATC_L2_CNTL3_BASE_IDX                                                                        0
#define regATC_L2_STATUS                                                                                0x0809
#define regATC_L2_STATUS_BASE_IDX                                                                       0
#define regATC_L2_STATUS2                                                                               0x080a
#define regATC_L2_STATUS2_BASE_IDX                                                                      0
#define regATC_L2_MISC_CG                                                                               0x080b
#define regATC_L2_MISC_CG_BASE_IDX                                                                      0
#define regATC_L2_MEM_POWER_LS                                                                          0x080c
#define regATC_L2_MEM_POWER_LS_BASE_IDX                                                                 0
#define regATC_L2_CGTT_CLK_CTRL                                                                         0x080d
#define regATC_L2_CGTT_CLK_CTRL_BASE_IDX                                                                0
#define regATC_L2_CACHE_4K_DSM_INDEX                                                                    0x080f
#define regATC_L2_CACHE_4K_DSM_INDEX_BASE_IDX                                                           0
#define regATC_L2_CACHE_32K_DSM_INDEX                                                                   0x0810
#define regATC_L2_CACHE_32K_DSM_INDEX_BASE_IDX                                                          0
#define regATC_L2_CACHE_2M_DSM_INDEX                                                                    0x0811
#define regATC_L2_CACHE_2M_DSM_INDEX_BASE_IDX                                                           0
#define regATC_L2_CACHE_4K_DSM_CNTL                                                                     0x0812
#define regATC_L2_CACHE_4K_DSM_CNTL_BASE_IDX                                                            0
#define regATC_L2_CACHE_32K_DSM_CNTL                                                                    0x0813
#define regATC_L2_CACHE_32K_DSM_CNTL_BASE_IDX                                                           0
#define regATC_L2_CACHE_2M_DSM_CNTL                                                                     0x0814
#define regATC_L2_CACHE_2M_DSM_CNTL_BASE_IDX                                                            0
#define regATC_L2_CNTL4                                                                                 0x0815
#define regATC_L2_CNTL4_BASE_IDX                                                                        0
#define regATC_L2_MM_GROUP_RT_CLASSES                                                                   0x0816
#define regATC_L2_MM_GROUP_RT_CLASSES_BASE_IDX                                                          0
#define regATC_L2_UE_ERR_STATUS_LO                                                                      0x081a
#define regATC_L2_UE_ERR_STATUS_LO_BASE_IDX                                                             0
#define regATC_L2_UE_ERR_STATUS_HI                                                                      0x081b
#define regATC_L2_UE_ERR_STATUS_HI_BASE_IDX                                                             0
#define regATC_L2_CE_ERR_STATUS_LO                                                                      0x081c
#define regATC_L2_CE_ERR_STATUS_LO_BASE_IDX                                                             0
#define regATC_L2_CE_ERR_STATUS_HI                                                                      0x081d
#define regATC_L2_CE_ERR_STATUS_HI_BASE_IDX                                                             0


// addressBlock: xcd0_gc_utcl2_vml2pfdec
// base address: 0xa080
#define regVM_L2_CNTL                                                                                   0x0820
#define regVM_L2_CNTL_BASE_IDX                                                                          0
#define regVM_L2_CNTL2                                                                                  0x0821
#define regVM_L2_CNTL2_BASE_IDX                                                                         0
#define regVM_L2_CNTL3                                                                                  0x0822
#define regVM_L2_CNTL3_BASE_IDX                                                                         0
#define regVM_L2_STATUS                                                                                 0x0823
#define regVM_L2_STATUS_BASE_IDX                                                                        0
#define regVM_DUMMY_PAGE_FAULT_CNTL                                                                     0x0824
#define regVM_DUMMY_PAGE_FAULT_CNTL_BASE_IDX                                                            0
#define regVM_DUMMY_PAGE_FAULT_ADDR_LO32                                                                0x0825
#define regVM_DUMMY_PAGE_FAULT_ADDR_LO32_BASE_IDX                                                       0
#define regVM_DUMMY_PAGE_FAULT_ADDR_HI32                                                                0x0826
#define regVM_DUMMY_PAGE_FAULT_ADDR_HI32_BASE_IDX                                                       0
#define regVM_L2_PROTECTION_FAULT_CNTL                                                                  0x0827
#define regVM_L2_PROTECTION_FAULT_CNTL_BASE_IDX                                                         0
#define regVM_L2_PROTECTION_FAULT_CNTL2                                                                 0x0828
#define regVM_L2_PROTECTION_FAULT_CNTL2_BASE_IDX                                                        0
#define regVM_L2_PROTECTION_FAULT_MM_CNTL3                                                              0x0829
#define regVM_L2_PROTECTION_FAULT_MM_CNTL3_BASE_IDX                                                     0
#define regVM_L2_PROTECTION_FAULT_MM_CNTL4                                                              0x082a
#define regVM_L2_PROTECTION_FAULT_MM_CNTL4_BASE_IDX                                                     0
#define regVM_L2_PROTECTION_FAULT_STATUS                                                                0x082b
#define regVM_L2_PROTECTION_FAULT_STATUS_BASE_IDX                                                       0
#define regVM_L2_PROTECTION_FAULT_ADDR_LO32                                                             0x082c
#define regVM_L2_PROTECTION_FAULT_ADDR_LO32_BASE_IDX                                                    0
#define regVM_L2_PROTECTION_FAULT_ADDR_HI32                                                             0x082d
#define regVM_L2_PROTECTION_FAULT_ADDR_HI32_BASE_IDX                                                    0
#define regVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_LO32                                                     0x082e
#define regVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_LO32_BASE_IDX                                            0
#define regVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_HI32                                                     0x082f
#define regVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_HI32_BASE_IDX                                            0
#define regVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_LO32                                               0x0831
#define regVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_LO32_BASE_IDX                                      0
#define regVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_HI32                                               0x0832
#define regVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_HI32_BASE_IDX                                      0
#define regVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_LO32                                              0x0833
#define regVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_LO32_BASE_IDX                                     0
#define regVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_HI32                                              0x0834
#define regVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_HI32_BASE_IDX                                     0
#define regVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_LO32                                                  0x0835
#define regVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_LO32_BASE_IDX                                         0
#define regVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_HI32                                                  0x0836
#define regVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_HI32_BASE_IDX                                         0
#define regVM_L2_CNTL4                                                                                  0x0837
#define regVM_L2_CNTL4_BASE_IDX                                                                         0
#define regVM_L2_CNTL5                                                                                  0x0838
#define regVM_L2_CNTL5_BASE_IDX                                                                         0
#define regVM_L2_MM_GROUP_RT_CLASSES                                                                    0x0839
#define regVM_L2_MM_GROUP_RT_CLASSES_BASE_IDX                                                           0
#define regVM_L2_BANK_SELECT_RESERVED_CID                                                               0x083a
#define regVM_L2_BANK_SELECT_RESERVED_CID_BASE_IDX                                                      0
#define regVM_L2_BANK_SELECT_RESERVED_CID2                                                              0x083b
#define regVM_L2_BANK_SELECT_RESERVED_CID2_BASE_IDX                                                     0
#define regVM_L2_CACHE_PARITY_CNTL                                                                      0x083c
#define regVM_L2_CACHE_PARITY_CNTL_BASE_IDX                                                             0
#define regVM_L2_CGTT_CLK_CTRL                                                                          0x083d
#define regVM_L2_CGTT_CLK_CTRL_BASE_IDX                                                                 0
#define regVM_L2_CGTT_BUSY_CTRL                                                                         0x083e
#define regVM_L2_CGTT_BUSY_CTRL_BASE_IDX                                                                0
#define regVML2_MEM_ECC_INDEX                                                                           0x0842
#define regVML2_MEM_ECC_INDEX_BASE_IDX                                                                  0
#define regVML2_WALKER_MEM_ECC_INDEX                                                                    0x0843
#define regVML2_WALKER_MEM_ECC_INDEX_BASE_IDX                                                           0
#define regUTCL2_MEM_ECC_INDEX                                                                          0x0844
#define regUTCL2_MEM_ECC_INDEX_BASE_IDX                                                                 0
#define regVML2_MEM_ECC_CNTL                                                                            0x0845
#define regVML2_MEM_ECC_CNTL_BASE_IDX                                                                   0
#define regVML2_WALKER_MEM_ECC_CNTL                                                                     0x0846
#define regVML2_WALKER_MEM_ECC_CNTL_BASE_IDX                                                            0
#define regUTCL2_MEM_ECC_CNTL                                                                           0x0847
#define regUTCL2_MEM_ECC_CNTL_BASE_IDX                                                                  0
#define regVML2_MEM_ECC_STATUS                                                                          0x0848
#define regVML2_MEM_ECC_STATUS_BASE_IDX                                                                 0
#define regVML2_WALKER_MEM_ECC_STATUS                                                                   0x0849
#define regVML2_WALKER_MEM_ECC_STATUS_BASE_IDX                                                          0
#define regUTCL2_MEM_ECC_STATUS                                                                         0x084a
#define regUTCL2_MEM_ECC_STATUS_BASE_IDX                                                                0
#define regUTCL2_EDC_MODE                                                                               0x084b
#define regUTCL2_EDC_MODE_BASE_IDX                                                                      0
#define regUTCL2_EDC_CONFIG                                                                             0x084c
#define regUTCL2_EDC_CONFIG_BASE_IDX                                                                    0
#define regVML2_UE_ERR_STATUS_LO                                                                        0x084d
#define regVML2_UE_ERR_STATUS_LO_BASE_IDX                                                               0
#define regVML2_WALKER_UE_ERR_STATUS_LO                                                                 0x084e
#define regVML2_WALKER_UE_ERR_STATUS_LO_BASE_IDX                                                        0
#define regUTCL2_UE_ERR_STATUS_LO                                                                       0x084f
#define regUTCL2_UE_ERR_STATUS_LO_BASE_IDX                                                              0
#define regVML2_UE_ERR_STATUS_HI                                                                        0x0850
#define regVML2_UE_ERR_STATUS_HI_BASE_IDX                                                               0
#define regVML2_WALKER_UE_ERR_STATUS_HI                                                                 0x0851
#define regVML2_WALKER_UE_ERR_STATUS_HI_BASE_IDX                                                        0
#define regUTCL2_UE_ERR_STATUS_HI                                                                       0x0852
#define regUTCL2_UE_ERR_STATUS_HI_BASE_IDX                                                              0
#define regVML2_CE_ERR_STATUS_LO                                                                        0x0853
#define regVML2_CE_ERR_STATUS_LO_BASE_IDX                                                               0
#define regVML2_WALKER_CE_ERR_STATUS_LO                                                                 0x0854
#define regVML2_WALKER_CE_ERR_STATUS_LO_BASE_IDX                                                        0
#define regUTCL2_CE_ERR_STATUS_LO                                                                       0x0855
#define regUTCL2_CE_ERR_STATUS_LO_BASE_IDX                                                              0
#define regVML2_CE_ERR_STATUS_HI                                                                        0x0856
#define regVML2_CE_ERR_STATUS_HI_BASE_IDX                                                               0
#define regVML2_WALKER_CE_ERR_STATUS_HI                                                                 0x0857
#define regVML2_WALKER_CE_ERR_STATUS_HI_BASE_IDX                                                        0
#define regUTCL2_CE_ERR_STATUS_HI                                                                       0x0858
#define regUTCL2_CE_ERR_STATUS_HI_BASE_IDX                                                              0


// addressBlock: xcd0_gc_utcl2_vml2vcdec
// base address: 0xa180
#define regVM_CONTEXT0_CNTL                                                                             0x0860
#define regVM_CONTEXT0_CNTL_BASE_IDX                                                                    0
#define regVM_CONTEXT1_CNTL                                                                             0x0861
#define regVM_CONTEXT1_CNTL_BASE_IDX                                                                    0
#define regVM_CONTEXT2_CNTL                                                                             0x0862
#define regVM_CONTEXT2_CNTL_BASE_IDX                                                                    0
#define regVM_CONTEXT3_CNTL                                                                             0x0863
#define regVM_CONTEXT3_CNTL_BASE_IDX                                                                    0
#define regVM_CONTEXT4_CNTL                                                                             0x0864
#define regVM_CONTEXT4_CNTL_BASE_IDX                                                                    0
#define regVM_CONTEXT5_CNTL                                                                             0x0865
#define regVM_CONTEXT5_CNTL_BASE_IDX                                                                    0
#define regVM_CONTEXT6_CNTL                                                                             0x0866
#define regVM_CONTEXT6_CNTL_BASE_IDX                                                                    0
#define regVM_CONTEXT7_CNTL                                                                             0x0867
#define regVM_CONTEXT7_CNTL_BASE_IDX                                                                    0
#define regVM_CONTEXT8_CNTL                                                                             0x0868
#define regVM_CONTEXT8_CNTL_BASE_IDX                                                                    0
#define regVM_CONTEXT9_CNTL                                                                             0x0869
#define regVM_CONTEXT9_CNTL_BASE_IDX                                                                    0
#define regVM_CONTEXT10_CNTL                                                                            0x086a
#define regVM_CONTEXT10_CNTL_BASE_IDX                                                                   0
#define regVM_CONTEXT11_CNTL                                                                            0x086b
#define regVM_CONTEXT11_CNTL_BASE_IDX                                                                   0
#define regVM_CONTEXT12_CNTL                                                                            0x086c
#define regVM_CONTEXT12_CNTL_BASE_IDX                                                                   0
#define regVM_CONTEXT13_CNTL                                                                            0x086d
#define regVM_CONTEXT13_CNTL_BASE_IDX                                                                   0
#define regVM_CONTEXT14_CNTL                                                                            0x086e
#define regVM_CONTEXT14_CNTL_BASE_IDX                                                                   0
#define regVM_CONTEXT15_CNTL                                                                            0x086f
#define regVM_CONTEXT15_CNTL_BASE_IDX                                                                   0
#define regVM_CONTEXTS_DISABLE                                                                          0x0870
#define regVM_CONTEXTS_DISABLE_BASE_IDX                                                                 0
#define regVM_INVALIDATE_ENG0_SEM                                                                       0x0871
#define regVM_INVALIDATE_ENG0_SEM_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG1_SEM                                                                       0x0872
#define regVM_INVALIDATE_ENG1_SEM_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG2_SEM                                                                       0x0873
#define regVM_INVALIDATE_ENG2_SEM_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG3_SEM                                                                       0x0874
#define regVM_INVALIDATE_ENG3_SEM_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG4_SEM                                                                       0x0875
#define regVM_INVALIDATE_ENG4_SEM_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG5_SEM                                                                       0x0876
#define regVM_INVALIDATE_ENG5_SEM_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG6_SEM                                                                       0x0877
#define regVM_INVALIDATE_ENG6_SEM_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG7_SEM                                                                       0x0878
#define regVM_INVALIDATE_ENG7_SEM_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG8_SEM                                                                       0x0879
#define regVM_INVALIDATE_ENG8_SEM_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG9_SEM                                                                       0x087a
#define regVM_INVALIDATE_ENG9_SEM_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG10_SEM                                                                      0x087b
#define regVM_INVALIDATE_ENG10_SEM_BASE_IDX                                                             0
#define regVM_INVALIDATE_ENG11_SEM                                                                      0x087c
#define regVM_INVALIDATE_ENG11_SEM_BASE_IDX                                                             0
#define regVM_INVALIDATE_ENG12_SEM                                                                      0x087d
#define regVM_INVALIDATE_ENG12_SEM_BASE_IDX                                                             0
#define regVM_INVALIDATE_ENG13_SEM                                                                      0x087e
#define regVM_INVALIDATE_ENG13_SEM_BASE_IDX                                                             0
#define regVM_INVALIDATE_ENG14_SEM                                                                      0x087f
#define regVM_INVALIDATE_ENG14_SEM_BASE_IDX                                                             0
#define regVM_INVALIDATE_ENG15_SEM                                                                      0x0880
#define regVM_INVALIDATE_ENG15_SEM_BASE_IDX                                                             0
#define regVM_INVALIDATE_ENG16_SEM                                                                      0x0881
#define regVM_INVALIDATE_ENG16_SEM_BASE_IDX                                                             0
#define regVM_INVALIDATE_ENG17_SEM                                                                      0x0882
#define regVM_INVALIDATE_ENG17_SEM_BASE_IDX                                                             0
#define regVM_INVALIDATE_ENG0_REQ                                                                       0x0883
#define regVM_INVALIDATE_ENG0_REQ_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG1_REQ                                                                       0x0884
#define regVM_INVALIDATE_ENG1_REQ_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG2_REQ                                                                       0x0885
#define regVM_INVALIDATE_ENG2_REQ_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG3_REQ                                                                       0x0886
#define regVM_INVALIDATE_ENG3_REQ_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG4_REQ                                                                       0x0887
#define regVM_INVALIDATE_ENG4_REQ_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG5_REQ                                                                       0x0888
#define regVM_INVALIDATE_ENG5_REQ_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG6_REQ                                                                       0x0889
#define regVM_INVALIDATE_ENG6_REQ_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG7_REQ                                                                       0x088a
#define regVM_INVALIDATE_ENG7_REQ_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG8_REQ                                                                       0x088b
#define regVM_INVALIDATE_ENG8_REQ_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG9_REQ                                                                       0x088c
#define regVM_INVALIDATE_ENG9_REQ_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG10_REQ                                                                      0x088d
#define regVM_INVALIDATE_ENG10_REQ_BASE_IDX                                                             0
#define regVM_INVALIDATE_ENG11_REQ                                                                      0x088e
#define regVM_INVALIDATE_ENG11_REQ_BASE_IDX                                                             0
#define regVM_INVALIDATE_ENG12_REQ                                                                      0x088f
#define regVM_INVALIDATE_ENG12_REQ_BASE_IDX                                                             0
#define regVM_INVALIDATE_ENG13_REQ                                                                      0x0890
#define regVM_INVALIDATE_ENG13_REQ_BASE_IDX                                                             0
#define regVM_INVALIDATE_ENG14_REQ                                                                      0x0891
#define regVM_INVALIDATE_ENG14_REQ_BASE_IDX                                                             0
#define regVM_INVALIDATE_ENG15_REQ                                                                      0x0892
#define regVM_INVALIDATE_ENG15_REQ_BASE_IDX                                                             0
#define regVM_INVALIDATE_ENG16_REQ                                                                      0x0893
#define regVM_INVALIDATE_ENG16_REQ_BASE_IDX                                                             0
#define regVM_INVALIDATE_ENG17_REQ                                                                      0x0894
#define regVM_INVALIDATE_ENG17_REQ_BASE_IDX                                                             0
#define regVM_INVALIDATE_ENG0_ACK                                                                       0x0895
#define regVM_INVALIDATE_ENG0_ACK_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG1_ACK                                                                       0x0896
#define regVM_INVALIDATE_ENG1_ACK_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG2_ACK                                                                       0x0897
#define regVM_INVALIDATE_ENG2_ACK_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG3_ACK                                                                       0x0898
#define regVM_INVALIDATE_ENG3_ACK_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG4_ACK                                                                       0x0899
#define regVM_INVALIDATE_ENG4_ACK_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG5_ACK                                                                       0x089a
#define regVM_INVALIDATE_ENG5_ACK_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG6_ACK                                                                       0x089b
#define regVM_INVALIDATE_ENG6_ACK_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG7_ACK                                                                       0x089c
#define regVM_INVALIDATE_ENG7_ACK_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG8_ACK                                                                       0x089d
#define regVM_INVALIDATE_ENG8_ACK_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG9_ACK                                                                       0x089e
#define regVM_INVALIDATE_ENG9_ACK_BASE_IDX                                                              0
#define regVM_INVALIDATE_ENG10_ACK                                                                      0x089f
#define regVM_INVALIDATE_ENG10_ACK_BASE_IDX                                                             0
#define regVM_INVALIDATE_ENG11_ACK                                                                      0x08a0
#define regVM_INVALIDATE_ENG11_ACK_BASE_IDX                                                             0
#define regVM_INVALIDATE_ENG12_ACK                                                                      0x08a1
#define regVM_INVALIDATE_ENG12_ACK_BASE_IDX                                                             0
#define regVM_INVALIDATE_ENG13_ACK                                                                      0x08a2
#define regVM_INVALIDATE_ENG13_ACK_BASE_IDX                                                             0
#define regVM_INVALIDATE_ENG14_ACK                                                                      0x08a3
#define regVM_INVALIDATE_ENG14_ACK_BASE_IDX                                                             0
#define regVM_INVALIDATE_ENG15_ACK                                                                      0x08a4
#define regVM_INVALIDATE_ENG15_ACK_BASE_IDX                                                             0
#define regVM_INVALIDATE_ENG16_ACK                                                                      0x08a5
#define regVM_INVALIDATE_ENG16_ACK_BASE_IDX                                                             0
#define regVM_INVALIDATE_ENG17_ACK                                                                      0x08a6
#define regVM_INVALIDATE_ENG17_ACK_BASE_IDX                                                             0
#define regVM_INVALIDATE_ENG0_ADDR_RANGE_LO32                                                           0x08a7
#define regVM_INVALIDATE_ENG0_ADDR_RANGE_LO32_BASE_IDX                                                  0
#define regVM_INVALIDATE_ENG0_ADDR_RANGE_HI32                                                           0x08a8
#define regVM_INVALIDATE_ENG0_ADDR_RANGE_HI32_BASE_IDX                                                  0
#define regVM_INVALIDATE_ENG1_ADDR_RANGE_LO32                                                           0x08a9
#define regVM_INVALIDATE_ENG1_ADDR_RANGE_LO32_BASE_IDX                                                  0
#define regVM_INVALIDATE_ENG1_ADDR_RANGE_HI32                                                           0x08aa
#define regVM_INVALIDATE_ENG1_ADDR_RANGE_HI32_BASE_IDX                                                  0
#define regVM_INVALIDATE_ENG2_ADDR_RANGE_LO32                                                           0x08ab
#define regVM_INVALIDATE_ENG2_ADDR_RANGE_LO32_BASE_IDX                                                  0
#define regVM_INVALIDATE_ENG2_ADDR_RANGE_HI32                                                           0x08ac
#define regVM_INVALIDATE_ENG2_ADDR_RANGE_HI32_BASE_IDX                                                  0
#define regVM_INVALIDATE_ENG3_ADDR_RANGE_LO32                                                           0x08ad
#define regVM_INVALIDATE_ENG3_ADDR_RANGE_LO32_BASE_IDX                                                  0
#define regVM_INVALIDATE_ENG3_ADDR_RANGE_HI32                                                           0x08ae
#define regVM_INVALIDATE_ENG3_ADDR_RANGE_HI32_BASE_IDX                                                  0
#define regVM_INVALIDATE_ENG4_ADDR_RANGE_LO32                                                           0x08af
#define regVM_INVALIDATE_ENG4_ADDR_RANGE_LO32_BASE_IDX                                                  0
#define regVM_INVALIDATE_ENG4_ADDR_RANGE_HI32                                                           0x08b0
#define regVM_INVALIDATE_ENG4_ADDR_RANGE_HI32_BASE_IDX                                                  0
#define regVM_INVALIDATE_ENG5_ADDR_RANGE_LO32                                                           0x08b1
#define regVM_INVALIDATE_ENG5_ADDR_RANGE_LO32_BASE_IDX                                                  0
#define regVM_INVALIDATE_ENG5_ADDR_RANGE_HI32                                                           0x08b2
#define regVM_INVALIDATE_ENG5_ADDR_RANGE_HI32_BASE_IDX                                                  0
#define regVM_INVALIDATE_ENG6_ADDR_RANGE_LO32                                                           0x08b3
#define regVM_INVALIDATE_ENG6_ADDR_RANGE_LO32_BASE_IDX                                                  0
#define regVM_INVALIDATE_ENG6_ADDR_RANGE_HI32                                                           0x08b4
#define regVM_INVALIDATE_ENG6_ADDR_RANGE_HI32_BASE_IDX                                                  0
#define regVM_INVALIDATE_ENG7_ADDR_RANGE_LO32                                                           0x08b5
#define regVM_INVALIDATE_ENG7_ADDR_RANGE_LO32_BASE_IDX                                                  0
#define regVM_INVALIDATE_ENG7_ADDR_RANGE_HI32                                                           0x08b6
#define regVM_INVALIDATE_ENG7_ADDR_RANGE_HI32_BASE_IDX                                                  0
#define regVM_INVALIDATE_ENG8_ADDR_RANGE_LO32                                                           0x08b7
#define regVM_INVALIDATE_ENG8_ADDR_RANGE_LO32_BASE_IDX                                                  0
#define regVM_INVALIDATE_ENG8_ADDR_RANGE_HI32                                                           0x08b8
#define regVM_INVALIDATE_ENG8_ADDR_RANGE_HI32_BASE_IDX                                                  0
#define regVM_INVALIDATE_ENG9_ADDR_RANGE_LO32                                                           0x08b9
#define regVM_INVALIDATE_ENG9_ADDR_RANGE_LO32_BASE_IDX                                                  0
#define regVM_INVALIDATE_ENG9_ADDR_RANGE_HI32                                                           0x08ba
#define regVM_INVALIDATE_ENG9_ADDR_RANGE_HI32_BASE_IDX                                                  0
#define regVM_INVALIDATE_ENG10_ADDR_RANGE_LO32                                                          0x08bb
#define regVM_INVALIDATE_ENG10_ADDR_RANGE_LO32_BASE_IDX                                                 0
#define regVM_INVALIDATE_ENG10_ADDR_RANGE_HI32                                                          0x08bc
#define regVM_INVALIDATE_ENG10_ADDR_RANGE_HI32_BASE_IDX                                                 0
#define regVM_INVALIDATE_ENG11_ADDR_RANGE_LO32                                                          0x08bd
#define regVM_INVALIDATE_ENG11_ADDR_RANGE_LO32_BASE_IDX                                                 0
#define regVM_INVALIDATE_ENG11_ADDR_RANGE_HI32                                                          0x08be
#define regVM_INVALIDATE_ENG11_ADDR_RANGE_HI32_BASE_IDX                                                 0
#define regVM_INVALIDATE_ENG12_ADDR_RANGE_LO32                                                          0x08bf
#define regVM_INVALIDATE_ENG12_ADDR_RANGE_LO32_BASE_IDX                                                 0
#define regVM_INVALIDATE_ENG12_ADDR_RANGE_HI32                                                          0x08c0
#define regVM_INVALIDATE_ENG12_ADDR_RANGE_HI32_BASE_IDX                                                 0
#define regVM_INVALIDATE_ENG13_ADDR_RANGE_LO32                                                          0x08c1
#define regVM_INVALIDATE_ENG13_ADDR_RANGE_LO32_BASE_IDX                                                 0
#define regVM_INVALIDATE_ENG13_ADDR_RANGE_HI32                                                          0x08c2
#define regVM_INVALIDATE_ENG13_ADDR_RANGE_HI32_BASE_IDX                                                 0
#define regVM_INVALIDATE_ENG14_ADDR_RANGE_LO32                                                          0x08c3
#define regVM_INVALIDATE_ENG14_ADDR_RANGE_LO32_BASE_IDX                                                 0
#define regVM_INVALIDATE_ENG14_ADDR_RANGE_HI32                                                          0x08c4
#define regVM_INVALIDATE_ENG14_ADDR_RANGE_HI32_BASE_IDX                                                 0
#define regVM_INVALIDATE_ENG15_ADDR_RANGE_LO32                                                          0x08c5
#define regVM_INVALIDATE_ENG15_ADDR_RANGE_LO32_BASE_IDX                                                 0
#define regVM_INVALIDATE_ENG15_ADDR_RANGE_HI32                                                          0x08c6
#define regVM_INVALIDATE_ENG15_ADDR_RANGE_HI32_BASE_IDX                                                 0
#define regVM_INVALIDATE_ENG16_ADDR_RANGE_LO32                                                          0x08c7
#define regVM_INVALIDATE_ENG16_ADDR_RANGE_LO32_BASE_IDX                                                 0
#define regVM_INVALIDATE_ENG16_ADDR_RANGE_HI32                                                          0x08c8
#define regVM_INVALIDATE_ENG16_ADDR_RANGE_HI32_BASE_IDX                                                 0
#define regVM_INVALIDATE_ENG17_ADDR_RANGE_LO32                                                          0x08c9
#define regVM_INVALIDATE_ENG17_ADDR_RANGE_LO32_BASE_IDX                                                 0
#define regVM_INVALIDATE_ENG17_ADDR_RANGE_HI32                                                          0x08ca
#define regVM_INVALIDATE_ENG17_ADDR_RANGE_HI32_BASE_IDX                                                 0
#define regVM_CONTEXT0_PAGE_TABLE_BASE_ADDR_LO32                                                        0x08cb
#define regVM_CONTEXT0_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                               0
#define regVM_CONTEXT0_PAGE_TABLE_BASE_ADDR_HI32                                                        0x08cc
#define regVM_CONTEXT0_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                               0
#define regVM_CONTEXT1_PAGE_TABLE_BASE_ADDR_LO32                                                        0x08cd
#define regVM_CONTEXT1_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                               0
#define regVM_CONTEXT1_PAGE_TABLE_BASE_ADDR_HI32                                                        0x08ce
#define regVM_CONTEXT1_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                               0
#define regVM_CONTEXT2_PAGE_TABLE_BASE_ADDR_LO32                                                        0x08cf
#define regVM_CONTEXT2_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                               0
#define regVM_CONTEXT2_PAGE_TABLE_BASE_ADDR_HI32                                                        0x08d0
#define regVM_CONTEXT2_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                               0
#define regVM_CONTEXT3_PAGE_TABLE_BASE_ADDR_LO32                                                        0x08d1
#define regVM_CONTEXT3_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                               0
#define regVM_CONTEXT3_PAGE_TABLE_BASE_ADDR_HI32                                                        0x08d2
#define regVM_CONTEXT3_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                               0
#define regVM_CONTEXT4_PAGE_TABLE_BASE_ADDR_LO32                                                        0x08d3
#define regVM_CONTEXT4_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                               0
#define regVM_CONTEXT4_PAGE_TABLE_BASE_ADDR_HI32                                                        0x08d4
#define regVM_CONTEXT4_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                               0
#define regVM_CONTEXT5_PAGE_TABLE_BASE_ADDR_LO32                                                        0x08d5
#define regVM_CONTEXT5_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                               0
#define regVM_CONTEXT5_PAGE_TABLE_BASE_ADDR_HI32                                                        0x08d6
#define regVM_CONTEXT5_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                               0
#define regVM_CONTEXT6_PAGE_TABLE_BASE_ADDR_LO32                                                        0x08d7
#define regVM_CONTEXT6_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                               0
#define regVM_CONTEXT6_PAGE_TABLE_BASE_ADDR_HI32                                                        0x08d8
#define regVM_CONTEXT6_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                               0
#define regVM_CONTEXT7_PAGE_TABLE_BASE_ADDR_LO32                                                        0x08d9
#define regVM_CONTEXT7_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                               0
#define regVM_CONTEXT7_PAGE_TABLE_BASE_ADDR_HI32                                                        0x08da
#define regVM_CONTEXT7_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                               0
#define regVM_CONTEXT8_PAGE_TABLE_BASE_ADDR_LO32                                                        0x08db
#define regVM_CONTEXT8_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                               0
#define regVM_CONTEXT8_PAGE_TABLE_BASE_ADDR_HI32                                                        0x08dc
#define regVM_CONTEXT8_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                               0
#define regVM_CONTEXT9_PAGE_TABLE_BASE_ADDR_LO32                                                        0x08dd
#define regVM_CONTEXT9_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                               0
#define regVM_CONTEXT9_PAGE_TABLE_BASE_ADDR_HI32                                                        0x08de
#define regVM_CONTEXT9_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                               0
#define regVM_CONTEXT10_PAGE_TABLE_BASE_ADDR_LO32                                                       0x08df
#define regVM_CONTEXT10_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                              0
#define regVM_CONTEXT10_PAGE_TABLE_BASE_ADDR_HI32                                                       0x08e0
#define regVM_CONTEXT10_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                              0
#define regVM_CONTEXT11_PAGE_TABLE_BASE_ADDR_LO32                                                       0x08e1
#define regVM_CONTEXT11_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                              0
#define regVM_CONTEXT11_PAGE_TABLE_BASE_ADDR_HI32                                                       0x08e2
#define regVM_CONTEXT11_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                              0
#define regVM_CONTEXT12_PAGE_TABLE_BASE_ADDR_LO32                                                       0x08e3
#define regVM_CONTEXT12_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                              0
#define regVM_CONTEXT12_PAGE_TABLE_BASE_ADDR_HI32                                                       0x08e4
#define regVM_CONTEXT12_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                              0
#define regVM_CONTEXT13_PAGE_TABLE_BASE_ADDR_LO32                                                       0x08e5
#define regVM_CONTEXT13_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                              0
#define regVM_CONTEXT13_PAGE_TABLE_BASE_ADDR_HI32                                                       0x08e6
#define regVM_CONTEXT13_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                              0
#define regVM_CONTEXT14_PAGE_TABLE_BASE_ADDR_LO32                                                       0x08e7
#define regVM_CONTEXT14_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                              0
#define regVM_CONTEXT14_PAGE_TABLE_BASE_ADDR_HI32                                                       0x08e8
#define regVM_CONTEXT14_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                              0
#define regVM_CONTEXT15_PAGE_TABLE_BASE_ADDR_LO32                                                       0x08e9
#define regVM_CONTEXT15_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                              0
#define regVM_CONTEXT15_PAGE_TABLE_BASE_ADDR_HI32                                                       0x08ea
#define regVM_CONTEXT15_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                              0
#define regVM_CONTEXT0_PAGE_TABLE_START_ADDR_LO32                                                       0x08eb
#define regVM_CONTEXT0_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                              0
#define regVM_CONTEXT0_PAGE_TABLE_START_ADDR_HI32                                                       0x08ec
#define regVM_CONTEXT0_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                              0
#define regVM_CONTEXT1_PAGE_TABLE_START_ADDR_LO32                                                       0x08ed
#define regVM_CONTEXT1_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                              0
#define regVM_CONTEXT1_PAGE_TABLE_START_ADDR_HI32                                                       0x08ee
#define regVM_CONTEXT1_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                              0
#define regVM_CONTEXT2_PAGE_TABLE_START_ADDR_LO32                                                       0x08ef
#define regVM_CONTEXT2_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                              0
#define regVM_CONTEXT2_PAGE_TABLE_START_ADDR_HI32                                                       0x08f0
#define regVM_CONTEXT2_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                              0
#define regVM_CONTEXT3_PAGE_TABLE_START_ADDR_LO32                                                       0x08f1
#define regVM_CONTEXT3_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                              0
#define regVM_CONTEXT3_PAGE_TABLE_START_ADDR_HI32                                                       0x08f2
#define regVM_CONTEXT3_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                              0
#define regVM_CONTEXT4_PAGE_TABLE_START_ADDR_LO32                                                       0x08f3
#define regVM_CONTEXT4_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                              0
#define regVM_CONTEXT4_PAGE_TABLE_START_ADDR_HI32                                                       0x08f4
#define regVM_CONTEXT4_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                              0
#define regVM_CONTEXT5_PAGE_TABLE_START_ADDR_LO32                                                       0x08f5
#define regVM_CONTEXT5_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                              0
#define regVM_CONTEXT5_PAGE_TABLE_START_ADDR_HI32                                                       0x08f6
#define regVM_CONTEXT5_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                              0
#define regVM_CONTEXT6_PAGE_TABLE_START_ADDR_LO32                                                       0x08f7
#define regVM_CONTEXT6_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                              0
#define regVM_CONTEXT6_PAGE_TABLE_START_ADDR_HI32                                                       0x08f8
#define regVM_CONTEXT6_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                              0
#define regVM_CONTEXT7_PAGE_TABLE_START_ADDR_LO32                                                       0x08f9
#define regVM_CONTEXT7_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                              0
#define regVM_CONTEXT7_PAGE_TABLE_START_ADDR_HI32                                                       0x08fa
#define regVM_CONTEXT7_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                              0
#define regVM_CONTEXT8_PAGE_TABLE_START_ADDR_LO32                                                       0x08fb
#define regVM_CONTEXT8_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                              0
#define regVM_CONTEXT8_PAGE_TABLE_START_ADDR_HI32                                                       0x08fc
#define regVM_CONTEXT8_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                              0
#define regVM_CONTEXT9_PAGE_TABLE_START_ADDR_LO32                                                       0x08fd
#define regVM_CONTEXT9_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                              0
#define regVM_CONTEXT9_PAGE_TABLE_START_ADDR_HI32                                                       0x08fe
#define regVM_CONTEXT9_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                              0
#define regVM_CONTEXT10_PAGE_TABLE_START_ADDR_LO32                                                      0x08ff
#define regVM_CONTEXT10_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                             0
#define regVM_CONTEXT10_PAGE_TABLE_START_ADDR_HI32                                                      0x0900
#define regVM_CONTEXT10_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                             0
#define regVM_CONTEXT11_PAGE_TABLE_START_ADDR_LO32                                                      0x0901
#define regVM_CONTEXT11_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                             0
#define regVM_CONTEXT11_PAGE_TABLE_START_ADDR_HI32                                                      0x0902
#define regVM_CONTEXT11_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                             0
#define regVM_CONTEXT12_PAGE_TABLE_START_ADDR_LO32                                                      0x0903
#define regVM_CONTEXT12_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                             0
#define regVM_CONTEXT12_PAGE_TABLE_START_ADDR_HI32                                                      0x0904
#define regVM_CONTEXT12_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                             0
#define regVM_CONTEXT13_PAGE_TABLE_START_ADDR_LO32                                                      0x0905
#define regVM_CONTEXT13_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                             0
#define regVM_CONTEXT13_PAGE_TABLE_START_ADDR_HI32                                                      0x0906
#define regVM_CONTEXT13_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                             0
#define regVM_CONTEXT14_PAGE_TABLE_START_ADDR_LO32                                                      0x0907
#define regVM_CONTEXT14_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                             0
#define regVM_CONTEXT14_PAGE_TABLE_START_ADDR_HI32                                                      0x0908
#define regVM_CONTEXT14_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                             0
#define regVM_CONTEXT15_PAGE_TABLE_START_ADDR_LO32                                                      0x0909
#define regVM_CONTEXT15_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                             0
#define regVM_CONTEXT15_PAGE_TABLE_START_ADDR_HI32                                                      0x090a
#define regVM_CONTEXT15_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                             0
#define regVM_CONTEXT0_PAGE_TABLE_END_ADDR_LO32                                                         0x090b
#define regVM_CONTEXT0_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                                0
#define regVM_CONTEXT0_PAGE_TABLE_END_ADDR_HI32                                                         0x090c
#define regVM_CONTEXT0_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                                0
#define regVM_CONTEXT1_PAGE_TABLE_END_ADDR_LO32                                                         0x090d
#define regVM_CONTEXT1_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                                0
#define regVM_CONTEXT1_PAGE_TABLE_END_ADDR_HI32                                                         0x090e
#define regVM_CONTEXT1_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                                0
#define regVM_CONTEXT2_PAGE_TABLE_END_ADDR_LO32                                                         0x090f
#define regVM_CONTEXT2_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                                0
#define regVM_CONTEXT2_PAGE_TABLE_END_ADDR_HI32                                                         0x0910
#define regVM_CONTEXT2_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                                0
#define regVM_CONTEXT3_PAGE_TABLE_END_ADDR_LO32                                                         0x0911
#define regVM_CONTEXT3_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                                0
#define regVM_CONTEXT3_PAGE_TABLE_END_ADDR_HI32                                                         0x0912
#define regVM_CONTEXT3_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                                0
#define regVM_CONTEXT4_PAGE_TABLE_END_ADDR_LO32                                                         0x0913
#define regVM_CONTEXT4_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                                0
#define regVM_CONTEXT4_PAGE_TABLE_END_ADDR_HI32                                                         0x0914
#define regVM_CONTEXT4_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                                0
#define regVM_CONTEXT5_PAGE_TABLE_END_ADDR_LO32                                                         0x0915
#define regVM_CONTEXT5_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                                0
#define regVM_CONTEXT5_PAGE_TABLE_END_ADDR_HI32                                                         0x0916
#define regVM_CONTEXT5_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                                0
#define regVM_CONTEXT6_PAGE_TABLE_END_ADDR_LO32                                                         0x0917
#define regVM_CONTEXT6_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                                0
#define regVM_CONTEXT6_PAGE_TABLE_END_ADDR_HI32                                                         0x0918
#define regVM_CONTEXT6_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                                0
#define regVM_CONTEXT7_PAGE_TABLE_END_ADDR_LO32                                                         0x0919
#define regVM_CONTEXT7_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                                0
#define regVM_CONTEXT7_PAGE_TABLE_END_ADDR_HI32                                                         0x091a
#define regVM_CONTEXT7_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                                0
#define regVM_CONTEXT8_PAGE_TABLE_END_ADDR_LO32                                                         0x091b
#define regVM_CONTEXT8_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                                0
#define regVM_CONTEXT8_PAGE_TABLE_END_ADDR_HI32                                                         0x091c
#define regVM_CONTEXT8_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                                0
#define regVM_CONTEXT9_PAGE_TABLE_END_ADDR_LO32                                                         0x091d
#define regVM_CONTEXT9_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                                0
#define regVM_CONTEXT9_PAGE_TABLE_END_ADDR_HI32                                                         0x091e
#define regVM_CONTEXT9_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                                0
#define regVM_CONTEXT10_PAGE_TABLE_END_ADDR_LO32                                                        0x091f
#define regVM_CONTEXT10_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                               0
#define regVM_CONTEXT10_PAGE_TABLE_END_ADDR_HI32                                                        0x0920
#define regVM_CONTEXT10_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                               0
#define regVM_CONTEXT11_PAGE_TABLE_END_ADDR_LO32                                                        0x0921
#define regVM_CONTEXT11_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                               0
#define regVM_CONTEXT11_PAGE_TABLE_END_ADDR_HI32                                                        0x0922
#define regVM_CONTEXT11_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                               0
#define regVM_CONTEXT12_PAGE_TABLE_END_ADDR_LO32                                                        0x0923
#define regVM_CONTEXT12_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                               0
#define regVM_CONTEXT12_PAGE_TABLE_END_ADDR_HI32                                                        0x0924
#define regVM_CONTEXT12_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                               0
#define regVM_CONTEXT13_PAGE_TABLE_END_ADDR_LO32                                                        0x0925
#define regVM_CONTEXT13_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                               0
#define regVM_CONTEXT13_PAGE_TABLE_END_ADDR_HI32                                                        0x0926
#define regVM_CONTEXT13_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                               0
#define regVM_CONTEXT14_PAGE_TABLE_END_ADDR_LO32                                                        0x0927
#define regVM_CONTEXT14_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                               0
#define regVM_CONTEXT14_PAGE_TABLE_END_ADDR_HI32                                                        0x0928
#define regVM_CONTEXT14_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                               0
#define regVM_CONTEXT15_PAGE_TABLE_END_ADDR_LO32                                                        0x0929
#define regVM_CONTEXT15_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                               0
#define regVM_CONTEXT15_PAGE_TABLE_END_ADDR_HI32                                                        0x092a
#define regVM_CONTEXT15_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                               0


// addressBlock: xcd0_gc_utcl2_vmsharedpfdec
// base address: 0xa500
#define regMC_VM_NB_MMIOBASE                                                                            0x0940
#define regMC_VM_NB_MMIOBASE_BASE_IDX                                                                   0
#define regMC_VM_NB_MMIOLIMIT                                                                           0x0941
#define regMC_VM_NB_MMIOLIMIT_BASE_IDX                                                                  0
#define regMC_VM_NB_PCI_CTRL                                                                            0x0942
#define regMC_VM_NB_PCI_CTRL_BASE_IDX                                                                   0
#define regMC_VM_NB_PCI_ARB                                                                             0x0943
#define regMC_VM_NB_PCI_ARB_BASE_IDX                                                                    0
#define regMC_VM_NB_TOP_OF_DRAM_SLOT1                                                                   0x0944
#define regMC_VM_NB_TOP_OF_DRAM_SLOT1_BASE_IDX                                                          0
#define regMC_VM_NB_LOWER_TOP_OF_DRAM2                                                                  0x0945
#define regMC_VM_NB_LOWER_TOP_OF_DRAM2_BASE_IDX                                                         0
#define regMC_VM_NB_UPPER_TOP_OF_DRAM2                                                                  0x0946
#define regMC_VM_NB_UPPER_TOP_OF_DRAM2_BASE_IDX                                                         0
#define regMC_VM_FB_OFFSET                                                                              0x0947
#define regMC_VM_FB_OFFSET_BASE_IDX                                                                     0
#define regMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_LSB                                                       0x0948
#define regMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_LSB_BASE_IDX                                              0
#define regMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_MSB                                                       0x0949
#define regMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_MSB_BASE_IDX                                              0
#define regMC_VM_STEERING                                                                               0x094a
#define regMC_VM_STEERING_BASE_IDX                                                                      0
#define regMC_SHARED_VIRT_RESET_REQ                                                                     0x094b
#define regMC_SHARED_VIRT_RESET_REQ_BASE_IDX                                                            0
#define regMC_MEM_POWER_LS                                                                              0x094c
#define regMC_MEM_POWER_LS_BASE_IDX                                                                     0
#define regMC_VM_CACHEABLE_DRAM_ADDRESS_START                                                           0x094d
#define regMC_VM_CACHEABLE_DRAM_ADDRESS_START_BASE_IDX                                                  0
#define regMC_VM_CACHEABLE_DRAM_ADDRESS_END                                                             0x094e
#define regMC_VM_CACHEABLE_DRAM_ADDRESS_END_BASE_IDX                                                    0
#define regMC_VM_APT_CNTL                                                                               0x0951
#define regMC_VM_APT_CNTL_BASE_IDX                                                                      0
#define regMC_VM_LOCAL_HBM_ADDRESS_START                                                                0x0952
#define regMC_VM_LOCAL_HBM_ADDRESS_START_BASE_IDX                                                       0
#define regMC_VM_LOCAL_HBM_ADDRESS_END                                                                  0x0953
#define regMC_VM_LOCAL_HBM_ADDRESS_END_BASE_IDX                                                         0
#define regMC_VM_LOCAL_HBM_ADDRESS_LOCK_CNTL                                                            0x0954
#define regMC_VM_LOCAL_HBM_ADDRESS_LOCK_CNTL_BASE_IDX                                                   0
#define regUTCL2_CGTT_CLK_CTRL                                                                          0x0955
#define regUTCL2_CGTT_CLK_CTRL_BASE_IDX                                                                 0
#define regMC_VM_XGMI_LFB_CNTL                                                                          0x0957
#define regMC_VM_XGMI_LFB_CNTL_BASE_IDX                                                                 0
#define regMC_VM_XGMI_LFB_SIZE                                                                          0x0958
#define regMC_VM_XGMI_LFB_SIZE_BASE_IDX                                                                 0
#define regMC_VM_CACHEABLE_DRAM_CNTL                                                                    0x0959
#define regMC_VM_CACHEABLE_DRAM_CNTL_BASE_IDX                                                           0
#define regMC_VM_HOST_MAPPING                                                                           0x095a
#define regMC_VM_HOST_MAPPING_BASE_IDX                                                                  0


// addressBlock: xcd0_gc_utcl2_vmsharedvcdec
// base address: 0xa570
#define regMC_VM_FB_LOCATION_BASE                                                                       0x095c
#define regMC_VM_FB_LOCATION_BASE_BASE_IDX                                                              0
#define regMC_VM_FB_LOCATION_TOP                                                                        0x095d
#define regMC_VM_FB_LOCATION_TOP_BASE_IDX                                                               0
#define regMC_VM_AGP_TOP                                                                                0x095e
#define regMC_VM_AGP_TOP_BASE_IDX                                                                       0
#define regMC_VM_AGP_BOT                                                                                0x095f
#define regMC_VM_AGP_BOT_BASE_IDX                                                                       0
#define regMC_VM_AGP_BASE                                                                               0x0960
#define regMC_VM_AGP_BASE_BASE_IDX                                                                      0
#define regMC_VM_SYSTEM_APERTURE_LOW_ADDR                                                               0x0961
#define regMC_VM_SYSTEM_APERTURE_LOW_ADDR_BASE_IDX                                                      0
#define regMC_VM_SYSTEM_APERTURE_HIGH_ADDR                                                              0x0962
#define regMC_VM_SYSTEM_APERTURE_HIGH_ADDR_BASE_IDX                                                     0
#define regMC_VM_MX_L1_TLB_CNTL                                                                         0x0963
#define regMC_VM_MX_L1_TLB_CNTL_BASE_IDX                                                                0


// addressBlock: xcd0_gc_utcl2_l2tlbdec
// base address: 0xa5b0
#define regL2TLB_TLB0_STATUS                                                                            0x096d
#define regL2TLB_TLB0_STATUS_BASE_IDX                                                                   0
#define regUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_LO                                                 0x096f
#define regUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_LO_BASE_IDX                                        0
#define regUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_HI                                                 0x0970
#define regUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_HI_BASE_IDX                                        0
#define regUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_LO                                                0x0971
#define regUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_LO_BASE_IDX                                       0
#define regUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_HI                                                0x0972
#define regUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_HI_BASE_IDX                                       0


// addressBlock: xcd0_gc_tcdec
// base address: 0xac00
#define regTCP_INVALIDATE                                                                               0x0b00
#define regTCP_INVALIDATE_BASE_IDX                                                                      0
#define regTCP_STATUS                                                                                   0x0b01
#define regTCP_STATUS_BASE_IDX                                                                          0
#define regTCP_CNTL                                                                                     0x0b02
#define regTCP_CNTL_BASE_IDX                                                                            0
#define regTCP_CHAN_STEER_0                                                                             0x0b03
#define regTCP_CHAN_STEER_0_BASE_IDX                                                                    0
#define regTCP_CHAN_STEER_1                                                                             0x0b04
#define regTCP_CHAN_STEER_1_BASE_IDX                                                                    0
#define regTCP_ADDR_CONFIG                                                                              0x0b05
#define regTCP_ADDR_CONFIG_BASE_IDX                                                                     0
#define regTCP_CREDIT                                                                                   0x0b06
#define regTCP_CREDIT_BASE_IDX                                                                          0
#define regTCP_BUFFER_ADDR_HASH_CNTL                                                                    0x0b16
#define regTCP_BUFFER_ADDR_HASH_CNTL_BASE_IDX                                                           0
#define regTC_CFG_L1_LOAD_POLICY0                                                                       0x0b1a
#define regTC_CFG_L1_LOAD_POLICY0_BASE_IDX                                                              0
#define regTC_CFG_L1_LOAD_POLICY1                                                                       0x0b1b
#define regTC_CFG_L1_LOAD_POLICY1_BASE_IDX                                                              0
#define regTC_CFG_L1_STORE_POLICY                                                                       0x0b1c
#define regTC_CFG_L1_STORE_POLICY_BASE_IDX                                                              0
#define regTC_CFG_L2_LOAD_POLICY0                                                                       0x0b1d
#define regTC_CFG_L2_LOAD_POLICY0_BASE_IDX                                                              0
#define regTC_CFG_L2_LOAD_POLICY1                                                                       0x0b1e
#define regTC_CFG_L2_LOAD_POLICY1_BASE_IDX                                                              0
#define regTC_CFG_L2_STORE_POLICY0                                                                      0x0b1f
#define regTC_CFG_L2_STORE_POLICY0_BASE_IDX                                                             0
#define regTC_CFG_L2_STORE_POLICY1                                                                      0x0b20
#define regTC_CFG_L2_STORE_POLICY1_BASE_IDX                                                             0
#define regTC_CFG_L2_ATOMIC_POLICY                                                                      0x0b21
#define regTC_CFG_L2_ATOMIC_POLICY_BASE_IDX                                                             0
#define regTC_CFG_L1_VOLATILE                                                                           0x0b22
#define regTC_CFG_L1_VOLATILE_BASE_IDX                                                                  0
#define regTC_CFG_L2_VOLATILE                                                                           0x0b23
#define regTC_CFG_L2_VOLATILE_BASE_IDX                                                                  0
#define regTCP_UE_EDC_HI_REG                                                                            0x0b54
#define regTCP_UE_EDC_HI_REG_BASE_IDX                                                                   0
#define regTCP_UE_EDC_LO_REG                                                                            0x0b55
#define regTCP_UE_EDC_LO_REG_BASE_IDX                                                                   0
#define regTCP_CE_EDC_HI_REG                                                                            0x0b56
#define regTCP_CE_EDC_HI_REG_BASE_IDX                                                                   0
#define regTCP_CE_EDC_LO_REG                                                                            0x0b57
#define regTCP_CE_EDC_LO_REG_BASE_IDX                                                                   0
#define regTCI_UE_EDC_HI_REG                                                                            0x0b58
#define regTCI_UE_EDC_HI_REG_BASE_IDX                                                                   0
#define regTCI_UE_EDC_LO_REG                                                                            0x0b59
#define regTCI_UE_EDC_LO_REG_BASE_IDX                                                                   0
#define regTCI_CE_EDC_HI_REG                                                                            0x0b5a
#define regTCI_CE_EDC_HI_REG_BASE_IDX                                                                   0
#define regTCI_CE_EDC_LO_REG                                                                            0x0b5b
#define regTCI_CE_EDC_LO_REG_BASE_IDX                                                                   0
#define regTCI_MISC                                                                                     0x0b5c
#define regTCI_MISC_BASE_IDX                                                                            0
#define regTCI_CNTL_3                                                                                   0x0b5d
#define regTCI_CNTL_3_BASE_IDX                                                                          0
#define regTCI_DSM_CNTL                                                                                 0x0b5e
#define regTCI_DSM_CNTL_BASE_IDX                                                                        0
#define regTCI_DSM_CNTL2                                                                                0x0b5f
#define regTCI_DSM_CNTL2_BASE_IDX                                                                       0
#define regTCI_STATUS                                                                                   0x0b61
#define regTCI_STATUS_BASE_IDX                                                                          0
#define regTCI_CNTL_1                                                                                   0x0b62
#define regTCI_CNTL_1_BASE_IDX                                                                          0
#define regTCI_CNTL_2                                                                                   0x0b63
#define regTCI_CNTL_2_BASE_IDX                                                                          0
#define regTCC_CTRL                                                                                     0x0b80
#define regTCC_CTRL_BASE_IDX                                                                            0
#define regTCC_CTRL2                                                                                    0x0b81
#define regTCC_CTRL2_BASE_IDX                                                                           0
#define regTCC_DSM_CNTL                                                                                 0x0b86
#define regTCC_DSM_CNTL_BASE_IDX                                                                        0
#define regTCC_DSM_CNTLA                                                                                0x0b87
#define regTCC_DSM_CNTLA_BASE_IDX                                                                       0
#define regTCC_DSM_CNTL2                                                                                0x0b88
#define regTCC_DSM_CNTL2_BASE_IDX                                                                       0
#define regTCC_DSM_CNTL2A                                                                               0x0b89
#define regTCC_DSM_CNTL2A_BASE_IDX                                                                      0
#define regTCC_DSM_CNTL2B                                                                               0x0b8a
#define regTCC_DSM_CNTL2B_BASE_IDX                                                                      0
#define regTCC_WBINVL2                                                                                  0x0b8b
#define regTCC_WBINVL2_BASE_IDX                                                                         0
#define regTCC_SOFT_RESET                                                                               0x0b8c
#define regTCC_SOFT_RESET_BASE_IDX                                                                      0
#define regTCC_DSM_CNTL3                                                                                0x0b8e
#define regTCC_DSM_CNTL3_BASE_IDX                                                                       0
#define regTCA_CTRL                                                                                     0x0bc0
#define regTCA_CTRL_BASE_IDX                                                                            0
#define regTCA_BURST_MASK                                                                               0x0bc1
#define regTCA_BURST_MASK_BASE_IDX                                                                      0
#define regTCA_BURST_CTRL                                                                               0x0bc2
#define regTCA_BURST_CTRL_BASE_IDX                                                                      0
#define regTCA_DSM_CNTL                                                                                 0x0bc3
#define regTCA_DSM_CNTL_BASE_IDX                                                                        0
#define regTCA_DSM_CNTL2                                                                                0x0bc4
#define regTCA_DSM_CNTL2_BASE_IDX                                                                       0
#define regTCX_CTRL                                                                                     0x0bc6
#define regTCX_CTRL_BASE_IDX                                                                            0
#define regTCX_DSM_CNTL                                                                                 0x0bc7
#define regTCX_DSM_CNTL_BASE_IDX                                                                        0
#define regTCX_DSM_CNTL2                                                                                0x0bc8
#define regTCX_DSM_CNTL2_BASE_IDX                                                                       0
#define regTCA_UE_ERR_STATUS_LO                                                                         0x0bc9
#define regTCA_UE_ERR_STATUS_LO_BASE_IDX                                                                0
#define regTCA_UE_ERR_STATUS_HI                                                                         0x0bca
#define regTCA_UE_ERR_STATUS_HI_BASE_IDX                                                                0
#define regTCX_UE_ERR_STATUS_LO                                                                         0x0bcb
#define regTCX_UE_ERR_STATUS_LO_BASE_IDX                                                                0
#define regTCX_UE_ERR_STATUS_HI                                                                         0x0bcc
#define regTCX_UE_ERR_STATUS_HI_BASE_IDX                                                                0
#define regTCX_CE_ERR_STATUS_LO                                                                         0x0bcd
#define regTCX_CE_ERR_STATUS_LO_BASE_IDX                                                                0
#define regTCX_CE_ERR_STATUS_HI                                                                         0x0bce
#define regTCX_CE_ERR_STATUS_HI_BASE_IDX                                                                0
#define regTCC_UE_ERR_STATUS_LO                                                                         0x0bcf
#define regTCC_UE_ERR_STATUS_LO_BASE_IDX                                                                0
#define regTCC_UE_ERR_STATUS_HI                                                                         0x0bd0
#define regTCC_UE_ERR_STATUS_HI_BASE_IDX                                                                0
#define regTCC_CE_ERR_STATUS_LO                                                                         0x0bd1
#define regTCC_CE_ERR_STATUS_LO_BASE_IDX                                                                0
#define regTCC_CE_ERR_STATUS_HI                                                                         0x0bd2
#define regTCC_CE_ERR_STATUS_HI_BASE_IDX                                                                0


// addressBlock: xcd0_gc_shdec
// base address: 0xb000
#define regSPI_SHADER_PGM_RSRC3_PS                                                                      0x0c07
#define regSPI_SHADER_PGM_RSRC3_PS_BASE_IDX                                                             0
#define regSPI_SHADER_PGM_LO_PS                                                                         0x0c08
#define regSPI_SHADER_PGM_LO_PS_BASE_IDX                                                                0
#define regSPI_SHADER_PGM_HI_PS                                                                         0x0c09
#define regSPI_SHADER_PGM_HI_PS_BASE_IDX                                                                0
#define regSPI_SHADER_PGM_RSRC1_PS                                                                      0x0c0a
#define regSPI_SHADER_PGM_RSRC1_PS_BASE_IDX                                                             0
#define regSPI_SHADER_PGM_RSRC2_PS                                                                      0x0c0b
#define regSPI_SHADER_PGM_RSRC2_PS_BASE_IDX                                                             0
#define regSPI_SHADER_USER_DATA_PS_0                                                                    0x0c0c
#define regSPI_SHADER_USER_DATA_PS_0_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_PS_1                                                                    0x0c0d
#define regSPI_SHADER_USER_DATA_PS_1_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_PS_2                                                                    0x0c0e
#define regSPI_SHADER_USER_DATA_PS_2_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_PS_3                                                                    0x0c0f
#define regSPI_SHADER_USER_DATA_PS_3_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_PS_4                                                                    0x0c10
#define regSPI_SHADER_USER_DATA_PS_4_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_PS_5                                                                    0x0c11
#define regSPI_SHADER_USER_DATA_PS_5_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_PS_6                                                                    0x0c12
#define regSPI_SHADER_USER_DATA_PS_6_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_PS_7                                                                    0x0c13
#define regSPI_SHADER_USER_DATA_PS_7_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_PS_8                                                                    0x0c14
#define regSPI_SHADER_USER_DATA_PS_8_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_PS_9                                                                    0x0c15
#define regSPI_SHADER_USER_DATA_PS_9_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_PS_10                                                                   0x0c16
#define regSPI_SHADER_USER_DATA_PS_10_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_11                                                                   0x0c17
#define regSPI_SHADER_USER_DATA_PS_11_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_12                                                                   0x0c18
#define regSPI_SHADER_USER_DATA_PS_12_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_13                                                                   0x0c19
#define regSPI_SHADER_USER_DATA_PS_13_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_14                                                                   0x0c1a
#define regSPI_SHADER_USER_DATA_PS_14_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_15                                                                   0x0c1b
#define regSPI_SHADER_USER_DATA_PS_15_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_16                                                                   0x0c1c
#define regSPI_SHADER_USER_DATA_PS_16_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_17                                                                   0x0c1d
#define regSPI_SHADER_USER_DATA_PS_17_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_18                                                                   0x0c1e
#define regSPI_SHADER_USER_DATA_PS_18_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_19                                                                   0x0c1f
#define regSPI_SHADER_USER_DATA_PS_19_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_20                                                                   0x0c20
#define regSPI_SHADER_USER_DATA_PS_20_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_21                                                                   0x0c21
#define regSPI_SHADER_USER_DATA_PS_21_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_22                                                                   0x0c22
#define regSPI_SHADER_USER_DATA_PS_22_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_23                                                                   0x0c23
#define regSPI_SHADER_USER_DATA_PS_23_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_24                                                                   0x0c24
#define regSPI_SHADER_USER_DATA_PS_24_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_25                                                                   0x0c25
#define regSPI_SHADER_USER_DATA_PS_25_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_26                                                                   0x0c26
#define regSPI_SHADER_USER_DATA_PS_26_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_27                                                                   0x0c27
#define regSPI_SHADER_USER_DATA_PS_27_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_28                                                                   0x0c28
#define regSPI_SHADER_USER_DATA_PS_28_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_29                                                                   0x0c29
#define regSPI_SHADER_USER_DATA_PS_29_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_30                                                                   0x0c2a
#define regSPI_SHADER_USER_DATA_PS_30_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_31                                                                   0x0c2b
#define regSPI_SHADER_USER_DATA_PS_31_BASE_IDX                                                          0
#define regSPI_SHADER_PGM_RSRC3_VS                                                                      0x0c46
#define regSPI_SHADER_PGM_RSRC3_VS_BASE_IDX                                                             0
#define regSPI_SHADER_LATE_ALLOC_VS                                                                     0x0c47
#define regSPI_SHADER_LATE_ALLOC_VS_BASE_IDX                                                            0
#define regSPI_SHADER_PGM_LO_VS                                                                         0x0c48
#define regSPI_SHADER_PGM_LO_VS_BASE_IDX                                                                0
#define regSPI_SHADER_PGM_HI_VS                                                                         0x0c49
#define regSPI_SHADER_PGM_HI_VS_BASE_IDX                                                                0
#define regSPI_SHADER_PGM_RSRC1_VS                                                                      0x0c4a
#define regSPI_SHADER_PGM_RSRC1_VS_BASE_IDX                                                             0
#define regSPI_SHADER_PGM_RSRC2_VS                                                                      0x0c4b
#define regSPI_SHADER_PGM_RSRC2_VS_BASE_IDX                                                             0
#define regSPI_SHADER_USER_DATA_VS_0                                                                    0x0c4c
#define regSPI_SHADER_USER_DATA_VS_0_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_VS_1                                                                    0x0c4d
#define regSPI_SHADER_USER_DATA_VS_1_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_VS_2                                                                    0x0c4e
#define regSPI_SHADER_USER_DATA_VS_2_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_VS_3                                                                    0x0c4f
#define regSPI_SHADER_USER_DATA_VS_3_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_VS_4                                                                    0x0c50
#define regSPI_SHADER_USER_DATA_VS_4_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_VS_5                                                                    0x0c51
#define regSPI_SHADER_USER_DATA_VS_5_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_VS_6                                                                    0x0c52
#define regSPI_SHADER_USER_DATA_VS_6_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_VS_7                                                                    0x0c53
#define regSPI_SHADER_USER_DATA_VS_7_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_VS_8                                                                    0x0c54
#define regSPI_SHADER_USER_DATA_VS_8_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_VS_9                                                                    0x0c55
#define regSPI_SHADER_USER_DATA_VS_9_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_VS_10                                                                   0x0c56
#define regSPI_SHADER_USER_DATA_VS_10_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_VS_11                                                                   0x0c57
#define regSPI_SHADER_USER_DATA_VS_11_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_VS_12                                                                   0x0c58
#define regSPI_SHADER_USER_DATA_VS_12_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_VS_13                                                                   0x0c59
#define regSPI_SHADER_USER_DATA_VS_13_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_VS_14                                                                   0x0c5a
#define regSPI_SHADER_USER_DATA_VS_14_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_VS_15                                                                   0x0c5b
#define regSPI_SHADER_USER_DATA_VS_15_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_VS_16                                                                   0x0c5c
#define regSPI_SHADER_USER_DATA_VS_16_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_VS_17                                                                   0x0c5d
#define regSPI_SHADER_USER_DATA_VS_17_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_VS_18                                                                   0x0c5e
#define regSPI_SHADER_USER_DATA_VS_18_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_VS_19                                                                   0x0c5f
#define regSPI_SHADER_USER_DATA_VS_19_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_VS_20                                                                   0x0c60
#define regSPI_SHADER_USER_DATA_VS_20_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_VS_21                                                                   0x0c61
#define regSPI_SHADER_USER_DATA_VS_21_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_VS_22                                                                   0x0c62
#define regSPI_SHADER_USER_DATA_VS_22_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_VS_23                                                                   0x0c63
#define regSPI_SHADER_USER_DATA_VS_23_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_VS_24                                                                   0x0c64
#define regSPI_SHADER_USER_DATA_VS_24_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_VS_25                                                                   0x0c65
#define regSPI_SHADER_USER_DATA_VS_25_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_VS_26                                                                   0x0c66
#define regSPI_SHADER_USER_DATA_VS_26_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_VS_27                                                                   0x0c67
#define regSPI_SHADER_USER_DATA_VS_27_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_VS_28                                                                   0x0c68
#define regSPI_SHADER_USER_DATA_VS_28_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_VS_29                                                                   0x0c69
#define regSPI_SHADER_USER_DATA_VS_29_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_VS_30                                                                   0x0c6a
#define regSPI_SHADER_USER_DATA_VS_30_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_VS_31                                                                   0x0c6b
#define regSPI_SHADER_USER_DATA_VS_31_BASE_IDX                                                          0
#define regSPI_SHADER_PGM_RSRC2_GS_VS                                                                   0x0c7c
#define regSPI_SHADER_PGM_RSRC2_GS_VS_BASE_IDX                                                          0
#define regSPI_SHADER_PGM_RSRC4_GS                                                                      0x0c81
#define regSPI_SHADER_PGM_RSRC4_GS_BASE_IDX                                                             0
#define regSPI_SHADER_USER_DATA_ADDR_LO_GS                                                              0x0c82
#define regSPI_SHADER_USER_DATA_ADDR_LO_GS_BASE_IDX                                                     0
#define regSPI_SHADER_USER_DATA_ADDR_HI_GS                                                              0x0c83
#define regSPI_SHADER_USER_DATA_ADDR_HI_GS_BASE_IDX                                                     0
#define regSPI_SHADER_PGM_LO_ES                                                                         0x0c84
#define regSPI_SHADER_PGM_LO_ES_BASE_IDX                                                                0
#define regSPI_SHADER_PGM_HI_ES                                                                         0x0c85
#define regSPI_SHADER_PGM_HI_ES_BASE_IDX                                                                0
#define regSPI_SHADER_PGM_RSRC3_GS                                                                      0x0c87
#define regSPI_SHADER_PGM_RSRC3_GS_BASE_IDX                                                             0
#define regSPI_SHADER_PGM_LO_GS                                                                         0x0c88
#define regSPI_SHADER_PGM_LO_GS_BASE_IDX                                                                0
#define regSPI_SHADER_PGM_HI_GS                                                                         0x0c89
#define regSPI_SHADER_PGM_HI_GS_BASE_IDX                                                                0
#define regSPI_SHADER_PGM_RSRC1_GS                                                                      0x0c8a
#define regSPI_SHADER_PGM_RSRC1_GS_BASE_IDX                                                             0
#define regSPI_SHADER_PGM_RSRC2_GS                                                                      0x0c8b
#define regSPI_SHADER_PGM_RSRC2_GS_BASE_IDX                                                             0
#define regSPI_SHADER_USER_DATA_ES_0                                                                    0x0ccc
#define regSPI_SHADER_USER_DATA_ES_0_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_ES_1                                                                    0x0ccd
#define regSPI_SHADER_USER_DATA_ES_1_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_ES_2                                                                    0x0cce
#define regSPI_SHADER_USER_DATA_ES_2_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_ES_3                                                                    0x0ccf
#define regSPI_SHADER_USER_DATA_ES_3_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_ES_4                                                                    0x0cd0
#define regSPI_SHADER_USER_DATA_ES_4_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_ES_5                                                                    0x0cd1
#define regSPI_SHADER_USER_DATA_ES_5_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_ES_6                                                                    0x0cd2
#define regSPI_SHADER_USER_DATA_ES_6_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_ES_7                                                                    0x0cd3
#define regSPI_SHADER_USER_DATA_ES_7_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_ES_8                                                                    0x0cd4
#define regSPI_SHADER_USER_DATA_ES_8_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_ES_9                                                                    0x0cd5
#define regSPI_SHADER_USER_DATA_ES_9_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_ES_10                                                                   0x0cd6
#define regSPI_SHADER_USER_DATA_ES_10_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_ES_11                                                                   0x0cd7
#define regSPI_SHADER_USER_DATA_ES_11_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_ES_12                                                                   0x0cd8
#define regSPI_SHADER_USER_DATA_ES_12_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_ES_13                                                                   0x0cd9
#define regSPI_SHADER_USER_DATA_ES_13_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_ES_14                                                                   0x0cda
#define regSPI_SHADER_USER_DATA_ES_14_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_ES_15                                                                   0x0cdb
#define regSPI_SHADER_USER_DATA_ES_15_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_ES_16                                                                   0x0cdc
#define regSPI_SHADER_USER_DATA_ES_16_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_ES_17                                                                   0x0cdd
#define regSPI_SHADER_USER_DATA_ES_17_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_ES_18                                                                   0x0cde
#define regSPI_SHADER_USER_DATA_ES_18_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_ES_19                                                                   0x0cdf
#define regSPI_SHADER_USER_DATA_ES_19_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_ES_20                                                                   0x0ce0
#define regSPI_SHADER_USER_DATA_ES_20_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_ES_21                                                                   0x0ce1
#define regSPI_SHADER_USER_DATA_ES_21_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_ES_22                                                                   0x0ce2
#define regSPI_SHADER_USER_DATA_ES_22_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_ES_23                                                                   0x0ce3
#define regSPI_SHADER_USER_DATA_ES_23_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_ES_24                                                                   0x0ce4
#define regSPI_SHADER_USER_DATA_ES_24_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_ES_25                                                                   0x0ce5
#define regSPI_SHADER_USER_DATA_ES_25_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_ES_26                                                                   0x0ce6
#define regSPI_SHADER_USER_DATA_ES_26_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_ES_27                                                                   0x0ce7
#define regSPI_SHADER_USER_DATA_ES_27_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_ES_28                                                                   0x0ce8
#define regSPI_SHADER_USER_DATA_ES_28_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_ES_29                                                                   0x0ce9
#define regSPI_SHADER_USER_DATA_ES_29_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_ES_30                                                                   0x0cea
#define regSPI_SHADER_USER_DATA_ES_30_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_ES_31                                                                   0x0ceb
#define regSPI_SHADER_USER_DATA_ES_31_BASE_IDX                                                          0
#define regSPI_SHADER_PGM_RSRC4_HS                                                                      0x0d01
#define regSPI_SHADER_PGM_RSRC4_HS_BASE_IDX                                                             0
#define regSPI_SHADER_USER_DATA_ADDR_LO_HS                                                              0x0d02
#define regSPI_SHADER_USER_DATA_ADDR_LO_HS_BASE_IDX                                                     0
#define regSPI_SHADER_USER_DATA_ADDR_HI_HS                                                              0x0d03
#define regSPI_SHADER_USER_DATA_ADDR_HI_HS_BASE_IDX                                                     0
#define regSPI_SHADER_PGM_LO_LS                                                                         0x0d04
#define regSPI_SHADER_PGM_LO_LS_BASE_IDX                                                                0
#define regSPI_SHADER_PGM_HI_LS                                                                         0x0d05
#define regSPI_SHADER_PGM_HI_LS_BASE_IDX                                                                0
#define regSPI_SHADER_PGM_RSRC3_HS                                                                      0x0d07
#define regSPI_SHADER_PGM_RSRC3_HS_BASE_IDX                                                             0
#define regSPI_SHADER_PGM_LO_HS                                                                         0x0d08
#define regSPI_SHADER_PGM_LO_HS_BASE_IDX                                                                0
#define regSPI_SHADER_PGM_HI_HS                                                                         0x0d09
#define regSPI_SHADER_PGM_HI_HS_BASE_IDX                                                                0
#define regSPI_SHADER_PGM_RSRC1_HS                                                                      0x0d0a
#define regSPI_SHADER_PGM_RSRC1_HS_BASE_IDX                                                             0
#define regSPI_SHADER_PGM_RSRC2_HS                                                                      0x0d0b
#define regSPI_SHADER_PGM_RSRC2_HS_BASE_IDX                                                             0
#define regSPI_SHADER_USER_DATA_LS_0                                                                    0x0d0c
#define regSPI_SHADER_USER_DATA_LS_0_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_LS_1                                                                    0x0d0d
#define regSPI_SHADER_USER_DATA_LS_1_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_LS_2                                                                    0x0d0e
#define regSPI_SHADER_USER_DATA_LS_2_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_LS_3                                                                    0x0d0f
#define regSPI_SHADER_USER_DATA_LS_3_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_LS_4                                                                    0x0d10
#define regSPI_SHADER_USER_DATA_LS_4_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_LS_5                                                                    0x0d11
#define regSPI_SHADER_USER_DATA_LS_5_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_LS_6                                                                    0x0d12
#define regSPI_SHADER_USER_DATA_LS_6_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_LS_7                                                                    0x0d13
#define regSPI_SHADER_USER_DATA_LS_7_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_LS_8                                                                    0x0d14
#define regSPI_SHADER_USER_DATA_LS_8_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_LS_9                                                                    0x0d15
#define regSPI_SHADER_USER_DATA_LS_9_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_LS_10                                                                   0x0d16
#define regSPI_SHADER_USER_DATA_LS_10_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_LS_11                                                                   0x0d17
#define regSPI_SHADER_USER_DATA_LS_11_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_LS_12                                                                   0x0d18
#define regSPI_SHADER_USER_DATA_LS_12_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_LS_13                                                                   0x0d19
#define regSPI_SHADER_USER_DATA_LS_13_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_LS_14                                                                   0x0d1a
#define regSPI_SHADER_USER_DATA_LS_14_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_LS_15                                                                   0x0d1b
#define regSPI_SHADER_USER_DATA_LS_15_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_LS_16                                                                   0x0d1c
#define regSPI_SHADER_USER_DATA_LS_16_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_LS_17                                                                   0x0d1d
#define regSPI_SHADER_USER_DATA_LS_17_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_LS_18                                                                   0x0d1e
#define regSPI_SHADER_USER_DATA_LS_18_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_LS_19                                                                   0x0d1f
#define regSPI_SHADER_USER_DATA_LS_19_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_LS_20                                                                   0x0d20
#define regSPI_SHADER_USER_DATA_LS_20_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_LS_21                                                                   0x0d21
#define regSPI_SHADER_USER_DATA_LS_21_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_LS_22                                                                   0x0d22
#define regSPI_SHADER_USER_DATA_LS_22_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_LS_23                                                                   0x0d23
#define regSPI_SHADER_USER_DATA_LS_23_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_LS_24                                                                   0x0d24
#define regSPI_SHADER_USER_DATA_LS_24_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_LS_25                                                                   0x0d25
#define regSPI_SHADER_USER_DATA_LS_25_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_LS_26                                                                   0x0d26
#define regSPI_SHADER_USER_DATA_LS_26_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_LS_27                                                                   0x0d27
#define regSPI_SHADER_USER_DATA_LS_27_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_LS_28                                                                   0x0d28
#define regSPI_SHADER_USER_DATA_LS_28_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_LS_29                                                                   0x0d29
#define regSPI_SHADER_USER_DATA_LS_29_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_LS_30                                                                   0x0d2a
#define regSPI_SHADER_USER_DATA_LS_30_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_LS_31                                                                   0x0d2b
#define regSPI_SHADER_USER_DATA_LS_31_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_COMMON_0                                                                0x0d4c
#define regSPI_SHADER_USER_DATA_COMMON_0_BASE_IDX                                                       0
#define regSPI_SHADER_USER_DATA_COMMON_1                                                                0x0d4d
#define regSPI_SHADER_USER_DATA_COMMON_1_BASE_IDX                                                       0
#define regSPI_SHADER_USER_DATA_COMMON_2                                                                0x0d4e
#define regSPI_SHADER_USER_DATA_COMMON_2_BASE_IDX                                                       0
#define regSPI_SHADER_USER_DATA_COMMON_3                                                                0x0d4f
#define regSPI_SHADER_USER_DATA_COMMON_3_BASE_IDX                                                       0
#define regSPI_SHADER_USER_DATA_COMMON_4                                                                0x0d50
#define regSPI_SHADER_USER_DATA_COMMON_4_BASE_IDX                                                       0
#define regSPI_SHADER_USER_DATA_COMMON_5                                                                0x0d51
#define regSPI_SHADER_USER_DATA_COMMON_5_BASE_IDX                                                       0
#define regSPI_SHADER_USER_DATA_COMMON_6                                                                0x0d52
#define regSPI_SHADER_USER_DATA_COMMON_6_BASE_IDX                                                       0
#define regSPI_SHADER_USER_DATA_COMMON_7                                                                0x0d53
#define regSPI_SHADER_USER_DATA_COMMON_7_BASE_IDX                                                       0
#define regSPI_SHADER_USER_DATA_COMMON_8                                                                0x0d54
#define regSPI_SHADER_USER_DATA_COMMON_8_BASE_IDX                                                       0
#define regSPI_SHADER_USER_DATA_COMMON_9                                                                0x0d55
#define regSPI_SHADER_USER_DATA_COMMON_9_BASE_IDX                                                       0
#define regSPI_SHADER_USER_DATA_COMMON_10                                                               0x0d56
#define regSPI_SHADER_USER_DATA_COMMON_10_BASE_IDX                                                      0
#define regSPI_SHADER_USER_DATA_COMMON_11                                                               0x0d57
#define regSPI_SHADER_USER_DATA_COMMON_11_BASE_IDX                                                      0
#define regSPI_SHADER_USER_DATA_COMMON_12                                                               0x0d58
#define regSPI_SHADER_USER_DATA_COMMON_12_BASE_IDX                                                      0
#define regSPI_SHADER_USER_DATA_COMMON_13                                                               0x0d59
#define regSPI_SHADER_USER_DATA_COMMON_13_BASE_IDX                                                      0
#define regSPI_SHADER_USER_DATA_COMMON_14                                                               0x0d5a
#define regSPI_SHADER_USER_DATA_COMMON_14_BASE_IDX                                                      0
#define regSPI_SHADER_USER_DATA_COMMON_15                                                               0x0d5b
#define regSPI_SHADER_USER_DATA_COMMON_15_BASE_IDX                                                      0
#define regSPI_SHADER_USER_DATA_COMMON_16                                                               0x0d5c
#define regSPI_SHADER_USER_DATA_COMMON_16_BASE_IDX                                                      0
#define regSPI_SHADER_USER_DATA_COMMON_17                                                               0x0d5d
#define regSPI_SHADER_USER_DATA_COMMON_17_BASE_IDX                                                      0
#define regSPI_SHADER_USER_DATA_COMMON_18                                                               0x0d5e
#define regSPI_SHADER_USER_DATA_COMMON_18_BASE_IDX                                                      0
#define regSPI_SHADER_USER_DATA_COMMON_19                                                               0x0d5f
#define regSPI_SHADER_USER_DATA_COMMON_19_BASE_IDX                                                      0
#define regSPI_SHADER_USER_DATA_COMMON_20                                                               0x0d60
#define regSPI_SHADER_USER_DATA_COMMON_20_BASE_IDX                                                      0
#define regSPI_SHADER_USER_DATA_COMMON_21                                                               0x0d61
#define regSPI_SHADER_USER_DATA_COMMON_21_BASE_IDX                                                      0
#define regSPI_SHADER_USER_DATA_COMMON_22                                                               0x0d62
#define regSPI_SHADER_USER_DATA_COMMON_22_BASE_IDX                                                      0
#define regSPI_SHADER_USER_DATA_COMMON_23                                                               0x0d63
#define regSPI_SHADER_USER_DATA_COMMON_23_BASE_IDX                                                      0
#define regSPI_SHADER_USER_DATA_COMMON_24                                                               0x0d64
#define regSPI_SHADER_USER_DATA_COMMON_24_BASE_IDX                                                      0
#define regSPI_SHADER_USER_DATA_COMMON_25                                                               0x0d65
#define regSPI_SHADER_USER_DATA_COMMON_25_BASE_IDX                                                      0
#define regSPI_SHADER_USER_DATA_COMMON_26                                                               0x0d66
#define regSPI_SHADER_USER_DATA_COMMON_26_BASE_IDX                                                      0
#define regSPI_SHADER_USER_DATA_COMMON_27                                                               0x0d67
#define regSPI_SHADER_USER_DATA_COMMON_27_BASE_IDX                                                      0
#define regSPI_SHADER_USER_DATA_COMMON_28                                                               0x0d68
#define regSPI_SHADER_USER_DATA_COMMON_28_BASE_IDX                                                      0
#define regSPI_SHADER_USER_DATA_COMMON_29                                                               0x0d69
#define regSPI_SHADER_USER_DATA_COMMON_29_BASE_IDX                                                      0
#define regSPI_SHADER_USER_DATA_COMMON_30                                                               0x0d6a
#define regSPI_SHADER_USER_DATA_COMMON_30_BASE_IDX                                                      0
#define regSPI_SHADER_USER_DATA_COMMON_31                                                               0x0d6b
#define regSPI_SHADER_USER_DATA_COMMON_31_BASE_IDX                                                      0
#define regCOMPUTE_DISPATCH_INITIATOR                                                                   0x0e00
#define regCOMPUTE_DISPATCH_INITIATOR_BASE_IDX                                                          0
#define regCOMPUTE_DIM_X                                                                                0x0e01
#define regCOMPUTE_DIM_X_BASE_IDX                                                                       0
#define regCOMPUTE_DIM_Y                                                                                0x0e02
#define regCOMPUTE_DIM_Y_BASE_IDX                                                                       0
#define regCOMPUTE_DIM_Z                                                                                0x0e03
#define regCOMPUTE_DIM_Z_BASE_IDX                                                                       0
#define regCOMPUTE_START_X                                                                              0x0e04
#define regCOMPUTE_START_X_BASE_IDX                                                                     0
#define regCOMPUTE_START_Y                                                                              0x0e05
#define regCOMPUTE_START_Y_BASE_IDX                                                                     0
#define regCOMPUTE_START_Z                                                                              0x0e06
#define regCOMPUTE_START_Z_BASE_IDX                                                                     0
#define regCOMPUTE_NUM_THREAD_X                                                                         0x0e07
#define regCOMPUTE_NUM_THREAD_X_BASE_IDX                                                                0
#define regCOMPUTE_NUM_THREAD_Y                                                                         0x0e08
#define regCOMPUTE_NUM_THREAD_Y_BASE_IDX                                                                0
#define regCOMPUTE_NUM_THREAD_Z                                                                         0x0e09
#define regCOMPUTE_NUM_THREAD_Z_BASE_IDX                                                                0
#define regCOMPUTE_PIPELINESTAT_ENABLE                                                                  0x0e0a
#define regCOMPUTE_PIPELINESTAT_ENABLE_BASE_IDX                                                         0
#define regCOMPUTE_PERFCOUNT_ENABLE                                                                     0x0e0b
#define regCOMPUTE_PERFCOUNT_ENABLE_BASE_IDX                                                            0
#define regCOMPUTE_PGM_LO                                                                               0x0e0c
#define regCOMPUTE_PGM_LO_BASE_IDX                                                                      0
#define regCOMPUTE_PGM_HI                                                                               0x0e0d
#define regCOMPUTE_PGM_HI_BASE_IDX                                                                      0
#define regCOMPUTE_DISPATCH_PKT_ADDR_LO                                                                 0x0e0e
#define regCOMPUTE_DISPATCH_PKT_ADDR_LO_BASE_IDX                                                        0
#define regCOMPUTE_DISPATCH_PKT_ADDR_HI                                                                 0x0e0f
#define regCOMPUTE_DISPATCH_PKT_ADDR_HI_BASE_IDX                                                        0
#define regCOMPUTE_DISPATCH_SCRATCH_BASE_LO                                                             0x0e10
#define regCOMPUTE_DISPATCH_SCRATCH_BASE_LO_BASE_IDX                                                    0
#define regCOMPUTE_DISPATCH_SCRATCH_BASE_HI                                                             0x0e11
#define regCOMPUTE_DISPATCH_SCRATCH_BASE_HI_BASE_IDX                                                    0
#define regCOMPUTE_PGM_RSRC1                                                                            0x0e12
#define regCOMPUTE_PGM_RSRC1_BASE_IDX                                                                   0
#define regCOMPUTE_PGM_RSRC2                                                                            0x0e13
#define regCOMPUTE_PGM_RSRC2_BASE_IDX                                                                   0
#define regCOMPUTE_VMID                                                                                 0x0e14
#define regCOMPUTE_VMID_BASE_IDX                                                                        0
#define regCOMPUTE_RESOURCE_LIMITS                                                                      0x0e15
#define regCOMPUTE_RESOURCE_LIMITS_BASE_IDX                                                             0
#define regCOMPUTE_STATIC_THREAD_MGMT_SE0                                                               0x0e16
#define regCOMPUTE_STATIC_THREAD_MGMT_SE0_BASE_IDX                                                      0
#define regCOMPUTE_STATIC_THREAD_MGMT_SE1                                                               0x0e17
#define regCOMPUTE_STATIC_THREAD_MGMT_SE1_BASE_IDX                                                      0
#define regCOMPUTE_TMPRING_SIZE                                                                         0x0e18
#define regCOMPUTE_TMPRING_SIZE_BASE_IDX                                                                0
#define regCOMPUTE_STATIC_THREAD_MGMT_SE2                                                               0x0e19
#define regCOMPUTE_STATIC_THREAD_MGMT_SE2_BASE_IDX                                                      0
#define regCOMPUTE_STATIC_THREAD_MGMT_SE3                                                               0x0e1a
#define regCOMPUTE_STATIC_THREAD_MGMT_SE3_BASE_IDX                                                      0
#define regCOMPUTE_RESTART_X                                                                            0x0e1b
#define regCOMPUTE_RESTART_X_BASE_IDX                                                                   0
#define regCOMPUTE_RESTART_Y                                                                            0x0e1c
#define regCOMPUTE_RESTART_Y_BASE_IDX                                                                   0
#define regCOMPUTE_RESTART_Z                                                                            0x0e1d
#define regCOMPUTE_RESTART_Z_BASE_IDX                                                                   0
#define regCOMPUTE_THREAD_TRACE_ENABLE                                                                  0x0e1e
#define regCOMPUTE_THREAD_TRACE_ENABLE_BASE_IDX                                                         0
#define regCOMPUTE_MISC_RESERVED                                                                        0x0e1f
#define regCOMPUTE_MISC_RESERVED_BASE_IDX                                                               0
#define regCOMPUTE_DISPATCH_ID                                                                          0x0e20
#define regCOMPUTE_DISPATCH_ID_BASE_IDX                                                                 0
#define regCOMPUTE_THREADGROUP_ID                                                                       0x0e21
#define regCOMPUTE_THREADGROUP_ID_BASE_IDX                                                              0
#define regCOMPUTE_RELAUNCH                                                                             0x0e22
#define regCOMPUTE_RELAUNCH_BASE_IDX                                                                    0
#define regCOMPUTE_WAVE_RESTORE_ADDR_LO                                                                 0x0e23
#define regCOMPUTE_WAVE_RESTORE_ADDR_LO_BASE_IDX                                                        0
#define regCOMPUTE_WAVE_RESTORE_ADDR_HI                                                                 0x0e24
#define regCOMPUTE_WAVE_RESTORE_ADDR_HI_BASE_IDX                                                        0
#define regCOMPUTE_TG_CHUNK_SIZE                                                                        0x0e27
#define regCOMPUTE_TG_CHUNK_SIZE_BASE_IDX                                                               0
#define regCOMPUTE_SHADER_CHKSUM                                                                        0x0e2c
#define regCOMPUTE_SHADER_CHKSUM_BASE_IDX                                                               0
#define regCOMPUTE_PGM_RSRC3                                                                            0x0e2d
#define regCOMPUTE_PGM_RSRC3_BASE_IDX                                                                   0
#define regCOMPUTE_USER_DATA_0                                                                          0x0e40
#define regCOMPUTE_USER_DATA_0_BASE_IDX                                                                 0
#define regCOMPUTE_USER_DATA_1                                                                          0x0e41
#define regCOMPUTE_USER_DATA_1_BASE_IDX                                                                 0
#define regCOMPUTE_USER_DATA_2                                                                          0x0e42
#define regCOMPUTE_USER_DATA_2_BASE_IDX                                                                 0
#define regCOMPUTE_USER_DATA_3                                                                          0x0e43
#define regCOMPUTE_USER_DATA_3_BASE_IDX                                                                 0
#define regCOMPUTE_USER_DATA_4                                                                          0x0e44
#define regCOMPUTE_USER_DATA_4_BASE_IDX                                                                 0
#define regCOMPUTE_USER_DATA_5                                                                          0x0e45
#define regCOMPUTE_USER_DATA_5_BASE_IDX                                                                 0
#define regCOMPUTE_USER_DATA_6                                                                          0x0e46
#define regCOMPUTE_USER_DATA_6_BASE_IDX                                                                 0
#define regCOMPUTE_USER_DATA_7                                                                          0x0e47
#define regCOMPUTE_USER_DATA_7_BASE_IDX                                                                 0
#define regCOMPUTE_USER_DATA_8                                                                          0x0e48
#define regCOMPUTE_USER_DATA_8_BASE_IDX                                                                 0
#define regCOMPUTE_USER_DATA_9                                                                          0x0e49
#define regCOMPUTE_USER_DATA_9_BASE_IDX                                                                 0
#define regCOMPUTE_USER_DATA_10                                                                         0x0e4a
#define regCOMPUTE_USER_DATA_10_BASE_IDX                                                                0
#define regCOMPUTE_USER_DATA_11                                                                         0x0e4b
#define regCOMPUTE_USER_DATA_11_BASE_IDX                                                                0
#define regCOMPUTE_USER_DATA_12                                                                         0x0e4c
#define regCOMPUTE_USER_DATA_12_BASE_IDX                                                                0
#define regCOMPUTE_USER_DATA_13                                                                         0x0e4d
#define regCOMPUTE_USER_DATA_13_BASE_IDX                                                                0
#define regCOMPUTE_USER_DATA_14                                                                         0x0e4e
#define regCOMPUTE_USER_DATA_14_BASE_IDX                                                                0
#define regCOMPUTE_USER_DATA_15                                                                         0x0e4f
#define regCOMPUTE_USER_DATA_15_BASE_IDX                                                                0
#define regCOMPUTE_DISPATCH_END                                                                         0x0e7e
#define regCOMPUTE_DISPATCH_END_BASE_IDX                                                                0
#define regCOMPUTE_NOWHERE                                                                              0x0e7f
#define regCOMPUTE_NOWHERE_BASE_IDX                                                                     0


// addressBlock: xcd0_gc_cppdec
// base address: 0xc080
#define regCP_DFY_CNTL                                                                                  0x1020
#define regCP_DFY_CNTL_BASE_IDX                                                                         0
#define regCP_DFY_STAT                                                                                  0x1021
#define regCP_DFY_STAT_BASE_IDX                                                                         0
#define regCP_DFY_ADDR_HI                                                                               0x1022
#define regCP_DFY_ADDR_HI_BASE_IDX                                                                      0
#define regCP_DFY_ADDR_LO                                                                               0x1023
#define regCP_DFY_ADDR_LO_BASE_IDX                                                                      0
#define regCP_DFY_DATA_0                                                                                0x1024
#define regCP_DFY_DATA_0_BASE_IDX                                                                       0
#define regCP_DFY_DATA_1                                                                                0x1025
#define regCP_DFY_DATA_1_BASE_IDX                                                                       0
#define regCP_DFY_DATA_2                                                                                0x1026
#define regCP_DFY_DATA_2_BASE_IDX                                                                       0
#define regCP_DFY_DATA_3                                                                                0x1027
#define regCP_DFY_DATA_3_BASE_IDX                                                                       0
#define regCP_DFY_DATA_4                                                                                0x1028
#define regCP_DFY_DATA_4_BASE_IDX                                                                       0
#define regCP_DFY_DATA_5                                                                                0x1029
#define regCP_DFY_DATA_5_BASE_IDX                                                                       0
#define regCP_DFY_DATA_6                                                                                0x102a
#define regCP_DFY_DATA_6_BASE_IDX                                                                       0
#define regCP_DFY_DATA_7                                                                                0x102b
#define regCP_DFY_DATA_7_BASE_IDX                                                                       0
#define regCP_DFY_DATA_8                                                                                0x102c
#define regCP_DFY_DATA_8_BASE_IDX                                                                       0
#define regCP_DFY_DATA_9                                                                                0x102d
#define regCP_DFY_DATA_9_BASE_IDX                                                                       0
#define regCP_DFY_DATA_10                                                                               0x102e
#define regCP_DFY_DATA_10_BASE_IDX                                                                      0
#define regCP_DFY_DATA_11                                                                               0x102f
#define regCP_DFY_DATA_11_BASE_IDX                                                                      0
#define regCP_DFY_DATA_12                                                                               0x1030
#define regCP_DFY_DATA_12_BASE_IDX                                                                      0
#define regCP_DFY_DATA_13                                                                               0x1031
#define regCP_DFY_DATA_13_BASE_IDX                                                                      0
#define regCP_DFY_DATA_14                                                                               0x1032
#define regCP_DFY_DATA_14_BASE_IDX                                                                      0
#define regCP_DFY_DATA_15                                                                               0x1033
#define regCP_DFY_DATA_15_BASE_IDX                                                                      0
#define regCP_DFY_CMD                                                                                   0x1034
#define regCP_DFY_CMD_BASE_IDX                                                                          0
#define regCP_EOPQ_WAIT_TIME                                                                            0x1035
#define regCP_EOPQ_WAIT_TIME_BASE_IDX                                                                   0
#define regCP_CPC_MGCG_SYNC_CNTL                                                                        0x1036
#define regCP_CPC_MGCG_SYNC_CNTL_BASE_IDX                                                               0
#define regCPC_INT_INFO                                                                                 0x1037
#define regCPC_INT_INFO_BASE_IDX                                                                        0
#define regCP_VIRT_STATUS                                                                               0x1038
#define regCP_VIRT_STATUS_BASE_IDX                                                                      0
#define regCPC_INT_ADDR                                                                                 0x1039
#define regCPC_INT_ADDR_BASE_IDX                                                                        0
#define regCPC_INT_PASID                                                                                0x103a
#define regCPC_INT_PASID_BASE_IDX                                                                       0
#define regCP_GFX_ERROR                                                                                 0x103b
#define regCP_GFX_ERROR_BASE_IDX                                                                        0
#define regCPG_UTCL1_CNTL                                                                               0x103c
#define regCPG_UTCL1_CNTL_BASE_IDX                                                                      0
#define regCPC_UTCL1_CNTL                                                                               0x103d
#define regCPC_UTCL1_CNTL_BASE_IDX                                                                      0
#define regCPF_UTCL1_CNTL                                                                               0x103e
#define regCPF_UTCL1_CNTL_BASE_IDX                                                                      0
#define regCP_AQL_SMM_STATUS                                                                            0x103f
#define regCP_AQL_SMM_STATUS_BASE_IDX                                                                   0
#define regCP_RB0_BASE                                                                                  0x1040
#define regCP_RB0_BASE_BASE_IDX                                                                         0
#define regCP_RB_BASE                                                                                   0x1040
#define regCP_RB_BASE_BASE_IDX                                                                          0
#define regCP_RB0_CNTL                                                                                  0x1041
#define regCP_RB0_CNTL_BASE_IDX                                                                         0
#define regCP_RB_CNTL                                                                                   0x1041
#define regCP_RB_CNTL_BASE_IDX                                                                          0
#define regCP_RB_RPTR_WR                                                                                0x1042
#define regCP_RB_RPTR_WR_BASE_IDX                                                                       0
#define regCP_RB0_RPTR_ADDR                                                                             0x1043
#define regCP_RB0_RPTR_ADDR_BASE_IDX                                                                    0
#define regCP_RB_RPTR_ADDR                                                                              0x1043
#define regCP_RB_RPTR_ADDR_BASE_IDX                                                                     0
#define regCP_RB0_RPTR_ADDR_HI                                                                          0x1044
#define regCP_RB0_RPTR_ADDR_HI_BASE_IDX                                                                 0
#define regCP_RB_RPTR_ADDR_HI                                                                           0x1044
#define regCP_RB_RPTR_ADDR_HI_BASE_IDX                                                                  0
#define regCP_RB0_BUFSZ_MASK                                                                            0x1045
#define regCP_RB0_BUFSZ_MASK_BASE_IDX                                                                   0
#define regCP_RB_BUFSZ_MASK                                                                             0x1045
#define regCP_RB_BUFSZ_MASK_BASE_IDX                                                                    0
#define regCP_RB_WPTR_POLL_ADDR_LO                                                                      0x1046
#define regCP_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                             0
#define regCP_RB_WPTR_POLL_ADDR_HI                                                                      0x1047
#define regCP_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                             0
#define regGC_PRIV_MODE                                                                                 0x1048
#define regGC_PRIV_MODE_BASE_IDX                                                                        0
#define regCP_INT_CNTL                                                                                  0x1049
#define regCP_INT_CNTL_BASE_IDX                                                                         0
#define regCP_INT_STATUS                                                                                0x104a
#define regCP_INT_STATUS_BASE_IDX                                                                       0
#define regCP_DEVICE_ID                                                                                 0x104b
#define regCP_DEVICE_ID_BASE_IDX                                                                        0
#define regCP_ME0_PIPE_PRIORITY_CNTS                                                                    0x104c
#define regCP_ME0_PIPE_PRIORITY_CNTS_BASE_IDX                                                           0
#define regCP_RING_PRIORITY_CNTS                                                                        0x104c
#define regCP_RING_PRIORITY_CNTS_BASE_IDX                                                               0
#define regCP_ME0_PIPE0_PRIORITY                                                                        0x104d
#define regCP_ME0_PIPE0_PRIORITY_BASE_IDX                                                               0
#define regCP_RING0_PRIORITY                                                                            0x104d
#define regCP_RING0_PRIORITY_BASE_IDX                                                                   0
#define regCP_ME0_PIPE1_PRIORITY                                                                        0x104e
#define regCP_ME0_PIPE1_PRIORITY_BASE_IDX                                                               0
#define regCP_RING1_PRIORITY                                                                            0x104e
#define regCP_RING1_PRIORITY_BASE_IDX                                                                   0
#define regCP_ME0_PIPE2_PRIORITY                                                                        0x104f
#define regCP_ME0_PIPE2_PRIORITY_BASE_IDX                                                               0
#define regCP_RING2_PRIORITY                                                                            0x104f
#define regCP_RING2_PRIORITY_BASE_IDX                                                                   0
#define regCP_FATAL_ERROR                                                                               0x1050
#define regCP_FATAL_ERROR_BASE_IDX                                                                      0
#define regCP_RB_VMID                                                                                   0x1051
#define regCP_RB_VMID_BASE_IDX                                                                          0
#define regCP_ME0_PIPE0_VMID                                                                            0x1052
#define regCP_ME0_PIPE0_VMID_BASE_IDX                                                                   0
#define regCP_ME0_PIPE1_VMID                                                                            0x1053
#define regCP_ME0_PIPE1_VMID_BASE_IDX                                                                   0
#define regCP_RB0_WPTR                                                                                  0x1054
#define regCP_RB0_WPTR_BASE_IDX                                                                         0
#define regCP_RB_WPTR                                                                                   0x1054
#define regCP_RB_WPTR_BASE_IDX                                                                          0
#define regCP_RB0_WPTR_HI                                                                               0x1055
#define regCP_RB0_WPTR_HI_BASE_IDX                                                                      0
#define regCP_RB_WPTR_HI                                                                                0x1055
#define regCP_RB_WPTR_HI_BASE_IDX                                                                       0
#define regCP_RB1_WPTR                                                                                  0x1056
#define regCP_RB1_WPTR_BASE_IDX                                                                         0
#define regCP_RB1_WPTR_HI                                                                               0x1057
#define regCP_RB1_WPTR_HI_BASE_IDX                                                                      0
#define regCP_RB2_WPTR                                                                                  0x1058
#define regCP_RB2_WPTR_BASE_IDX                                                                         0
#define regCP_RB_DOORBELL_CONTROL                                                                       0x1059
#define regCP_RB_DOORBELL_CONTROL_BASE_IDX                                                              0
#define regCP_RB_DOORBELL_RANGE_LOWER                                                                   0x105a
#define regCP_RB_DOORBELL_RANGE_LOWER_BASE_IDX                                                          0
#define regCP_RB_DOORBELL_RANGE_UPPER                                                                   0x105b
#define regCP_RB_DOORBELL_RANGE_UPPER_BASE_IDX                                                          0
#define regCP_MEC_DOORBELL_RANGE_LOWER                                                                  0x105c
#define regCP_MEC_DOORBELL_RANGE_LOWER_BASE_IDX                                                         0
#define regCP_MEC_DOORBELL_RANGE_UPPER                                                                  0x105d
#define regCP_MEC_DOORBELL_RANGE_UPPER_BASE_IDX                                                         0
#define regCPG_UTCL1_ERROR                                                                              0x105e
#define regCPG_UTCL1_ERROR_BASE_IDX                                                                     0
#define regCPC_UTCL1_ERROR                                                                              0x105f
#define regCPC_UTCL1_ERROR_BASE_IDX                                                                     0
#define regCP_RB1_BASE                                                                                  0x1060
#define regCP_RB1_BASE_BASE_IDX                                                                         0
#define regCP_RB1_CNTL                                                                                  0x1061
#define regCP_RB1_CNTL_BASE_IDX                                                                         0
#define regCP_RB1_RPTR_ADDR                                                                             0x1062
#define regCP_RB1_RPTR_ADDR_BASE_IDX                                                                    0
#define regCP_RB1_RPTR_ADDR_HI                                                                          0x1063
#define regCP_RB1_RPTR_ADDR_HI_BASE_IDX                                                                 0
#define regCP_RB2_BASE                                                                                  0x1065
#define regCP_RB2_BASE_BASE_IDX                                                                         0
#define regCP_RB2_CNTL                                                                                  0x1066
#define regCP_RB2_CNTL_BASE_IDX                                                                         0
#define regCP_RB2_RPTR_ADDR                                                                             0x1067
#define regCP_RB2_RPTR_ADDR_BASE_IDX                                                                    0
#define regCP_RB2_RPTR_ADDR_HI                                                                          0x1068
#define regCP_RB2_RPTR_ADDR_HI_BASE_IDX                                                                 0
#define regCP_RB0_ACTIVE                                                                                0x1069
#define regCP_RB0_ACTIVE_BASE_IDX                                                                       0
#define regCP_RB_ACTIVE                                                                                 0x1069
#define regCP_RB_ACTIVE_BASE_IDX                                                                        0
#define regCP_INT_CNTL_RING0                                                                            0x106a
#define regCP_INT_CNTL_RING0_BASE_IDX                                                                   0
#define regCP_INT_CNTL_RING1                                                                            0x106b
#define regCP_INT_CNTL_RING1_BASE_IDX                                                                   0
#define regCP_INT_CNTL_RING2                                                                            0x106c
#define regCP_INT_CNTL_RING2_BASE_IDX                                                                   0
#define regCP_INT_STATUS_RING0                                                                          0x106d
#define regCP_INT_STATUS_RING0_BASE_IDX                                                                 0
#define regCP_INT_STATUS_RING1                                                                          0x106e
#define regCP_INT_STATUS_RING1_BASE_IDX                                                                 0
#define regCP_INT_STATUS_RING2                                                                          0x106f
#define regCP_INT_STATUS_RING2_BASE_IDX                                                                 0
#define regCP_ME_F32_INTERRUPT                                                                          0x1073
#define regCP_ME_F32_INTERRUPT_BASE_IDX                                                                 0
#define regCP_PFP_F32_INTERRUPT                                                                         0x1074
#define regCP_PFP_F32_INTERRUPT_BASE_IDX                                                                0
#define regCP_CE_F32_INTERRUPT                                                                          0x1075
#define regCP_CE_F32_INTERRUPT_BASE_IDX                                                                 0
#define regCP_MEC1_F32_INTERRUPT                                                                        0x1076
#define regCP_MEC1_F32_INTERRUPT_BASE_IDX                                                               0
#define regCP_MEC2_F32_INTERRUPT                                                                        0x1077
#define regCP_MEC2_F32_INTERRUPT_BASE_IDX                                                               0
#define regCP_PWR_CNTL                                                                                  0x1078
#define regCP_PWR_CNTL_BASE_IDX                                                                         0
#define regCP_MEM_SLP_CNTL                                                                              0x1079
#define regCP_MEM_SLP_CNTL_BASE_IDX                                                                     0
#define regCP_ECC_DMA_FIRST_OCCURRENCE                                                                  0x107a
#define regCP_ECC_DMA_FIRST_OCCURRENCE_BASE_IDX                                                         0
#define regCP_ECC_FIRSTOCCURRENCE                                                                       0x107a
#define regCP_ECC_FIRSTOCCURRENCE_BASE_IDX                                                              0
#define regCP_ECC_FIRSTOCCURRENCE_RING0                                                                 0x107b
#define regCP_ECC_FIRSTOCCURRENCE_RING0_BASE_IDX                                                        0
#define regCP_ECC_FIRSTOCCURRENCE_RING1                                                                 0x107c
#define regCP_ECC_FIRSTOCCURRENCE_RING1_BASE_IDX                                                        0
#define regCP_ECC_FIRSTOCCURRENCE_RING2                                                                 0x107d
#define regCP_ECC_FIRSTOCCURRENCE_RING2_BASE_IDX                                                        0
#define regGB_EDC_MODE                                                                                  0x107e
#define regGB_EDC_MODE_BASE_IDX                                                                         0
#define regCP_DEBUG                                                                                     0x107f
#define regCP_DEBUG_BASE_IDX                                                                            0
#define regCP_CPF_DEBUG                                                                                 0x1080
#define regCP_CPF_DEBUG_BASE_IDX                                                                        0
#define regCP_CPC_DEBUG                                                                                 0x1081
#define regCP_CPC_DEBUG_BASE_IDX                                                                        0
#define regCP_CPC_DEBUG_2                                                                               0x1082
#define regCP_CPC_DEBUG_2_BASE_IDX                                                                      0
#define regCP_PQ_WPTR_POLL_CNTL                                                                         0x1083
#define regCP_PQ_WPTR_POLL_CNTL_BASE_IDX                                                                0
#define regCP_PQ_WPTR_POLL_CNTL1                                                                        0x1084
#define regCP_PQ_WPTR_POLL_CNTL1_BASE_IDX                                                               0
#define regCP_ME1_PIPE0_INT_CNTL                                                                        0x1085
#define regCP_ME1_PIPE0_INT_CNTL_BASE_IDX                                                               0
#define regCP_ME1_PIPE1_INT_CNTL                                                                        0x1086
#define regCP_ME1_PIPE1_INT_CNTL_BASE_IDX                                                               0
#define regCP_ME1_PIPE2_INT_CNTL                                                                        0x1087
#define regCP_ME1_PIPE2_INT_CNTL_BASE_IDX                                                               0
#define regCP_ME1_PIPE3_INT_CNTL                                                                        0x1088
#define regCP_ME1_PIPE3_INT_CNTL_BASE_IDX                                                               0
#define regCP_ME2_PIPE0_INT_CNTL                                                                        0x1089
#define regCP_ME2_PIPE0_INT_CNTL_BASE_IDX                                                               0
#define regCP_ME2_PIPE1_INT_CNTL                                                                        0x108a
#define regCP_ME2_PIPE1_INT_CNTL_BASE_IDX                                                               0
#define regCP_ME2_PIPE2_INT_CNTL                                                                        0x108b
#define regCP_ME2_PIPE2_INT_CNTL_BASE_IDX                                                               0
#define regCP_ME2_PIPE3_INT_CNTL                                                                        0x108c
#define regCP_ME2_PIPE3_INT_CNTL_BASE_IDX                                                               0
#define regCP_ME1_PIPE0_INT_STATUS                                                                      0x108d
#define regCP_ME1_PIPE0_INT_STATUS_BASE_IDX                                                             0
#define regCP_ME1_PIPE1_INT_STATUS                                                                      0x108e
#define regCP_ME1_PIPE1_INT_STATUS_BASE_IDX                                                             0
#define regCP_ME1_PIPE2_INT_STATUS                                                                      0x108f
#define regCP_ME1_PIPE2_INT_STATUS_BASE_IDX                                                             0
#define regCP_ME1_PIPE3_INT_STATUS                                                                      0x1090
#define regCP_ME1_PIPE3_INT_STATUS_BASE_IDX                                                             0
#define regCP_ME2_PIPE0_INT_STATUS                                                                      0x1091
#define regCP_ME2_PIPE0_INT_STATUS_BASE_IDX                                                             0
#define regCP_ME2_PIPE1_INT_STATUS                                                                      0x1092
#define regCP_ME2_PIPE1_INT_STATUS_BASE_IDX                                                             0
#define regCP_ME2_PIPE2_INT_STATUS                                                                      0x1093
#define regCP_ME2_PIPE2_INT_STATUS_BASE_IDX                                                             0
#define regCP_ME2_PIPE3_INT_STATUS                                                                      0x1094
#define regCP_ME2_PIPE3_INT_STATUS_BASE_IDX                                                             0
#define regCP_ME1_INT_STAT_DEBUG                                                                        0x1095
#define regCP_ME1_INT_STAT_DEBUG_BASE_IDX                                                               0
#define regCP_ME2_INT_STAT_DEBUG                                                                        0x1096
#define regCP_ME2_INT_STAT_DEBUG_BASE_IDX                                                               0
#define regCC_GC_EDC_CONFIG                                                                             0x1098
#define regCC_GC_EDC_CONFIG_BASE_IDX                                                                    0
#define regCP_ME1_PIPE_PRIORITY_CNTS                                                                    0x1099
#define regCP_ME1_PIPE_PRIORITY_CNTS_BASE_IDX                                                           0
#define regCP_ME1_PIPE0_PRIORITY                                                                        0x109a
#define regCP_ME1_PIPE0_PRIORITY_BASE_IDX                                                               0
#define regCP_ME1_PIPE1_PRIORITY                                                                        0x109b
#define regCP_ME1_PIPE1_PRIORITY_BASE_IDX                                                               0
#define regCP_ME1_PIPE2_PRIORITY                                                                        0x109c
#define regCP_ME1_PIPE2_PRIORITY_BASE_IDX                                                               0
#define regCP_ME1_PIPE3_PRIORITY                                                                        0x109d
#define regCP_ME1_PIPE3_PRIORITY_BASE_IDX                                                               0
#define regCP_ME2_PIPE_PRIORITY_CNTS                                                                    0x109e
#define regCP_ME2_PIPE_PRIORITY_CNTS_BASE_IDX                                                           0
#define regCP_ME2_PIPE0_PRIORITY                                                                        0x109f
#define regCP_ME2_PIPE0_PRIORITY_BASE_IDX                                                               0
#define regCP_ME2_PIPE1_PRIORITY                                                                        0x10a0
#define regCP_ME2_PIPE1_PRIORITY_BASE_IDX                                                               0
#define regCP_ME2_PIPE2_PRIORITY                                                                        0x10a1
#define regCP_ME2_PIPE2_PRIORITY_BASE_IDX                                                               0
#define regCP_ME2_PIPE3_PRIORITY                                                                        0x10a2
#define regCP_ME2_PIPE3_PRIORITY_BASE_IDX                                                               0
#define regCP_CE_PRGRM_CNTR_START                                                                       0x10a3
#define regCP_CE_PRGRM_CNTR_START_BASE_IDX                                                              0
#define regCP_PFP_PRGRM_CNTR_START                                                                      0x10a4
#define regCP_PFP_PRGRM_CNTR_START_BASE_IDX                                                             0
#define regCP_ME_PRGRM_CNTR_START                                                                       0x10a5
#define regCP_ME_PRGRM_CNTR_START_BASE_IDX                                                              0
#define regCP_MEC1_PRGRM_CNTR_START                                                                     0x10a6
#define regCP_MEC1_PRGRM_CNTR_START_BASE_IDX                                                            0
#define regCP_MEC2_PRGRM_CNTR_START                                                                     0x10a7
#define regCP_MEC2_PRGRM_CNTR_START_BASE_IDX                                                            0
#define regCP_CE_INTR_ROUTINE_START                                                                     0x10a8
#define regCP_CE_INTR_ROUTINE_START_BASE_IDX                                                            0
#define regCP_PFP_INTR_ROUTINE_START                                                                    0x10a9
#define regCP_PFP_INTR_ROUTINE_START_BASE_IDX                                                           0
#define regCP_ME_INTR_ROUTINE_START                                                                     0x10aa
#define regCP_ME_INTR_ROUTINE_START_BASE_IDX                                                            0
#define regCP_MEC1_INTR_ROUTINE_START                                                                   0x10ab
#define regCP_MEC1_INTR_ROUTINE_START_BASE_IDX                                                          0
#define regCP_MEC2_INTR_ROUTINE_START                                                                   0x10ac
#define regCP_MEC2_INTR_ROUTINE_START_BASE_IDX                                                          0
#define regCP_CONTEXT_CNTL                                                                              0x10ad
#define regCP_CONTEXT_CNTL_BASE_IDX                                                                     0
#define regCP_MAX_CONTEXT                                                                               0x10ae
#define regCP_MAX_CONTEXT_BASE_IDX                                                                      0
#define regCP_IQ_WAIT_TIME1                                                                             0x10af
#define regCP_IQ_WAIT_TIME1_BASE_IDX                                                                    0
#define regCP_IQ_WAIT_TIME2                                                                             0x10b0
#define regCP_IQ_WAIT_TIME2_BASE_IDX                                                                    0
#define regCP_RB0_BASE_HI                                                                               0x10b1
#define regCP_RB0_BASE_HI_BASE_IDX                                                                      0
#define regCP_RB1_BASE_HI                                                                               0x10b2
#define regCP_RB1_BASE_HI_BASE_IDX                                                                      0
#define regCP_VMID_RESET                                                                                0x10b3
#define regCP_VMID_RESET_BASE_IDX                                                                       0
#define regCPC_INT_CNTL                                                                                 0x10b4
#define regCPC_INT_CNTL_BASE_IDX                                                                        0
#define regCPC_INT_STATUS                                                                               0x10b5
#define regCPC_INT_STATUS_BASE_IDX                                                                      0
#define regCP_VMID_PREEMPT                                                                              0x10b6
#define regCP_VMID_PREEMPT_BASE_IDX                                                                     0
#define regCPC_INT_CNTX_ID                                                                              0x10b7
#define regCPC_INT_CNTX_ID_BASE_IDX                                                                     0
#define regCP_PQ_STATUS                                                                                 0x10b8
#define regCP_PQ_STATUS_BASE_IDX                                                                        0
#define regCP_CPC_IC_BASE_LO                                                                            0x10b9
#define regCP_CPC_IC_BASE_LO_BASE_IDX                                                                   0
#define regCP_CPC_IC_BASE_HI                                                                            0x10ba
#define regCP_CPC_IC_BASE_HI_BASE_IDX                                                                   0
#define regCP_CPC_IC_BASE_CNTL                                                                          0x10bb
#define regCP_CPC_IC_BASE_CNTL_BASE_IDX                                                                 0
#define regCP_CPC_IC_OP_CNTL                                                                            0x10bc
#define regCP_CPC_IC_OP_CNTL_BASE_IDX                                                                   0
#define regCP_MEC1_F32_INT_DIS                                                                          0x10bd
#define regCP_MEC1_F32_INT_DIS_BASE_IDX                                                                 0
#define regCP_MEC2_F32_INT_DIS                                                                          0x10be
#define regCP_MEC2_F32_INT_DIS_BASE_IDX                                                                 0
#define regCP_VMID_STATUS                                                                               0x10bf
#define regCP_VMID_STATUS_BASE_IDX                                                                      0
#define regCPC_UE_ERR_STATUS_LO                                                                         0x10e0
#define regCPC_UE_ERR_STATUS_LO_BASE_IDX                                                                0
#define regCPC_UE_ERR_STATUS_HI                                                                         0x10e1
#define regCPC_UE_ERR_STATUS_HI_BASE_IDX                                                                0
#define regCPC_CE_ERR_STATUS_LO                                                                         0x10e2
#define regCPC_CE_ERR_STATUS_LO_BASE_IDX                                                                0
#define regCPC_CE_ERR_STATUS_HI                                                                         0x10e3
#define regCPC_CE_ERR_STATUS_HI_BASE_IDX                                                                0
#define regCPF_UE_ERR_STATUS_LO                                                                         0x10e4
#define regCPF_UE_ERR_STATUS_LO_BASE_IDX                                                                0
#define regCPF_UE_ERR_STATUS_HI                                                                         0x10e5
#define regCPF_UE_ERR_STATUS_HI_BASE_IDX                                                                0
#define regCPF_CE_ERR_STATUS_LO                                                                         0x10e6
#define regCPF_CE_ERR_STATUS_LO_BASE_IDX                                                                0
#define regCPF_CE_ERR_STATUS_HI                                                                         0x10e7
#define regCPF_CE_ERR_STATUS_HI_BASE_IDX                                                                0
#define regCPG_UE_ERR_STATUS_LO                                                                         0x10e8
#define regCPG_UE_ERR_STATUS_LO_BASE_IDX                                                                0
#define regCPG_UE_ERR_STATUS_HI                                                                         0x10e9
#define regCPG_UE_ERR_STATUS_HI_BASE_IDX                                                                0
#define regCPG_CE_ERR_STATUS_LO                                                                         0x10ea
#define regCPG_CE_ERR_STATUS_LO_BASE_IDX                                                                0
#define regCPG_CE_ERR_STATUS_HI                                                                         0x10eb
#define regCPG_CE_ERR_STATUS_HI_BASE_IDX                                                                0


// addressBlock: xcd0_gc_cppdec2
// base address: 0xc600
#define regCP_RB_DOORBELL_CONTROL_SCH_0                                                                 0x1180
#define regCP_RB_DOORBELL_CONTROL_SCH_0_BASE_IDX                                                        0
#define regCP_RB_DOORBELL_CONTROL_SCH_1                                                                 0x1181
#define regCP_RB_DOORBELL_CONTROL_SCH_1_BASE_IDX                                                        0
#define regCP_RB_DOORBELL_CONTROL_SCH_2                                                                 0x1182
#define regCP_RB_DOORBELL_CONTROL_SCH_2_BASE_IDX                                                        0
#define regCP_RB_DOORBELL_CONTROL_SCH_3                                                                 0x1183
#define regCP_RB_DOORBELL_CONTROL_SCH_3_BASE_IDX                                                        0
#define regCP_RB_DOORBELL_CONTROL_SCH_4                                                                 0x1184
#define regCP_RB_DOORBELL_CONTROL_SCH_4_BASE_IDX                                                        0
#define regCP_RB_DOORBELL_CONTROL_SCH_5                                                                 0x1185
#define regCP_RB_DOORBELL_CONTROL_SCH_5_BASE_IDX                                                        0
#define regCP_RB_DOORBELL_CONTROL_SCH_6                                                                 0x1186
#define regCP_RB_DOORBELL_CONTROL_SCH_6_BASE_IDX                                                        0
#define regCP_RB_DOORBELL_CONTROL_SCH_7                                                                 0x1187
#define regCP_RB_DOORBELL_CONTROL_SCH_7_BASE_IDX                                                        0
#define regCP_RB_DOORBELL_CLEAR                                                                         0x1188
#define regCP_RB_DOORBELL_CLEAR_BASE_IDX                                                                0
#define regCP_CPF_DSM_CNTL                                                                              0x1194
#define regCP_CPF_DSM_CNTL_BASE_IDX                                                                     0
#define regCP_CPG_DSM_CNTL                                                                              0x1195
#define regCP_CPG_DSM_CNTL_BASE_IDX                                                                     0
#define regCP_CPC_DSM_CNTL                                                                              0x1196
#define regCP_CPC_DSM_CNTL_BASE_IDX                                                                     0
#define regCP_CPF_DSM_CNTL2                                                                             0x1197
#define regCP_CPF_DSM_CNTL2_BASE_IDX                                                                    0
#define regCP_CPG_DSM_CNTL2                                                                             0x1198
#define regCP_CPG_DSM_CNTL2_BASE_IDX                                                                    0
#define regCP_CPC_DSM_CNTL2                                                                             0x1199
#define regCP_CPC_DSM_CNTL2_BASE_IDX                                                                    0
#define regCP_CPF_DSM_CNTL2A                                                                            0x119a
#define regCP_CPF_DSM_CNTL2A_BASE_IDX                                                                   0
#define regCP_CPG_DSM_CNTL2A                                                                            0x119b
#define regCP_CPG_DSM_CNTL2A_BASE_IDX                                                                   0
#define regCP_CPC_DSM_CNTL2A                                                                            0x119c
#define regCP_CPC_DSM_CNTL2A_BASE_IDX                                                                   0
#define regCP_EDC_FUE_CNTL                                                                              0x119d
#define regCP_EDC_FUE_CNTL_BASE_IDX                                                                     0
#define regCP_GFX_MQD_CONTROL                                                                           0x11a0
#define regCP_GFX_MQD_CONTROL_BASE_IDX                                                                  0
#define regCP_GFX_MQD_BASE_ADDR                                                                         0x11a1
#define regCP_GFX_MQD_BASE_ADDR_BASE_IDX                                                                0
#define regCP_GFX_MQD_BASE_ADDR_HI                                                                      0x11a2
#define regCP_GFX_MQD_BASE_ADDR_HI_BASE_IDX                                                             0
#define regCP_RB_STATUS                                                                                 0x11a3
#define regCP_RB_STATUS_BASE_IDX                                                                        0
#define regCPG_UTCL1_STATUS                                                                             0x11b4
#define regCPG_UTCL1_STATUS_BASE_IDX                                                                    0
#define regCPC_UTCL1_STATUS                                                                             0x11b5
#define regCPC_UTCL1_STATUS_BASE_IDX                                                                    0
#define regCPF_UTCL1_STATUS                                                                             0x11b6
#define regCPF_UTCL1_STATUS_BASE_IDX                                                                    0
#define regCP_SD_CNTL                                                                                   0x11b7
#define regCP_SD_CNTL_BASE_IDX                                                                          0
#define regCP_SOFT_RESET_CNTL                                                                           0x11b9
#define regCP_SOFT_RESET_CNTL_BASE_IDX                                                                  0
#define regCP_CPC_GFX_CNTL                                                                              0x11ba
#define regCP_CPC_GFX_CNTL_BASE_IDX                                                                     0


// addressBlock: xcd0_gc_spipdec
// base address: 0xc700
#define regSPI_ARB_PRIORITY                                                                             0x11c0
#define regSPI_ARB_PRIORITY_BASE_IDX                                                                    0
#define regSPI_ARB_CYCLES_0                                                                             0x11c1
#define regSPI_ARB_CYCLES_0_BASE_IDX                                                                    0
#define regSPI_ARB_CYCLES_1                                                                             0x11c2
#define regSPI_ARB_CYCLES_1_BASE_IDX                                                                    0
#define regSPI_CDBG_SYS_GFX                                                                             0x11c3
#define regSPI_CDBG_SYS_GFX_BASE_IDX                                                                    0
#define regSPI_CDBG_SYS_HP3D                                                                            0x11c4
#define regSPI_CDBG_SYS_HP3D_BASE_IDX                                                                   0
#define regSPI_CDBG_SYS_CS0                                                                             0x11c5
#define regSPI_CDBG_SYS_CS0_BASE_IDX                                                                    0
#define regSPI_CDBG_SYS_CS1                                                                             0x11c6
#define regSPI_CDBG_SYS_CS1_BASE_IDX                                                                    0
#define regSPI_WCL_PIPE_PERCENT_GFX                                                                     0x11c7
#define regSPI_WCL_PIPE_PERCENT_GFX_BASE_IDX                                                            0
#define regSPI_WCL_PIPE_PERCENT_HP3D                                                                    0x11c8
#define regSPI_WCL_PIPE_PERCENT_HP3D_BASE_IDX                                                           0
#define regSPI_WCL_PIPE_PERCENT_CS0                                                                     0x11c9
#define regSPI_WCL_PIPE_PERCENT_CS0_BASE_IDX                                                            0
#define regSPI_WCL_PIPE_PERCENT_CS1                                                                     0x11ca
#define regSPI_WCL_PIPE_PERCENT_CS1_BASE_IDX                                                            0
#define regSPI_WCL_PIPE_PERCENT_CS2                                                                     0x11cb
#define regSPI_WCL_PIPE_PERCENT_CS2_BASE_IDX                                                            0
#define regSPI_WCL_PIPE_PERCENT_CS3                                                                     0x11cc
#define regSPI_WCL_PIPE_PERCENT_CS3_BASE_IDX                                                            0
#define regSPI_WCL_PIPE_PERCENT_CS4                                                                     0x11cd
#define regSPI_WCL_PIPE_PERCENT_CS4_BASE_IDX                                                            0
#define regSPI_WCL_PIPE_PERCENT_CS5                                                                     0x11ce
#define regSPI_WCL_PIPE_PERCENT_CS5_BASE_IDX                                                            0
#define regSPI_WCL_PIPE_PERCENT_CS6                                                                     0x11cf
#define regSPI_WCL_PIPE_PERCENT_CS6_BASE_IDX                                                            0
#define regSPI_WCL_PIPE_PERCENT_CS7                                                                     0x11d0
#define regSPI_WCL_PIPE_PERCENT_CS7_BASE_IDX                                                            0
#define regSPI_GDBG_WAVE_CNTL                                                                           0x11d1
#define regSPI_GDBG_WAVE_CNTL_BASE_IDX                                                                  0
#define regSPI_GDBG_TRAP_CONFIG                                                                         0x11d2
#define regSPI_GDBG_TRAP_CONFIG_BASE_IDX                                                                0
#define regSPI_GDBG_PER_VMID_CNTL                                                                       0x11d3
#define regSPI_GDBG_PER_VMID_CNTL_BASE_IDX                                                              0
#define regSPI_GDBG_WAVE_CNTL3                                                                          0x11d5
#define regSPI_GDBG_WAVE_CNTL3_BASE_IDX                                                                 0
#define regSPI_SCRATCH_ADDR_CHECK                                                                       0x11d8
#define regSPI_SCRATCH_ADDR_CHECK_BASE_IDX                                                              0
#define regSPI_SCRATCH_ADDR_STATUS                                                                      0x11d9
#define regSPI_SCRATCH_ADDR_STATUS_BASE_IDX                                                             0
#define regSPI_RESET_DEBUG                                                                              0x11da
#define regSPI_RESET_DEBUG_BASE_IDX                                                                     0
#define regSPI_COMPUTE_QUEUE_RESET                                                                      0x11db
#define regSPI_COMPUTE_QUEUE_RESET_BASE_IDX                                                             0
#define regSPI_RESOURCE_RESERVE_CU_0                                                                    0x11dc
#define regSPI_RESOURCE_RESERVE_CU_0_BASE_IDX                                                           0
#define regSPI_RESOURCE_RESERVE_CU_1                                                                    0x11dd
#define regSPI_RESOURCE_RESERVE_CU_1_BASE_IDX                                                           0
#define regSPI_RESOURCE_RESERVE_CU_2                                                                    0x11de
#define regSPI_RESOURCE_RESERVE_CU_2_BASE_IDX                                                           0
#define regSPI_RESOURCE_RESERVE_CU_3                                                                    0x11df
#define regSPI_RESOURCE_RESERVE_CU_3_BASE_IDX                                                           0
#define regSPI_RESOURCE_RESERVE_CU_4                                                                    0x11e0
#define regSPI_RESOURCE_RESERVE_CU_4_BASE_IDX                                                           0
#define regSPI_RESOURCE_RESERVE_CU_5                                                                    0x11e1
#define regSPI_RESOURCE_RESERVE_CU_5_BASE_IDX                                                           0
#define regSPI_RESOURCE_RESERVE_CU_6                                                                    0x11e2
#define regSPI_RESOURCE_RESERVE_CU_6_BASE_IDX                                                           0
#define regSPI_RESOURCE_RESERVE_CU_7                                                                    0x11e3
#define regSPI_RESOURCE_RESERVE_CU_7_BASE_IDX                                                           0
#define regSPI_RESOURCE_RESERVE_CU_8                                                                    0x11e4
#define regSPI_RESOURCE_RESERVE_CU_8_BASE_IDX                                                           0
#define regSPI_RESOURCE_RESERVE_CU_9                                                                    0x11e5
#define regSPI_RESOURCE_RESERVE_CU_9_BASE_IDX                                                           0
#define regSPI_RESOURCE_RESERVE_EN_CU_0                                                                 0x11e6
#define regSPI_RESOURCE_RESERVE_EN_CU_0_BASE_IDX                                                        0
#define regSPI_RESOURCE_RESERVE_EN_CU_1                                                                 0x11e7
#define regSPI_RESOURCE_RESERVE_EN_CU_1_BASE_IDX                                                        0
#define regSPI_RESOURCE_RESERVE_EN_CU_2                                                                 0x11e8
#define regSPI_RESOURCE_RESERVE_EN_CU_2_BASE_IDX                                                        0
#define regSPI_RESOURCE_RESERVE_EN_CU_3                                                                 0x11e9
#define regSPI_RESOURCE_RESERVE_EN_CU_3_BASE_IDX                                                        0
#define regSPI_RESOURCE_RESERVE_EN_CU_4                                                                 0x11ea
#define regSPI_RESOURCE_RESERVE_EN_CU_4_BASE_IDX                                                        0
#define regSPI_RESOURCE_RESERVE_EN_CU_5                                                                 0x11eb
#define regSPI_RESOURCE_RESERVE_EN_CU_5_BASE_IDX                                                        0
#define regSPI_RESOURCE_RESERVE_EN_CU_6                                                                 0x11ec
#define regSPI_RESOURCE_RESERVE_EN_CU_6_BASE_IDX                                                        0
#define regSPI_RESOURCE_RESERVE_EN_CU_7                                                                 0x11ed
#define regSPI_RESOURCE_RESERVE_EN_CU_7_BASE_IDX                                                        0
#define regSPI_RESOURCE_RESERVE_EN_CU_8                                                                 0x11ee
#define regSPI_RESOURCE_RESERVE_EN_CU_8_BASE_IDX                                                        0
#define regSPI_RESOURCE_RESERVE_EN_CU_9                                                                 0x11ef
#define regSPI_RESOURCE_RESERVE_EN_CU_9_BASE_IDX                                                        0
#define regSPI_RESOURCE_RESERVE_CU_10                                                                   0x11f0
#define regSPI_RESOURCE_RESERVE_CU_10_BASE_IDX                                                          0
#define regSPI_RESOURCE_RESERVE_CU_11                                                                   0x11f1
#define regSPI_RESOURCE_RESERVE_CU_11_BASE_IDX                                                          0
#define regSPI_RESOURCE_RESERVE_EN_CU_10                                                                0x11f2
#define regSPI_RESOURCE_RESERVE_EN_CU_10_BASE_IDX                                                       0
#define regSPI_RESOURCE_RESERVE_EN_CU_11                                                                0x11f3
#define regSPI_RESOURCE_RESERVE_EN_CU_11_BASE_IDX                                                       0
#define regSPI_RESOURCE_RESERVE_CU_12                                                                   0x11f4
#define regSPI_RESOURCE_RESERVE_CU_12_BASE_IDX                                                          0
#define regSPI_RESOURCE_RESERVE_CU_13                                                                   0x11f5
#define regSPI_RESOURCE_RESERVE_CU_13_BASE_IDX                                                          0
#define regSPI_RESOURCE_RESERVE_CU_14                                                                   0x11f6
#define regSPI_RESOURCE_RESERVE_CU_14_BASE_IDX                                                          0
#define regSPI_RESOURCE_RESERVE_CU_15                                                                   0x11f7
#define regSPI_RESOURCE_RESERVE_CU_15_BASE_IDX                                                          0
#define regSPI_RESOURCE_RESERVE_EN_CU_12                                                                0x11f8
#define regSPI_RESOURCE_RESERVE_EN_CU_12_BASE_IDX                                                       0
#define regSPI_RESOURCE_RESERVE_EN_CU_13                                                                0x11f9
#define regSPI_RESOURCE_RESERVE_EN_CU_13_BASE_IDX                                                       0
#define regSPI_RESOURCE_RESERVE_EN_CU_14                                                                0x11fa
#define regSPI_RESOURCE_RESERVE_EN_CU_14_BASE_IDX                                                       0
#define regSPI_RESOURCE_RESERVE_EN_CU_15                                                                0x11fb
#define regSPI_RESOURCE_RESERVE_EN_CU_15_BASE_IDX                                                       0
#define regSPI_COMPUTE_WF_CTX_SAVE                                                                      0x11fc
#define regSPI_COMPUTE_WF_CTX_SAVE_BASE_IDX                                                             0
#define regSPI_ARB_CNTL_0                                                                               0x11fd
#define regSPI_ARB_CNTL_0_BASE_IDX                                                                      0


// addressBlock: xcd0_gc_cpphqddec
// base address: 0xc800
#define regCP_HQD_GFX_CONTROL                                                                           0x123e
#define regCP_HQD_GFX_CONTROL_BASE_IDX                                                                  0
#define regCP_HQD_GFX_STATUS                                                                            0x123f
#define regCP_HQD_GFX_STATUS_BASE_IDX                                                                   0
#define regCP_HPD_ROQ_OFFSETS                                                                           0x1240
#define regCP_HPD_ROQ_OFFSETS_BASE_IDX                                                                  0
#define regCP_HPD_STATUS0                                                                               0x1241
#define regCP_HPD_STATUS0_BASE_IDX                                                                      0
#define regCP_HPD_UTCL1_CNTL                                                                            0x1242
#define regCP_HPD_UTCL1_CNTL_BASE_IDX                                                                   0
#define regCP_HPD_UTCL1_ERROR                                                                           0x1243
#define regCP_HPD_UTCL1_ERROR_BASE_IDX                                                                  0
#define regCP_HPD_UTCL1_ERROR_ADDR                                                                      0x1244
#define regCP_HPD_UTCL1_ERROR_ADDR_BASE_IDX                                                             0
#define regCP_MQD_BASE_ADDR                                                                             0x1245
#define regCP_MQD_BASE_ADDR_BASE_IDX                                                                    0
#define regCP_MQD_BASE_ADDR_HI                                                                          0x1246
#define regCP_MQD_BASE_ADDR_HI_BASE_IDX                                                                 0
#define regCP_HQD_ACTIVE                                                                                0x1247
#define regCP_HQD_ACTIVE_BASE_IDX                                                                       0
#define regCP_HQD_VMID                                                                                  0x1248
#define regCP_HQD_VMID_BASE_IDX                                                                         0
#define regCP_HQD_PERSISTENT_STATE                                                                      0x1249
#define regCP_HQD_PERSISTENT_STATE_BASE_IDX                                                             0
#define regCP_HQD_PIPE_PRIORITY                                                                         0x124a
#define regCP_HQD_PIPE_PRIORITY_BASE_IDX                                                                0
#define regCP_HQD_QUEUE_PRIORITY                                                                        0x124b
#define regCP_HQD_QUEUE_PRIORITY_BASE_IDX                                                               0
#define regCP_HQD_QUANTUM                                                                               0x124c
#define regCP_HQD_QUANTUM_BASE_IDX                                                                      0
#define regCP_HQD_PQ_BASE                                                                               0x124d
#define regCP_HQD_PQ_BASE_BASE_IDX                                                                      0
#define regCP_HQD_PQ_BASE_HI                                                                            0x124e
#define regCP_HQD_PQ_BASE_HI_BASE_IDX                                                                   0
#define regCP_HQD_PQ_RPTR                                                                               0x124f
#define regCP_HQD_PQ_RPTR_BASE_IDX                                                                      0
#define regCP_HQD_PQ_RPTR_REPORT_ADDR                                                                   0x1250
#define regCP_HQD_PQ_RPTR_REPORT_ADDR_BASE_IDX                                                          0
#define regCP_HQD_PQ_RPTR_REPORT_ADDR_HI                                                                0x1251
#define regCP_HQD_PQ_RPTR_REPORT_ADDR_HI_BASE_IDX                                                       0
#define regCP_HQD_PQ_WPTR_POLL_ADDR                                                                     0x1252
#define regCP_HQD_PQ_WPTR_POLL_ADDR_BASE_IDX                                                            0
#define regCP_HQD_PQ_WPTR_POLL_ADDR_HI                                                                  0x1253
#define regCP_HQD_PQ_WPTR_POLL_ADDR_HI_BASE_IDX                                                         0
#define regCP_HQD_PQ_DOORBELL_CONTROL                                                                   0x1254
#define regCP_HQD_PQ_DOORBELL_CONTROL_BASE_IDX                                                          0
#define regCP_HQD_PQ_CONTROL                                                                            0x1256
#define regCP_HQD_PQ_CONTROL_BASE_IDX                                                                   0
#define regCP_HQD_IB_BASE_ADDR                                                                          0x1257
#define regCP_HQD_IB_BASE_ADDR_BASE_IDX                                                                 0
#define regCP_HQD_IB_BASE_ADDR_HI                                                                       0x1258
#define regCP_HQD_IB_BASE_ADDR_HI_BASE_IDX                                                              0
#define regCP_HQD_IB_RPTR                                                                               0x1259
#define regCP_HQD_IB_RPTR_BASE_IDX                                                                      0
#define regCP_HQD_IB_CONTROL                                                                            0x125a
#define regCP_HQD_IB_CONTROL_BASE_IDX                                                                   0
#define regCP_HQD_IQ_TIMER                                                                              0x125b
#define regCP_HQD_IQ_TIMER_BASE_IDX                                                                     0
#define regCP_HQD_IQ_RPTR                                                                               0x125c
#define regCP_HQD_IQ_RPTR_BASE_IDX                                                                      0
#define regCP_HQD_DEQUEUE_REQUEST                                                                       0x125d
#define regCP_HQD_DEQUEUE_REQUEST_BASE_IDX                                                              0
#define regCP_HQD_DMA_OFFLOAD                                                                           0x125e
#define regCP_HQD_DMA_OFFLOAD_BASE_IDX                                                                  0
#define regCP_HQD_OFFLOAD                                                                               0x125e
#define regCP_HQD_OFFLOAD_BASE_IDX                                                                      0
#define regCP_HQD_SEMA_CMD                                                                              0x125f
#define regCP_HQD_SEMA_CMD_BASE_IDX                                                                     0
#define regCP_HQD_MSG_TYPE                                                                              0x1260
#define regCP_HQD_MSG_TYPE_BASE_IDX                                                                     0
#define regCP_HQD_ATOMIC0_PREOP_LO                                                                      0x1261
#define regCP_HQD_ATOMIC0_PREOP_LO_BASE_IDX                                                             0
#define regCP_HQD_ATOMIC0_PREOP_HI                                                                      0x1262
#define regCP_HQD_ATOMIC0_PREOP_HI_BASE_IDX                                                             0
#define regCP_HQD_ATOMIC1_PREOP_LO                                                                      0x1263
#define regCP_HQD_ATOMIC1_PREOP_LO_BASE_IDX                                                             0
#define regCP_HQD_ATOMIC1_PREOP_HI                                                                      0x1264
#define regCP_HQD_ATOMIC1_PREOP_HI_BASE_IDX                                                             0
#define regCP_HQD_HQ_SCHEDULER0                                                                         0x1265
#define regCP_HQD_HQ_SCHEDULER0_BASE_IDX                                                                0
#define regCP_HQD_HQ_STATUS0                                                                            0x1265
#define regCP_HQD_HQ_STATUS0_BASE_IDX                                                                   0
#define regCP_HQD_HQ_CONTROL0                                                                           0x1266
#define regCP_HQD_HQ_CONTROL0_BASE_IDX                                                                  0
#define regCP_HQD_HQ_SCHEDULER1                                                                         0x1266
#define regCP_HQD_HQ_SCHEDULER1_BASE_IDX                                                                0
#define regCP_MQD_CONTROL                                                                               0x1267
#define regCP_MQD_CONTROL_BASE_IDX                                                                      0
#define regCP_HQD_HQ_STATUS1                                                                            0x1268
#define regCP_HQD_HQ_STATUS1_BASE_IDX                                                                   0
#define regCP_HQD_HQ_CONTROL1                                                                           0x1269
#define regCP_HQD_HQ_CONTROL1_BASE_IDX                                                                  0
#define regCP_HQD_EOP_BASE_ADDR                                                                         0x126a
#define regCP_HQD_EOP_BASE_ADDR_BASE_IDX                                                                0
#define regCP_HQD_EOP_BASE_ADDR_HI                                                                      0x126b
#define regCP_HQD_EOP_BASE_ADDR_HI_BASE_IDX                                                             0
#define regCP_HQD_EOP_CONTROL                                                                           0x126c
#define regCP_HQD_EOP_CONTROL_BASE_IDX                                                                  0
#define regCP_HQD_EOP_RPTR                                                                              0x126d
#define regCP_HQD_EOP_RPTR_BASE_IDX                                                                     0
#define regCP_HQD_EOP_WPTR                                                                              0x126e
#define regCP_HQD_EOP_WPTR_BASE_IDX                                                                     0
#define regCP_HQD_EOP_EVENTS                                                                            0x126f
#define regCP_HQD_EOP_EVENTS_BASE_IDX                                                                   0
#define regCP_HQD_CTX_SAVE_BASE_ADDR_LO                                                                 0x1270
#define regCP_HQD_CTX_SAVE_BASE_ADDR_LO_BASE_IDX                                                        0
#define regCP_HQD_CTX_SAVE_BASE_ADDR_HI                                                                 0x1271
#define regCP_HQD_CTX_SAVE_BASE_ADDR_HI_BASE_IDX                                                        0
#define regCP_HQD_CTX_SAVE_CONTROL                                                                      0x1272
#define regCP_HQD_CTX_SAVE_CONTROL_BASE_IDX                                                             0
#define regCP_HQD_CNTL_STACK_OFFSET                                                                     0x1273
#define regCP_HQD_CNTL_STACK_OFFSET_BASE_IDX                                                            0
#define regCP_HQD_CNTL_STACK_SIZE                                                                       0x1274
#define regCP_HQD_CNTL_STACK_SIZE_BASE_IDX                                                              0
#define regCP_HQD_WG_STATE_OFFSET                                                                       0x1275
#define regCP_HQD_WG_STATE_OFFSET_BASE_IDX                                                              0
#define regCP_HQD_CTX_SAVE_SIZE                                                                         0x1276
#define regCP_HQD_CTX_SAVE_SIZE_BASE_IDX                                                                0
#define regCP_HQD_GDS_RESOURCE_STATE                                                                    0x1277
#define regCP_HQD_GDS_RESOURCE_STATE_BASE_IDX                                                           0
#define regCP_HQD_ERROR                                                                                 0x1278
#define regCP_HQD_ERROR_BASE_IDX                                                                        0
#define regCP_HQD_EOP_WPTR_MEM                                                                          0x1279
#define regCP_HQD_EOP_WPTR_MEM_BASE_IDX                                                                 0
#define regCP_HQD_AQL_CONTROL                                                                           0x127a
#define regCP_HQD_AQL_CONTROL_BASE_IDX                                                                  0
#define regCP_HQD_PQ_WPTR_LO                                                                            0x127b
#define regCP_HQD_PQ_WPTR_LO_BASE_IDX                                                                   0
#define regCP_HQD_PQ_WPTR_HI                                                                            0x127c
#define regCP_HQD_PQ_WPTR_HI_BASE_IDX                                                                   0
#define regCP_HQD_AQL_CONTROL_1                                                                         0x127d
#define regCP_HQD_AQL_CONTROL_1_BASE_IDX                                                                0
#define regCP_HQD_AQL_DISPATCH_ID                                                                       0x127e
#define regCP_HQD_AQL_DISPATCH_ID_BASE_IDX                                                              0
#define regCP_HQD_AQL_DISPATCH_ID_HI                                                                    0x127f
#define regCP_HQD_AQL_DISPATCH_ID_HI_BASE_IDX                                                           0


// addressBlock: xcd0_gc_tcpdec
// base address: 0xca80
#define regTCP_WATCH0_ADDR_H                                                                            0x12a0
#define regTCP_WATCH0_ADDR_H_BASE_IDX                                                                   0
#define regTCP_WATCH0_ADDR_L                                                                            0x12a1
#define regTCP_WATCH0_ADDR_L_BASE_IDX                                                                   0
#define regTCP_WATCH0_CNTL                                                                              0x12a2
#define regTCP_WATCH0_CNTL_BASE_IDX                                                                     0
#define regTCP_WATCH1_ADDR_H                                                                            0x12a3
#define regTCP_WATCH1_ADDR_H_BASE_IDX                                                                   0
#define regTCP_WATCH1_ADDR_L                                                                            0x12a4
#define regTCP_WATCH1_ADDR_L_BASE_IDX                                                                   0
#define regTCP_WATCH1_CNTL                                                                              0x12a5
#define regTCP_WATCH1_CNTL_BASE_IDX                                                                     0
#define regTCP_WATCH2_ADDR_H                                                                            0x12a6
#define regTCP_WATCH2_ADDR_H_BASE_IDX                                                                   0
#define regTCP_WATCH2_ADDR_L                                                                            0x12a7
#define regTCP_WATCH2_ADDR_L_BASE_IDX                                                                   0
#define regTCP_WATCH2_CNTL                                                                              0x12a8
#define regTCP_WATCH2_CNTL_BASE_IDX                                                                     0
#define regTCP_WATCH3_ADDR_H                                                                            0x12a9
#define regTCP_WATCH3_ADDR_H_BASE_IDX                                                                   0
#define regTCP_WATCH3_ADDR_L                                                                            0x12aa
#define regTCP_WATCH3_ADDR_L_BASE_IDX                                                                   0
#define regTCP_WATCH3_CNTL                                                                              0x12ab
#define regTCP_WATCH3_CNTL_BASE_IDX                                                                     0
#define regTCP_GATCL1_CNTL                                                                              0x12b0
#define regTCP_GATCL1_CNTL_BASE_IDX                                                                     0
#define regTCP_ATC_EDC_GATCL1_CNT                                                                       0x12b1
#define regTCP_ATC_EDC_GATCL1_CNT_BASE_IDX                                                              0
#define regTCP_GATCL1_DSM_CNTL                                                                          0x12b2
#define regTCP_GATCL1_DSM_CNTL_BASE_IDX                                                                 0
#define regTCP_DSM_CNTL                                                                                 0x12b3
#define regTCP_DSM_CNTL_BASE_IDX                                                                        0
#define regTCP_CNTL2                                                                                    0x12b4
#define regTCP_CNTL2_BASE_IDX                                                                           0
#define regTCP_UTCL1_CNTL1                                                                              0x12b5
#define regTCP_UTCL1_CNTL1_BASE_IDX                                                                     0
#define regTCP_UTCL1_CNTL2                                                                              0x12b6
#define regTCP_UTCL1_CNTL2_BASE_IDX                                                                     0
#define regTCP_UTCL1_STATUS                                                                             0x12b7
#define regTCP_UTCL1_STATUS_BASE_IDX                                                                    0
#define regTCP_DSM_CNTL2                                                                                0x12b8
#define regTCP_DSM_CNTL2_BASE_IDX                                                                       0
#define regTCP_PERFCOUNTER_FILTER                                                                       0x12b9
#define regTCP_PERFCOUNTER_FILTER_BASE_IDX                                                              0
#define regTCP_PERFCOUNTER_FILTER_EN                                                                    0x12ba
#define regTCP_PERFCOUNTER_FILTER_EN_BASE_IDX                                                           0


// addressBlock: xcd0_gc_gdspdec
// base address: 0xcc00
#define regGDS_VMID0_BASE                                                                               0x1300
#define regGDS_VMID0_BASE_BASE_IDX                                                                      0
#define regGDS_VMID0_SIZE                                                                               0x1301
#define regGDS_VMID0_SIZE_BASE_IDX                                                                      0
#define regGDS_VMID1_BASE                                                                               0x1302
#define regGDS_VMID1_BASE_BASE_IDX                                                                      0
#define regGDS_VMID1_SIZE                                                                               0x1303
#define regGDS_VMID1_SIZE_BASE_IDX                                                                      0
#define regGDS_VMID2_BASE                                                                               0x1304
#define regGDS_VMID2_BASE_BASE_IDX                                                                      0
#define regGDS_VMID2_SIZE                                                                               0x1305
#define regGDS_VMID2_SIZE_BASE_IDX                                                                      0
#define regGDS_VMID3_BASE                                                                               0x1306
#define regGDS_VMID3_BASE_BASE_IDX                                                                      0
#define regGDS_VMID3_SIZE                                                                               0x1307
#define regGDS_VMID3_SIZE_BASE_IDX                                                                      0
#define regGDS_VMID4_BASE                                                                               0x1308
#define regGDS_VMID4_BASE_BASE_IDX                                                                      0
#define regGDS_VMID4_SIZE                                                                               0x1309
#define regGDS_VMID4_SIZE_BASE_IDX                                                                      0
#define regGDS_VMID5_BASE                                                                               0x130a
#define regGDS_VMID5_BASE_BASE_IDX                                                                      0
#define regGDS_VMID5_SIZE                                                                               0x130b
#define regGDS_VMID5_SIZE_BASE_IDX                                                                      0
#define regGDS_VMID6_BASE                                                                               0x130c
#define regGDS_VMID6_BASE_BASE_IDX                                                                      0
#define regGDS_VMID6_SIZE                                                                               0x130d
#define regGDS_VMID6_SIZE_BASE_IDX                                                                      0
#define regGDS_VMID7_BASE                                                                               0x130e
#define regGDS_VMID7_BASE_BASE_IDX                                                                      0
#define regGDS_VMID7_SIZE                                                                               0x130f
#define regGDS_VMID7_SIZE_BASE_IDX                                                                      0
#define regGDS_VMID8_BASE                                                                               0x1310
#define regGDS_VMID8_BASE_BASE_IDX                                                                      0
#define regGDS_VMID8_SIZE                                                                               0x1311
#define regGDS_VMID8_SIZE_BASE_IDX                                                                      0
#define regGDS_VMID9_BASE                                                                               0x1312
#define regGDS_VMID9_BASE_BASE_IDX                                                                      0
#define regGDS_VMID9_SIZE                                                                               0x1313
#define regGDS_VMID9_SIZE_BASE_IDX                                                                      0
#define regGDS_VMID10_BASE                                                                              0x1314
#define regGDS_VMID10_BASE_BASE_IDX                                                                     0
#define regGDS_VMID10_SIZE                                                                              0x1315
#define regGDS_VMID10_SIZE_BASE_IDX                                                                     0
#define regGDS_VMID11_BASE                                                                              0x1316
#define regGDS_VMID11_BASE_BASE_IDX                                                                     0
#define regGDS_VMID11_SIZE                                                                              0x1317
#define regGDS_VMID11_SIZE_BASE_IDX                                                                     0
#define regGDS_VMID12_BASE                                                                              0x1318
#define regGDS_VMID12_BASE_BASE_IDX                                                                     0
#define regGDS_VMID12_SIZE                                                                              0x1319
#define regGDS_VMID12_SIZE_BASE_IDX                                                                     0
#define regGDS_VMID13_BASE                                                                              0x131a
#define regGDS_VMID13_BASE_BASE_IDX                                                                     0
#define regGDS_VMID13_SIZE                                                                              0x131b
#define regGDS_VMID13_SIZE_BASE_IDX                                                                     0
#define regGDS_VMID14_BASE                                                                              0x131c
#define regGDS_VMID14_BASE_BASE_IDX                                                                     0
#define regGDS_VMID14_SIZE                                                                              0x131d
#define regGDS_VMID14_SIZE_BASE_IDX                                                                     0
#define regGDS_VMID15_BASE                                                                              0x131e
#define regGDS_VMID15_BASE_BASE_IDX                                                                     0
#define regGDS_VMID15_SIZE                                                                              0x131f
#define regGDS_VMID15_SIZE_BASE_IDX                                                                     0
#define regGDS_GWS_VMID0                                                                                0x1320
#define regGDS_GWS_VMID0_BASE_IDX                                                                       0
#define regGDS_GWS_VMID1                                                                                0x1321
#define regGDS_GWS_VMID1_BASE_IDX                                                                       0
#define regGDS_GWS_VMID2                                                                                0x1322
#define regGDS_GWS_VMID2_BASE_IDX                                                                       0
#define regGDS_GWS_VMID3                                                                                0x1323
#define regGDS_GWS_VMID3_BASE_IDX                                                                       0
#define regGDS_GWS_VMID4                                                                                0x1324
#define regGDS_GWS_VMID4_BASE_IDX                                                                       0
#define regGDS_GWS_VMID5                                                                                0x1325
#define regGDS_GWS_VMID5_BASE_IDX                                                                       0
#define regGDS_GWS_VMID6                                                                                0x1326
#define regGDS_GWS_VMID6_BASE_IDX                                                                       0
#define regGDS_GWS_VMID7                                                                                0x1327
#define regGDS_GWS_VMID7_BASE_IDX                                                                       0
#define regGDS_GWS_VMID8                                                                                0x1328
#define regGDS_GWS_VMID8_BASE_IDX                                                                       0
#define regGDS_GWS_VMID9                                                                                0x1329
#define regGDS_GWS_VMID9_BASE_IDX                                                                       0
#define regGDS_GWS_VMID10                                                                               0x132a
#define regGDS_GWS_VMID10_BASE_IDX                                                                      0
#define regGDS_GWS_VMID11                                                                               0x132b
#define regGDS_GWS_VMID11_BASE_IDX                                                                      0
#define regGDS_GWS_VMID12                                                                               0x132c
#define regGDS_GWS_VMID12_BASE_IDX                                                                      0
#define regGDS_GWS_VMID13                                                                               0x132d
#define regGDS_GWS_VMID13_BASE_IDX                                                                      0
#define regGDS_GWS_VMID14                                                                               0x132e
#define regGDS_GWS_VMID14_BASE_IDX                                                                      0
#define regGDS_GWS_VMID15                                                                               0x132f
#define regGDS_GWS_VMID15_BASE_IDX                                                                      0
#define regGDS_OA_VMID0                                                                                 0x1330
#define regGDS_OA_VMID0_BASE_IDX                                                                        0
#define regGDS_OA_VMID1                                                                                 0x1331
#define regGDS_OA_VMID1_BASE_IDX                                                                        0
#define regGDS_OA_VMID2                                                                                 0x1332
#define regGDS_OA_VMID2_BASE_IDX                                                                        0
#define regGDS_OA_VMID3                                                                                 0x1333
#define regGDS_OA_VMID3_BASE_IDX                                                                        0
#define regGDS_OA_VMID4                                                                                 0x1334
#define regGDS_OA_VMID4_BASE_IDX                                                                        0
#define regGDS_OA_VMID5                                                                                 0x1335
#define regGDS_OA_VMID5_BASE_IDX                                                                        0
#define regGDS_OA_VMID6                                                                                 0x1336
#define regGDS_OA_VMID6_BASE_IDX                                                                        0
#define regGDS_OA_VMID7                                                                                 0x1337
#define regGDS_OA_VMID7_BASE_IDX                                                                        0
#define regGDS_OA_VMID8                                                                                 0x1338
#define regGDS_OA_VMID8_BASE_IDX                                                                        0
#define regGDS_OA_VMID9                                                                                 0x1339
#define regGDS_OA_VMID9_BASE_IDX                                                                        0
#define regGDS_OA_VMID10                                                                                0x133a
#define regGDS_OA_VMID10_BASE_IDX                                                                       0
#define regGDS_OA_VMID11                                                                                0x133b
#define regGDS_OA_VMID11_BASE_IDX                                                                       0
#define regGDS_OA_VMID12                                                                                0x133c
#define regGDS_OA_VMID12_BASE_IDX                                                                       0
#define regGDS_OA_VMID13                                                                                0x133d
#define regGDS_OA_VMID13_BASE_IDX                                                                       0
#define regGDS_OA_VMID14                                                                                0x133e
#define regGDS_OA_VMID14_BASE_IDX                                                                       0
#define regGDS_OA_VMID15                                                                                0x133f
#define regGDS_OA_VMID15_BASE_IDX                                                                       0
#define regGDS_GWS_RESET0                                                                               0x1344
#define regGDS_GWS_RESET0_BASE_IDX                                                                      0
#define regGDS_GWS_RESET1                                                                               0x1345
#define regGDS_GWS_RESET1_BASE_IDX                                                                      0
#define regGDS_GWS_RESOURCE_RESET                                                                       0x1346
#define regGDS_GWS_RESOURCE_RESET_BASE_IDX                                                              0
#define regGDS_COMPUTE_MAX_WAVE_ID                                                                      0x1348
#define regGDS_COMPUTE_MAX_WAVE_ID_BASE_IDX                                                             0
#define regGDS_OA_RESET_MASK                                                                            0x1349
#define regGDS_OA_RESET_MASK_BASE_IDX                                                                   0
#define regGDS_OA_RESET                                                                                 0x134a
#define regGDS_OA_RESET_BASE_IDX                                                                        0
#define regGDS_ENHANCE                                                                                  0x134b
#define regGDS_ENHANCE_BASE_IDX                                                                         0
#define regGDS_OA_CGPG_RESTORE                                                                          0x134c
#define regGDS_OA_CGPG_RESTORE_BASE_IDX                                                                 0
#define regGDS_CS_CTXSW_STATUS                                                                          0x134d
#define regGDS_CS_CTXSW_STATUS_BASE_IDX                                                                 0
#define regGDS_CS_CTXSW_CNT0                                                                            0x134e
#define regGDS_CS_CTXSW_CNT0_BASE_IDX                                                                   0
#define regGDS_CS_CTXSW_CNT1                                                                            0x134f
#define regGDS_CS_CTXSW_CNT1_BASE_IDX                                                                   0
#define regGDS_CS_CTXSW_CNT2                                                                            0x1350
#define regGDS_CS_CTXSW_CNT2_BASE_IDX                                                                   0
#define regGDS_CS_CTXSW_CNT3                                                                            0x1351
#define regGDS_CS_CTXSW_CNT3_BASE_IDX                                                                   0
#define regGDS_GFX_CTXSW_STATUS                                                                         0x1352
#define regGDS_GFX_CTXSW_STATUS_BASE_IDX                                                                0
#define regGDS_VS_CTXSW_CNT0                                                                            0x1353
#define regGDS_VS_CTXSW_CNT0_BASE_IDX                                                                   0
#define regGDS_VS_CTXSW_CNT1                                                                            0x1354
#define regGDS_VS_CTXSW_CNT1_BASE_IDX                                                                   0
#define regGDS_VS_CTXSW_CNT2                                                                            0x1355
#define regGDS_VS_CTXSW_CNT2_BASE_IDX                                                                   0
#define regGDS_VS_CTXSW_CNT3                                                                            0x1356
#define regGDS_VS_CTXSW_CNT3_BASE_IDX                                                                   0
#define regGDS_PS0_CTXSW_CNT0                                                                           0x1357
#define regGDS_PS0_CTXSW_CNT0_BASE_IDX                                                                  0
#define regGDS_PS0_CTXSW_CNT1                                                                           0x1358
#define regGDS_PS0_CTXSW_CNT1_BASE_IDX                                                                  0
#define regGDS_PS0_CTXSW_CNT2                                                                           0x1359
#define regGDS_PS0_CTXSW_CNT2_BASE_IDX                                                                  0
#define regGDS_PS0_CTXSW_CNT3                                                                           0x135a
#define regGDS_PS0_CTXSW_CNT3_BASE_IDX                                                                  0
#define regGDS_PS1_CTXSW_CNT0                                                                           0x135b
#define regGDS_PS1_CTXSW_CNT0_BASE_IDX                                                                  0
#define regGDS_PS1_CTXSW_CNT1                                                                           0x135c
#define regGDS_PS1_CTXSW_CNT1_BASE_IDX                                                                  0
#define regGDS_PS1_CTXSW_CNT2                                                                           0x135d
#define regGDS_PS1_CTXSW_CNT2_BASE_IDX                                                                  0
#define regGDS_PS1_CTXSW_CNT3                                                                           0x135e
#define regGDS_PS1_CTXSW_CNT3_BASE_IDX                                                                  0
#define regGDS_PS2_CTXSW_CNT0                                                                           0x135f
#define regGDS_PS2_CTXSW_CNT0_BASE_IDX                                                                  0
#define regGDS_PS2_CTXSW_CNT1                                                                           0x1360
#define regGDS_PS2_CTXSW_CNT1_BASE_IDX                                                                  0
#define regGDS_PS2_CTXSW_CNT2                                                                           0x1361
#define regGDS_PS2_CTXSW_CNT2_BASE_IDX                                                                  0
#define regGDS_PS2_CTXSW_CNT3                                                                           0x1362
#define regGDS_PS2_CTXSW_CNT3_BASE_IDX                                                                  0
#define regGDS_PS3_CTXSW_CNT0                                                                           0x1363
#define regGDS_PS3_CTXSW_CNT0_BASE_IDX                                                                  0
#define regGDS_PS3_CTXSW_CNT1                                                                           0x1364
#define regGDS_PS3_CTXSW_CNT1_BASE_IDX                                                                  0
#define regGDS_PS3_CTXSW_CNT2                                                                           0x1365
#define regGDS_PS3_CTXSW_CNT2_BASE_IDX                                                                  0
#define regGDS_PS3_CTXSW_CNT3                                                                           0x1366
#define regGDS_PS3_CTXSW_CNT3_BASE_IDX                                                                  0
#define regGDS_PS4_CTXSW_CNT0                                                                           0x1367
#define regGDS_PS4_CTXSW_CNT0_BASE_IDX                                                                  0
#define regGDS_PS4_CTXSW_CNT1                                                                           0x1368
#define regGDS_PS4_CTXSW_CNT1_BASE_IDX                                                                  0
#define regGDS_PS4_CTXSW_CNT2                                                                           0x1369
#define regGDS_PS4_CTXSW_CNT2_BASE_IDX                                                                  0
#define regGDS_PS4_CTXSW_CNT3                                                                           0x136a
#define regGDS_PS4_CTXSW_CNT3_BASE_IDX                                                                  0
#define regGDS_PS5_CTXSW_CNT0                                                                           0x136b
#define regGDS_PS5_CTXSW_CNT0_BASE_IDX                                                                  0
#define regGDS_PS5_CTXSW_CNT1                                                                           0x136c
#define regGDS_PS5_CTXSW_CNT1_BASE_IDX                                                                  0
#define regGDS_PS5_CTXSW_CNT2                                                                           0x136d
#define regGDS_PS5_CTXSW_CNT2_BASE_IDX                                                                  0
#define regGDS_PS5_CTXSW_CNT3                                                                           0x136e
#define regGDS_PS5_CTXSW_CNT3_BASE_IDX                                                                  0
#define regGDS_PS6_CTXSW_CNT0                                                                           0x136f
#define regGDS_PS6_CTXSW_CNT0_BASE_IDX                                                                  0
#define regGDS_PS6_CTXSW_CNT1                                                                           0x1370
#define regGDS_PS6_CTXSW_CNT1_BASE_IDX                                                                  0
#define regGDS_PS6_CTXSW_CNT2                                                                           0x1371
#define regGDS_PS6_CTXSW_CNT2_BASE_IDX                                                                  0
#define regGDS_PS6_CTXSW_CNT3                                                                           0x1372
#define regGDS_PS6_CTXSW_CNT3_BASE_IDX                                                                  0
#define regGDS_PS7_CTXSW_CNT0                                                                           0x1373
#define regGDS_PS7_CTXSW_CNT0_BASE_IDX                                                                  0
#define regGDS_PS7_CTXSW_CNT1                                                                           0x1374
#define regGDS_PS7_CTXSW_CNT1_BASE_IDX                                                                  0
#define regGDS_PS7_CTXSW_CNT2                                                                           0x1375
#define regGDS_PS7_CTXSW_CNT2_BASE_IDX                                                                  0
#define regGDS_PS7_CTXSW_CNT3                                                                           0x1376
#define regGDS_PS7_CTXSW_CNT3_BASE_IDX                                                                  0
#define regGDS_GS_CTXSW_CNT0                                                                            0x1377
#define regGDS_GS_CTXSW_CNT0_BASE_IDX                                                                   0
#define regGDS_GS_CTXSW_CNT1                                                                            0x1378
#define regGDS_GS_CTXSW_CNT1_BASE_IDX                                                                   0
#define regGDS_GS_CTXSW_CNT2                                                                            0x1379
#define regGDS_GS_CTXSW_CNT2_BASE_IDX                                                                   0
#define regGDS_GS_CTXSW_CNT3                                                                            0x137a
#define regGDS_GS_CTXSW_CNT3_BASE_IDX                                                                   0


// addressBlock: xcd0_gc_rasdec
// base address: 0xce00
#define regRAS_SIGNATURE_CONTROL                                                                        0x1380
#define regRAS_SIGNATURE_CONTROL_BASE_IDX                                                               0
#define regRAS_SIGNATURE_MASK                                                                           0x1381
#define regRAS_SIGNATURE_MASK_BASE_IDX                                                                  0
#define regRAS_SX_SIGNATURE0                                                                            0x1382
#define regRAS_SX_SIGNATURE0_BASE_IDX                                                                   0
#define regRAS_SX_SIGNATURE1                                                                            0x1383
#define regRAS_SX_SIGNATURE1_BASE_IDX                                                                   0
#define regRAS_SX_SIGNATURE2                                                                            0x1384
#define regRAS_SX_SIGNATURE2_BASE_IDX                                                                   0
#define regRAS_SX_SIGNATURE3                                                                            0x1385
#define regRAS_SX_SIGNATURE3_BASE_IDX                                                                   0
#define regRAS_DB_SIGNATURE0                                                                            0x138b
#define regRAS_DB_SIGNATURE0_BASE_IDX                                                                   0
#define regRAS_PA_SIGNATURE0                                                                            0x138c
#define regRAS_PA_SIGNATURE0_BASE_IDX                                                                   0
#define regRAS_VGT_SIGNATURE0                                                                           0x138d
#define regRAS_VGT_SIGNATURE0_BASE_IDX                                                                  0
#define regRAS_SQ_SIGNATURE0                                                                            0x138e
#define regRAS_SQ_SIGNATURE0_BASE_IDX                                                                   0
#define regRAS_SC_SIGNATURE0                                                                            0x138f
#define regRAS_SC_SIGNATURE0_BASE_IDX                                                                   0
#define regRAS_SC_SIGNATURE1                                                                            0x1390
#define regRAS_SC_SIGNATURE1_BASE_IDX                                                                   0
#define regRAS_SC_SIGNATURE2                                                                            0x1391
#define regRAS_SC_SIGNATURE2_BASE_IDX                                                                   0
#define regRAS_SC_SIGNATURE3                                                                            0x1392
#define regRAS_SC_SIGNATURE3_BASE_IDX                                                                   0
#define regRAS_SC_SIGNATURE4                                                                            0x1393
#define regRAS_SC_SIGNATURE4_BASE_IDX                                                                   0
#define regRAS_SC_SIGNATURE5                                                                            0x1394
#define regRAS_SC_SIGNATURE5_BASE_IDX                                                                   0
#define regRAS_SC_SIGNATURE6                                                                            0x1395
#define regRAS_SC_SIGNATURE6_BASE_IDX                                                                   0
#define regRAS_SC_SIGNATURE7                                                                            0x1396
#define regRAS_SC_SIGNATURE7_BASE_IDX                                                                   0
#define regRAS_IA_SIGNATURE0                                                                            0x1397
#define regRAS_IA_SIGNATURE0_BASE_IDX                                                                   0
#define regRAS_IA_SIGNATURE1                                                                            0x1398
#define regRAS_IA_SIGNATURE1_BASE_IDX                                                                   0
#define regRAS_SPI_SIGNATURE0                                                                           0x1399
#define regRAS_SPI_SIGNATURE0_BASE_IDX                                                                  0
#define regRAS_SPI_SIGNATURE1                                                                           0x139a
#define regRAS_SPI_SIGNATURE1_BASE_IDX                                                                  0
#define regRAS_TA_SIGNATURE0                                                                            0x139b
#define regRAS_TA_SIGNATURE0_BASE_IDX                                                                   0
#define regRAS_TD_SIGNATURE0                                                                            0x139c
#define regRAS_TD_SIGNATURE0_BASE_IDX                                                                   0
#define regRAS_CB_SIGNATURE0                                                                            0x139d
#define regRAS_CB_SIGNATURE0_BASE_IDX                                                                   0
#define regRAS_BCI_SIGNATURE0                                                                           0x139e
#define regRAS_BCI_SIGNATURE0_BASE_IDX                                                                  0
#define regRAS_BCI_SIGNATURE1                                                                           0x139f
#define regRAS_BCI_SIGNATURE1_BASE_IDX                                                                  0
#define regRAS_TA_SIGNATURE1                                                                            0x13a0
#define regRAS_TA_SIGNATURE1_BASE_IDX                                                                   0


// addressBlock: xcd0_gc_gfxdec0
// base address: 0x28000
#define regDB_RENDER_CONTROL                                                                            0x0000
#define regDB_RENDER_CONTROL_BASE_IDX                                                                   1
#define regDB_COUNT_CONTROL                                                                             0x0001
#define regDB_COUNT_CONTROL_BASE_IDX                                                                    1
#define regDB_DEPTH_VIEW                                                                                0x0002
#define regDB_DEPTH_VIEW_BASE_IDX                                                                       1
#define regDB_RENDER_OVERRIDE                                                                           0x0003
#define regDB_RENDER_OVERRIDE_BASE_IDX                                                                  1
#define regDB_RENDER_OVERRIDE2                                                                          0x0004
#define regDB_RENDER_OVERRIDE2_BASE_IDX                                                                 1
#define regDB_HTILE_DATA_BASE                                                                           0x0005
#define regDB_HTILE_DATA_BASE_BASE_IDX                                                                  1
#define regDB_HTILE_DATA_BASE_HI                                                                        0x0006
#define regDB_HTILE_DATA_BASE_HI_BASE_IDX                                                               1
#define regDB_DEPTH_SIZE                                                                                0x0007
#define regDB_DEPTH_SIZE_BASE_IDX                                                                       1
#define regDB_DEPTH_BOUNDS_MIN                                                                          0x0008
#define regDB_DEPTH_BOUNDS_MIN_BASE_IDX                                                                 1
#define regDB_DEPTH_BOUNDS_MAX                                                                          0x0009
#define regDB_DEPTH_BOUNDS_MAX_BASE_IDX                                                                 1
#define regDB_STENCIL_CLEAR                                                                             0x000a
#define regDB_STENCIL_CLEAR_BASE_IDX                                                                    1
#define regDB_DEPTH_CLEAR                                                                               0x000b
#define regDB_DEPTH_CLEAR_BASE_IDX                                                                      1
#define regPA_SC_SCREEN_SCISSOR_TL                                                                      0x000c
#define regPA_SC_SCREEN_SCISSOR_TL_BASE_IDX                                                             1
#define regPA_SC_SCREEN_SCISSOR_BR                                                                      0x000d
#define regPA_SC_SCREEN_SCISSOR_BR_BASE_IDX                                                             1
#define regDB_Z_INFO                                                                                    0x000e
#define regDB_Z_INFO_BASE_IDX                                                                           1
#define regDB_STENCIL_INFO                                                                              0x000f
#define regDB_STENCIL_INFO_BASE_IDX                                                                     1
#define regDB_Z_READ_BASE                                                                               0x0010
#define regDB_Z_READ_BASE_BASE_IDX                                                                      1
#define regDB_Z_READ_BASE_HI                                                                            0x0011
#define regDB_Z_READ_BASE_HI_BASE_IDX                                                                   1
#define regDB_STENCIL_READ_BASE                                                                         0x0012
#define regDB_STENCIL_READ_BASE_BASE_IDX                                                                1
#define regDB_STENCIL_READ_BASE_HI                                                                      0x0013
#define regDB_STENCIL_READ_BASE_HI_BASE_IDX                                                             1
#define regDB_Z_WRITE_BASE                                                                              0x0014
#define regDB_Z_WRITE_BASE_BASE_IDX                                                                     1
#define regDB_Z_WRITE_BASE_HI                                                                           0x0015
#define regDB_Z_WRITE_BASE_HI_BASE_IDX                                                                  1
#define regDB_STENCIL_WRITE_BASE                                                                        0x0016
#define regDB_STENCIL_WRITE_BASE_BASE_IDX                                                               1
#define regDB_STENCIL_WRITE_BASE_HI                                                                     0x0017
#define regDB_STENCIL_WRITE_BASE_HI_BASE_IDX                                                            1
#define regDB_DFSM_CONTROL                                                                              0x0018
#define regDB_DFSM_CONTROL_BASE_IDX                                                                     1
#define regDB_Z_INFO2                                                                                   0x001a
#define regDB_Z_INFO2_BASE_IDX                                                                          1
#define regDB_STENCIL_INFO2                                                                             0x001b
#define regDB_STENCIL_INFO2_BASE_IDX                                                                    1
#define regCOHER_DEST_BASE_HI_0                                                                         0x007a
#define regCOHER_DEST_BASE_HI_0_BASE_IDX                                                                1
#define regCOHER_DEST_BASE_HI_1                                                                         0x007b
#define regCOHER_DEST_BASE_HI_1_BASE_IDX                                                                1
#define regCOHER_DEST_BASE_HI_2                                                                         0x007c
#define regCOHER_DEST_BASE_HI_2_BASE_IDX                                                                1
#define regCOHER_DEST_BASE_HI_3                                                                         0x007d
#define regCOHER_DEST_BASE_HI_3_BASE_IDX                                                                1
#define regCOHER_DEST_BASE_2                                                                            0x007e
#define regCOHER_DEST_BASE_2_BASE_IDX                                                                   1
#define regCOHER_DEST_BASE_3                                                                            0x007f
#define regCOHER_DEST_BASE_3_BASE_IDX                                                                   1
#define regPA_SC_WINDOW_OFFSET                                                                          0x0080
#define regPA_SC_WINDOW_OFFSET_BASE_IDX                                                                 1
#define regPA_SC_WINDOW_SCISSOR_TL                                                                      0x0081
#define regPA_SC_WINDOW_SCISSOR_TL_BASE_IDX                                                             1
#define regPA_SC_WINDOW_SCISSOR_BR                                                                      0x0082
#define regPA_SC_WINDOW_SCISSOR_BR_BASE_IDX                                                             1
#define regPA_SC_CLIPRECT_RULE                                                                          0x0083
#define regPA_SC_CLIPRECT_RULE_BASE_IDX                                                                 1
#define regPA_SC_CLIPRECT_0_TL                                                                          0x0084
#define regPA_SC_CLIPRECT_0_TL_BASE_IDX                                                                 1
#define regPA_SC_CLIPRECT_0_BR                                                                          0x0085
#define regPA_SC_CLIPRECT_0_BR_BASE_IDX                                                                 1
#define regPA_SC_CLIPRECT_1_TL                                                                          0x0086
#define regPA_SC_CLIPRECT_1_TL_BASE_IDX                                                                 1
#define regPA_SC_CLIPRECT_1_BR                                                                          0x0087
#define regPA_SC_CLIPRECT_1_BR_BASE_IDX                                                                 1
#define regPA_SC_CLIPRECT_2_TL                                                                          0x0088
#define regPA_SC_CLIPRECT_2_TL_BASE_IDX                                                                 1
#define regPA_SC_CLIPRECT_2_BR                                                                          0x0089
#define regPA_SC_CLIPRECT_2_BR_BASE_IDX                                                                 1
#define regPA_SC_CLIPRECT_3_TL                                                                          0x008a
#define regPA_SC_CLIPRECT_3_TL_BASE_IDX                                                                 1
#define regPA_SC_CLIPRECT_3_BR                                                                          0x008b
#define regPA_SC_CLIPRECT_3_BR_BASE_IDX                                                                 1
#define regPA_SC_EDGERULE                                                                               0x008c
#define regPA_SC_EDGERULE_BASE_IDX                                                                      1
#define regPA_SU_HARDWARE_SCREEN_OFFSET                                                                 0x008d
#define regPA_SU_HARDWARE_SCREEN_OFFSET_BASE_IDX                                                        1
#define regCB_TARGET_MASK                                                                               0x008e
#define regCB_TARGET_MASK_BASE_IDX                                                                      1
#define regCB_SHADER_MASK                                                                               0x008f
#define regCB_SHADER_MASK_BASE_IDX                                                                      1
#define regPA_SC_GENERIC_SCISSOR_TL                                                                     0x0090
#define regPA_SC_GENERIC_SCISSOR_TL_BASE_IDX                                                            1
#define regPA_SC_GENERIC_SCISSOR_BR                                                                     0x0091
#define regPA_SC_GENERIC_SCISSOR_BR_BASE_IDX                                                            1
#define regCOHER_DEST_BASE_0                                                                            0x0092
#define regCOHER_DEST_BASE_0_BASE_IDX                                                                   1
#define regCOHER_DEST_BASE_1                                                                            0x0093
#define regCOHER_DEST_BASE_1_BASE_IDX                                                                   1
#define regPA_SC_VPORT_SCISSOR_0_TL                                                                     0x0094
#define regPA_SC_VPORT_SCISSOR_0_TL_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_0_BR                                                                     0x0095
#define regPA_SC_VPORT_SCISSOR_0_BR_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_1_TL                                                                     0x0096
#define regPA_SC_VPORT_SCISSOR_1_TL_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_1_BR                                                                     0x0097
#define regPA_SC_VPORT_SCISSOR_1_BR_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_2_TL                                                                     0x0098
#define regPA_SC_VPORT_SCISSOR_2_TL_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_2_BR                                                                     0x0099
#define regPA_SC_VPORT_SCISSOR_2_BR_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_3_TL                                                                     0x009a
#define regPA_SC_VPORT_SCISSOR_3_TL_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_3_BR                                                                     0x009b
#define regPA_SC_VPORT_SCISSOR_3_BR_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_4_TL                                                                     0x009c
#define regPA_SC_VPORT_SCISSOR_4_TL_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_4_BR                                                                     0x009d
#define regPA_SC_VPORT_SCISSOR_4_BR_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_5_TL                                                                     0x009e
#define regPA_SC_VPORT_SCISSOR_5_TL_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_5_BR                                                                     0x009f
#define regPA_SC_VPORT_SCISSOR_5_BR_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_6_TL                                                                     0x00a0
#define regPA_SC_VPORT_SCISSOR_6_TL_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_6_BR                                                                     0x00a1
#define regPA_SC_VPORT_SCISSOR_6_BR_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_7_TL                                                                     0x00a2
#define regPA_SC_VPORT_SCISSOR_7_TL_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_7_BR                                                                     0x00a3
#define regPA_SC_VPORT_SCISSOR_7_BR_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_8_TL                                                                     0x00a4
#define regPA_SC_VPORT_SCISSOR_8_TL_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_8_BR                                                                     0x00a5
#define regPA_SC_VPORT_SCISSOR_8_BR_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_9_TL                                                                     0x00a6
#define regPA_SC_VPORT_SCISSOR_9_TL_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_9_BR                                                                     0x00a7
#define regPA_SC_VPORT_SCISSOR_9_BR_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_10_TL                                                                    0x00a8
#define regPA_SC_VPORT_SCISSOR_10_TL_BASE_IDX                                                           1
#define regPA_SC_VPORT_SCISSOR_10_BR                                                                    0x00a9
#define regPA_SC_VPORT_SCISSOR_10_BR_BASE_IDX                                                           1
#define regPA_SC_VPORT_SCISSOR_11_TL                                                                    0x00aa
#define regPA_SC_VPORT_SCISSOR_11_TL_BASE_IDX                                                           1
#define regPA_SC_VPORT_SCISSOR_11_BR                                                                    0x00ab
#define regPA_SC_VPORT_SCISSOR_11_BR_BASE_IDX                                                           1
#define regPA_SC_VPORT_SCISSOR_12_TL                                                                    0x00ac
#define regPA_SC_VPORT_SCISSOR_12_TL_BASE_IDX                                                           1
#define regPA_SC_VPORT_SCISSOR_12_BR                                                                    0x00ad
#define regPA_SC_VPORT_SCISSOR_12_BR_BASE_IDX                                                           1
#define regPA_SC_VPORT_SCISSOR_13_TL                                                                    0x00ae
#define regPA_SC_VPORT_SCISSOR_13_TL_BASE_IDX                                                           1
#define regPA_SC_VPORT_SCISSOR_13_BR                                                                    0x00af
#define regPA_SC_VPORT_SCISSOR_13_BR_BASE_IDX                                                           1
#define regPA_SC_VPORT_SCISSOR_14_TL                                                                    0x00b0
#define regPA_SC_VPORT_SCISSOR_14_TL_BASE_IDX                                                           1
#define regPA_SC_VPORT_SCISSOR_14_BR                                                                    0x00b1
#define regPA_SC_VPORT_SCISSOR_14_BR_BASE_IDX                                                           1
#define regPA_SC_VPORT_SCISSOR_15_TL                                                                    0x00b2
#define regPA_SC_VPORT_SCISSOR_15_TL_BASE_IDX                                                           1
#define regPA_SC_VPORT_SCISSOR_15_BR                                                                    0x00b3
#define regPA_SC_VPORT_SCISSOR_15_BR_BASE_IDX                                                           1
#define regPA_SC_VPORT_ZMIN_0                                                                           0x00b4
#define regPA_SC_VPORT_ZMIN_0_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMAX_0                                                                           0x00b5
#define regPA_SC_VPORT_ZMAX_0_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMIN_1                                                                           0x00b6
#define regPA_SC_VPORT_ZMIN_1_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMAX_1                                                                           0x00b7
#define regPA_SC_VPORT_ZMAX_1_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMIN_2                                                                           0x00b8
#define regPA_SC_VPORT_ZMIN_2_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMAX_2                                                                           0x00b9
#define regPA_SC_VPORT_ZMAX_2_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMIN_3                                                                           0x00ba
#define regPA_SC_VPORT_ZMIN_3_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMAX_3                                                                           0x00bb
#define regPA_SC_VPORT_ZMAX_3_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMIN_4                                                                           0x00bc
#define regPA_SC_VPORT_ZMIN_4_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMAX_4                                                                           0x00bd
#define regPA_SC_VPORT_ZMAX_4_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMIN_5                                                                           0x00be
#define regPA_SC_VPORT_ZMIN_5_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMAX_5                                                                           0x00bf
#define regPA_SC_VPORT_ZMAX_5_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMIN_6                                                                           0x00c0
#define regPA_SC_VPORT_ZMIN_6_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMAX_6                                                                           0x00c1
#define regPA_SC_VPORT_ZMAX_6_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMIN_7                                                                           0x00c2
#define regPA_SC_VPORT_ZMIN_7_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMAX_7                                                                           0x00c3
#define regPA_SC_VPORT_ZMAX_7_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMIN_8                                                                           0x00c4
#define regPA_SC_VPORT_ZMIN_8_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMAX_8                                                                           0x00c5
#define regPA_SC_VPORT_ZMAX_8_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMIN_9                                                                           0x00c6
#define regPA_SC_VPORT_ZMIN_9_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMAX_9                                                                           0x00c7
#define regPA_SC_VPORT_ZMAX_9_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMIN_10                                                                          0x00c8
#define regPA_SC_VPORT_ZMIN_10_BASE_IDX                                                                 1
#define regPA_SC_VPORT_ZMAX_10                                                                          0x00c9
#define regPA_SC_VPORT_ZMAX_10_BASE_IDX                                                                 1
#define regPA_SC_VPORT_ZMIN_11                                                                          0x00ca
#define regPA_SC_VPORT_ZMIN_11_BASE_IDX                                                                 1
#define regPA_SC_VPORT_ZMAX_11                                                                          0x00cb
#define regPA_SC_VPORT_ZMAX_11_BASE_IDX                                                                 1
#define regPA_SC_VPORT_ZMIN_12                                                                          0x00cc
#define regPA_SC_VPORT_ZMIN_12_BASE_IDX                                                                 1
#define regPA_SC_VPORT_ZMAX_12                                                                          0x00cd
#define regPA_SC_VPORT_ZMAX_12_BASE_IDX                                                                 1
#define regPA_SC_VPORT_ZMIN_13                                                                          0x00ce
#define regPA_SC_VPORT_ZMIN_13_BASE_IDX                                                                 1
#define regPA_SC_VPORT_ZMAX_13                                                                          0x00cf
#define regPA_SC_VPORT_ZMAX_13_BASE_IDX                                                                 1
#define regPA_SC_VPORT_ZMIN_14                                                                          0x00d0
#define regPA_SC_VPORT_ZMIN_14_BASE_IDX                                                                 1
#define regPA_SC_VPORT_ZMAX_14                                                                          0x00d1
#define regPA_SC_VPORT_ZMAX_14_BASE_IDX                                                                 1
#define regPA_SC_VPORT_ZMIN_15                                                                          0x00d2
#define regPA_SC_VPORT_ZMIN_15_BASE_IDX                                                                 1
#define regPA_SC_VPORT_ZMAX_15                                                                          0x00d3
#define regPA_SC_VPORT_ZMAX_15_BASE_IDX                                                                 1
#define regPA_SC_RASTER_CONFIG                                                                          0x00d4
#define regPA_SC_RASTER_CONFIG_BASE_IDX                                                                 1
#define regPA_SC_RASTER_CONFIG_1                                                                        0x00d5
#define regPA_SC_RASTER_CONFIG_1_BASE_IDX                                                               1
#define regPA_SC_SCREEN_EXTENT_CONTROL                                                                  0x00d6
#define regPA_SC_SCREEN_EXTENT_CONTROL_BASE_IDX                                                         1
#define regPA_SC_TILE_STEERING_OVERRIDE                                                                 0x00d7
#define regPA_SC_TILE_STEERING_OVERRIDE_BASE_IDX                                                        1
#define regCP_PERFMON_CNTX_CNTL                                                                         0x00d8
#define regCP_PERFMON_CNTX_CNTL_BASE_IDX                                                                1
#define regCP_PIPEID                                                                                    0x00d9
#define regCP_PIPEID_BASE_IDX                                                                           1
#define regCP_RINGID                                                                                    0x00d9
#define regCP_RINGID_BASE_IDX                                                                           1
#define regCP_VMID                                                                                      0x00da
#define regCP_VMID_BASE_IDX                                                                             1
#define regPA_SC_RIGHT_VERT_GRID                                                                        0x00e8
#define regPA_SC_RIGHT_VERT_GRID_BASE_IDX                                                               1
#define regPA_SC_LEFT_VERT_GRID                                                                         0x00e9
#define regPA_SC_LEFT_VERT_GRID_BASE_IDX                                                                1
#define regPA_SC_HORIZ_GRID                                                                             0x00ea
#define regPA_SC_HORIZ_GRID_BASE_IDX                                                                    1
#define regVGT_MULTI_PRIM_IB_RESET_INDX                                                                 0x0103
#define regVGT_MULTI_PRIM_IB_RESET_INDX_BASE_IDX                                                        1
#define regCB_BLEND_RED                                                                                 0x0105
#define regCB_BLEND_RED_BASE_IDX                                                                        1
#define regCB_BLEND_GREEN                                                                               0x0106
#define regCB_BLEND_GREEN_BASE_IDX                                                                      1
#define regCB_BLEND_BLUE                                                                                0x0107
#define regCB_BLEND_BLUE_BASE_IDX                                                                       1
#define regCB_BLEND_ALPHA                                                                               0x0108
#define regCB_BLEND_ALPHA_BASE_IDX                                                                      1
#define regCB_DCC_CONTROL                                                                               0x0109
#define regCB_DCC_CONTROL_BASE_IDX                                                                      1
#define regDB_STENCIL_CONTROL                                                                           0x010b
#define regDB_STENCIL_CONTROL_BASE_IDX                                                                  1
#define regDB_STENCILREFMASK                                                                            0x010c
#define regDB_STENCILREFMASK_BASE_IDX                                                                   1
#define regDB_STENCILREFMASK_BF                                                                         0x010d
#define regDB_STENCILREFMASK_BF_BASE_IDX                                                                1
#define regPA_CL_VPORT_XSCALE                                                                           0x010f
#define regPA_CL_VPORT_XSCALE_BASE_IDX                                                                  1
#define regPA_CL_VPORT_XOFFSET                                                                          0x0110
#define regPA_CL_VPORT_XOFFSET_BASE_IDX                                                                 1
#define regPA_CL_VPORT_YSCALE                                                                           0x0111
#define regPA_CL_VPORT_YSCALE_BASE_IDX                                                                  1
#define regPA_CL_VPORT_YOFFSET                                                                          0x0112
#define regPA_CL_VPORT_YOFFSET_BASE_IDX                                                                 1
#define regPA_CL_VPORT_ZSCALE                                                                           0x0113
#define regPA_CL_VPORT_ZSCALE_BASE_IDX                                                                  1
#define regPA_CL_VPORT_ZOFFSET                                                                          0x0114
#define regPA_CL_VPORT_ZOFFSET_BASE_IDX                                                                 1
#define regPA_CL_VPORT_XSCALE_1                                                                         0x0115
#define regPA_CL_VPORT_XSCALE_1_BASE_IDX                                                                1
#define regPA_CL_VPORT_XOFFSET_1                                                                        0x0116
#define regPA_CL_VPORT_XOFFSET_1_BASE_IDX                                                               1
#define regPA_CL_VPORT_YSCALE_1                                                                         0x0117
#define regPA_CL_VPORT_YSCALE_1_BASE_IDX                                                                1
#define regPA_CL_VPORT_YOFFSET_1                                                                        0x0118
#define regPA_CL_VPORT_YOFFSET_1_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZSCALE_1                                                                         0x0119
#define regPA_CL_VPORT_ZSCALE_1_BASE_IDX                                                                1
#define regPA_CL_VPORT_ZOFFSET_1                                                                        0x011a
#define regPA_CL_VPORT_ZOFFSET_1_BASE_IDX                                                               1
#define regPA_CL_VPORT_XSCALE_2                                                                         0x011b
#define regPA_CL_VPORT_XSCALE_2_BASE_IDX                                                                1
#define regPA_CL_VPORT_XOFFSET_2                                                                        0x011c
#define regPA_CL_VPORT_XOFFSET_2_BASE_IDX                                                               1
#define regPA_CL_VPORT_YSCALE_2                                                                         0x011d
#define regPA_CL_VPORT_YSCALE_2_BASE_IDX                                                                1
#define regPA_CL_VPORT_YOFFSET_2                                                                        0x011e
#define regPA_CL_VPORT_YOFFSET_2_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZSCALE_2                                                                         0x011f
#define regPA_CL_VPORT_ZSCALE_2_BASE_IDX                                                                1
#define regPA_CL_VPORT_ZOFFSET_2                                                                        0x0120
#define regPA_CL_VPORT_ZOFFSET_2_BASE_IDX                                                               1
#define regPA_CL_VPORT_XSCALE_3                                                                         0x0121
#define regPA_CL_VPORT_XSCALE_3_BASE_IDX                                                                1
#define regPA_CL_VPORT_XOFFSET_3                                                                        0x0122
#define regPA_CL_VPORT_XOFFSET_3_BASE_IDX                                                               1
#define regPA_CL_VPORT_YSCALE_3                                                                         0x0123
#define regPA_CL_VPORT_YSCALE_3_BASE_IDX                                                                1
#define regPA_CL_VPORT_YOFFSET_3                                                                        0x0124
#define regPA_CL_VPORT_YOFFSET_3_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZSCALE_3                                                                         0x0125
#define regPA_CL_VPORT_ZSCALE_3_BASE_IDX                                                                1
#define regPA_CL_VPORT_ZOFFSET_3                                                                        0x0126
#define regPA_CL_VPORT_ZOFFSET_3_BASE_IDX                                                               1
#define regPA_CL_VPORT_XSCALE_4                                                                         0x0127
#define regPA_CL_VPORT_XSCALE_4_BASE_IDX                                                                1
#define regPA_CL_VPORT_XOFFSET_4                                                                        0x0128
#define regPA_CL_VPORT_XOFFSET_4_BASE_IDX                                                               1
#define regPA_CL_VPORT_YSCALE_4                                                                         0x0129
#define regPA_CL_VPORT_YSCALE_4_BASE_IDX                                                                1
#define regPA_CL_VPORT_YOFFSET_4                                                                        0x012a
#define regPA_CL_VPORT_YOFFSET_4_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZSCALE_4                                                                         0x012b
#define regPA_CL_VPORT_ZSCALE_4_BASE_IDX                                                                1
#define regPA_CL_VPORT_ZOFFSET_4                                                                        0x012c
#define regPA_CL_VPORT_ZOFFSET_4_BASE_IDX                                                               1
#define regPA_CL_VPORT_XSCALE_5                                                                         0x012d
#define regPA_CL_VPORT_XSCALE_5_BASE_IDX                                                                1
#define regPA_CL_VPORT_XOFFSET_5                                                                        0x012e
#define regPA_CL_VPORT_XOFFSET_5_BASE_IDX                                                               1
#define regPA_CL_VPORT_YSCALE_5                                                                         0x012f
#define regPA_CL_VPORT_YSCALE_5_BASE_IDX                                                                1
#define regPA_CL_VPORT_YOFFSET_5                                                                        0x0130
#define regPA_CL_VPORT_YOFFSET_5_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZSCALE_5                                                                         0x0131
#define regPA_CL_VPORT_ZSCALE_5_BASE_IDX                                                                1
#define regPA_CL_VPORT_ZOFFSET_5                                                                        0x0132
#define regPA_CL_VPORT_ZOFFSET_5_BASE_IDX                                                               1
#define regPA_CL_VPORT_XSCALE_6                                                                         0x0133
#define regPA_CL_VPORT_XSCALE_6_BASE_IDX                                                                1
#define regPA_CL_VPORT_XOFFSET_6                                                                        0x0134
#define regPA_CL_VPORT_XOFFSET_6_BASE_IDX                                                               1
#define regPA_CL_VPORT_YSCALE_6                                                                         0x0135
#define regPA_CL_VPORT_YSCALE_6_BASE_IDX                                                                1
#define regPA_CL_VPORT_YOFFSET_6                                                                        0x0136
#define regPA_CL_VPORT_YOFFSET_6_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZSCALE_6                                                                         0x0137
#define regPA_CL_VPORT_ZSCALE_6_BASE_IDX                                                                1
#define regPA_CL_VPORT_ZOFFSET_6                                                                        0x0138
#define regPA_CL_VPORT_ZOFFSET_6_BASE_IDX                                                               1
#define regPA_CL_VPORT_XSCALE_7                                                                         0x0139
#define regPA_CL_VPORT_XSCALE_7_BASE_IDX                                                                1
#define regPA_CL_VPORT_XOFFSET_7                                                                        0x013a
#define regPA_CL_VPORT_XOFFSET_7_BASE_IDX                                                               1
#define regPA_CL_VPORT_YSCALE_7                                                                         0x013b
#define regPA_CL_VPORT_YSCALE_7_BASE_IDX                                                                1
#define regPA_CL_VPORT_YOFFSET_7                                                                        0x013c
#define regPA_CL_VPORT_YOFFSET_7_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZSCALE_7                                                                         0x013d
#define regPA_CL_VPORT_ZSCALE_7_BASE_IDX                                                                1
#define regPA_CL_VPORT_ZOFFSET_7                                                                        0x013e
#define regPA_CL_VPORT_ZOFFSET_7_BASE_IDX                                                               1
#define regPA_CL_VPORT_XSCALE_8                                                                         0x013f
#define regPA_CL_VPORT_XSCALE_8_BASE_IDX                                                                1
#define regPA_CL_VPORT_XOFFSET_8                                                                        0x0140
#define regPA_CL_VPORT_XOFFSET_8_BASE_IDX                                                               1
#define regPA_CL_VPORT_YSCALE_8                                                                         0x0141
#define regPA_CL_VPORT_YSCALE_8_BASE_IDX                                                                1
#define regPA_CL_VPORT_YOFFSET_8                                                                        0x0142
#define regPA_CL_VPORT_YOFFSET_8_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZSCALE_8                                                                         0x0143
#define regPA_CL_VPORT_ZSCALE_8_BASE_IDX                                                                1
#define regPA_CL_VPORT_ZOFFSET_8                                                                        0x0144
#define regPA_CL_VPORT_ZOFFSET_8_BASE_IDX                                                               1
#define regPA_CL_VPORT_XSCALE_9                                                                         0x0145
#define regPA_CL_VPORT_XSCALE_9_BASE_IDX                                                                1
#define regPA_CL_VPORT_XOFFSET_9                                                                        0x0146
#define regPA_CL_VPORT_XOFFSET_9_BASE_IDX                                                               1
#define regPA_CL_VPORT_YSCALE_9                                                                         0x0147
#define regPA_CL_VPORT_YSCALE_9_BASE_IDX                                                                1
#define regPA_CL_VPORT_YOFFSET_9                                                                        0x0148
#define regPA_CL_VPORT_YOFFSET_9_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZSCALE_9                                                                         0x0149
#define regPA_CL_VPORT_ZSCALE_9_BASE_IDX                                                                1
#define regPA_CL_VPORT_ZOFFSET_9                                                                        0x014a
#define regPA_CL_VPORT_ZOFFSET_9_BASE_IDX                                                               1
#define regPA_CL_VPORT_XSCALE_10                                                                        0x014b
#define regPA_CL_VPORT_XSCALE_10_BASE_IDX                                                               1
#define regPA_CL_VPORT_XOFFSET_10                                                                       0x014c
#define regPA_CL_VPORT_XOFFSET_10_BASE_IDX                                                              1
#define regPA_CL_VPORT_YSCALE_10                                                                        0x014d
#define regPA_CL_VPORT_YSCALE_10_BASE_IDX                                                               1
#define regPA_CL_VPORT_YOFFSET_10                                                                       0x014e
#define regPA_CL_VPORT_YOFFSET_10_BASE_IDX                                                              1
#define regPA_CL_VPORT_ZSCALE_10                                                                        0x014f
#define regPA_CL_VPORT_ZSCALE_10_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZOFFSET_10                                                                       0x0150
#define regPA_CL_VPORT_ZOFFSET_10_BASE_IDX                                                              1
#define regPA_CL_VPORT_XSCALE_11                                                                        0x0151
#define regPA_CL_VPORT_XSCALE_11_BASE_IDX                                                               1
#define regPA_CL_VPORT_XOFFSET_11                                                                       0x0152
#define regPA_CL_VPORT_XOFFSET_11_BASE_IDX                                                              1
#define regPA_CL_VPORT_YSCALE_11                                                                        0x0153
#define regPA_CL_VPORT_YSCALE_11_BASE_IDX                                                               1
#define regPA_CL_VPORT_YOFFSET_11                                                                       0x0154
#define regPA_CL_VPORT_YOFFSET_11_BASE_IDX                                                              1
#define regPA_CL_VPORT_ZSCALE_11                                                                        0x0155
#define regPA_CL_VPORT_ZSCALE_11_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZOFFSET_11                                                                       0x0156
#define regPA_CL_VPORT_ZOFFSET_11_BASE_IDX                                                              1
#define regPA_CL_VPORT_XSCALE_12                                                                        0x0157
#define regPA_CL_VPORT_XSCALE_12_BASE_IDX                                                               1
#define regPA_CL_VPORT_XOFFSET_12                                                                       0x0158
#define regPA_CL_VPORT_XOFFSET_12_BASE_IDX                                                              1
#define regPA_CL_VPORT_YSCALE_12                                                                        0x0159
#define regPA_CL_VPORT_YSCALE_12_BASE_IDX                                                               1
#define regPA_CL_VPORT_YOFFSET_12                                                                       0x015a
#define regPA_CL_VPORT_YOFFSET_12_BASE_IDX                                                              1
#define regPA_CL_VPORT_ZSCALE_12                                                                        0x015b
#define regPA_CL_VPORT_ZSCALE_12_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZOFFSET_12                                                                       0x015c
#define regPA_CL_VPORT_ZOFFSET_12_BASE_IDX                                                              1
#define regPA_CL_VPORT_XSCALE_13                                                                        0x015d
#define regPA_CL_VPORT_XSCALE_13_BASE_IDX                                                               1
#define regPA_CL_VPORT_XOFFSET_13                                                                       0x015e
#define regPA_CL_VPORT_XOFFSET_13_BASE_IDX                                                              1
#define regPA_CL_VPORT_YSCALE_13                                                                        0x015f
#define regPA_CL_VPORT_YSCALE_13_BASE_IDX                                                               1
#define regPA_CL_VPORT_YOFFSET_13                                                                       0x0160
#define regPA_CL_VPORT_YOFFSET_13_BASE_IDX                                                              1
#define regPA_CL_VPORT_ZSCALE_13                                                                        0x0161
#define regPA_CL_VPORT_ZSCALE_13_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZOFFSET_13                                                                       0x0162
#define regPA_CL_VPORT_ZOFFSET_13_BASE_IDX                                                              1
#define regPA_CL_VPORT_XSCALE_14                                                                        0x0163
#define regPA_CL_VPORT_XSCALE_14_BASE_IDX                                                               1
#define regPA_CL_VPORT_XOFFSET_14                                                                       0x0164
#define regPA_CL_VPORT_XOFFSET_14_BASE_IDX                                                              1
#define regPA_CL_VPORT_YSCALE_14                                                                        0x0165
#define regPA_CL_VPORT_YSCALE_14_BASE_IDX                                                               1
#define regPA_CL_VPORT_YOFFSET_14                                                                       0x0166
#define regPA_CL_VPORT_YOFFSET_14_BASE_IDX                                                              1
#define regPA_CL_VPORT_ZSCALE_14                                                                        0x0167
#define regPA_CL_VPORT_ZSCALE_14_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZOFFSET_14                                                                       0x0168
#define regPA_CL_VPORT_ZOFFSET_14_BASE_IDX                                                              1
#define regPA_CL_VPORT_XSCALE_15                                                                        0x0169
#define regPA_CL_VPORT_XSCALE_15_BASE_IDX                                                               1
#define regPA_CL_VPORT_XOFFSET_15                                                                       0x016a
#define regPA_CL_VPORT_XOFFSET_15_BASE_IDX                                                              1
#define regPA_CL_VPORT_YSCALE_15                                                                        0x016b
#define regPA_CL_VPORT_YSCALE_15_BASE_IDX                                                               1
#define regPA_CL_VPORT_YOFFSET_15                                                                       0x016c
#define regPA_CL_VPORT_YOFFSET_15_BASE_IDX                                                              1
#define regPA_CL_VPORT_ZSCALE_15                                                                        0x016d
#define regPA_CL_VPORT_ZSCALE_15_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZOFFSET_15                                                                       0x016e
#define regPA_CL_VPORT_ZOFFSET_15_BASE_IDX                                                              1
#define regPA_CL_UCP_0_X                                                                                0x016f
#define regPA_CL_UCP_0_X_BASE_IDX                                                                       1
#define regPA_CL_UCP_0_Y                                                                                0x0170
#define regPA_CL_UCP_0_Y_BASE_IDX                                                                       1
#define regPA_CL_UCP_0_Z                                                                                0x0171
#define regPA_CL_UCP_0_Z_BASE_IDX                                                                       1
#define regPA_CL_UCP_0_W                                                                                0x0172
#define regPA_CL_UCP_0_W_BASE_IDX                                                                       1
#define regPA_CL_UCP_1_X                                                                                0x0173
#define regPA_CL_UCP_1_X_BASE_IDX                                                                       1
#define regPA_CL_UCP_1_Y                                                                                0x0174
#define regPA_CL_UCP_1_Y_BASE_IDX                                                                       1
#define regPA_CL_UCP_1_Z                                                                                0x0175
#define regPA_CL_UCP_1_Z_BASE_IDX                                                                       1
#define regPA_CL_UCP_1_W                                                                                0x0176
#define regPA_CL_UCP_1_W_BASE_IDX                                                                       1
#define regPA_CL_UCP_2_X                                                                                0x0177
#define regPA_CL_UCP_2_X_BASE_IDX                                                                       1
#define regPA_CL_UCP_2_Y                                                                                0x0178
#define regPA_CL_UCP_2_Y_BASE_IDX                                                                       1
#define regPA_CL_UCP_2_Z                                                                                0x0179
#define regPA_CL_UCP_2_Z_BASE_IDX                                                                       1
#define regPA_CL_UCP_2_W                                                                                0x017a
#define regPA_CL_UCP_2_W_BASE_IDX                                                                       1
#define regPA_CL_UCP_3_X                                                                                0x017b
#define regPA_CL_UCP_3_X_BASE_IDX                                                                       1
#define regPA_CL_UCP_3_Y                                                                                0x017c
#define regPA_CL_UCP_3_Y_BASE_IDX                                                                       1
#define regPA_CL_UCP_3_Z                                                                                0x017d
#define regPA_CL_UCP_3_Z_BASE_IDX                                                                       1
#define regPA_CL_UCP_3_W                                                                                0x017e
#define regPA_CL_UCP_3_W_BASE_IDX                                                                       1
#define regPA_CL_UCP_4_X                                                                                0x017f
#define regPA_CL_UCP_4_X_BASE_IDX                                                                       1
#define regPA_CL_UCP_4_Y                                                                                0x0180
#define regPA_CL_UCP_4_Y_BASE_IDX                                                                       1
#define regPA_CL_UCP_4_Z                                                                                0x0181
#define regPA_CL_UCP_4_Z_BASE_IDX                                                                       1
#define regPA_CL_UCP_4_W                                                                                0x0182
#define regPA_CL_UCP_4_W_BASE_IDX                                                                       1
#define regPA_CL_UCP_5_X                                                                                0x0183
#define regPA_CL_UCP_5_X_BASE_IDX                                                                       1
#define regPA_CL_UCP_5_Y                                                                                0x0184
#define regPA_CL_UCP_5_Y_BASE_IDX                                                                       1
#define regPA_CL_UCP_5_Z                                                                                0x0185
#define regPA_CL_UCP_5_Z_BASE_IDX                                                                       1
#define regPA_CL_UCP_5_W                                                                                0x0186
#define regPA_CL_UCP_5_W_BASE_IDX                                                                       1
#define regPA_CL_PROG_NEAR_CLIP_Z                                                                       0x0187
#define regPA_CL_PROG_NEAR_CLIP_Z_BASE_IDX                                                              1
#define regSPI_PS_INPUT_CNTL_0                                                                          0x0191
#define regSPI_PS_INPUT_CNTL_0_BASE_IDX                                                                 1
#define regSPI_PS_INPUT_CNTL_1                                                                          0x0192
#define regSPI_PS_INPUT_CNTL_1_BASE_IDX                                                                 1
#define regSPI_PS_INPUT_CNTL_2                                                                          0x0193
#define regSPI_PS_INPUT_CNTL_2_BASE_IDX                                                                 1
#define regSPI_PS_INPUT_CNTL_3                                                                          0x0194
#define regSPI_PS_INPUT_CNTL_3_BASE_IDX                                                                 1
#define regSPI_PS_INPUT_CNTL_4                                                                          0x0195
#define regSPI_PS_INPUT_CNTL_4_BASE_IDX                                                                 1
#define regSPI_PS_INPUT_CNTL_5                                                                          0x0196
#define regSPI_PS_INPUT_CNTL_5_BASE_IDX                                                                 1
#define regSPI_PS_INPUT_CNTL_6                                                                          0x0197
#define regSPI_PS_INPUT_CNTL_6_BASE_IDX                                                                 1
#define regSPI_PS_INPUT_CNTL_7                                                                          0x0198
#define regSPI_PS_INPUT_CNTL_7_BASE_IDX                                                                 1
#define regSPI_PS_INPUT_CNTL_8                                                                          0x0199
#define regSPI_PS_INPUT_CNTL_8_BASE_IDX                                                                 1
#define regSPI_PS_INPUT_CNTL_9                                                                          0x019a
#define regSPI_PS_INPUT_CNTL_9_BASE_IDX                                                                 1
#define regSPI_PS_INPUT_CNTL_10                                                                         0x019b
#define regSPI_PS_INPUT_CNTL_10_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_11                                                                         0x019c
#define regSPI_PS_INPUT_CNTL_11_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_12                                                                         0x019d
#define regSPI_PS_INPUT_CNTL_12_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_13                                                                         0x019e
#define regSPI_PS_INPUT_CNTL_13_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_14                                                                         0x019f
#define regSPI_PS_INPUT_CNTL_14_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_15                                                                         0x01a0
#define regSPI_PS_INPUT_CNTL_15_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_16                                                                         0x01a1
#define regSPI_PS_INPUT_CNTL_16_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_17                                                                         0x01a2
#define regSPI_PS_INPUT_CNTL_17_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_18                                                                         0x01a3
#define regSPI_PS_INPUT_CNTL_18_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_19                                                                         0x01a4
#define regSPI_PS_INPUT_CNTL_19_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_20                                                                         0x01a5
#define regSPI_PS_INPUT_CNTL_20_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_21                                                                         0x01a6
#define regSPI_PS_INPUT_CNTL_21_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_22                                                                         0x01a7
#define regSPI_PS_INPUT_CNTL_22_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_23                                                                         0x01a8
#define regSPI_PS_INPUT_CNTL_23_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_24                                                                         0x01a9
#define regSPI_PS_INPUT_CNTL_24_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_25                                                                         0x01aa
#define regSPI_PS_INPUT_CNTL_25_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_26                                                                         0x01ab
#define regSPI_PS_INPUT_CNTL_26_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_27                                                                         0x01ac
#define regSPI_PS_INPUT_CNTL_27_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_28                                                                         0x01ad
#define regSPI_PS_INPUT_CNTL_28_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_29                                                                         0x01ae
#define regSPI_PS_INPUT_CNTL_29_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_30                                                                         0x01af
#define regSPI_PS_INPUT_CNTL_30_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_31                                                                         0x01b0
#define regSPI_PS_INPUT_CNTL_31_BASE_IDX                                                                1
#define regSPI_VS_OUT_CONFIG                                                                            0x01b1
#define regSPI_VS_OUT_CONFIG_BASE_IDX                                                                   1
#define regSPI_PS_INPUT_ENA                                                                             0x01b3
#define regSPI_PS_INPUT_ENA_BASE_IDX                                                                    1
#define regSPI_PS_INPUT_ADDR                                                                            0x01b4
#define regSPI_PS_INPUT_ADDR_BASE_IDX                                                                   1
#define regSPI_INTERP_CONTROL_0                                                                         0x01b5
#define regSPI_INTERP_CONTROL_0_BASE_IDX                                                                1
#define regSPI_PS_IN_CONTROL                                                                            0x01b6
#define regSPI_PS_IN_CONTROL_BASE_IDX                                                                   1
#define regSPI_BARYC_CNTL                                                                               0x01b8
#define regSPI_BARYC_CNTL_BASE_IDX                                                                      1
#define regSPI_TMPRING_SIZE                                                                             0x01ba
#define regSPI_TMPRING_SIZE_BASE_IDX                                                                    1
#define regSPI_SHADER_POS_FORMAT                                                                        0x01c3
#define regSPI_SHADER_POS_FORMAT_BASE_IDX                                                               1
#define regSPI_SHADER_Z_FORMAT                                                                          0x01c4
#define regSPI_SHADER_Z_FORMAT_BASE_IDX                                                                 1
#define regSPI_SHADER_COL_FORMAT                                                                        0x01c5
#define regSPI_SHADER_COL_FORMAT_BASE_IDX                                                               1
#define regCB_BLEND0_CONTROL                                                                            0x01e0
#define regCB_BLEND0_CONTROL_BASE_IDX                                                                   1
#define regCB_BLEND1_CONTROL                                                                            0x01e1
#define regCB_BLEND1_CONTROL_BASE_IDX                                                                   1
#define regCB_BLEND2_CONTROL                                                                            0x01e2
#define regCB_BLEND2_CONTROL_BASE_IDX                                                                   1
#define regCB_BLEND3_CONTROL                                                                            0x01e3
#define regCB_BLEND3_CONTROL_BASE_IDX                                                                   1
#define regCB_BLEND4_CONTROL                                                                            0x01e4
#define regCB_BLEND4_CONTROL_BASE_IDX                                                                   1
#define regCB_BLEND5_CONTROL                                                                            0x01e5
#define regCB_BLEND5_CONTROL_BASE_IDX                                                                   1
#define regCB_BLEND6_CONTROL                                                                            0x01e6
#define regCB_BLEND6_CONTROL_BASE_IDX                                                                   1
#define regCB_BLEND7_CONTROL                                                                            0x01e7
#define regCB_BLEND7_CONTROL_BASE_IDX                                                                   1
#define regCB_MRT0_EPITCH                                                                               0x01e8
#define regCB_MRT0_EPITCH_BASE_IDX                                                                      1
#define regCB_MRT1_EPITCH                                                                               0x01e9
#define regCB_MRT1_EPITCH_BASE_IDX                                                                      1
#define regCB_MRT2_EPITCH                                                                               0x01ea
#define regCB_MRT2_EPITCH_BASE_IDX                                                                      1
#define regCB_MRT3_EPITCH                                                                               0x01eb
#define regCB_MRT3_EPITCH_BASE_IDX                                                                      1
#define regCB_MRT4_EPITCH                                                                               0x01ec
#define regCB_MRT4_EPITCH_BASE_IDX                                                                      1
#define regCB_MRT5_EPITCH                                                                               0x01ed
#define regCB_MRT5_EPITCH_BASE_IDX                                                                      1
#define regCB_MRT6_EPITCH                                                                               0x01ee
#define regCB_MRT6_EPITCH_BASE_IDX                                                                      1
#define regCB_MRT7_EPITCH                                                                               0x01ef
#define regCB_MRT7_EPITCH_BASE_IDX                                                                      1
#define regCS_COPY_STATE                                                                                0x01f3
#define regCS_COPY_STATE_BASE_IDX                                                                       1
#define regGFX_COPY_STATE                                                                               0x01f4
#define regGFX_COPY_STATE_BASE_IDX                                                                      1
#define regPA_CL_POINT_X_RAD                                                                            0x01f5
#define regPA_CL_POINT_X_RAD_BASE_IDX                                                                   1
#define regPA_CL_POINT_Y_RAD                                                                            0x01f6
#define regPA_CL_POINT_Y_RAD_BASE_IDX                                                                   1
#define regPA_CL_POINT_SIZE                                                                             0x01f7
#define regPA_CL_POINT_SIZE_BASE_IDX                                                                    1
#define regPA_CL_POINT_CULL_RAD                                                                         0x01f8
#define regPA_CL_POINT_CULL_RAD_BASE_IDX                                                                1
#define regVGT_DMA_BASE_HI                                                                              0x01f9
#define regVGT_DMA_BASE_HI_BASE_IDX                                                                     1
#define regVGT_DMA_BASE                                                                                 0x01fa
#define regVGT_DMA_BASE_BASE_IDX                                                                        1
#define regVGT_DRAW_INITIATOR                                                                           0x01fc
#define regVGT_DRAW_INITIATOR_BASE_IDX                                                                  1
#define regVGT_IMMED_DATA                                                                               0x01fd
#define regVGT_IMMED_DATA_BASE_IDX                                                                      1
#define regVGT_EVENT_ADDRESS_REG                                                                        0x01fe
#define regVGT_EVENT_ADDRESS_REG_BASE_IDX                                                               1
#define regDB_DEPTH_CONTROL                                                                             0x0200
#define regDB_DEPTH_CONTROL_BASE_IDX                                                                    1
#define regDB_EQAA                                                                                      0x0201
#define regDB_EQAA_BASE_IDX                                                                             1
#define regCB_COLOR_CONTROL                                                                             0x0202
#define regCB_COLOR_CONTROL_BASE_IDX                                                                    1
#define regDB_SHADER_CONTROL                                                                            0x0203
#define regDB_SHADER_CONTROL_BASE_IDX                                                                   1
#define regPA_CL_CLIP_CNTL                                                                              0x0204
#define regPA_CL_CLIP_CNTL_BASE_IDX                                                                     1
#define regPA_SU_SC_MODE_CNTL                                                                           0x0205
#define regPA_SU_SC_MODE_CNTL_BASE_IDX                                                                  1
#define regPA_CL_VTE_CNTL                                                                               0x0206
#define regPA_CL_VTE_CNTL_BASE_IDX                                                                      1
#define regPA_CL_VS_OUT_CNTL                                                                            0x0207
#define regPA_CL_VS_OUT_CNTL_BASE_IDX                                                                   1
#define regPA_CL_NANINF_CNTL                                                                            0x0208
#define regPA_CL_NANINF_CNTL_BASE_IDX                                                                   1
#define regPA_SU_LINE_STIPPLE_CNTL                                                                      0x0209
#define regPA_SU_LINE_STIPPLE_CNTL_BASE_IDX                                                             1
#define regPA_SU_LINE_STIPPLE_SCALE                                                                     0x020a
#define regPA_SU_LINE_STIPPLE_SCALE_BASE_IDX                                                            1
#define regPA_SU_PRIM_FILTER_CNTL                                                                       0x020b
#define regPA_SU_PRIM_FILTER_CNTL_BASE_IDX                                                              1
#define regPA_SU_SMALL_PRIM_FILTER_CNTL                                                                 0x020c
#define regPA_SU_SMALL_PRIM_FILTER_CNTL_BASE_IDX                                                        1
#define regPA_CL_OBJPRIM_ID_CNTL                                                                        0x020d
#define regPA_CL_OBJPRIM_ID_CNTL_BASE_IDX                                                               1
#define regPA_CL_NGG_CNTL                                                                               0x020e
#define regPA_CL_NGG_CNTL_BASE_IDX                                                                      1
#define regPA_SU_OVER_RASTERIZATION_CNTL                                                                0x020f
#define regPA_SU_OVER_RASTERIZATION_CNTL_BASE_IDX                                                       1
#define regPA_STEREO_CNTL                                                                               0x0210
#define regPA_STEREO_CNTL_BASE_IDX                                                                      1
#define regPA_SU_POINT_SIZE                                                                             0x0280
#define regPA_SU_POINT_SIZE_BASE_IDX                                                                    1
#define regPA_SU_POINT_MINMAX                                                                           0x0281
#define regPA_SU_POINT_MINMAX_BASE_IDX                                                                  1
#define regPA_SU_LINE_CNTL                                                                              0x0282
#define regPA_SU_LINE_CNTL_BASE_IDX                                                                     1
#define regPA_SC_LINE_STIPPLE                                                                           0x0283
#define regPA_SC_LINE_STIPPLE_BASE_IDX                                                                  1
#define regVGT_OUTPUT_PATH_CNTL                                                                         0x0284
#define regVGT_OUTPUT_PATH_CNTL_BASE_IDX                                                                1
#define regVGT_HOS_CNTL                                                                                 0x0285
#define regVGT_HOS_CNTL_BASE_IDX                                                                        1
#define regVGT_HOS_MAX_TESS_LEVEL                                                                       0x0286
#define regVGT_HOS_MAX_TESS_LEVEL_BASE_IDX                                                              1
#define regVGT_HOS_MIN_TESS_LEVEL                                                                       0x0287
#define regVGT_HOS_MIN_TESS_LEVEL_BASE_IDX                                                              1
#define regVGT_HOS_REUSE_DEPTH                                                                          0x0288
#define regVGT_HOS_REUSE_DEPTH_BASE_IDX                                                                 1
#define regVGT_GROUP_PRIM_TYPE                                                                          0x0289
#define regVGT_GROUP_PRIM_TYPE_BASE_IDX                                                                 1
#define regVGT_GROUP_FIRST_DECR                                                                         0x028a
#define regVGT_GROUP_FIRST_DECR_BASE_IDX                                                                1
#define regVGT_GROUP_DECR                                                                               0x028b
#define regVGT_GROUP_DECR_BASE_IDX                                                                      1
#define regVGT_GROUP_VECT_0_CNTL                                                                        0x028c
#define regVGT_GROUP_VECT_0_CNTL_BASE_IDX                                                               1
#define regVGT_GROUP_VECT_1_CNTL                                                                        0x028d
#define regVGT_GROUP_VECT_1_CNTL_BASE_IDX                                                               1
#define regVGT_GROUP_VECT_0_FMT_CNTL                                                                    0x028e
#define regVGT_GROUP_VECT_0_FMT_CNTL_BASE_IDX                                                           1
#define regVGT_GROUP_VECT_1_FMT_CNTL                                                                    0x028f
#define regVGT_GROUP_VECT_1_FMT_CNTL_BASE_IDX                                                           1
#define regVGT_GS_MODE                                                                                  0x0290
#define regVGT_GS_MODE_BASE_IDX                                                                         1
#define regVGT_GS_ONCHIP_CNTL                                                                           0x0291
#define regVGT_GS_ONCHIP_CNTL_BASE_IDX                                                                  1
#define regPA_SC_MODE_CNTL_0                                                                            0x0292
#define regPA_SC_MODE_CNTL_0_BASE_IDX                                                                   1
#define regPA_SC_MODE_CNTL_1                                                                            0x0293
#define regPA_SC_MODE_CNTL_1_BASE_IDX                                                                   1
#define regVGT_ENHANCE                                                                                  0x0294
#define regVGT_ENHANCE_BASE_IDX                                                                         1
#define regVGT_GS_PER_ES                                                                                0x0295
#define regVGT_GS_PER_ES_BASE_IDX                                                                       1
#define regVGT_ES_PER_GS                                                                                0x0296
#define regVGT_ES_PER_GS_BASE_IDX                                                                       1
#define regVGT_GS_PER_VS                                                                                0x0297
#define regVGT_GS_PER_VS_BASE_IDX                                                                       1
#define regVGT_GSVS_RING_OFFSET_1                                                                       0x0298
#define regVGT_GSVS_RING_OFFSET_1_BASE_IDX                                                              1
#define regVGT_GSVS_RING_OFFSET_2                                                                       0x0299
#define regVGT_GSVS_RING_OFFSET_2_BASE_IDX                                                              1
#define regVGT_GSVS_RING_OFFSET_3                                                                       0x029a
#define regVGT_GSVS_RING_OFFSET_3_BASE_IDX                                                              1
#define regVGT_GS_OUT_PRIM_TYPE                                                                         0x029b
#define regVGT_GS_OUT_PRIM_TYPE_BASE_IDX                                                                1
#define regIA_ENHANCE                                                                                   0x029c
#define regIA_ENHANCE_BASE_IDX                                                                          1
#define regVGT_DMA_SIZE                                                                                 0x029d
#define regVGT_DMA_SIZE_BASE_IDX                                                                        1
#define regVGT_DMA_MAX_SIZE                                                                             0x029e
#define regVGT_DMA_MAX_SIZE_BASE_IDX                                                                    1
#define regVGT_DMA_INDEX_TYPE                                                                           0x029f
#define regVGT_DMA_INDEX_TYPE_BASE_IDX                                                                  1
#define regWD_ENHANCE                                                                                   0x02a0
#define regWD_ENHANCE_BASE_IDX                                                                          1
#define regVGT_PRIMITIVEID_EN                                                                           0x02a1
#define regVGT_PRIMITIVEID_EN_BASE_IDX                                                                  1
#define regVGT_DMA_NUM_INSTANCES                                                                        0x02a2
#define regVGT_DMA_NUM_INSTANCES_BASE_IDX                                                               1
#define regVGT_PRIMITIVEID_RESET                                                                        0x02a3
#define regVGT_PRIMITIVEID_RESET_BASE_IDX                                                               1
#define regVGT_EVENT_INITIATOR                                                                          0x02a4
#define regVGT_EVENT_INITIATOR_BASE_IDX                                                                 1
#define regVGT_GS_MAX_PRIMS_PER_SUBGROUP                                                                0x02a5
#define regVGT_GS_MAX_PRIMS_PER_SUBGROUP_BASE_IDX                                                       1
#define regVGT_DRAW_PAYLOAD_CNTL                                                                        0x02a6
#define regVGT_DRAW_PAYLOAD_CNTL_BASE_IDX                                                               1
#define regVGT_INSTANCE_STEP_RATE_0                                                                     0x02a8
#define regVGT_INSTANCE_STEP_RATE_0_BASE_IDX                                                            1
#define regVGT_INSTANCE_STEP_RATE_1                                                                     0x02a9
#define regVGT_INSTANCE_STEP_RATE_1_BASE_IDX                                                            1
#define regIA_MULTI_VGT_PARAM_BC                                                                        0x02aa
#define regIA_MULTI_VGT_PARAM_BC_BASE_IDX                                                               1
#define regVGT_ESGS_RING_ITEMSIZE                                                                       0x02ab
#define regVGT_ESGS_RING_ITEMSIZE_BASE_IDX                                                              1
#define regVGT_GSVS_RING_ITEMSIZE                                                                       0x02ac
#define regVGT_GSVS_RING_ITEMSIZE_BASE_IDX                                                              1
#define regVGT_REUSE_OFF                                                                                0x02ad
#define regVGT_REUSE_OFF_BASE_IDX                                                                       1
#define regVGT_VTX_CNT_EN                                                                               0x02ae
#define regVGT_VTX_CNT_EN_BASE_IDX                                                                      1
#define regDB_HTILE_SURFACE                                                                             0x02af
#define regDB_HTILE_SURFACE_BASE_IDX                                                                    1
#define regDB_SRESULTS_COMPARE_STATE0                                                                   0x02b0
#define regDB_SRESULTS_COMPARE_STATE0_BASE_IDX                                                          1
#define regDB_SRESULTS_COMPARE_STATE1                                                                   0x02b1
#define regDB_SRESULTS_COMPARE_STATE1_BASE_IDX                                                          1
#define regDB_PRELOAD_CONTROL                                                                           0x02b2
#define regDB_PRELOAD_CONTROL_BASE_IDX                                                                  1
#define regVGT_STRMOUT_BUFFER_SIZE_0                                                                    0x02b4
#define regVGT_STRMOUT_BUFFER_SIZE_0_BASE_IDX                                                           1
#define regVGT_STRMOUT_VTX_STRIDE_0                                                                     0x02b5
#define regVGT_STRMOUT_VTX_STRIDE_0_BASE_IDX                                                            1
#define regVGT_STRMOUT_BUFFER_OFFSET_0                                                                  0x02b7
#define regVGT_STRMOUT_BUFFER_OFFSET_0_BASE_IDX                                                         1
#define regVGT_STRMOUT_BUFFER_SIZE_1                                                                    0x02b8
#define regVGT_STRMOUT_BUFFER_SIZE_1_BASE_IDX                                                           1
#define regVGT_STRMOUT_VTX_STRIDE_1                                                                     0x02b9
#define regVGT_STRMOUT_VTX_STRIDE_1_BASE_IDX                                                            1
#define regVGT_STRMOUT_BUFFER_OFFSET_1                                                                  0x02bb
#define regVGT_STRMOUT_BUFFER_OFFSET_1_BASE_IDX                                                         1
#define regVGT_STRMOUT_BUFFER_SIZE_2                                                                    0x02bc
#define regVGT_STRMOUT_BUFFER_SIZE_2_BASE_IDX                                                           1
#define regVGT_STRMOUT_VTX_STRIDE_2                                                                     0x02bd
#define regVGT_STRMOUT_VTX_STRIDE_2_BASE_IDX                                                            1
#define regVGT_STRMOUT_BUFFER_OFFSET_2                                                                  0x02bf
#define regVGT_STRMOUT_BUFFER_OFFSET_2_BASE_IDX                                                         1
#define regVGT_STRMOUT_BUFFER_SIZE_3                                                                    0x02c0
#define regVGT_STRMOUT_BUFFER_SIZE_3_BASE_IDX                                                           1
#define regVGT_STRMOUT_VTX_STRIDE_3                                                                     0x02c1
#define regVGT_STRMOUT_VTX_STRIDE_3_BASE_IDX                                                            1
#define regVGT_STRMOUT_BUFFER_OFFSET_3                                                                  0x02c3
#define regVGT_STRMOUT_BUFFER_OFFSET_3_BASE_IDX                                                         1
#define regVGT_STRMOUT_DRAW_OPAQUE_OFFSET                                                               0x02ca
#define regVGT_STRMOUT_DRAW_OPAQUE_OFFSET_BASE_IDX                                                      1
#define regVGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE                                                   0x02cb
#define regVGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE_BASE_IDX                                          1
#define regVGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE                                                        0x02cc
#define regVGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE_BASE_IDX                                               1
#define regVGT_GS_MAX_VERT_OUT                                                                          0x02ce
#define regVGT_GS_MAX_VERT_OUT_BASE_IDX                                                                 1
#define regVGT_TESS_DISTRIBUTION                                                                        0x02d4
#define regVGT_TESS_DISTRIBUTION_BASE_IDX                                                               1
#define regVGT_SHADER_STAGES_EN                                                                         0x02d5
#define regVGT_SHADER_STAGES_EN_BASE_IDX                                                                1
#define regVGT_LS_HS_CONFIG                                                                             0x02d6
#define regVGT_LS_HS_CONFIG_BASE_IDX                                                                    1
#define regVGT_GS_VERT_ITEMSIZE                                                                         0x02d7
#define regVGT_GS_VERT_ITEMSIZE_BASE_IDX                                                                1
#define regVGT_GS_VERT_ITEMSIZE_1                                                                       0x02d8
#define regVGT_GS_VERT_ITEMSIZE_1_BASE_IDX                                                              1
#define regVGT_GS_VERT_ITEMSIZE_2                                                                       0x02d9
#define regVGT_GS_VERT_ITEMSIZE_2_BASE_IDX                                                              1
#define regVGT_GS_VERT_ITEMSIZE_3                                                                       0x02da
#define regVGT_GS_VERT_ITEMSIZE_3_BASE_IDX                                                              1
#define regVGT_TF_PARAM                                                                                 0x02db
#define regVGT_TF_PARAM_BASE_IDX                                                                        1
#define regDB_ALPHA_TO_MASK                                                                             0x02dc
#define regDB_ALPHA_TO_MASK_BASE_IDX                                                                    1
#define regVGT_DISPATCH_DRAW_INDEX                                                                      0x02dd
#define regVGT_DISPATCH_DRAW_INDEX_BASE_IDX                                                             1
#define regPA_SU_POLY_OFFSET_DB_FMT_CNTL                                                                0x02de
#define regPA_SU_POLY_OFFSET_DB_FMT_CNTL_BASE_IDX                                                       1
#define regPA_SU_POLY_OFFSET_CLAMP                                                                      0x02df
#define regPA_SU_POLY_OFFSET_CLAMP_BASE_IDX                                                             1
#define regPA_SU_POLY_OFFSET_FRONT_SCALE                                                                0x02e0
#define regPA_SU_POLY_OFFSET_FRONT_SCALE_BASE_IDX                                                       1
#define regPA_SU_POLY_OFFSET_FRONT_OFFSET                                                               0x02e1
#define regPA_SU_POLY_OFFSET_FRONT_OFFSET_BASE_IDX                                                      1
#define regPA_SU_POLY_OFFSET_BACK_SCALE                                                                 0x02e2
#define regPA_SU_POLY_OFFSET_BACK_SCALE_BASE_IDX                                                        1
#define regPA_SU_POLY_OFFSET_BACK_OFFSET                                                                0x02e3
#define regPA_SU_POLY_OFFSET_BACK_OFFSET_BASE_IDX                                                       1
#define regVGT_GS_INSTANCE_CNT                                                                          0x02e4
#define regVGT_GS_INSTANCE_CNT_BASE_IDX                                                                 1
#define regVGT_STRMOUT_CONFIG                                                                           0x02e5
#define regVGT_STRMOUT_CONFIG_BASE_IDX                                                                  1
#define regVGT_STRMOUT_BUFFER_CONFIG                                                                    0x02e6
#define regVGT_STRMOUT_BUFFER_CONFIG_BASE_IDX                                                           1
#define regVGT_DMA_EVENT_INITIATOR                                                                      0x02e7
#define regVGT_DMA_EVENT_INITIATOR_BASE_IDX                                                             1
#define regPA_SC_CENTROID_PRIORITY_0                                                                    0x02f5
#define regPA_SC_CENTROID_PRIORITY_0_BASE_IDX                                                           1
#define regPA_SC_CENTROID_PRIORITY_1                                                                    0x02f6
#define regPA_SC_CENTROID_PRIORITY_1_BASE_IDX                                                           1
#define regPA_SC_LINE_CNTL                                                                              0x02f7
#define regPA_SC_LINE_CNTL_BASE_IDX                                                                     1
#define regPA_SC_AA_CONFIG                                                                              0x02f8
#define regPA_SC_AA_CONFIG_BASE_IDX                                                                     1
#define regPA_SU_VTX_CNTL                                                                               0x02f9
#define regPA_SU_VTX_CNTL_BASE_IDX                                                                      1
#define regPA_CL_GB_VERT_CLIP_ADJ                                                                       0x02fa
#define regPA_CL_GB_VERT_CLIP_ADJ_BASE_IDX                                                              1
#define regPA_CL_GB_VERT_DISC_ADJ                                                                       0x02fb
#define regPA_CL_GB_VERT_DISC_ADJ_BASE_IDX                                                              1
#define regPA_CL_GB_HORZ_CLIP_ADJ                                                                       0x02fc
#define regPA_CL_GB_HORZ_CLIP_ADJ_BASE_IDX                                                              1
#define regPA_CL_GB_HORZ_DISC_ADJ                                                                       0x02fd
#define regPA_CL_GB_HORZ_DISC_ADJ_BASE_IDX                                                              1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0                                                            0x02fe
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1                                                            0x02ff
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2                                                            0x0300
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3                                                            0x0301
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0                                                            0x0302
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1                                                            0x0303
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2                                                            0x0304
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3                                                            0x0305
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0                                                            0x0306
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1                                                            0x0307
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2                                                            0x0308
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3                                                            0x0309
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0                                                            0x030a
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1                                                            0x030b
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2                                                            0x030c
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3                                                            0x030d
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3_BASE_IDX                                                   1
#define regPA_SC_AA_MASK_X0Y0_X1Y0                                                                      0x030e
#define regPA_SC_AA_MASK_X0Y0_X1Y0_BASE_IDX                                                             1
#define regPA_SC_AA_MASK_X0Y1_X1Y1                                                                      0x030f
#define regPA_SC_AA_MASK_X0Y1_X1Y1_BASE_IDX                                                             1
#define regPA_SC_SHADER_CONTROL                                                                         0x0310
#define regPA_SC_SHADER_CONTROL_BASE_IDX                                                                1
#define regPA_SC_BINNER_CNTL_0                                                                          0x0311
#define regPA_SC_BINNER_CNTL_0_BASE_IDX                                                                 1
#define regPA_SC_BINNER_CNTL_1                                                                          0x0312
#define regPA_SC_BINNER_CNTL_1_BASE_IDX                                                                 1
#define regPA_SC_CONSERVATIVE_RASTERIZATION_CNTL                                                        0x0313
#define regPA_SC_CONSERVATIVE_RASTERIZATION_CNTL_BASE_IDX                                               1
#define regPA_SC_NGG_MODE_CNTL                                                                          0x0314
#define regPA_SC_NGG_MODE_CNTL_BASE_IDX                                                                 1
#define regVGT_VERTEX_REUSE_BLOCK_CNTL                                                                  0x0316
#define regVGT_VERTEX_REUSE_BLOCK_CNTL_BASE_IDX                                                         1
#define regVGT_OUT_DEALLOC_CNTL                                                                         0x0317
#define regVGT_OUT_DEALLOC_CNTL_BASE_IDX                                                                1
#define regCB_COLOR0_BASE                                                                               0x0318
#define regCB_COLOR0_BASE_BASE_IDX                                                                      1
#define regCB_COLOR0_BASE_EXT                                                                           0x0319
#define regCB_COLOR0_BASE_EXT_BASE_IDX                                                                  1
#define regCB_COLOR0_ATTRIB2                                                                            0x031a
#define regCB_COLOR0_ATTRIB2_BASE_IDX                                                                   1
#define regCB_COLOR0_VIEW                                                                               0x031b
#define regCB_COLOR0_VIEW_BASE_IDX                                                                      1
#define regCB_COLOR0_INFO                                                                               0x031c
#define regCB_COLOR0_INFO_BASE_IDX                                                                      1
#define regCB_COLOR0_ATTRIB                                                                             0x031d
#define regCB_COLOR0_ATTRIB_BASE_IDX                                                                    1
#define regCB_COLOR0_DCC_CONTROL                                                                        0x031e
#define regCB_COLOR0_DCC_CONTROL_BASE_IDX                                                               1
#define regCB_COLOR0_CMASK                                                                              0x031f
#define regCB_COLOR0_CMASK_BASE_IDX                                                                     1
#define regCB_COLOR0_CMASK_BASE_EXT                                                                     0x0320
#define regCB_COLOR0_CMASK_BASE_EXT_BASE_IDX                                                            1
#define regCB_COLOR0_FMASK                                                                              0x0321
#define regCB_COLOR0_FMASK_BASE_IDX                                                                     1
#define regCB_COLOR0_FMASK_BASE_EXT                                                                     0x0322
#define regCB_COLOR0_FMASK_BASE_EXT_BASE_IDX                                                            1
#define regCB_COLOR0_CLEAR_WORD0                                                                        0x0323
#define regCB_COLOR0_CLEAR_WORD0_BASE_IDX                                                               1
#define regCB_COLOR0_CLEAR_WORD1                                                                        0x0324
#define regCB_COLOR0_CLEAR_WORD1_BASE_IDX                                                               1
#define regCB_COLOR0_DCC_BASE                                                                           0x0325
#define regCB_COLOR0_DCC_BASE_BASE_IDX                                                                  1
#define regCB_COLOR0_DCC_BASE_EXT                                                                       0x0326
#define regCB_COLOR0_DCC_BASE_EXT_BASE_IDX                                                              1
#define regCB_COLOR1_BASE                                                                               0x0327
#define regCB_COLOR1_BASE_BASE_IDX                                                                      1
#define regCB_COLOR1_BASE_EXT                                                                           0x0328
#define regCB_COLOR1_BASE_EXT_BASE_IDX                                                                  1
#define regCB_COLOR1_ATTRIB2                                                                            0x0329
#define regCB_COLOR1_ATTRIB2_BASE_IDX                                                                   1
#define regCB_COLOR1_VIEW                                                                               0x032a
#define regCB_COLOR1_VIEW_BASE_IDX                                                                      1
#define regCB_COLOR1_INFO                                                                               0x032b
#define regCB_COLOR1_INFO_BASE_IDX                                                                      1
#define regCB_COLOR1_ATTRIB                                                                             0x032c
#define regCB_COLOR1_ATTRIB_BASE_IDX                                                                    1
#define regCB_COLOR1_DCC_CONTROL                                                                        0x032d
#define regCB_COLOR1_DCC_CONTROL_BASE_IDX                                                               1
#define regCB_COLOR1_CMASK                                                                              0x032e
#define regCB_COLOR1_CMASK_BASE_IDX                                                                     1
#define regCB_COLOR1_CMASK_BASE_EXT                                                                     0x032f
#define regCB_COLOR1_CMASK_BASE_EXT_BASE_IDX                                                            1
#define regCB_COLOR1_FMASK                                                                              0x0330
#define regCB_COLOR1_FMASK_BASE_IDX                                                                     1
#define regCB_COLOR1_FMASK_BASE_EXT                                                                     0x0331
#define regCB_COLOR1_FMASK_BASE_EXT_BASE_IDX                                                            1
#define regCB_COLOR1_CLEAR_WORD0                                                                        0x0332
#define regCB_COLOR1_CLEAR_WORD0_BASE_IDX                                                               1
#define regCB_COLOR1_CLEAR_WORD1                                                                        0x0333
#define regCB_COLOR1_CLEAR_WORD1_BASE_IDX                                                               1
#define regCB_COLOR1_DCC_BASE                                                                           0x0334
#define regCB_COLOR1_DCC_BASE_BASE_IDX                                                                  1
#define regCB_COLOR1_DCC_BASE_EXT                                                                       0x0335
#define regCB_COLOR1_DCC_BASE_EXT_BASE_IDX                                                              1
#define regCB_COLOR2_BASE                                                                               0x0336
#define regCB_COLOR2_BASE_BASE_IDX                                                                      1
#define regCB_COLOR2_BASE_EXT                                                                           0x0337
#define regCB_COLOR2_BASE_EXT_BASE_IDX                                                                  1
#define regCB_COLOR2_ATTRIB2                                                                            0x0338
#define regCB_COLOR2_ATTRIB2_BASE_IDX                                                                   1
#define regCB_COLOR2_VIEW                                                                               0x0339
#define regCB_COLOR2_VIEW_BASE_IDX                                                                      1
#define regCB_COLOR2_INFO                                                                               0x033a
#define regCB_COLOR2_INFO_BASE_IDX                                                                      1
#define regCB_COLOR2_ATTRIB                                                                             0x033b
#define regCB_COLOR2_ATTRIB_BASE_IDX                                                                    1
#define regCB_COLOR2_DCC_CONTROL                                                                        0x033c
#define regCB_COLOR2_DCC_CONTROL_BASE_IDX                                                               1
#define regCB_COLOR2_CMASK                                                                              0x033d
#define regCB_COLOR2_CMASK_BASE_IDX                                                                     1
#define regCB_COLOR2_CMASK_BASE_EXT                                                                     0x033e
#define regCB_COLOR2_CMASK_BASE_EXT_BASE_IDX                                                            1
#define regCB_COLOR2_FMASK                                                                              0x033f
#define regCB_COLOR2_FMASK_BASE_IDX                                                                     1
#define regCB_COLOR2_FMASK_BASE_EXT                                                                     0x0340
#define regCB_COLOR2_FMASK_BASE_EXT_BASE_IDX                                                            1
#define regCB_COLOR2_CLEAR_WORD0                                                                        0x0341
#define regCB_COLOR2_CLEAR_WORD0_BASE_IDX                                                               1
#define regCB_COLOR2_CLEAR_WORD1                                                                        0x0342
#define regCB_COLOR2_CLEAR_WORD1_BASE_IDX                                                               1
#define regCB_COLOR2_DCC_BASE                                                                           0x0343
#define regCB_COLOR2_DCC_BASE_BASE_IDX                                                                  1
#define regCB_COLOR2_DCC_BASE_EXT                                                                       0x0344
#define regCB_COLOR2_DCC_BASE_EXT_BASE_IDX                                                              1
#define regCB_COLOR3_BASE                                                                               0x0345
#define regCB_COLOR3_BASE_BASE_IDX                                                                      1
#define regCB_COLOR3_BASE_EXT                                                                           0x0346
#define regCB_COLOR3_BASE_EXT_BASE_IDX                                                                  1
#define regCB_COLOR3_ATTRIB2                                                                            0x0347
#define regCB_COLOR3_ATTRIB2_BASE_IDX                                                                   1
#define regCB_COLOR3_VIEW                                                                               0x0348
#define regCB_COLOR3_VIEW_BASE_IDX                                                                      1
#define regCB_COLOR3_INFO                                                                               0x0349
#define regCB_COLOR3_INFO_BASE_IDX                                                                      1
#define regCB_COLOR3_ATTRIB                                                                             0x034a
#define regCB_COLOR3_ATTRIB_BASE_IDX                                                                    1
#define regCB_COLOR3_DCC_CONTROL                                                                        0x034b
#define regCB_COLOR3_DCC_CONTROL_BASE_IDX                                                               1
#define regCB_COLOR3_CMASK                                                                              0x034c
#define regCB_COLOR3_CMASK_BASE_IDX                                                                     1
#define regCB_COLOR3_CMASK_BASE_EXT                                                                     0x034d
#define regCB_COLOR3_CMASK_BASE_EXT_BASE_IDX                                                            1
#define regCB_COLOR3_FMASK                                                                              0x034e
#define regCB_COLOR3_FMASK_BASE_IDX                                                                     1
#define regCB_COLOR3_FMASK_BASE_EXT                                                                     0x034f
#define regCB_COLOR3_FMASK_BASE_EXT_BASE_IDX                                                            1
#define regCB_COLOR3_CLEAR_WORD0                                                                        0x0350
#define regCB_COLOR3_CLEAR_WORD0_BASE_IDX                                                               1
#define regCB_COLOR3_CLEAR_WORD1                                                                        0x0351
#define regCB_COLOR3_CLEAR_WORD1_BASE_IDX                                                               1
#define regCB_COLOR3_DCC_BASE                                                                           0x0352
#define regCB_COLOR3_DCC_BASE_BASE_IDX                                                                  1
#define regCB_COLOR3_DCC_BASE_EXT                                                                       0x0353
#define regCB_COLOR3_DCC_BASE_EXT_BASE_IDX                                                              1
#define regCB_COLOR4_BASE                                                                               0x0354
#define regCB_COLOR4_BASE_BASE_IDX                                                                      1
#define regCB_COLOR4_BASE_EXT                                                                           0x0355
#define regCB_COLOR4_BASE_EXT_BASE_IDX                                                                  1
#define regCB_COLOR4_ATTRIB2                                                                            0x0356
#define regCB_COLOR4_ATTRIB2_BASE_IDX                                                                   1
#define regCB_COLOR4_VIEW                                                                               0x0357
#define regCB_COLOR4_VIEW_BASE_IDX                                                                      1
#define regCB_COLOR4_INFO                                                                               0x0358
#define regCB_COLOR4_INFO_BASE_IDX                                                                      1
#define regCB_COLOR4_ATTRIB                                                                             0x0359
#define regCB_COLOR4_ATTRIB_BASE_IDX                                                                    1
#define regCB_COLOR4_DCC_CONTROL                                                                        0x035a
#define regCB_COLOR4_DCC_CONTROL_BASE_IDX                                                               1
#define regCB_COLOR4_CMASK                                                                              0x035b
#define regCB_COLOR4_CMASK_BASE_IDX                                                                     1
#define regCB_COLOR4_CMASK_BASE_EXT                                                                     0x035c
#define regCB_COLOR4_CMASK_BASE_EXT_BASE_IDX                                                            1
#define regCB_COLOR4_FMASK                                                                              0x035d
#define regCB_COLOR4_FMASK_BASE_IDX                                                                     1
#define regCB_COLOR4_FMASK_BASE_EXT                                                                     0x035e
#define regCB_COLOR4_FMASK_BASE_EXT_BASE_IDX                                                            1
#define regCB_COLOR4_CLEAR_WORD0                                                                        0x035f
#define regCB_COLOR4_CLEAR_WORD0_BASE_IDX                                                               1
#define regCB_COLOR4_CLEAR_WORD1                                                                        0x0360
#define regCB_COLOR4_CLEAR_WORD1_BASE_IDX                                                               1
#define regCB_COLOR4_DCC_BASE                                                                           0x0361
#define regCB_COLOR4_DCC_BASE_BASE_IDX                                                                  1
#define regCB_COLOR4_DCC_BASE_EXT                                                                       0x0362
#define regCB_COLOR4_DCC_BASE_EXT_BASE_IDX                                                              1
#define regCB_COLOR5_BASE                                                                               0x0363
#define regCB_COLOR5_BASE_BASE_IDX                                                                      1
#define regCB_COLOR5_BASE_EXT                                                                           0x0364
#define regCB_COLOR5_BASE_EXT_BASE_IDX                                                                  1
#define regCB_COLOR5_ATTRIB2                                                                            0x0365
#define regCB_COLOR5_ATTRIB2_BASE_IDX                                                                   1
#define regCB_COLOR5_VIEW                                                                               0x0366
#define regCB_COLOR5_VIEW_BASE_IDX                                                                      1
#define regCB_COLOR5_INFO                                                                               0x0367
#define regCB_COLOR5_INFO_BASE_IDX                                                                      1
#define regCB_COLOR5_ATTRIB                                                                             0x0368
#define regCB_COLOR5_ATTRIB_BASE_IDX                                                                    1
#define regCB_COLOR5_DCC_CONTROL                                                                        0x0369
#define regCB_COLOR5_DCC_CONTROL_BASE_IDX                                                               1
#define regCB_COLOR5_CMASK                                                                              0x036a
#define regCB_COLOR5_CMASK_BASE_IDX                                                                     1
#define regCB_COLOR5_CMASK_BASE_EXT                                                                     0x036b
#define regCB_COLOR5_CMASK_BASE_EXT_BASE_IDX                                                            1
#define regCB_COLOR5_FMASK                                                                              0x036c
#define regCB_COLOR5_FMASK_BASE_IDX                                                                     1
#define regCB_COLOR5_FMASK_BASE_EXT                                                                     0x036d
#define regCB_COLOR5_FMASK_BASE_EXT_BASE_IDX                                                            1
#define regCB_COLOR5_CLEAR_WORD0                                                                        0x036e
#define regCB_COLOR5_CLEAR_WORD0_BASE_IDX                                                               1
#define regCB_COLOR5_CLEAR_WORD1                                                                        0x036f
#define regCB_COLOR5_CLEAR_WORD1_BASE_IDX                                                               1
#define regCB_COLOR5_DCC_BASE                                                                           0x0370
#define regCB_COLOR5_DCC_BASE_BASE_IDX                                                                  1
#define regCB_COLOR5_DCC_BASE_EXT                                                                       0x0371
#define regCB_COLOR5_DCC_BASE_EXT_BASE_IDX                                                              1
#define regCB_COLOR6_BASE                                                                               0x0372
#define regCB_COLOR6_BASE_BASE_IDX                                                                      1
#define regCB_COLOR6_BASE_EXT                                                                           0x0373
#define regCB_COLOR6_BASE_EXT_BASE_IDX                                                                  1
#define regCB_COLOR6_ATTRIB2                                                                            0x0374
#define regCB_COLOR6_ATTRIB2_BASE_IDX                                                                   1
#define regCB_COLOR6_VIEW                                                                               0x0375
#define regCB_COLOR6_VIEW_BASE_IDX                                                                      1
#define regCB_COLOR6_INFO                                                                               0x0376
#define regCB_COLOR6_INFO_BASE_IDX                                                                      1
#define regCB_COLOR6_ATTRIB                                                                             0x0377
#define regCB_COLOR6_ATTRIB_BASE_IDX                                                                    1
#define regCB_COLOR6_DCC_CONTROL                                                                        0x0378
#define regCB_COLOR6_DCC_CONTROL_BASE_IDX                                                               1
#define regCB_COLOR6_CMASK                                                                              0x0379
#define regCB_COLOR6_CMASK_BASE_IDX                                                                     1
#define regCB_COLOR6_CMASK_BASE_EXT                                                                     0x037a
#define regCB_COLOR6_CMASK_BASE_EXT_BASE_IDX                                                            1
#define regCB_COLOR6_FMASK                                                                              0x037b
#define regCB_COLOR6_FMASK_BASE_IDX                                                                     1
#define regCB_COLOR6_FMASK_BASE_EXT                                                                     0x037c
#define regCB_COLOR6_FMASK_BASE_EXT_BASE_IDX                                                            1
#define regCB_COLOR6_CLEAR_WORD0                                                                        0x037d
#define regCB_COLOR6_CLEAR_WORD0_BASE_IDX                                                               1
#define regCB_COLOR6_CLEAR_WORD1                                                                        0x037e
#define regCB_COLOR6_CLEAR_WORD1_BASE_IDX                                                               1
#define regCB_COLOR6_DCC_BASE                                                                           0x037f
#define regCB_COLOR6_DCC_BASE_BASE_IDX                                                                  1
#define regCB_COLOR6_DCC_BASE_EXT                                                                       0x0380
#define regCB_COLOR6_DCC_BASE_EXT_BASE_IDX                                                              1
#define regCB_COLOR7_BASE                                                                               0x0381
#define regCB_COLOR7_BASE_BASE_IDX                                                                      1
#define regCB_COLOR7_BASE_EXT                                                                           0x0382
#define regCB_COLOR7_BASE_EXT_BASE_IDX                                                                  1
#define regCB_COLOR7_ATTRIB2                                                                            0x0383
#define regCB_COLOR7_ATTRIB2_BASE_IDX                                                                   1
#define regCB_COLOR7_VIEW                                                                               0x0384
#define regCB_COLOR7_VIEW_BASE_IDX                                                                      1
#define regCB_COLOR7_INFO                                                                               0x0385
#define regCB_COLOR7_INFO_BASE_IDX                                                                      1
#define regCB_COLOR7_ATTRIB                                                                             0x0386
#define regCB_COLOR7_ATTRIB_BASE_IDX                                                                    1
#define regCB_COLOR7_DCC_CONTROL                                                                        0x0387
#define regCB_COLOR7_DCC_CONTROL_BASE_IDX                                                               1
#define regCB_COLOR7_CMASK                                                                              0x0388
#define regCB_COLOR7_CMASK_BASE_IDX                                                                     1
#define regCB_COLOR7_CMASK_BASE_EXT                                                                     0x0389
#define regCB_COLOR7_CMASK_BASE_EXT_BASE_IDX                                                            1
#define regCB_COLOR7_FMASK                                                                              0x038a
#define regCB_COLOR7_FMASK_BASE_IDX                                                                     1
#define regCB_COLOR7_FMASK_BASE_EXT                                                                     0x038b
#define regCB_COLOR7_FMASK_BASE_EXT_BASE_IDX                                                            1
#define regCB_COLOR7_CLEAR_WORD0                                                                        0x038c
#define regCB_COLOR7_CLEAR_WORD0_BASE_IDX                                                               1
#define regCB_COLOR7_CLEAR_WORD1                                                                        0x038d
#define regCB_COLOR7_CLEAR_WORD1_BASE_IDX                                                               1
#define regCB_COLOR7_DCC_BASE                                                                           0x038e
#define regCB_COLOR7_DCC_BASE_BASE_IDX                                                                  1
#define regCB_COLOR7_DCC_BASE_EXT                                                                       0x038f
#define regCB_COLOR7_DCC_BASE_EXT_BASE_IDX                                                              1


// addressBlock: xcd0_gc_gfxudec
// base address: 0x30000
#define regCP_EOP_DONE_ADDR_LO                                                                          0x2000
#define regCP_EOP_DONE_ADDR_LO_BASE_IDX                                                                 1
#define regCP_EOP_DONE_ADDR_HI                                                                          0x2001
#define regCP_EOP_DONE_ADDR_HI_BASE_IDX                                                                 1
#define regCP_EOP_DONE_DATA_LO                                                                          0x2002
#define regCP_EOP_DONE_DATA_LO_BASE_IDX                                                                 1
#define regCP_EOP_DONE_DATA_HI                                                                          0x2003
#define regCP_EOP_DONE_DATA_HI_BASE_IDX                                                                 1
#define regCP_EOP_LAST_FENCE_LO                                                                         0x2004
#define regCP_EOP_LAST_FENCE_LO_BASE_IDX                                                                1
#define regCP_EOP_LAST_FENCE_HI                                                                         0x2005
#define regCP_EOP_LAST_FENCE_HI_BASE_IDX                                                                1
#define regCP_STREAM_OUT_ADDR_LO                                                                        0x2006
#define regCP_STREAM_OUT_ADDR_LO_BASE_IDX                                                               1
#define regCP_STREAM_OUT_ADDR_HI                                                                        0x2007
#define regCP_STREAM_OUT_ADDR_HI_BASE_IDX                                                               1
#define regCP_NUM_PRIM_WRITTEN_COUNT0_LO                                                                0x2008
#define regCP_NUM_PRIM_WRITTEN_COUNT0_LO_BASE_IDX                                                       1
#define regCP_NUM_PRIM_WRITTEN_COUNT0_HI                                                                0x2009
#define regCP_NUM_PRIM_WRITTEN_COUNT0_HI_BASE_IDX                                                       1
#define regCP_NUM_PRIM_NEEDED_COUNT0_LO                                                                 0x200a
#define regCP_NUM_PRIM_NEEDED_COUNT0_LO_BASE_IDX                                                        1
#define regCP_NUM_PRIM_NEEDED_COUNT0_HI                                                                 0x200b
#define regCP_NUM_PRIM_NEEDED_COUNT0_HI_BASE_IDX                                                        1
#define regCP_NUM_PRIM_WRITTEN_COUNT1_LO                                                                0x200c
#define regCP_NUM_PRIM_WRITTEN_COUNT1_LO_BASE_IDX                                                       1
#define regCP_NUM_PRIM_WRITTEN_COUNT1_HI                                                                0x200d
#define regCP_NUM_PRIM_WRITTEN_COUNT1_HI_BASE_IDX                                                       1
#define regCP_NUM_PRIM_NEEDED_COUNT1_LO                                                                 0x200e
#define regCP_NUM_PRIM_NEEDED_COUNT1_LO_BASE_IDX                                                        1
#define regCP_NUM_PRIM_NEEDED_COUNT1_HI                                                                 0x200f
#define regCP_NUM_PRIM_NEEDED_COUNT1_HI_BASE_IDX                                                        1
#define regCP_NUM_PRIM_WRITTEN_COUNT2_LO                                                                0x2010
#define regCP_NUM_PRIM_WRITTEN_COUNT2_LO_BASE_IDX                                                       1
#define regCP_NUM_PRIM_WRITTEN_COUNT2_HI                                                                0x2011
#define regCP_NUM_PRIM_WRITTEN_COUNT2_HI_BASE_IDX                                                       1
#define regCP_NUM_PRIM_NEEDED_COUNT2_LO                                                                 0x2012
#define regCP_NUM_PRIM_NEEDED_COUNT2_LO_BASE_IDX                                                        1
#define regCP_NUM_PRIM_NEEDED_COUNT2_HI                                                                 0x2013
#define regCP_NUM_PRIM_NEEDED_COUNT2_HI_BASE_IDX                                                        1
#define regCP_NUM_PRIM_WRITTEN_COUNT3_LO                                                                0x2014
#define regCP_NUM_PRIM_WRITTEN_COUNT3_LO_BASE_IDX                                                       1
#define regCP_NUM_PRIM_WRITTEN_COUNT3_HI                                                                0x2015
#define regCP_NUM_PRIM_WRITTEN_COUNT3_HI_BASE_IDX                                                       1
#define regCP_NUM_PRIM_NEEDED_COUNT3_LO                                                                 0x2016
#define regCP_NUM_PRIM_NEEDED_COUNT3_LO_BASE_IDX                                                        1
#define regCP_NUM_PRIM_NEEDED_COUNT3_HI                                                                 0x2017
#define regCP_NUM_PRIM_NEEDED_COUNT3_HI_BASE_IDX                                                        1
#define regCP_PIPE_STATS_ADDR_LO                                                                        0x2018
#define regCP_PIPE_STATS_ADDR_LO_BASE_IDX                                                               1
#define regCP_PIPE_STATS_ADDR_HI                                                                        0x2019
#define regCP_PIPE_STATS_ADDR_HI_BASE_IDX                                                               1
#define regCP_VGT_IAVERT_COUNT_LO                                                                       0x201a
#define regCP_VGT_IAVERT_COUNT_LO_BASE_IDX                                                              1
#define regCP_VGT_IAVERT_COUNT_HI                                                                       0x201b
#define regCP_VGT_IAVERT_COUNT_HI_BASE_IDX                                                              1
#define regCP_VGT_IAPRIM_COUNT_LO                                                                       0x201c
#define regCP_VGT_IAPRIM_COUNT_LO_BASE_IDX                                                              1
#define regCP_VGT_IAPRIM_COUNT_HI                                                                       0x201d
#define regCP_VGT_IAPRIM_COUNT_HI_BASE_IDX                                                              1
#define regCP_VGT_GSPRIM_COUNT_LO                                                                       0x201e
#define regCP_VGT_GSPRIM_COUNT_LO_BASE_IDX                                                              1
#define regCP_VGT_GSPRIM_COUNT_HI                                                                       0x201f
#define regCP_VGT_GSPRIM_COUNT_HI_BASE_IDX                                                              1
#define regCP_VGT_VSINVOC_COUNT_LO                                                                      0x2020
#define regCP_VGT_VSINVOC_COUNT_LO_BASE_IDX                                                             1
#define regCP_VGT_VSINVOC_COUNT_HI                                                                      0x2021
#define regCP_VGT_VSINVOC_COUNT_HI_BASE_IDX                                                             1
#define regCP_VGT_GSINVOC_COUNT_LO                                                                      0x2022
#define regCP_VGT_GSINVOC_COUNT_LO_BASE_IDX                                                             1
#define regCP_VGT_GSINVOC_COUNT_HI                                                                      0x2023
#define regCP_VGT_GSINVOC_COUNT_HI_BASE_IDX                                                             1
#define regCP_VGT_HSINVOC_COUNT_LO                                                                      0x2024
#define regCP_VGT_HSINVOC_COUNT_LO_BASE_IDX                                                             1
#define regCP_VGT_HSINVOC_COUNT_HI                                                                      0x2025
#define regCP_VGT_HSINVOC_COUNT_HI_BASE_IDX                                                             1
#define regCP_VGT_DSINVOC_COUNT_LO                                                                      0x2026
#define regCP_VGT_DSINVOC_COUNT_LO_BASE_IDX                                                             1
#define regCP_VGT_DSINVOC_COUNT_HI                                                                      0x2027
#define regCP_VGT_DSINVOC_COUNT_HI_BASE_IDX                                                             1
#define regCP_PA_CINVOC_COUNT_LO                                                                        0x2028
#define regCP_PA_CINVOC_COUNT_LO_BASE_IDX                                                               1
#define regCP_PA_CINVOC_COUNT_HI                                                                        0x2029
#define regCP_PA_CINVOC_COUNT_HI_BASE_IDX                                                               1
#define regCP_PA_CPRIM_COUNT_LO                                                                         0x202a
#define regCP_PA_CPRIM_COUNT_LO_BASE_IDX                                                                1
#define regCP_PA_CPRIM_COUNT_HI                                                                         0x202b
#define regCP_PA_CPRIM_COUNT_HI_BASE_IDX                                                                1
#define regCP_SC_PSINVOC_COUNT0_LO                                                                      0x202c
#define regCP_SC_PSINVOC_COUNT0_LO_BASE_IDX                                                             1
#define regCP_SC_PSINVOC_COUNT0_HI                                                                      0x202d
#define regCP_SC_PSINVOC_COUNT0_HI_BASE_IDX                                                             1
#define regCP_SC_PSINVOC_COUNT1_LO                                                                      0x202e
#define regCP_SC_PSINVOC_COUNT1_LO_BASE_IDX                                                             1
#define regCP_SC_PSINVOC_COUNT1_HI                                                                      0x202f
#define regCP_SC_PSINVOC_COUNT1_HI_BASE_IDX                                                             1
#define regCP_VGT_CSINVOC_COUNT_LO                                                                      0x2030
#define regCP_VGT_CSINVOC_COUNT_LO_BASE_IDX                                                             1
#define regCP_VGT_CSINVOC_COUNT_HI                                                                      0x2031
#define regCP_VGT_CSINVOC_COUNT_HI_BASE_IDX                                                             1
#define regCP_PIPE_STATS_CONTROL                                                                        0x203d
#define regCP_PIPE_STATS_CONTROL_BASE_IDX                                                               1
#define regCP_STREAM_OUT_CONTROL                                                                        0x203e
#define regCP_STREAM_OUT_CONTROL_BASE_IDX                                                               1
#define regCP_STRMOUT_CNTL                                                                              0x203f
#define regCP_STRMOUT_CNTL_BASE_IDX                                                                     1
#define regSCRATCH_REG0                                                                                 0x2040
#define regSCRATCH_REG0_BASE_IDX                                                                        1
#define regSCRATCH_REG1                                                                                 0x2041
#define regSCRATCH_REG1_BASE_IDX                                                                        1
#define regSCRATCH_REG2                                                                                 0x2042
#define regSCRATCH_REG2_BASE_IDX                                                                        1
#define regSCRATCH_REG3                                                                                 0x2043
#define regSCRATCH_REG3_BASE_IDX                                                                        1
#define regSCRATCH_REG4                                                                                 0x2044
#define regSCRATCH_REG4_BASE_IDX                                                                        1
#define regSCRATCH_REG5                                                                                 0x2045
#define regSCRATCH_REG5_BASE_IDX                                                                        1
#define regSCRATCH_REG6                                                                                 0x2046
#define regSCRATCH_REG6_BASE_IDX                                                                        1
#define regSCRATCH_REG7                                                                                 0x2047
#define regSCRATCH_REG7_BASE_IDX                                                                        1
#define regCP_APPEND_DATA_HI                                                                            0x204c
#define regCP_APPEND_DATA_HI_BASE_IDX                                                                   1
#define regCP_APPEND_LAST_CS_FENCE_HI                                                                   0x204d
#define regCP_APPEND_LAST_CS_FENCE_HI_BASE_IDX                                                          1
#define regCP_APPEND_LAST_PS_FENCE_HI                                                                   0x204e
#define regCP_APPEND_LAST_PS_FENCE_HI_BASE_IDX                                                          1
#define regSCRATCH_UMSK                                                                                 0x2050
#define regSCRATCH_UMSK_BASE_IDX                                                                        1
#define regSCRATCH_ADDR                                                                                 0x2051
#define regSCRATCH_ADDR_BASE_IDX                                                                        1
#define regCP_PFP_ATOMIC_PREOP_LO                                                                       0x2052
#define regCP_PFP_ATOMIC_PREOP_LO_BASE_IDX                                                              1
#define regCP_PFP_ATOMIC_PREOP_HI                                                                       0x2053
#define regCP_PFP_ATOMIC_PREOP_HI_BASE_IDX                                                              1
#define regCP_PFP_GDS_ATOMIC0_PREOP_LO                                                                  0x2054
#define regCP_PFP_GDS_ATOMIC0_PREOP_LO_BASE_IDX                                                         1
#define regCP_PFP_GDS_ATOMIC0_PREOP_HI                                                                  0x2055
#define regCP_PFP_GDS_ATOMIC0_PREOP_HI_BASE_IDX                                                         1
#define regCP_PFP_GDS_ATOMIC1_PREOP_LO                                                                  0x2056
#define regCP_PFP_GDS_ATOMIC1_PREOP_LO_BASE_IDX                                                         1
#define regCP_PFP_GDS_ATOMIC1_PREOP_HI                                                                  0x2057
#define regCP_PFP_GDS_ATOMIC1_PREOP_HI_BASE_IDX                                                         1
#define regCP_APPEND_ADDR_LO                                                                            0x2058
#define regCP_APPEND_ADDR_LO_BASE_IDX                                                                   1
#define regCP_APPEND_ADDR_HI                                                                            0x2059
#define regCP_APPEND_ADDR_HI_BASE_IDX                                                                   1
#define regCP_APPEND_DATA_LO                                                                            0x205a
#define regCP_APPEND_DATA_LO_BASE_IDX                                                                   1
#define regCP_APPEND_LAST_CS_FENCE_LO                                                                   0x205b
#define regCP_APPEND_LAST_CS_FENCE_LO_BASE_IDX                                                          1
#define regCP_APPEND_LAST_PS_FENCE_LO                                                                   0x205c
#define regCP_APPEND_LAST_PS_FENCE_LO_BASE_IDX                                                          1
#define regCP_ATOMIC_PREOP_LO                                                                           0x205d
#define regCP_ATOMIC_PREOP_LO_BASE_IDX                                                                  1
#define regCP_ME_ATOMIC_PREOP_LO                                                                        0x205d
#define regCP_ME_ATOMIC_PREOP_LO_BASE_IDX                                                               1
#define regCP_ATOMIC_PREOP_HI                                                                           0x205e
#define regCP_ATOMIC_PREOP_HI_BASE_IDX                                                                  1
#define regCP_ME_ATOMIC_PREOP_HI                                                                        0x205e
#define regCP_ME_ATOMIC_PREOP_HI_BASE_IDX                                                               1
#define regCP_GDS_ATOMIC0_PREOP_LO                                                                      0x205f
#define regCP_GDS_ATOMIC0_PREOP_LO_BASE_IDX                                                             1
#define regCP_ME_GDS_ATOMIC0_PREOP_LO                                                                   0x205f
#define regCP_ME_GDS_ATOMIC0_PREOP_LO_BASE_IDX                                                          1
#define regCP_GDS_ATOMIC0_PREOP_HI                                                                      0x2060
#define regCP_GDS_ATOMIC0_PREOP_HI_BASE_IDX                                                             1
#define regCP_ME_GDS_ATOMIC0_PREOP_HI                                                                   0x2060
#define regCP_ME_GDS_ATOMIC0_PREOP_HI_BASE_IDX                                                          1
#define regCP_GDS_ATOMIC1_PREOP_LO                                                                      0x2061
#define regCP_GDS_ATOMIC1_PREOP_LO_BASE_IDX                                                             1
#define regCP_ME_GDS_ATOMIC1_PREOP_LO                                                                   0x2061
#define regCP_ME_GDS_ATOMIC1_PREOP_LO_BASE_IDX                                                          1
#define regCP_GDS_ATOMIC1_PREOP_HI                                                                      0x2062
#define regCP_GDS_ATOMIC1_PREOP_HI_BASE_IDX                                                             1
#define regCP_ME_GDS_ATOMIC1_PREOP_HI                                                                   0x2062
#define regCP_ME_GDS_ATOMIC1_PREOP_HI_BASE_IDX                                                          1
#define regCP_ME_MC_WADDR_LO                                                                            0x2069
#define regCP_ME_MC_WADDR_LO_BASE_IDX                                                                   1
#define regCP_ME_MC_WADDR_HI                                                                            0x206a
#define regCP_ME_MC_WADDR_HI_BASE_IDX                                                                   1
#define regCP_ME_MC_WDATA_LO                                                                            0x206b
#define regCP_ME_MC_WDATA_LO_BASE_IDX                                                                   1
#define regCP_ME_MC_WDATA_HI                                                                            0x206c
#define regCP_ME_MC_WDATA_HI_BASE_IDX                                                                   1
#define regCP_ME_MC_RADDR_LO                                                                            0x206d
#define regCP_ME_MC_RADDR_LO_BASE_IDX                                                                   1
#define regCP_ME_MC_RADDR_HI                                                                            0x206e
#define regCP_ME_MC_RADDR_HI_BASE_IDX                                                                   1
#define regCP_SEM_WAIT_TIMER                                                                            0x206f
#define regCP_SEM_WAIT_TIMER_BASE_IDX                                                                   1
#define regCP_SIG_SEM_ADDR_LO                                                                           0x2070
#define regCP_SIG_SEM_ADDR_LO_BASE_IDX                                                                  1
#define regCP_SIG_SEM_ADDR_HI                                                                           0x2071
#define regCP_SIG_SEM_ADDR_HI_BASE_IDX                                                                  1
#define regCP_WAIT_REG_MEM_TIMEOUT                                                                      0x2074
#define regCP_WAIT_REG_MEM_TIMEOUT_BASE_IDX                                                             1
#define regCP_WAIT_SEM_ADDR_LO                                                                          0x2075
#define regCP_WAIT_SEM_ADDR_LO_BASE_IDX                                                                 1
#define regCP_WAIT_SEM_ADDR_HI                                                                          0x2076
#define regCP_WAIT_SEM_ADDR_HI_BASE_IDX                                                                 1
#define regCP_DMA_PFP_CONTROL                                                                           0x2077
#define regCP_DMA_PFP_CONTROL_BASE_IDX                                                                  1
#define regCP_DMA_ME_CONTROL                                                                            0x2078
#define regCP_DMA_ME_CONTROL_BASE_IDX                                                                   1
#define regCP_COHER_BASE_HI                                                                             0x2079
#define regCP_COHER_BASE_HI_BASE_IDX                                                                    1
#define regCP_COHER_START_DELAY                                                                         0x207b
#define regCP_COHER_START_DELAY_BASE_IDX                                                                1
#define regCP_COHER_CNTL                                                                                0x207c
#define regCP_COHER_CNTL_BASE_IDX                                                                       1
#define regCP_COHER_SIZE                                                                                0x207d
#define regCP_COHER_SIZE_BASE_IDX                                                                       1
#define regCP_COHER_BASE                                                                                0x207e
#define regCP_COHER_BASE_BASE_IDX                                                                       1
#define regCP_COHER_STATUS                                                                              0x207f
#define regCP_COHER_STATUS_BASE_IDX                                                                     1
#define regCP_DMA_ME_SRC_ADDR                                                                           0x2080
#define regCP_DMA_ME_SRC_ADDR_BASE_IDX                                                                  1
#define regCP_DMA_ME_SRC_ADDR_HI                                                                        0x2081
#define regCP_DMA_ME_SRC_ADDR_HI_BASE_IDX                                                               1
#define regCP_DMA_ME_DST_ADDR                                                                           0x2082
#define regCP_DMA_ME_DST_ADDR_BASE_IDX                                                                  1
#define regCP_DMA_ME_DST_ADDR_HI                                                                        0x2083
#define regCP_DMA_ME_DST_ADDR_HI_BASE_IDX                                                               1
#define regCP_DMA_ME_COMMAND                                                                            0x2084
#define regCP_DMA_ME_COMMAND_BASE_IDX                                                                   1
#define regCP_DMA_PFP_SRC_ADDR                                                                          0x2085
#define regCP_DMA_PFP_SRC_ADDR_BASE_IDX                                                                 1
#define regCP_DMA_PFP_SRC_ADDR_HI                                                                       0x2086
#define regCP_DMA_PFP_SRC_ADDR_HI_BASE_IDX                                                              1
#define regCP_DMA_PFP_DST_ADDR                                                                          0x2087
#define regCP_DMA_PFP_DST_ADDR_BASE_IDX                                                                 1
#define regCP_DMA_PFP_DST_ADDR_HI                                                                       0x2088
#define regCP_DMA_PFP_DST_ADDR_HI_BASE_IDX                                                              1
#define regCP_DMA_PFP_COMMAND                                                                           0x2089
#define regCP_DMA_PFP_COMMAND_BASE_IDX                                                                  1
#define regCP_DMA_CNTL                                                                                  0x208a
#define regCP_DMA_CNTL_BASE_IDX                                                                         1
#define regCP_DMA_READ_TAGS                                                                             0x208b
#define regCP_DMA_READ_TAGS_BASE_IDX                                                                    1
#define regCP_COHER_SIZE_HI                                                                             0x208c
#define regCP_COHER_SIZE_HI_BASE_IDX                                                                    1
#define regCP_PFP_IB_CONTROL                                                                            0x208d
#define regCP_PFP_IB_CONTROL_BASE_IDX                                                                   1
#define regCP_PFP_LOAD_CONTROL                                                                          0x208e
#define regCP_PFP_LOAD_CONTROL_BASE_IDX                                                                 1
#define regCP_SCRATCH_INDEX                                                                             0x208f
#define regCP_SCRATCH_INDEX_BASE_IDX                                                                    1
#define regCP_SCRATCH_DATA                                                                              0x2090
#define regCP_SCRATCH_DATA_BASE_IDX                                                                     1
#define regCP_RB_OFFSET                                                                                 0x2091
#define regCP_RB_OFFSET_BASE_IDX                                                                        1
#define regCP_IB1_OFFSET                                                                                0x2092
#define regCP_IB1_OFFSET_BASE_IDX                                                                       1
#define regCP_IB2_OFFSET                                                                                0x2093
#define regCP_IB2_OFFSET_BASE_IDX                                                                       1
#define regCP_IB1_PREAMBLE_BEGIN                                                                        0x2094
#define regCP_IB1_PREAMBLE_BEGIN_BASE_IDX                                                               1
#define regCP_IB1_PREAMBLE_END                                                                          0x2095
#define regCP_IB1_PREAMBLE_END_BASE_IDX                                                                 1
#define regCP_IB2_PREAMBLE_BEGIN                                                                        0x2096
#define regCP_IB2_PREAMBLE_BEGIN_BASE_IDX                                                               1
#define regCP_IB2_PREAMBLE_END                                                                          0x2097
#define regCP_IB2_PREAMBLE_END_BASE_IDX                                                                 1
#define regCP_CE_IB1_OFFSET                                                                             0x2098
#define regCP_CE_IB1_OFFSET_BASE_IDX                                                                    1
#define regCP_CE_IB2_OFFSET                                                                             0x2099
#define regCP_CE_IB2_OFFSET_BASE_IDX                                                                    1
#define regCP_CE_COUNTER                                                                                0x209a
#define regCP_CE_COUNTER_BASE_IDX                                                                       1
#define regCP_CE_RB_OFFSET                                                                              0x209b
#define regCP_CE_RB_OFFSET_BASE_IDX                                                                     1
#define regCP_CE_INIT_CMD_BUFSZ                                                                         0x20bd
#define regCP_CE_INIT_CMD_BUFSZ_BASE_IDX                                                                1
#define regCP_CE_IB1_CMD_BUFSZ                                                                          0x20be
#define regCP_CE_IB1_CMD_BUFSZ_BASE_IDX                                                                 1
#define regCP_CE_IB2_CMD_BUFSZ                                                                          0x20bf
#define regCP_CE_IB2_CMD_BUFSZ_BASE_IDX                                                                 1
#define regCP_IB1_CMD_BUFSZ                                                                             0x20c0
#define regCP_IB1_CMD_BUFSZ_BASE_IDX                                                                    1
#define regCP_IB2_CMD_BUFSZ                                                                             0x20c1
#define regCP_IB2_CMD_BUFSZ_BASE_IDX                                                                    1
#define regCP_ST_CMD_BUFSZ                                                                              0x20c2
#define regCP_ST_CMD_BUFSZ_BASE_IDX                                                                     1
#define regCP_CE_INIT_BASE_LO                                                                           0x20c3
#define regCP_CE_INIT_BASE_LO_BASE_IDX                                                                  1
#define regCP_CE_INIT_BASE_HI                                                                           0x20c4
#define regCP_CE_INIT_BASE_HI_BASE_IDX                                                                  1
#define regCP_CE_INIT_BUFSZ                                                                             0x20c5
#define regCP_CE_INIT_BUFSZ_BASE_IDX                                                                    1
#define regCP_CE_IB1_BASE_LO                                                                            0x20c6
#define regCP_CE_IB1_BASE_LO_BASE_IDX                                                                   1
#define regCP_CE_IB1_BASE_HI                                                                            0x20c7
#define regCP_CE_IB1_BASE_HI_BASE_IDX                                                                   1
#define regCP_CE_IB1_BUFSZ                                                                              0x20c8
#define regCP_CE_IB1_BUFSZ_BASE_IDX                                                                     1
#define regCP_CE_IB2_BASE_LO                                                                            0x20c9
#define regCP_CE_IB2_BASE_LO_BASE_IDX                                                                   1
#define regCP_CE_IB2_BASE_HI                                                                            0x20ca
#define regCP_CE_IB2_BASE_HI_BASE_IDX                                                                   1
#define regCP_CE_IB2_BUFSZ                                                                              0x20cb
#define regCP_CE_IB2_BUFSZ_BASE_IDX                                                                     1
#define regCP_IB1_BASE_LO                                                                               0x20cc
#define regCP_IB1_BASE_LO_BASE_IDX                                                                      1
#define regCP_IB1_BASE_HI                                                                               0x20cd
#define regCP_IB1_BASE_HI_BASE_IDX                                                                      1
#define regCP_IB1_BUFSZ                                                                                 0x20ce
#define regCP_IB1_BUFSZ_BASE_IDX                                                                        1
#define regCP_IB2_BASE_LO                                                                               0x20cf
#define regCP_IB2_BASE_LO_BASE_IDX                                                                      1
#define regCP_IB2_BASE_HI                                                                               0x20d0
#define regCP_IB2_BASE_HI_BASE_IDX                                                                      1
#define regCP_IB2_BUFSZ                                                                                 0x20d1
#define regCP_IB2_BUFSZ_BASE_IDX                                                                        1
#define regCP_ST_BASE_LO                                                                                0x20d2
#define regCP_ST_BASE_LO_BASE_IDX                                                                       1
#define regCP_ST_BASE_HI                                                                                0x20d3
#define regCP_ST_BASE_HI_BASE_IDX                                                                       1
#define regCP_ST_BUFSZ                                                                                  0x20d4
#define regCP_ST_BUFSZ_BASE_IDX                                                                         1
#define regCP_EOP_DONE_EVENT_CNTL                                                                       0x20d5
#define regCP_EOP_DONE_EVENT_CNTL_BASE_IDX                                                              1
#define regCP_EOP_DONE_DATA_CNTL                                                                        0x20d6
#define regCP_EOP_DONE_DATA_CNTL_BASE_IDX                                                               1
#define regCP_EOP_DONE_CNTX_ID                                                                          0x20d7
#define regCP_EOP_DONE_CNTX_ID_BASE_IDX                                                                 1
#define regCP_PFP_COMPLETION_STATUS                                                                     0x20ec
#define regCP_PFP_COMPLETION_STATUS_BASE_IDX                                                            1
#define regCP_CE_COMPLETION_STATUS                                                                      0x20ed
#define regCP_CE_COMPLETION_STATUS_BASE_IDX                                                             1
#define regCP_PRED_NOT_VISIBLE                                                                          0x20ee
#define regCP_PRED_NOT_VISIBLE_BASE_IDX                                                                 1
#define regCP_PFP_METADATA_BASE_ADDR                                                                    0x20f0
#define regCP_PFP_METADATA_BASE_ADDR_BASE_IDX                                                           1
#define regCP_PFP_METADATA_BASE_ADDR_HI                                                                 0x20f1
#define regCP_PFP_METADATA_BASE_ADDR_HI_BASE_IDX                                                        1
#define regCP_CE_METADATA_BASE_ADDR                                                                     0x20f2
#define regCP_CE_METADATA_BASE_ADDR_BASE_IDX                                                            1
#define regCP_CE_METADATA_BASE_ADDR_HI                                                                  0x20f3
#define regCP_CE_METADATA_BASE_ADDR_HI_BASE_IDX                                                         1
#define regCP_DRAW_INDX_INDR_ADDR                                                                       0x20f4
#define regCP_DRAW_INDX_INDR_ADDR_BASE_IDX                                                              1
#define regCP_DRAW_INDX_INDR_ADDR_HI                                                                    0x20f5
#define regCP_DRAW_INDX_INDR_ADDR_HI_BASE_IDX                                                           1
#define regCP_DISPATCH_INDR_ADDR                                                                        0x20f6
#define regCP_DISPATCH_INDR_ADDR_BASE_IDX                                                               1
#define regCP_DISPATCH_INDR_ADDR_HI                                                                     0x20f7
#define regCP_DISPATCH_INDR_ADDR_HI_BASE_IDX                                                            1
#define regCP_INDEX_BASE_ADDR                                                                           0x20f8
#define regCP_INDEX_BASE_ADDR_BASE_IDX                                                                  1
#define regCP_INDEX_BASE_ADDR_HI                                                                        0x20f9
#define regCP_INDEX_BASE_ADDR_HI_BASE_IDX                                                               1
#define regCP_INDEX_TYPE                                                                                0x20fa
#define regCP_INDEX_TYPE_BASE_IDX                                                                       1
#define regCP_GDS_BKUP_ADDR                                                                             0x20fb
#define regCP_GDS_BKUP_ADDR_BASE_IDX                                                                    1
#define regCP_GDS_BKUP_ADDR_HI                                                                          0x20fc
#define regCP_GDS_BKUP_ADDR_HI_BASE_IDX                                                                 1
#define regCP_SAMPLE_STATUS                                                                             0x20fd
#define regCP_SAMPLE_STATUS_BASE_IDX                                                                    1
#define regCP_ME_COHER_CNTL                                                                             0x20fe
#define regCP_ME_COHER_CNTL_BASE_IDX                                                                    1
#define regCP_ME_COHER_SIZE                                                                             0x20ff
#define regCP_ME_COHER_SIZE_BASE_IDX                                                                    1
#define regCP_ME_COHER_SIZE_HI                                                                          0x2100
#define regCP_ME_COHER_SIZE_HI_BASE_IDX                                                                 1
#define regCP_ME_COHER_BASE                                                                             0x2101
#define regCP_ME_COHER_BASE_BASE_IDX                                                                    1
#define regCP_ME_COHER_BASE_HI                                                                          0x2102
#define regCP_ME_COHER_BASE_HI_BASE_IDX                                                                 1
#define regCP_ME_COHER_STATUS                                                                           0x2103
#define regCP_ME_COHER_STATUS_BASE_IDX                                                                  1
#define regRLC_GPM_PERF_COUNT_0                                                                         0x2140
#define regRLC_GPM_PERF_COUNT_0_BASE_IDX                                                                1
#define regRLC_GPM_PERF_COUNT_1                                                                         0x2141
#define regRLC_GPM_PERF_COUNT_1_BASE_IDX                                                                1
#define regGRBM_GFX_INDEX                                                                               0x2200
#define regGRBM_GFX_INDEX_BASE_IDX                                                                      1
#define regVGT_GSVS_RING_SIZE                                                                           0x2241
#define regVGT_GSVS_RING_SIZE_BASE_IDX                                                                  1
#define regVGT_PRIMITIVE_TYPE                                                                           0x2242
#define regVGT_PRIMITIVE_TYPE_BASE_IDX                                                                  1
#define regVGT_INDEX_TYPE                                                                               0x2243
#define regVGT_INDEX_TYPE_BASE_IDX                                                                      1
#define regVGT_STRMOUT_BUFFER_FILLED_SIZE_0                                                             0x2244
#define regVGT_STRMOUT_BUFFER_FILLED_SIZE_0_BASE_IDX                                                    1
#define regVGT_STRMOUT_BUFFER_FILLED_SIZE_1                                                             0x2245
#define regVGT_STRMOUT_BUFFER_FILLED_SIZE_1_BASE_IDX                                                    1
#define regVGT_STRMOUT_BUFFER_FILLED_SIZE_2                                                             0x2246
#define regVGT_STRMOUT_BUFFER_FILLED_SIZE_2_BASE_IDX                                                    1
#define regVGT_STRMOUT_BUFFER_FILLED_SIZE_3                                                             0x2247
#define regVGT_STRMOUT_BUFFER_FILLED_SIZE_3_BASE_IDX                                                    1
#define regVGT_MAX_VTX_INDX                                                                             0x2248
#define regVGT_MAX_VTX_INDX_BASE_IDX                                                                    1
#define regVGT_MIN_VTX_INDX                                                                             0x2249
#define regVGT_MIN_VTX_INDX_BASE_IDX                                                                    1
#define regVGT_INDX_OFFSET                                                                              0x224a
#define regVGT_INDX_OFFSET_BASE_IDX                                                                     1
#define regVGT_MULTI_PRIM_IB_RESET_EN                                                                   0x224b
#define regVGT_MULTI_PRIM_IB_RESET_EN_BASE_IDX                                                          1
#define regVGT_NUM_INDICES                                                                              0x224c
#define regVGT_NUM_INDICES_BASE_IDX                                                                     1
#define regVGT_NUM_INSTANCES                                                                            0x224d
#define regVGT_NUM_INSTANCES_BASE_IDX                                                                   1
#define regVGT_TF_RING_SIZE                                                                             0x224e
#define regVGT_TF_RING_SIZE_BASE_IDX                                                                    1
#define regVGT_HS_OFFCHIP_PARAM                                                                         0x224f
#define regVGT_HS_OFFCHIP_PARAM_BASE_IDX                                                                1
#define regVGT_TF_MEMORY_BASE                                                                           0x2250
#define regVGT_TF_MEMORY_BASE_BASE_IDX                                                                  1
#define regVGT_TF_MEMORY_BASE_HI                                                                        0x2251
#define regVGT_TF_MEMORY_BASE_HI_BASE_IDX                                                               1
#define regWD_POS_BUF_BASE                                                                              0x2252
#define regWD_POS_BUF_BASE_BASE_IDX                                                                     1
#define regWD_POS_BUF_BASE_HI                                                                           0x2253
#define regWD_POS_BUF_BASE_HI_BASE_IDX                                                                  1
#define regWD_CNTL_SB_BUF_BASE                                                                          0x2254
#define regWD_CNTL_SB_BUF_BASE_BASE_IDX                                                                 1
#define regWD_CNTL_SB_BUF_BASE_HI                                                                       0x2255
#define regWD_CNTL_SB_BUF_BASE_HI_BASE_IDX                                                              1
#define regWD_INDEX_BUF_BASE                                                                            0x2256
#define regWD_INDEX_BUF_BASE_BASE_IDX                                                                   1
#define regWD_INDEX_BUF_BASE_HI                                                                         0x2257
#define regWD_INDEX_BUF_BASE_HI_BASE_IDX                                                                1
#define regIA_MULTI_VGT_PARAM                                                                           0x2258
#define regIA_MULTI_VGT_PARAM_BASE_IDX                                                                  1
#define regVGT_INSTANCE_BASE_ID                                                                         0x225a
#define regVGT_INSTANCE_BASE_ID_BASE_IDX                                                                1
#define regPA_SU_LINE_STIPPLE_VALUE                                                                     0x2280
#define regPA_SU_LINE_STIPPLE_VALUE_BASE_IDX                                                            1
#define regPA_SC_LINE_STIPPLE_STATE                                                                     0x2281
#define regPA_SC_LINE_STIPPLE_STATE_BASE_IDX                                                            1
#define regPA_SC_SCREEN_EXTENT_MIN_0                                                                    0x2284
#define regPA_SC_SCREEN_EXTENT_MIN_0_BASE_IDX                                                           1
#define regPA_SC_SCREEN_EXTENT_MAX_0                                                                    0x2285
#define regPA_SC_SCREEN_EXTENT_MAX_0_BASE_IDX                                                           1
#define regPA_SC_SCREEN_EXTENT_MIN_1                                                                    0x2286
#define regPA_SC_SCREEN_EXTENT_MIN_1_BASE_IDX                                                           1
#define regPA_SC_SCREEN_EXTENT_MAX_1                                                                    0x228b
#define regPA_SC_SCREEN_EXTENT_MAX_1_BASE_IDX                                                           1
#define regPA_SC_P3D_TRAP_SCREEN_HV_EN                                                                  0x22a0
#define regPA_SC_P3D_TRAP_SCREEN_HV_EN_BASE_IDX                                                         1
#define regPA_SC_P3D_TRAP_SCREEN_H                                                                      0x22a1
#define regPA_SC_P3D_TRAP_SCREEN_H_BASE_IDX                                                             1
#define regPA_SC_P3D_TRAP_SCREEN_V                                                                      0x22a2
#define regPA_SC_P3D_TRAP_SCREEN_V_BASE_IDX                                                             1
#define regPA_SC_P3D_TRAP_SCREEN_OCCURRENCE                                                             0x22a3
#define regPA_SC_P3D_TRAP_SCREEN_OCCURRENCE_BASE_IDX                                                    1
#define regPA_SC_P3D_TRAP_SCREEN_COUNT                                                                  0x22a4
#define regPA_SC_P3D_TRAP_SCREEN_COUNT_BASE_IDX                                                         1
#define regPA_SC_HP3D_TRAP_SCREEN_HV_EN                                                                 0x22a8
#define regPA_SC_HP3D_TRAP_SCREEN_HV_EN_BASE_IDX                                                        1
#define regPA_SC_HP3D_TRAP_SCREEN_H                                                                     0x22a9
#define regPA_SC_HP3D_TRAP_SCREEN_H_BASE_IDX                                                            1
#define regPA_SC_HP3D_TRAP_SCREEN_V                                                                     0x22aa
#define regPA_SC_HP3D_TRAP_SCREEN_V_BASE_IDX                                                            1
#define regPA_SC_HP3D_TRAP_SCREEN_OCCURRENCE                                                            0x22ab
#define regPA_SC_HP3D_TRAP_SCREEN_OCCURRENCE_BASE_IDX                                                   1
#define regPA_SC_HP3D_TRAP_SCREEN_COUNT                                                                 0x22ac
#define regPA_SC_HP3D_TRAP_SCREEN_COUNT_BASE_IDX                                                        1
#define regPA_SC_TRAP_SCREEN_HV_EN                                                                      0x22b0
#define regPA_SC_TRAP_SCREEN_HV_EN_BASE_IDX                                                             1
#define regPA_SC_TRAP_SCREEN_H                                                                          0x22b1
#define regPA_SC_TRAP_SCREEN_H_BASE_IDX                                                                 1
#define regPA_SC_TRAP_SCREEN_V                                                                          0x22b2
#define regPA_SC_TRAP_SCREEN_V_BASE_IDX                                                                 1
#define regPA_SC_TRAP_SCREEN_OCCURRENCE                                                                 0x22b3
#define regPA_SC_TRAP_SCREEN_OCCURRENCE_BASE_IDX                                                        1
#define regPA_SC_TRAP_SCREEN_COUNT                                                                      0x22b4
#define regPA_SC_TRAP_SCREEN_COUNT_BASE_IDX                                                             1
#define regPA_STATE_STEREO_X                                                                            0x22b5
#define regPA_STATE_STEREO_X_BASE_IDX                                                                   1
#define regSQ_THREAD_TRACE_BASE                                                                         0x2330
#define regSQ_THREAD_TRACE_BASE_BASE_IDX                                                                1
#define regSQ_THREAD_TRACE_SIZE                                                                         0x2331
#define regSQ_THREAD_TRACE_SIZE_BASE_IDX                                                                1
#define regSQ_THREAD_TRACE_MASK                                                                         0x2332
#define regSQ_THREAD_TRACE_MASK_BASE_IDX                                                                1
#define regSQ_THREAD_TRACE_TOKEN_MASK                                                                   0x2333
#define regSQ_THREAD_TRACE_TOKEN_MASK_BASE_IDX                                                          1
#define regSQ_THREAD_TRACE_PERF_MASK                                                                    0x2334
#define regSQ_THREAD_TRACE_PERF_MASK_BASE_IDX                                                           1
#define regSQ_THREAD_TRACE_CTRL                                                                         0x2335
#define regSQ_THREAD_TRACE_CTRL_BASE_IDX                                                                1
#define regSQ_THREAD_TRACE_MODE                                                                         0x2336
#define regSQ_THREAD_TRACE_MODE_BASE_IDX                                                                1
#define regSQ_THREAD_TRACE_BASE2                                                                        0x2337
#define regSQ_THREAD_TRACE_BASE2_BASE_IDX                                                               1
#define regSQ_THREAD_TRACE_TOKEN_MASK2                                                                  0x2338
#define regSQ_THREAD_TRACE_TOKEN_MASK2_BASE_IDX                                                         1
#define regSQ_THREAD_TRACE_WPTR                                                                         0x2339
#define regSQ_THREAD_TRACE_WPTR_BASE_IDX                                                                1
#define regSQ_THREAD_TRACE_STATUS                                                                       0x233a
#define regSQ_THREAD_TRACE_STATUS_BASE_IDX                                                              1
#define regSQ_THREAD_TRACE_HIWATER                                                                      0x233b
#define regSQ_THREAD_TRACE_HIWATER_BASE_IDX                                                             1
#define regSQ_THREAD_TRACE_CNTR                                                                         0x233c
#define regSQ_THREAD_TRACE_CNTR_BASE_IDX                                                                1
#define regSQ_THREAD_TRACE_USERDATA_0                                                                   0x2340
#define regSQ_THREAD_TRACE_USERDATA_0_BASE_IDX                                                          1
#define regSQ_THREAD_TRACE_USERDATA_1                                                                   0x2341
#define regSQ_THREAD_TRACE_USERDATA_1_BASE_IDX                                                          1
#define regSQ_THREAD_TRACE_USERDATA_2                                                                   0x2342
#define regSQ_THREAD_TRACE_USERDATA_2_BASE_IDX                                                          1
#define regSQ_THREAD_TRACE_USERDATA_3                                                                   0x2343
#define regSQ_THREAD_TRACE_USERDATA_3_BASE_IDX                                                          1
#define regSQC_CACHES                                                                                   0x2348
#define regSQC_CACHES_BASE_IDX                                                                          1
#define regSQC_WRITEBACK                                                                                0x2349
#define regSQC_WRITEBACK_BASE_IDX                                                                       1
#define regDB_OCCLUSION_COUNT0_LOW                                                                      0x23c0
#define regDB_OCCLUSION_COUNT0_LOW_BASE_IDX                                                             1
#define regDB_OCCLUSION_COUNT0_HI                                                                       0x23c1
#define regDB_OCCLUSION_COUNT0_HI_BASE_IDX                                                              1
#define regDB_OCCLUSION_COUNT1_LOW                                                                      0x23c2
#define regDB_OCCLUSION_COUNT1_LOW_BASE_IDX                                                             1
#define regDB_OCCLUSION_COUNT1_HI                                                                       0x23c3
#define regDB_OCCLUSION_COUNT1_HI_BASE_IDX                                                              1
#define regDB_OCCLUSION_COUNT2_LOW                                                                      0x23c4
#define regDB_OCCLUSION_COUNT2_LOW_BASE_IDX                                                             1
#define regDB_OCCLUSION_COUNT2_HI                                                                       0x23c5
#define regDB_OCCLUSION_COUNT2_HI_BASE_IDX                                                              1
#define regDB_OCCLUSION_COUNT3_LOW                                                                      0x23c6
#define regDB_OCCLUSION_COUNT3_LOW_BASE_IDX                                                             1
#define regDB_OCCLUSION_COUNT3_HI                                                                       0x23c7
#define regDB_OCCLUSION_COUNT3_HI_BASE_IDX                                                              1
#define regDB_ZPASS_COUNT_LOW                                                                           0x23fe
#define regDB_ZPASS_COUNT_LOW_BASE_IDX                                                                  1
#define regDB_ZPASS_COUNT_HI                                                                            0x23ff
#define regDB_ZPASS_COUNT_HI_BASE_IDX                                                                   1
#define regGDS_RD_ADDR                                                                                  0x2400
#define regGDS_RD_ADDR_BASE_IDX                                                                         1
#define regGDS_RD_DATA                                                                                  0x2401
#define regGDS_RD_DATA_BASE_IDX                                                                         1
#define regGDS_RD_BURST_ADDR                                                                            0x2402
#define regGDS_RD_BURST_ADDR_BASE_IDX                                                                   1
#define regGDS_RD_BURST_COUNT                                                                           0x2403
#define regGDS_RD_BURST_COUNT_BASE_IDX                                                                  1
#define regGDS_RD_BURST_DATA                                                                            0x2404
#define regGDS_RD_BURST_DATA_BASE_IDX                                                                   1
#define regGDS_WR_ADDR                                                                                  0x2405
#define regGDS_WR_ADDR_BASE_IDX                                                                         1
#define regGDS_WR_DATA                                                                                  0x2406
#define regGDS_WR_DATA_BASE_IDX                                                                         1
#define regGDS_WR_BURST_ADDR                                                                            0x2407
#define regGDS_WR_BURST_ADDR_BASE_IDX                                                                   1
#define regGDS_WR_BURST_DATA                                                                            0x2408
#define regGDS_WR_BURST_DATA_BASE_IDX                                                                   1
#define regGDS_WRITE_COMPLETE                                                                           0x2409
#define regGDS_WRITE_COMPLETE_BASE_IDX                                                                  1
#define regGDS_ATOM_CNTL                                                                                0x240a
#define regGDS_ATOM_CNTL_BASE_IDX                                                                       1
#define regGDS_ATOM_COMPLETE                                                                            0x240b
#define regGDS_ATOM_COMPLETE_BASE_IDX                                                                   1
#define regGDS_ATOM_BASE                                                                                0x240c
#define regGDS_ATOM_BASE_BASE_IDX                                                                       1
#define regGDS_ATOM_SIZE                                                                                0x240d
#define regGDS_ATOM_SIZE_BASE_IDX                                                                       1
#define regGDS_ATOM_OFFSET0                                                                             0x240e
#define regGDS_ATOM_OFFSET0_BASE_IDX                                                                    1
#define regGDS_ATOM_OFFSET1                                                                             0x240f
#define regGDS_ATOM_OFFSET1_BASE_IDX                                                                    1
#define regGDS_ATOM_DST                                                                                 0x2410
#define regGDS_ATOM_DST_BASE_IDX                                                                        1
#define regGDS_ATOM_OP                                                                                  0x2411
#define regGDS_ATOM_OP_BASE_IDX                                                                         1
#define regGDS_ATOM_SRC0                                                                                0x2412
#define regGDS_ATOM_SRC0_BASE_IDX                                                                       1
#define regGDS_ATOM_SRC0_U                                                                              0x2413
#define regGDS_ATOM_SRC0_U_BASE_IDX                                                                     1
#define regGDS_ATOM_SRC1                                                                                0x2414
#define regGDS_ATOM_SRC1_BASE_IDX                                                                       1
#define regGDS_ATOM_SRC1_U                                                                              0x2415
#define regGDS_ATOM_SRC1_U_BASE_IDX                                                                     1
#define regGDS_ATOM_READ0                                                                               0x2416
#define regGDS_ATOM_READ0_BASE_IDX                                                                      1
#define regGDS_ATOM_READ0_U                                                                             0x2417
#define regGDS_ATOM_READ0_U_BASE_IDX                                                                    1
#define regGDS_ATOM_READ1                                                                               0x2418
#define regGDS_ATOM_READ1_BASE_IDX                                                                      1
#define regGDS_ATOM_READ1_U                                                                             0x2419
#define regGDS_ATOM_READ1_U_BASE_IDX                                                                    1
#define regGDS_GWS_RESOURCE_CNTL                                                                        0x241a
#define regGDS_GWS_RESOURCE_CNTL_BASE_IDX                                                               1
#define regGDS_GWS_RESOURCE                                                                             0x241b
#define regGDS_GWS_RESOURCE_BASE_IDX                                                                    1
#define regGDS_GWS_RESOURCE_CNT                                                                         0x241c
#define regGDS_GWS_RESOURCE_CNT_BASE_IDX                                                                1
#define regGDS_OA_CNTL                                                                                  0x241d
#define regGDS_OA_CNTL_BASE_IDX                                                                         1
#define regGDS_OA_COUNTER                                                                               0x241e
#define regGDS_OA_COUNTER_BASE_IDX                                                                      1
#define regGDS_OA_ADDRESS                                                                               0x241f
#define regGDS_OA_ADDRESS_BASE_IDX                                                                      1
#define regGDS_OA_INCDEC                                                                                0x2420
#define regGDS_OA_INCDEC_BASE_IDX                                                                       1
#define regGDS_OA_RING_SIZE                                                                             0x2421
#define regGDS_OA_RING_SIZE_BASE_IDX                                                                    1
#define regSPI_CONFIG_CNTL                                                                              0x2440
#define regSPI_CONFIG_CNTL_BASE_IDX                                                                     1
#define regSPI_CONFIG_CNTL_1                                                                            0x2441
#define regSPI_CONFIG_CNTL_1_BASE_IDX                                                                   1
#define regSPI_CONFIG_CNTL_2                                                                            0x2442
#define regSPI_CONFIG_CNTL_2_BASE_IDX                                                                   1
#define regSPI_WAVE_LIMIT_CNTL                                                                          0x2443
#define regSPI_WAVE_LIMIT_CNTL_BASE_IDX                                                                 1

// addressBlock: xcd0_gc_gccanedec
// base address: 0x33d00
#define regGC_CANE_ERR_STATUS                                                                           0x2f4d
#define regGC_CANE_ERR_STATUS_BASE_IDX                                                                  1
#define regGC_CANE_UE_ERR_STATUS_LO                                                                     0x2f4e
#define regGC_CANE_UE_ERR_STATUS_LO_BASE_IDX                                                            1
#define regGC_CANE_UE_ERR_STATUS_HI                                                                     0x2f4f
#define regGC_CANE_UE_ERR_STATUS_HI_BASE_IDX                                                            1
#define regGC_CANE_CE_ERR_STATUS_LO                                                                     0x2f50
#define regGC_CANE_CE_ERR_STATUS_LO_BASE_IDX                                                            1
#define regGC_CANE_CE_ERR_STATUS_HI                                                                     0x2f51
#define regGC_CANE_CE_ERR_STATUS_HI_BASE_IDX                                                            1

// addressBlock: xcd0_gc_perfddec
// base address: 0x34000
#define regCPG_PERFCOUNTER1_LO                                                                          0x3000
#define regCPG_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define regCPG_PERFCOUNTER1_HI                                                                          0x3001
#define regCPG_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define regCPG_PERFCOUNTER0_LO                                                                          0x3002
#define regCPG_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define regCPG_PERFCOUNTER0_HI                                                                          0x3003
#define regCPG_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define regCPC_PERFCOUNTER1_LO                                                                          0x3004
#define regCPC_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define regCPC_PERFCOUNTER1_HI                                                                          0x3005
#define regCPC_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define regCPC_PERFCOUNTER0_LO                                                                          0x3006
#define regCPC_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define regCPC_PERFCOUNTER0_HI                                                                          0x3007
#define regCPC_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define regCPF_PERFCOUNTER1_LO                                                                          0x3008
#define regCPF_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define regCPF_PERFCOUNTER1_HI                                                                          0x3009
#define regCPF_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define regCPF_PERFCOUNTER0_LO                                                                          0x300a
#define regCPF_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define regCPF_PERFCOUNTER0_HI                                                                          0x300b
#define regCPF_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define regCPF_LATENCY_STATS_DATA                                                                       0x300c
#define regCPF_LATENCY_STATS_DATA_BASE_IDX                                                              1
#define regCPG_LATENCY_STATS_DATA                                                                       0x300d
#define regCPG_LATENCY_STATS_DATA_BASE_IDX                                                              1
#define regCPC_LATENCY_STATS_DATA                                                                       0x300e
#define regCPC_LATENCY_STATS_DATA_BASE_IDX                                                              1
#define regGRBM_PERFCOUNTER0_LO                                                                         0x3040
#define regGRBM_PERFCOUNTER0_LO_BASE_IDX                                                                1
#define regGRBM_PERFCOUNTER0_HI                                                                         0x3041
#define regGRBM_PERFCOUNTER0_HI_BASE_IDX                                                                1
#define regGRBM_PERFCOUNTER1_LO                                                                         0x3043
#define regGRBM_PERFCOUNTER1_LO_BASE_IDX                                                                1
#define regGRBM_PERFCOUNTER1_HI                                                                         0x3044
#define regGRBM_PERFCOUNTER1_HI_BASE_IDX                                                                1
#define regGRBM_SE0_PERFCOUNTER_LO                                                                      0x3045
#define regGRBM_SE0_PERFCOUNTER_LO_BASE_IDX                                                             1
#define regGRBM_SE0_PERFCOUNTER_HI                                                                      0x3046
#define regGRBM_SE0_PERFCOUNTER_HI_BASE_IDX                                                             1
#define regGRBM_SE1_PERFCOUNTER_LO                                                                      0x3047
#define regGRBM_SE1_PERFCOUNTER_LO_BASE_IDX                                                             1
#define regGRBM_SE1_PERFCOUNTER_HI                                                                      0x3048
#define regGRBM_SE1_PERFCOUNTER_HI_BASE_IDX                                                             1
#define regGRBM_SE2_PERFCOUNTER_LO                                                                      0x3049
#define regGRBM_SE2_PERFCOUNTER_LO_BASE_IDX                                                             1
#define regGRBM_SE2_PERFCOUNTER_HI                                                                      0x304a
#define regGRBM_SE2_PERFCOUNTER_HI_BASE_IDX                                                             1
#define regGRBM_SE3_PERFCOUNTER_LO                                                                      0x304b
#define regGRBM_SE3_PERFCOUNTER_LO_BASE_IDX                                                             1
#define regGRBM_SE3_PERFCOUNTER_HI                                                                      0x304c
#define regGRBM_SE3_PERFCOUNTER_HI_BASE_IDX                                                             1
#define regWD_PERFCOUNTER0_LO                                                                           0x3080
#define regWD_PERFCOUNTER0_LO_BASE_IDX                                                                  1
#define regWD_PERFCOUNTER0_HI                                                                           0x3081
#define regWD_PERFCOUNTER0_HI_BASE_IDX                                                                  1
#define regWD_PERFCOUNTER1_LO                                                                           0x3082
#define regWD_PERFCOUNTER1_LO_BASE_IDX                                                                  1
#define regWD_PERFCOUNTER1_HI                                                                           0x3083
#define regWD_PERFCOUNTER1_HI_BASE_IDX                                                                  1
#define regWD_PERFCOUNTER2_LO                                                                           0x3084
#define regWD_PERFCOUNTER2_LO_BASE_IDX                                                                  1
#define regWD_PERFCOUNTER2_HI                                                                           0x3085
#define regWD_PERFCOUNTER2_HI_BASE_IDX                                                                  1
#define regWD_PERFCOUNTER3_LO                                                                           0x3086
#define regWD_PERFCOUNTER3_LO_BASE_IDX                                                                  1
#define regWD_PERFCOUNTER3_HI                                                                           0x3087
#define regWD_PERFCOUNTER3_HI_BASE_IDX                                                                  1
#define regIA_PERFCOUNTER0_LO                                                                           0x3088
#define regIA_PERFCOUNTER0_LO_BASE_IDX                                                                  1
#define regIA_PERFCOUNTER0_HI                                                                           0x3089
#define regIA_PERFCOUNTER0_HI_BASE_IDX                                                                  1
#define regIA_PERFCOUNTER1_LO                                                                           0x308a
#define regIA_PERFCOUNTER1_LO_BASE_IDX                                                                  1
#define regIA_PERFCOUNTER1_HI                                                                           0x308b
#define regIA_PERFCOUNTER1_HI_BASE_IDX                                                                  1
#define regIA_PERFCOUNTER2_LO                                                                           0x308c
#define regIA_PERFCOUNTER2_LO_BASE_IDX                                                                  1
#define regIA_PERFCOUNTER2_HI                                                                           0x308d
#define regIA_PERFCOUNTER2_HI_BASE_IDX                                                                  1
#define regIA_PERFCOUNTER3_LO                                                                           0x308e
#define regIA_PERFCOUNTER3_LO_BASE_IDX                                                                  1
#define regIA_PERFCOUNTER3_HI                                                                           0x308f
#define regIA_PERFCOUNTER3_HI_BASE_IDX                                                                  1
#define regVGT_PERFCOUNTER0_LO                                                                          0x3090
#define regVGT_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define regVGT_PERFCOUNTER0_HI                                                                          0x3091
#define regVGT_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define regVGT_PERFCOUNTER1_LO                                                                          0x3092
#define regVGT_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define regVGT_PERFCOUNTER1_HI                                                                          0x3093
#define regVGT_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define regVGT_PERFCOUNTER2_LO                                                                          0x3094
#define regVGT_PERFCOUNTER2_LO_BASE_IDX                                                                 1
#define regVGT_PERFCOUNTER2_HI                                                                          0x3095
#define regVGT_PERFCOUNTER2_HI_BASE_IDX                                                                 1
#define regVGT_PERFCOUNTER3_LO                                                                          0x3096
#define regVGT_PERFCOUNTER3_LO_BASE_IDX                                                                 1
#define regVGT_PERFCOUNTER3_HI                                                                          0x3097
#define regVGT_PERFCOUNTER3_HI_BASE_IDX                                                                 1
#define regPA_SU_PERFCOUNTER0_LO                                                                        0x3100
#define regPA_SU_PERFCOUNTER0_LO_BASE_IDX                                                               1
#define regPA_SU_PERFCOUNTER0_HI                                                                        0x3101
#define regPA_SU_PERFCOUNTER0_HI_BASE_IDX                                                               1
#define regPA_SU_PERFCOUNTER1_LO                                                                        0x3102
#define regPA_SU_PERFCOUNTER1_LO_BASE_IDX                                                               1
#define regPA_SU_PERFCOUNTER1_HI                                                                        0x3103
#define regPA_SU_PERFCOUNTER1_HI_BASE_IDX                                                               1
#define regPA_SU_PERFCOUNTER2_LO                                                                        0x3104
#define regPA_SU_PERFCOUNTER2_LO_BASE_IDX                                                               1
#define regPA_SU_PERFCOUNTER2_HI                                                                        0x3105
#define regPA_SU_PERFCOUNTER2_HI_BASE_IDX                                                               1
#define regPA_SU_PERFCOUNTER3_LO                                                                        0x3106
#define regPA_SU_PERFCOUNTER3_LO_BASE_IDX                                                               1
#define regPA_SU_PERFCOUNTER3_HI                                                                        0x3107
#define regPA_SU_PERFCOUNTER3_HI_BASE_IDX                                                               1
#define regPA_SC_PERFCOUNTER0_LO                                                                        0x3140
#define regPA_SC_PERFCOUNTER0_LO_BASE_IDX                                                               1
#define regPA_SC_PERFCOUNTER0_HI                                                                        0x3141
#define regPA_SC_PERFCOUNTER0_HI_BASE_IDX                                                               1
#define regPA_SC_PERFCOUNTER1_LO                                                                        0x3142
#define regPA_SC_PERFCOUNTER1_LO_BASE_IDX                                                               1
#define regPA_SC_PERFCOUNTER1_HI                                                                        0x3143
#define regPA_SC_PERFCOUNTER1_HI_BASE_IDX                                                               1
#define regPA_SC_PERFCOUNTER2_LO                                                                        0x3144
#define regPA_SC_PERFCOUNTER2_LO_BASE_IDX                                                               1
#define regPA_SC_PERFCOUNTER2_HI                                                                        0x3145
#define regPA_SC_PERFCOUNTER2_HI_BASE_IDX                                                               1
#define regPA_SC_PERFCOUNTER3_LO                                                                        0x3146
#define regPA_SC_PERFCOUNTER3_LO_BASE_IDX                                                               1
#define regPA_SC_PERFCOUNTER3_HI                                                                        0x3147
#define regPA_SC_PERFCOUNTER3_HI_BASE_IDX                                                               1
#define regPA_SC_PERFCOUNTER4_LO                                                                        0x3148
#define regPA_SC_PERFCOUNTER4_LO_BASE_IDX                                                               1
#define regPA_SC_PERFCOUNTER4_HI                                                                        0x3149
#define regPA_SC_PERFCOUNTER4_HI_BASE_IDX                                                               1
#define regPA_SC_PERFCOUNTER5_LO                                                                        0x314a
#define regPA_SC_PERFCOUNTER5_LO_BASE_IDX                                                               1
#define regPA_SC_PERFCOUNTER5_HI                                                                        0x314b
#define regPA_SC_PERFCOUNTER5_HI_BASE_IDX                                                               1
#define regPA_SC_PERFCOUNTER6_LO                                                                        0x314c
#define regPA_SC_PERFCOUNTER6_LO_BASE_IDX                                                               1
#define regPA_SC_PERFCOUNTER6_HI                                                                        0x314d
#define regPA_SC_PERFCOUNTER6_HI_BASE_IDX                                                               1
#define regPA_SC_PERFCOUNTER7_LO                                                                        0x314e
#define regPA_SC_PERFCOUNTER7_LO_BASE_IDX                                                               1
#define regPA_SC_PERFCOUNTER7_HI                                                                        0x314f
#define regPA_SC_PERFCOUNTER7_HI_BASE_IDX                                                               1
#define regSPI_PERFCOUNTER0_HI                                                                          0x3180
#define regSPI_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define regSPI_PERFCOUNTER0_LO                                                                          0x3181
#define regSPI_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define regSPI_PERFCOUNTER1_HI                                                                          0x3182
#define regSPI_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define regSPI_PERFCOUNTER1_LO                                                                          0x3183
#define regSPI_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define regSPI_PERFCOUNTER2_HI                                                                          0x3184
#define regSPI_PERFCOUNTER2_HI_BASE_IDX                                                                 1
#define regSPI_PERFCOUNTER2_LO                                                                          0x3185
#define regSPI_PERFCOUNTER2_LO_BASE_IDX                                                                 1
#define regSPI_PERFCOUNTER3_HI                                                                          0x3186
#define regSPI_PERFCOUNTER3_HI_BASE_IDX                                                                 1
#define regSPI_PERFCOUNTER3_LO                                                                          0x3187
#define regSPI_PERFCOUNTER3_LO_BASE_IDX                                                                 1
#define regSPI_PERFCOUNTER4_HI                                                                          0x3188
#define regSPI_PERFCOUNTER4_HI_BASE_IDX                                                                 1
#define regSPI_PERFCOUNTER4_LO                                                                          0x3189
#define regSPI_PERFCOUNTER4_LO_BASE_IDX                                                                 1
#define regSPI_PERFCOUNTER5_HI                                                                          0x318a
#define regSPI_PERFCOUNTER5_HI_BASE_IDX                                                                 1
#define regSPI_PERFCOUNTER5_LO                                                                          0x318b
#define regSPI_PERFCOUNTER5_LO_BASE_IDX                                                                 1
#define regSQ_PERFCOUNTER0_LO                                                                           0x31c0
#define regSQ_PERFCOUNTER0_LO_BASE_IDX                                                                  1
#define regSQ_PERFCOUNTER0_HI                                                                           0x31c1
#define regSQ_PERFCOUNTER0_HI_BASE_IDX                                                                  1
#define regSQ_PERFCOUNTER1_LO                                                                           0x31c2
#define regSQ_PERFCOUNTER1_LO_BASE_IDX                                                                  1
#define regSQ_PERFCOUNTER1_HI                                                                           0x31c3
#define regSQ_PERFCOUNTER1_HI_BASE_IDX                                                                  1
#define regSQ_PERFCOUNTER2_LO                                                                           0x31c4
#define regSQ_PERFCOUNTER2_LO_BASE_IDX                                                                  1
#define regSQ_PERFCOUNTER2_HI                                                                           0x31c5
#define regSQ_PERFCOUNTER2_HI_BASE_IDX                                                                  1
#define regSQ_PERFCOUNTER3_LO                                                                           0x31c6
#define regSQ_PERFCOUNTER3_LO_BASE_IDX                                                                  1
#define regSQ_PERFCOUNTER3_HI                                                                           0x31c7
#define regSQ_PERFCOUNTER3_HI_BASE_IDX                                                                  1
#define regSQ_PERFCOUNTER4_LO                                                                           0x31c8
#define regSQ_PERFCOUNTER4_LO_BASE_IDX                                                                  1
#define regSQ_PERFCOUNTER4_HI                                                                           0x31c9
#define regSQ_PERFCOUNTER4_HI_BASE_IDX                                                                  1
#define regSQ_PERFCOUNTER5_LO                                                                           0x31ca
#define regSQ_PERFCOUNTER5_LO_BASE_IDX                                                                  1
#define regSQ_PERFCOUNTER5_HI                                                                           0x31cb
#define regSQ_PERFCOUNTER5_HI_BASE_IDX                                                                  1
#define regSQ_PERFCOUNTER6_LO                                                                           0x31cc
#define regSQ_PERFCOUNTER6_LO_BASE_IDX                                                                  1
#define regSQ_PERFCOUNTER6_HI                                                                           0x31cd
#define regSQ_PERFCOUNTER6_HI_BASE_IDX                                                                  1
#define regSQ_PERFCOUNTER7_LO                                                                           0x31ce
#define regSQ_PERFCOUNTER7_LO_BASE_IDX                                                                  1
#define regSQ_PERFCOUNTER7_HI                                                                           0x31cf
#define regSQ_PERFCOUNTER7_HI_BASE_IDX                                                                  1
#define regSQ_PERFCOUNTER8_LO                                                                           0x31d0
#define regSQ_PERFCOUNTER8_LO_BASE_IDX                                                                  1
#define regSQ_PERFCOUNTER8_HI                                                                           0x31d1
#define regSQ_PERFCOUNTER8_HI_BASE_IDX                                                                  1
#define regSQ_PERFCOUNTER9_LO                                                                           0x31d2
#define regSQ_PERFCOUNTER9_LO_BASE_IDX                                                                  1
#define regSQ_PERFCOUNTER9_HI                                                                           0x31d3
#define regSQ_PERFCOUNTER9_HI_BASE_IDX                                                                  1
#define regSQ_PERFCOUNTER10_LO                                                                          0x31d4
#define regSQ_PERFCOUNTER10_LO_BASE_IDX                                                                 1
#define regSQ_PERFCOUNTER10_HI                                                                          0x31d5
#define regSQ_PERFCOUNTER10_HI_BASE_IDX                                                                 1
#define regSQ_PERFCOUNTER11_LO                                                                          0x31d6
#define regSQ_PERFCOUNTER11_LO_BASE_IDX                                                                 1
#define regSQ_PERFCOUNTER11_HI                                                                          0x31d7
#define regSQ_PERFCOUNTER11_HI_BASE_IDX                                                                 1
#define regSQ_PERFCOUNTER12_LO                                                                          0x31d8
#define regSQ_PERFCOUNTER12_LO_BASE_IDX                                                                 1
#define regSQ_PERFCOUNTER12_HI                                                                          0x31d9
#define regSQ_PERFCOUNTER12_HI_BASE_IDX                                                                 1
#define regSQ_PERFCOUNTER13_LO                                                                          0x31da
#define regSQ_PERFCOUNTER13_LO_BASE_IDX                                                                 1
#define regSQ_PERFCOUNTER13_HI                                                                          0x31db
#define regSQ_PERFCOUNTER13_HI_BASE_IDX                                                                 1
#define regSQ_PERFCOUNTER14_LO                                                                          0x31dc
#define regSQ_PERFCOUNTER14_LO_BASE_IDX                                                                 1
#define regSQ_PERFCOUNTER14_HI                                                                          0x31dd
#define regSQ_PERFCOUNTER14_HI_BASE_IDX                                                                 1
#define regSQ_PERFCOUNTER15_LO                                                                          0x31de
#define regSQ_PERFCOUNTER15_LO_BASE_IDX                                                                 1
#define regSQ_PERFCOUNTER15_HI                                                                          0x31df
#define regSQ_PERFCOUNTER15_HI_BASE_IDX                                                                 1
#define regSX_PERFCOUNTER0_LO                                                                           0x3240
#define regSX_PERFCOUNTER0_LO_BASE_IDX                                                                  1
#define regSX_PERFCOUNTER0_HI                                                                           0x3241
#define regSX_PERFCOUNTER0_HI_BASE_IDX                                                                  1
#define regSX_PERFCOUNTER1_LO                                                                           0x3242
#define regSX_PERFCOUNTER1_LO_BASE_IDX                                                                  1
#define regSX_PERFCOUNTER1_HI                                                                           0x3243
#define regSX_PERFCOUNTER1_HI_BASE_IDX                                                                  1
#define regSX_PERFCOUNTER2_LO                                                                           0x3244
#define regSX_PERFCOUNTER2_LO_BASE_IDX                                                                  1
#define regSX_PERFCOUNTER2_HI                                                                           0x3245
#define regSX_PERFCOUNTER2_HI_BASE_IDX                                                                  1
#define regSX_PERFCOUNTER3_LO                                                                           0x3246
#define regSX_PERFCOUNTER3_LO_BASE_IDX                                                                  1
#define regSX_PERFCOUNTER3_HI                                                                           0x3247
#define regSX_PERFCOUNTER3_HI_BASE_IDX                                                                  1
#define regGDS_PERFCOUNTER0_LO                                                                          0x3280
#define regGDS_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define regGDS_PERFCOUNTER0_HI                                                                          0x3281
#define regGDS_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define regGDS_PERFCOUNTER1_LO                                                                          0x3282
#define regGDS_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define regGDS_PERFCOUNTER1_HI                                                                          0x3283
#define regGDS_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define regGDS_PERFCOUNTER2_LO                                                                          0x3284
#define regGDS_PERFCOUNTER2_LO_BASE_IDX                                                                 1
#define regGDS_PERFCOUNTER2_HI                                                                          0x3285
#define regGDS_PERFCOUNTER2_HI_BASE_IDX                                                                 1
#define regGDS_PERFCOUNTER3_LO                                                                          0x3286
#define regGDS_PERFCOUNTER3_LO_BASE_IDX                                                                 1
#define regGDS_PERFCOUNTER3_HI                                                                          0x3287
#define regGDS_PERFCOUNTER3_HI_BASE_IDX                                                                 1
#define regTA_PERFCOUNTER0_LO                                                                           0x32c0
#define regTA_PERFCOUNTER0_LO_BASE_IDX                                                                  1
#define regTA_PERFCOUNTER0_HI                                                                           0x32c1
#define regTA_PERFCOUNTER0_HI_BASE_IDX                                                                  1
#define regTA_PERFCOUNTER1_LO                                                                           0x32c2
#define regTA_PERFCOUNTER1_LO_BASE_IDX                                                                  1
#define regTA_PERFCOUNTER1_HI                                                                           0x32c3
#define regTA_PERFCOUNTER1_HI_BASE_IDX                                                                  1
#define regTD_PERFCOUNTER0_LO                                                                           0x3300
#define regTD_PERFCOUNTER0_LO_BASE_IDX                                                                  1
#define regTD_PERFCOUNTER0_HI                                                                           0x3301
#define regTD_PERFCOUNTER0_HI_BASE_IDX                                                                  1
#define regTD_PERFCOUNTER1_LO                                                                           0x3302
#define regTD_PERFCOUNTER1_LO_BASE_IDX                                                                  1
#define regTD_PERFCOUNTER1_HI                                                                           0x3303
#define regTD_PERFCOUNTER1_HI_BASE_IDX                                                                  1
#define regTCP_PERFCOUNTER0_LO                                                                          0x3340
#define regTCP_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define regTCP_PERFCOUNTER0_HI                                                                          0x3341
#define regTCP_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define regTCP_PERFCOUNTER1_LO                                                                          0x3342
#define regTCP_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define regTCP_PERFCOUNTER1_HI                                                                          0x3343
#define regTCP_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define regTCP_PERFCOUNTER2_LO                                                                          0x3344
#define regTCP_PERFCOUNTER2_LO_BASE_IDX                                                                 1
#define regTCP_PERFCOUNTER2_HI                                                                          0x3345
#define regTCP_PERFCOUNTER2_HI_BASE_IDX                                                                 1
#define regTCP_PERFCOUNTER3_LO                                                                          0x3346
#define regTCP_PERFCOUNTER3_LO_BASE_IDX                                                                 1
#define regTCP_PERFCOUNTER3_HI                                                                          0x3347
#define regTCP_PERFCOUNTER3_HI_BASE_IDX                                                                 1
#define regTCC_PERFCOUNTER0_LO                                                                          0x3380
#define regTCC_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define regTCC_PERFCOUNTER0_HI                                                                          0x3381
#define regTCC_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define regTCC_PERFCOUNTER1_LO                                                                          0x3382
#define regTCC_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define regTCC_PERFCOUNTER1_HI                                                                          0x3383
#define regTCC_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define regTCC_PERFCOUNTER2_LO                                                                          0x3384
#define regTCC_PERFCOUNTER2_LO_BASE_IDX                                                                 1
#define regTCC_PERFCOUNTER2_HI                                                                          0x3385
#define regTCC_PERFCOUNTER2_HI_BASE_IDX                                                                 1
#define regTCC_PERFCOUNTER3_LO                                                                          0x3386
#define regTCC_PERFCOUNTER3_LO_BASE_IDX                                                                 1
#define regTCC_PERFCOUNTER3_HI                                                                          0x3387
#define regTCC_PERFCOUNTER3_HI_BASE_IDX                                                                 1
#define regTCA_PERFCOUNTER0_LO                                                                          0x3390
#define regTCA_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define regTCA_PERFCOUNTER0_HI                                                                          0x3391
#define regTCA_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define regTCA_PERFCOUNTER1_LO                                                                          0x3392
#define regTCA_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define regTCA_PERFCOUNTER1_HI                                                                          0x3393
#define regTCA_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define regTCA_PERFCOUNTER2_LO                                                                          0x3394
#define regTCA_PERFCOUNTER2_LO_BASE_IDX                                                                 1
#define regTCA_PERFCOUNTER2_HI                                                                          0x3395
#define regTCA_PERFCOUNTER2_HI_BASE_IDX                                                                 1
#define regTCA_PERFCOUNTER3_LO                                                                          0x3396
#define regTCA_PERFCOUNTER3_LO_BASE_IDX                                                                 1
#define regTCA_PERFCOUNTER3_HI                                                                          0x3397
#define regTCA_PERFCOUNTER3_HI_BASE_IDX                                                                 1
#define regCB_PERFCOUNTER0_LO                                                                           0x3406
#define regCB_PERFCOUNTER0_LO_BASE_IDX                                                                  1
#define regCB_PERFCOUNTER0_HI                                                                           0x3407
#define regCB_PERFCOUNTER0_HI_BASE_IDX                                                                  1
#define regCB_PERFCOUNTER1_LO                                                                           0x3408
#define regCB_PERFCOUNTER1_LO_BASE_IDX                                                                  1
#define regCB_PERFCOUNTER1_HI                                                                           0x3409
#define regCB_PERFCOUNTER1_HI_BASE_IDX                                                                  1
#define regCB_PERFCOUNTER2_LO                                                                           0x340a
#define regCB_PERFCOUNTER2_LO_BASE_IDX                                                                  1
#define regCB_PERFCOUNTER2_HI                                                                           0x340b
#define regCB_PERFCOUNTER2_HI_BASE_IDX                                                                  1
#define regCB_PERFCOUNTER3_LO                                                                           0x340c
#define regCB_PERFCOUNTER3_LO_BASE_IDX                                                                  1
#define regCB_PERFCOUNTER3_HI                                                                           0x340d
#define regCB_PERFCOUNTER3_HI_BASE_IDX                                                                  1
#define regDB_PERFCOUNTER0_LO                                                                           0x3440
#define regDB_PERFCOUNTER0_LO_BASE_IDX                                                                  1
#define regDB_PERFCOUNTER0_HI                                                                           0x3441
#define regDB_PERFCOUNTER0_HI_BASE_IDX                                                                  1
#define regDB_PERFCOUNTER1_LO                                                                           0x3442
#define regDB_PERFCOUNTER1_LO_BASE_IDX                                                                  1
#define regDB_PERFCOUNTER1_HI                                                                           0x3443
#define regDB_PERFCOUNTER1_HI_BASE_IDX                                                                  1
#define regDB_PERFCOUNTER2_LO                                                                           0x3444
#define regDB_PERFCOUNTER2_LO_BASE_IDX                                                                  1
#define regDB_PERFCOUNTER2_HI                                                                           0x3445
#define regDB_PERFCOUNTER2_HI_BASE_IDX                                                                  1
#define regDB_PERFCOUNTER3_LO                                                                           0x3446
#define regDB_PERFCOUNTER3_LO_BASE_IDX                                                                  1
#define regDB_PERFCOUNTER3_HI                                                                           0x3447
#define regDB_PERFCOUNTER3_HI_BASE_IDX                                                                  1
#define regRLC_PERFCOUNTER0_LO                                                                          0x3480
#define regRLC_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define regRLC_PERFCOUNTER0_HI                                                                          0x3481
#define regRLC_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define regRLC_PERFCOUNTER1_LO                                                                          0x3482
#define regRLC_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define regRLC_PERFCOUNTER1_HI                                                                          0x3483
#define regRLC_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define regRMI_PERFCOUNTER0_LO                                                                          0x34c0
#define regRMI_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define regRMI_PERFCOUNTER0_HI                                                                          0x34c1
#define regRMI_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define regRMI_PERFCOUNTER1_LO                                                                          0x34c2
#define regRMI_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define regRMI_PERFCOUNTER1_HI                                                                          0x34c3
#define regRMI_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define regRMI_PERFCOUNTER2_LO                                                                          0x34c4
#define regRMI_PERFCOUNTER2_LO_BASE_IDX                                                                 1
#define regRMI_PERFCOUNTER2_HI                                                                          0x34c5
#define regRMI_PERFCOUNTER2_HI_BASE_IDX                                                                 1
#define regRMI_PERFCOUNTER3_LO                                                                          0x34c6
#define regRMI_PERFCOUNTER3_LO_BASE_IDX                                                                 1
#define regRMI_PERFCOUNTER3_HI                                                                          0x34c7
#define regRMI_PERFCOUNTER3_HI_BASE_IDX                                                                 1


// addressBlock: xcd0_gc_utcl2_atcl2pfcntrdec
// base address: 0x35400
#define regATC_L2_PERFCOUNTER_LO                                                                        0x3500
#define regATC_L2_PERFCOUNTER_LO_BASE_IDX                                                               1
#define regATC_L2_PERFCOUNTER_HI                                                                        0x3501
#define regATC_L2_PERFCOUNTER_HI_BASE_IDX                                                               1


// addressBlock: xcd0_gc_utcl2_vml2prdec
// base address: 0x35408
#define regMC_VM_L2_PERFCOUNTER_LO                                                                      0x3502
#define regMC_VM_L2_PERFCOUNTER_LO_BASE_IDX                                                             1
#define regMC_VM_L2_PERFCOUNTER_HI                                                                      0x3503
#define regMC_VM_L2_PERFCOUNTER_HI_BASE_IDX                                                             1


// addressBlock: xcd0_gc_utcl2_l2tlbprdec
// base address: 0x35448
#define regL2TLB_PERFCOUNTER_LO                                                                         0x3512
#define regL2TLB_PERFCOUNTER_LO_BASE_IDX                                                                1
#define regL2TLB_PERFCOUNTER_HI                                                                         0x3513
#define regL2TLB_PERFCOUNTER_HI_BASE_IDX                                                                1


// addressBlock: xcd0_gc_perfsdec
// base address: 0x36000
#define regCPG_PERFCOUNTER1_SELECT                                                                      0x3800
#define regCPG_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define regCPG_PERFCOUNTER0_SELECT1                                                                     0x3801
#define regCPG_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define regCPG_PERFCOUNTER0_SELECT                                                                      0x3802
#define regCPG_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define regCPC_PERFCOUNTER1_SELECT                                                                      0x3803
#define regCPC_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define regCPC_PERFCOUNTER0_SELECT1                                                                     0x3804
#define regCPC_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define regCPF_PERFCOUNTER1_SELECT                                                                      0x3805
#define regCPF_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define regCPF_PERFCOUNTER0_SELECT1                                                                     0x3806
#define regCPF_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define regCPF_PERFCOUNTER0_SELECT                                                                      0x3807
#define regCPF_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define regCP_PERFMON_CNTL                                                                              0x3808
#define regCP_PERFMON_CNTL_BASE_IDX                                                                     1
#define regCPC_PERFCOUNTER0_SELECT                                                                      0x3809
#define regCPC_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define regCPF_TC_PERF_COUNTER_WINDOW_SELECT                                                            0x380a
#define regCPF_TC_PERF_COUNTER_WINDOW_SELECT_BASE_IDX                                                   1
#define regCPG_TC_PERF_COUNTER_WINDOW_SELECT                                                            0x380b
#define regCPG_TC_PERF_COUNTER_WINDOW_SELECT_BASE_IDX                                                   1
#define regCPF_LATENCY_STATS_SELECT                                                                     0x380c
#define regCPF_LATENCY_STATS_SELECT_BASE_IDX                                                            1
#define regCPG_LATENCY_STATS_SELECT                                                                     0x380d
#define regCPG_LATENCY_STATS_SELECT_BASE_IDX                                                            1
#define regCPC_LATENCY_STATS_SELECT                                                                     0x380e
#define regCPC_LATENCY_STATS_SELECT_BASE_IDX                                                            1
#define regCP_DRAW_OBJECT                                                                               0x3810
#define regCP_DRAW_OBJECT_BASE_IDX                                                                      1
#define regCP_DRAW_OBJECT_COUNTER                                                                       0x3811
#define regCP_DRAW_OBJECT_COUNTER_BASE_IDX                                                              1
#define regCP_DRAW_WINDOW_MASK_HI                                                                       0x3812
#define regCP_DRAW_WINDOW_MASK_HI_BASE_IDX                                                              1
#define regCP_DRAW_WINDOW_HI                                                                            0x3813
#define regCP_DRAW_WINDOW_HI_BASE_IDX                                                                   1
#define regCP_DRAW_WINDOW_LO                                                                            0x3814
#define regCP_DRAW_WINDOW_LO_BASE_IDX                                                                   1
#define regCP_DRAW_WINDOW_CNTL                                                                          0x3815
#define regCP_DRAW_WINDOW_CNTL_BASE_IDX                                                                 1
#define regGRBM_PERFCOUNTER0_SELECT                                                                     0x3840
#define regGRBM_PERFCOUNTER0_SELECT_BASE_IDX                                                            1
#define regGRBM_PERFCOUNTER1_SELECT                                                                     0x3841
#define regGRBM_PERFCOUNTER1_SELECT_BASE_IDX                                                            1
#define regGRBM_SE0_PERFCOUNTER_SELECT                                                                  0x3842
#define regGRBM_SE0_PERFCOUNTER_SELECT_BASE_IDX                                                         1
#define regGRBM_SE1_PERFCOUNTER_SELECT                                                                  0x3843
#define regGRBM_SE1_PERFCOUNTER_SELECT_BASE_IDX                                                         1
#define regGRBM_SE2_PERFCOUNTER_SELECT                                                                  0x3844
#define regGRBM_SE2_PERFCOUNTER_SELECT_BASE_IDX                                                         1
#define regGRBM_SE3_PERFCOUNTER_SELECT                                                                  0x3845
#define regGRBM_SE3_PERFCOUNTER_SELECT_BASE_IDX                                                         1
#define regWD_PERFCOUNTER0_SELECT                                                                       0x3880
#define regWD_PERFCOUNTER0_SELECT_BASE_IDX                                                              1
#define regWD_PERFCOUNTER1_SELECT                                                                       0x3881
#define regWD_PERFCOUNTER1_SELECT_BASE_IDX                                                              1
#define regWD_PERFCOUNTER2_SELECT                                                                       0x3882
#define regWD_PERFCOUNTER2_SELECT_BASE_IDX                                                              1
#define regWD_PERFCOUNTER3_SELECT                                                                       0x3883
#define regWD_PERFCOUNTER3_SELECT_BASE_IDX                                                              1
#define regIA_PERFCOUNTER0_SELECT                                                                       0x3884
#define regIA_PERFCOUNTER0_SELECT_BASE_IDX                                                              1
#define regIA_PERFCOUNTER1_SELECT                                                                       0x3885
#define regIA_PERFCOUNTER1_SELECT_BASE_IDX                                                              1
#define regIA_PERFCOUNTER2_SELECT                                                                       0x3886
#define regIA_PERFCOUNTER2_SELECT_BASE_IDX                                                              1
#define regIA_PERFCOUNTER3_SELECT                                                                       0x3887
#define regIA_PERFCOUNTER3_SELECT_BASE_IDX                                                              1
#define regIA_PERFCOUNTER0_SELECT1                                                                      0x3888
#define regIA_PERFCOUNTER0_SELECT1_BASE_IDX                                                             1
#define regVGT_PERFCOUNTER0_SELECT                                                                      0x388c
#define regVGT_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define regVGT_PERFCOUNTER1_SELECT                                                                      0x388d
#define regVGT_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define regVGT_PERFCOUNTER2_SELECT                                                                      0x388e
#define regVGT_PERFCOUNTER2_SELECT_BASE_IDX                                                             1
#define regVGT_PERFCOUNTER3_SELECT                                                                      0x388f
#define regVGT_PERFCOUNTER3_SELECT_BASE_IDX                                                             1
#define regVGT_PERFCOUNTER0_SELECT1                                                                     0x3890
#define regVGT_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define regVGT_PERFCOUNTER1_SELECT1                                                                     0x3891
#define regVGT_PERFCOUNTER1_SELECT1_BASE_IDX                                                            1
#define regVGT_PERFCOUNTER_SEID_MASK                                                                    0x3894
#define regVGT_PERFCOUNTER_SEID_MASK_BASE_IDX                                                           1
#define regPA_SU_PERFCOUNTER0_SELECT                                                                    0x3900
#define regPA_SU_PERFCOUNTER0_SELECT_BASE_IDX                                                           1
#define regPA_SU_PERFCOUNTER0_SELECT1                                                                   0x3901
#define regPA_SU_PERFCOUNTER0_SELECT1_BASE_IDX                                                          1
#define regPA_SU_PERFCOUNTER1_SELECT                                                                    0x3902
#define regPA_SU_PERFCOUNTER1_SELECT_BASE_IDX                                                           1
#define regPA_SU_PERFCOUNTER1_SELECT1                                                                   0x3903
#define regPA_SU_PERFCOUNTER1_SELECT1_BASE_IDX                                                          1
#define regPA_SU_PERFCOUNTER2_SELECT                                                                    0x3904
#define regPA_SU_PERFCOUNTER2_SELECT_BASE_IDX                                                           1
#define regPA_SU_PERFCOUNTER3_SELECT                                                                    0x3905
#define regPA_SU_PERFCOUNTER3_SELECT_BASE_IDX                                                           1
#define regPA_SC_PERFCOUNTER0_SELECT                                                                    0x3940
#define regPA_SC_PERFCOUNTER0_SELECT_BASE_IDX                                                           1
#define regPA_SC_PERFCOUNTER0_SELECT1                                                                   0x3941
#define regPA_SC_PERFCOUNTER0_SELECT1_BASE_IDX                                                          1
#define regPA_SC_PERFCOUNTER1_SELECT                                                                    0x3942
#define regPA_SC_PERFCOUNTER1_SELECT_BASE_IDX                                                           1
#define regPA_SC_PERFCOUNTER2_SELECT                                                                    0x3943
#define regPA_SC_PERFCOUNTER2_SELECT_BASE_IDX                                                           1
#define regPA_SC_PERFCOUNTER3_SELECT                                                                    0x3944
#define regPA_SC_PERFCOUNTER3_SELECT_BASE_IDX                                                           1
#define regPA_SC_PERFCOUNTER4_SELECT                                                                    0x3945
#define regPA_SC_PERFCOUNTER4_SELECT_BASE_IDX                                                           1
#define regPA_SC_PERFCOUNTER5_SELECT                                                                    0x3946
#define regPA_SC_PERFCOUNTER5_SELECT_BASE_IDX                                                           1
#define regPA_SC_PERFCOUNTER6_SELECT                                                                    0x3947
#define regPA_SC_PERFCOUNTER6_SELECT_BASE_IDX                                                           1
#define regPA_SC_PERFCOUNTER7_SELECT                                                                    0x3948
#define regPA_SC_PERFCOUNTER7_SELECT_BASE_IDX                                                           1
#define regSPI_PERFCOUNTER0_SELECT                                                                      0x3980
#define regSPI_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define regSPI_PERFCOUNTER1_SELECT                                                                      0x3981
#define regSPI_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define regSPI_PERFCOUNTER2_SELECT                                                                      0x3982
#define regSPI_PERFCOUNTER2_SELECT_BASE_IDX                                                             1
#define regSPI_PERFCOUNTER3_SELECT                                                                      0x3983
#define regSPI_PERFCOUNTER3_SELECT_BASE_IDX                                                             1
#define regSPI_PERFCOUNTER0_SELECT1                                                                     0x3984
#define regSPI_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define regSPI_PERFCOUNTER1_SELECT1                                                                     0x3985
#define regSPI_PERFCOUNTER1_SELECT1_BASE_IDX                                                            1
#define regSPI_PERFCOUNTER2_SELECT1                                                                     0x3986
#define regSPI_PERFCOUNTER2_SELECT1_BASE_IDX                                                            1
#define regSPI_PERFCOUNTER3_SELECT1                                                                     0x3987
#define regSPI_PERFCOUNTER3_SELECT1_BASE_IDX                                                            1
#define regSPI_PERFCOUNTER4_SELECT                                                                      0x3988
#define regSPI_PERFCOUNTER4_SELECT_BASE_IDX                                                             1
#define regSPI_PERFCOUNTER5_SELECT                                                                      0x3989
#define regSPI_PERFCOUNTER5_SELECT_BASE_IDX                                                             1
#define regSPI_PERFCOUNTER_BINS                                                                         0x398a
#define regSPI_PERFCOUNTER_BINS_BASE_IDX                                                                1
#define regSQ_PERFCOUNTER0_SELECT                                                                       0x39c0
#define regSQ_PERFCOUNTER0_SELECT_BASE_IDX                                                              1
#define regSQ_PERFCOUNTER1_SELECT                                                                       0x39c1
#define regSQ_PERFCOUNTER1_SELECT_BASE_IDX                                                              1
#define regSQ_PERFCOUNTER2_SELECT                                                                       0x39c2
#define regSQ_PERFCOUNTER2_SELECT_BASE_IDX                                                              1
#define regSQ_PERFCOUNTER3_SELECT                                                                       0x39c3
#define regSQ_PERFCOUNTER3_SELECT_BASE_IDX                                                              1
#define regSQ_PERFCOUNTER4_SELECT                                                                       0x39c4
#define regSQ_PERFCOUNTER4_SELECT_BASE_IDX                                                              1
#define regSQ_PERFCOUNTER5_SELECT                                                                       0x39c5
#define regSQ_PERFCOUNTER5_SELECT_BASE_IDX                                                              1
#define regSQ_PERFCOUNTER6_SELECT                                                                       0x39c6
#define regSQ_PERFCOUNTER6_SELECT_BASE_IDX                                                              1
#define regSQ_PERFCOUNTER7_SELECT                                                                       0x39c7
#define regSQ_PERFCOUNTER7_SELECT_BASE_IDX                                                              1
#define regSQ_PERFCOUNTER8_SELECT                                                                       0x39c8
#define regSQ_PERFCOUNTER8_SELECT_BASE_IDX                                                              1
#define regSQ_PERFCOUNTER9_SELECT                                                                       0x39c9
#define regSQ_PERFCOUNTER9_SELECT_BASE_IDX                                                              1
#define regSQ_PERFCOUNTER10_SELECT                                                                      0x39ca
#define regSQ_PERFCOUNTER10_SELECT_BASE_IDX                                                             1
#define regSQ_PERFCOUNTER11_SELECT                                                                      0x39cb
#define regSQ_PERFCOUNTER11_SELECT_BASE_IDX                                                             1
#define regSQ_PERFCOUNTER12_SELECT                                                                      0x39cc
#define regSQ_PERFCOUNTER12_SELECT_BASE_IDX                                                             1
#define regSQ_PERFCOUNTER13_SELECT                                                                      0x39cd
#define regSQ_PERFCOUNTER13_SELECT_BASE_IDX                                                             1
#define regSQ_PERFCOUNTER14_SELECT                                                                      0x39ce
#define regSQ_PERFCOUNTER14_SELECT_BASE_IDX                                                             1
#define regSQ_PERFCOUNTER15_SELECT                                                                      0x39cf
#define regSQ_PERFCOUNTER15_SELECT_BASE_IDX                                                             1
#define regSQ_PERFCOUNTER_CTRL                                                                          0x39e0
#define regSQ_PERFCOUNTER_CTRL_BASE_IDX                                                                 1
#define regSQ_PERFCOUNTER_MASK                                                                          0x39e1
#define regSQ_PERFCOUNTER_MASK_BASE_IDX                                                                 1
#define regSQ_PERFCOUNTER_CTRL2                                                                         0x39e2
#define regSQ_PERFCOUNTER_CTRL2_BASE_IDX                                                                1
#define regSX_PERFCOUNTER0_SELECT                                                                       0x3a40
#define regSX_PERFCOUNTER0_SELECT_BASE_IDX                                                              1
#define regSX_PERFCOUNTER1_SELECT                                                                       0x3a41
#define regSX_PERFCOUNTER1_SELECT_BASE_IDX                                                              1
#define regSX_PERFCOUNTER2_SELECT                                                                       0x3a42
#define regSX_PERFCOUNTER2_SELECT_BASE_IDX                                                              1
#define regSX_PERFCOUNTER3_SELECT                                                                       0x3a43
#define regSX_PERFCOUNTER3_SELECT_BASE_IDX                                                              1
#define regSX_PERFCOUNTER0_SELECT1                                                                      0x3a44
#define regSX_PERFCOUNTER0_SELECT1_BASE_IDX                                                             1
#define regSX_PERFCOUNTER1_SELECT1                                                                      0x3a45
#define regSX_PERFCOUNTER1_SELECT1_BASE_IDX                                                             1
#define regGDS_PERFCOUNTER0_SELECT                                                                      0x3a80
#define regGDS_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define regGDS_PERFCOUNTER1_SELECT                                                                      0x3a81
#define regGDS_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define regGDS_PERFCOUNTER2_SELECT                                                                      0x3a82
#define regGDS_PERFCOUNTER2_SELECT_BASE_IDX                                                             1
#define regGDS_PERFCOUNTER3_SELECT                                                                      0x3a83
#define regGDS_PERFCOUNTER3_SELECT_BASE_IDX                                                             1
#define regGDS_PERFCOUNTER0_SELECT1                                                                     0x3a84
#define regGDS_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define regTA_PERFCOUNTER0_SELECT                                                                       0x3ac0
#define regTA_PERFCOUNTER0_SELECT_BASE_IDX                                                              1
#define regTA_PERFCOUNTER0_SELECT1                                                                      0x3ac1
#define regTA_PERFCOUNTER0_SELECT1_BASE_IDX                                                             1
#define regTA_PERFCOUNTER1_SELECT                                                                       0x3ac2
#define regTA_PERFCOUNTER1_SELECT_BASE_IDX                                                              1
#define regTD_PERFCOUNTER0_SELECT                                                                       0x3b00
#define regTD_PERFCOUNTER0_SELECT_BASE_IDX                                                              1
#define regTD_PERFCOUNTER0_SELECT1                                                                      0x3b01
#define regTD_PERFCOUNTER0_SELECT1_BASE_IDX                                                             1
#define regTD_PERFCOUNTER1_SELECT                                                                       0x3b02
#define regTD_PERFCOUNTER1_SELECT_BASE_IDX                                                              1
#define regTCP_PERFCOUNTER0_SELECT                                                                      0x3b40
#define regTCP_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define regTCP_PERFCOUNTER0_SELECT1                                                                     0x3b41
#define regTCP_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define regTCP_PERFCOUNTER1_SELECT                                                                      0x3b42
#define regTCP_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define regTCP_PERFCOUNTER1_SELECT1                                                                     0x3b43
#define regTCP_PERFCOUNTER1_SELECT1_BASE_IDX                                                            1
#define regTCP_PERFCOUNTER2_SELECT                                                                      0x3b44
#define regTCP_PERFCOUNTER2_SELECT_BASE_IDX                                                             1
#define regTCP_PERFCOUNTER3_SELECT                                                                      0x3b45
#define regTCP_PERFCOUNTER3_SELECT_BASE_IDX                                                             1
#define regTCC_PERFCOUNTER0_SELECT                                                                      0x3b80
#define regTCC_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define regTCC_PERFCOUNTER0_SELECT1                                                                     0x3b81
#define regTCC_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define regTCC_PERFCOUNTER1_SELECT                                                                      0x3b82
#define regTCC_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define regTCC_PERFCOUNTER1_SELECT1                                                                     0x3b83
#define regTCC_PERFCOUNTER1_SELECT1_BASE_IDX                                                            1
#define regTCC_PERFCOUNTER2_SELECT                                                                      0x3b84
#define regTCC_PERFCOUNTER2_SELECT_BASE_IDX                                                             1
#define regTCC_PERFCOUNTER3_SELECT                                                                      0x3b85
#define regTCC_PERFCOUNTER3_SELECT_BASE_IDX                                                             1
#define regTCA_PERFCOUNTER0_SELECT                                                                      0x3b90
#define regTCA_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define regTCA_PERFCOUNTER0_SELECT1                                                                     0x3b91
#define regTCA_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define regTCA_PERFCOUNTER1_SELECT                                                                      0x3b92
#define regTCA_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define regTCA_PERFCOUNTER1_SELECT1                                                                     0x3b93
#define regTCA_PERFCOUNTER1_SELECT1_BASE_IDX                                                            1
#define regTCA_PERFCOUNTER2_SELECT                                                                      0x3b94
#define regTCA_PERFCOUNTER2_SELECT_BASE_IDX                                                             1
#define regTCA_PERFCOUNTER3_SELECT                                                                      0x3b95
#define regTCA_PERFCOUNTER3_SELECT_BASE_IDX                                                             1
#define regCB_PERFCOUNTER_FILTER                                                                        0x3c00
#define regCB_PERFCOUNTER_FILTER_BASE_IDX                                                               1
#define regCB_PERFCOUNTER0_SELECT                                                                       0x3c01
#define regCB_PERFCOUNTER0_SELECT_BASE_IDX                                                              1
#define regCB_PERFCOUNTER0_SELECT1                                                                      0x3c02
#define regCB_PERFCOUNTER0_SELECT1_BASE_IDX                                                             1
#define regCB_PERFCOUNTER1_SELECT                                                                       0x3c03
#define regCB_PERFCOUNTER1_SELECT_BASE_IDX                                                              1
#define regCB_PERFCOUNTER2_SELECT                                                                       0x3c04
#define regCB_PERFCOUNTER2_SELECT_BASE_IDX                                                              1
#define regCB_PERFCOUNTER3_SELECT                                                                       0x3c05
#define regCB_PERFCOUNTER3_SELECT_BASE_IDX                                                              1
#define regDB_PERFCOUNTER0_SELECT                                                                       0x3c40
#define regDB_PERFCOUNTER0_SELECT_BASE_IDX                                                              1
#define regDB_PERFCOUNTER0_SELECT1                                                                      0x3c41
#define regDB_PERFCOUNTER0_SELECT1_BASE_IDX                                                             1
#define regDB_PERFCOUNTER1_SELECT                                                                       0x3c42
#define regDB_PERFCOUNTER1_SELECT_BASE_IDX                                                              1
#define regDB_PERFCOUNTER1_SELECT1                                                                      0x3c43
#define regDB_PERFCOUNTER1_SELECT1_BASE_IDX                                                             1
#define regDB_PERFCOUNTER2_SELECT                                                                       0x3c44
#define regDB_PERFCOUNTER2_SELECT_BASE_IDX                                                              1
#define regDB_PERFCOUNTER3_SELECT                                                                       0x3c46
#define regDB_PERFCOUNTER3_SELECT_BASE_IDX                                                              1
#define regRLC_SPM_PERFMON_CNTL                                                                         0x3c80
#define regRLC_SPM_PERFMON_CNTL_BASE_IDX                                                                1
#define regRLC_SPM_PERFMON_RING_BASE_LO                                                                 0x3c81
#define regRLC_SPM_PERFMON_RING_BASE_LO_BASE_IDX                                                        1
#define regRLC_SPM_PERFMON_RING_BASE_HI                                                                 0x3c82
#define regRLC_SPM_PERFMON_RING_BASE_HI_BASE_IDX                                                        1
#define regRLC_SPM_PERFMON_RING_SIZE                                                                    0x3c83
#define regRLC_SPM_PERFMON_RING_SIZE_BASE_IDX                                                           1
#define regRLC_SPM_PERFMON_SEGMENT_SIZE                                                                 0x3c84
#define regRLC_SPM_PERFMON_SEGMENT_SIZE_BASE_IDX                                                        1
#define regRLC_SPM_SE_MUXSEL_ADDR                                                                       0x3c85
#define regRLC_SPM_SE_MUXSEL_ADDR_BASE_IDX                                                              1
#define regRLC_SPM_SE_MUXSEL_DATA                                                                       0x3c86
#define regRLC_SPM_SE_MUXSEL_DATA_BASE_IDX                                                              1
#define regRLC_SPM_CPG_PERFMON_SAMPLE_DELAY                                                             0x3c87
#define regRLC_SPM_CPG_PERFMON_SAMPLE_DELAY_BASE_IDX                                                    1
#define regRLC_SPM_CPC_PERFMON_SAMPLE_DELAY                                                             0x3c88
#define regRLC_SPM_CPC_PERFMON_SAMPLE_DELAY_BASE_IDX                                                    1
#define regRLC_SPM_CPF_PERFMON_SAMPLE_DELAY                                                             0x3c89
#define regRLC_SPM_CPF_PERFMON_SAMPLE_DELAY_BASE_IDX                                                    1
#define regRLC_SPM_CB_PERFMON_SAMPLE_DELAY                                                              0x3c8a
#define regRLC_SPM_CB_PERFMON_SAMPLE_DELAY_BASE_IDX                                                     1
#define regRLC_SPM_DB_PERFMON_SAMPLE_DELAY                                                              0x3c8b
#define regRLC_SPM_DB_PERFMON_SAMPLE_DELAY_BASE_IDX                                                     1
#define regRLC_SPM_PA_PERFMON_SAMPLE_DELAY                                                              0x3c8c
#define regRLC_SPM_PA_PERFMON_SAMPLE_DELAY_BASE_IDX                                                     1
#define regRLC_SPM_GDS_PERFMON_SAMPLE_DELAY                                                             0x3c8d
#define regRLC_SPM_GDS_PERFMON_SAMPLE_DELAY_BASE_IDX                                                    1
#define regRLC_SPM_IA_PERFMON_SAMPLE_DELAY                                                              0x3c8e
#define regRLC_SPM_IA_PERFMON_SAMPLE_DELAY_BASE_IDX                                                     1
#define regRLC_SPM_SC_PERFMON_SAMPLE_DELAY                                                              0x3c90
#define regRLC_SPM_SC_PERFMON_SAMPLE_DELAY_BASE_IDX                                                     1
#define regRLC_SPM_TCC_PERFMON_SAMPLE_DELAY                                                             0x3c91
#define regRLC_SPM_TCC_PERFMON_SAMPLE_DELAY_BASE_IDX                                                    1
#define regRLC_SPM_TCA_PERFMON_SAMPLE_DELAY                                                             0x3c92
#define regRLC_SPM_TCA_PERFMON_SAMPLE_DELAY_BASE_IDX                                                    1
#define regRLC_SPM_TCP_PERFMON_SAMPLE_DELAY                                                             0x3c93
#define regRLC_SPM_TCP_PERFMON_SAMPLE_DELAY_BASE_IDX                                                    1
#define regRLC_SPM_TA_PERFMON_SAMPLE_DELAY                                                              0x3c94
#define regRLC_SPM_TA_PERFMON_SAMPLE_DELAY_BASE_IDX                                                     1
#define regRLC_SPM_TD_PERFMON_SAMPLE_DELAY                                                              0x3c95
#define regRLC_SPM_TD_PERFMON_SAMPLE_DELAY_BASE_IDX                                                     1
#define regRLC_SPM_VGT_PERFMON_SAMPLE_DELAY                                                             0x3c96
#define regRLC_SPM_VGT_PERFMON_SAMPLE_DELAY_BASE_IDX                                                    1
#define regRLC_SPM_SPI_PERFMON_SAMPLE_DELAY                                                             0x3c97
#define regRLC_SPM_SPI_PERFMON_SAMPLE_DELAY_BASE_IDX                                                    1
#define regRLC_SPM_SQG_PERFMON_SAMPLE_DELAY                                                             0x3c98
#define regRLC_SPM_SQG_PERFMON_SAMPLE_DELAY_BASE_IDX                                                    1
#define regRLC_SPM_SX_PERFMON_SAMPLE_DELAY                                                              0x3c9a
#define regRLC_SPM_SX_PERFMON_SAMPLE_DELAY_BASE_IDX                                                     1
#define regRLC_SPM_GLOBAL_MUXSEL_ADDR                                                                   0x3c9b
#define regRLC_SPM_GLOBAL_MUXSEL_ADDR_BASE_IDX                                                          1
#define regRLC_SPM_GLOBAL_MUXSEL_DATA                                                                   0x3c9c
#define regRLC_SPM_GLOBAL_MUXSEL_DATA_BASE_IDX                                                          1
#define regRLC_SPM_RING_RDPTR                                                                           0x3c9d
#define regRLC_SPM_RING_RDPTR_BASE_IDX                                                                  1
#define regRLC_SPM_SEGMENT_THRESHOLD                                                                    0x3c9e
#define regRLC_SPM_SEGMENT_THRESHOLD_BASE_IDX                                                           1
#define regRLC_SPM_RMI_PERFMON_SAMPLE_DELAY                                                             0x3ca3
#define regRLC_SPM_RMI_PERFMON_SAMPLE_DELAY_BASE_IDX                                                    1
#define regRLC_SPM_PERFMON_SAMPLE_DELAY_MAX                                                             0x3ca4
#define regRLC_SPM_PERFMON_SAMPLE_DELAY_MAX_BASE_IDX                                                    1
#define regRLC_PERFMON_CNTL                                                                             0x3cc0
#define regRLC_PERFMON_CNTL_BASE_IDX                                                                    1
#define regRLC_PERFCOUNTER0_SELECT                                                                      0x3cc1
#define regRLC_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define regRLC_PERFCOUNTER1_SELECT                                                                      0x3cc2
#define regRLC_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define regRLC_GPU_IOV_PERF_CNT_CNTL                                                                    0x3cc3
#define regRLC_GPU_IOV_PERF_CNT_CNTL_BASE_IDX                                                           1
#define regRLC_GPU_IOV_PERF_CNT_WR_ADDR                                                                 0x3cc4
#define regRLC_GPU_IOV_PERF_CNT_WR_ADDR_BASE_IDX                                                        1
#define regRLC_GPU_IOV_PERF_CNT_WR_DATA                                                                 0x3cc5
#define regRLC_GPU_IOV_PERF_CNT_WR_DATA_BASE_IDX                                                        1
#define regRLC_GPU_IOV_PERF_CNT_RD_ADDR                                                                 0x3cc6
#define regRLC_GPU_IOV_PERF_CNT_RD_ADDR_BASE_IDX                                                        1
#define regRLC_GPU_IOV_PERF_CNT_RD_DATA                                                                 0x3cc7
#define regRLC_GPU_IOV_PERF_CNT_RD_DATA_BASE_IDX                                                        1
#define regRMI_PERFCOUNTER0_SELECT                                                                      0x3d00
#define regRMI_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define regRMI_PERFCOUNTER0_SELECT1                                                                     0x3d01
#define regRMI_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define regRMI_PERFCOUNTER1_SELECT                                                                      0x3d02
#define regRMI_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define regRMI_PERFCOUNTER2_SELECT                                                                      0x3d03
#define regRMI_PERFCOUNTER2_SELECT_BASE_IDX                                                             1
#define regRMI_PERFCOUNTER2_SELECT1                                                                     0x3d04
#define regRMI_PERFCOUNTER2_SELECT1_BASE_IDX                                                            1
#define regRMI_PERFCOUNTER3_SELECT                                                                      0x3d05
#define regRMI_PERFCOUNTER3_SELECT_BASE_IDX                                                             1
#define regRMI_PERF_COUNTER_CNTL                                                                        0x3d06
#define regRMI_PERF_COUNTER_CNTL_BASE_IDX                                                               1


// addressBlock: xcd0_gc_utcl2_atcl2pfcntldec
// base address: 0x37500
#define regATC_L2_PERFCOUNTER0_CFG                                                                      0x3d40
#define regATC_L2_PERFCOUNTER0_CFG_BASE_IDX                                                             1
#define regATC_L2_PERFCOUNTER1_CFG                                                                      0x3d41
#define regATC_L2_PERFCOUNTER1_CFG_BASE_IDX                                                             1
#define regATC_L2_PERFCOUNTER_RSLT_CNTL                                                                 0x3d42
#define regATC_L2_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                        1


// addressBlock: xcd0_gc_utcl2_vml2pldec
// base address: 0x37518
#define regMC_VM_L2_PERFCOUNTER0_CFG                                                                    0x3d46
#define regMC_VM_L2_PERFCOUNTER0_CFG_BASE_IDX                                                           1
#define regMC_VM_L2_PERFCOUNTER1_CFG                                                                    0x3d47
#define regMC_VM_L2_PERFCOUNTER1_CFG_BASE_IDX                                                           1
#define regMC_VM_L2_PERFCOUNTER2_CFG                                                                    0x3d48
#define regMC_VM_L2_PERFCOUNTER2_CFG_BASE_IDX                                                           1
#define regMC_VM_L2_PERFCOUNTER3_CFG                                                                    0x3d49
#define regMC_VM_L2_PERFCOUNTER3_CFG_BASE_IDX                                                           1
#define regMC_VM_L2_PERFCOUNTER4_CFG                                                                    0x3d4a
#define regMC_VM_L2_PERFCOUNTER4_CFG_BASE_IDX                                                           1
#define regMC_VM_L2_PERFCOUNTER5_CFG                                                                    0x3d4b
#define regMC_VM_L2_PERFCOUNTER5_CFG_BASE_IDX                                                           1
#define regMC_VM_L2_PERFCOUNTER6_CFG                                                                    0x3d4c
#define regMC_VM_L2_PERFCOUNTER6_CFG_BASE_IDX                                                           1
#define regMC_VM_L2_PERFCOUNTER7_CFG                                                                    0x3d4d
#define regMC_VM_L2_PERFCOUNTER7_CFG_BASE_IDX                                                           1
#define regMC_VM_L2_PERFCOUNTER_RSLT_CNTL                                                               0x3d56
#define regMC_VM_L2_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                      1


// addressBlock: xcd0_gc_utcl2_l2tlbpldec
// base address: 0x37578
#define regL2TLB_PERFCOUNTER0_CFG                                                                       0x3d5e
#define regL2TLB_PERFCOUNTER0_CFG_BASE_IDX                                                              1
#define regL2TLB_PERFCOUNTER1_CFG                                                                       0x3d5f
#define regL2TLB_PERFCOUNTER1_CFG_BASE_IDX                                                              1
#define regL2TLB_PERFCOUNTER2_CFG                                                                       0x3d60
#define regL2TLB_PERFCOUNTER2_CFG_BASE_IDX                                                              1
#define regL2TLB_PERFCOUNTER3_CFG                                                                       0x3d61
#define regL2TLB_PERFCOUNTER3_CFG_BASE_IDX                                                              1
#define regL2TLB_PERFCOUNTER_RSLT_CNTL                                                                  0x3d62
#define regL2TLB_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                         1


// addressBlock: xcd0_gc_gdflldec
// base address: 0x3a000
#define regGDFLL_EDC_HYSTERESIS_CNTL                                                                    0x481b
#define regGDFLL_EDC_HYSTERESIS_CNTL_BASE_IDX                                                           1
#define regGDFLL_EDC_HYSTERESIS_STAT                                                                    0x481c
#define regGDFLL_EDC_HYSTERESIS_STAT_BASE_IDX                                                           1


// addressBlock: xcd0_gc_rlcpdec
// base address: 0x3b000
#define regRLC_CNTL                                                                                     0x4c00
#define regRLC_CNTL_BASE_IDX                                                                            1
#define regRLC_CGCG_CGLS_CTRL_2                                                                         0x4c03
#define regRLC_CGCG_CGLS_CTRL_2_BASE_IDX                                                                1
#define regRLC_STAT                                                                                     0x4c04
#define regRLC_STAT_BASE_IDX                                                                            1
#define regRLC_SAFE_MODE                                                                                0x4c05
#define regRLC_SAFE_MODE_BASE_IDX                                                                       1
#define regRLC_MEM_SLP_CNTL                                                                             0x4c06
#define regRLC_MEM_SLP_CNTL_BASE_IDX                                                                    1
#define regSMU_RLC_RESPONSE                                                                             0x4c07
#define regSMU_RLC_RESPONSE_BASE_IDX                                                                    1
#define regRLC_RLCV_SAFE_MODE                                                                           0x4c08
#define regRLC_RLCV_SAFE_MODE_BASE_IDX                                                                  1
#define regRLC_SMU_SAFE_MODE                                                                            0x4c09
#define regRLC_SMU_SAFE_MODE_BASE_IDX                                                                   1
#define regRLC_RLCV_COMMAND                                                                             0x4c0a
#define regRLC_RLCV_COMMAND_BASE_IDX                                                                    1
#define regRLC_REFCLOCK_TIMESTAMP_LSB                                                                   0x4c0c
#define regRLC_REFCLOCK_TIMESTAMP_LSB_BASE_IDX                                                          1
#define regRLC_REFCLOCK_TIMESTAMP_MSB                                                                   0x4c0d
#define regRLC_REFCLOCK_TIMESTAMP_MSB_BASE_IDX                                                          1
#define regRLC_GPM_TIMER_INT_0                                                                          0x4c0e
#define regRLC_GPM_TIMER_INT_0_BASE_IDX                                                                 1
#define regRLC_GPM_TIMER_INT_1                                                                          0x4c0f
#define regRLC_GPM_TIMER_INT_1_BASE_IDX                                                                 1
#define regRLC_GPM_TIMER_INT_2                                                                          0x4c10
#define regRLC_GPM_TIMER_INT_2_BASE_IDX                                                                 1
#define regRLC_GPM_TIMER_CTRL                                                                           0x4c11
#define regRLC_GPM_TIMER_CTRL_BASE_IDX                                                                  1
#define regRLC_LB_CNTR_MAX                                                                              0x4c12
#define regRLC_LB_CNTR_MAX_BASE_IDX                                                                     1
#define regRLC_GPM_TIMER_STAT                                                                           0x4c13
#define regRLC_GPM_TIMER_STAT_BASE_IDX                                                                  1
#define regRLC_GPM_TIMER_INT_3                                                                          0x4c15
#define regRLC_GPM_TIMER_INT_3_BASE_IDX                                                                 1
#define regRLC_SERDES_WR_NONCU_MASTER_MASK_1                                                            0x4c16
#define regRLC_SERDES_WR_NONCU_MASTER_MASK_1_BASE_IDX                                                   1
#define regRLC_SERDES_NONCU_MASTER_BUSY_1                                                               0x4c17
#define regRLC_SERDES_NONCU_MASTER_BUSY_1_BASE_IDX                                                      1
#define regRLC_INT_STAT                                                                                 0x4c18
#define regRLC_INT_STAT_BASE_IDX                                                                        1
#define regRLC_LB_CNTL                                                                                  0x4c19
#define regRLC_LB_CNTL_BASE_IDX                                                                         1
#define regRLC_MGCG_CTRL                                                                                0x4c1a
#define regRLC_MGCG_CTRL_BASE_IDX                                                                       1
#define regRLC_LB_CNTR_INIT                                                                             0x4c1b
#define regRLC_LB_CNTR_INIT_BASE_IDX                                                                    1
#define regRLC_LOAD_BALANCE_CNTR                                                                        0x4c1c
#define regRLC_LOAD_BALANCE_CNTR_BASE_IDX                                                               1
#define regRLC_JUMP_TABLE_RESTORE                                                                       0x4c1e
#define regRLC_JUMP_TABLE_RESTORE_BASE_IDX                                                              1
#define regRLC_PG_DELAY_2                                                                               0x4c1f
#define regRLC_PG_DELAY_2_BASE_IDX                                                                      1
#define regRLC_GPU_CLOCK_COUNT_LSB                                                                      0x4c24
#define regRLC_GPU_CLOCK_COUNT_LSB_BASE_IDX                                                             1
#define regRLC_GPU_CLOCK_COUNT_MSB                                                                      0x4c25
#define regRLC_GPU_CLOCK_COUNT_MSB_BASE_IDX                                                             1
#define regRLC_CAPTURE_GPU_CLOCK_COUNT                                                                  0x4c26
#define regRLC_CAPTURE_GPU_CLOCK_COUNT_BASE_IDX                                                         1
#define regRLC_UCODE_CNTL                                                                               0x4c27
#define regRLC_UCODE_CNTL_BASE_IDX                                                                      1
#define regRLC_GPM_THREAD_RESET                                                                         0x4c28
#define regRLC_GPM_THREAD_RESET_BASE_IDX                                                                1
#define regRLC_GPM_CP_DMA_COMPLETE_T0                                                                   0x4c29
#define regRLC_GPM_CP_DMA_COMPLETE_T0_BASE_IDX                                                          1
#define regRLC_GPM_CP_DMA_COMPLETE_T1                                                                   0x4c2a
#define regRLC_GPM_CP_DMA_COMPLETE_T1_BASE_IDX                                                          1
#define regRLC_FIREWALL_VIOLATION                                                                       0x4c2b
#define regRLC_FIREWALL_VIOLATION_BASE_IDX                                                              1
#define regRLC_CLK_COUNT_GFXCLK_LSB                                                                     0x4c30
#define regRLC_CLK_COUNT_GFXCLK_LSB_BASE_IDX                                                            1
#define regRLC_CLK_COUNT_GFXCLK_MSB                                                                     0x4c31
#define regRLC_CLK_COUNT_GFXCLK_MSB_BASE_IDX                                                            1
#define regRLC_CLK_COUNT_REFCLK_LSB                                                                     0x4c32
#define regRLC_CLK_COUNT_REFCLK_LSB_BASE_IDX                                                            1
#define regRLC_CLK_COUNT_REFCLK_MSB                                                                     0x4c33
#define regRLC_CLK_COUNT_REFCLK_MSB_BASE_IDX                                                            1
#define regRLC_CLK_COUNT_CTRL                                                                           0x4c34
#define regRLC_CLK_COUNT_CTRL_BASE_IDX                                                                  1
#define regRLC_CLK_COUNT_STAT                                                                           0x4c35
#define regRLC_CLK_COUNT_STAT_BASE_IDX                                                                  1
#define regRLC_GPM_STAT                                                                                 0x4c40
#define regRLC_GPM_STAT_BASE_IDX                                                                        1
#define regRLC_GPU_CLOCK_32_RES_SEL                                                                     0x4c41
#define regRLC_GPU_CLOCK_32_RES_SEL_BASE_IDX                                                            1
#define regRLC_GPU_CLOCK_32                                                                             0x4c42
#define regRLC_GPU_CLOCK_32_BASE_IDX                                                                    1
#define regRLC_PG_CNTL                                                                                  0x4c43
#define regRLC_PG_CNTL_BASE_IDX                                                                         1
#define regRLC_GPM_THREAD_PRIORITY                                                                      0x4c44
#define regRLC_GPM_THREAD_PRIORITY_BASE_IDX                                                             1
#define regRLC_GPM_THREAD_ENABLE                                                                        0x4c45
#define regRLC_GPM_THREAD_ENABLE_BASE_IDX                                                               1
#define regRLC_CGTT_MGCG_OVERRIDE                                                                       0x4c48
#define regRLC_CGTT_MGCG_OVERRIDE_BASE_IDX                                                              1
#define regRLC_CGCG_CGLS_CTRL                                                                           0x4c49
#define regRLC_CGCG_CGLS_CTRL_BASE_IDX                                                                  1
#define regRLC_CGCG_RAMP_CTRL                                                                           0x4c4a
#define regRLC_CGCG_RAMP_CTRL_BASE_IDX                                                                  1
#define regRLC_DYN_PG_STATUS                                                                            0x4c4b
#define regRLC_DYN_PG_STATUS_BASE_IDX                                                                   1
#define regRLC_DYN_PG_REQUEST                                                                           0x4c4c
#define regRLC_DYN_PG_REQUEST_BASE_IDX                                                                  1
#define regRLC_PG_DELAY                                                                                 0x4c4d
#define regRLC_PG_DELAY_BASE_IDX                                                                        1
#define regRLC_CU_STATUS                                                                                0x4c4e
#define regRLC_CU_STATUS_BASE_IDX                                                                       1
#define regRLC_LB_INIT_CU_MASK                                                                          0x4c4f
#define regRLC_LB_INIT_CU_MASK_BASE_IDX                                                                 1
#define regRLC_LB_ALWAYS_ACTIVE_CU_MASK                                                                 0x4c50
#define regRLC_LB_ALWAYS_ACTIVE_CU_MASK_BASE_IDX                                                        1
#define regRLC_LB_PARAMS                                                                                0x4c51
#define regRLC_LB_PARAMS_BASE_IDX                                                                       1
#define regRLC_THREAD1_DELAY                                                                            0x4c52
#define regRLC_THREAD1_DELAY_BASE_IDX                                                                   1
#define regRLC_PG_ALWAYS_ON_CU_MASK                                                                     0x4c53
#define regRLC_PG_ALWAYS_ON_CU_MASK_BASE_IDX                                                            1
#define regRLC_MAX_PG_CU                                                                                0x4c54
#define regRLC_MAX_PG_CU_BASE_IDX                                                                       1
#define regRLC_AUTO_PG_CTRL                                                                             0x4c55
#define regRLC_AUTO_PG_CTRL_BASE_IDX                                                                    1
#define regRLC_SMU_GRBM_REG_SAVE_CTRL                                                                   0x4c56
#define regRLC_SMU_GRBM_REG_SAVE_CTRL_BASE_IDX                                                          1
#define regRLC_SERDES_RD_PENDING                                                                        0x4c58
#define regRLC_SERDES_RD_PENDING_BASE_IDX                                                               1
#define regRLC_SERDES_RD_MASTER_INDEX                                                                   0x4c59
#define regRLC_SERDES_RD_MASTER_INDEX_BASE_IDX                                                          1
#define regRLC_SERDES_RD_DATA_0                                                                         0x4c5a
#define regRLC_SERDES_RD_DATA_0_BASE_IDX                                                                1
#define regRLC_SERDES_RD_DATA_1                                                                         0x4c5b
#define regRLC_SERDES_RD_DATA_1_BASE_IDX                                                                1
#define regRLC_SERDES_RD_DATA_2                                                                         0x4c5c
#define regRLC_SERDES_RD_DATA_2_BASE_IDX                                                                1
#define regRLC_SERDES_WR_CU_MASTER_MASK                                                                 0x4c5d
#define regRLC_SERDES_WR_CU_MASTER_MASK_BASE_IDX                                                        1
#define regRLC_SERDES_WR_NONCU_MASTER_MASK                                                              0x4c5e
#define regRLC_SERDES_WR_NONCU_MASTER_MASK_BASE_IDX                                                     1
#define regRLC_SERDES_WR_CTRL                                                                           0x4c5f
#define regRLC_SERDES_WR_CTRL_BASE_IDX                                                                  1
#define regRLC_SERDES_WR_DATA                                                                           0x4c60
#define regRLC_SERDES_WR_DATA_BASE_IDX                                                                  1
#define regRLC_SERDES_CU_MASTER_BUSY                                                                    0x4c61
#define regRLC_SERDES_CU_MASTER_BUSY_BASE_IDX                                                           1
#define regRLC_SERDES_NONCU_MASTER_BUSY                                                                 0x4c62
#define regRLC_SERDES_NONCU_MASTER_BUSY_BASE_IDX                                                        1
#define regRLC_GPM_GENERAL_0                                                                            0x4c63
#define regRLC_GPM_GENERAL_0_BASE_IDX                                                                   1
#define regRLC_GPM_GENERAL_1                                                                            0x4c64
#define regRLC_GPM_GENERAL_1_BASE_IDX                                                                   1
#define regRLC_GPM_GENERAL_2                                                                            0x4c65
#define regRLC_GPM_GENERAL_2_BASE_IDX                                                                   1
#define regRLC_GPM_GENERAL_3                                                                            0x4c66
#define regRLC_GPM_GENERAL_3_BASE_IDX                                                                   1
#define regRLC_GPM_GENERAL_4                                                                            0x4c67
#define regRLC_GPM_GENERAL_4_BASE_IDX                                                                   1
#define regRLC_GPM_GENERAL_5                                                                            0x4c68
#define regRLC_GPM_GENERAL_5_BASE_IDX                                                                   1
#define regRLC_GPM_GENERAL_6                                                                            0x4c69
#define regRLC_GPM_GENERAL_6_BASE_IDX                                                                   1
#define regRLC_GPM_GENERAL_7                                                                            0x4c6a
#define regRLC_GPM_GENERAL_7_BASE_IDX                                                                   1
#define regRLC_GPM_SCRATCH_ADDR                                                                         0x4c6c
#define regRLC_GPM_SCRATCH_ADDR_BASE_IDX                                                                1
#define regRLC_GPM_SCRATCH_DATA                                                                         0x4c6d
#define regRLC_GPM_SCRATCH_DATA_BASE_IDX                                                                1
#define regRLC_STATIC_PG_STATUS                                                                         0x4c6e
#define regRLC_STATIC_PG_STATUS_BASE_IDX                                                                1
#define regRLC_SPM_MC_CNTL                                                                              0x4c71
#define regRLC_SPM_MC_CNTL_BASE_IDX                                                                     1
#define regRLC_SPM_INT_CNTL                                                                             0x4c72
#define regRLC_SPM_INT_CNTL_BASE_IDX                                                                    1
#define regRLC_SPM_INT_STATUS                                                                           0x4c73
#define regRLC_SPM_INT_STATUS_BASE_IDX                                                                  1
#define regRLC_SMU_MESSAGE                                                                              0x4c76
#define regRLC_SMU_MESSAGE_BASE_IDX                                                                     1
#define regRLC_GPM_LOG_SIZE                                                                             0x4c77
#define regRLC_GPM_LOG_SIZE_BASE_IDX                                                                    1
#define regRLC_PG_DELAY_3                                                                               0x4c78
#define regRLC_PG_DELAY_3_BASE_IDX                                                                      1
#define regRLC_GPR_REG1                                                                                 0x4c79
#define regRLC_GPR_REG1_BASE_IDX                                                                        1
#define regRLC_GPR_REG2                                                                                 0x4c7a
#define regRLC_GPR_REG2_BASE_IDX                                                                        1
#define regRLC_GPM_LOG_CONT                                                                             0x4c7b
#define regRLC_GPM_LOG_CONT_BASE_IDX                                                                    1
#define regRLC_GPM_INT_DISABLE_TH0                                                                      0x4c7c
#define regRLC_GPM_INT_DISABLE_TH0_BASE_IDX                                                             1
#define regRLC_GPM_INT_FORCE_TH0                                                                        0x4c7e
#define regRLC_GPM_INT_FORCE_TH0_BASE_IDX                                                               1
#define regRLC_GPM_INT_FORCE_TH1                                                                        0x4c7f
#define regRLC_GPM_INT_FORCE_TH1_BASE_IDX                                                               1
#define regRLC_SRM_CNTL                                                                                 0x4c80
#define regRLC_SRM_CNTL_BASE_IDX                                                                        1
#define regRLC_SRM_ARAM_ADDR                                                                            0x4c83
#define regRLC_SRM_ARAM_ADDR_BASE_IDX                                                                   1
#define regRLC_SRM_ARAM_DATA                                                                            0x4c84
#define regRLC_SRM_ARAM_DATA_BASE_IDX                                                                   1
#define regRLC_SRM_DRAM_ADDR                                                                            0x4c85
#define regRLC_SRM_DRAM_ADDR_BASE_IDX                                                                   1
#define regRLC_SRM_DRAM_DATA                                                                            0x4c86
#define regRLC_SRM_DRAM_DATA_BASE_IDX                                                                   1
#define regRLC_SRM_GPM_COMMAND                                                                          0x4c87
#define regRLC_SRM_GPM_COMMAND_BASE_IDX                                                                 1
#define regRLC_SRM_GPM_COMMAND_STATUS                                                                   0x4c88
#define regRLC_SRM_GPM_COMMAND_STATUS_BASE_IDX                                                          1
#define regRLC_SRM_RLCV_COMMAND                                                                         0x4c89
#define regRLC_SRM_RLCV_COMMAND_BASE_IDX                                                                1
#define regRLC_SRM_RLCV_COMMAND_STATUS                                                                  0x4c8a
#define regRLC_SRM_RLCV_COMMAND_STATUS_BASE_IDX                                                         1
#define regRLC_SRM_INDEX_CNTL_ADDR_0                                                                    0x4c8b
#define regRLC_SRM_INDEX_CNTL_ADDR_0_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_ADDR_1                                                                    0x4c8c
#define regRLC_SRM_INDEX_CNTL_ADDR_1_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_ADDR_2                                                                    0x4c8d
#define regRLC_SRM_INDEX_CNTL_ADDR_2_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_ADDR_3                                                                    0x4c8e
#define regRLC_SRM_INDEX_CNTL_ADDR_3_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_ADDR_4                                                                    0x4c8f
#define regRLC_SRM_INDEX_CNTL_ADDR_4_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_ADDR_5                                                                    0x4c90
#define regRLC_SRM_INDEX_CNTL_ADDR_5_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_ADDR_6                                                                    0x4c91
#define regRLC_SRM_INDEX_CNTL_ADDR_6_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_ADDR_7                                                                    0x4c92
#define regRLC_SRM_INDEX_CNTL_ADDR_7_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_DATA_0                                                                    0x4c93
#define regRLC_SRM_INDEX_CNTL_DATA_0_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_DATA_1                                                                    0x4c94
#define regRLC_SRM_INDEX_CNTL_DATA_1_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_DATA_2                                                                    0x4c95
#define regRLC_SRM_INDEX_CNTL_DATA_2_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_DATA_3                                                                    0x4c96
#define regRLC_SRM_INDEX_CNTL_DATA_3_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_DATA_4                                                                    0x4c97
#define regRLC_SRM_INDEX_CNTL_DATA_4_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_DATA_5                                                                    0x4c98
#define regRLC_SRM_INDEX_CNTL_DATA_5_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_DATA_6                                                                    0x4c99
#define regRLC_SRM_INDEX_CNTL_DATA_6_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_DATA_7                                                                    0x4c9a
#define regRLC_SRM_INDEX_CNTL_DATA_7_BASE_IDX                                                           1
#define regRLC_SRM_STAT                                                                                 0x4c9b
#define regRLC_SRM_STAT_BASE_IDX                                                                        1
#define regRLC_SRM_GPM_ABORT                                                                            0x4c9c
#define regRLC_SRM_GPM_ABORT_BASE_IDX                                                                   1
#define regRLC_CSIB_ADDR_LO                                                                             0x4ca2
#define regRLC_CSIB_ADDR_LO_BASE_IDX                                                                    1
#define regRLC_CSIB_ADDR_HI                                                                             0x4ca3
#define regRLC_CSIB_ADDR_HI_BASE_IDX                                                                    1
#define regRLC_CSIB_LENGTH                                                                              0x4ca4
#define regRLC_CSIB_LENGTH_BASE_IDX                                                                     1
#define regRLC_SMU_COMMAND                                                                              0x4ca9
#define regRLC_SMU_COMMAND_BASE_IDX                                                                     1
#define regRLC_CP_SCHEDULERS                                                                            0x4caa
#define regRLC_CP_SCHEDULERS_BASE_IDX                                                                   1
#define regRLC_SMU_ARGUMENT_1                                                                           0x4cab
#define regRLC_SMU_ARGUMENT_1_BASE_IDX                                                                  1
#define regRLC_SMU_ARGUMENT_2                                                                           0x4cac
#define regRLC_SMU_ARGUMENT_2_BASE_IDX                                                                  1
#define regRLC_GPM_GENERAL_8                                                                            0x4cad
#define regRLC_GPM_GENERAL_8_BASE_IDX                                                                   1
#define regRLC_GPM_GENERAL_9                                                                            0x4cae
#define regRLC_GPM_GENERAL_9_BASE_IDX                                                                   1
#define regRLC_GPM_GENERAL_10                                                                           0x4caf
#define regRLC_GPM_GENERAL_10_BASE_IDX                                                                  1
#define regRLC_GPM_GENERAL_11                                                                           0x4cb0
#define regRLC_GPM_GENERAL_11_BASE_IDX                                                                  1
#define regRLC_GPM_GENERAL_12                                                                           0x4cb1
#define regRLC_GPM_GENERAL_12_BASE_IDX                                                                  1
#define regRLC_GPM_UTCL1_CNTL_0                                                                         0x4cb2
#define regRLC_GPM_UTCL1_CNTL_0_BASE_IDX                                                                1
#define regRLC_GPM_UTCL1_CNTL_1                                                                         0x4cb3
#define regRLC_GPM_UTCL1_CNTL_1_BASE_IDX                                                                1
#define regRLC_GPM_UTCL1_CNTL_2                                                                         0x4cb4
#define regRLC_GPM_UTCL1_CNTL_2_BASE_IDX                                                                1
#define regRLC_SPM_UTCL1_CNTL                                                                           0x4cb5
#define regRLC_SPM_UTCL1_CNTL_BASE_IDX                                                                  1
#define regRLC_UTCL1_STATUS_2                                                                           0x4cb6
#define regRLC_UTCL1_STATUS_2_BASE_IDX                                                                  1
#define regRLC_LB_THR_CONFIG_2                                                                          0x4cb8
#define regRLC_LB_THR_CONFIG_2_BASE_IDX                                                                 1
#define regRLC_LB_THR_CONFIG_3                                                                          0x4cb9
#define regRLC_LB_THR_CONFIG_3_BASE_IDX                                                                 1
#define regRLC_LB_THR_CONFIG_4                                                                          0x4cba
#define regRLC_LB_THR_CONFIG_4_BASE_IDX                                                                 1
#define regRLC_SPM_UTCL1_ERROR_1                                                                        0x4cbc
#define regRLC_SPM_UTCL1_ERROR_1_BASE_IDX                                                               1
#define regRLC_SPM_UTCL1_ERROR_2                                                                        0x4cbd
#define regRLC_SPM_UTCL1_ERROR_2_BASE_IDX                                                               1
#define regRLC_GPM_UTCL1_TH0_ERROR_1                                                                    0x4cbe
#define regRLC_GPM_UTCL1_TH0_ERROR_1_BASE_IDX                                                           1
#define regRLC_LB_THR_CONFIG_1                                                                          0x4cbf
#define regRLC_LB_THR_CONFIG_1_BASE_IDX                                                                 1
#define regRLC_GPM_UTCL1_TH0_ERROR_2                                                                    0x4cc0
#define regRLC_GPM_UTCL1_TH0_ERROR_2_BASE_IDX                                                           1
#define regRLC_GPM_UTCL1_TH1_ERROR_1                                                                    0x4cc1
#define regRLC_GPM_UTCL1_TH1_ERROR_1_BASE_IDX                                                           1
#define regRLC_GPM_UTCL1_TH1_ERROR_2                                                                    0x4cc2
#define regRLC_GPM_UTCL1_TH1_ERROR_2_BASE_IDX                                                           1
#define regRLC_GPM_UTCL1_TH2_ERROR_1                                                                    0x4cc3
#define regRLC_GPM_UTCL1_TH2_ERROR_1_BASE_IDX                                                           1
#define regRLC_GPM_UTCL1_TH2_ERROR_2                                                                    0x4cc4
#define regRLC_GPM_UTCL1_TH2_ERROR_2_BASE_IDX                                                           1
#define regRLC_SEMAPHORE_0                                                                              0x4cc7
#define regRLC_SEMAPHORE_0_BASE_IDX                                                                     1
#define regRLC_SEMAPHORE_1                                                                              0x4cc8
#define regRLC_SEMAPHORE_1_BASE_IDX                                                                     1
#define regRLC_CP_EOF_INT                                                                               0x4cca
#define regRLC_CP_EOF_INT_BASE_IDX                                                                      1
#define regRLC_CP_EOF_INT_CNT                                                                           0x4ccb
#define regRLC_CP_EOF_INT_CNT_BASE_IDX                                                                  1
#define regRLC_SPARE_INT                                                                                0x4ccc
#define regRLC_SPARE_INT_BASE_IDX                                                                       1
#define regRLC_PREWALKER_UTCL1_CNTL                                                                     0x4ccd
#define regRLC_PREWALKER_UTCL1_CNTL_BASE_IDX                                                            1
#define regRLC_PREWALKER_UTCL1_TRIG                                                                     0x4cce
#define regRLC_PREWALKER_UTCL1_TRIG_BASE_IDX                                                            1
#define regRLC_PREWALKER_UTCL1_ADDR_LSB                                                                 0x4ccf
#define regRLC_PREWALKER_UTCL1_ADDR_LSB_BASE_IDX                                                        1
#define regRLC_PREWALKER_UTCL1_ADDR_MSB                                                                 0x4cd0
#define regRLC_PREWALKER_UTCL1_ADDR_MSB_BASE_IDX                                                        1
#define regRLC_PREWALKER_UTCL1_SIZE_LSB                                                                 0x4cd1
#define regRLC_PREWALKER_UTCL1_SIZE_LSB_BASE_IDX                                                        1
#define regRLC_PREWALKER_UTCL1_SIZE_MSB                                                                 0x4cd2
#define regRLC_PREWALKER_UTCL1_SIZE_MSB_BASE_IDX                                                        1
#define regRLC_DSM_TRIG                                                                                 0x4cd3
#define regRLC_DSM_TRIG_BASE_IDX                                                                        1
#define regRLC_UTCL1_STATUS                                                                             0x4cd4
#define regRLC_UTCL1_STATUS_BASE_IDX                                                                    1
#define regRLC_R2I_CNTL_0                                                                               0x4cd5
#define regRLC_R2I_CNTL_0_BASE_IDX                                                                      1
#define regRLC_R2I_CNTL_1                                                                               0x4cd6
#define regRLC_R2I_CNTL_1_BASE_IDX                                                                      1
#define regRLC_R2I_CNTL_2                                                                               0x4cd7
#define regRLC_R2I_CNTL_2_BASE_IDX                                                                      1
#define regRLC_R2I_CNTL_3                                                                               0x4cd8
#define regRLC_R2I_CNTL_3_BASE_IDX                                                                      1
#define regRLC_UTCL2_CNTL                                                                               0x4cd9
#define regRLC_UTCL2_CNTL_BASE_IDX                                                                      1
#define regRLC_LBPW_CU_STAT                                                                             0x4cda
#define regRLC_LBPW_CU_STAT_BASE_IDX                                                                    1
#define regRLC_DS_CNTL                                                                                  0x4cdb
#define regRLC_DS_CNTL_BASE_IDX                                                                         1
#define regRLC_GPM_INT_STAT_TH0                                                                         0x4cdc
#define regRLC_GPM_INT_STAT_TH0_BASE_IDX                                                                1
#define regRLC_GPM_GENERAL_13                                                                           0x4cdd
#define regRLC_GPM_GENERAL_13_BASE_IDX                                                                  1
#define regRLC_GPM_GENERAL_14                                                                           0x4cde
#define regRLC_GPM_GENERAL_14_BASE_IDX                                                                  1
#define regRLC_GPM_GENERAL_15                                                                           0x4cdf
#define regRLC_GPM_GENERAL_15_BASE_IDX                                                                  1
#define regRLC_SPARE_INT_1                                                                              0x4ce0
#define regRLC_SPARE_INT_1_BASE_IDX                                                                     1
#define regRLC_RLCV_SPARE_INT_1                                                                         0x4ce1
#define regRLC_RLCV_SPARE_INT_1_BASE_IDX                                                                1
#define regRLC_SEMAPHORE_2                                                                              0x4ce3
#define regRLC_SEMAPHORE_2_BASE_IDX                                                                     1
#define regRLC_SEMAPHORE_3                                                                              0x4ce4
#define regRLC_SEMAPHORE_3_BASE_IDX                                                                     1
#define regRLC_SMU_ARGUMENT_3                                                                           0x4ce5
#define regRLC_SMU_ARGUMENT_3_BASE_IDX                                                                  1
#define regRLC_SMU_ARGUMENT_4                                                                           0x4ce6
#define regRLC_SMU_ARGUMENT_4_BASE_IDX                                                                  1
#define regRLC_GPU_CLOCK_COUNT_LSB_1                                                                    0x4ce8
#define regRLC_GPU_CLOCK_COUNT_LSB_1_BASE_IDX                                                           1
#define regRLC_GPU_CLOCK_COUNT_MSB_1                                                                    0x4ce9
#define regRLC_GPU_CLOCK_COUNT_MSB_1_BASE_IDX                                                           1
#define regRLC_CAPTURE_GPU_CLOCK_COUNT_1                                                                0x4cea
#define regRLC_CAPTURE_GPU_CLOCK_COUNT_1_BASE_IDX                                                       1
#define regRLC_GPU_CLOCK_COUNT_LSB_2                                                                    0x4ceb
#define regRLC_GPU_CLOCK_COUNT_LSB_2_BASE_IDX                                                           1
#define regRLC_GPU_CLOCK_COUNT_MSB_2                                                                    0x4cec
#define regRLC_GPU_CLOCK_COUNT_MSB_2_BASE_IDX                                                           1
#define regRLC_CAPTURE_GPU_CLOCK_COUNT_2                                                                0x4cef
#define regRLC_CAPTURE_GPU_CLOCK_COUNT_2_BASE_IDX                                                       1
#define regRLC_CPG_STAT_INVAL                                                                           0x4d09
#define regRLC_CPG_STAT_INVAL_BASE_IDX                                                                  1
#define regRLC_UE_ERR_STATUS_LOW                                                                        0x4d40
#define regRLC_UE_ERR_STATUS_LOW_BASE_IDX                                                               1
#define regRLC_UE_ERR_STATUS_HIGH                                                                       0x4d41
#define regRLC_UE_ERR_STATUS_HIGH_BASE_IDX                                                              1
#define regRLC_DSM_CNTL                                                                                 0x4d42
#define regRLC_DSM_CNTL_BASE_IDX                                                                        1
#define regRLC_DSM_CNTLA                                                                                0x4d43
#define regRLC_DSM_CNTLA_BASE_IDX                                                                       1
#define regRLC_DSM_CNTL2                                                                                0x4d44
#define regRLC_DSM_CNTL2_BASE_IDX                                                                       1
#define regRLC_DSM_CNTL2A                                                                               0x4d45
#define regRLC_DSM_CNTL2A_BASE_IDX                                                                      1
#define regRLC_CE_ERR_STATUS_LOW                                                                        0x4d49
#define regRLC_CE_ERR_STATUS_LOW_BASE_IDX                                                               1
#define regRLC_CE_ERR_STATUS_HIGH                                                                       0x4d4a
#define regRLC_CE_ERR_STATUS_HIGH_BASE_IDX                                                              1
#define regRLC_RLCV_SPARE_INT                                                                           0x4f30
#define regRLC_RLCV_SPARE_INT_BASE_IDX                                                                  1
#define regRLC_SMU_CLK_REQ                                                                              0x4f97
#define regRLC_SMU_CLK_REQ_BASE_IDX                                                                     1


// addressBlock: xcd0_gc_pwrdec
// base address: 0x3c000
#define regCGTS_SM_CTRL_REG                                                                             0x5000
#define regCGTS_SM_CTRL_REG_BASE_IDX                                                                    1
#define regCGTS_RD_CTRL_REG                                                                             0x5001
#define regCGTS_RD_CTRL_REG_BASE_IDX                                                                    1
#define regCGTS_RD_REG                                                                                  0x5002
#define regCGTS_RD_REG_BASE_IDX                                                                         1
#define regCGTS_TCC_DISABLE                                                                             0x5003
#define regCGTS_TCC_DISABLE_BASE_IDX                                                                    1
#define regCGTS_USER_TCC_DISABLE                                                                        0x5004
#define regCGTS_USER_TCC_DISABLE_BASE_IDX                                                               1
#define regCGTS_CU0_SP0_CTRL_REG                                                                        0x5008
#define regCGTS_CU0_SP0_CTRL_REG_BASE_IDX                                                               1
#define regCGTS_CU0_LDS_SQ_CTRL_REG                                                                     0x5009
#define regCGTS_CU0_LDS_SQ_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU0_TA_SQC_CTRL_REG                                                                     0x500a
#define regCGTS_CU0_TA_SQC_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU0_SP1_CTRL_REG                                                                        0x500b
#define regCGTS_CU0_SP1_CTRL_REG_BASE_IDX                                                               1
#define regCGTS_CU0_TD_TCP_CTRL_REG                                                                     0x500c
#define regCGTS_CU0_TD_TCP_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU1_SP0_CTRL_REG                                                                        0x500d
#define regCGTS_CU1_SP0_CTRL_REG_BASE_IDX                                                               1
#define regCGTS_CU1_LDS_SQ_CTRL_REG                                                                     0x500e
#define regCGTS_CU1_LDS_SQ_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU1_TA_SQC_CTRL_REG                                                                     0x500f
#define regCGTS_CU1_TA_SQC_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU1_SP1_CTRL_REG                                                                        0x5010
#define regCGTS_CU1_SP1_CTRL_REG_BASE_IDX                                                               1
#define regCGTS_CU1_TD_TCP_CTRL_REG                                                                     0x5011
#define regCGTS_CU1_TD_TCP_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU2_SP0_CTRL_REG                                                                        0x5012
#define regCGTS_CU2_SP0_CTRL_REG_BASE_IDX                                                               1
#define regCGTS_CU2_LDS_SQ_CTRL_REG                                                                     0x5013
#define regCGTS_CU2_LDS_SQ_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU2_TA_SQC_CTRL_REG                                                                     0x5014
#define regCGTS_CU2_TA_SQC_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU2_SP1_CTRL_REG                                                                        0x5015
#define regCGTS_CU2_SP1_CTRL_REG_BASE_IDX                                                               1
#define regCGTS_CU2_TD_TCP_CTRL_REG                                                                     0x5016
#define regCGTS_CU2_TD_TCP_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU3_SP0_CTRL_REG                                                                        0x5017
#define regCGTS_CU3_SP0_CTRL_REG_BASE_IDX                                                               1
#define regCGTS_CU3_LDS_SQ_CTRL_REG                                                                     0x5018
#define regCGTS_CU3_LDS_SQ_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU3_TA_SQC_CTRL_REG                                                                     0x5019
#define regCGTS_CU3_TA_SQC_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU3_SP1_CTRL_REG                                                                        0x501a
#define regCGTS_CU3_SP1_CTRL_REG_BASE_IDX                                                               1
#define regCGTS_CU3_TD_TCP_CTRL_REG                                                                     0x501b
#define regCGTS_CU3_TD_TCP_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU4_SP0_CTRL_REG                                                                        0x501c
#define regCGTS_CU4_SP0_CTRL_REG_BASE_IDX                                                               1
#define regCGTS_CU4_LDS_SQ_CTRL_REG                                                                     0x501d
#define regCGTS_CU4_LDS_SQ_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU4_TA_SQC_CTRL_REG                                                                     0x501e
#define regCGTS_CU4_TA_SQC_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU4_SP1_CTRL_REG                                                                        0x501f
#define regCGTS_CU4_SP1_CTRL_REG_BASE_IDX                                                               1
#define regCGTS_CU4_TD_TCP_CTRL_REG                                                                     0x5020
#define regCGTS_CU4_TD_TCP_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU5_SP0_CTRL_REG                                                                        0x5021
#define regCGTS_CU5_SP0_CTRL_REG_BASE_IDX                                                               1
#define regCGTS_CU5_LDS_SQ_CTRL_REG                                                                     0x5022
#define regCGTS_CU5_LDS_SQ_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU5_TA_SQC_CTRL_REG                                                                     0x5023
#define regCGTS_CU5_TA_SQC_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU5_SP1_CTRL_REG                                                                        0x5024
#define regCGTS_CU5_SP1_CTRL_REG_BASE_IDX                                                               1
#define regCGTS_CU5_TD_TCP_CTRL_REG                                                                     0x5025
#define regCGTS_CU5_TD_TCP_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU6_SP0_CTRL_REG                                                                        0x5026
#define regCGTS_CU6_SP0_CTRL_REG_BASE_IDX                                                               1
#define regCGTS_CU6_LDS_SQ_CTRL_REG                                                                     0x5027
#define regCGTS_CU6_LDS_SQ_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU6_TA_SQC_CTRL_REG                                                                     0x5028
#define regCGTS_CU6_TA_SQC_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU6_SP1_CTRL_REG                                                                        0x5029
#define regCGTS_CU6_SP1_CTRL_REG_BASE_IDX                                                               1
#define regCGTS_CU6_TD_TCP_CTRL_REG                                                                     0x502a
#define regCGTS_CU6_TD_TCP_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU7_SP0_CTRL_REG                                                                        0x502b
#define regCGTS_CU7_SP0_CTRL_REG_BASE_IDX                                                               1
#define regCGTS_CU7_LDS_SQ_CTRL_REG                                                                     0x502c
#define regCGTS_CU7_LDS_SQ_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU7_TA_SQC_CTRL_REG                                                                     0x502d
#define regCGTS_CU7_TA_SQC_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU7_SP1_CTRL_REG                                                                        0x502e
#define regCGTS_CU7_SP1_CTRL_REG_BASE_IDX                                                               1
#define regCGTS_CU7_TD_TCP_CTRL_REG                                                                     0x502f
#define regCGTS_CU7_TD_TCP_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU8_SP0_CTRL_REG                                                                        0x5030
#define regCGTS_CU8_SP0_CTRL_REG_BASE_IDX                                                               1
#define regCGTS_CU8_LDS_SQ_CTRL_REG                                                                     0x5031
#define regCGTS_CU8_LDS_SQ_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU8_TA_SQC_CTRL_REG                                                                     0x5032
#define regCGTS_CU8_TA_SQC_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU8_SP1_CTRL_REG                                                                        0x5033
#define regCGTS_CU8_SP1_CTRL_REG_BASE_IDX                                                               1
#define regCGTS_CU8_TD_TCP_CTRL_REG                                                                     0x5034
#define regCGTS_CU8_TD_TCP_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU9_SP0_CTRL_REG                                                                        0x5035
#define regCGTS_CU9_SP0_CTRL_REG_BASE_IDX                                                               1
#define regCGTS_CU9_LDS_SQ_CTRL_REG                                                                     0x5036
#define regCGTS_CU9_LDS_SQ_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU9_TA_SQC_CTRL_REG                                                                     0x5037
#define regCGTS_CU9_TA_SQC_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU9_SP1_CTRL_REG                                                                        0x5038
#define regCGTS_CU9_SP1_CTRL_REG_BASE_IDX                                                               1
#define regCGTS_CU9_TD_TCP_CTRL_REG                                                                     0x5039
#define regCGTS_CU9_TD_TCP_CTRL_REG_BASE_IDX                                                            1
#define regCGTS_CU10_SP0_CTRL_REG                                                                       0x503a
#define regCGTS_CU10_SP0_CTRL_REG_BASE_IDX                                                              1
#define regCGTS_CU10_LDS_SQ_CTRL_REG                                                                    0x503b
#define regCGTS_CU10_LDS_SQ_CTRL_REG_BASE_IDX                                                           1
#define regCGTS_CU10_TA_SQC_CTRL_REG                                                                    0x503c
#define regCGTS_CU10_TA_SQC_CTRL_REG_BASE_IDX                                                           1
#define regCGTS_CU10_SP1_CTRL_REG                                                                       0x503d
#define regCGTS_CU10_SP1_CTRL_REG_BASE_IDX                                                              1
#define regCGTS_CU10_TD_TCP_CTRL_REG                                                                    0x503e
#define regCGTS_CU10_TD_TCP_CTRL_REG_BASE_IDX                                                           1
#define regCGTS_CU11_SP0_CTRL_REG                                                                       0x503f
#define regCGTS_CU11_SP0_CTRL_REG_BASE_IDX                                                              1
#define regCGTS_CU11_LDS_SQ_CTRL_REG                                                                    0x5040
#define regCGTS_CU11_LDS_SQ_CTRL_REG_BASE_IDX                                                           1
#define regCGTS_CU11_TA_SQC_CTRL_REG                                                                    0x5041
#define regCGTS_CU11_TA_SQC_CTRL_REG_BASE_IDX                                                           1
#define regCGTS_CU11_SP1_CTRL_REG                                                                       0x5042
#define regCGTS_CU11_SP1_CTRL_REG_BASE_IDX                                                              1
#define regCGTS_CU11_TD_TCP_CTRL_REG                                                                    0x5043
#define regCGTS_CU11_TD_TCP_CTRL_REG_BASE_IDX                                                           1
#define regCGTS_CU12_SP0_CTRL_REG                                                                       0x5044
#define regCGTS_CU12_SP0_CTRL_REG_BASE_IDX                                                              1
#define regCGTS_CU12_LDS_SQ_CTRL_REG                                                                    0x5045
#define regCGTS_CU12_LDS_SQ_CTRL_REG_BASE_IDX                                                           1
#define regCGTS_CU12_TA_SQC_CTRL_REG                                                                    0x5046
#define regCGTS_CU12_TA_SQC_CTRL_REG_BASE_IDX                                                           1
#define regCGTS_CU12_SP1_CTRL_REG                                                                       0x5047
#define regCGTS_CU12_SP1_CTRL_REG_BASE_IDX                                                              1
#define regCGTS_CU12_TD_TCP_CTRL_REG                                                                    0x5048
#define regCGTS_CU12_TD_TCP_CTRL_REG_BASE_IDX                                                           1
#define regCGTS_CU13_SP0_CTRL_REG                                                                       0x5049
#define regCGTS_CU13_SP0_CTRL_REG_BASE_IDX                                                              1
#define regCGTS_CU13_LDS_SQ_CTRL_REG                                                                    0x504a
#define regCGTS_CU13_LDS_SQ_CTRL_REG_BASE_IDX                                                           1
#define regCGTS_CU13_TA_SQC_CTRL_REG                                                                    0x504b
#define regCGTS_CU13_TA_SQC_CTRL_REG_BASE_IDX                                                           1
#define regCGTS_CU13_SP1_CTRL_REG                                                                       0x504c
#define regCGTS_CU13_SP1_CTRL_REG_BASE_IDX                                                              1
#define regCGTS_CU13_TD_TCP_CTRL_REG                                                                    0x504d
#define regCGTS_CU13_TD_TCP_CTRL_REG_BASE_IDX                                                           1
#define regCGTS_CU14_SP0_CTRL_REG                                                                       0x504e
#define regCGTS_CU14_SP0_CTRL_REG_BASE_IDX                                                              1
#define regCGTS_CU14_LDS_SQ_CTRL_REG                                                                    0x504f
#define regCGTS_CU14_LDS_SQ_CTRL_REG_BASE_IDX                                                           1
#define regCGTS_CU14_TA_SQC_CTRL_REG                                                                    0x5050
#define regCGTS_CU14_TA_SQC_CTRL_REG_BASE_IDX                                                           1
#define regCGTS_CU14_SP1_CTRL_REG                                                                       0x5051
#define regCGTS_CU14_SP1_CTRL_REG_BASE_IDX                                                              1
#define regCGTS_CU14_TD_TCP_CTRL_REG                                                                    0x5052
#define regCGTS_CU14_TD_TCP_CTRL_REG_BASE_IDX                                                           1
#define regCGTS_CU15_SP0_CTRL_REG                                                                       0x5053
#define regCGTS_CU15_SP0_CTRL_REG_BASE_IDX                                                              1
#define regCGTS_CU15_LDS_SQ_CTRL_REG                                                                    0x5054
#define regCGTS_CU15_LDS_SQ_CTRL_REG_BASE_IDX                                                           1
#define regCGTS_CU15_TA_SQC_CTRL_REG                                                                    0x5055
#define regCGTS_CU15_TA_SQC_CTRL_REG_BASE_IDX                                                           1
#define regCGTS_CU15_SP1_CTRL_REG                                                                       0x5056
#define regCGTS_CU15_SP1_CTRL_REG_BASE_IDX                                                              1
#define regCGTS_CU15_TD_TCP_CTRL_REG                                                                    0x5057
#define regCGTS_CU15_TD_TCP_CTRL_REG_BASE_IDX                                                           1
#define regCGTS_CU0_TCPI_CTRL_REG                                                                       0x5058
#define regCGTS_CU0_TCPI_CTRL_REG_BASE_IDX                                                              1
#define regCGTS_CU1_TCPI_CTRL_REG                                                                       0x5059
#define regCGTS_CU1_TCPI_CTRL_REG_BASE_IDX                                                              1
#define regCGTS_CU2_TCPI_CTRL_REG                                                                       0x505a
#define regCGTS_CU2_TCPI_CTRL_REG_BASE_IDX                                                              1
#define regCGTS_CU3_TCPI_CTRL_REG                                                                       0x505b
#define regCGTS_CU3_TCPI_CTRL_REG_BASE_IDX                                                              1
#define regCGTS_CU4_TCPI_CTRL_REG                                                                       0x505c
#define regCGTS_CU4_TCPI_CTRL_REG_BASE_IDX                                                              1
#define regCGTS_CU5_TCPI_CTRL_REG                                                                       0x505d
#define regCGTS_CU5_TCPI_CTRL_REG_BASE_IDX                                                              1
#define regCGTS_CU6_TCPI_CTRL_REG                                                                       0x505e
#define regCGTS_CU6_TCPI_CTRL_REG_BASE_IDX                                                              1
#define regCGTS_CU7_TCPI_CTRL_REG                                                                       0x505f
#define regCGTS_CU7_TCPI_CTRL_REG_BASE_IDX                                                              1
#define regCGTS_CU8_TCPI_CTRL_REG                                                                       0x5060
#define regCGTS_CU8_TCPI_CTRL_REG_BASE_IDX                                                              1
#define regCGTS_CU9_TCPI_CTRL_REG                                                                       0x5061
#define regCGTS_CU9_TCPI_CTRL_REG_BASE_IDX                                                              1
#define regCGTS_CU10_TCPI_CTRL_REG                                                                      0x5062
#define regCGTS_CU10_TCPI_CTRL_REG_BASE_IDX                                                             1
#define regCGTS_CU11_TCPI_CTRL_REG                                                                      0x5063
#define regCGTS_CU11_TCPI_CTRL_REG_BASE_IDX                                                             1
#define regCGTS_CU12_TCPI_CTRL_REG                                                                      0x5064
#define regCGTS_CU12_TCPI_CTRL_REG_BASE_IDX                                                             1
#define regCGTS_CU13_TCPI_CTRL_REG                                                                      0x5065
#define regCGTS_CU13_TCPI_CTRL_REG_BASE_IDX                                                             1
#define regCGTS_CU14_TCPI_CTRL_REG                                                                      0x5066
#define regCGTS_CU14_TCPI_CTRL_REG_BASE_IDX                                                             1
#define regCGTS_CU15_TCPI_CTRL_REG                                                                      0x5067
#define regCGTS_CU15_TCPI_CTRL_REG_BASE_IDX                                                             1
#define regCGTT_SPI_PS_CLK_CTRL                                                                         0x507d
#define regCGTT_SPI_PS_CLK_CTRL_BASE_IDX                                                                1
#define regCGTT_SPIS_CLK_CTRL                                                                           0x507e
#define regCGTT_SPIS_CLK_CTRL_BASE_IDX                                                                  1
#define regCGTX_SPI_DEBUG_CLK_CTRL                                                                      0x507f
#define regCGTX_SPI_DEBUG_CLK_CTRL_BASE_IDX                                                             1
#define regCGTT_SPI_CLK_CTRL                                                                            0x5080
#define regCGTT_SPI_CLK_CTRL_BASE_IDX                                                                   1
#define regCGTT_PC_CLK_CTRL                                                                             0x5081
#define regCGTT_PC_CLK_CTRL_BASE_IDX                                                                    1
#define regCGTT_BCI_CLK_CTRL                                                                            0x5082
#define regCGTT_BCI_CLK_CTRL_BASE_IDX                                                                   1
#define regCGTT_VGT_CLK_CTRL                                                                            0x5084
#define regCGTT_VGT_CLK_CTRL_BASE_IDX                                                                   1
#define regCGTT_IA_CLK_CTRL                                                                             0x5085
#define regCGTT_IA_CLK_CTRL_BASE_IDX                                                                    1
#define regCGTT_WD_CLK_CTRL                                                                             0x5086
#define regCGTT_WD_CLK_CTRL_BASE_IDX                                                                    1
#define regCGTT_PA_CLK_CTRL                                                                             0x5088
#define regCGTT_PA_CLK_CTRL_BASE_IDX                                                                    1
#define regCGTT_SC_CLK_CTRL0                                                                            0x5089
#define regCGTT_SC_CLK_CTRL0_BASE_IDX                                                                   1
#define regCGTT_SC_CLK_CTRL1                                                                            0x508a
#define regCGTT_SC_CLK_CTRL1_BASE_IDX                                                                   1
#define regCGTT_SC_CLK_CTRL2                                                                            0x508b
#define regCGTT_SC_CLK_CTRL2_BASE_IDX                                                                   1
#define regCGTT_SQ_CLK_CTRL                                                                             0x508c
#define regCGTT_SQ_CLK_CTRL_BASE_IDX                                                                    1
#define regCGTT_SQG_CLK_CTRL                                                                            0x508d
#define regCGTT_SQG_CLK_CTRL_BASE_IDX                                                                   1
#define regSQ_ALU_CLK_CTRL                                                                              0x508e
#define regSQ_ALU_CLK_CTRL_BASE_IDX                                                                     1
#define regSQ_TEX_CLK_CTRL                                                                              0x508f
#define regSQ_TEX_CLK_CTRL_BASE_IDX                                                                     1
#define regSQ_LDS_CLK_CTRL                                                                              0x5090
#define regSQ_LDS_CLK_CTRL_BASE_IDX                                                                     1
#define regSQ_POWER_THROTTLE                                                                            0x5091
#define regSQ_POWER_THROTTLE_BASE_IDX                                                                   1
#define regSQ_POWER_THROTTLE2                                                                           0x5092
#define regSQ_POWER_THROTTLE2_BASE_IDX                                                                  1
#define regTD_CGTT_CTRL                                                                                 0x509c
#define regTD_CGTT_CTRL_BASE_IDX                                                                        1
#define regTA_CGTT_CTRL                                                                                 0x509d
#define regTA_CGTT_CTRL_BASE_IDX                                                                        1
#define regCGTT_TCPI_CLK_CTRL                                                                           0x509e
#define regCGTT_TCPI_CLK_CTRL_BASE_IDX                                                                  1
#define regTCX_CGTT_SCLK_CTRL                                                                           0x50a3
#define regTCX_CGTT_SCLK_CTRL_BASE_IDX                                                                  1
#define regDB_CGTT_CLK_CTRL_0                                                                           0x50a4
#define regDB_CGTT_CLK_CTRL_0_BASE_IDX                                                                  1
#define regCB_CGTT_SCLK_CTRL                                                                            0x50a8
#define regCB_CGTT_SCLK_CTRL_BASE_IDX                                                                   1
#define regTCC_CGTT_SCLK_CTRL                                                                           0x50ac
#define regTCC_CGTT_SCLK_CTRL_BASE_IDX                                                                  1
#define regTCC_CGTT_SCLK_CTRL2                                                                          0x50ad
#define regTCC_CGTT_SCLK_CTRL2_BASE_IDX                                                                 1
#define regTCC_CGTT_SCLK_CTRL3                                                                          0x50ae
#define regTCC_CGTT_SCLK_CTRL3_BASE_IDX                                                                 1
#define regTCA_CGTT_SCLK_CTRL                                                                           0x50af
#define regTCA_CGTT_SCLK_CTRL_BASE_IDX                                                                  1
#define regCGTT_CP_CLK_CTRL                                                                             0x50b0
#define regCGTT_CP_CLK_CTRL_BASE_IDX                                                                    1
#define regCGTT_CPC_CLK_CTRL                                                                            0x50b2
#define regCGTT_CPC_CLK_CTRL_BASE_IDX                                                                   1
#define regCGTT_RLC_CLK_CTRL                                                                            0x50b5
#define regCGTT_RLC_CLK_CTRL_BASE_IDX                                                                   1
#define regRLC_GFX_RM_CNTL                                                                              0x50b6
#define regRLC_GFX_RM_CNTL_BASE_IDX                                                                     1
#define regRMI_CGTT_SCLK_CTRL                                                                           0x50c0
#define regRMI_CGTT_SCLK_CTRL_BASE_IDX                                                                  1
#define regCGTT_TCPF_CLK_CTRL                                                                           0x50c1
#define regCGTT_TCPF_CLK_CTRL_BASE_IDX                                                                  1


// addressBlock: xcd0_gc_hypdec
// base address: 0x3e000
#define regCP_HYP_PFP_UCODE_ADDR                                                                        0x5814
#define regCP_HYP_PFP_UCODE_ADDR_BASE_IDX                                                               1
#define regCP_PFP_UCODE_ADDR                                                                            0x5814
#define regCP_PFP_UCODE_ADDR_BASE_IDX                                                                   1
#define regCP_HYP_PFP_UCODE_DATA                                                                        0x5815
#define regCP_HYP_PFP_UCODE_DATA_BASE_IDX                                                               1
#define regCP_PFP_UCODE_DATA                                                                            0x5815
#define regCP_PFP_UCODE_DATA_BASE_IDX                                                                   1
#define regCP_HYP_ME_UCODE_ADDR                                                                         0x5816
#define regCP_HYP_ME_UCODE_ADDR_BASE_IDX                                                                1
#define regCP_ME_RAM_RADDR                                                                              0x5816
#define regCP_ME_RAM_RADDR_BASE_IDX                                                                     1
#define regCP_ME_RAM_WADDR                                                                              0x5816
#define regCP_ME_RAM_WADDR_BASE_IDX                                                                     1
#define regCP_HYP_ME_UCODE_DATA                                                                         0x5817
#define regCP_HYP_ME_UCODE_DATA_BASE_IDX                                                                1
#define regCP_ME_RAM_DATA                                                                               0x5817
#define regCP_ME_RAM_DATA_BASE_IDX                                                                      1
#define regCP_CE_UCODE_ADDR                                                                             0x5818
#define regCP_CE_UCODE_ADDR_BASE_IDX                                                                    1
#define regCP_HYP_CE_UCODE_ADDR                                                                         0x5818
#define regCP_HYP_CE_UCODE_ADDR_BASE_IDX                                                                1
#define regCP_CE_UCODE_DATA                                                                             0x5819
#define regCP_CE_UCODE_DATA_BASE_IDX                                                                    1
#define regCP_HYP_CE_UCODE_DATA                                                                         0x5819
#define regCP_HYP_CE_UCODE_DATA_BASE_IDX                                                                1
#define regCP_HYP_MEC1_UCODE_ADDR                                                                       0x581a
#define regCP_HYP_MEC1_UCODE_ADDR_BASE_IDX                                                              1
#define regCP_MEC_ME1_UCODE_ADDR                                                                        0x581a
#define regCP_MEC_ME1_UCODE_ADDR_BASE_IDX                                                               1
#define regCP_HYP_MEC1_UCODE_DATA                                                                       0x581b
#define regCP_HYP_MEC1_UCODE_DATA_BASE_IDX                                                              1
#define regCP_MEC_ME1_UCODE_DATA                                                                        0x581b
#define regCP_MEC_ME1_UCODE_DATA_BASE_IDX                                                               1
#define regCP_HYP_MEC2_UCODE_ADDR                                                                       0x581c
#define regCP_HYP_MEC2_UCODE_ADDR_BASE_IDX                                                              1
#define regCP_MEC_ME2_UCODE_ADDR                                                                        0x581c
#define regCP_MEC_ME2_UCODE_ADDR_BASE_IDX                                                               1
#define regCP_HYP_MEC2_UCODE_DATA                                                                       0x581d
#define regCP_HYP_MEC2_UCODE_DATA_BASE_IDX                                                              1
#define regCP_MEC_ME2_UCODE_DATA                                                                        0x581d
#define regCP_MEC_ME2_UCODE_DATA_BASE_IDX                                                               1
#define regCP_HYP_PFP_UCODE_CHKSUM                                                                      0x581e
#define regCP_HYP_PFP_UCODE_CHKSUM_BASE_IDX                                                             1
#define regCP_HYP_CE_UCODE_CHKSUM                                                                       0x581f
#define regCP_HYP_CE_UCODE_CHKSUM_BASE_IDX                                                              1
#define regCP_HYP_ME_UCODE_CHKSUM                                                                       0x5820
#define regCP_HYP_ME_UCODE_CHKSUM_BASE_IDX                                                              1
#define regCP_HYP_MEC_ME1_UCODE_CHKSUM                                                                  0x5821
#define regCP_HYP_MEC_ME1_UCODE_CHKSUM_BASE_IDX                                                         1
#define regCP_HYP_MEC_ME2_UCODE_CHKSUM                                                                  0x5822
#define regCP_HYP_MEC_ME2_UCODE_CHKSUM_BASE_IDX                                                         1
#define regCP_HYP_XCP_CTL                                                                               0x5828
#define regCP_HYP_XCP_CTL_BASE_IDX                                                                      1
#define regRLC_GPM_UCODE_ADDR                                                                           0x583c
#define regRLC_GPM_UCODE_ADDR_BASE_IDX                                                                  1
#define regRLC_GPM_UCODE_DATA                                                                           0x583d
#define regRLC_GPM_UCODE_DATA_BASE_IDX                                                                  1
#define regGRBM_GFX_INDEX_SR_SELECT                                                                     0x5a00
#define regGRBM_GFX_INDEX_SR_SELECT_BASE_IDX                                                            1
#define regGRBM_GFX_INDEX_SR_DATA                                                                       0x5a01
#define regGRBM_GFX_INDEX_SR_DATA_BASE_IDX                                                              1
#define regGRBM_GFX_CNTL_SR_SELECT                                                                      0x5a02
#define regGRBM_GFX_CNTL_SR_SELECT_BASE_IDX                                                             1
#define regGRBM_GFX_CNTL_SR_DATA                                                                        0x5a03
#define regGRBM_GFX_CNTL_SR_DATA_BASE_IDX                                                               1
#define regGRBM_MCM_ADDR                                                                                0x5a07
#define regGRBM_MCM_ADDR_BASE_IDX                                                                       1
#define regRLC_GPU_IOV_VF_ENABLE                                                                        0x5b00
#define regRLC_GPU_IOV_VF_ENABLE_BASE_IDX                                                               1
#define regRLC_GPU_IOV_CFG_REG6                                                                         0x5b06
#define regRLC_GPU_IOV_CFG_REG6_BASE_IDX                                                                1
#define regRLC_GPU_IOV_CFG_REG8                                                                         0x5b20
#define regRLC_GPU_IOV_CFG_REG8_BASE_IDX                                                                1
#define regRLC_RLCV_TIMER_INT_0                                                                         0x5b25
#define regRLC_RLCV_TIMER_INT_0_BASE_IDX                                                                1
#define regRLC_RLCV_TIMER_CTRL                                                                          0x5b26
#define regRLC_RLCV_TIMER_CTRL_BASE_IDX                                                                 1
#define regRLC_RLCV_TIMER_STAT                                                                          0x5b27
#define regRLC_RLCV_TIMER_STAT_BASE_IDX                                                                 1
#define regRLC_GPU_IOV_VF_DOORBELL_STATUS                                                               0x5b2a
#define regRLC_GPU_IOV_VF_DOORBELL_STATUS_BASE_IDX                                                      1
#define regRLC_GPU_IOV_VF_DOORBELL_STATUS_SET                                                           0x5b2b
#define regRLC_GPU_IOV_VF_DOORBELL_STATUS_SET_BASE_IDX                                                  1
#define regRLC_GPU_IOV_VF_DOORBELL_STATUS_CLR                                                           0x5b2c
#define regRLC_GPU_IOV_VF_DOORBELL_STATUS_CLR_BASE_IDX                                                  1
#define regRLC_GPU_IOV_VF_MASK                                                                          0x5b2d
#define regRLC_GPU_IOV_VF_MASK_BASE_IDX                                                                 1
#define regRLC_HYP_SEMAPHORE_0                                                                          0x5b2e
#define regRLC_HYP_SEMAPHORE_0_BASE_IDX                                                                 1
#define regRLC_HYP_SEMAPHORE_1                                                                          0x5b2f
#define regRLC_HYP_SEMAPHORE_1_BASE_IDX                                                                 1
#define regRLC_CLK_CNTL                                                                                 0x5b31
#define regRLC_CLK_CNTL_BASE_IDX                                                                        1
#define regRLC_GPU_IOV_SCH_BLOCK                                                                        0x5b34
#define regRLC_GPU_IOV_SCH_BLOCK_BASE_IDX                                                               1
#define regRLC_GPU_IOV_CFG_REG1                                                                         0x5b35
#define regRLC_GPU_IOV_CFG_REG1_BASE_IDX                                                                1
#define regRLC_GPU_IOV_CFG_REG2                                                                         0x5b36
#define regRLC_GPU_IOV_CFG_REG2_BASE_IDX                                                                1
#define regRLC_GPU_IOV_VM_BUSY_STATUS                                                                   0x5b37
#define regRLC_GPU_IOV_VM_BUSY_STATUS_BASE_IDX                                                          1
#define regRLC_GPU_IOV_SCH_0                                                                            0x5b38
#define regRLC_GPU_IOV_SCH_0_BASE_IDX                                                                   1
#define regRLC_GPU_IOV_ACTIVE_FCN_ID                                                                    0x5b39
#define regRLC_GPU_IOV_ACTIVE_FCN_ID_BASE_IDX                                                           1
#define regRLC_GPU_IOV_SCH_3                                                                            0x5b3a
#define regRLC_GPU_IOV_SCH_3_BASE_IDX                                                                   1
#define regRLC_GPU_IOV_SCH_1                                                                            0x5b3b
#define regRLC_GPU_IOV_SCH_1_BASE_IDX                                                                   1
#define regRLC_GPU_IOV_SCH_2                                                                            0x5b3c
#define regRLC_GPU_IOV_SCH_2_BASE_IDX                                                                   1
#define regRLC_GPU_IOV_INT_STAT                                                                         0x5b3f
#define regRLC_GPU_IOV_INT_STAT_BASE_IDX                                                                1
#define regRLC_RLCV_TIMER_INT_1                                                                         0x5b40
#define regRLC_RLCV_TIMER_INT_1_BASE_IDX                                                                1
#define regRLC_GPU_IOV_UCODE_ADDR                                                                       0x5b42
#define regRLC_GPU_IOV_UCODE_ADDR_BASE_IDX                                                              1
#define regRLC_GPU_IOV_UCODE_DATA                                                                       0x5b43
#define regRLC_GPU_IOV_UCODE_DATA_BASE_IDX                                                              1
#define regRLC_GPU_IOV_SCRATCH_ADDR                                                                     0x5b44
#define regRLC_GPU_IOV_SCRATCH_ADDR_BASE_IDX                                                            1
#define regRLC_GPU_IOV_SCRATCH_DATA                                                                     0x5b45
#define regRLC_GPU_IOV_SCRATCH_DATA_BASE_IDX                                                            1
#define regRLC_GPU_IOV_F32_CNTL                                                                         0x5b46
#define regRLC_GPU_IOV_F32_CNTL_BASE_IDX                                                                1
#define regRLC_GPU_IOV_F32_RESET                                                                        0x5b47
#define regRLC_GPU_IOV_F32_RESET_BASE_IDX                                                               1
#define regRLC_GPU_IOV_SDMA0_STATUS                                                                     0x5b48
#define regRLC_GPU_IOV_SDMA0_STATUS_BASE_IDX                                                            1
#define regRLC_GPU_IOV_SDMA1_STATUS                                                                     0x5b49
#define regRLC_GPU_IOV_SDMA1_STATUS_BASE_IDX                                                            1
#define regRLC_GPU_IOV_SMU_RESPONSE                                                                     0x5b4a
#define regRLC_GPU_IOV_SMU_RESPONSE_BASE_IDX                                                            1
#define regRLC_GPU_IOV_VIRT_RESET_REQ                                                                   0x5b4c
#define regRLC_GPU_IOV_VIRT_RESET_REQ_BASE_IDX                                                          1
#define regRLC_GPU_IOV_RLC_RESPONSE                                                                     0x5b4d
#define regRLC_GPU_IOV_RLC_RESPONSE_BASE_IDX                                                            1
#define regRLC_GPU_IOV_INT_DISABLE                                                                      0x5b4e
#define regRLC_GPU_IOV_INT_DISABLE_BASE_IDX                                                             1
#define regRLC_GPU_IOV_INT_FORCE                                                                        0x5b4f
#define regRLC_GPU_IOV_INT_FORCE_BASE_IDX                                                               1
#define regRLC_GPU_IOV_SDMA0_BUSY_STATUS                                                                0x5b50
#define regRLC_GPU_IOV_SDMA0_BUSY_STATUS_BASE_IDX                                                       1
#define regRLC_GPU_IOV_SDMA1_BUSY_STATUS                                                                0x5b51
#define regRLC_GPU_IOV_SDMA1_BUSY_STATUS_BASE_IDX                                                       1
#define regRLC_HYP_SEMAPHORE_2                                                                          0x5b52
#define regRLC_HYP_SEMAPHORE_2_BASE_IDX                                                                 1
#define regRLC_HYP_SEMAPHORE_3                                                                          0x5b53
#define regRLC_HYP_SEMAPHORE_3_BASE_IDX                                                                 1
#define regRLC_GPU_IOV_SDMA2_STATUS                                                                     0x5b54
#define regRLC_GPU_IOV_SDMA2_STATUS_BASE_IDX                                                            1
#define regRLC_GPU_IOV_SDMA3_STATUS                                                                     0x5b55
#define regRLC_GPU_IOV_SDMA3_STATUS_BASE_IDX                                                            1
#define regRLC_GPU_IOV_SDMA4_STATUS                                                                     0x5b56
#define regRLC_GPU_IOV_SDMA4_STATUS_BASE_IDX                                                            1
#define regRLC_GPU_IOV_SDMA5_STATUS                                                                     0x5b57
#define regRLC_GPU_IOV_SDMA5_STATUS_BASE_IDX                                                            1
#define regRLC_GPU_IOV_SDMA6_STATUS                                                                     0x5b58
#define regRLC_GPU_IOV_SDMA6_STATUS_BASE_IDX                                                            1
#define regRLC_GPU_IOV_SDMA7_STATUS                                                                     0x5b59
#define regRLC_GPU_IOV_SDMA7_STATUS_BASE_IDX                                                            1
#define regRLC_GPU_IOV_SDMA2_BUSY_STATUS                                                                0x5b5a
#define regRLC_GPU_IOV_SDMA2_BUSY_STATUS_BASE_IDX                                                       1
#define regRLC_GPU_IOV_SDMA3_BUSY_STATUS                                                                0x5b5b
#define regRLC_GPU_IOV_SDMA3_BUSY_STATUS_BASE_IDX                                                       1
#define regRLC_GPU_IOV_SDMA4_BUSY_STATUS                                                                0x5b5c
#define regRLC_GPU_IOV_SDMA4_BUSY_STATUS_BASE_IDX                                                       1
#define regRLC_GPU_IOV_SDMA5_BUSY_STATUS                                                                0x5b5d
#define regRLC_GPU_IOV_SDMA5_BUSY_STATUS_BASE_IDX                                                       1
#define regRLC_GPU_IOV_SDMA6_BUSY_STATUS                                                                0x5b5e
#define regRLC_GPU_IOV_SDMA6_BUSY_STATUS_BASE_IDX                                                       1
#define regRLC_GPU_IOV_SDMA7_BUSY_STATUS                                                                0x5b5f
#define regRLC_GPU_IOV_SDMA7_BUSY_STATUS_BASE_IDX                                                       1


// addressBlock: xcd0_gc_utcl2_vmsharedhvdec
// base address: 0x3ea00
#define regMC_VM_FB_SIZE_OFFSET_VF0                                                                     0x5a80
#define regMC_VM_FB_SIZE_OFFSET_VF0_BASE_IDX                                                            1
#define regMC_VM_FB_SIZE_OFFSET_VF1                                                                     0x5a81
#define regMC_VM_FB_SIZE_OFFSET_VF1_BASE_IDX                                                            1
#define regMC_VM_FB_SIZE_OFFSET_VF2                                                                     0x5a82
#define regMC_VM_FB_SIZE_OFFSET_VF2_BASE_IDX                                                            1
#define regMC_VM_FB_SIZE_OFFSET_VF3                                                                     0x5a83
#define regMC_VM_FB_SIZE_OFFSET_VF3_BASE_IDX                                                            1
#define regMC_VM_FB_SIZE_OFFSET_VF4                                                                     0x5a84
#define regMC_VM_FB_SIZE_OFFSET_VF4_BASE_IDX                                                            1
#define regMC_VM_FB_SIZE_OFFSET_VF5                                                                     0x5a85
#define regMC_VM_FB_SIZE_OFFSET_VF5_BASE_IDX                                                            1
#define regMC_VM_FB_SIZE_OFFSET_VF6                                                                     0x5a86
#define regMC_VM_FB_SIZE_OFFSET_VF6_BASE_IDX                                                            1
#define regMC_VM_FB_SIZE_OFFSET_VF7                                                                     0x5a87
#define regMC_VM_FB_SIZE_OFFSET_VF7_BASE_IDX                                                            1
#define regMC_VM_FB_SIZE_OFFSET_VF8                                                                     0x5a88
#define regMC_VM_FB_SIZE_OFFSET_VF8_BASE_IDX                                                            1
#define regMC_VM_FB_SIZE_OFFSET_VF9                                                                     0x5a89
#define regMC_VM_FB_SIZE_OFFSET_VF9_BASE_IDX                                                            1
#define regMC_VM_FB_SIZE_OFFSET_VF10                                                                    0x5a8a
#define regMC_VM_FB_SIZE_OFFSET_VF10_BASE_IDX                                                           1
#define regMC_VM_FB_SIZE_OFFSET_VF11                                                                    0x5a8b
#define regMC_VM_FB_SIZE_OFFSET_VF11_BASE_IDX                                                           1
#define regMC_VM_FB_SIZE_OFFSET_VF12                                                                    0x5a8c
#define regMC_VM_FB_SIZE_OFFSET_VF12_BASE_IDX                                                           1
#define regMC_VM_FB_SIZE_OFFSET_VF13                                                                    0x5a8d
#define regMC_VM_FB_SIZE_OFFSET_VF13_BASE_IDX                                                           1
#define regMC_VM_FB_SIZE_OFFSET_VF14                                                                    0x5a8e
#define regMC_VM_FB_SIZE_OFFSET_VF14_BASE_IDX                                                           1
#define regMC_VM_FB_SIZE_OFFSET_VF15                                                                    0x5a8f
#define regMC_VM_FB_SIZE_OFFSET_VF15_BASE_IDX                                                           1
#define regVM_IOMMU_MMIO_CNTRL_1                                                                        0x5a90
#define regVM_IOMMU_MMIO_CNTRL_1_BASE_IDX                                                               1
#define regMC_VM_MARC_BASE_LO_0                                                                         0x5a91
#define regMC_VM_MARC_BASE_LO_0_BASE_IDX                                                                1
#define regMC_VM_MARC_BASE_LO_1                                                                         0x5a92
#define regMC_VM_MARC_BASE_LO_1_BASE_IDX                                                                1
#define regMC_VM_MARC_BASE_LO_2                                                                         0x5a93
#define regMC_VM_MARC_BASE_LO_2_BASE_IDX                                                                1
#define regMC_VM_MARC_BASE_LO_3                                                                         0x5a94
#define regMC_VM_MARC_BASE_LO_3_BASE_IDX                                                                1
#define regMC_VM_MARC_BASE_HI_0                                                                         0x5a95
#define regMC_VM_MARC_BASE_HI_0_BASE_IDX                                                                1
#define regMC_VM_MARC_BASE_HI_1                                                                         0x5a96
#define regMC_VM_MARC_BASE_HI_1_BASE_IDX                                                                1
#define regMC_VM_MARC_BASE_HI_2                                                                         0x5a97
#define regMC_VM_MARC_BASE_HI_2_BASE_IDX                                                                1
#define regMC_VM_MARC_BASE_HI_3                                                                         0x5a98
#define regMC_VM_MARC_BASE_HI_3_BASE_IDX                                                                1
#define regMC_VM_MARC_RELOC_LO_0                                                                        0x5a99
#define regMC_VM_MARC_RELOC_LO_0_BASE_IDX                                                               1
#define regMC_VM_MARC_RELOC_LO_1                                                                        0x5a9a
#define regMC_VM_MARC_RELOC_LO_1_BASE_IDX                                                               1
#define regMC_VM_MARC_RELOC_LO_2                                                                        0x5a9b
#define regMC_VM_MARC_RELOC_LO_2_BASE_IDX                                                               1
#define regMC_VM_MARC_RELOC_LO_3                                                                        0x5a9c
#define regMC_VM_MARC_RELOC_LO_3_BASE_IDX                                                               1
#define regMC_VM_MARC_RELOC_HI_0                                                                        0x5a9d
#define regMC_VM_MARC_RELOC_HI_0_BASE_IDX                                                               1
#define regMC_VM_MARC_RELOC_HI_1                                                                        0x5a9e
#define regMC_VM_MARC_RELOC_HI_1_BASE_IDX                                                               1
#define regMC_VM_MARC_RELOC_HI_2                                                                        0x5a9f
#define regMC_VM_MARC_RELOC_HI_2_BASE_IDX                                                               1
#define regMC_VM_MARC_RELOC_HI_3                                                                        0x5aa0
#define regMC_VM_MARC_RELOC_HI_3_BASE_IDX                                                               1
#define regMC_VM_MARC_LEN_LO_0                                                                          0x5aa1
#define regMC_VM_MARC_LEN_LO_0_BASE_IDX                                                                 1
#define regMC_VM_MARC_LEN_LO_1                                                                          0x5aa2
#define regMC_VM_MARC_LEN_LO_1_BASE_IDX                                                                 1
#define regMC_VM_MARC_LEN_LO_2                                                                          0x5aa3
#define regMC_VM_MARC_LEN_LO_2_BASE_IDX                                                                 1
#define regMC_VM_MARC_LEN_LO_3                                                                          0x5aa4
#define regMC_VM_MARC_LEN_LO_3_BASE_IDX                                                                 1
#define regMC_VM_MARC_LEN_HI_0                                                                          0x5aa5
#define regMC_VM_MARC_LEN_HI_0_BASE_IDX                                                                 1
#define regMC_VM_MARC_LEN_HI_1                                                                          0x5aa6
#define regMC_VM_MARC_LEN_HI_1_BASE_IDX                                                                 1
#define regMC_VM_MARC_LEN_HI_2                                                                          0x5aa7
#define regMC_VM_MARC_LEN_HI_2_BASE_IDX                                                                 1
#define regMC_VM_MARC_LEN_HI_3                                                                          0x5aa8
#define regMC_VM_MARC_LEN_HI_3_BASE_IDX                                                                 1
#define regVM_IOMMU_CONTROL_REGISTER                                                                    0x5aa9
#define regVM_IOMMU_CONTROL_REGISTER_BASE_IDX                                                           1
#define regVM_IOMMU_PERFORMANCE_OPTIMIZATION_CONTROL_REGISTER                                           0x5aaa
#define regVM_IOMMU_PERFORMANCE_OPTIMIZATION_CONTROL_REGISTER_BASE_IDX                                  1
#define regVM_PCIE_ATS_CNTL                                                                             0x5aab
#define regVM_PCIE_ATS_CNTL_BASE_IDX                                                                    1
#define regVM_PCIE_ATS_CNTL_VF_0                                                                        0x5aac
#define regVM_PCIE_ATS_CNTL_VF_0_BASE_IDX                                                               1
#define regVM_PCIE_ATS_CNTL_VF_1                                                                        0x5aad
#define regVM_PCIE_ATS_CNTL_VF_1_BASE_IDX                                                               1
#define regVM_PCIE_ATS_CNTL_VF_2                                                                        0x5aae
#define regVM_PCIE_ATS_CNTL_VF_2_BASE_IDX                                                               1
#define regVM_PCIE_ATS_CNTL_VF_3                                                                        0x5aaf
#define regVM_PCIE_ATS_CNTL_VF_3_BASE_IDX                                                               1
#define regVM_PCIE_ATS_CNTL_VF_4                                                                        0x5ab0
#define regVM_PCIE_ATS_CNTL_VF_4_BASE_IDX                                                               1
#define regVM_PCIE_ATS_CNTL_VF_5                                                                        0x5ab1
#define regVM_PCIE_ATS_CNTL_VF_5_BASE_IDX                                                               1
#define regVM_PCIE_ATS_CNTL_VF_6                                                                        0x5ab2
#define regVM_PCIE_ATS_CNTL_VF_6_BASE_IDX                                                               1
#define regVM_PCIE_ATS_CNTL_VF_7                                                                        0x5ab3
#define regVM_PCIE_ATS_CNTL_VF_7_BASE_IDX                                                               1
#define regVM_PCIE_ATS_CNTL_VF_8                                                                        0x5ab4
#define regVM_PCIE_ATS_CNTL_VF_8_BASE_IDX                                                               1
#define regVM_PCIE_ATS_CNTL_VF_9                                                                        0x5ab5
#define regVM_PCIE_ATS_CNTL_VF_9_BASE_IDX                                                               1
#define regVM_PCIE_ATS_CNTL_VF_10                                                                       0x5ab6
#define regVM_PCIE_ATS_CNTL_VF_10_BASE_IDX                                                              1
#define regVM_PCIE_ATS_CNTL_VF_11                                                                       0x5ab7
#define regVM_PCIE_ATS_CNTL_VF_11_BASE_IDX                                                              1
#define regVM_PCIE_ATS_CNTL_VF_12                                                                       0x5ab8
#define regVM_PCIE_ATS_CNTL_VF_12_BASE_IDX                                                              1
#define regVM_PCIE_ATS_CNTL_VF_13                                                                       0x5ab9
#define regVM_PCIE_ATS_CNTL_VF_13_BASE_IDX                                                              1
#define regVM_PCIE_ATS_CNTL_VF_14                                                                       0x5aba
#define regVM_PCIE_ATS_CNTL_VF_14_BASE_IDX                                                              1
#define regVM_PCIE_ATS_CNTL_VF_15                                                                       0x5abb
#define regVM_PCIE_ATS_CNTL_VF_15_BASE_IDX                                                              1
#define regMC_SHARED_ACTIVE_FCN_ID                                                                      0x5abc
#define regMC_SHARED_ACTIVE_FCN_ID_BASE_IDX                                                             1
#define regMC_VM_XGMI_GPUIOV_ENABLE                                                                     0x5abd
#define regMC_VM_XGMI_GPUIOV_ENABLE_BASE_IDX                                                            1


// addressBlock: xcd0_gc_pspdec
// base address: 0x3f000
#define regCPG_PSP_DEBUG                                                                                0x5c30
#define regCPG_PSP_DEBUG_BASE_IDX                                                                       1
#define regCPC_PSP_DEBUG                                                                                0x5c31
#define regCPC_PSP_DEBUG_BASE_IDX                                                                       1
#define regCP_PSP_XCP_CTL                                                                               0x5c34
#define regCP_PSP_XCP_CTL_BASE_IDX                                                                      1
#define regGRBM_SEC_CNTL                                                                                0x5e0b
#define regGRBM_SEC_CNTL_BASE_IDX                                                                       1
#define regGRBM_IOV_ERROR_FIFO_DATA                                                                     0x5e12
#define regGRBM_IOV_ERROR_FIFO_DATA_BASE_IDX                                                            1
#define regGRBM_DSM_BYPASS                                                                              0x5e13
#define regGRBM_DSM_BYPASS_BASE_IDX                                                                     1
#define regGRBM_CAM_INDEX                                                                               0x5e16
#define regGRBM_CAM_INDEX_BASE_IDX                                                                      1
#define regGRBM_HYP_CAM_INDEX                                                                           0x5e16
#define regGRBM_HYP_CAM_INDEX_BASE_IDX                                                                  1
#define regGRBM_CAM_DATA                                                                                0x5e17
#define regGRBM_CAM_DATA_BASE_IDX                                                                       1
#define regGRBM_HYP_CAM_DATA                                                                            0x5e17
#define regGRBM_HYP_CAM_DATA_BASE_IDX                                                                   1
#define regRLC_FWL_FIRST_VIOL_ADDR                                                                      0x5f37
#define regRLC_FWL_FIRST_VIOL_ADDR_BASE_IDX                                                             1


// addressBlock: sqind
// base address: 0x0
#define ixSQ_DEBUG_STS_LOCAL                                                                           0x0008
#define ixSQ_DEBUG_CTRL_LOCAL                                                                          0x0009
#define ixSQ_WAVE_VALID_AND_IDLE                                                                       0x000a
#define ixSQ_WAVE_MODE                                                                                 0x0011
#define ixSQ_WAVE_STATUS                                                                               0x0012
#define ixSQ_WAVE_TRAPSTS                                                                              0x0013
#define ixSQ_WAVE_HW_ID                                                                                0x0014
#define ixSQ_WAVE_GPR_ALLOC                                                                            0x0015
#define ixSQ_WAVE_LDS_ALLOC                                                                            0x0016
#define ixSQ_WAVE_IB_STS                                                                               0x0017
#define ixSQ_WAVE_PC_LO                                                                                0x0018
#define ixSQ_WAVE_PC_HI                                                                                0x0019
#define ixSQ_WAVE_INST_DW0                                                                             0x001a
#define ixSQ_WAVE_INST_DW1                                                                             0x001b
#define ixSQ_WAVE_IB_DBG0                                                                              0x001c
#define ixSQ_WAVE_IB_DBG1                                                                              0x001d
#define ixSQ_WAVE_FLUSH_IB                                                                             0x001e
#define ixSQ_WAVE_TTMP0                                                                                0x026c
#define ixSQ_WAVE_TTMP1                                                                                0x026d
#define ixSQ_WAVE_TTMP2                                                                                0x026e
#define ixSQ_WAVE_TTMP3                                                                                0x026f
#define ixSQ_WAVE_TTMP4                                                                                0x0270
#define ixSQ_WAVE_TTMP5                                                                                0x0271
#define ixSQ_WAVE_TTMP6                                                                                0x0272
#define ixSQ_WAVE_TTMP7                                                                                0x0273
#define ixSQ_WAVE_TTMP8                                                                                0x0274
#define ixSQ_WAVE_TTMP9                                                                                0x0275
#define ixSQ_WAVE_TTMP10                                                                               0x0276
#define ixSQ_WAVE_TTMP11                                                                               0x0277
#define ixSQ_WAVE_TTMP12                                                                               0x0278
#define ixSQ_WAVE_TTMP13                                                                               0x0279
#define ixSQ_WAVE_TTMP14                                                                               0x027a
#define ixSQ_WAVE_TTMP15                                                                               0x027b
#define ixSQ_WAVE_M0                                                                                   0x027c
#define ixSQ_WAVE_EXEC_LO                                                                              0x027e
#define ixSQ_WAVE_EXEC_HI                                                                              0x027f
#define ixSQ_INTERRUPT_WORD_AUTO_CTXID                                                                 0x20c0
#define ixSQ_INTERRUPT_WORD_AUTO_HI                                                                    0x20c0
#define ixSQ_INTERRUPT_WORD_AUTO_LO                                                                    0x20c0
#define ixSQ_INTERRUPT_WORD_CMN_CTXID                                                                  0x20c0
#define ixSQ_INTERRUPT_WORD_CMN_HI                                                                     0x20c0
#define ixSQ_INTERRUPT_WORD_WAVE_CTXID                                                                 0x20c0
#define ixSQ_INTERRUPT_WORD_WAVE_HI                                                                    0x20c0
#define ixSQ_INTERRUPT_WORD_WAVE_LO                                                                    0x20c0


#endif
