# DependencyGraphViewer

## Why use this tool?
If you are developing with NativeAOT or using the IL linker, you might ask yourself: why are types or methods being kept after trimming? Sometimes, it can be unclear why certain types or methods are retained after a self-contained application is trimmed.

## How to build and run
1. Launch Visual Studio
2. Load `DependencyGraphViewer.sln`
3. Build and Run as normal
## Using ETW logs
The DependencyGraphViewer must be run as an administrator if collecting ETW events when compiling with NativeAOT. One of the easiest ways of doing this is by running Visual Studio as an administrator and then building and running the program.

For collecting ETW logs, publish the NativeAOT app you want to analyze. This code snippet is an example of publishing the app for Windows as a NativeAOT application on a machine with the required prerequisites installed.
```
dotnet publish -r win-x64 -c Release
```
The `-t:rebuild` argument can also be included and can help if you do not see the graph populating when you compile your program.
## Using DGML files
DGML dependency dumps are generated by the the NativeAOT compiler, the R2R (crossgen2) compiler, and the IL Linker. DGMLs can be opened by the tool either as a command line argument or using the file browser. To generate them, the following flags should be set:

### NativeAOT

Add `<IlcGenerateDgmlFile>true</IlcGenerateDgmlFile>` as a PropertyGroup in the `.csproj` file of your program. Make sure `<PublishAot>true</PublishAot>` is also added to your project file to publish with NativeAOT. The DGML file will be generated in the `obj` folder. One can find path of it with `dir /s *.dgml.xml` command. The usual path is `obj\<Configuration>\<Target_Framework>\<RID>\native\`.

### R2R (crossgen2)

Add `--dgmllog` to the command line to save the result of dependency analysis as a DGML.

### IL Linker

If using the IL linker, use `--dump-dependencies` and `--dependencies-file-format dgml` to dump DGML files.

Check the documentation for the compiler you are using for more information on how to generate DGML files when dumping dependencies.
## Get help
The "Information on the DependencyGraphViewer" button displays additional help information.
