/* Capstone Disassembly Engine, https://www.capstone-engine.org */
/* By Nguyen Anh Quynh <aquynh@gmail.com>, 2013-2022, */
/*    Rot127 <unisono@quyllur.org> 2022-2023 */
/* Automatically generated file by Capstone's LLVM TableGen Disassembler Backend. */

/* LLVM-commit: 083d57d0731afc1746680d828bdfe2fa41f62a61 */
/* LLVM-tag: llvmorg-3.0.0-2-g083d57d0731a */

/* Do not edit. */

/* Capstone's LLVM TableGen Backends: */
/* https://github.com/capstone-engine/llvm-capstone */

#include <capstone/platform.h>
#include "../../cs_priv.h"

/// getMnemonic - This method is automatically generated by tablegen
/// from the instruction set description.
static MnemonicBitsInfo getMnemonic(MCInst *MI, SStream *O) {
#ifndef CAPSTONE_DIET
  static const char AsmStrs[] = {
  /* 0 */ "; ADJDOWN \0"
  /* 11 */ "; ADJUP \0"
  /* 20 */ "lda \0"
  /* 25 */ "sra \0"
  /* 30 */ "stb \0"
  /* 35 */ "sextb \0"
  /* 42 */ "stl_c \0"
  /* 49 */ "stq_c \0"
  /* 56 */ "blbc \0"
  /* 62 */ "cmovlbc \0"
  /* 71 */ "rpcc \0"
  /* 77 */ "bic \0"
  /* 82 */ "rc \0"
  /* 86 */ "cvttq/svc \0"
  /* 97 */ "and \0"
  /* 102 */ "fbge \0"
  /* 108 */ "cmpbge \0"
  /* 116 */ "fcmovge \0"
  /* 125 */ "fble \0"
  /* 131 */ "cmple \0"
  /* 138 */ "cmpule \0"
  /* 146 */ "fcmovle \0"
  /* 155 */ "fbne \0"
  /* 161 */ "jsr_coroutine \0"
  /* 176 */ "fcmovne \0"
  /* 185 */ "cpyse \0"
  /* 192 */ "ldah \0"
  /* 198 */ "msklh \0"
  /* 205 */ "inslh \0"
  /* 212 */ "extlh \0"
  /* 219 */ "umulh \0"
  /* 226 */ "mskqh \0"
  /* 233 */ "insqh \0"
  /* 240 */ "extqh \0"
  /* 247 */ "mskwh \0"
  /* 254 */ "inswh \0"
  /* 261 */ "extwh \0"
  /* 268 */ "cvtqs/sui \0"
  /* 279 */ "cvtts/sui \0"
  /* 290 */ "cvtqt/sui \0"
  /* 301 */ "ldl_l \0"
  /* 308 */ "ldq_l \0"
  /* 315 */ "mskbl \0"
  /* 322 */ "insbl \0"
  /* 329 */ "extbl \0"
  /* 336 */ "s4subl \0"
  /* 344 */ "s8subl \0"
  /* 352 */ "s4addl \0"
  /* 360 */ "s8addl \0"
  /* 368 */ "ldl \0"
  /* 373 */ "mskll \0"
  /* 380 */ "insll \0"
  /* 387 */ "extll \0"
  /* 394 */ "mull \0"
  /* 400 */ "mskql \0"
  /* 407 */ "insql \0"
  /* 414 */ "extql \0"
  /* 421 */ "srl \0"
  /* 426 */ "stl \0"
  /* 431 */ "mskwl \0"
  /* 438 */ "inswl \0"
  /* 445 */ "extwl \0"
  /* 452 */ "cpysn \0"
  /* 459 */ "ctpop \0"
  /* 466 */ "s4subq \0"
  /* 474 */ "s8subq \0"
  /* 482 */ "s4addq \0"
  /* 490 */ "s8addq \0"
  /* 498 */ "ldq \0"
  /* 503 */ "fbeq \0"
  /* 509 */ "cmpeq \0"
  /* 516 */ "fcmoveq \0"
  /* 525 */ "mulq \0"
  /* 531 */ "stq \0"
  /* 536 */ "xor \0"
  /* 541 */ "cvtst/s \0"
  /* 550 */ "blbs \0"
  /* 556 */ "cmovlbs \0"
  /* 565 */ "lds \0"
  /* 570 */ "itofs \0"
  /* 577 */ "bis \0"
  /* 582 */ "ftois \0"
  /* 589 */ "rs \0"
  /* 593 */ "sts \0"
  /* 598 */ "cpys \0"
  /* 604 */ "ldt \0"
  /* 609 */ "itoft \0"
  /* 616 */ "fbgt \0"
  /* 622 */ "fcmovgt \0"
  /* 631 */ "ftoit \0"
  /* 638 */ "fblt \0"
  /* 644 */ "cmplt \0"
  /* 651 */ "cmpult \0"
  /* 659 */ "fcmovlt \0"
  /* 668 */ "zapnot \0"
  /* 676 */ "ornot \0"
  /* 683 */ "stt \0"
  /* 688 */ "ldq_u \0"
  /* 695 */ "stq_u \0"
  /* 702 */ "ldbu \0"
  /* 708 */ "cmptle/su \0"
  /* 719 */ "cmptun/su \0"
  /* 730 */ "cmpteq/su \0"
  /* 741 */ "subs/su \0"
  /* 750 */ "adds/su \0"
  /* 759 */ "muls/su \0"
  /* 768 */ "sqrts/su \0"
  /* 778 */ "divs/su \0"
  /* 787 */ "subt/su \0"
  /* 796 */ "addt/su \0"
  /* 805 */ "cmptlt/su \0"
  /* 816 */ "mult/su \0"
  /* 825 */ "sqrtt/su \0"
  /* 835 */ "divt/su \0"
  /* 844 */ "ldwu \0"
  /* 850 */ "eqv \0"
  /* 855 */ "stw \0"
  /* 860 */ "sextw \0"
  /* 867 */ "ctlz \0"
  /* 873 */ "cttz \0"
  /* 879 */ "bsr $26,$\0"
  /* 889 */ "LSMARKER$\0"
  /* 899 */ "wh64 (\0"
  /* 906 */ "ecb (\0"
  /* 912 */ "fetch (\0"
  /* 920 */ "fetch_m (\0"
  /* 930 */ "wh64en (\0"
  /* 939 */ "jmp $31,\0"
  /* 948 */ "br $31,\0"
  /* 956 */ "# XRay Function Patchable RET.\0"
  /* 987 */ "# XRay Typed Event Log.\0"
  /* 1011 */ "# XRay Custom Event Log.\0"
  /* 1036 */ "# XRay Function Enter.\0"
  /* 1059 */ "# XRay Tail Call Exit.\0"
  /* 1082 */ "# XRay Function Exit.\0"
  /* 1104 */ "jsr $23,($27),0\0"
  /* 1120 */ "jsr $26,($27),0\0"
  /* 1136 */ "ret $31,($26),1\0"
  /* 1152 */ "COND_BRANCH imm:\0"
  /* 1169 */ "LIFETIME_END\0"
  /* 1182 */ "PSEUDO_PROBE\0"
  /* 1195 */ "BUNDLE\0"
  /* 1202 */ "DBG_VALUE\0"
  /* 1212 */ "DBG_INSTR_REF\0"
  /* 1226 */ "DBG_PHI\0"
  /* 1234 */ "DBG_LABEL\0"
  /* 1244 */ "LIFETIME_START\0"
  /* 1259 */ "DBG_VALUE_LIST\0"
  /* 1274 */ "PCMARKER_\0"
  /* 1284 */ "excb\0"
  /* 1289 */ "wmb\0"
  /* 1293 */ "trapb\0"
  /* 1299 */ "#wtf\0"
  /* 1304 */ "# FEntry call\0"
};
#endif // CAPSTONE_DIET

  static const uint16_t OpInfo0[] = {
    0U,	// PHI
    0U,	// INLINEASM
    0U,	// INLINEASM_BR
    0U,	// CFI_INSTRUCTION
    0U,	// EH_LABEL
    0U,	// GC_LABEL
    0U,	// ANNOTATION_LABEL
    0U,	// KILL
    0U,	// EXTRACT_SUBREG
    0U,	// INSERT_SUBREG
    0U,	// IMPLICIT_DEF
    0U,	// SUBREG_TO_REG
    0U,	// COPY_TO_REGCLASS
    1203U,	// DBG_VALUE
    1260U,	// DBG_VALUE_LIST
    1213U,	// DBG_INSTR_REF
    1227U,	// DBG_PHI
    1235U,	// DBG_LABEL
    0U,	// REG_SEQUENCE
    0U,	// COPY
    1196U,	// BUNDLE
    1245U,	// LIFETIME_START
    1170U,	// LIFETIME_END
    1183U,	// PSEUDO_PROBE
    0U,	// ARITH_FENCE
    0U,	// STACKMAP
    1305U,	// FENTRY_CALL
    0U,	// PATCHPOINT
    0U,	// LOAD_STACK_GUARD
    0U,	// PREALLOCATED_SETUP
    0U,	// PREALLOCATED_ARG
    0U,	// STATEPOINT
    0U,	// LOCAL_ESCAPE
    0U,	// FAULTING_OP
    0U,	// PATCHABLE_OP
    1037U,	// PATCHABLE_FUNCTION_ENTER
    957U,	// PATCHABLE_RET
    1083U,	// PATCHABLE_FUNCTION_EXIT
    1060U,	// PATCHABLE_TAIL_CALL
    1012U,	// PATCHABLE_EVENT_CALL
    988U,	// PATCHABLE_TYPED_EVENT_CALL
    0U,	// ICALL_BRANCH_FUNNEL
    0U,	// MEMBARRIER
    0U,	// G_ASSERT_SEXT
    0U,	// G_ASSERT_ZEXT
    0U,	// G_ASSERT_ALIGN
    0U,	// G_ADD
    0U,	// G_SUB
    0U,	// G_MUL
    0U,	// G_SDIV
    0U,	// G_UDIV
    0U,	// G_SREM
    0U,	// G_UREM
    0U,	// G_SDIVREM
    0U,	// G_UDIVREM
    0U,	// G_AND
    0U,	// G_OR
    0U,	// G_XOR
    0U,	// G_IMPLICIT_DEF
    0U,	// G_PHI
    0U,	// G_FRAME_INDEX
    0U,	// G_GLOBAL_VALUE
    0U,	// G_EXTRACT
    0U,	// G_UNMERGE_VALUES
    0U,	// G_INSERT
    0U,	// G_MERGE_VALUES
    0U,	// G_BUILD_VECTOR
    0U,	// G_BUILD_VECTOR_TRUNC
    0U,	// G_CONCAT_VECTORS
    0U,	// G_PTRTOINT
    0U,	// G_INTTOPTR
    0U,	// G_BITCAST
    0U,	// G_FREEZE
    0U,	// G_INTRINSIC_FPTRUNC_ROUND
    0U,	// G_INTRINSIC_TRUNC
    0U,	// G_INTRINSIC_ROUND
    0U,	// G_INTRINSIC_LRINT
    0U,	// G_INTRINSIC_ROUNDEVEN
    0U,	// G_READCYCLECOUNTER
    0U,	// G_LOAD
    0U,	// G_SEXTLOAD
    0U,	// G_ZEXTLOAD
    0U,	// G_INDEXED_LOAD
    0U,	// G_INDEXED_SEXTLOAD
    0U,	// G_INDEXED_ZEXTLOAD
    0U,	// G_STORE
    0U,	// G_INDEXED_STORE
    0U,	// G_ATOMIC_CMPXCHG_WITH_SUCCESS
    0U,	// G_ATOMIC_CMPXCHG
    0U,	// G_ATOMICRMW_XCHG
    0U,	// G_ATOMICRMW_ADD
    0U,	// G_ATOMICRMW_SUB
    0U,	// G_ATOMICRMW_AND
    0U,	// G_ATOMICRMW_NAND
    0U,	// G_ATOMICRMW_OR
    0U,	// G_ATOMICRMW_XOR
    0U,	// G_ATOMICRMW_MAX
    0U,	// G_ATOMICRMW_MIN
    0U,	// G_ATOMICRMW_UMAX
    0U,	// G_ATOMICRMW_UMIN
    0U,	// G_ATOMICRMW_FADD
    0U,	// G_ATOMICRMW_FSUB
    0U,	// G_ATOMICRMW_FMAX
    0U,	// G_ATOMICRMW_FMIN
    0U,	// G_ATOMICRMW_UINC_WRAP
    0U,	// G_ATOMICRMW_UDEC_WRAP
    0U,	// G_FENCE
    0U,	// G_BRCOND
    0U,	// G_BRINDIRECT
    0U,	// G_INVOKE_REGION_START
    0U,	// G_INTRINSIC
    0U,	// G_INTRINSIC_W_SIDE_EFFECTS
    0U,	// G_ANYEXT
    0U,	// G_TRUNC
    0U,	// G_CONSTANT
    0U,	// G_FCONSTANT
    0U,	// G_VASTART
    0U,	// G_VAARG
    0U,	// G_SEXT
    0U,	// G_SEXT_INREG
    0U,	// G_ZEXT
    0U,	// G_SHL
    0U,	// G_LSHR
    0U,	// G_ASHR
    0U,	// G_FSHL
    0U,	// G_FSHR
    0U,	// G_ROTR
    0U,	// G_ROTL
    0U,	// G_ICMP
    0U,	// G_FCMP
    0U,	// G_SELECT
    0U,	// G_UADDO
    0U,	// G_UADDE
    0U,	// G_USUBO
    0U,	// G_USUBE
    0U,	// G_SADDO
    0U,	// G_SADDE
    0U,	// G_SSUBO
    0U,	// G_SSUBE
    0U,	// G_UMULO
    0U,	// G_SMULO
    0U,	// G_UMULH
    0U,	// G_SMULH
    0U,	// G_UADDSAT
    0U,	// G_SADDSAT
    0U,	// G_USUBSAT
    0U,	// G_SSUBSAT
    0U,	// G_USHLSAT
    0U,	// G_SSHLSAT
    0U,	// G_SMULFIX
    0U,	// G_UMULFIX
    0U,	// G_SMULFIXSAT
    0U,	// G_UMULFIXSAT
    0U,	// G_SDIVFIX
    0U,	// G_UDIVFIX
    0U,	// G_SDIVFIXSAT
    0U,	// G_UDIVFIXSAT
    0U,	// G_FADD
    0U,	// G_FSUB
    0U,	// G_FMUL
    0U,	// G_FMA
    0U,	// G_FMAD
    0U,	// G_FDIV
    0U,	// G_FREM
    0U,	// G_FPOW
    0U,	// G_FPOWI
    0U,	// G_FEXP
    0U,	// G_FEXP2
    0U,	// G_FLOG
    0U,	// G_FLOG2
    0U,	// G_FLOG10
    0U,	// G_FNEG
    0U,	// G_FPEXT
    0U,	// G_FPTRUNC
    0U,	// G_FPTOSI
    0U,	// G_FPTOUI
    0U,	// G_SITOFP
    0U,	// G_UITOFP
    0U,	// G_FABS
    0U,	// G_FCOPYSIGN
    0U,	// G_IS_FPCLASS
    0U,	// G_FCANONICALIZE
    0U,	// G_FMINNUM
    0U,	// G_FMAXNUM
    0U,	// G_FMINNUM_IEEE
    0U,	// G_FMAXNUM_IEEE
    0U,	// G_FMINIMUM
    0U,	// G_FMAXIMUM
    0U,	// G_PTR_ADD
    0U,	// G_PTRMASK
    0U,	// G_SMIN
    0U,	// G_SMAX
    0U,	// G_UMIN
    0U,	// G_UMAX
    0U,	// G_ABS
    0U,	// G_LROUND
    0U,	// G_LLROUND
    0U,	// G_BR
    0U,	// G_BRJT
    0U,	// G_INSERT_VECTOR_ELT
    0U,	// G_EXTRACT_VECTOR_ELT
    0U,	// G_SHUFFLE_VECTOR
    0U,	// G_CTTZ
    0U,	// G_CTTZ_ZERO_UNDEF
    0U,	// G_CTLZ
    0U,	// G_CTLZ_ZERO_UNDEF
    0U,	// G_CTPOP
    0U,	// G_BSWAP
    0U,	// G_BITREVERSE
    0U,	// G_FCEIL
    0U,	// G_FCOS
    0U,	// G_FSIN
    0U,	// G_FSQRT
    0U,	// G_FFLOOR
    0U,	// G_FRINT
    0U,	// G_FNEARBYINT
    0U,	// G_ADDRSPACE_CAST
    0U,	// G_BLOCK_ADDR
    0U,	// G_JUMP_TABLE
    0U,	// G_DYN_STACKALLOC
    0U,	// G_STRICT_FADD
    0U,	// G_STRICT_FSUB
    0U,	// G_STRICT_FMUL
    0U,	// G_STRICT_FDIV
    0U,	// G_STRICT_FREM
    0U,	// G_STRICT_FMA
    0U,	// G_STRICT_FSQRT
    0U,	// G_READ_REGISTER
    0U,	// G_WRITE_REGISTER
    0U,	// G_MEMCPY
    0U,	// G_MEMCPY_INLINE
    0U,	// G_MEMMOVE
    0U,	// G_MEMSET
    0U,	// G_BZERO
    0U,	// G_VECREDUCE_SEQ_FADD
    0U,	// G_VECREDUCE_SEQ_FMUL
    0U,	// G_VECREDUCE_FADD
    0U,	// G_VECREDUCE_FMUL
    0U,	// G_VECREDUCE_FMAX
    0U,	// G_VECREDUCE_FMIN
    0U,	// G_VECREDUCE_ADD
    0U,	// G_VECREDUCE_MUL
    0U,	// G_VECREDUCE_AND
    0U,	// G_VECREDUCE_OR
    0U,	// G_VECREDUCE_XOR
    0U,	// G_VECREDUCE_SMAX
    0U,	// G_VECREDUCE_SMIN
    0U,	// G_VECREDUCE_UMAX
    0U,	// G_VECREDUCE_UMIN
    0U,	// G_SBFX
    0U,	// G_UBFX
    2049U,	// ADJUSTSTACKDOWN
    2060U,	// ADJUSTSTACKUP
    19320U,	// ALTENT
    0U,	// CAS32
    0U,	// CAS64
    0U,	// LAS32
    0U,	// LAS64
    35706U,	// MEMLABEL
    52475U,	// PCLABEL
    0U,	// SWAP32
    0U,	// SWAP64
    1300U,	// WTF
    4451U,	// ADDLi
    4451U,	// ADDLr
    4581U,	// ADDQi
    4581U,	// ADDQr
    4847U,	// ADDS
    4893U,	// ADDT
    4194U,	// ANDi
    4194U,	// ANDr
    2553U,	// BEQ
    2152U,	// BGE
    2666U,	// BGT
    4174U,	// BICi
    4174U,	// BICr
    4674U,	// BISi
    4674U,	// BISr
    2105U,	// BLBC
    2599U,	// BLBS
    2175U,	// BLE
    2688U,	// BLT
    2205U,	// BNE
    7093U,	// BR
    23408U,	// BSR
    4614U,	// CMOVEQi
    4614U,	// CMOVEQr
    4214U,	// CMOVGEi
    4214U,	// CMOVGEr
    4720U,	// CMOVGTi
    4720U,	// CMOVGTr
    4159U,	// CMOVLBCi
    4159U,	// CMOVLBCr
    4653U,	// CMOVLBSi
    4653U,	// CMOVLBSr
    4244U,	// CMOVLEi
    4244U,	// CMOVLEr
    4757U,	// CMOVLTi
    4757U,	// CMOVLTr
    4274U,	// CMOVNEi
    4274U,	// CMOVNEr
    4205U,	// CMPBGE
    4205U,	// CMPBGEi
    4606U,	// CMPEQ
    4606U,	// CMPEQi
    4228U,	// CMPLE
    4228U,	// CMPLEi
    4741U,	// CMPLT
    4741U,	// CMPLTi
    4827U,	// CMPTEQ
    4805U,	// CMPTLE
    4902U,	// CMPTLT
    4816U,	// CMPTUN
    4235U,	// CMPULE
    4235U,	// CMPULEi
    4748U,	// CMPULT
    4748U,	// CMPULTi
    35969U,	// COND_BRANCH_F
    52353U,	// COND_BRANCH_I
    4282U,	// CPYSES
    4282U,	// CPYSESt
    4282U,	// CPYSET
    4549U,	// CPYSNS
    4549U,	// CPYSNSt
    4549U,	// CPYSNT
    4549U,	// CPYSNTs
    4695U,	// CPYSS
    4695U,	// CPYSSt
    4695U,	// CPYST
    4695U,	// CPYSTs
    4964U,	// CTLZ
    4556U,	// CTPOP
    4970U,	// CTTZ
    4365U,	// CVTQS
    4387U,	// CVTQT
    4638U,	// CVTST
    4183U,	// CVTTQ
    4376U,	// CVTTS
    4875U,	// DIVS
    4932U,	// DIVT
    5003U,	// ECB
    4947U,	// EQVi
    4947U,	// EQVr
    1285U,	// EXCB
    4426U,	// EXTBL
    4426U,	// EXTBLi
    4309U,	// EXTLH
    4309U,	// EXTLHi
    4484U,	// EXTLL
    4484U,	// EXTLLi
    4337U,	// EXTQH
    4337U,	// EXTQHi
    4511U,	// EXTQL
    4511U,	// EXTQLi
    4358U,	// EXTWH
    4358U,	// EXTWHi
    4542U,	// EXTWL
    4542U,	// EXTWLi
    2552U,	// FBEQ
    2151U,	// FBGE
    2665U,	// FBGT
    2174U,	// FBLE
    2687U,	// FBLT
    2204U,	// FBNE
    8709U,	// FCMOVEQS
    8709U,	// FCMOVEQT
    8309U,	// FCMOVGES
    8309U,	// FCMOVGET
    8815U,	// FCMOVGTS
    8815U,	// FCMOVGTT
    8339U,	// FCMOVLES
    8339U,	// FCMOVLET
    8852U,	// FCMOVLTS
    8852U,	// FCMOVLTT
    8369U,	// FCMOVNES
    8369U,	// FCMOVNET
    5009U,	// FETCH
    5017U,	// FETCH_M
    4679U,	// FTOIS
    4728U,	// FTOIT
    4419U,	// INSBL
    4419U,	// INSBLi
    4302U,	// INSLH
    4302U,	// INSLHi
    4477U,	// INSLL
    4477U,	// INSLLi
    4330U,	// INSQH
    4330U,	// INSQHi
    4504U,	// INSQL
    4504U,	// INSQLi
    4351U,	// INSWH
    4351U,	// INSWHi
    4535U,	// INSWL
    4535U,	// INSWLi
    4667U,	// ITOFS
    4706U,	// ITOFT
    19372U,	// JMP
    1121U,	// JSR
    34978U,	// JSR_COROUTINE
    1105U,	// JSRs
    2069U,	// LDA
    2241U,	// LDAH
    51393U,	// LDAHg
    2241U,	// LDAHr
    51221U,	// LDAg
    2069U,	// LDAr
    2751U,	// LDBU
    2751U,	// LDBUr
    2417U,	// LDL
    2350U,	// LDL_L
    2417U,	// LDLr
    2547U,	// LDQ
    2357U,	// LDQ_L
    2737U,	// LDQ_U
    2547U,	// LDQl
    2547U,	// LDQr
    2614U,	// LDS
    2614U,	// LDSr
    2653U,	// LDT
    2653U,	// LDTr
    2893U,	// LDWU
    2893U,	// LDWUr
    1291U,	// MB
    4412U,	// MSKBL
    4412U,	// MSKBLi
    4295U,	// MSKLH
    4295U,	// MSKLHi
    4470U,	// MSKLL
    4470U,	// MSKLLi
    4323U,	// MSKQH
    4323U,	// MSKQHi
    4497U,	// MSKQL
    4497U,	// MSKQLi
    4344U,	// MSKWH
    4344U,	// MSKWHi
    4528U,	// MSKWL
    4528U,	// MSKWLi
    4491U,	// MULLi
    4491U,	// MULLr
    4622U,	// MULQi
    4622U,	// MULQr
    4856U,	// MULS
    4913U,	// MULT
    4773U,	// ORNOTi
    4773U,	// ORNOTr
    2131U,	// RC
    1137U,	// RETDAG
    1137U,	// RETDAGp
    2120U,	// RPCC
    2638U,	// RS
    4449U,	// S4ADDLi
    4449U,	// S4ADDLr
    4579U,	// S4ADDQi
    4579U,	// S4ADDQr
    4433U,	// S4SUBLi
    4433U,	// S4SUBLr
    4563U,	// S4SUBQi
    4563U,	// S4SUBQr
    4457U,	// S8ADDLi
    4457U,	// S8ADDLr
    4587U,	// S8ADDQi
    4587U,	// S8ADDQr
    4441U,	// S8SUBLi
    4441U,	// S8SUBLr
    4571U,	// S8SUBQi
    4571U,	// S8SUBQr
    4132U,	// SEXTB
    4957U,	// SEXTW
    4479U,	// SLi
    4479U,	// SLr
    4865U,	// SQRTS
    4922U,	// SQRTT
    4122U,	// SRAi
    4122U,	// SRAr
    4518U,	// SRLi
    4518U,	// SRLr
    2079U,	// STB
    2079U,	// STBr
    2475U,	// STL
    4139U,	// STL_C
    2475U,	// STLr
    2580U,	// STQ
    4146U,	// STQ_C
    2744U,	// STQ_U
    2580U,	// STQr
    2642U,	// STS
    2642U,	// STSr
    2732U,	// STT
    2732U,	// STTr
    2904U,	// STW
    2904U,	// STWr
    4435U,	// SUBLi
    4435U,	// SUBLr
    4565U,	// SUBQi
    4565U,	// SUBQr
    4838U,	// SUBS
    4884U,	// SUBT
    1294U,	// TRAPB
    4316U,	// UMULHi
    4316U,	// UMULHr
    4996U,	// WH64
    5027U,	// WH64EN
    1290U,	// WMB
    4633U,	// XORi
    4633U,	// XORr
    4765U,	// ZAPNOTi
  };

  static const uint8_t OpInfo1[] = {
    0U,	// PHI
    0U,	// INLINEASM
    0U,	// INLINEASM_BR
    0U,	// CFI_INSTRUCTION
    0U,	// EH_LABEL
    0U,	// GC_LABEL
    0U,	// ANNOTATION_LABEL
    0U,	// KILL
    0U,	// EXTRACT_SUBREG
    0U,	// INSERT_SUBREG
    0U,	// IMPLICIT_DEF
    0U,	// SUBREG_TO_REG
    0U,	// COPY_TO_REGCLASS
    0U,	// DBG_VALUE
    0U,	// DBG_VALUE_LIST
    0U,	// DBG_INSTR_REF
    0U,	// DBG_PHI
    0U,	// DBG_LABEL
    0U,	// REG_SEQUENCE
    0U,	// COPY
    0U,	// BUNDLE
    0U,	// LIFETIME_START
    0U,	// LIFETIME_END
    0U,	// PSEUDO_PROBE
    0U,	// ARITH_FENCE
    0U,	// STACKMAP
    0U,	// FENTRY_CALL
    0U,	// PATCHPOINT
    0U,	// LOAD_STACK_GUARD
    0U,	// PREALLOCATED_SETUP
    0U,	// PREALLOCATED_ARG
    0U,	// STATEPOINT
    0U,	// LOCAL_ESCAPE
    0U,	// FAULTING_OP
    0U,	// PATCHABLE_OP
    0U,	// PATCHABLE_FUNCTION_ENTER
    0U,	// PATCHABLE_RET
    0U,	// PATCHABLE_FUNCTION_EXIT
    0U,	// PATCHABLE_TAIL_CALL
    0U,	// PATCHABLE_EVENT_CALL
    0U,	// PATCHABLE_TYPED_EVENT_CALL
    0U,	// ICALL_BRANCH_FUNNEL
    0U,	// MEMBARRIER
    0U,	// G_ASSERT_SEXT
    0U,	// G_ASSERT_ZEXT
    0U,	// G_ASSERT_ALIGN
    0U,	// G_ADD
    0U,	// G_SUB
    0U,	// G_MUL
    0U,	// G_SDIV
    0U,	// G_UDIV
    0U,	// G_SREM
    0U,	// G_UREM
    0U,	// G_SDIVREM
    0U,	// G_UDIVREM
    0U,	// G_AND
    0U,	// G_OR
    0U,	// G_XOR
    0U,	// G_IMPLICIT_DEF
    0U,	// G_PHI
    0U,	// G_FRAME_INDEX
    0U,	// G_GLOBAL_VALUE
    0U,	// G_EXTRACT
    0U,	// G_UNMERGE_VALUES
    0U,	// G_INSERT
    0U,	// G_MERGE_VALUES
    0U,	// G_BUILD_VECTOR
    0U,	// G_BUILD_VECTOR_TRUNC
    0U,	// G_CONCAT_VECTORS
    0U,	// G_PTRTOINT
    0U,	// G_INTTOPTR
    0U,	// G_BITCAST
    0U,	// G_FREEZE
    0U,	// G_INTRINSIC_FPTRUNC_ROUND
    0U,	// G_INTRINSIC_TRUNC
    0U,	// G_INTRINSIC_ROUND
    0U,	// G_INTRINSIC_LRINT
    0U,	// G_INTRINSIC_ROUNDEVEN
    0U,	// G_READCYCLECOUNTER
    0U,	// G_LOAD
    0U,	// G_SEXTLOAD
    0U,	// G_ZEXTLOAD
    0U,	// G_INDEXED_LOAD
    0U,	// G_INDEXED_SEXTLOAD
    0U,	// G_INDEXED_ZEXTLOAD
    0U,	// G_STORE
    0U,	// G_INDEXED_STORE
    0U,	// G_ATOMIC_CMPXCHG_WITH_SUCCESS
    0U,	// G_ATOMIC_CMPXCHG
    0U,	// G_ATOMICRMW_XCHG
    0U,	// G_ATOMICRMW_ADD
    0U,	// G_ATOMICRMW_SUB
    0U,	// G_ATOMICRMW_AND
    0U,	// G_ATOMICRMW_NAND
    0U,	// G_ATOMICRMW_OR
    0U,	// G_ATOMICRMW_XOR
    0U,	// G_ATOMICRMW_MAX
    0U,	// G_ATOMICRMW_MIN
    0U,	// G_ATOMICRMW_UMAX
    0U,	// G_ATOMICRMW_UMIN
    0U,	// G_ATOMICRMW_FADD
    0U,	// G_ATOMICRMW_FSUB
    0U,	// G_ATOMICRMW_FMAX
    0U,	// G_ATOMICRMW_FMIN
    0U,	// G_ATOMICRMW_UINC_WRAP
    0U,	// G_ATOMICRMW_UDEC_WRAP
    0U,	// G_FENCE
    0U,	// G_BRCOND
    0U,	// G_BRINDIRECT
    0U,	// G_INVOKE_REGION_START
    0U,	// G_INTRINSIC
    0U,	// G_INTRINSIC_W_SIDE_EFFECTS
    0U,	// G_ANYEXT
    0U,	// G_TRUNC
    0U,	// G_CONSTANT
    0U,	// G_FCONSTANT
    0U,	// G_VASTART
    0U,	// G_VAARG
    0U,	// G_SEXT
    0U,	// G_SEXT_INREG
    0U,	// G_ZEXT
    0U,	// G_SHL
    0U,	// G_LSHR
    0U,	// G_ASHR
    0U,	// G_FSHL
    0U,	// G_FSHR
    0U,	// G_ROTR
    0U,	// G_ROTL
    0U,	// G_ICMP
    0U,	// G_FCMP
    0U,	// G_SELECT
    0U,	// G_UADDO
    0U,	// G_UADDE
    0U,	// G_USUBO
    0U,	// G_USUBE
    0U,	// G_SADDO
    0U,	// G_SADDE
    0U,	// G_SSUBO
    0U,	// G_SSUBE
    0U,	// G_UMULO
    0U,	// G_SMULO
    0U,	// G_UMULH
    0U,	// G_SMULH
    0U,	// G_UADDSAT
    0U,	// G_SADDSAT
    0U,	// G_USUBSAT
    0U,	// G_SSUBSAT
    0U,	// G_USHLSAT
    0U,	// G_SSHLSAT
    0U,	// G_SMULFIX
    0U,	// G_UMULFIX
    0U,	// G_SMULFIXSAT
    0U,	// G_UMULFIXSAT
    0U,	// G_SDIVFIX
    0U,	// G_UDIVFIX
    0U,	// G_SDIVFIXSAT
    0U,	// G_UDIVFIXSAT
    0U,	// G_FADD
    0U,	// G_FSUB
    0U,	// G_FMUL
    0U,	// G_FMA
    0U,	// G_FMAD
    0U,	// G_FDIV
    0U,	// G_FREM
    0U,	// G_FPOW
    0U,	// G_FPOWI
    0U,	// G_FEXP
    0U,	// G_FEXP2
    0U,	// G_FLOG
    0U,	// G_FLOG2
    0U,	// G_FLOG10
    0U,	// G_FNEG
    0U,	// G_FPEXT
    0U,	// G_FPTRUNC
    0U,	// G_FPTOSI
    0U,	// G_FPTOUI
    0U,	// G_SITOFP
    0U,	// G_UITOFP
    0U,	// G_FABS
    0U,	// G_FCOPYSIGN
    0U,	// G_IS_FPCLASS
    0U,	// G_FCANONICALIZE
    0U,	// G_FMINNUM
    0U,	// G_FMAXNUM
    0U,	// G_FMINNUM_IEEE
    0U,	// G_FMAXNUM_IEEE
    0U,	// G_FMINIMUM
    0U,	// G_FMAXIMUM
    0U,	// G_PTR_ADD
    0U,	// G_PTRMASK
    0U,	// G_SMIN
    0U,	// G_SMAX
    0U,	// G_UMIN
    0U,	// G_UMAX
    0U,	// G_ABS
    0U,	// G_LROUND
    0U,	// G_LLROUND
    0U,	// G_BR
    0U,	// G_BRJT
    0U,	// G_INSERT_VECTOR_ELT
    0U,	// G_EXTRACT_VECTOR_ELT
    0U,	// G_SHUFFLE_VECTOR
    0U,	// G_CTTZ
    0U,	// G_CTTZ_ZERO_UNDEF
    0U,	// G_CTLZ
    0U,	// G_CTLZ_ZERO_UNDEF
    0U,	// G_CTPOP
    0U,	// G_BSWAP
    0U,	// G_BITREVERSE
    0U,	// G_FCEIL
    0U,	// G_FCOS
    0U,	// G_FSIN
    0U,	// G_FSQRT
    0U,	// G_FFLOOR
    0U,	// G_FRINT
    0U,	// G_FNEARBYINT
    0U,	// G_ADDRSPACE_CAST
    0U,	// G_BLOCK_ADDR
    0U,	// G_JUMP_TABLE
    0U,	// G_DYN_STACKALLOC
    0U,	// G_STRICT_FADD
    0U,	// G_STRICT_FSUB
    0U,	// G_STRICT_FMUL
    0U,	// G_STRICT_FDIV
    0U,	// G_STRICT_FREM
    0U,	// G_STRICT_FMA
    0U,	// G_STRICT_FSQRT
    0U,	// G_READ_REGISTER
    0U,	// G_WRITE_REGISTER
    0U,	// G_MEMCPY
    0U,	// G_MEMCPY_INLINE
    0U,	// G_MEMMOVE
    0U,	// G_MEMSET
    0U,	// G_BZERO
    0U,	// G_VECREDUCE_SEQ_FADD
    0U,	// G_VECREDUCE_SEQ_FMUL
    0U,	// G_VECREDUCE_FADD
    0U,	// G_VECREDUCE_FMUL
    0U,	// G_VECREDUCE_FMAX
    0U,	// G_VECREDUCE_FMIN
    0U,	// G_VECREDUCE_ADD
    0U,	// G_VECREDUCE_MUL
    0U,	// G_VECREDUCE_AND
    0U,	// G_VECREDUCE_OR
    0U,	// G_VECREDUCE_XOR
    0U,	// G_VECREDUCE_SMAX
    0U,	// G_VECREDUCE_SMIN
    0U,	// G_VECREDUCE_UMAX
    0U,	// G_VECREDUCE_UMIN
    0U,	// G_SBFX
    0U,	// G_UBFX
    0U,	// ADJUSTSTACKDOWN
    0U,	// ADJUSTSTACKUP
    0U,	// ALTENT
    0U,	// CAS32
    0U,	// CAS64
    0U,	// LAS32
    0U,	// LAS64
    0U,	// MEMLABEL
    0U,	// PCLABEL
    0U,	// SWAP32
    0U,	// SWAP64
    0U,	// WTF
    1U,	// ADDLi
    1U,	// ADDLr
    1U,	// ADDQi
    1U,	// ADDQr
    1U,	// ADDS
    1U,	// ADDT
    1U,	// ANDi
    1U,	// ANDr
    5U,	// BEQ
    5U,	// BGE
    5U,	// BGT
    1U,	// BICi
    1U,	// BICr
    1U,	// BISi
    1U,	// BISr
    5U,	// BLBC
    5U,	// BLBS
    5U,	// BLE
    5U,	// BLT
    5U,	// BNE
    0U,	// BR
    1U,	// BSR
    1U,	// CMOVEQi
    1U,	// CMOVEQr
    1U,	// CMOVGEi
    1U,	// CMOVGEr
    1U,	// CMOVGTi
    1U,	// CMOVGTr
    1U,	// CMOVLBCi
    1U,	// CMOVLBCr
    1U,	// CMOVLBSi
    1U,	// CMOVLBSr
    1U,	// CMOVLEi
    1U,	// CMOVLEr
    1U,	// CMOVLTi
    1U,	// CMOVLTr
    1U,	// CMOVNEi
    1U,	// CMOVNEr
    1U,	// CMPBGE
    1U,	// CMPBGEi
    1U,	// CMPEQ
    1U,	// CMPEQi
    1U,	// CMPLE
    1U,	// CMPLEi
    1U,	// CMPLT
    1U,	// CMPLTi
    1U,	// CMPTEQ
    1U,	// CMPTLE
    1U,	// CMPTLT
    1U,	// CMPTUN
    1U,	// CMPULE
    1U,	// CMPULEi
    1U,	// CMPULT
    1U,	// CMPULTi
    1U,	// COND_BRANCH_F
    1U,	// COND_BRANCH_I
    1U,	// CPYSES
    1U,	// CPYSESt
    1U,	// CPYSET
    1U,	// CPYSNS
    1U,	// CPYSNSt
    1U,	// CPYSNT
    1U,	// CPYSNTs
    1U,	// CPYSS
    1U,	// CPYSSt
    1U,	// CPYST
    1U,	// CPYSTs
    9U,	// CTLZ
    9U,	// CTPOP
    9U,	// CTTZ
    9U,	// CVTQS
    9U,	// CVTQT
    9U,	// CVTST
    9U,	// CVTTQ
    9U,	// CVTTS
    1U,	// DIVS
    1U,	// DIVT
    2U,	// ECB
    1U,	// EQVi
    1U,	// EQVr
    0U,	// EXCB
    1U,	// EXTBL
    1U,	// EXTBLi
    1U,	// EXTLH
    1U,	// EXTLHi
    1U,	// EXTLL
    1U,	// EXTLLi
    1U,	// EXTQH
    1U,	// EXTQHi
    1U,	// EXTQL
    1U,	// EXTQLi
    1U,	// EXTWH
    1U,	// EXTWHi
    1U,	// EXTWL
    1U,	// EXTWLi
    5U,	// FBEQ
    5U,	// FBGE
    5U,	// FBGT
    5U,	// FBLE
    5U,	// FBLT
    5U,	// FBNE
    0U,	// FCMOVEQS
    0U,	// FCMOVEQT
    0U,	// FCMOVGES
    0U,	// FCMOVGET
    0U,	// FCMOVGTS
    0U,	// FCMOVGTT
    0U,	// FCMOVLES
    0U,	// FCMOVLET
    0U,	// FCMOVLTS
    0U,	// FCMOVLTT
    0U,	// FCMOVNES
    0U,	// FCMOVNET
    2U,	// FETCH
    2U,	// FETCH_M
    9U,	// FTOIS
    9U,	// FTOIT
    1U,	// INSBL
    1U,	// INSBLi
    1U,	// INSLH
    1U,	// INSLHi
    1U,	// INSLL
    1U,	// INSLLi
    1U,	// INSQH
    1U,	// INSQHi
    1U,	// INSQL
    1U,	// INSQLi
    1U,	// INSWH
    1U,	// INSWHi
    1U,	// INSWL
    1U,	// INSWLi
    9U,	// ITOFS
    9U,	// ITOFT
    2U,	// JMP
    0U,	// JSR
    2U,	// JSR_COROUTINE
    0U,	// JSRs
    29U,	// LDA
    29U,	// LDAH
    2U,	// LDAHg
    45U,	// LDAHr
    2U,	// LDAg
    61U,	// LDAr
    29U,	// LDBU
    61U,	// LDBUr
    29U,	// LDL
    29U,	// LDL_L
    61U,	// LDLr
    29U,	// LDQ
    29U,	// LDQ_L
    29U,	// LDQ_U
    77U,	// LDQl
    61U,	// LDQr
    29U,	// LDS
    61U,	// LDSr
    29U,	// LDT
    61U,	// LDTr
    29U,	// LDWU
    61U,	// LDWUr
    0U,	// MB
    1U,	// MSKBL
    1U,	// MSKBLi
    1U,	// MSKLH
    1U,	// MSKLHi
    1U,	// MSKLL
    1U,	// MSKLLi
    1U,	// MSKQH
    1U,	// MSKQHi
    1U,	// MSKQL
    1U,	// MSKQLi
    1U,	// MSKWH
    1U,	// MSKWHi
    1U,	// MSKWL
    1U,	// MSKWLi
    1U,	// MULLi
    1U,	// MULLr
    1U,	// MULQi
    1U,	// MULQr
    1U,	// MULS
    1U,	// MULT
    1U,	// ORNOTi
    1U,	// ORNOTr
    0U,	// RC
    0U,	// RETDAG
    0U,	// RETDAGp
    0U,	// RPCC
    0U,	// RS
    1U,	// S4ADDLi
    1U,	// S4ADDLr
    1U,	// S4ADDQi
    1U,	// S4ADDQr
    1U,	// S4SUBLi
    1U,	// S4SUBLr
    1U,	// S4SUBQi
    1U,	// S4SUBQr
    1U,	// S8ADDLi
    1U,	// S8ADDLr
    1U,	// S8ADDQi
    1U,	// S8ADDQr
    1U,	// S8SUBLi
    1U,	// S8SUBLr
    1U,	// S8SUBQi
    1U,	// S8SUBQr
    9U,	// SEXTB
    9U,	// SEXTW
    1U,	// SLi
    1U,	// SLr
    9U,	// SQRTS
    9U,	// SQRTT
    1U,	// SRAi
    1U,	// SRAr
    1U,	// SRLi
    1U,	// SRLr
    3U,	// STB
    61U,	// STBr
    29U,	// STL
    81U,	// STL_C
    61U,	// STLr
    29U,	// STQ
    81U,	// STQ_C
    3U,	// STQ_U
    61U,	// STQr
    29U,	// STS
    61U,	// STSr
    29U,	// STT
    61U,	// STTr
    29U,	// STW
    61U,	// STWr
    1U,	// SUBLi
    1U,	// SUBLr
    1U,	// SUBQi
    1U,	// SUBQr
    1U,	// SUBS
    1U,	// SUBT
    0U,	// TRAPB
    1U,	// UMULHi
    1U,	// UMULHr
    2U,	// WH64
    2U,	// WH64EN
    0U,	// WMB
    1U,	// XORi
    1U,	// XORr
    1U,	// ZAPNOTi
  };

  // Emit the opcode for the instruction.
  uint32_t Bits = 0;
  Bits |= OpInfo0[MCInst_getOpcode(MI)] << 0;
  Bits |= OpInfo1[MCInst_getOpcode(MI)] << 16;
  MnemonicBitsInfo MBI = {
#ifndef CAPSTONE_DIET
    AsmStrs+(Bits & 2047)-1,
#else
    NULL,
#endif // CAPSTONE_DIET
    Bits
  };
  return MBI;
}

/// printInstruction - This method is automatically generated by tablegen
/// from the instruction set description.
static void printInstruction(MCInst *MI, uint64_t Address, SStream *O) {
  SStream_concat0(O, "");
  MnemonicBitsInfo MnemonicInfo = getMnemonic(MI, O);

  SStream_concat0(O, MnemonicInfo.first);

  uint32_t Bits = MnemonicInfo.second;
  CS_ASSERT_RET(Bits != 0 && "Cannot print this instruction.");

  // Fragment 0 encoded into 3 bits for 5 unique commands.
  switch ((Bits >> 11) & 7) {
  default: CS_ASSERT_RET(0 && "Invalid command number.");
  case 0:
    // DBG_VALUE, DBG_VALUE_LIST, DBG_INSTR_REF, DBG_PHI, DBG_LABEL, BUNDLE, ...
    return;
    break;
  case 1:
    // ADJUSTSTACKDOWN, ADJUSTSTACKUP, ALTENT, MEMLABEL, PCLABEL, BEQ, BGE, B...
    printOperand(MI, 0, O);
    break;
  case 2:
    // ADDLi, ADDLr, ADDQi, ADDQr, ADDS, ADDT, ANDi, ANDr, BICi, BICr, BISi, ...
    printOperand(MI, 1, O);
    break;
  case 3:
    // BR, BSR
    printOperandAddr(MI, Address, 0, O);
    break;
  case 4:
    // FCMOVEQS, FCMOVEQT, FCMOVGES, FCMOVGET, FCMOVGTS, FCMOVGTT, FCMOVLES, ...
    printOperand(MI, 3, O);
    SStream_concat1(O, ',');
    printOperand(MI, 2, O);
    SStream_concat1(O, ',');
    printOperand(MI, 0, O);
    return;
    break;
  }


  // Fragment 1 encoded into 4 bits for 13 unique commands.
  switch ((Bits >> 14) & 15) {
  default: CS_ASSERT_RET(0 && "Invalid command number.");
  case 0:
    // ADJUSTSTACKDOWN, ADJUSTSTACKUP, BR, RC, RPCC, RS
    return;
    break;
  case 1:
    // ALTENT
    SStream_concat0(O, "..ng:\n");
    return;
    break;
  case 2:
    // MEMLABEL
    SStream_concat1(O, '$');
    printOperand(MI, 1, O);
    SStream_concat1(O, '$');
    printOperand(MI, 2, O);
    SStream_concat1(O, '$');
    printOperand(MI, 3, O);
    SStream_concat1(O, ':');
    return;
    break;
  case 3:
    // PCLABEL
    SStream_concat0(O, ":\n");
    return;
    break;
  case 4:
    // ADDLi, ADDLr, ADDQi, ADDQr, ADDS, ADDT, ANDi, ANDr, BEQ, BGE, BGT, BIC...
    SStream_concat1(O, ',');
    break;
  case 5:
    // BSR
    SStream_concat0(O, " ..ng");
    return;
    break;
  case 6:
    // COND_BRANCH_F
    SStream_concat0(O, ", F8RC:");
    printOperand(MI, 1, O);
    SStream_concat0(O, ", bb:");
    printOperandAddr(MI, Address, 2, O);
    return;
    break;
  case 7:
    // COND_BRANCH_I
    SStream_concat0(O, ", GPRC:");
    printOperand(MI, 1, O);
    SStream_concat0(O, ", bb:");
    printOperandAddr(MI, Address, 2, O);
    return;
    break;
  case 8:
    // ECB, FETCH, FETCH_M, WH64, WH64EN
    SStream_concat1(O, ')');
    return;
    break;
  case 9:
    // JMP
    SStream_concat0(O, ",0");
    return;
    break;
  case 10:
    // JSR_COROUTINE
    SStream_concat0(O, ",(");
    printOperand(MI, 1, O);
    SStream_concat0(O, "),");
    printOperand(MI, 2, O);
    return;
    break;
  case 11:
    // LDAHg, LDAg
    SStream_concat0(O, ",0(");
    printOperand(MI, 2, O);
    SStream_concat0(O, ")\t\t!gpdisp!");
    printOperand(MI, 3, O);
    return;
    break;
  case 12:
    // STB, STQ_U
    SStream_concat0(O, ", ");
    printOperand(MI, 1, O);
    SStream_concat1(O, '(');
    printOperand(MI, 2, O);
    SStream_concat1(O, ')');
    return;
    break;
  }


  // Fragment 2 encoded into 2 bits for 4 unique commands.
  switch ((Bits >> 18) & 3) {
  default: CS_ASSERT_RET(0 && "Invalid command number.");
  case 0:
    // ADDLi, ADDLr, ADDQi, ADDQr, ADDS, ADDT, ANDi, ANDr, BICi, BICr, BISi, ...
    printOperand(MI, 2, O);
    break;
  case 1:
    // BEQ, BGE, BGT, BLBC, BLBS, BLE, BLT, BNE, FBEQ, FBGE, FBGT, FBLE, FBLT...
    printOperandAddr(MI, Address, 1, O);
    return;
    break;
  case 2:
    // CTLZ, CTPOP, CTTZ, CVTQS, CVTQT, CVTST, CVTTQ, CVTTS, FTOIS, FTOIT, IT...
    printOperand(MI, 0, O);
    return;
    break;
  case 3:
    // LDA, LDAH, LDAHr, LDAr, LDBU, LDBUr, LDL, LDL_L, LDLr, LDQ, LDQ_L, LDQ...
    printOperand(MI, 1, O);
    SStream_concat1(O, '(');
    printOperand(MI, 2, O);
    break;
  }


  // Fragment 3 encoded into 3 bits for 6 unique commands.
  switch ((Bits >> 20) & 7) {
  default: CS_ASSERT_RET(0 && "Invalid command number.");
  case 0:
    // ADDLi, ADDLr, ADDQi, ADDQr, ADDS, ADDT, ANDi, ANDr, BICi, BICr, BISi, ...
    SStream_concat1(O, ',');
    printOperand(MI, 0, O);
    return;
    break;
  case 1:
    // LDA, LDAH, LDBU, LDL, LDL_L, LDQ, LDQ_L, LDQ_U, LDS, LDT, LDWU, STL, S...
    SStream_concat1(O, ')');
    return;
    break;
  case 2:
    // LDAHr
    SStream_concat0(O, ")\t\t!gprelhigh");
    return;
    break;
  case 3:
    // LDAr, LDBUr, LDLr, LDQr, LDSr, LDTr, LDWUr, STBr, STLr, STQr, STSr, ST...
    SStream_concat0(O, ")\t\t!gprellow");
    return;
    break;
  case 4:
    // LDQl
    SStream_concat0(O, ")\t\t!literal");
    return;
    break;
  case 5:
    // STL_C, STQ_C
    SStream_concat1(O, '(');
    printOperand(MI, 3, O);
    SStream_concat1(O, ')');
    return;
    break;
  }

}


/// getRegisterName - This method is automatically generated by tblgen
/// from the register set description.  This returns the assembler name
/// for the specified register.
static const char *getRegisterName(unsigned RegNo) {
#ifndef CAPSTONE_DIET
  CS_ASSERT_RET_VAL(RegNo && RegNo < 65 && "Invalid register number!", NULL);

  static const char AsmStrs[] = {
  /* 0 */ "$0\0"
  /* 3 */ "$10\0"
  /* 7 */ "$f10\0"
  /* 12 */ "$20\0"
  /* 16 */ "$f20\0"
  /* 21 */ "$30\0"
  /* 25 */ "$f30\0"
  /* 30 */ "$f0\0"
  /* 34 */ "$1\0"
  /* 37 */ "$11\0"
  /* 41 */ "$f11\0"
  /* 46 */ "$21\0"
  /* 50 */ "$f21\0"
  /* 55 */ "$31\0"
  /* 59 */ "$f31\0"
  /* 64 */ "$f1\0"
  /* 68 */ "$2\0"
  /* 71 */ "$12\0"
  /* 75 */ "$f12\0"
  /* 80 */ "$22\0"
  /* 84 */ "$f22\0"
  /* 89 */ "$f2\0"
  /* 93 */ "$3\0"
  /* 96 */ "$13\0"
  /* 100 */ "$f13\0"
  /* 105 */ "$23\0"
  /* 109 */ "$f23\0"
  /* 114 */ "$f3\0"
  /* 118 */ "$4\0"
  /* 121 */ "$14\0"
  /* 125 */ "$f14\0"
  /* 130 */ "$24\0"
  /* 134 */ "$f24\0"
  /* 139 */ "$f4\0"
  /* 143 */ "$5\0"
  /* 146 */ "$15\0"
  /* 150 */ "$f15\0"
  /* 155 */ "$25\0"
  /* 159 */ "$f25\0"
  /* 164 */ "$f5\0"
  /* 168 */ "$6\0"
  /* 171 */ "$16\0"
  /* 175 */ "$f16\0"
  /* 180 */ "$26\0"
  /* 184 */ "$f26\0"
  /* 189 */ "$f6\0"
  /* 193 */ "$7\0"
  /* 196 */ "$17\0"
  /* 200 */ "$f17\0"
  /* 205 */ "$27\0"
  /* 209 */ "$f27\0"
  /* 214 */ "$f7\0"
  /* 218 */ "$8\0"
  /* 221 */ "$18\0"
  /* 225 */ "$f18\0"
  /* 230 */ "$28\0"
  /* 234 */ "$f28\0"
  /* 239 */ "$f8\0"
  /* 243 */ "$9\0"
  /* 246 */ "$19\0"
  /* 250 */ "$f19\0"
  /* 255 */ "$29\0"
  /* 259 */ "$f29\0"
  /* 264 */ "$f9\0"
};
  static const uint16_t RegAsmOffset[] = {
    30, 64, 89, 114, 139, 164, 189, 214, 239, 264, 7, 41, 75, 100, 
    125, 150, 175, 200, 225, 250, 16, 50, 84, 109, 134, 159, 184, 209, 
    234, 259, 25, 59, 0, 34, 68, 93, 118, 143, 168, 193, 218, 243, 
    3, 37, 71, 96, 121, 146, 171, 196, 221, 246, 12, 46, 80, 105, 
    130, 155, 180, 205, 230, 255, 21, 55, 
  };

  CS_ASSERT_RET_VAL(*(AsmStrs+RegAsmOffset[RegNo-1]) &&
          "Invalid alt name index for register!", NULL);
  return AsmStrs+RegAsmOffset[RegNo-1];
#else
  return NULL;
#endif // CAPSTONE_DIET
}
#ifdef PRINT_ALIAS_INSTR
#undef PRINT_ALIAS_INSTR

static bool printAliasInstr(MCInst *MI, uint64_t Address, SStream *OS) {
  return false;
}

#endif // PRINT_ALIAS_INSTR
