/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.ComparisonException;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class UntypedAtomicValue
extends StringValue {
    public static final UntypedAtomicValue ZERO_LENGTH_UNTYPED = new UntypedAtomicValue("");
    int cachedConversionType = -1;
    ConversionResult cachedConversionResult = null;

    public UntypedAtomicValue(CharSequence value) {
        this.value = value == null ? "" : value;
        this.typeLabel = BuiltInAtomicType.UNTYPED_ATOMIC;
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        UntypedAtomicValue v = new UntypedAtomicValue(this.value);
        v.cachedConversionResult = this.cachedConversionResult;
        v.cachedConversionType = this.cachedConversionType;
        v.typeLabel = typeLabel;
        return v;
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.UNTYPED_ATOMIC;
    }

    public int compareTo(AtomicValue other, StringCollator collator, XPathContext context) {
        if (other instanceof NumericValue) {
            DoubleValue doubleValue = null;
            if (this.cachedConversionType == 517) {
                try {
                    doubleValue = (DoubleValue)this.cachedConversionResult.asAtomic();
                }
                catch (ValidationException e) {
                    throw new NumberFormatException(e.getMessage());
                }
            }
            if (doubleValue == null) {
                try {
                    doubleValue = new DoubleValue(context.getConfiguration().getConversionRules().getStringToDoubleConverter().stringToNumber(this.value));
                }
                catch (NumberFormatException e) {
                    XPathException xe = new XPathException("Cannot convert untyped atomic value '" + this.getStringValue() + "' to a double ", "FORG0001");
                    throw new ComparisonException(xe);
                }
                this.cachedConversionType = 517;
                this.cachedConversionResult = doubleValue;
            }
            return doubleValue.compareTo((NumericValue)other);
        }
        if (other instanceof StringValue) {
            if (collator instanceof CodepointCollator) {
                return CodepointCollator.compareCS(this.getStringValueCS(), other.getStringValueCS());
            }
            return collator.compareStrings(this.getStringValue(), other.getStringValue());
        }
        Configuration config = context.getConfiguration();
        Converter converter = config.getConversionRules().getConverter(BuiltInAtomicType.UNTYPED_ATOMIC, other.getItemType());
        ConversionResult result = converter.convert(this);
        if (result instanceof ValidationFailure) {
            XPathException xe = new XPathException("Cannot convert untyped atomic value '" + this.getStringValue() + "' to type " + other.getItemType(), "FORG0001");
            throw new ComparisonException(xe);
        }
        return ((Comparable)((Object)result)).compareTo(other);
    }

    public synchronized ConversionResult getConversionResultIfKnown(int atomicType) {
        return this.cachedConversionType == atomicType ? this.cachedConversionResult : null;
    }

    public synchronized ConversionResult obtainConversionResult(int atomicType, StringConverter converter) {
        ConversionResult knownResult = this.getConversionResultIfKnown(atomicType);
        if (knownResult == null) {
            this.cachedConversionType = atomicType;
            this.cachedConversionResult = converter.convertString(this.value);
            return this.cachedConversionResult;
        }
        return knownResult;
    }

    public synchronized void setConversionResult(int atomicType, AtomicValue value) {
        this.cachedConversionType = atomicType;
        this.cachedConversionResult = value;
    }

    @Override
    public String toShortString() {
        return "u" + super.toShortString();
    }
}

