/* SPDX-License-Identifier: GPL-2.0-only OR MIT */

#include <console/console.h>
#include <soc/mt6685.h>

static const struct mt6685_setting init_setting[] = {
	{0x18, 0x2, 0x2, 0},
	{0x1A, 0x1F, 0x1F, 0},
	{0x27, 0x10, 0x10, 0},
	{0x8A, 0x0, 0x1F, 0},
	{0x10B, 0x8, 0x8, 0},
	{0x11E, 0x1, 0x1, 0},
	{0x127, 0x2, 0x2, 0},
	{0x193, 0x1, 0x1, 0},
	{0x19C, 0x3, 0xF, 0},
	{0x389, 0x0, 0xFF, 0},
	{0x38A, 0x0, 0x7, 0},
	{0x413, 0x7, 0xFF, 0},
	{0x418, 0x10, 0xF0, 0},
	{0x789, 0x6, 0x6, 0},
	{0x9B3, 0x0, 0x7F, 0},
	{0x9B4, 0x7E, 0x7E, 0},
	{0xF8C, 0x15, 0x15, 0},
	{0xF8D, 0x5, 0x5, 0},
	{0x1B0D, 0xF, 0xF, 0},
	{0x1B0E, 0x1, 0x1, 0},
	{0x1B0F, 0x0, 0x1, 0},
	{0x1B10, 0x7F, 0x7F, 0},
	{0x1B1A, 0x8, 0x8, 0},
	{0x1B89, 0x0, 0x80, 0},
	{0x1B8E, 0x40, 0x40, 0},
	{0x1B99, 0x0, 0x80, 0},
	{0x1B9E, 0x40, 0x40, 0},
	{0x1BA9, 0x0, 0x80, 0},
	{0x1BAE, 0x40, 0x40, 0},
	{0x1BB9, 0x0, 0x80, 0},
	{0x1BC9, 0x0, 0x80, 0},
	{0x1BD9, 0x0, 0x80, 0},
	{0x1C09, 0x0, 0x80, 0},
	{0x1C0B, 0x1, 0x5, 0},
	{0x1C0E, 0xC0, 0xC0, 0},
	{0x1C8E, 0x1, 0x1, 0},

	/* Add UVLO 2.0 setting, also need to modify dts setting for main pmic */
	{0x7F1, 0x1, 0xF, 0},
	{0x9a3, 0xD, 0x1F, 0},
	{0x9b2, 0x80, 0x80, 0},
	{0xA8b, 0x4, 0x4, 0},
};

static inline void write_field(const struct mt6685_setting *setting)
{
	mt6685_write_field(setting->addr, setting->val, setting->mask, setting->shift);
}

void mt6685_init_setting(void)
{
	for (int i = 0; i < ARRAY_SIZE(init_setting); i++)
		write_field(&init_setting[i]);
}
