/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef VARIANT_EC_H
#define VARIANT_EC_H

#include <baseboard/ec.h>

#define EC_ENABLE_MULTIPLE_DPTF_PROFILES

/* Add EC_HOST_EVENT_MKBP from baseboard */
#undef MAINBOARD_EC_S3_WAKE_EVENTS
#define MAINBOARD_EC_S3_WAKE_EVENTS \
	(MAINBOARD_EC_S5_WAKE_EVENTS |\
	 EC_HOST_EVENT_MASK(EC_HOST_EVENT_KEY_PRESSED) |\
	 EC_HOST_EVENT_MASK(EC_HOST_EVENT_MKBP)        |\
	 EC_HOST_EVENT_MASK(EC_HOST_EVENT_MODE_CHANGE))

/* Removing EC_HOST_EVENT_MKBP from baseboard mask */
#undef MAINBOARD_EC_SCI_EVENTS
#define MAINBOARD_EC_SCI_EVENTS \
	(EC_HOST_EVENT_MASK(EC_HOST_EVENT_LID_CLOSED)        |\
	 EC_HOST_EVENT_MASK(EC_HOST_EVENT_LID_OPEN)          |\
	 EC_HOST_EVENT_MASK(EC_HOST_EVENT_AC_CONNECTED)      |\
	 EC_HOST_EVENT_MASK(EC_HOST_EVENT_AC_DISCONNECTED)   |\
	 EC_HOST_EVENT_MASK(EC_HOST_EVENT_BATTERY_LOW)       |\
	 EC_HOST_EVENT_MASK(EC_HOST_EVENT_BATTERY_CRITICAL)  |\
	 EC_HOST_EVENT_MASK(EC_HOST_EVENT_BATTERY)           |\
	 EC_HOST_EVENT_MASK(EC_HOST_EVENT_BATTERY_STATUS)    |\
	 EC_HOST_EVENT_MASK(EC_HOST_EVENT_THERMAL_THRESHOLD) |\
	 EC_HOST_EVENT_MASK(EC_HOST_EVENT_THROTTLE_START)    |\
	 EC_HOST_EVENT_MASK(EC_HOST_EVENT_THROTTLE_STOP)     |\
	 EC_HOST_EVENT_MASK(EC_HOST_EVENT_PD_MCU)            |\
	 EC_HOST_EVENT_MASK(EC_HOST_EVENT_MODE_CHANGE))

#endif /* VARIANT_EC_H */
