/* SPDX-License-Identifier: GPL-2.0-or-later */

#include "gpio.h"

static const struct pad_config gpio_table[] = {
	PAD_CFG_NF_OWNERSHIP(GPPC_A0, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_A1, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_A2, UP_20K, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_A3, UP_20K, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_A4, UP_20K, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_A5, UP_20K, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_A6, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_A7, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_A8, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_A9, DN_20K, DEEP, NF1, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_A10, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_A11, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPO(GPPC_A12, 0, DEEP),
	PAD_CFG_GPI_TRIG_OWN(GPPC_A13, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_A14, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPO(GPPC_A15, 1, DEEP),
	PAD_CFG_GPIO_OWNERSHIP(GPPC_A16, NONE, DEEP, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_A17, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_A18, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_A19, NONE, DEEP, OFF, ACPI),

	PAD_CFG_NF_OWNERSHIP(GPPC_B0, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B1, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B2, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B3, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B4, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B5, NONE, DEEP, NF4, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_B6, NONE, DEEP, OFF, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B7, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B8, NONE, DEEP, NF1, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_B9, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_B10, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_B11, NONE, DEEP, OFF, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B12, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B13, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B14, NONE, DEEP, NF4, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_B15, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_B16, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_B17, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_B18, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_B19, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_B20, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_NMI(GPPC_B21, NONE, DEEP, LEVEL, INVERT),
	PAD_CFG_GPI_TRIG_OWN(GPPC_B22, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_B23, NONE, DEEP, OFF, ACPI),

	PAD_CFG_NF_OWNERSHIP(GPPC_C0, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_C1, NONE, DEEP, NF1, ACPI),
	PAD_CFG_GPO(GPPC_C2, 1, DEEP),
	PAD_CFG_GPI_TRIG_OWN(GPPC_C3, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_C4, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_C5, NONE, DEEP, OFF, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_C6, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_C7, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_C8, NONE, DEEP, NF1, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_C9, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_C10, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPO(GPPC_C11, 1, DEEP),
	PAD_CFG_GPI_TRIG_OWN(GPPC_C12, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_C13, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPO(GPPC_C14, 1, DEEP),
	PAD_CFG_GPI_TRIG_OWN(GPPC_C15, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_C16, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPO(GPPC_C17, 1, PLTRST),
	PAD_CFG_GPI_TRIG_OWN(GPPC_C18, NONE, RSMRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_C19, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_C20, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_C21, NONE, DEEP, OFF, ACPI),

	PAD_CFG_NF_OWNERSHIP(GPP_D0, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_D1, NONE, DEEP, NF1, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D2, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPO(GPP_D3, 0, DEEP),
	PAD_CFG_GPO(GPP_D4, 0, DEEP),
	PAD_CFG_GPO(GPP_D5, 0, DEEP),
	PAD_CFG_GPI_TRIG_OWN(GPP_D6, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D7, NONE, DEEP, OFF, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_D8, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_D9, NONE, DEEP, NF1, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D10, NONE, DEEP, OFF, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_D11, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_D12, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_D13, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_D14, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_D15, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_D16, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_D17, NONE, DEEP, NF1, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D18, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D19, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D20, NONE, DEEP, OFF, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_D21, NONE, DEEP, NF1, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D22, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D23, NONE, DEEP, OFF, ACPI),

	PAD_CFG_GPI_TRIG_OWN(GPP_E0, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E1, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E2, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E3, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPO(GPP_E4, 0, DEEP),			      // FIXME: GpioOutDefault
	PAD_CFG_GPO(GPP_E5, 0, DEEP),			      // FIXME: GpioOutDefault
	PAD_CFG_GPI_TRIG_OWN(GPP_E6, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E7, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E8, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E9, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E10, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPO(GPP_E11, 0, DEEP),			      // FIXME: GpioOutDefault
	PAD_CFG_GPI_TRIG_OWN(GPP_E12, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E13, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E14, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E15, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E16, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E17, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E18, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E19, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPO(GPP_E20, 0, DEEP),
	PAD_CFG_GPO(GPP_E21, 0, DEEP),
	PAD_CFG_GPO(GPP_E22, 0, DEEP),
	PAD_CFG_GPO(GPP_E23, 0, DEEP),

	PAD_CFG_GPI_TRIG_OWN(GPPC_H0, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_H1, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPO(GPPC_H2, 0, DEEP),
	PAD_CFG_GPO(GPPC_H3, 0, DEEP),
	PAD_CFG_GPO(GPPC_H4, 0, DEEP),
	PAD_CFG_GPO(GPPC_H5, 0, DEEP),
	PAD_CFG_GPI_TRIG_OWN(GPPC_H6, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_H7, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPO(GPPC_H8, 0, DEEP),
	PAD_CFG_GPO(GPPC_H9, 0, DEEP),
	PAD_CFG_GPO(GPPC_H10, 0, DEEP),
	PAD_CFG_GPO(GPPC_H11, 0, DEEP),
	PAD_CFG_GPO(GPPC_H12, 0, DEEP),
	PAD_CFG_GPO(GPPC_H13, 0, DEEP),
	PAD_CFG_GPO(GPPC_H14, 0, DEEP),
	PAD_CFG_GPI_TRIG_OWN(GPPC_H15, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_H16, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_H17, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_H18, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_H19, NONE, DEEP, OFF, ACPI),

	PAD_CFG_GPO(GPP_I0, 0, DEEP),
	PAD_CFG_GPO(GPP_I1, 0, DEEP),
	PAD_CFG_GPO(GPP_I2, 0, DEEP),
	PAD_CFG_GPO(GPP_I3, 0, DEEP),
	PAD_CFG_GPO(GPP_I4, 0, DEEP),
	PAD_CFG_GPO(GPP_I5, 0, DEEP),
	PAD_CFG_GPO(GPP_I6, 0, DEEP),
	PAD_CFG_GPO(GPP_I7, 0, DEEP),
	PAD_CFG_GPO(GPP_I8, 0, DEEP),
	PAD_CFG_GPO(GPP_I9, 0, DEEP),
	PAD_CFG_GPO(GPP_I10, 0, DEEP),
	PAD_CFG_GPO(GPP_I11, 0, DEEP),
	PAD_CFG_GPI_TRIG_OWN(GPP_I12, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_I13, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_I14, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_I15, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_I16, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPO(GPP_I17, 0, DEEP),
	PAD_CFG_GPO(GPP_I18, 0, DEEP),
	PAD_CFG_GPO(GPP_I19, 0, DEEP),
	PAD_CFG_GPO(GPP_I20, 0, DEEP),
	PAD_CFG_GPI_TRIG_OWN(GPP_I21, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_I22, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_I23, NONE, DEEP, OFF, ACPI),

	PAD_CFG_NF_OWNERSHIP(GPP_J0, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_J1, NONE, DEEP, NF1, ACPI),
	PAD_CFG_GPO(GPP_J2, 0, DEEP),
	PAD_CFG_NF_OWNERSHIP(GPP_J3, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_J4, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_J5, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_J6, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_J7, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_J8, NONE, DEEP, NF1, ACPI),
	PAD_CFG_GPO(GPP_J9, 0, DEEP),
	PAD_CFG_GPO(GPP_J10, 0, DEEP),
	PAD_CFG_GPO(GPP_J11, 0, DEEP),
	PAD_CFG_NF_OWNERSHIP(GPP_J12, UP_20K, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_J13, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_J14, UP_20K, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_J15, UP_20K, DEEP, NF1, ACPI),
	PAD_CFG_GPO(GPP_J16, 0, DEEP),
	PAD_CFG_GPO(GPP_J17, 0, DEEP),

	PAD_CFG_NF_OWNERSHIP(GPP_L0, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_L1, NONE, DEEP, NF1, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_L2, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_L3, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_L4, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_L5, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_L6, NONE, DEEP, OFF, DRIVER),
	PAD_CFG_GPI_TRIG_OWN(GPP_L7, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPO(GPP_L8, 0, DEEP),
	PAD_CFG_GPO(GPP_L9, 0, DEEP),
	PAD_CFG_GPO(GPP_L10, 0, DEEP),
	PAD_CFG_GPO(GPP_L11, 0, DEEP),
	PAD_CFG_GPO(GPP_L12, 0, DEEP),
	PAD_CFG_GPO(GPP_L13, 0, DEEP),
	PAD_CFG_GPO(GPP_L14, 0, DEEP),
	PAD_CFG_GPO(GPP_L15, 0, DEEP),
	PAD_CFG_GPO(GPP_L16, 0, DEEP),
	PAD_CFG_GPO(GPP_L17, 0, DEEP),

	PAD_CFG_GPI_TRIG_OWN(GPP_M0, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_M1, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_M2, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_M3, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_M4, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_M5, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_M6, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_M7, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_M8, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPO(GPP_M9, 0, DEEP),
	PAD_CFG_GPO(GPP_M10, 0, DEEP),
	PAD_CFG_GPI_TRIG_OWN(GPP_M11, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_M12, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPO(GPP_M13, 0, DEEP),
	PAD_CFG_GPO(GPP_M14, 0, DEEP),
	PAD_CFG_GPI_TRIG_OWN(GPP_M15, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_M16, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_M17, NONE, DEEP, OFF, ACPI),

	PAD_CFG_GPO(GPP_N0, 0, DEEP),
	PAD_CFG_GPO(GPP_N1, 0, DEEP),
	PAD_CFG_GPO(GPP_N2, 0, DEEP),
	PAD_CFG_GPO(GPP_N3, 0, DEEP),
	PAD_CFG_GPO(GPP_N4, 0, DEEP),
	PAD_CFG_GPO(GPP_N5, 0, DEEP),
	PAD_CFG_GPO(GPP_N6, 0, DEEP),
	PAD_CFG_GPO(GPP_N7, 0, DEEP),
	PAD_CFG_GPO(GPP_N8, 0, DEEP),
	PAD_CFG_GPO(GPP_N9, 0, DEEP),
	PAD_CFG_GPO(GPP_N10, 0, DEEP),
	PAD_CFG_GPO(GPP_N11, 0, DEEP),
	PAD_CFG_GPO(GPP_N12, 0, DEEP),
	PAD_CFG_GPO(GPP_N13, 0, DEEP),
	PAD_CFG_GPO(GPP_N14, 0, DEEP),
	PAD_CFG_GPO(GPP_N15, 0, DEEP),
	PAD_CFG_GPO(GPP_N16, 0, DEEP),
	PAD_CFG_GPO(GPP_N17, 0, DEEP),

	PAD_CFG_GPI_TRIG_OWN(GPP_O1, NONE, PWROK, OFF, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_O2, NONE, PWROK, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_O3, NONE, PWROK, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_O4, NONE, PWROK, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_O5, NONE, PWROK, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_O6, NONE, PWROK, NF1, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_O7, NONE, PWROK, OFF, ACPI),
	PAD_CFG_GPO(GPP_O8, 0, PWROK),
	PAD_CFG_GPO(GPP_O9, 0, PWROK),
	PAD_CFG_NF_OWNERSHIP(GPP_O10, NONE, PWROK, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_O11, NONE, PWROK, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_O12, NONE, PWROK, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_O13, NONE, PWROK, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_O14, NONE, PWROK, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_O15, NONE, PWROK, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_O16, NONE, PWROK, NF1, ACPI),

	PAD_CFG_GPI_TRIG_OWN(GPPC_S0, NONE, DEEP, OFF, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_S1, NONE, DEEP, NF1, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_S2, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_S3, NONE, RSMRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_S4, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_S5, NONE, DEEP, OFF, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_S6, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_S7, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_S8, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_S9, NONE, DEEP, NF1, DRIVER),
	PAD_CFG_GPI_TRIG_OWN(GPPC_S10, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_S11, NONE, DEEP, OFF, ACPI),
};

static const struct pad_config override_fsp_gpio_table[] = {
	PAD_CFG_GPI_TRIG_OWN(GPPC_B10, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_B11, NONE, DEEP, OFF, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B12, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B13, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B14, NONE, DEEP, NF4, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_B15, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D22, NONE, DEEP, OFF, ACPI),
};

const struct pad_config *get_gpio_table(size_t *num)
{
	*num = ARRAY_SIZE(gpio_table);
	return gpio_table;
}

const struct pad_config *get_override_fsp_gpio_table(size_t *num)
{
	*num = ARRAY_SIZE(override_fsp_gpio_table);
	return override_fsp_gpio_table;
}
