// +build !manifestcodegen
// Code generated by "menifestcodegen". DO NOT EDIT.
// To reproduce: go run github.com/9elements/converged-security-suite/v2/pkg/intel/metadata/manifest/common/manifestcodegen/cmd/manifestcodegen github.com/9elements/converged-security-suite/v2/pkg/intel/metadata/manifest

package manifest

import (
	"encoding/binary"
	"fmt"
	"io"
	"strings"

	"github.com/9elements/converged-security-suite/v2/pkg/intel/metadata/manifest/common/pretty"
)

var (
	// Just to avoid errors in "import" above in case if it wasn't used below
	_ = binary.LittleEndian
	_ = (fmt.Stringer)(nil)
	_ = (io.Reader)(nil)
	_ = pretty.Header
	_ = strings.Join
)

// NewChipsetACModuleInformation returns a new instance of ChipsetACModuleInformation with
// all default values set.
func NewChipsetACModuleInformation() *ChipsetACModuleInformation {
	s := &ChipsetACModuleInformation{}
	s.Rehash()
	return s
}

// Validate (recursively) checks the structure if there are any unexpected
// values. It returns an error if so.
func (s *ChipsetACModuleInformation) Validate() error {

	return nil
}

// ReadFrom reads the ChipsetACModuleInformation from 'r' in format defined in the document #575623.
func (s *ChipsetACModuleInformation) ReadFrom(r io.Reader) (int64, error) {
	totalN := int64(0)

	// UUID (ManifestFieldType: arrayStatic)
	{
		n, err := 16, binary.Read(r, binary.LittleEndian, s.UUID[:])
		if err != nil {
			return totalN, fmt.Errorf("unable to read field 'UUID': %w", err)
		}
		totalN += int64(n)
	}

	// ChipsetACMType (ManifestFieldType: endValue)
	{
		n, err := 1, binary.Read(r, binary.LittleEndian, &s.ChipsetACMType)
		if err != nil {
			return totalN, fmt.Errorf("unable to read field 'ChipsetACMType': %w", err)
		}
		totalN += int64(n)
	}

	// Version (ManifestFieldType: endValue)
	{
		n, err := 1, binary.Read(r, binary.LittleEndian, &s.Version)
		if err != nil {
			return totalN, fmt.Errorf("unable to read field 'Version': %w", err)
		}
		totalN += int64(n)
	}

	// Length (ManifestFieldType: endValue)
	{
		n, err := 2, binary.Read(r, binary.LittleEndian, &s.Length)
		if err != nil {
			return totalN, fmt.Errorf("unable to read field 'Length': %w", err)
		}
		totalN += int64(n)
	}

	// ChipsetIDList (ManifestFieldType: endValue)
	{
		n, err := 4, binary.Read(r, binary.LittleEndian, &s.ChipsetIDList)
		if err != nil {
			return totalN, fmt.Errorf("unable to read field 'ChipsetIDList': %w", err)
		}
		totalN += int64(n)
	}

	// OsSinitDataVer (ManifestFieldType: endValue)
	{
		n, err := 4, binary.Read(r, binary.LittleEndian, &s.OsSinitDataVer)
		if err != nil {
			return totalN, fmt.Errorf("unable to read field 'OsSinitDataVer': %w", err)
		}
		totalN += int64(n)
	}

	// MinMleHeaderVer (ManifestFieldType: endValue)
	{
		n, err := 4, binary.Read(r, binary.LittleEndian, &s.MinMleHeaderVer)
		if err != nil {
			return totalN, fmt.Errorf("unable to read field 'MinMleHeaderVer': %w", err)
		}
		totalN += int64(n)
	}

	// Capabilities (ManifestFieldType: endValue)
	{
		n, err := 4, binary.Read(r, binary.LittleEndian, &s.Capabilities)
		if err != nil {
			return totalN, fmt.Errorf("unable to read field 'Capabilities': %w", err)
		}
		totalN += int64(n)
	}

	// AcmVersion (ManifestFieldType: endValue)
	{
		n, err := 1, binary.Read(r, binary.LittleEndian, &s.AcmVersion)
		if err != nil {
			return totalN, fmt.Errorf("unable to read field 'AcmVersion': %w", err)
		}
		totalN += int64(n)
	}

	// AcmRevision (ManifestFieldType: arrayStatic)
	{
		n, err := 3, binary.Read(r, binary.LittleEndian, s.AcmRevision[:])
		if err != nil {
			return totalN, fmt.Errorf("unable to read field 'AcmRevision': %w", err)
		}
		totalN += int64(n)
	}

	// ProcessorIDList (ManifestFieldType: endValue)
	{
		n, err := 4, binary.Read(r, binary.LittleEndian, &s.ProcessorIDList)
		if err != nil {
			return totalN, fmt.Errorf("unable to read field 'ProcessorIDList': %w", err)
		}
		totalN += int64(n)
	}

	return totalN, nil
}

// RehashRecursive calls Rehash (see below) recursively.
func (s *ChipsetACModuleInformation) RehashRecursive() {
	s.Rehash()
}

// Rehash sets values which are calculated automatically depending on the rest
// data. It is usually about the total size field of an element.
func (s *ChipsetACModuleInformation) Rehash() {
}

// WriteTo writes the ChipsetACModuleInformation into 'w' in format defined in
// the document #575623.
func (s *ChipsetACModuleInformation) WriteTo(w io.Writer) (int64, error) {
	totalN := int64(0)
	s.Rehash()

	// UUID (ManifestFieldType: arrayStatic)
	{
		n, err := 16, binary.Write(w, binary.LittleEndian, s.UUID[:])
		if err != nil {
			return totalN, fmt.Errorf("unable to write field 'UUID': %w", err)
		}
		totalN += int64(n)
	}

	// ChipsetACMType (ManifestFieldType: endValue)
	{
		n, err := 1, binary.Write(w, binary.LittleEndian, &s.ChipsetACMType)
		if err != nil {
			return totalN, fmt.Errorf("unable to write field 'ChipsetACMType': %w", err)
		}
		totalN += int64(n)
	}

	// Version (ManifestFieldType: endValue)
	{
		n, err := 1, binary.Write(w, binary.LittleEndian, &s.Version)
		if err != nil {
			return totalN, fmt.Errorf("unable to write field 'Version': %w", err)
		}
		totalN += int64(n)
	}

	// Length (ManifestFieldType: endValue)
	{
		n, err := 2, binary.Write(w, binary.LittleEndian, &s.Length)
		if err != nil {
			return totalN, fmt.Errorf("unable to write field 'Length': %w", err)
		}
		totalN += int64(n)
	}

	// ChipsetIDList (ManifestFieldType: endValue)
	{
		n, err := 4, binary.Write(w, binary.LittleEndian, &s.ChipsetIDList)
		if err != nil {
			return totalN, fmt.Errorf("unable to write field 'ChipsetIDList': %w", err)
		}
		totalN += int64(n)
	}

	// OsSinitDataVer (ManifestFieldType: endValue)
	{
		n, err := 4, binary.Write(w, binary.LittleEndian, &s.OsSinitDataVer)
		if err != nil {
			return totalN, fmt.Errorf("unable to write field 'OsSinitDataVer': %w", err)
		}
		totalN += int64(n)
	}

	// MinMleHeaderVer (ManifestFieldType: endValue)
	{
		n, err := 4, binary.Write(w, binary.LittleEndian, &s.MinMleHeaderVer)
		if err != nil {
			return totalN, fmt.Errorf("unable to write field 'MinMleHeaderVer': %w", err)
		}
		totalN += int64(n)
	}

	// Capabilities (ManifestFieldType: endValue)
	{
		n, err := 4, binary.Write(w, binary.LittleEndian, &s.Capabilities)
		if err != nil {
			return totalN, fmt.Errorf("unable to write field 'Capabilities': %w", err)
		}
		totalN += int64(n)
	}

	// AcmVersion (ManifestFieldType: endValue)
	{
		n, err := 1, binary.Write(w, binary.LittleEndian, &s.AcmVersion)
		if err != nil {
			return totalN, fmt.Errorf("unable to write field 'AcmVersion': %w", err)
		}
		totalN += int64(n)
	}

	// AcmRevision (ManifestFieldType: arrayStatic)
	{
		n, err := 3, binary.Write(w, binary.LittleEndian, s.AcmRevision[:])
		if err != nil {
			return totalN, fmt.Errorf("unable to write field 'AcmRevision': %w", err)
		}
		totalN += int64(n)
	}

	// ProcessorIDList (ManifestFieldType: endValue)
	{
		n, err := 4, binary.Write(w, binary.LittleEndian, &s.ProcessorIDList)
		if err != nil {
			return totalN, fmt.Errorf("unable to write field 'ProcessorIDList': %w", err)
		}
		totalN += int64(n)
	}

	return totalN, nil
}

// UUIDSize returns the size in bytes of the value of field UUID
func (s *ChipsetACModuleInformation) UUIDTotalSize() uint64 {
	return 16
}

// ChipsetACMTypeSize returns the size in bytes of the value of field ChipsetACMType
func (s *ChipsetACModuleInformation) ChipsetACMTypeTotalSize() uint64 {
	return 1
}

// VersionSize returns the size in bytes of the value of field Version
func (s *ChipsetACModuleInformation) VersionTotalSize() uint64 {
	return 1
}

// LengthSize returns the size in bytes of the value of field Length
func (s *ChipsetACModuleInformation) LengthTotalSize() uint64 {
	return 2
}

// ChipsetIDListSize returns the size in bytes of the value of field ChipsetIDList
func (s *ChipsetACModuleInformation) ChipsetIDListTotalSize() uint64 {
	return 4
}

// OsSinitDataVerSize returns the size in bytes of the value of field OsSinitDataVer
func (s *ChipsetACModuleInformation) OsSinitDataVerTotalSize() uint64 {
	return 4
}

// MinMleHeaderVerSize returns the size in bytes of the value of field MinMleHeaderVer
func (s *ChipsetACModuleInformation) MinMleHeaderVerTotalSize() uint64 {
	return 4
}

// CapabilitiesSize returns the size in bytes of the value of field Capabilities
func (s *ChipsetACModuleInformation) CapabilitiesTotalSize() uint64 {
	return 4
}

// AcmVersionSize returns the size in bytes of the value of field AcmVersion
func (s *ChipsetACModuleInformation) AcmVersionTotalSize() uint64 {
	return 1
}

// AcmRevisionSize returns the size in bytes of the value of field AcmRevision
func (s *ChipsetACModuleInformation) AcmRevisionTotalSize() uint64 {
	return 3
}

// ProcessorIDListSize returns the size in bytes of the value of field ProcessorIDList
func (s *ChipsetACModuleInformation) ProcessorIDListTotalSize() uint64 {
	return 4
}

// UUIDOffset returns the offset in bytes of field UUID
func (s *ChipsetACModuleInformation) UUIDOffset() uint64 {
	return 0
}

// ChipsetACMTypeOffset returns the offset in bytes of field ChipsetACMType
func (s *ChipsetACModuleInformation) ChipsetACMTypeOffset() uint64 {
	return s.UUIDOffset() + s.UUIDTotalSize()
}

// VersionOffset returns the offset in bytes of field Version
func (s *ChipsetACModuleInformation) VersionOffset() uint64 {
	return s.ChipsetACMTypeOffset() + s.ChipsetACMTypeTotalSize()
}

// LengthOffset returns the offset in bytes of field Length
func (s *ChipsetACModuleInformation) LengthOffset() uint64 {
	return s.VersionOffset() + s.VersionTotalSize()
}

// ChipsetIDListOffset returns the offset in bytes of field ChipsetIDList
func (s *ChipsetACModuleInformation) ChipsetIDListOffset() uint64 {
	return s.LengthOffset() + s.LengthTotalSize()
}

// OsSinitDataVerOffset returns the offset in bytes of field OsSinitDataVer
func (s *ChipsetACModuleInformation) OsSinitDataVerOffset() uint64 {
	return s.ChipsetIDListOffset() + s.ChipsetIDListTotalSize()
}

// MinMleHeaderVerOffset returns the offset in bytes of field MinMleHeaderVer
func (s *ChipsetACModuleInformation) MinMleHeaderVerOffset() uint64 {
	return s.OsSinitDataVerOffset() + s.OsSinitDataVerTotalSize()
}

// CapabilitiesOffset returns the offset in bytes of field Capabilities
func (s *ChipsetACModuleInformation) CapabilitiesOffset() uint64 {
	return s.MinMleHeaderVerOffset() + s.MinMleHeaderVerTotalSize()
}

// AcmVersionOffset returns the offset in bytes of field AcmVersion
func (s *ChipsetACModuleInformation) AcmVersionOffset() uint64 {
	return s.CapabilitiesOffset() + s.CapabilitiesTotalSize()
}

// AcmRevisionOffset returns the offset in bytes of field AcmRevision
func (s *ChipsetACModuleInformation) AcmRevisionOffset() uint64 {
	return s.AcmVersionOffset() + s.AcmVersionTotalSize()
}

// ProcessorIDListOffset returns the offset in bytes of field ProcessorIDList
func (s *ChipsetACModuleInformation) ProcessorIDListOffset() uint64 {
	return s.AcmRevisionOffset() + s.AcmRevisionTotalSize()
}

// Size returns the total size of the ChipsetACModuleInformation.
func (s *ChipsetACModuleInformation) TotalSize() uint64 {
	if s == nil {
		return 0
	}

	var size uint64
	size += s.UUIDTotalSize()
	size += s.ChipsetACMTypeTotalSize()
	size += s.VersionTotalSize()
	size += s.LengthTotalSize()
	size += s.ChipsetIDListTotalSize()
	size += s.OsSinitDataVerTotalSize()
	size += s.MinMleHeaderVerTotalSize()
	size += s.CapabilitiesTotalSize()
	size += s.AcmVersionTotalSize()
	size += s.AcmRevisionTotalSize()
	size += s.ProcessorIDListTotalSize()
	return size
}

// PrettyString returns the content of the structure in an easy-to-read format.
func (s *ChipsetACModuleInformation) PrettyString(depth uint, withHeader bool, opts ...pretty.Option) string {
	var lines []string
	if withHeader {
		lines = append(lines, pretty.Header(depth, "Chipset AC Module Information", s))
	}
	if s == nil {
		return strings.Join(lines, "\n")
	}
	// ManifestFieldType is arrayStatic
	lines = append(lines, pretty.SubValue(depth+1, "UUID", "", &s.UUID, opts...)...)
	// ManifestFieldType is endValue
	lines = append(lines, pretty.SubValue(depth+1, "Chipset ACM Type", "", &s.ChipsetACMType, opts...)...)
	// ManifestFieldType is endValue
	lines = append(lines, pretty.SubValue(depth+1, "Version", "", &s.Version, opts...)...)
	// ManifestFieldType is endValue
	lines = append(lines, pretty.SubValue(depth+1, "Length", "", &s.Length, opts...)...)
	// ManifestFieldType is endValue
	lines = append(lines, pretty.SubValue(depth+1, "Chipset ID List", "", &s.ChipsetIDList, opts...)...)
	// ManifestFieldType is endValue
	lines = append(lines, pretty.SubValue(depth+1, "Os Sinit Data Ver", "", &s.OsSinitDataVer, opts...)...)
	// ManifestFieldType is endValue
	lines = append(lines, pretty.SubValue(depth+1, "Min Mle Header Ver", "", &s.MinMleHeaderVer, opts...)...)
	// ManifestFieldType is endValue
	lines = append(lines, pretty.SubValue(depth+1, "Capabilities", "", &s.Capabilities, opts...)...)
	// ManifestFieldType is endValue
	lines = append(lines, pretty.SubValue(depth+1, "Acm Version", "", &s.AcmVersion, opts...)...)
	// ManifestFieldType is arrayStatic
	lines = append(lines, pretty.SubValue(depth+1, "Acm Revision", "", &s.AcmRevision, opts...)...)
	// ManifestFieldType is endValue
	lines = append(lines, pretty.SubValue(depth+1, "Processor ID List", "", &s.ProcessorIDList, opts...)...)
	if depth < 2 {
		lines = append(lines, "")
	}
	return strings.Join(lines, "\n")
}

// NewChipsetACModuleInformationV5 returns a new instance of ChipsetACModuleInformationV5 with
// all default values set.
func NewChipsetACModuleInformationV5() *ChipsetACModuleInformationV5 {
	s := &ChipsetACModuleInformationV5{}
	// Recursively initializing a child structure:
	s.Base = *NewChipsetACModuleInformation()
	s.Rehash()
	return s
}

// Validate (recursively) checks the structure if there are any unexpected
// values. It returns an error if so.
func (s *ChipsetACModuleInformationV5) Validate() error {
	// Recursively validating a child structure:
	if err := s.Base.Validate(); err != nil {
		return fmt.Errorf("error on field 'Base': %w", err)
	}

	return nil
}

// ReadFrom reads the ChipsetACModuleInformationV5 from 'r' in format defined in the document #575623.
func (s *ChipsetACModuleInformationV5) ReadFrom(r io.Reader) (int64, error) {
	totalN := int64(0)

	// Base (ManifestFieldType: subStruct)
	{
		n, err := s.Base.ReadFrom(r)
		if err != nil {
			return totalN, fmt.Errorf("unable to read field 'Base': %w", err)
		}
		totalN += int64(n)
	}

	// TPMInfoList (ManifestFieldType: endValue)
	{
		n, err := 4, binary.Read(r, binary.LittleEndian, &s.TPMInfoList)
		if err != nil {
			return totalN, fmt.Errorf("unable to read field 'TPMInfoList': %w", err)
		}
		totalN += int64(n)
	}

	return totalN, nil
}

// RehashRecursive calls Rehash (see below) recursively.
func (s *ChipsetACModuleInformationV5) RehashRecursive() {
	s.Base.Rehash()
	s.Rehash()
}

// Rehash sets values which are calculated automatically depending on the rest
// data. It is usually about the total size field of an element.
func (s *ChipsetACModuleInformationV5) Rehash() {
}

// WriteTo writes the ChipsetACModuleInformationV5 into 'w' in format defined in
// the document #575623.
func (s *ChipsetACModuleInformationV5) WriteTo(w io.Writer) (int64, error) {
	totalN := int64(0)
	s.Rehash()

	// Base (ManifestFieldType: subStruct)
	{
		n, err := s.Base.WriteTo(w)
		if err != nil {
			return totalN, fmt.Errorf("unable to write field 'Base': %w", err)
		}
		totalN += int64(n)
	}

	// TPMInfoList (ManifestFieldType: endValue)
	{
		n, err := 4, binary.Write(w, binary.LittleEndian, &s.TPMInfoList)
		if err != nil {
			return totalN, fmt.Errorf("unable to write field 'TPMInfoList': %w", err)
		}
		totalN += int64(n)
	}

	return totalN, nil
}

// BaseSize returns the size in bytes of the value of field Base
func (s *ChipsetACModuleInformationV5) BaseTotalSize() uint64 {
	return s.Base.TotalSize()
}

// TPMInfoListSize returns the size in bytes of the value of field TPMInfoList
func (s *ChipsetACModuleInformationV5) TPMInfoListTotalSize() uint64 {
	return 4
}

// BaseOffset returns the offset in bytes of field Base
func (s *ChipsetACModuleInformationV5) BaseOffset() uint64 {
	return 0
}

// TPMInfoListOffset returns the offset in bytes of field TPMInfoList
func (s *ChipsetACModuleInformationV5) TPMInfoListOffset() uint64 {
	return s.BaseOffset() + s.BaseTotalSize()
}

// Size returns the total size of the ChipsetACModuleInformationV5.
func (s *ChipsetACModuleInformationV5) TotalSize() uint64 {
	if s == nil {
		return 0
	}

	var size uint64
	size += s.BaseTotalSize()
	size += s.TPMInfoListTotalSize()
	return size
}

// PrettyString returns the content of the structure in an easy-to-read format.
func (s *ChipsetACModuleInformationV5) PrettyString(depth uint, withHeader bool, opts ...pretty.Option) string {
	var lines []string
	if withHeader {
		lines = append(lines, pretty.Header(depth, "Chipset AC Module Information V 5", s))
	}
	if s == nil {
		return strings.Join(lines, "\n")
	}
	// ManifestFieldType is subStruct
	lines = append(lines, pretty.SubValue(depth+1, "Base", "", &s.Base, opts...)...)
	// ManifestFieldType is endValue
	lines = append(lines, pretty.SubValue(depth+1, "TPM Info List", "", &s.TPMInfoList, opts...)...)
	if depth < 2 {
		lines = append(lines, "")
	}
	return strings.Join(lines, "\n")
}
