/*
 * Copyright (c) 2019-2023, Intel Corporation. All rights reserved.
 * Copyright (c) 2024, Altera Corporation. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef AGX5_PINMUX_H
#define AGX5_PINMUX_H

#include "socfpga_handoff.h"

/* PINMUX REGISTER ADDRESS */
#define AGX5_PINMUX_PIN0SEL					0x10D13000
#define AGX5_PINMUX_IO0CTRL					0x10D13130
#define AGX5_PINMUX_EMAC0_USEFPGA				0x10D13300
#define AGX5_PINMUX_IO0_DELAY					0x10D13400

/* Macros */
#define SOCFPGA_PINMUX_SEL_NAND					(0x03)
#define SOCFPGA_PINMUX_PIN0SEL					(0x00)
#define SOCFPGA_PINMUX_PIN1SEL					(0x04)
#define SOCFPGA_PINMUX_PIN2SEL					(0x08)
#define SOCFPGA_PINMUX_PIN3SEL					(0x0C)
#define SOCFPGA_PINMUX_PIN4SEL					(0x10)
#define SOCFPGA_PINMUX_PIN5SEL					(0x14)
#define SOCFPGA_PINMUX_PIN6SEL					(0x18)
#define SOCFPGA_PINMUX_PIN7SEL					(0x1C)
#define SOCFPGA_PINMUX_PIN8SEL					(0x20)
#define SOCFPGA_PINMUX_PIN9SEL					(0x24)
#define SOCFPGA_PINMUX_PIN10SEL					(0x28)
#define SOCFPGA_PINMUX_PIN11SEL					(0x2C)
#define SOCFPGA_PINMUX_PIN12SEL					(0x30)
#define SOCFPGA_PINMUX_PIN13SEL					(0x34)
#define SOCFPGA_PINMUX_PIN14SEL					(0x38)
#define SOCFPGA_PINMUX_PIN15SEL					(0x3C)
#define SOCFPGA_PINMUX_PIN16SEL					(0x40)
#define SOCFPGA_PINMUX_PIN17SEL					(0x44)
#define SOCFPGA_PINMUX_PIN18SEL					(0x48)
#define SOCFPGA_PINMUX_PIN19SEL					(0x4C)
#define SOCFPGA_PINMUX_PIN20SEL					(0x50)
#define SOCFPGA_PINMUX_PIN21SEL					(0x54)
#define SOCFPGA_PINMUX_PIN22SEL					(0x58)
#define SOCFPGA_PINMUX_PIN23SEL					(0x5C)
#define SOCFPGA_PINMUX_PIN24SEL					(0x60)
#define SOCFPGA_PINMUX_PIN25SEL					(0x64)
#define SOCFPGA_PINMUX_PIN26SEL					(0x68)
#define SOCFPGA_PINMUX_PIN27SEL					(0x6C)
#define SOCFPGA_PINMUX_PIN28SEL					(0x70)
#define SOCFPGA_PINMUX_PIN29SEL					(0x74)
#define SOCFPGA_PINMUX_PIN30SEL					(0x78)
#define SOCFPGA_PINMUX_PIN31SEL					(0x7C)
#define SOCFPGA_PINMUX_PIN32SEL					(0x80)
#define SOCFPGA_PINMUX_PIN33SEL					(0x84)
#define SOCFPGA_PINMUX_PIN34SEL					(0x88)
#define SOCFPGA_PINMUX_PIN35SEL					(0x8C)
#define SOCFPGA_PINMUX_PIN36SEL					(0x90)
#define SOCFPGA_PINMUX_PIN37SEL					(0x94)
#define SOCFPGA_PINMUX_PIN38SEL					(0x98)
#define SOCFPGA_PINMUX_PIN39SEL					(0x9C)
#define SOCFPGA_PINMUX_PIN40SEL					(0x100)
#define SOCFPGA_PINMUX_PIN41SEL					(0x104)
#define SOCFPGA_PINMUX_PIN42SEL					(0x108)
#define SOCFPGA_PINMUX_PIN43SEL					(0x10C)
#define SOCFPGA_PINMUX_PIN44SEL					(0x110)
#define SOCFPGA_PINMUX_PIN45SEL					(0x114)
#define SOCFPGA_PINMUX_PIN46SEL					(0x118)
#define SOCFPGA_PINMUX_PIN47SEL					(0x11C)

#define SOCFPGA_PINMUX_IO0CTRL					(0x00)
#define SOCFPGA_PINMUX_IO1CTRL					(0x04)
#define SOCFPGA_PINMUX_IO2CTRL					(0x08)
#define SOCFPGA_PINMUX_IO3CTRL					(0x0C)
#define SOCFPGA_PINMUX_IO4CTRL					(0x10)
#define SOCFPGA_PINMUX_IO5CTRL					(0x14)
#define SOCFPGA_PINMUX_IO6CTRL					(0x18)
#define SOCFPGA_PINMUX_IO7CTRL					(0x1C)
#define SOCFPGA_PINMUX_IO8CTRL					(0x20)
#define SOCFPGA_PINMUX_IO9CTRL					(0x24)
#define SOCFPGA_PINMUX_IO10CTRL					(0x28)
#define SOCFPGA_PINMUX_IO11CTRL					(0x2C)
#define SOCFPGA_PINMUX_IO12CTRL					(0x30)
#define SOCFPGA_PINMUX_IO13CTRL					(0x34)
#define SOCFPGA_PINMUX_IO14CTRL					(0x38)
#define SOCFPGA_PINMUX_IO15CTRL					(0x3C)
#define SOCFPGA_PINMUX_IO16CTRL					(0x40)
#define SOCFPGA_PINMUX_IO17CTRL					(0x44)
#define SOCFPGA_PINMUX_IO18CTRL					(0x48)
#define SOCFPGA_PINMUX_IO19CTRL					(0x4C)
#define SOCFPGA_PINMUX_IO20CTRL					(0x50)
#define SOCFPGA_PINMUX_IO21CTRL					(0x54)
#define SOCFPGA_PINMUX_IO22CTRL					(0x58)
#define SOCFPGA_PINMUX_IO23CTRL					(0x5C)
#define SOCFPGA_PINMUX_IO24CTRL					(0x60)
#define SOCFPGA_PINMUX_IO25CTRL					(0x64)
#define SOCFPGA_PINMUX_IO26CTRL					(0x68)
#define SOCFPGA_PINMUX_IO27CTRL					(0x6C)
#define SOCFPGA_PINMUX_IO28CTRL					(0xD0)
#define SOCFPGA_PINMUX_IO29CTRL					(0xD4)
#define SOCFPGA_PINMUX_IO30CTRL					(0xD8)
#define SOCFPGA_PINMUX_IO31CTRL					(0xDC)
#define SOCFPGA_PINMUX_IO32CTRL					(0xE0)
#define SOCFPGA_PINMUX_IO33CTRL					(0xE4)
#define SOCFPGA_PINMUX_IO34CTRL					(0xE8)
#define SOCFPGA_PINMUX_IO35CTRL					(0xEC)
#define SOCFPGA_PINMUX_IO36CTRL					(0xF0)
#define SOCFPGA_PINMUX_IO37CTRL					(0xF4)
#define SOCFPGA_PINMUX_IO38CTRL					(0xF8)
#define SOCFPGA_PINMUX_IO39CTRL					(0xFC)
#define SOCFPGA_PINMUX_IO40CTRL					(0x100)
#define SOCFPGA_PINMUX_IO41CTRL					(0x104)
#define SOCFPGA_PINMUX_IO42CTRL					(0x108)
#define SOCFPGA_PINMUX_IO43CTRL					(0x10C)
#define SOCFPGA_PINMUX_IO44CTRL					(0x110)
#define SOCFPGA_PINMUX_IO45CTRL					(0x114)
#define SOCFPGA_PINMUX_IO46CTRL					(0x118)
#define SOCFPGA_PINMUX_IO47CTRL					(0x11C)

#define SOCFPGA_PINMUX_EMAC0_USEFPGA				(0x00)
#define SOCFPGA_PINMUX_EMAC1_USEFPGA				(0x04)
#define SOCFPGA_PINMUX_EMAC2_USEFPGA				(0x08)
#define SOCFPGA_PINMUX_I2C0_USEFPGA				(0x0C)
#define SOCFPGA_PINMUX_I2C1_USEFPGA				(0x10)
#define SOCFPGA_PINMUX_I2C_EMAC0_USEFPGA			(0x14)
#define SOCFPGA_PINMUX_I2C_EMAC1_USEFPGA			(0x18)
#define SOCFPGA_PINMUX_I2C_EMAC2_USEFPGA			(0x1C)
#define SOCFPGA_PINMUX_NAND_USEFPGA				(0x20)
#define SOCFPGA_PINMUX_SPIM0_USEFPGA				(0x28)
#define SOCFPGA_PINMUX_SPIM1_USEFPGA				(0x2C)
#define SOCFPGA_PINMUX_SPIS0_USEFPGA				(0x30)
#define SOCFPGA_PINMUX_SPIS1_USEFPGA				(0x34)
#define SOCFPGA_PINMUX_UART0_USEFPGA				(0x38)
#define SOCFPGA_PINMUX_UART1_USEFPGA				(0x3C)
#define SOCFPGA_PINMUX_MDIO0_USEFPGA				(0x40)
#define SOCFPGA_PINMUX_MDIO1_USEFPGA				(0x44)
#define SOCFPGA_PINMUX_MDIO2_USEFPGA				(0x48)
#define SOCFPGA_PINMUX_JTAG_USEFPGA				(0x50)
#define SOCFPGA_PINMUX_SDMMC_USEFPGA				(0x54)

#define SOCFPGA_PINUMX_USEFPGA(_reg)				(AGX5_PINMUX_EMAC0_USEFPGA \
								+ SOCFPGA_PINMUX_##_reg)

#define SOCFPGA_PINMUX_IO0DELAY					(0x00)
#define SOCFPGA_PINMUX_IO1DELAY					(0x04)
#define SOCFPGA_PINMUX_IO2DELAY					(0x08)
#define SOCFPGA_PINMUX_IO3DELAY					(0x0C)
#define SOCFPGA_PINMUX_IO4DELAY					(0x10)
#define SOCFPGA_PINMUX_IO5DELAY					(0x14)
#define SOCFPGA_PINMUX_IO6DELAY					(0x18)
#define SOCFPGA_PINMUX_IO7DELAY					(0x1C)
#define SOCFPGA_PINMUX_IO8DELAY					(0x20)
#define SOCFPGA_PINMUX_IO9DELAY					(0x24)
#define SOCFPGA_PINMUX_IO10DELAY				(0x28)
#define SOCFPGA_PINMUX_IO11DELAY				(0x2C)
#define SOCFPGA_PINMUX_IO12DELAY				(0x30)
#define SOCFPGA_PINMUX_IO13DELAY				(0x34)
#define SOCFPGA_PINMUX_IO14DELAY				(0x38)
#define SOCFPGA_PINMUX_IO15DELAY				(0x3C)
#define SOCFPGA_PINMUX_IO16DELAY				(0x40)
#define SOCFPGA_PINMUX_IO17DELAY				(0x44)
#define SOCFPGA_PINMUX_IO18DELAY				(0x48)
#define SOCFPGA_PINMUX_IO19DELAY				(0x4C)
#define SOCFPGA_PINMUX_IO20DELAY				(0x50)
#define SOCFPGA_PINMUX_IO21DELAY				(0x54)
#define SOCFPGA_PINMUX_IO22DELAY				(0x58)
#define SOCFPGA_PINMUX_IO23DELAY				(0x5C)
#define SOCFPGA_PINMUX_IO24DELAY				(0x60)
#define SOCFPGA_PINMUX_IO25DELAY				(0x64)
#define SOCFPGA_PINMUX_IO26DELAY				(0x68)
#define SOCFPGA_PINMUX_IO27DELAY				(0x6C)
#define SOCFPGA_PINMUX_IO28DELAY				(0x70)
#define SOCFPGA_PINMUX_IO29DELAY				(0x74)
#define SOCFPGA_PINMUX_IO30DELAY				(0x78)
#define SOCFPGA_PINMUX_IO31DELAY				(0x7C)
#define SOCFPGA_PINMUX_IO32DELAY				(0x80)
#define SOCFPGA_PINMUX_IO33DELAY				(0x84)
#define SOCFPGA_PINMUX_IO34DELAY				(0x88)
#define SOCFPGA_PINMUX_IO35DELAY				(0x8C)
#define SOCFPGA_PINMUX_IO36DELAY				(0x90)
#define SOCFPGA_PINMUX_IO37DELAY				(0x94)
#define SOCFPGA_PINMUX_IO38DELAY				(0x98)
#define SOCFPGA_PINMUX_IO39DELAY				(0x9C)
#define SOCFPGA_PINMUX_IO40DELAY				(0xA0)
#define SOCFPGA_PINMUX_IO41DELAY				(0xA4)
#define SOCFPGA_PINMUX_IO42DELAY				(0xA8)
#define SOCFPGA_PINMUX_IO43DELAY				(0xAC)
#define SOCFPGA_PINMUX_IO44DELAY				(0xB0)
#define SOCFPGA_PINMUX_IO45DELAY				(0xB4)
#define SOCFPGA_PINMUX_IO46DELAY				(0xB8)
#define SOCFPGA_PINMUX_IO47DELAY				(0xBC)

#define SOCFPGA_PINMUX_I3C0_USEFPGA				(0xC0)
#define SOCFPGA_PINMUX_I3C1_USEFPGA				(0xC4)

#define SOCFPGA_PINMUX(_reg)					(SOCFPGA_PINMUX_REG_BASE \
								+ (SOCFPGA_PINMUX_##_reg))

void config_pinmux(handoff *handoff);
#endif
