/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.classfile;

import com.claritysys.jvm.classfile.CfMethod;
import com.claritysys.jvm.classfile.ClassFileFormatException;
import java.io.DataInputStream;
import java.io.IOException;

public class ExceptionHandler {
    protected CfMethod method;
    protected ExceptionHandler next;
    protected int startPc;
    protected int endPc;
    protected int handlerPc;
    protected int exceptionClassIndex;

    public ExceptionHandler(CfMethod method, DataInputStream dataIn) throws IOException, ClassFileFormatException {
        this.method = method;
        this.startPc = dataIn.readUnsignedShort();
        this.endPc = dataIn.readUnsignedShort();
        this.handlerPc = dataIn.readUnsignedShort();
        this.exceptionClassIndex = dataIn.readUnsignedShort();
    }

    public ExceptionHandler(CfMethod method, int startPc, int endPc, int handlerPc, int exceptionClassIndex) {
        this.method = method;
        this.startPc = startPc;
        this.endPc = endPc;
        this.handlerPc = handlerPc;
        this.exceptionClassIndex = exceptionClassIndex;
    }

    public ExceptionHandler getNext() {
        return this.next;
    }

    public void setNext(ExceptionHandler next) {
        this.next = next;
    }

    public int getStartPc() {
        return this.startPc;
    }

    public void setStartPc(int startPc) {
        this.startPc = startPc;
    }

    public int getEndPc() {
        return this.endPc;
    }

    public void setEndPc(int endPc) {
        this.endPc = endPc;
    }

    public int getHandlerPc() {
        return this.handlerPc;
    }

    public void setHandlerPc(int handlerPc) {
        this.handlerPc = handlerPc;
    }

    public int getExceptionClassIndex() {
        return this.exceptionClassIndex;
    }

    public void setExceptionClassIndex(int exceptionClassIndex) {
        this.exceptionClassIndex = exceptionClassIndex;
    }
}

