/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.dependencies;

import com.intellij.microservices.jvm.dependencies.Version;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VersionRange {
    private static final Pattern RANGE_PATTERN = Pattern.compile("(\\(|\\[)(.*),(.*)(\\)|])");
    private final Version lowerVersion;
    private final boolean lowerInclusive;
    private final Version higherVersion;
    private final boolean higherInclusive;

    private VersionRange(Version lowerVersion, boolean lowerInclusive, Version higherVersion, boolean higherInclusive) {
        this.lowerVersion = lowerVersion;
        this.lowerInclusive = lowerInclusive;
        this.higherVersion = higherVersion;
        this.higherInclusive = higherInclusive;
    }

    public boolean match(Version version) {
        int lower = this.lowerVersion.compareTo(version);
        if (lower > 0) {
            return false;
        }
        if (!this.lowerInclusive && lower == 0) {
            return false;
        }
        if (this.higherVersion != null) {
            int higher = this.higherVersion.compareTo(version);
            if (higher < 0) {
                return false;
            }
            if (!this.higherInclusive && higher == 0) {
                return false;
            }
        }
        return true;
    }

    public String displayText() {
        boolean hasLower;
        StringBuilder sb = new StringBuilder();
        boolean bl = hasLower = this.lowerVersion.getMajor() != 0;
        if (hasLower) {
            if (this.lowerInclusive) {
                sb.append(">=");
            } else {
                sb.append(">");
            }
            sb.append(this.lowerVersion.displayText());
        }
        if (this.higherVersion != null && this.higherVersion.getMajor() != 0) {
            if (hasLower) {
                sb.append(" and ");
            }
            if (this.higherInclusive) {
                sb.append("<=");
            } else {
                sb.append("<");
            }
            sb.append(this.higherVersion.displayText());
        }
        return sb.toString();
    }

    public static VersionRange parse(String text) {
        Matcher matcher = RANGE_PATTERN.matcher(text.trim());
        if (!matcher.matches()) {
            Version version = Version.parse(text);
            return new VersionRange(version, true, null, true);
        }
        boolean lowerInclusive = matcher.group(1).equals("[");
        Version lowerVersion = Version.parse(matcher.group(2));
        Version higherVersion = Version.parse(matcher.group(3));
        boolean higherInclusive = matcher.group(4).equals("]");
        return new VersionRange(lowerVersion, lowerInclusive, higherVersion, higherInclusive);
    }
}

