/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.resolve.directive;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.protobuf.ide.highlighter.PbTextSyntaxHighlighter;
import com.intellij.protobuf.lang.PbLangBundle;
import com.intellij.protobuf.lang.psi.PbMessageType;
import com.intellij.protobuf.lang.psi.PbTextFile;
import com.intellij.protobuf.lang.resolve.PbImportReference;
import com.intellij.protobuf.lang.resolve.directive.SchemaComment;
import com.intellij.protobuf.lang.resolve.directive.SchemaDirective;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;

public class SchemaDirectiveAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            SchemaDirectiveAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SchemaDirectiveAnnotator.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiComment && element.getContainingFile() instanceof PbTextFile) {
            SchemaDirectiveAnnotator.annotateDirectiveComment((PsiComment)element, holder);
        }
    }

    private static void annotateDirectiveComment(PsiComment comment, AnnotationHolder holder) {
        PsiElement resolved;
        PsiReference messageReference;
        SchemaDirective directive = SchemaDirective.find(comment.getContainingFile());
        if (directive == null) {
            return;
        }
        SchemaComment schemaComment = directive.getSchemaComment(comment);
        if (schemaComment == null) {
            return;
        }
        TextRange keyRange = schemaComment.getKeyRange();
        if (keyRange == null) {
            return;
        }
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(keyRange.shiftRight(comment.getTextOffset())).textAttributes(PbTextSyntaxHighlighter.COMMENT_DIRECTIVE).create();
        if (schemaComment.getName() == null) {
            holder.newAnnotation(HighlightSeverity.WARNING, SchemaDirectiveAnnotator.missingNameWarning(schemaComment.getType())).range(keyRange.shiftRight(comment.getTextOffset())).afterEndOfLine().create();
            return;
        }
        if (schemaComment.getType() == SchemaComment.Type.MESSAGE && (messageReference = schemaComment.getReference()) != null && (resolved = messageReference.resolve()) != null && !(resolved instanceof PbMessageType)) {
            holder.newAnnotation(HighlightSeverity.WARNING, PbLangBundle.message("message.type.expected", new Object[0])).range(messageReference.getRangeInElement().shiftRight(comment.getTextOffset())).create();
        }
        if (directive.getFileComment() == null || directive.getMessageComment() == null) {
            holder.newAnnotation(HighlightSeverity.WARNING, PbLangBundle.message("file.and.message.comments.must.be.specified", new Object[0])).range(keyRange.shiftRight(comment.getTextOffset())).create();
        }
        for (PsiReference ref : schemaComment.getAllReferences()) {
            String symbol = ref.getRangeInElement().substring(ref.getElement().getText());
            if (symbol.isEmpty() || ref.resolve() != null) continue;
            holder.newAnnotation(HighlightSeverity.WARNING, SchemaDirectiveAnnotator.cannotResolveWarning(ref, symbol)).range(ref.getRangeInElement().shiftRight(ref.getElement().getStartOffsetInParent())).create();
        }
    }

    @NotNull
    @InspectionMessage
    private static String missingNameWarning(SchemaComment.Type type) {
        String string = PbLangBundle.message(switch (type) {
            default -> throw new MatchException(null, null);
            case SchemaComment.Type.FILE, SchemaComment.Type.IMPORT -> "missing.filename";
            case SchemaComment.Type.MESSAGE -> "missing.message.name";
        }, new Object[0]);
        if (string == null) {
            SchemaDirectiveAnnotator.$$$reportNull$$$0(2);
        }
        return string;
    }

    @InspectionMessage
    private static String cannotResolveWarning(PsiReference ref, String name) {
        if (ref instanceof PbImportReference) {
            return PbLangBundle.message("cannot.resolve.import", name);
        }
        return PbLangBundle.message("cannot.resolve.symbol", name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/protobuf/lang/resolve/directive/SchemaDirectiveAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/protobuf/lang/resolve/directive/SchemaDirectiveAnnotator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "missingNameWarning";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

