/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.kubernetes.api.settings.KubernetesApiGlobalSettings;
import com.intellij.kubernetes.api.settings.KubernetesApiProjectSettings;
import com.intellij.kubernetes.config.KubernetesProjectOptions;
import com.intellij.kubernetes.config.KubernetesProjectSettings;
import com.intellij.openapi.project.Project;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kubernetes/KubernetesSettingsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "VERSION", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "NAMESPACES_IN_SETTINGS", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "getGroup", "intellij.clouds.kubernetes.backend"})
public final class KubernetesSettingsCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("kubernetes.settings", 7, null, 4, null);
    @NotNull
    private final EventId1<String> VERSION = this.GROUP.registerEvent("k8sVersion", (EventField)EventFields.Version);
    @NotNull
    private final EventId2<Integer, Integer> NAMESPACES_IN_SETTINGS = this.GROUP.registerEvent("namespaces.count.used", (EventField)EventFields.RoundedInt((String)"global"), (EventField)EventFields.RoundedInt((String)"in_project"));

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = new MetricEvent[]{this.VERSION.metric((Object)((KubernetesProjectOptions)KubernetesProjectSettings.Companion.getInstance(project).getState()).getApiVersion()), this.NAMESPACES_IN_SETTINGS.metric((Object)KubernetesApiGlobalSettings.Companion.getInstance().getNamespaces().size(), (Object)KubernetesApiProjectSettings.Companion.getInstance(project).getNamespaces().size())};
        return SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }
}

