/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.inspections;

import com.intellij.aop.psi.PsiExecutionExpression;
import com.intellij.aop.psi.PsiPointcutExpression;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.model.highlighting.dom.SpringDomInspectionUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.security.SpringSecurityBundle;
import com.intellij.spring.security.model.xml.AccessDeniedHandler;
import com.intellij.spring.security.model.xml.AuthenticationProvider;
import com.intellij.spring.security.model.xml.CustomFilter;
import com.intellij.spring.security.model.xml.GlobalMethodSecurity;
import com.intellij.spring.security.model.xml.Http;
import com.intellij.spring.security.model.xml.InterceptUrl;
import com.intellij.spring.security.model.xml.LdapCommonElement;
import com.intellij.spring.security.model.xml.LdapServer;
import com.intellij.spring.security.model.xml.PrePostAnnotations;
import com.intellij.spring.security.model.xml.Protect;
import com.intellij.spring.security.model.xml.ProtectPointcut;
import com.intellij.spring.security.model.xml.RememberMe;
import com.intellij.spring.security.model.xml.UserService;
import com.intellij.spring.security.util.SpringSecurityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.List;
import java.util.Set;

class SpringSecurityModelVisitor
implements DomElementVisitor {
    private final DomElementAnnotationHolder holder;
    private final boolean myMultipleUserServices;
    private final SpringDomInspectionUtils mySpringDomInspectionUtils;
    private boolean foundGlobalMethodSecurity;

    SpringSecurityModelVisitor(DomElementAnnotationHolder holder, boolean multipleUserServices) {
        this.holder = holder;
        this.myMultipleUserServices = multipleUserServices;
        this.mySpringDomInspectionUtils = new SpringDomInspectionUtils(holder);
    }

    public void visitDomElement(DomElement element) {
        this.visitSubElements(element);
    }

    private void visitSubElements(DomElement element) {
        List children = DomUtil.getDefinedChildren((DomElement)element, (boolean)true, (boolean)false);
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            DomElement child = (DomElement)children.get(i);
            child.accept((DomElementVisitor)this);
        }
    }

    public void visitHttp(Http http) {
        if (http.getSecurity().getValue() == Http.Security.NONE && http.getXmlTag().getSubTags().length != 0) {
            this.holder.createProblem((DomElement)http, HighlightSeverity.ERROR, SpringSecurityBundle.message("model.inspection.model.http.must.not.contain.children", new Object[0]));
        }
        if (this.myMultipleUserServices) {
            List refs = ContainerUtil.concat((List[])new List[]{http.getRememberMes(), http.getX509s(), http.getOpenidLogins()});
            ContainerUtil.process((List)refs, userServiceRefElement -> {
                if (!DomUtil.hasXml(userServiceRefElement.getUserServiceRef())) {
                    if (userServiceRefElement instanceof RememberMe && DomUtil.hasXml(((RememberMe)userServiceRefElement).getServicesRef())) {
                        return true;
                    }
                    this.holder.createProblem((DomElement)userServiceRefElement, HighlightSeverity.ERROR, SpringSecurityBundle.message("model.inspection.model.user.service.ref.required", new Object[0]));
                }
                return true;
            });
        }
        this.visitSubElements(http);
    }

    public void visitUserService(UserService userService) {
        if (DomUtil.hasXml(userService.getProperties()) && !userService.getUsers().isEmpty()) {
            this.holder.createProblem((DomElement)userService, HighlightSeverity.ERROR, SpringSecurityBundle.message("model.inspection.model.user.service.either.properties.or.users", new Object[0]));
        }
    }

    public void visitLdapServer(LdapServer ldapServer) {
        if (DomUtil.hasXml(ldapServer.getManagerDn()) && !DomUtil.hasXml(ldapServer.getManagerPassword())) {
            this.holder.createProblem((DomElement)ldapServer, HighlightSeverity.ERROR, SpringSecurityBundle.message("model.inspection.model.ldap.server.manager.dn.without.manager.password", new Object[0]));
        }
    }

    public void visitLdapCommonElement(LdapCommonElement ldapCommonElement) {
        boolean moreThanOne = SpringDomInspectionUtils.hasMoreThanOne((DomElement[])new DomElement[]{ldapCommonElement.getUserDetailsClass(), ldapCommonElement.getUserContextMapperRef()});
        if (moreThanOne) {
            this.holder.createProblem((DomElement)ldapCommonElement, HighlightSeverity.ERROR, SpringSecurityBundle.message("model.inspection.model.ldap.either.user.context.mapper.ref.or.user.details.class", new Object[0]));
        }
    }

    public void visitCustomFilter(CustomFilter customFilter) {
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)customFilter, new GenericAttributeValue[]{customFilter.getAfter(), customFilter.getBefore(), customFilter.getPosition()});
    }

    public void visitAuthenticationProvider(AuthenticationProvider authenticationProvider) {
        boolean moreThanOne = SpringDomInspectionUtils.hasMoreThanOne((DomElement[])new DomElement[]{authenticationProvider.getJdbcUserService(), authenticationProvider.getLdapUserService(), authenticationProvider.getUserService()});
        if (moreThanOne) {
            this.holder.createProblem((DomElement)authenticationProvider, HighlightSeverity.ERROR, SpringSecurityBundle.message("model.inspection.model.authentication.provider.only.one.kind.of.user.service", new Object[0]));
        }
        this.visitSubElements(authenticationProvider);
    }

    public void visitGlobalMethodSecurity(GlobalMethodSecurity globalMethodSecurity) {
        if (DomUtil.hasXml((DomElement)globalMethodSecurity.getPrePostAnnotationHandling()) && globalMethodSecurity.getPrePostAnnotations().getValue() != PrePostAnnotations.ENABLED) {
            this.holder.createProblem((DomElement)globalMethodSecurity, HighlightSeverity.ERROR, SpringSecurityBundle.message("model.inspection.global.method.security.pre.post.annotations.not.enabled", new Object[0]));
        }
        if (globalMethodSecurity.getMode().getValue() == GlobalMethodSecurity.Mode.ASPECTJ && !globalMethodSecurity.getProtectPointcuts().isEmpty()) {
            this.holder.createProblem((DomElement)globalMethodSecurity, HighlightSeverity.ERROR, SpringSecurityBundle.message("mode.inspection.global.method.security.not.aspectj.with.protect.pointcut", new Object[0]));
        }
        this.foundGlobalMethodSecurity = true;
        this.visitSubElements(globalMethodSecurity);
    }

    public void visitInterceptUrl(InterceptUrl interceptUrl) {
        if (interceptUrl.getParentOfType(Http.class, true) != null) {
            return;
        }
        if (DomUtil.hasXml(interceptUrl.getRequiresChannel())) {
            this.holder.createProblem(interceptUrl.getRequiresChannel(), HighlightSeverity.ERROR, SpringSecurityBundle.message("model.inspection.model.intercept.url.attribute.only.inside.http", new Object[0]));
        }
        if (DomUtil.hasXml(interceptUrl.getFilters())) {
            this.holder.createProblem(interceptUrl.getFilters(), HighlightSeverity.ERROR, SpringSecurityBundle.message("model.inspection.model.intercept.url.attribute.only.inside.http", new Object[0]));
        }
    }

    public void visitAccessDeniedHandler(AccessDeniedHandler accessDeniedHandler) {
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)accessDeniedHandler, new GenericAttributeValue[]{accessDeniedHandler.getErrorPage(), accessDeniedHandler.getRef()});
        Http http = (Http)accessDeniedHandler.getParentOfType(Http.class, true);
        if (http != null && DomUtil.hasXml(http.getAccessDeniedPage())) {
            this.holder.createProblem((DomElement)accessDeniedHandler, HighlightSeverity.ERROR, SpringSecurityBundle.message("model.inspection.model.access.denied.handler.no.http.access.denied.page", new Object[0]));
        }
    }

    public void visitProtectPointcut(ProtectPointcut protectPointcut) {
        PsiPointcutExpression pointcutExpression = (PsiPointcutExpression)protectPointcut.getExpression().getValue();
        if (!(pointcutExpression instanceof PsiExecutionExpression)) {
            this.holder.createProblem(protectPointcut.getExpression(), HighlightSeverity.ERROR, SpringSecurityBundle.message("model.inspection.model.protect.pointcut.expression.only.execution", new Object[0]));
        }
    }

    public void visitProtect(Protect protect) {
        if (this.foundGlobalMethodSecurity || SpringSecurityModelVisitor.findGlobalMethodSecurityDefinition(protect)) {
            this.holder.createProblem((DomElement)protect, HighlightSeverity.WARNING, SpringSecurityBundle.message("model.inspection.model.protect.do.not.mix.with.global.method.security", new Object[0]));
        }
    }

    private static boolean findGlobalMethodSecurityDefinition(DomElement domElement) {
        Module module = domElement.getModule();
        if (module == null) {
            return false;
        }
        Set models = SpringManager.getInstance((Project)domElement.getManager().getProject()).getAllModels(module);
        for (SpringModel model : models) {
            if (!(model instanceof XmlSpringModel)) continue;
            Set roots = ((XmlSpringModel)model).getLocalModelsRoots();
            for (DomFileElement domFileElement : roots) {
                List globalMethodSecurityList;
                if (!SpringSecurityUtil.isSpringSecurityUsed((DomFileElement<Beans>)domFileElement) || (globalMethodSecurityList = DomUtil.getDefinedChildrenOfType((DomElement)domFileElement.getRootElement(), GlobalMethodSecurity.class, (boolean)true, (boolean)false)).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }
}

