/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gitlab.internal;

import com.vladsch.flexmark.ext.gitlab.GitLabExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSetter;
import com.vladsch.flexmark.util.misc.CharPredicate;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class GitLabOptions
implements MutableDataSetter {
    public final boolean insParser;
    public final boolean delParser;
    public final boolean inlineMathParser;
    public final boolean blockQuoteParser;
    public final boolean nestedBlockQuotes;
    public final boolean renderBlockMath;
    public final boolean renderBlockMermaid;
    public final boolean renderVideoImages;
    public final boolean renderVideoLink;
    public final String inlineMathClass;
    public final String blockMathClass;
    public final String blockMermaidClass;
    public final String[] mathLanguages;
    public final String[] mermaidLanguages;
    public final String videoImageClass;
    public final String videoImageLinkTextFormat;
    public final String videoImageExtensions;
    public final HashSet<String> videoImageExtensionSet;
    @Deprecated
    public final String blockInfoDelimiters;
    @Deprecated
    public final CharPredicate blockInfoDelimiterSet;

    public GitLabOptions(DataHolder options) {
        String[] extensions;
        this.insParser = GitLabExtension.INS_PARSER.get(options);
        this.delParser = GitLabExtension.DEL_PARSER.get(options);
        this.inlineMathParser = GitLabExtension.INLINE_MATH_PARSER.get(options);
        this.blockQuoteParser = GitLabExtension.BLOCK_QUOTE_PARSER.get(options);
        this.nestedBlockQuotes = GitLabExtension.NESTED_BLOCK_QUOTES.get(options);
        this.inlineMathClass = GitLabExtension.INLINE_MATH_CLASS.get(options);
        this.renderBlockMath = GitLabExtension.RENDER_BLOCK_MATH.get(options);
        this.renderBlockMermaid = GitLabExtension.RENDER_BLOCK_MERMAID.get(options);
        this.renderVideoImages = GitLabExtension.RENDER_VIDEO_IMAGES.get(options);
        this.renderVideoLink = GitLabExtension.RENDER_VIDEO_LINK.get(options);
        this.blockMathClass = GitLabExtension.BLOCK_MATH_CLASS.get(options);
        this.blockMermaidClass = GitLabExtension.BLOCK_MERMAID_CLASS.get(options);
        this.blockInfoDelimiters = HtmlRenderer.FENCED_CODE_LANGUAGE_DELIMITERS.get(options);
        this.blockInfoDelimiterSet = CharPredicate.anyOf(this.blockInfoDelimiters);
        this.mathLanguages = GitLabExtension.MATH_LANGUAGES.get(options);
        this.mermaidLanguages = GitLabExtension.MERMAID_LANGUAGES.get(options);
        this.videoImageClass = GitLabExtension.VIDEO_IMAGE_CLASS.get(options);
        this.videoImageLinkTextFormat = GitLabExtension.VIDEO_IMAGE_LINK_TEXT_FORMAT.get(options);
        this.videoImageExtensions = GitLabExtension.VIDEO_IMAGE_EXTENSIONS.get(options);
        this.videoImageExtensionSet = new HashSet();
        for (String ext : extensions = this.videoImageExtensions.split(",")) {
            String trimmed = ext.trim();
            if (trimmed.isEmpty()) continue;
            this.videoImageExtensionSet.add(trimmed);
        }
    }

    @Override
    @NotNull
    public MutableDataHolder setIn(@NotNull MutableDataHolder dataHolder) {
        dataHolder.set(GitLabExtension.INS_PARSER, Boolean.valueOf(this.insParser));
        dataHolder.set(GitLabExtension.DEL_PARSER, Boolean.valueOf(this.delParser));
        dataHolder.set(GitLabExtension.INLINE_MATH_PARSER, Boolean.valueOf(this.inlineMathParser));
        dataHolder.set(GitLabExtension.BLOCK_QUOTE_PARSER, Boolean.valueOf(this.blockQuoteParser));
        dataHolder.set(GitLabExtension.NESTED_BLOCK_QUOTES, Boolean.valueOf(this.nestedBlockQuotes));
        dataHolder.set(GitLabExtension.INLINE_MATH_CLASS, this.inlineMathClass);
        dataHolder.set(GitLabExtension.RENDER_BLOCK_MATH, Boolean.valueOf(this.renderBlockMath));
        dataHolder.set(GitLabExtension.RENDER_BLOCK_MERMAID, Boolean.valueOf(this.renderBlockMermaid));
        dataHolder.set(GitLabExtension.RENDER_VIDEO_IMAGES, Boolean.valueOf(this.renderVideoImages));
        dataHolder.set(GitLabExtension.RENDER_VIDEO_LINK, Boolean.valueOf(this.renderVideoLink));
        dataHolder.set(GitLabExtension.BLOCK_MATH_CLASS, this.blockMathClass);
        dataHolder.set(GitLabExtension.BLOCK_MERMAID_CLASS, this.blockMermaidClass);
        dataHolder.set(HtmlRenderer.FENCED_CODE_LANGUAGE_DELIMITERS, this.blockInfoDelimiters);
        dataHolder.set(GitLabExtension.VIDEO_IMAGE_CLASS, this.videoImageClass);
        dataHolder.set(GitLabExtension.VIDEO_IMAGE_LINK_TEXT_FORMAT, this.videoImageLinkTextFormat);
        dataHolder.set(GitLabExtension.VIDEO_IMAGE_EXTENSIONS, this.videoImageExtensions);
        return dataHolder;
    }
}

