/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.settings;

import com.intellij.execution.ui.AdjustingTabSettingsEditor;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowsRange;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/nodejs/run/profile/settings/NodeProfilingPanel;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/jetbrains/nodejs/run/NodeJsRunConfiguration;", "Lcom/intellij/execution/ui/AdjustingTabSettingsEditor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "profile", "Lcom/intellij/ui/components/JBCheckBox;", "logFileField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "oneLogFile", "allowHeapProfiling", "mainPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "resetEditorFrom", "", "rc", "applyEditorTo", "getLogFileText", "", "createEditor", "Ljavax/swing/JComponent;", "intellij.nodeJS"})
@SourceDebugExtension(value={"SMAP\nNodeProfilingPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeProfilingPanel.kt\ncom/jetbrains/nodejs/run/profile/settings/NodeProfilingPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public final class NodeProfilingPanel
extends SettingsEditor<NodeJsRunConfiguration>
implements AdjustingTabSettingsEditor {
    @NotNull
    private final Project project;
    private JBCheckBox profile;
    private TextFieldWithBrowseButton logFileField;
    private JBCheckBox oneLogFile;
    private JBCheckBox allowHeapProfiling;
    @NotNull
    private final DialogPanel mainPanel;

    public NodeProfilingPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.mainPanel = BuilderKt.panel(arg_0 -> NodeProfilingPanel.mainPanel$lambda$0(this, arg_0));
    }

    protected void resetEditorFrom(@NotNull NodeJsRunConfiguration rc) {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        String finalText;
        NodeProfilingSettings settings;
        block11: {
            Object object;
            block9: {
                block10: {
                    String basePath;
                    boolean haveLogFile;
                    Intrinsics.checkNotNullParameter((Object)((Object)rc), (String)"rc");
                    NodeProfilingSettings nodeProfilingSettings = rc.getNodeProfilingSettings();
                    Intrinsics.checkNotNullExpressionValue((Object)nodeProfilingSettings, (String)"getNodeProfilingSettings(...)");
                    settings = nodeProfilingSettings;
                    JBCheckBox jBCheckBox = this.profile;
                    if (jBCheckBox == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"profile");
                        jBCheckBox = null;
                    }
                    jBCheckBox.setSelected(settings.isProfile());
                    String string = settings.getLogFolder();
                    if (string == null) {
                        string = "";
                    }
                    String text = string;
                    boolean bl = haveLogFile = settings.getLogFolder() != null;
                    if (!haveLogFile) break block9;
                    Path file = null;
                    Path path = file = NioFiles.toPath((String)text);
                    boolean bl2 = path != null ? !path.isAbsolute() : false;
                    if (bl2 && (basePath = this.project.getBasePath()) != null) {
                        String string2 = basePath;
                        String[] stringArray = new String[]{text};
                        Path path2 = Paths.get(string2, Arrays.copyOf(stringArray, stringArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                        file = path2.normalize();
                    }
                    if ((object = file) == null) break block10;
                    Object it = object;
                    boolean bl3 = false;
                    String string3 = FileUtil.toSystemDependentName((String)((Object)file).toString());
                    object = string3;
                    if (string3 != null) break block11;
                }
                object = "";
                break block11;
            }
            object = this.project.getBasePath();
            if (object == null) {
                object = finalText = "";
            }
        }
        if ((textFieldWithBrowseButton = this.logFileField) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logFileField");
            textFieldWithBrowseButton = null;
        }
        textFieldWithBrowseButton.setText(finalText);
        JBCheckBox jBCheckBox = this.oneLogFile;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"oneLogFile");
            jBCheckBox = null;
        }
        jBCheckBox.setSelected(settings.isOneLogFile());
        JBCheckBox jBCheckBox2 = this.allowHeapProfiling;
        if (jBCheckBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"allowHeapProfiling");
            jBCheckBox2 = null;
        }
        jBCheckBox2.setSelected(settings.isAllowRuntimeHeapSnapshot());
    }

    protected void applyEditorTo(@NotNull NodeJsRunConfiguration rc) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)((Object)rc), (String)"rc");
        NodeProfilingSettings nodeProfilingSettings = rc.getNodeProfilingSettings();
        Intrinsics.checkNotNullExpressionValue((Object)nodeProfilingSettings, (String)"getNodeProfilingSettings(...)");
        NodeProfilingSettings settings = nodeProfilingSettings;
        JBCheckBox jBCheckBox = this.profile;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"profile");
            jBCheckBox = null;
        }
        settings.setProfile(jBCheckBox.isSelected());
        String text = this.getLogFileText();
        NodeProfilingSettings nodeProfilingSettings2 = settings;
        CharSequence charSequence2 = text;
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            NodeProfilingSettings nodeProfilingSettings3 = nodeProfilingSettings2;
            boolean bl = false;
            charSequence = null;
            nodeProfilingSettings2 = nodeProfilingSettings3;
        } else {
            charSequence = charSequence2;
        }
        nodeProfilingSettings2.setLogFolder((String)charSequence);
        JBCheckBox jBCheckBox2 = this.oneLogFile;
        if (jBCheckBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"oneLogFile");
            jBCheckBox2 = null;
        }
        settings.setOneLogFile(jBCheckBox2.isSelected());
        settings.setOpenViewer(true);
        JBCheckBox jBCheckBox3 = this.allowHeapProfiling;
        if (jBCheckBox3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"allowHeapProfiling");
            jBCheckBox3 = null;
        }
        settings.setAllowRuntimeHeapSnapshot(jBCheckBox3.isSelected());
    }

    private final String getLogFileText() {
        String relativePath;
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.logFileField;
        if (textFieldWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logFileField");
            textFieldWithBrowseButton = null;
        }
        String string = textFieldWithBrowseButton.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = string;
        String basePath = this.project.getBasePath();
        if (basePath != null && (relativePath = FileUtil.getRelativePath((String)FileUtil.toSystemIndependentName((String)basePath), (String)FileUtil.toSystemIndependentName((String)text), (char)'/')) != null) {
            text = relativePath;
        }
        return text;
    }

    @NotNull
    protected JComponent createEditor() {
        return (JComponent)this.mainPanel;
    }

    private static final Unit mainPanel$lambda$0(NodeProfilingPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> NodeProfilingPanel.mainPanel$lambda$0$0(this$0, arg_0), (int)1, null);
        RowsRange rowsRange = $this$panel.indent(arg_0 -> NodeProfilingPanel.mainPanel$lambda$0$1(this$0, arg_0));
        JBCheckBox jBCheckBox = this$0.profile;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"profile");
            jBCheckBox = null;
        }
        rowsRange.enabledIf(ComponentPredicateKt.getSelected((AbstractButton)((AbstractButton)jBCheckBox)));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> NodeProfilingPanel.mainPanel$lambda$0$2(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit mainPanel$lambda$0$0(NodeProfilingPanel this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = NodeJSBundle.message("runConfiguration.nodejs.profiling.cpu.record.checkbox", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell it = cell = $this$row.checkBox(string);
        boolean bl = false;
        this$0.profile = (JBCheckBox)it.getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit mainPanel$lambda$0$1(NodeProfilingPanel this$0, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Panel.row$default((Panel)$this$indent, null, arg_0 -> NodeProfilingPanel.mainPanel$lambda$0$1$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$indent, null, arg_0 -> NodeProfilingPanel.mainPanel$lambda$0$1$1(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit mainPanel$lambda$0$1$0(NodeProfilingPanel this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = NodeJSBundle.message("runConfiguration.nodejs.profiling.cpu.log.folder.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.singleDir();
        Intrinsics.checkNotNull((Object)descriptor);
        Cell it = cell = Row.textFieldWithBrowseButton$default((Row)$this$row, (FileChooserDescriptor)descriptor, null, null, (int)6, null).applyToComponent(arg_0 -> NodeProfilingPanel.mainPanel$lambda$0$1$0$0(descriptor, this$0, arg_0)).align((Align)AlignX.FILL.INSTANCE);
        boolean bl = false;
        this$0.logFileField = (TextFieldWithBrowseButton)it.getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit mainPanel$lambda$0$1$0$0(FileChooserDescriptor $descriptor, NodeProfilingPanel this$0, TextFieldWithBrowseButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        FileChooserFactory.getInstance().installFileCompletion($this$applyToComponent.getTextField(), $descriptor, false, null);
        $this$applyToComponent.addActionListener(arg_0 -> NodeProfilingPanel.mainPanel$lambda$0$1$0$0$0($descriptor, this$0, $this$applyToComponent, arg_0));
        return Unit.INSTANCE;
    }

    private static final void mainPanel$lambda$0$1$0$0$0(FileChooserDescriptor $descriptor, NodeProfilingPanel this$0, TextFieldWithBrowseButton $this_applyToComponent, ActionEvent it) {
        FileChooserDialog fileChooserDialog = FileChooserFactory.getInstance().createFileChooser($descriptor, this$0.project, (Component)$this_applyToComponent);
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDialog, (String)"createFileChooser(...)");
        FileChooserDialog chooser = fileChooserDialog;
        VirtualFile[] virtualFileArray = new VirtualFile[]{ProjectUtil.guessProjectDir((Project)this$0.project)};
        VirtualFile[] virtualFileArray2 = chooser.choose(this$0.project, virtualFileArray);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"choose(...)");
        VirtualFile[] fileWrapper = virtualFileArray2;
        if (!(fileWrapper.length == 0)) {
            $this_applyToComponent.setText(fileWrapper[0].getPath());
        }
    }

    private static final Unit mainPanel$lambda$0$1$1(NodeProfilingPanel this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = NodeJSBundle.message("runConfiguration.nodejs.profiling.cpu.one.log.file.checkbox", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell it = cell = $this$row.checkBox(string);
        boolean bl = false;
        this$0.oneLogFile = (JBCheckBox)it.getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit mainPanel$lambda$0$2(NodeProfilingPanel this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = NodeJSBundle.message("runConfiguration.nodejs.profiling.heap.take.snapshots.checkbox", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell it = cell = $this$row.checkBox(string);
        boolean bl = false;
        this$0.allowHeapProfiling = (JBCheckBox)it.getComponent();
        String string2 = NodeJSBundle.message("runConfiguration.nodejs.profiling.heap.inspect.explanation", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Row.contextHelp$default((Row)$this$row, (String)string2, null, (int)2, null);
        return Unit.INSTANCE;
    }
}

