/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.colors;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.ui.MessageType;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightColors;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.ide.model.AbstractColor;
import com.jetbrains.rd.ide.model.ColorId;
import com.jetbrains.rd.ide.model.ColorKeyModel;
import com.jetbrains.rd.ide.model.NamedColor;
import com.jetbrains.rd.ide.model.ThemeColorId;
import com.jetbrains.rd.platform.colors.ColorHostKt;
import com.jetbrains.rd.platform.colors.ColorKeysStorage;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0015J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rd/platform/colors/ColorHost;", "", "<init>", "()V", "colorKeyStorage", "Lcom/jetbrains/rd/platform/colors/ColorKeysStorage;", "namedColorCache", "Ljava/util/HashMap;", "", "Ljava/awt/Color;", "Lkotlin/collections/HashMap;", "enumMap", "", "Lcom/jetbrains/rd/ide/model/ColorId;", "getColor", "colorId", "Lcom/jetbrains/rd/ide/model/ThemeColorId;", "model", "Lcom/jetbrains/rd/ide/model/NamedColor;", "getColorKey", "Lcom/intellij/openapi/editor/colors/ColorKey;", "Lcom/jetbrains/rd/ide/model/ColorKeyModel;", "colorScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "getColorKeyModel", "key", "Companion", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nColorHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorHost.kt\ncom/jetbrains/rd/platform/colors/ColorHost\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,120:1\n382#2,7:121\n13#3:128\n*S KotlinDebug\n*F\n+ 1 ColorHost.kt\ncom/jetbrains/rd/platform/colors/ColorHost\n*L\n56#1:121,7\n24#1:128\n*E\n"})
public final class ColorHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ColorKeysStorage colorKeyStorage = new ColorKeysStorage();
    @NotNull
    private final HashMap<String, Color> namedColorCache = new HashMap();
    @NotNull
    private final Map<ColorId, Color> enumMap;
    @NotNull
    private static final Logger logger;

    public ColorHost() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ColorId.DefaultForeground, (Object)JBColor.black), TuplesKt.to((Object)ColorId.Gray, (Object)JBColor.gray), TuplesKt.to((Object)ColorId.LabelForeground, (Object)UIUtil.getLabelForeground()), TuplesKt.to((Object)ColorId.LabelForegroundBrighter, (Object)new JBColor((Color)Gray.x00, (Color)Gray.xFF)), TuplesKt.to((Object)ColorId.LabelDisabled, (Object)UIUtil.getLabelDisabledForeground()), TuplesKt.to((Object)ColorId.ListBackground, (Object)UIUtil.getListBackground()), TuplesKt.to((Object)ColorId.InformationHint, (Object)HintUtil.getInformationColor()), TuplesKt.to((Object)ColorId.ErrorHint, (Object)HintUtil.getErrorColor()), TuplesKt.to((Object)ColorId.WarningHint, (Object)HintUtil.getWarningColor()), TuplesKt.to((Object)ColorId.QuestionHint, (Object)HintUtil.getQuestionColor()), TuplesKt.to((Object)ColorId.BalloonBorder, (Object)JBUI.CurrentTheme.Tooltip.borderColor()), TuplesKt.to((Object)ColorId.PopupInformationBg, (Object)MessageType.INFO.getPopupBackground()), TuplesKt.to((Object)ColorId.PopupWarningBg, (Object)MessageType.WARNING.getPopupBackground()), TuplesKt.to((Object)ColorId.PopupErrorBg, (Object)MessageType.ERROR.getPopupBackground()), TuplesKt.to((Object)ColorId.Success, (Object)LightColors.GREEN)};
        this.enumMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final Color getColor(@NotNull ThemeColorId colorId) {
        Intrinsics.checkNotNullParameter((Object)colorId, (String)"colorId");
        Color color = this.enumMap.get(colorId.getId());
        if (color == null) {
            ColorHost $this$getColor_u24lambda_u240 = this;
            boolean bl = false;
            logger.error("Can't resolve color by enum: " + colorId);
            JBColor jBColor = JBColor.BLACK;
            Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"BLACK");
            return (Color)jBColor;
        }
        return color;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Color getColor(@NotNull NamedColor model) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Map map = this.namedColorCache;
        String key$iv = model.getName();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            Color color;
            Color defaultColor;
            boolean bl = false;
            AbstractColor abstractColor = model.getDefaultColor();
            Color color2 = defaultColor = abstractColor != null ? ColorHostKt.toColor(abstractColor) : null;
            if (defaultColor != null) {
                JBColor jBColor = JBColor.namedColor((String)model.getName(), (Color)defaultColor);
                Intrinsics.checkNotNull((Object)jBColor);
                color = (Color)jBColor;
            } else {
                JBColor jBColor = JBColor.namedColor((String)model.getName());
                Intrinsics.checkNotNull((Object)jBColor);
                color = (Color)jBColor;
            }
            return color;
        }
        return (Color)value$iv;
    }

    @NotNull
    public final ColorKey getColorKey(@NotNull ColorKeyModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return this.colorKeyStorage.getColorKey(model);
    }

    @Nullable
    public final Color getColor(@NotNull ColorKeyModel model, @NotNull EditorColorsScheme colorScheme) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)colorScheme, (String)"colorScheme");
        ColorKey key = this.getColorKey(model);
        return colorScheme.getColor(key);
    }

    public static /* synthetic */ Color getColor$default(ColorHost colorHost, ColorKeyModel colorKeyModel, EditorColorsScheme editorColorsScheme, int n, Object object) {
        if ((n & 2) != 0) {
            EditorColorsScheme editorColorsScheme2 = EditorColorsManager.getInstance().getGlobalScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme2, (String)"getGlobalScheme(...)");
            editorColorsScheme = editorColorsScheme2;
        }
        return colorHost.getColor(colorKeyModel, editorColorsScheme);
    }

    @NotNull
    public final ColorKeyModel getColorKeyModel(@NotNull ColorKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.colorKeyStorage.getModel(key);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ColorHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ColorHost.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rd/platform/colors/ColorHost$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rd/platform/colors/ColorHost;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.platform"})
    @SourceDebugExtension(value={"SMAP\nColorHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorHost.kt\ncom/jetbrains/rd/platform/colors/ColorHost$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,120:1\n42#2,3:121\n*S KotlinDebug\n*F\n+ 1 ColorHost.kt\ncom/jetbrains/rd/platform/colors/ColorHost$Companion\n*L\n23#1:121,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColorHost getInstance() {
            boolean $i$f$service = false;
            Class<ColorHost> serviceClass$iv = ColorHost.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (ColorHost)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

