/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.owner;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.ContextMetaObjectFactory;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.owner.ElementMatcherImpl;
import com.intellij.database.schemaEditor.owner.ElementOwnerImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class Id<E extends BasicElement>
implements ElementIdentity<E>,
Comparable<Id<?>> {
    private final Object myParentIdOrMatcher;
    private final BasicMetaObject<E> myMetaObject;
    private final BasicMetaReference<?, E> myInlined;
    private final int myOrder;
    private final Set<BasicMetaObject<?>> myPulled;

    Id(@Nullable Id<?> parentId, @NotNull ElementMatcherImpl matcher, @NotNull BasicMetaObject<E> metaObject, int order) {
        if (matcher == null) {
            Id.$$$reportNull$$$0(0);
        }
        if (metaObject == null) {
            Id.$$$reportNull$$$0(1);
        }
        this(parentId, matcher, null, metaObject, order);
    }

    Id(@Nullable Id<?> parentId, @NotNull ElementMatcherImpl matcher, @Nullable BasicMetaReference<?, E> inlined2, @NotNull BasicMetaObject<E> metaObject, int order) {
        if (matcher == null) {
            Id.$$$reportNull$$$0(2);
        }
        if (metaObject == null) {
            Id.$$$reportNull$$$0(3);
        }
        this.myPulled = new HashSet();
        ContextMetaObjectFactory.assertBound(metaObject);
        this.myParentIdOrMatcher = parentId == null ? matcher : parentId;
        this.myMetaObject = metaObject;
        this.myOrder = order;
        this.myInlined = inlined2;
        this.getMatcher().cache(this);
    }

    boolean onPull(BasicMetaObject<?> meta) {
        return this.myPulled.add(meta);
    }

    boolean isPulled(BasicMetaObject<?> meta) {
        return this.myPulled.contains(meta);
    }

    @NotNull
    private ElementMatcherImpl getMatcher() {
        Id<?> p = this.getParentId();
        return p == null ? (ElementMatcherImpl)this.myParentIdOrMatcher : p.getMatcher();
    }

    @NotNull
    public BasicMetaObject<E> getMetaObject() {
        BasicMetaObject<E> basicMetaObject = this.myMetaObject;
        if (basicMetaObject == null) {
            Id.$$$reportNull$$$0(4);
        }
        return basicMetaObject;
    }

    @Nullable
    <S extends BasicElement> BasicMetaReference<S, E> getInlined(S parent2) {
        return this.getInlined();
    }

    @Nullable
    BasicMetaReference<?, E> getInlined() {
        return this.myInlined;
    }

    @Nullable
    public Id<?> getParentId() {
        return (Id)ObjectUtils.tryCast((Object)this.myParentIdOrMatcher, Id.class);
    }

    @Override
    public int compareTo(@NotNull Id<?> o) {
        if (o == null) {
            Id.$$$reportNull$$$0(5);
        }
        return Integer.compare(this.myOrder, o.myOrder);
    }

    public String toString() {
        List path = (List)JBIterable.generate((Object)this, Id::getParentId).addAllTo(new ArrayList());
        Collections.reverse(path);
        Object res2 = StringUtil.join((Collection)path, Id::getPathItem, (String)".");
        if (!((String)res2).endsWith("]")) {
            res2 = (String)res2 + ":" + this.getKindAndOrder();
        }
        return res2;
    }

    private String getPathItem() {
        if (this.myMetaObject.kind == ObjectKind.ROOT) {
            return "";
        }
        String anyName = this.findName();
        return anyName == null ? "[+" + this.getKindAndOrder() + "]" : anyName;
    }

    @Nullable
    private String findName() {
        for (ElementOwnerImpl owner : this.getMatcher().getOwners()) {
            Object r = owner.findElement(this);
            if (ElementMatcherImpl.isNull(r) || r.getName().isEmpty()) continue;
            return r.getName();
        }
        return null;
    }

    @NotNull
    private String getKindAndOrder() {
        String string = this.myMetaObject.kind.code() + " #" + this.myOrder;
        if (string == null) {
            Id.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaObject";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/owner/Id";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/owner/Id";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaObject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindAndOrder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }
}

