/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.lombok;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import de.plushnikov.intellij.plugin.psi.LombokLightAnnotationMethodBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightArrayInitializerMemberValue;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LombokAnnotationProcessor {
    private static final Map<String, Pair<Collection<String>, Collection<String>>> config = LombokAnnotationProcessor.initializeConfig();

    private static Map<String, Pair<Collection<String>, Collection<String>>> initializeConfig() {
        return Map.of("onParam_", LombokAnnotationProcessor.createAnnotationsPair("lombok.Setter", "lombok.EqualsAndHashCode", "lombok.With", "lombok.experimental.Wither"), "onMethod_", LombokAnnotationProcessor.createAnnotationsPair("lombok.Getter", "lombok.Setter", "lombok.With", "lombok.experimental.Wither"), "onConstructor_", LombokAnnotationProcessor.createAnnotationsPair("lombok.AllArgsConstructor", "lombok.RequiredArgsConstructor", "lombok.NoArgsConstructor"));
    }

    private static Pair<Collection<String>, Collection<String>> createAnnotationsPair(String ... fqns) {
        List<String> fqnList = Arrays.asList(fqns);
        List shortNamesList = ContainerUtil.map(fqnList, StringUtil::getShortName);
        return Pair.pair((Object)shortNamesList, fqnList);
    }

    @NotNull
    public static List<PsiMethod> process(@NotNull PsiClass psiClass, @Nullable String nameHint) {
        if (psiClass == null) {
            LombokAnnotationProcessor.$$$reportNull$$$0(0);
        }
        if (nameHint != null && !config.containsKey(nameHint)) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                LombokAnnotationProcessor.$$$reportNull$$$0(1);
            }
            return list;
        }
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        if (nameHint != null) {
            Pair<Collection<String>, Collection<String>> hintConfig = config.get(nameHint);
            LombokAnnotationProcessor.addAnnotationMethods(psiClass, (Collection)hintConfig.getFirst(), (Collection)hintConfig.getSecond(), nameHint, result);
        } else {
            for (Map.Entry<String, Pair<Collection<String>, Collection<String>>> entry : config.entrySet()) {
                LombokAnnotationProcessor.addAnnotationMethods(psiClass, (Collection)entry.getValue().getFirst(), (Collection)entry.getValue().getSecond(), entry.getKey(), result);
            }
        }
        ArrayList<PsiMethod> arrayList = result;
        if (arrayList == null) {
            LombokAnnotationProcessor.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static void addAnnotationMethods(@NotNull PsiClass psiClass, @NotNull Collection<String> onXAnnotationNames, @NotNull Collection<String> onXAnnotationFQNs, @NotNull String methodName, @NotNull List<PsiMethod> result) {
        if (psiClass == null) {
            LombokAnnotationProcessor.$$$reportNull$$$0(3);
        }
        if (onXAnnotationNames == null) {
            LombokAnnotationProcessor.$$$reportNull$$$0(4);
        }
        if (onXAnnotationFQNs == null) {
            LombokAnnotationProcessor.$$$reportNull$$$0(5);
        }
        if (methodName == null) {
            LombokAnnotationProcessor.$$$reportNull$$$0(6);
        }
        if (result == null) {
            LombokAnnotationProcessor.$$$reportNull$$$0(7);
        }
        if (onXAnnotationNames.contains(psiClass.getName()) && onXAnnotationFQNs.contains(psiClass.getQualifiedName())) {
            result.add((PsiMethod)LombokAnnotationProcessor.createAnnotationMethod(psiClass, methodName));
        }
    }

    private static LombokLightMethodBuilder createAnnotationMethod(@NotNull PsiClass psiClass, @NotNull String methodName) {
        if (psiClass == null) {
            LombokAnnotationProcessor.$$$reportNull$$$0(8);
        }
        if (methodName == null) {
            LombokAnnotationProcessor.$$$reportNull$$$0(9);
        }
        PsiClassType myAnnotationType = PsiType.getJavaLangObject((PsiManager)psiClass.getManager(), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)psiClass.getProject()));
        return new LombokLightAnnotationMethodBuilder(psiClass.getManager(), methodName).withDefaultValue((PsiAnnotationMemberValue)new LombokLightArrayInitializerMemberValue(psiClass.getManager(), psiClass.getLanguage())).withContainingClass(psiClass).withMethodReturnType((PsiType)new PsiArrayType((PsiType)myAnnotationType));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/lombok/LombokAnnotationProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onXAnnotationNames";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onXAnnotationFQNs";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/lombok/LombokAnnotationProcessor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotationMethods";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

