/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveAnnotationQuickFix;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.inspection.LombokJavaInspectionBase;
import de.plushnikov.intellij.plugin.intention.valvar.from.ReplaceValWithExplicitTypeIntentionAction;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigDiscovery;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigKey;
import de.plushnikov.intellij.plugin.processor.ValProcessor;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LombokFlagUsageInspection
extends LombokJavaInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            LombokFlagUsageInspection.$$$reportNull$$$0(0);
        }
        return new LombokFlagUsageElementVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "de/plushnikov/intellij/plugin/inspection/LombokFlagUsageInspection", "createVisitor"));
    }

    private static class LombokFlagUsageElementVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder holder;

        LombokFlagUsageElementVisitor(ProblemsHolder holder) {
            this.holder = holder;
        }

        public void visitClass(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                LombokFlagUsageElementVisitor.$$$reportNull$$$0(0);
            }
            for (PsiAnnotation psiAnnotation : psiClass.getAnnotations()) {
                this.visitAnnotatedElement(psiAnnotation);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.Data", ConfigKey.DATA_FLAG_USAGE);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.Value", ConfigKey.VALUE_FLAG_USAGE);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.EqualsAndHashCode", ConfigKey.EQUALS_AND_HASHCODE_FLAG_USAGE);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.ToString", ConfigKey.TOSTRING_FLAG_USAGE);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.experimental.SuperBuilder", ConfigKey.SUPER_BUILDER_FLAG_USAGE, ConfigKey.EXPERIMENTAL_FLAG_USAGE);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.experimental.Helper", ConfigKey.HELPER_FLAG_USAGE, ConfigKey.EXPERIMENTAL_FLAG_USAGE);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.experimental.UtilityClass", ConfigKey.UTILITY_CLASS_FLAG_USAGE, ConfigKey.EXPERIMENTAL_FLAG_USAGE);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.experimental.StandardException", ConfigKey.STANDARD_EXCEPTION_FLAG_USAGE, ConfigKey.EXPERIMENTAL_FLAG_USAGE);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.experimental.ExtensionMethod", ConfigKey.EXTENSION_METHOD_FLAG_USAGE, ConfigKey.EXPERIMENTAL_FLAG_USAGE);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.experimental.FieldDefaults", ConfigKey.FIELD_DEFAULTS_FLAG_USAGE, ConfigKey.EXPERIMENTAL_FLAG_USAGE);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.experimental.FieldNameConstants", ConfigKey.FIELD_NAME_CONSTANT_FLAG_USAGE, ConfigKey.EXPERIMENTAL_FLAG_USAGE);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.extern.apachecommons.CommonsLog", ConfigKey.LOG_APACHE_COMMONS_FLAG_USAGE, ConfigKey.LOG_FLAG_USAGE);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.CustomLog", ConfigKey.LOG_CUSTOM_USAGE, ConfigKey.LOG_FLAG_USAGE);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.extern.flogger.Flogger", ConfigKey.LOG_FLOGGER_FLAG_USAGE, ConfigKey.LOG_FLAG_USAGE);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.extern.java.Log", ConfigKey.LOG_JAVA_UTIL_LOGGING_FLAG_USAGE, ConfigKey.LOG_FLAG_USAGE);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.extern.jbosslog.JBossLog", ConfigKey.LOG_JBOSSLOG_FLAG_USAGE, ConfigKey.LOG_FLAG_USAGE);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.extern.log4j.Log4j", ConfigKey.LOG_LOG4J_FLAG_USAGE, ConfigKey.LOG_FLAG_USAGE);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.extern.log4j.Log4j2", ConfigKey.LOG_LOG4J2_FLAG_USAGE, ConfigKey.LOG_FLAG_USAGE);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.extern.slf4j.Slf4j", ConfigKey.LOG_SLF4J_FLAG_USAGE, ConfigKey.LOG_FLAG_USAGE);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.extern.slf4j.XSlf4j", ConfigKey.LOG_XSLF4J_FLAG_USAGE, ConfigKey.LOG_FLAG_USAGE);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.AllArgsConstructor", ConfigKey.ALL_ARGS_CONSTRUCTOR_FLAG_USAGE, ConfigKey.ANY_CONSTRUCTOR_FLAG_USAGE);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.NoArgsConstructor", ConfigKey.NO_ARGS_CONSTRUCTOR_FLAG_USAGE, ConfigKey.ANY_CONSTRUCTOR_FLAG_USAGE);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.RequiredArgsConstructor", ConfigKey.REQUIRED_ARGS_CONSTRUCTOR_FLAG_USAGE, ConfigKey.ANY_CONSTRUCTOR_FLAG_USAGE);
                this.checkOnXAnnotationAndFlagUsage(psiAnnotation, "onConstructor", "lombok.NoArgsConstructor", "lombok.RequiredArgsConstructor", "lombok.AllArgsConstructor");
            }
        }

        public void visitMethod(@NotNull PsiMethod psiMethod) {
            if (psiMethod == null) {
                LombokFlagUsageElementVisitor.$$$reportNull$$$0(1);
            }
            for (PsiAnnotation psiAnnotation : psiMethod.getAnnotations()) {
                this.visitAnnotatedElement(psiAnnotation);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.SneakyThrows", ConfigKey.SNEAKY_THROWS_FLAG_USAGE);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.Synchronized", ConfigKey.SYNCHRONIZED_FLAG_USAGE);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.experimental.Tolerate", ConfigKey.EXPERIMENTAL_FLAG_USAGE);
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.Locked", ConfigKey.LOCKED_FLAG_USAGE);
            }
        }

        public void visitField(@NotNull PsiField psiField) {
            if (psiField == null) {
                LombokFlagUsageElementVisitor.$$$reportNull$$$0(2);
            }
            for (PsiAnnotation psiAnnotation : psiField.getAnnotations()) {
                this.visitAnnotatedElement(psiAnnotation);
            }
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                LombokFlagUsageElementVisitor.$$$reportNull$$$0(3);
            }
            for (PsiAnnotation psiAnnotation : variable.getAnnotations()) {
                this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.Cleanup", ConfigKey.CLEANUP_FLAG_USAGE);
            }
            this.checkValVarUsage((PsiVariable)variable);
        }

        public void visitParameter(@NotNull PsiParameter parameter) {
            if (parameter == null) {
                LombokFlagUsageElementVisitor.$$$reportNull$$$0(4);
            }
            this.checkValVarUsage((PsiVariable)parameter);
        }

        private void checkValVarUsage(@NotNull PsiVariable variable) {
            PsiTypeElement typeElement;
            PsiClass containingClass;
            if (variable == null) {
                LombokFlagUsageElementVisitor.$$$reportNull$$$0(5);
            }
            if ((containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiClass.class)) != null && (typeElement = variable.getTypeElement()) != null) {
                if (ValProcessor.isVal(variable)) {
                    this.checkFlagUsage((PsiElement)typeElement, "lombok.val", containingClass, ConfigKey.VAL_FLAG_USAGE, LocalQuickFix.from((ModCommandAction)new ReplaceValWithExplicitTypeIntentionAction()));
                }
                if (ValProcessor.isVar(variable)) {
                    this.checkFlagUsage((PsiElement)typeElement, "lombok.var", containingClass, ConfigKey.VAR_FLAG_USAGE, LocalQuickFix.from((ModCommandAction)new ReplaceValWithExplicitTypeIntentionAction()));
                }
            }
        }

        private void visitAnnotatedElement(@NotNull PsiAnnotation psiAnnotation) {
            if (psiAnnotation == null) {
                LombokFlagUsageElementVisitor.$$$reportNull$$$0(6);
            }
            this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.experimental.Accessors", ConfigKey.ACCESSORS_FLAG_USAGE, ConfigKey.EXPERIMENTAL_FLAG_USAGE);
            this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.experimental.WithBy", ConfigKey.WITHBY_FLAG_USAGE);
            this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.Builder", ConfigKey.BUILDER_FLAG_USAGE);
            this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.Delegate", ConfigKey.DELEGATE_FLAG_USAGE);
            this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.Getter", ConfigKey.GETTER_FLAG_USAGE);
            this.checkLazyGetterAnnotationAndFlagUsage(psiAnnotation);
            this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.extern.jackson.Jacksonized", ConfigKey.JACKSONIZED_FLAG_USAGE);
            this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.NonNull", ConfigKey.NONNULL_FLAG_USAGE);
            this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.Setter", ConfigKey.SETTER_FLAG_USAGE);
            this.checkAnnotationAndFlagUsage(psiAnnotation, "lombok.With", ConfigKey.WITH_FLAG_USAGE);
            this.checkOnXAnnotationAndFlagUsage(psiAnnotation, "onParam", "lombok.Setter");
            this.checkOnXAnnotationAndFlagUsage(psiAnnotation, "onMethod", "lombok.Getter", "lombok.Setter");
        }

        private void checkAnnotationAndFlagUsage(@NotNull PsiAnnotation annotation, @NotNull @NonNls String lombokAnnotationQualifiedName, ConfigKey ... flagUsageKeys) {
            if (annotation == null) {
                LombokFlagUsageElementVisitor.$$$reportNull$$$0(7);
            }
            if (lombokAnnotationQualifiedName == null) {
                LombokFlagUsageElementVisitor.$$$reportNull$$$0(8);
            }
            if (flagUsageKeys == null) {
                LombokFlagUsageElementVisitor.$$$reportNull$$$0(9);
            }
            if (!annotation.hasQualifiedName(lombokAnnotationQualifiedName)) {
                return;
            }
            PsiClass parentOfAnnotation = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiClass.class);
            if (parentOfAnnotation == null) {
                return;
            }
            for (ConfigKey flagUsageKey : flagUsageKeys) {
                this.checkFlagUsageKey(annotation, StringUtil.getShortName((String)lombokAnnotationQualifiedName), parentOfAnnotation, flagUsageKey);
            }
        }

        private void checkFlagUsageKey(@NotNull PsiAnnotation annotation, @NotNull String featureName, PsiClass parentOfAnnotation, ConfigKey flagUsageKey) {
            if (annotation == null) {
                LombokFlagUsageElementVisitor.$$$reportNull$$$0(10);
            }
            if (featureName == null) {
                LombokFlagUsageElementVisitor.$$$reportNull$$$0(11);
            }
            this.checkFlagUsage((PsiElement)annotation, featureName, parentOfAnnotation, flagUsageKey, new LocalQuickFix[]{new RemoveAnnotationQuickFix(annotation, null)});
        }

        private void checkFlagUsage(@NotNull PsiElement problemElement, @NotNull String featureName, PsiClass parentOfAnnotation, ConfigKey flagUsageKey, LocalQuickFix ... fixes) {
            String configProperty;
            if (problemElement == null) {
                LombokFlagUsageElementVisitor.$$$reportNull$$$0(12);
            }
            if (featureName == null) {
                LombokFlagUsageElementVisitor.$$$reportNull$$$0(13);
            }
            if (!(configProperty = ConfigDiscovery.getInstance().getStringLombokConfigProperty(flagUsageKey, parentOfAnnotation)).isEmpty() && !configProperty.equalsIgnoreCase("ALLOW")) {
                String msg = LombokBundle.message("inspection.message.use.flagged.lombok.annotation", featureName);
                if (configProperty.equalsIgnoreCase("ERROR")) {
                    this.holder.registerProblem(problemElement, msg, ProblemHighlightType.ERROR, fixes);
                } else if (configProperty.equalsIgnoreCase("WARNING")) {
                    this.holder.registerProblem(problemElement, msg, ProblemHighlightType.WARNING, fixes);
                }
            }
        }

        private void checkLazyGetterAnnotationAndFlagUsage(@NotNull PsiAnnotation psiAnnotation) {
            if (psiAnnotation == null) {
                LombokFlagUsageElementVisitor.$$$reportNull$$$0(14);
            }
            if (!psiAnnotation.hasQualifiedName("lombok.Getter")) {
                return;
            }
            if (!PsiAnnotationUtil.getBooleanAnnotationValue(psiAnnotation, "lazy", false)) {
                return;
            }
            PsiClass parentOfAnnotation = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiClass.class);
            if (parentOfAnnotation == null) {
                return;
            }
            this.checkFlagUsageKey(psiAnnotation, "Getter(lazy=true)", parentOfAnnotation, ConfigKey.GETTER_LAZY_FLAG_USAGE);
        }

        private void checkOnXAnnotationAndFlagUsage(@NotNull PsiAnnotation psiAnnotation, @NotNull String parameterName, String ... qualifiedNames) {
            if (psiAnnotation == null) {
                LombokFlagUsageElementVisitor.$$$reportNull$$$0(15);
            }
            if (parameterName == null) {
                LombokFlagUsageElementVisitor.$$$reportNull$$$0(16);
            }
            if (qualifiedNames == null) {
                LombokFlagUsageElementVisitor.$$$reportNull$$$0(17);
            }
            for (String qualifiedName : qualifiedNames) {
                if (!psiAnnotation.hasQualifiedName(qualifiedName)) continue;
                Iterable<String> annotationsToAdd = LombokProcessorUtil.getOnX(psiAnnotation, parameterName);
                if (!annotationsToAdd.iterator().hasNext()) break;
                PsiClass parentOfAnnotation = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiClass.class);
                if (parentOfAnnotation == null) {
                    return;
                }
                this.checkFlagUsageKey(psiAnnotation, String.format("%s(%s=...)", qualifiedName, parameterName), parentOfAnnotation, ConfigKey.ONX_FLAG_USAGE);
                break;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiMethod";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiField";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 6: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiAnnotation";
                    break;
                }
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotation";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lombokAnnotationQualifiedName";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flagUsageKeys";
                    break;
                }
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "featureName";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problemElement";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterName";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedNames";
                    break;
                }
            }
            objectArray2[1] = "de/plushnikov/intellij/plugin/inspection/LombokFlagUsageInspection$LombokFlagUsageElementVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLocalVariable";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParameter";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkValVarUsage";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAnnotatedElement";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkAnnotationAndFlagUsage";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkFlagUsageKey";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkFlagUsage";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkLazyGetterAnnotationAndFlagUsage";
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkOnXAnnotationAndFlagUsage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

