/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.visitors;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.attributes.DfaTuple;
import com.intellij.rml.dfa.impl.providers.RMLMutableInstancesProvider;
import com.intellij.rml.dfa.impl.relations.RelationSignature;
import com.intellij.rml.dfa.impl.relations.dump.Dump;
import com.intellij.rml.dfa.impl.relations.dump.RelationDump;
import com.intellij.rml.dfa.impl.relations.dump.RelationHandle;
import com.intellij.rml.dfa.impl.symtable.MutableSymbolTable;
import com.intellij.rml.dfa.impl.visitors.Visitor;
import com.intellij.rml.dfa.utils.Cancellation;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VisitorImpl
implements Visitor {
    private final RelationSignature[] outputRelations;
    private final RelationSignature[] allPossibleRelations;

    public VisitorImpl(List<RelationSignature> outputSignatures, List<RelationSignature> allPossibleSignatures) {
        this.outputRelations = outputSignatures.toArray(RelationSignature.EMPTY_ARRAY);
        this.allPossibleRelations = allPossibleSignatures.toArray(RelationSignature.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public String getName() {
        return "Relations visitor";
    }

    @Override
    public RelationSignature @NotNull [] getOutputRelations() {
        if (this.outputRelations == null) {
            VisitorImpl.$$$reportNull$$$0(0);
        }
        return this.outputRelations;
    }

    private Map<RelationSignature, RelationHandle> initRelations(@NotNull Dump dump) {
        if (dump == null) {
            VisitorImpl.$$$reportNull$$$0(1);
        }
        HashMap<RelationSignature, RelationHandle> map2 = new HashMap<RelationSignature, RelationHandle>();
        for (RelationSignature signature : this.getOutputRelations()) {
            map2.put(signature, dump.addRelation(signature));
        }
        return map2;
    }

    @Override
    public void collectAttributes(@NotNull List<DfaTuple> input, @NotNull MutableSymbolTable symbolTable, @NotNull Cancellation cancellation) {
        if (input == null) {
            VisitorImpl.$$$reportNull$$$0(2);
        }
        if (symbolTable == null) {
            VisitorImpl.$$$reportNull$$$0(3);
        }
        if (cancellation == null) {
            VisitorImpl.$$$reportNull$$$0(4);
        }
        Map<String, RelationSignature> signaturesMap = VisitorImpl.getSignaturesMap(this.allPossibleRelations);
        for (DfaTuple tuple : input) {
            List attributes = tuple.getAttributes();
            String relation = tuple.getRelation();
            RelationSignature signature = signaturesMap.get(relation);
            for (int i = 0; i < attributes.size(); ++i) {
                symbolTable.addAttribute((Attribute)attributes.get(i), signature.getType(i), "Relation", relation);
            }
        }
    }

    @Override
    public void collectRelations(@NotNull List<DfaTuple> input, @NotNull RMLMutableInstancesProvider provider, @NotNull Cancellation cancellation) {
        if (input == null) {
            VisitorImpl.$$$reportNull$$$0(5);
        }
        if (provider == null) {
            VisitorImpl.$$$reportNull$$$0(6);
        }
        if (cancellation == null) {
            VisitorImpl.$$$reportNull$$$0(7);
        }
        Map<String, RelationSignature> signaturesMap = VisitorImpl.getSignaturesMap(this.outputRelations);
        RelationDump dump = new RelationDump(provider);
        Map<RelationSignature, RelationHandle> result = this.initRelations(dump);
        for (DfaTuple tuple : input) {
            List attributes = tuple.getAttributes();
            RelationSignature signature = signaturesMap.get(tuple.getRelation());
            ArrayList<String> attributeKeys = new ArrayList<String>();
            for (Attribute attribute : attributes) {
                attributeKeys.add(attribute.getKey());
            }
            if (result.containsKey(signature)) {
                result.get(signature).addTuple(ArrayUtilRt.toStringArray(attributeKeys));
                continue;
            }
            throw new DfaInternalException("Unknown relation \"" + signature.getName() + "\"");
        }
        dump.copyToRepository(provider.getRelationsRepository());
    }

    @NotNull
    private static Map<String, RelationSignature> getSignaturesMap(RelationSignature[] signatures) {
        HashMap<String, RelationSignature> signaturesMap = new HashMap<String, RelationSignature>();
        for (RelationSignature relation : signatures) {
            signaturesMap.put(relation.getName(), relation);
        }
        HashMap<String, RelationSignature> hashMap = signaturesMap;
        if (hashMap == null) {
            VisitorImpl.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/rml/dfa/impl/visitors/VisitorImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dump";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolTable";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancellation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputRelations";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/rml/dfa/impl/visitors/VisitorImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignaturesMap";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initRelations";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectAttributes";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectRelations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

