/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.hash;

import com.intellij.indexing.shared.platform.hash.ArchiveData;
import com.intellij.indexing.shared.platform.hash.SharedIndexCrcArchiveHashKt;
import com.intellij.indexing.shared.util.VirtualFileCache;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.vfs.IntegrityCheckCapableFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0003\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/intellij/indexing/shared/platform/hash/ArchiveDataCache;", "Lcom/intellij/indexing/shared/util/VirtualFileCache;", "Lcom/intellij/indexing/shared/platform/hash/ArchiveData;", "<init>", "()V", "computeValue", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.indexing.shared"})
final class ArchiveDataCache
extends VirtualFileCache<ArchiveData> {
    public ArchiveDataCache() {
        super(true);
    }

    @Override
    @Nullable
    protected ArchiveData computeValue(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = SharedIndexCrcArchiveHashKt.getArchiveId(string);
        if (string2 == null) {
            return null;
        }
        String archiveId = string2;
        return new ArchiveData(archiveId, (Lazy<? extends Map<String, Long>>)LazyKt.lazy(() -> ArchiveDataCache.computeValue$lambda$0(file)));
    }

    private static final Map computeValue$lambda$0(VirtualFile $file) {
        VirtualFileSystem virtualFileSystem = $file.getFileSystem();
        Intrinsics.checkNotNull((Object)virtualFileSystem, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.IntegrityCheckCapableFileSystem");
        return ((IntegrityCheckCapableFileSystem)virtualFileSystem).getArchiveCrcHashes($file);
    }
}

