/*
 * Decompiled with CFR 0.152.
 */
package sun.net.httpserver;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import sun.net.httpserver.ExchangeImpl;
import sun.net.httpserver.LeftOverInputStream;
import sun.net.httpserver.StreamClosedException;
import sun.net.httpserver.WriteFinishedEvent;

class FixedLengthOutputStream
extends FilterOutputStream {
    private long remaining;
    private boolean eof = false;
    private boolean closed = false;
    ExchangeImpl t;

    FixedLengthOutputStream(ExchangeImpl exchangeImpl, OutputStream outputStream, long l) {
        super(outputStream);
        if (l < 0L) {
            throw new IllegalArgumentException("Content-Length: " + l);
        }
        this.t = exchangeImpl;
        this.remaining = l;
    }

    @Override
    public void write(int n) throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        boolean bl = this.eof = this.remaining == 0L;
        if (this.eof) {
            throw new StreamClosedException();
        }
        this.out.write(n);
        --this.remaining;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        boolean bl = this.eof = this.remaining == 0L;
        if (this.eof) {
            throw new StreamClosedException();
        }
        if ((long)n2 > this.remaining) {
            throw new IOException("too many bytes to write to stream");
        }
        this.out.write(byArray, n, n2);
        this.remaining -= (long)n2;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.remaining > 0L) {
            this.t.close();
            throw new IOException("insufficient bytes written to stream");
        }
        this.flush();
        this.eof = true;
        LeftOverInputStream leftOverInputStream = this.t.getOriginalInputStream();
        if (!leftOverInputStream.isClosed()) {
            try {
                leftOverInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        WriteFinishedEvent writeFinishedEvent = new WriteFinishedEvent(this.t);
        this.t.getHttpContext().getServerImpl().addEvent(writeFinishedEvent);
    }
}

