﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/clouddirectory/model/ListAttachedIndicesRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::CloudDirectory::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String ListAttachedIndicesRequest::SerializePayload() const {
  JsonValue payload;

  if (m_targetReferenceHasBeenSet) {
    payload.WithObject("TargetReference", m_targetReference.Jsonize());
  }

  if (m_nextTokenHasBeenSet) {
    payload.WithString("NextToken", m_nextToken);
  }

  if (m_maxResultsHasBeenSet) {
    payload.WithInteger("MaxResults", m_maxResults);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection ListAttachedIndicesRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  Aws::StringStream ss;
  if (m_directoryArnHasBeenSet) {
    ss << m_directoryArn;
    headers.emplace("x-amz-data-partition", ss.str());
    ss.str("");
  }

  if (m_consistencyLevelHasBeenSet && m_consistencyLevel != ConsistencyLevel::NOT_SET) {
    headers.emplace("x-amz-consistency-level", ConsistencyLevelMapper::GetNameForConsistencyLevel(m_consistencyLevel));
  }

  return headers;
}
