/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorageService;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorageManager;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.lang.Language;
import com.intellij.model.Pointer;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.database.SqlCommonTestUtilsCore;
import com.intellij.sql.database.SqlModelBuilder;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.containers.JBIterable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class SqlCommonTestUtils
extends SqlCommonTestUtilsCore {
    @TestOnly
    public static Map<BasicElement, Pointer<DasObject>> fillModelOnPooledThread(@NotNull Project project, DasModel model, boolean saveSources, boolean useReadOnlyPsi, String ... texts) {
        if (project == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(0);
        }
        if (texts == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(1);
        }
        Ref res2 = Ref.create();
        DbImplUtilCore.invokeOnPooledThreadSync(() -> DbImplUtilCore.performSrcOperation((Project)project, (DasModel)model, (ModalityState)ModalityState.nonModal(), (boolean)false, () -> ReadAction.run(() -> res2.set(SqlCommonTestUtils.fillModel(project, (BasicModModel)model, saveSources, useReadOnlyPsi, texts)))));
        return (Map)res2.get();
    }

    private static Map<BasicElement, Pointer<DasObject>> fillModel(@NotNull Project project, @NotNull BasicModModel model, boolean saveSources, boolean useReadOnlyPsi, String ... texts) {
        PsiErrorElement error;
        if (project == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(2);
        }
        if (model == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(3);
        }
        if (texts == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(4);
        }
        SqlLanguageDialect sqlDialect = DbSqlUtilCore.getSqlDialect((Dbms)model.getDbms());
        List files2 = JBIterable.of((Object[])texts).map(text -> useReadOnlyPsi ? SqlPsiFacade.getInstance((Project)project).createROFile(sqlDialect, (CharSequence)text) : (SqlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("a.sql", (Language)sqlDialect, (CharSequence)text)).toList();
        if (!useReadOnlyPsi && (error = (PsiErrorElement)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoots((Iterable)files2)).filter(PsiErrorElement.class).first()) != null) {
            throw new AssertionError((Object)(error.getContainingFile().getName() + ": " + error.getErrorDescription()));
        }
        SqlModelBuilder builder = new SqlModelBuilder(project, model, new HashMap(), null);
        builder.begin(saveSources);
        builder.introspect(files2, 0, true, -1L);
        builder.end();
        return builder.getMapping();
    }

    @TestOnly
    @NotNull
    public static LocalDataSource createDataSourceFromSql(@NotNull Project project, @NotNull Dbms dbms, boolean saveSources, String ... texts) {
        if (project == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(5);
        }
        if (dbms == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(6);
        }
        if (texts == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(7);
        }
        LocalDataSource dataSource = LocalDataSource.create((String)"test-data-source", null, null, null);
        dataSource.setDatabaseDriver(DbImplUtilCore.guessDatabaseDriver((Dbms)dbms));
        if (dataSource.getDatabaseDriver() == null) {
            throw new AssertionError((Object)("driver not found for " + dbms.getName()));
        }
        dataSource.setModel((DasModel)DbSrcModelStorageService.getInstance().createFactory(project, dataSource).createModel(dataSource.getDbms()));
        DataSourceStorage.getStorage().addDataSource(dataSource);
        SqlCommonTestUtils.fillModelOnPooledThread(project, dataSource.getModel(), saveSources, true, texts);
        SqlCommonTestUtils.updateScopeFromModel((LocalDataSource)dataSource);
        if (saveSources) {
            DbSrcStorageManager.getInstance(project).getStorage(dataSource.getUniqueId(), true).flushToFs(true);
        }
        LocalDataSource localDataSource = dataSource;
        if (localDataSource == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(8);
        }
        return localDataSource;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "texts";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlCommonTestUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlCommonTestUtils";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceFromSql";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillModelOnPooledThread";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fillModel";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceFromSql";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

