/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataBus;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.connection.throwable.info.SimpleErrorInfo;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.client.SessionClientHolder;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.model.DasObject;
import com.intellij.database.run.actions.CustomActionGroupWithPopup;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.actions.SubmitMutations;
import com.intellij.database.run.actions.TxIsolation;
import com.intellij.database.run.session.Session;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.DescriptionPopup;
import com.intellij.database.run.ui.GridDataSupport;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.roots.ui.configuration.actions.AlignedIconWithTextAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TransactionAction
extends DumbAwareAction
implements GridAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            TransactionAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        Dbms family;
        if (e == null) {
            TransactionAction.$$$reportNull$$$0(1);
        }
        DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        DataRequest.OwnerEx owner = TransactionAction.getRequestOwner(e);
        Dbms dbms = family = grid != null ? DataGridUtil.getDbms(grid) : TransactionAction.getDbms((DataRequest.Owner)owner);
        if (owner != null && family != null && DataSourceUtil.isTransactionsSupported(family)) {
            this.update(owner, e);
        } else {
            e.getPresentation().setVisible(grid != null && DataGridUtilCore.getDatabaseTable((CoreGrid)grid) != null && DataSourceUtil.isTransactionsSupported(family));
            e.getPresentation().setEnabled(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataRequest.OwnerEx owner;
        if (e == null) {
            TransactionAction.$$$reportNull$$$0(2);
        }
        if ((owner = TransactionAction.getRequestOwner(e)) == null) {
            return;
        }
        this.actionPerformed(owner, e);
    }

    @Nullable
    public static Dbms getDbms(@Nullable DataRequest.Owner owner) {
        return DbImplUtil.getDbms(owner);
    }

    private static void stopEditingIfNecessary(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            TransactionAction.$$$reportNull$$$0(3);
        }
        if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null && !dataGrid.stopEditing()) {
            dataGrid.cancelEditing();
        }
    }

    @Nullable
    private static DasObject getTable(@NotNull DataRequest.OwnerEx owner) {
        if (owner == null) {
            TransactionAction.$$$reportNull$$$0(4);
        }
        return owner instanceof DatabaseGridDataHookUp ? ((DatabaseGridDataHookUp)owner).getDatabaseTable() : null;
    }

    private static void switchIsolationLevel(@NotNull AnActionEvent e, @NotNull DataRequest.OwnerEx owner, @NotNull TxIsolation isolation) {
        if (e == null) {
            TransactionAction.$$$reportNull$$$0(5);
        }
        if (owner == null) {
            TransactionAction.$$$reportNull$$$0(6);
        }
        if (isolation == null) {
            TransactionAction.$$$reportNull$$$0(7);
        }
        String okMessage = DatabaseBundle.message((String)"notification.content.transaction.isolation.level.switched.to", (Object[])new Object[]{StringUtil.toLowerCase((String)isolation.getName())});
        String failMessage = DatabaseBundle.message((String)"notification.content.transaction.isolation.level.can.not.be.switched", (Object[])new Object[0]);
        TransactionAction.performTxSettingsAction(e, owner, okMessage, failMessage, () -> {
            if (owner instanceof DataRequest.TxIsolationOwner) {
                DataRequest.TxIsolationOwner txOwner = (DataRequest.TxIsolationOwner)owner;
                txOwner.setTxIsolation(isolation.getIsolation());
            }
        });
    }

    private static void selectTxMode(@NotNull AnActionEvent e, @NotNull DataRequest.OwnerEx owner, boolean auto) {
        if (e == null) {
            TransactionAction.$$$reportNull$$$0(8);
        }
        if (owner == null) {
            TransactionAction.$$$reportNull$$$0(9);
        }
        String mode = StringUtil.toLowerCase((String)(auto ? DatabaseBundle.message((String)"transaction.mode.auto", (Object[])new Object[0]) : DatabaseBundle.message((String)"transaction.mode.manual", (Object[])new Object[0])));
        String okMessage = DatabaseBundle.message((String)"notification.content.transaction.mode.on", (Object[])new Object[]{mode});
        String failMessage = DatabaseBundle.message((String)"notification.content.transaction.mode.can.not.be.changed", (Object[])new Object[0]);
        TransactionAction.performTxSettingsAction(e, owner, okMessage, failMessage, () -> owner.setAutoCommit(auto));
    }

    private static void performTxSettingsAction(@NotNull AnActionEvent e, @NotNull DataRequest.OwnerEx owner, @NlsSafe @NotNull String okMessage, @NlsSafe @NotNull String failMessage, @NotNull Runnable action) {
        if (e == null) {
            TransactionAction.$$$reportNull$$$0(10);
        }
        if (owner == null) {
            TransactionAction.$$$reportNull$$$0(11);
        }
        if (okMessage == null) {
            TransactionAction.$$$reportNull$$$0(12);
        }
        if (failMessage == null) {
            TransactionAction.$$$reportNull$$$0(13);
        }
        if (action == null) {
            TransactionAction.$$$reportNull$$$0(14);
        }
        TransactionAction.stopEditingIfNecessary(e);
        DataAuditor auditor = DataBus.shortCircuit((DataBus.Consuming)owner.getMessageBus()).getDataAuditor();
        DataRequest.Context context = DataRequest.newContext((DataRequest.OwnerEx)owner, null, (String)"");
        if (TransactionAction.canPerformTxSettingsAction(owner)) {
            action.run();
            auditor.print(context, okMessage);
        } else {
            auditor.error(context, SimpleErrorInfo.create((String)failMessage));
        }
    }

    @Nullable
    private static DataRequest.OwnerEx getRequestOwner(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            TransactionAction.$$$reportNull$$$0(15);
        }
        if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null) {
            return dataGrid.isEditable() ? DataGridUtil.getDataBusHookUp(dataGrid) : null;
        }
        JdbcConsole console = JdbcConsole.findConsole(e);
        if (console != null) {
            return console;
        }
        VisibleDatabaseSessionClient client = (VisibleDatabaseSessionClient)ObjectUtils.tryCast((Object)e.getData(SessionClientHolder.CLIENT_KEY), VisibleDatabaseSessionClient.class);
        if (client != null) {
            return client.isValid() ? client : null;
        }
        return (DataRequest.OwnerEx)ObjectUtils.tryCast((Object)e.getData(Session.SESSION_KEY), DatabaseSession.class);
    }

    @Nullable
    private static DataRequest.TxIsolationOwner getTxIsolationOwner(@NotNull AnActionEvent e) {
        if (e == null) {
            TransactionAction.$$$reportNull$$$0(16);
        }
        return (DataRequest.TxIsolationOwner)ObjectUtils.tryCast((Object)TransactionAction.getRequestOwner(e), DataRequest.TxIsolationOwner.class);
    }

    @Nullable
    private static DatabaseSession getSession(@NotNull DataRequest.OwnerEx owner) {
        if (owner == null) {
            TransactionAction.$$$reportNull$$$0(17);
        }
        if (owner instanceof DatabaseSession) {
            return (DatabaseSession)owner;
        }
        if (owner instanceof DatabaseSessionClient) {
            return (DatabaseSession)((DatabaseSessionClient)owner).getSession();
        }
        return null;
    }

    @Nullable
    private static JComponent getComponent(AnActionEvent e) {
        return (JComponent)e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY);
    }

    protected abstract void actionPerformed(@NotNull DataRequest.OwnerEx var1, @NotNull AnActionEvent var2);

    protected abstract void update(@NotNull DataRequest.OwnerEx var1, AnActionEvent var2);

    private static boolean canPerformTxSettingsAction(@NotNull DataRequest.OwnerEx owner) {
        if (owner == null) {
            TransactionAction.$$$reportNull$$$0(18);
        }
        if (TransactionAction.canOwnTx(owner)) {
            return false;
        }
        DatabaseSession session = TransactionAction.getSession(owner);
        return session != null && session.isIdle();
    }

    private static boolean canChangeTx(@NotNull DataRequest.OwnerEx owner) {
        DataRequest.TxMarker marker;
        DataRequest.Owner txOwner;
        if (owner == null) {
            TransactionAction.$$$reportNull$$$0(19);
        }
        return (txOwner = (marker = owner.getCurrentTx()).getOwner()) == null || TransactionAction.canOwnTx(owner);
    }

    private static boolean canOwnTx(@NotNull DataRequest.OwnerEx owner) {
        DataRequest.TxMarker marker;
        DataRequest.Owner txOwner;
        if (owner == null) {
            TransactionAction.$$$reportNull$$$0(20);
        }
        return (txOwner = (marker = owner.getCurrentTx()).getOwner()) == owner || txOwner instanceof DataRequest.OwnerEx && ((DataRequest.OwnerEx)txOwner).isChildOf((DataRequest.Owner)owner) || marker == DataRequest.IN_PROGRESS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/TransactionAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolation";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "okMessage";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failMessage";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/TransactionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "stopEditingIfNecessary";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "switchIsolationLevel";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "selectTxMode";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "performTxSettingsAction";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRequestOwner";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTxIsolationOwner";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSession";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "canPerformTxSettingsAction";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "canChangeTx";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "canOwnTx";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20 -> new IllegalArgumentException(string);
        };
    }

    public static abstract class PreferencesUserActivityWrapper
    extends JPanel
    implements UserActivityProviderComponent,
    DescriptionPopup.TxPopup.TxSelector {
        private final List<ChangeListener> myListeners;

        public PreferencesUserActivityWrapper(@NotNull JComponent component) {
            if (component == null) {
                PreferencesUserActivityWrapper.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            this.myListeners = new ArrayList<ChangeListener>();
            this.add((Component)component, "Center");
            component.setBorder((Border)JBUI.Borders.empty());
        }

        @NotNull
        protected abstract DescriptionPopup.TxPopup.TxSelector getSelector();

        public void addChangeListener(@NotNull ChangeListener changeListener) {
            if (changeListener == null) {
                PreferencesUserActivityWrapper.$$$reportNull$$$0(1);
            }
            this.myListeners.add(changeListener);
        }

        public void removeChangeListener(@NotNull ChangeListener changeListener) {
            if (changeListener == null) {
                PreferencesUserActivityWrapper.$$$reportNull$$$0(2);
            }
            this.myListeners.remove(changeListener);
        }

        @Override
        public void toggle(@Nullable AnActionEvent e, boolean auto) {
            this.getSelector().toggle(e, auto);
            this.fireUpdate();
        }

        @Override
        public boolean isAuto() {
            return this.getSelector().isAuto();
        }

        private void fireStateChanged() {
            ChangeEvent event = new ChangeEvent(this);
            this.myListeners.forEach(l -> l.stateChanged(event));
        }

        protected void fireUpdate() {
            ActionToolbar toolbar = ActionToolbar.findToolbarBy((Component)this);
            if (toolbar != null) {
                toolbar.updateActionsImmediately();
            }
            this.fireStateChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeListener";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$PreferencesUserActivityWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addChangeListener";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeChangeListener";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class PreferencesTxModeAction
    extends AlignedIconWithTextAction.Group
    implements DumbAware {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                PreferencesTxModeAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        @NotNull
        public abstract DescriptionPopup.TxPopup.TxSelector getSelector();

        @NotNull
        protected abstract PreferencesUserActivityWrapper createActivityWrapper(@NotNull JComponent var1);

        @Nullable
        protected abstract DescriptionPopup.TxPopup createPopup(@NotNull PreferencesUserActivityWrapper var1);

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                PreferencesTxModeAction.$$$reportNull$$$0(1);
            }
            Presentation presentation = e.getPresentation();
            String text = this.getSelector().isAuto() ? DatabaseBundle.message((String)"transaction.mode.auto", (Object[])new Object[0]) : DatabaseBundle.message((String)"transaction.mode.manual", (Object[])new Object[0]);
            presentation.setEnabledAndVisible(true);
            presentation.setText(text);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PreferencesUserActivityWrapper activityWrapper;
            if (e == null) {
                PreferencesTxModeAction.$$$reportNull$$$0(2);
            }
            if ((activityWrapper = (PreferencesUserActivityWrapper)ObjectUtils.tryCast((Object)TransactionAction.getComponent(e), PreferencesUserActivityWrapper.class)) == null) {
                return;
            }
            DescriptionPopup.TxPopup popup2 = this.createPopup(activityWrapper);
            if (popup2 == null) {
                return;
            }
            popup2.build(e.getDataContext()).showUnderneathOf((Component)activityWrapper);
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            if (presentation == null) {
                PreferencesTxModeAction.$$$reportNull$$$0(3);
            }
            if (place == null) {
                PreferencesTxModeAction.$$$reportNull$$$0(4);
            }
            JComponent component = super.createCustomComponent(presentation, place);
            PreferencesUserActivityWrapper preferencesUserActivityWrapper = this.createActivityWrapper(component);
            if (preferencesUserActivityWrapper == null) {
                PreferencesTxModeAction.$$$reportNull$$$0(5);
            }
            return preferencesUserActivityWrapper;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/TransactionAction$PreferencesTxModeAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$PreferencesTxModeAction";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCustomComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createCustomComponent";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    static final class RevertAndRollbackAction
    extends GridTransactionAction {
        RevertAndRollbackAction() {
        }

        @Override
        @NotNull
        ActionCallback prepareGrid(@NotNull AnActionEvent e, @NotNull DataGrid grid) {
            GridDataSupport support;
            if (e == null) {
                RevertAndRollbackAction.$$$reportNull$$$0(0);
            }
            if (grid == null) {
                RevertAndRollbackAction.$$$reportNull$$$0(1);
            }
            if (!(support = grid.getDataSupport()).hasPendingChanges()) {
                ActionCallback actionCallback = ActionCallback.DONE;
                if (actionCallback == null) {
                    RevertAndRollbackAction.$$$reportNull$$$0(2);
                }
                return actionCallback;
            }
            GridModel model = grid.getDataModel(DataAccessType.DATABASE_DATA);
            ModelIndexSet rows = model.getRowIndices();
            ModelIndexSet columns = model.getColumnIndices();
            support.revert(rows, columns);
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                RevertAndRollbackAction.$$$reportNull$$$0(3);
            }
            return actionCallback;
        }

        @Override
        boolean isEnabledWithoutTx(@NotNull AnActionEvent e, @NotNull DataRequest.OwnerEx owner) {
            if (e == null) {
                RevertAndRollbackAction.$$$reportNull$$$0(4);
            }
            if (owner == null) {
                RevertAndRollbackAction.$$$reportNull$$$0(5);
            }
            return false;
        }

        @Override
        protected void performTxAction(@NotNull DataRequest.OwnerEx owner) {
            if (owner == null) {
                RevertAndRollbackAction.$$$reportNull$$$0(6);
            }
            GridDataRequest request2 = DataRequest.newTxRollback((DataRequest.OwnerEx)owner);
            owner.getMessageBus().getDataProducer().processRequest(request2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/TransactionAction$RevertAndRollbackAction";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$RevertAndRollbackAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepareGrid";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareGrid";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabledWithoutTx";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "performTxAction";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    static final class SubmitAndCommitAction
    extends GridTransactionAction {
        SubmitAndCommitAction() {
        }

        @Override
        @NotNull
        ActionCallback prepareGrid(@NotNull AnActionEvent e, @NotNull DataGrid grid) {
            if (e == null) {
                SubmitAndCommitAction.$$$reportNull$$$0(0);
            }
            if (grid == null) {
                SubmitAndCommitAction.$$$reportNull$$$0(1);
            }
            ActionCallback actionCallback = SubmitMutations.submitChangesIfExists(e);
            if (actionCallback == null) {
                SubmitAndCommitAction.$$$reportNull$$$0(2);
            }
            return actionCallback;
        }

        @Override
        boolean isEnabledWithoutTx(@NotNull AnActionEvent e, @NotNull DataRequest.OwnerEx owner) {
            if (e == null) {
                SubmitAndCommitAction.$$$reportNull$$$0(3);
            }
            if (owner == null) {
                SubmitAndCommitAction.$$$reportNull$$$0(4);
            }
            return owner.getCurrentTx() == DataRequest.START_NEW && SubmitMutations.hasChangesToSubmit(e);
        }

        @Override
        protected void performTxAction(@NotNull DataRequest.OwnerEx owner) {
            if (owner == null) {
                SubmitAndCommitAction.$$$reportNull$$$0(5);
            }
            GridDataRequest request2 = DataRequest.newTxCommit((DataRequest.OwnerEx)owner);
            owner.getMessageBus().getDataProducer().processRequest(request2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/TransactionAction$SubmitAndCommitAction";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$SubmitAndCommitAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepareGrid";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareGrid";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabledWithoutTx";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "performTxAction";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static abstract class GridTransactionAction
    extends TransactionAction {
        private GridTransactionAction() {
        }

        @Override
        protected void actionPerformed(@NotNull DataRequest.OwnerEx owner, @NotNull AnActionEvent e) {
            if (owner == null) {
                GridTransactionAction.$$$reportNull$$$0(0);
            }
            if (e == null) {
                GridTransactionAction.$$$reportNull$$$0(1);
            }
            TransactionAction.stopEditingIfNecessary(e);
            DataGrid grid = GridUtil.getDataGrid((DataContext)e.getDataContext());
            if (grid == null) {
                return;
            }
            this.prepareGrid(e, grid).doWhenDone(() -> this.performTxAction(owner));
        }

        @Override
        protected void update(@NotNull DataRequest.OwnerEx owner, AnActionEvent e) {
            if (owner == null) {
                GridTransactionAction.$$$reportNull$$$0(2);
            }
            DataGrid grid = GridUtil.getDataGrid((DataContext)e.getDataContext());
            boolean isGrid = owner instanceof DatabaseGridDataHookUp && grid != null;
            boolean enabled = isGrid && (TransactionAction.canOwnTx(owner) || this.isEnabledWithoutTx(e, owner));
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(isGrid && (enabled || owner.getCurrentTx() != DataRequest.AUTO_COMMIT));
        }

        @NotNull
        abstract ActionCallback prepareGrid(@NotNull AnActionEvent var1, @NotNull DataGrid var2);

        abstract boolean isEnabledWithoutTx(@NotNull AnActionEvent var1, @NotNull DataRequest.OwnerEx var2);

        protected abstract void performTxAction(@NotNull DataRequest.OwnerEx var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$GridTransactionAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class RollbackAction
    extends NonGridTxAction {
        RollbackAction() {
        }

        @Override
        protected void actionPerformed(@NotNull DataRequest.OwnerEx owner, @NotNull AnActionEvent e) {
            if (owner == null) {
                RollbackAction.$$$reportNull$$$0(0);
            }
            if (e == null) {
                RollbackAction.$$$reportNull$$$0(1);
            }
            GridDataRequest request2 = DataRequest.newTxRollback((DataRequest.OwnerEx)owner);
            owner.getMessageBus().getDataProducer().processRequest(request2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/TransactionAction$RollbackAction";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class CommitAction
    extends NonGridTxAction {
        CommitAction() {
        }

        @Override
        protected void actionPerformed(@NotNull DataRequest.OwnerEx owner, @NotNull AnActionEvent e) {
            if (owner == null) {
                CommitAction.$$$reportNull$$$0(0);
            }
            if (e == null) {
                CommitAction.$$$reportNull$$$0(1);
            }
            TransactionAction.stopEditingIfNecessary(e);
            GridDataRequest request2 = DataRequest.newTxCommit((DataRequest.OwnerEx)owner);
            owner.getMessageBus().getDataProducer().processRequest(request2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/TransactionAction$CommitAction";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class NonGridTxAction
    extends TransactionAction {
        private NonGridTxAction() {
        }

        @Override
        protected void update(@NotNull DataRequest.OwnerEx owner, AnActionEvent e) {
            if (owner == null) {
                NonGridTxAction.$$$reportNull$$$0(0);
            }
            boolean isGrid = GridUtil.getDataGrid((DataContext)e.getDataContext()) != null;
            boolean enabled = !isGrid && TransactionAction.canOwnTx(owner);
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(!isGrid && (enabled || owner.getCurrentTx() != DataRequest.AUTO_COMMIT));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/run/actions/TransactionAction$NonGridTxAction", "update"));
        }
    }

    private static abstract class SetTxModeAction
    extends CheckboxAction
    implements DumbAware {
        private final boolean myAuto;

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                SetTxModeAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        private SetTxModeAction(@NlsActions.ActionText @NotNull String text, @NlsActions.ActionDescription @NotNull String description, boolean auto) {
            if (text == null) {
                SetTxModeAction.$$$reportNull$$$0(1);
            }
            if (description == null) {
                SetTxModeAction.$$$reportNull$$$0(2);
            }
            super(text, description, null);
            this.myAuto = auto;
        }

        public void update(@NotNull AnActionEvent e) {
            DataRequest.OwnerEx owner;
            if (e == null) {
                SetTxModeAction.$$$reportNull$$$0(3);
            }
            boolean visible = (owner = TransactionAction.getRequestOwner(e)) != null && TransactionAction.canChangeTx(owner);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && TransactionAction.canPerformTxSettingsAction(owner));
            super.update(e);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            DataRequest.OwnerEx owner;
            if (e == null) {
                SetTxModeAction.$$$reportNull$$$0(4);
            }
            return (owner = TransactionAction.getRequestOwner(e)) != null && this.isSelected(owner);
        }

        protected abstract boolean isSelected(DataRequest.OwnerEx var1);

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                SetTxModeAction.$$$reportNull$$$0(5);
            }
            DataRequest.OwnerEx owner = TransactionAction.getRequestOwner(e);
            if (!state || owner == null) {
                return;
            }
            TransactionAction.selectTxMode(Objects.requireNonNull(e), owner, this.myAuto);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/TransactionAction$SetTxModeAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$SetTxModeAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class TxSettingsActionGroup
    extends CustomActionGroupWithPopup<DataRequest.OwnerEx> {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                TxSettingsActionGroup.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public TxSettingsActionGroup() {
            this.add((AnAction)new SetTxModeAction(DatabaseBundle.message((String)"transaction.mode.auto", (Object[])new Object[0]), DatabaseBundle.message((String)"transaction.mode.auto.description", (Object[])new Object[0]), true){

                @Override
                protected boolean isSelected(DataRequest.OwnerEx owner) {
                    return owner.getCurrentTx() == DataRequest.AUTO_COMMIT;
                }
            });
            this.add((AnAction)new SetTxModeAction(DatabaseBundle.message((String)"transaction.mode.manual", (Object[])new Object[0]), DatabaseBundle.message((String)"transaction.mode.manual.description", (Object[])new Object[0]), false){

                @Override
                protected boolean isSelected(DataRequest.OwnerEx owner) {
                    return owner.getCurrentTx() != DataRequest.AUTO_COMMIT;
                }
            });
        }

        @Override
        @Nullable
        protected DataRequest.OwnerEx getOwner(@NotNull AnActionEvent e) {
            if (e == null) {
                TxSettingsActionGroup.$$$reportNull$$$0(1);
            }
            return TransactionAction.getRequestOwner(e);
        }

        public void update(@NotNull AnActionEvent e) {
            boolean enabled;
            if (e == null) {
                TxSettingsActionGroup.$$$reportNull$$$0(2);
            }
            DataRequest.OwnerEx owner = TransactionAction.getRequestOwner(e);
            Presentation presentation = e.getPresentation();
            DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
            Dbms family = grid != null ? DataGridUtil.getDbms(grid) : TransactionAction.getDbms((DataRequest.Owner)owner);
            boolean transactionsSupported = family == null || DataSourceUtil.isTransactionsSupported(family);
            boolean visible = transactionsSupported && owner != null && TransactionAction.canChangeTx(owner);
            boolean bl = enabled = visible && TransactionAction.canPerformTxSettingsAction(owner);
            if (owner == null) {
                owner = DataGridUtil.getDataBusHookUp(grid);
                visible = transactionsSupported && owner != null && DataGridUtilCore.getDatabaseTable((CoreGrid)grid) != null;
            }
            presentation.setVisible(visible);
            if (!visible) {
                return;
            }
            presentation.setEnabled(enabled);
            String mode = owner.getCurrentTx() == DataRequest.AUTO_COMMIT ? DatabaseBundle.message((String)"transaction.mode.auto", (Object[])new Object[0]) : DatabaseBundle.message((String)"transaction.mode.manual", (Object[])new Object[0]);
            String text = e.isFromActionToolbar() ? DatabaseBundle.message((String)"action.tx.text", (Object[])new Object[]{mode}) : DatabaseBundle.message((String)"action.tx.mode.text", (Object[])new Object[]{mode});
            presentation.setText(text);
        }

        @Override
        @NotNull
        protected JBPopup getPopup(final @NotNull DataRequest.OwnerEx owner, @NotNull DataContext context) {
            if (owner == null) {
                TxSettingsActionGroup.$$$reportNull$$$0(3);
            }
            if (context == null) {
                TxSettingsActionGroup.$$$reportNull$$$0(4);
            }
            DasObject table = TransactionAction.getTable(owner);
            Dbms family = TransactionAction.getDbms((DataRequest.Owner)owner);
            final DataRequest.TxIsolationOwner txOwner = (DataRequest.TxIsolationOwner)ObjectUtils.tryCast((Object)owner, DataRequest.TxIsolationOwner.class);
            JBPopup jBPopup = new DescriptionPopup.TxSettingsPopup(TxSettingsActionGroup.getAvailableLevels(txOwner, family, table), new DescriptionPopup.TxPopup.TxIsolationSelector(){

                @Override
                public boolean isSelected(@NotNull TxIsolation isolation) {
                    if (isolation == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return Objects.requireNonNull(txOwner).getTxIsolation() == isolation.getIsolation();
                }

                @Override
                public void select(@NotNull TxIsolation isolation, AnActionEvent e) {
                    if (isolation == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    TransactionAction.switchIsolationLevel(Objects.requireNonNull(e), (DataRequest.OwnerEx)Objects.requireNonNull(txOwner), isolation);
                }

                @Override
                public void toggle(@Nullable AnActionEvent e, boolean auto) {
                    TransactionAction.selectTxMode(Objects.requireNonNull(e), owner, auto);
                }

                @Override
                public boolean isAuto() {
                    return owner.getCurrentTx() == DataRequest.AUTO_COMMIT;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "isolation";
                    objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$TxSettingsActionGroup$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isSelected";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "select";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }).build(context);
            if (jBPopup == null) {
                TxSettingsActionGroup.$$$reportNull$$$0(5);
            }
            return jBPopup;
        }

        @NotNull
        private static List<TxIsolation> getAvailableLevels(@Nullable DataRequest.TxIsolationOwner owner, @Nullable Dbms id, @Nullable DasObject table) {
            List list = id != null && owner != null && TxIsolation.levelsSupported((Dbms)id) ? ContainerUtil.filter((Object[])TxIsolation.values(), isolation -> isolation.isSupported(id, table)) : ContainerUtil.emptyList();
            if (list == null) {
                TxSettingsActionGroup.$$$reportNull$$$0(6);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/TransactionAction$TxSettingsActionGroup";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$TxSettingsActionGroup";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPopup";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAvailableLevels";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getOwner";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getPopup";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class IsolationLevelAction
    extends CheckboxAction
    implements DumbAware {
        private final TxIsolation myIsolation;

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                IsolationLevelAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        private IsolationLevelAction(@NotNull TxIsolation isolation) {
            if (isolation == null) {
                IsolationLevelAction.$$$reportNull$$$0(1);
            }
            super(isolation.getName(), StringUtil.removeHtmlTags((String)isolation.getDescription()), null);
            this.myIsolation = isolation;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                IsolationLevelAction.$$$reportNull$$$0(2);
            }
            DataRequest.TxIsolationOwner owner = TransactionAction.getTxIsolationOwner(e);
            Dbms family = TransactionAction.getDbms((DataRequest.Owner)owner);
            boolean visible = owner != null && family != null && this.myIsolation.isSupported(family, TransactionAction.getTable((DataRequest.OwnerEx)owner));
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && TransactionAction.canPerformTxSettingsAction((DataRequest.OwnerEx)owner));
            super.update(e);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            DataRequest.TxIsolationOwner owner;
            if (e == null) {
                IsolationLevelAction.$$$reportNull$$$0(3);
            }
            return (owner = TransactionAction.getTxIsolationOwner(e)) != null && owner.getTxIsolation() == this.myIsolation.getIsolation();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                IsolationLevelAction.$$$reportNull$$$0(4);
            }
            DataRequest.TxIsolationOwner owner = TransactionAction.getTxIsolationOwner(e);
            if (!state || owner == null) {
                return;
            }
            TransactionAction.switchIsolationLevel(e, (DataRequest.OwnerEx)owner, this.myIsolation);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/TransactionAction$IsolationLevelAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isolation";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$IsolationLevelAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class ChangeIsolationLevelActionGroup
    extends DefaultActionGroup
    implements DumbAware {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ChangeIsolationLevelActionGroup.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public ChangeIsolationLevelActionGroup() {
            this.setPopup(true);
            for (TxIsolation isolation : TxIsolation.values()) {
                this.add((AnAction)new IsolationLevelAction(isolation));
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ChangeIsolationLevelActionGroup.$$$reportNull$$$0(1);
            }
            DataRequest.TxIsolationOwner owner = TransactionAction.getTxIsolationOwner(e);
            Dbms family = TransactionAction.getDbms((DataRequest.Owner)owner);
            boolean visible = owner != null && family != null && DataSourceUtil.isTransactionsSupported(family) && TxIsolation.levelsSupported((Dbms)family);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && TransactionAction.canPerformTxSettingsAction((DataRequest.OwnerEx)owner));
            if (visible && e.isFromContextMenu()) {
                e.getPresentation().setText(DatabaseBundle.messagePointer((String)"action.tx.isolation.text", (Object[])new Object[]{TxIsolation.of((int)owner.getTxIsolation()).getName()}));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/TransactionAction$ChangeIsolationLevelActionGroup";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$ChangeIsolationLevelActionGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

