/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template;

import com.intellij.jinja.template.DjangoTemplateFileViewProvider;
import com.intellij.jinja.template.DjangoTemplateLanguage;
import com.intellij.jinja.template.tags.Jinja2BlockTag;
import com.intellij.lang.Language;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.DefaultXmlExtension;
import com.jetbrains.django.util.DjangoPsiUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoXmlExtension
extends DefaultXmlExtension {
    public SchemaPrefix getPrefixDeclaration(@Nullable XmlTag context, String namespacePrefix) {
        SchemaPrefix prefix = super.getPrefixDeclaration(context, namespacePrefix);
        if (prefix != null) {
            return prefix;
        }
        if (context == null) {
            return null;
        }
        return this.findPrefixDeclaration(context, namespacePrefix);
    }

    @Nullable
    private SchemaPrefix findPrefixDeclaration(@NotNull XmlTag context, String prefix) {
        if (context == null) {
            DjangoXmlExtension.$$$reportNull$$$0(0);
        }
        PsiFile file = context.getContainingFile();
        FileViewProvider viewProvider = file.getViewProvider();
        PsiElement tag = viewProvider.findElementAt(context.getTextOffset(), (Language)DjangoTemplateLanguage.INSTANCE);
        return this.findBlockTagAndResolveToIt(tag, prefix, new HashSet<Jinja2BlockTag>());
    }

    @Nullable
    private SchemaPrefix findBlockTagAndResolveToIt(PsiElement tag, String prefix, Set<Jinja2BlockTag> blocksSet) {
        Jinja2BlockTag block = DjangoPsiUtil.findOpeningBlock((PsiElement)tag);
        if (block != null) {
            return this.findPrefixFromBlockDeclaration(block, prefix, blocksSet);
        }
        return null;
    }

    @Nullable
    private SchemaPrefix findPrefixFromBlockDeclaration(Jinja2BlockTag block, String prefix, Set<Jinja2BlockTag> blocksSet) {
        PsiElement injection;
        PsiElement el;
        if (blocksSet.contains(block)) {
            return null;
        }
        blocksSet.add(block);
        PsiReference ref = block.getReference();
        if (ref != null && (el = ref.resolve()) != null && (injection = DjangoPsiUtil.findContainingElementInTemplateDataLanguage((PsiElement)el)) != null) {
            SchemaPrefix result = super.getPrefixDeclaration((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)injection, XmlTag.class), prefix);
            if (result != null) {
                return result;
            }
            return this.findBlockTagAndResolveToIt(DjangoPsiUtil.prevFromTag((PsiElement)el), prefix, blocksSet);
        }
        return null;
    }

    public boolean isAvailable(PsiFile file) {
        return file.getViewProvider() instanceof DjangoTemplateFileViewProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/python/django/lang/template/DjangoXmlExtension", "findPrefixDeclaration"));
    }
}

