/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssPropertyValue;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.completion.CssCompletionUtil;
import com.intellij.psi.css.impl.util.table.CssLookupValue;
import com.intellij.psi.css.impl.util.table.CssPropertyValueImpl;
import com.intellij.psi.css.impl.util.table.CssTableValue;
import com.intellij.psi.css.index.CssIndex;
import com.intellij.psi.css.index.CssIndexValue;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.xml.util.ColorMap;
import com.intellij.xml.util.ColorSampleLookupValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssColorValue
extends CssLookupValue {
    private final boolean myAllColorKeywordsKnown;

    public CssColorValue() {
        this(true);
    }

    public CssColorValue(boolean allColorKeywordsKnown) {
        super(CssTableValue.Type.OR, CssTermTypes.COLOR);
        this.myAllColorKeywordsKnown = allColorKeywordsKnown;
        this.addChild(new CssPropertyValueImpl(CssCompletionUtil.lookupForUserColorLookup()));
        for (ColorSampleLookupValue color : ColorSampleLookupValue.getColors()) {
            if (ColorMap.isSystemColorName((String)StringUtil.toLowerCase((String)color.getName()))) continue;
            if (this.myAllColorKeywordsKnown) {
                String colorName = color.getName();
                this.addChild(new MyCssPropertyValueImpl(new ColorSampleLookupValue(colorName, color.getValue(), true)));
                continue;
            }
            this.addChild(new MyCssPropertyValueImpl(color));
        }
    }

    @Override
    @NotNull
    public List<? extends CssPropertyValue> getDynamicVariants(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            CssColorValue.$$$reportNull$$$0(0);
        }
        List children = this.getChildren();
        Set<String> popularColors = CssColorValue.getPopularColors(contextElement);
        ASTNode contextElementNode = contextElement.getNode();
        boolean afterSharp = contextElementNode != null && contextElementNode.getElementType() == CssElementTypes.CSS_HASH;
        HashMap<String, String> popularColorNames = afterSharp ? null : new HashMap<String, String>(popularColors.size());
        ArrayList<CssPropertyValue> result = new ArrayList<CssPropertyValue>(children.size() + popularColors.size());
        for (CssPropertyValue propertyValue : children) {
            String colorName;
            ColorSampleLookupValue cslValue;
            String hashValue;
            Object variant;
            if (popularColorNames != null && (variant = propertyValue.getValue()) instanceof ColorSampleLookupValue && popularColors.contains(hashValue = (cslValue = (ColorSampleLookupValue)variant).getValue()) && (colorName = cslValue.getName()) != null) {
                popularColorNames.put(hashValue, colorName);
                continue;
            }
            result.add(propertyValue);
        }
        for (String colorHash : popularColors) {
            String colorName = popularColorNames != null ? (String)popularColorNames.get(colorHash) : null;
            result.add(new MyCssPropertyValueImpl(new MyPopularColorLookupValue(colorName, colorHash, this.myAllColorKeywordsKnown)));
        }
        ArrayList<CssPropertyValue> arrayList = result;
        if (arrayList == null) {
            CssColorValue.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static Set<String> getPopularColors(PsiElement psiElement) {
        HashSet<String> result = new HashSet<String>();
        HashSet<String> resultLower = new HashSet<String>();
        FileBasedIndex fbIndex = FileBasedIndex.getInstance();
        Collection allCssNames = fbIndex.getAllKeys(CssIndex.CSS_INDEX, psiElement.getProject());
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        GlobalSearchScope scope = module != null ? module.getModuleWithDependenciesScope().uniteWith(module.getModuleContentWithDependenciesScope()) : GlobalSearchScope.projectScope((Project)psiElement.getProject());
        for (String cssName : allCssNames) {
            String color;
            boolean b;
            if (CssIndexValue.keyType(cssName) != CssIndexValue.COLOR || (b = FileBasedIndex.getInstance().processValues(CssIndex.CSS_INDEX, (Object)cssName, null, (file, value) -> value.isEmpty(), scope)) || !resultLower.add(StringUtil.toLowerCase((String)(color = "#" + cssName)))) continue;
            result.add(color);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/table/CssColorValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/table/CssColorValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDynamicVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDynamicVariants";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private class MyCssPropertyValueImpl
    extends CssPropertyValueImpl {
        MyCssPropertyValueImpl(ColorSampleLookupValue color) {
            super(color);
        }

        @Override
        public boolean isValueBelongs(@Nullable PsiElement element) {
            return CssColorValue.this.isValueBelongs(element);
        }
    }

    public static class MyPopularColorLookupValue
    extends ColorSampleLookupValue {
        public MyPopularColorLookupValue(String name, String value, boolean isStandard) {
            super(name, value, isStandard);
        }
    }
}

