/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataWrangler.impl;

import com.intellij.dataWrangler.annotations.ColumnIntent;
import com.intellij.dataWrangler.impl.ui.DWTableDataViewer;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.ResultView;
import com.intellij.database.datagrid.color.ColorLayer;
import com.intellij.database.datagrid.color.GridColorModel;
import com.intellij.database.datagrid.color.GridColorModelImpl;
import com.intellij.database.datagrid.color.TableHeatmapColorLayer;
import com.intellij.database.diff.TableDiffColors;
import com.intellij.database.run.ui.grid.CellAttributesKey;
import com.intellij.database.run.ui.grid.GridMarkupModel;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import java.awt.Rectangle;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0017H\u0016J\u0018\u0010\u001d\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/dataWrangler/impl/DWTableDataViewerImpl;", "Lcom/intellij/dataWrangler/impl/ui/DWTableDataViewer;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "<init>", "(Lcom/intellij/database/datagrid/DataGrid;)V", "tableView", "Lcom/intellij/database/run/ui/table/TableResultView;", "myHighlightings", "", "Lcom/intellij/database/run/ui/grid/GridMarkupModel$Highlighting;", "colorModel", "Lcom/intellij/database/datagrid/color/GridColorModelImpl;", "getColorModel", "()Lcom/intellij/database/datagrid/color/GridColorModelImpl;", "tableHeatmapLayer", "Lcom/intellij/database/datagrid/color/TableHeatmapColorLayer;", "getTableHeatmapLayer", "()Lcom/intellij/database/datagrid/color/TableHeatmapColorLayer;", "currentColorMode", "Lcom/intellij/database/datagrid/color/TableHeatmapColorLayer$ColoringMode;", "getGrid", "setColumnHighlighted", "", "name", "", "intent", "Lcom/intellij/dataWrangler/annotations/ColumnIntent;", "dropColumnHighlights", "getHighlightColorForIntent", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "kotlin.jvm.PlatformType", "intellij.dataWrangler.impl"})
@SourceDebugExtension(value={"SMAP\nDWTableDataViewerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DWTableDataViewerImpl.kt\ncom/intellij/dataWrangler/impl/DWTableDataViewerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1869#2,2:81\n1869#2,2:84\n1#3:83\n*S KotlinDebug\n*F\n+ 1 DWTableDataViewerImpl.kt\ncom/intellij/dataWrangler/impl/DWTableDataViewerImpl\n*L\n30#1:81,2\n60#1:84,2\n*E\n"})
public final class DWTableDataViewerImpl
implements DWTableDataViewer {
    @NotNull
    private final DataGrid grid;
    @NotNull
    private final TableResultView tableView;
    @NotNull
    private List<? extends GridMarkupModel.Highlighting> myHighlightings;
    @Nullable
    private TableHeatmapColorLayer.ColoringMode currentColorMode;

    public DWTableDataViewerImpl(@NotNull DataGrid grid2) {
        Intrinsics.checkNotNullParameter((Object)grid2, (String)"grid");
        this.grid = grid2;
        ResultView resultView = this.grid.getResultView();
        Intrinsics.checkNotNull((Object)resultView, (String)"null cannot be cast to non-null type com.intellij.database.run.ui.table.TableResultView");
        this.tableView = (TableResultView)resultView;
        this.myHighlightings = CollectionsKt.emptyList();
    }

    private final GridColorModelImpl getColorModel() {
        GridColorModel gridColorModel = this.grid.getColorModel();
        return gridColorModel instanceof GridColorModelImpl ? (GridColorModelImpl)gridColorModel : null;
    }

    private final TableHeatmapColorLayer getTableHeatmapLayer() {
        GridColorModelImpl gridColorModelImpl = this.getColorModel();
        ColorLayer colorLayer = gridColorModelImpl != null ? gridColorModelImpl.getLayer(TableHeatmapColorLayer.class) : null;
        return colorLayer instanceof TableHeatmapColorLayer ? (TableHeatmapColorLayer)colorLayer : null;
    }

    @Override
    @NotNull
    public DataGrid getGrid() {
        return this.grid;
    }

    @Override
    public void setColumnHighlighted(@NotNull String name, @NotNull ColumnIntent intent) {
        Object v3;
        Object highlight;
        block5: {
            Object element$iv2;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            Iterable $this$forEach$iv = this.myHighlightings;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                highlight = (GridMarkupModel.Highlighting)element$iv2;
                boolean bl = false;
                this.grid.getMarkupModel().removeHighlighting((GridMarkupModel.Highlighting)highlight);
            }
            this.myHighlightings = CollectionsKt.emptyList();
            if (this.currentColorMode == null) {
                TableHeatmapColorLayer tableHeatmapColorLayer = this.getTableHeatmapLayer();
                this.currentColorMode = tableHeatmapColorLayer != null ? tableHeatmapColorLayer.getColoringMode() : null;
            }
            TableHeatmapColorLayer tableHeatmapColorLayer = this.getTableHeatmapLayer();
            if (tableHeatmapColorLayer != null) {
                tableHeatmapColorLayer.setColoringMode(TableHeatmapColorLayer.ColoringMode.OFF);
            }
            List list = this.grid.getDataHookup().getDataModel().getColumns();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColumns(...)");
            element$iv2 = list;
            highlight = element$iv2.iterator();
            while (highlight.hasNext()) {
                Object bl = highlight.next();
                GridColumn it = (GridColumn)bl;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v3 = bl;
                break block5;
            }
            v3 = null;
        }
        GridColumn gridColumn = v3;
        if (gridColumn == null) {
            return;
        }
        GridColumn column = gridColumn;
        ModelIndexSet modelIndexSet = this.grid.getVisibleRows();
        Intrinsics.checkNotNullExpressionValue((Object)modelIndexSet, (String)"getVisibleRows(...)");
        ModelIndexSet rows = modelIndexSet;
        ModelIndex columnIdx = ModelIndex.forColumn((CoreGrid)((CoreGrid)this.grid), (int)column.getColumnNumber());
        highlight = new ModelIndex[]{columnIdx};
        ModelIndexSet columns = ModelIndexSet.forColumns((GridModel)this.grid.getDataHookup().getDataModel(), (ModelIndex[])highlight);
        TextAttributesKey highlightColor = this.getHighlightColorForIntent(intent);
        CellAttributesKey attributesKey = new CellAttributesKey(highlightColor, false);
        GridMarkupModel.CellHighlighting cellHighlighting = this.grid.getMarkupModel().highlightCells(rows, columns, attributesKey, 1);
        Intrinsics.checkNotNullExpressionValue((Object)cellHighlighting, (String)"highlightCells(...)");
        GridMarkupModel.CellHighlighting cellHighlighting2 = cellHighlighting;
        GridMarkupModel.HeaderHighlighting headerHighlighting = this.grid.getMarkupModel().highlightColumnHeaders(columns, attributesKey, 0);
        Intrinsics.checkNotNullExpressionValue((Object)headerHighlighting, (String)"highlightColumnHeaders(...)");
        GridMarkupModel.HeaderHighlighting headerHighlighting2 = headerHighlighting;
        Object[] objectArray = new GridMarkupModel.Highlighting[]{cellHighlighting2, headerHighlighting2};
        this.myHighlightings = CollectionsKt.listOf((Object[])objectArray);
        Rectangle rect = this.tableView.getCellRect(0, columnIdx.toView((CoreGrid)this.grid).asInteger(), false);
        this.tableView.scrollRectToVisible(rect);
        this.grid.getMainResultViewComponent().repaint();
    }

    @Override
    public void dropColumnHighlights() {
        Iterable $this$forEach$iv = this.myHighlightings;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GridMarkupModel.Highlighting highlight = (GridMarkupModel.Highlighting)element$iv;
            boolean bl = false;
            this.grid.getMarkupModel().removeHighlighting(highlight);
        }
        this.myHighlightings = CollectionsKt.emptyList();
        TableHeatmapColorLayer.ColoringMode coloringMode = this.currentColorMode;
        if (coloringMode != null) {
            TableHeatmapColorLayer.ColoringMode it = coloringMode;
            boolean bl = false;
            TableHeatmapColorLayer tableHeatmapColorLayer = this.getTableHeatmapLayer();
            if (tableHeatmapColorLayer != null) {
                tableHeatmapColorLayer.setColoringMode(it);
            }
        }
        this.currentColorMode = null;
    }

    private final TextAttributesKey getHighlightColorForIntent(ColumnIntent intent) {
        return switch (WhenMappings.$EnumSwitchMapping$0[intent.ordinal()]) {
            case 1 -> TableDiffColors.TDIFF_DELETED;
            case 2 -> TableDiffColors.TDIFF_INSERTED;
            case 3 -> TableDiffColors.TDIFF_MODIFIED;
            case 4 -> TableDiffColors.TDIFF_MODIFIED;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ColumnIntent.values().length];
            try {
                nArray[ColumnIntent.REMOVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColumnIntent.ADD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColumnIntent.CHANGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColumnIntent.REFERENCE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

